#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook nx/nw 94xx System BIOS (68YHV)  - Linux-Based"
BIOS_VERSION="F.14"
FILENAME="sp33630.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o44  )t4   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68YAF   BIN  :E44  P4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  6   d             F  /    I  
     &  o  A  )    %  z
  T
  
      U    y          ?  .          q  i  G    5          s"  m"  !           &       &  %  $  c$  N$  $  5#  /#  !#   }
 }
 }
Z*  A*  !*  *  )  )  )   }
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}
C  rC  AC  ;C  B  I  I  H  F  F  1F  +F  F  V}
&}
}
}
}
}
}
x}
N}
0}
}
}
}
}
}
}
p}
R}
4}
 S  S  S  S  S   ya  &a  a  
a  `  d  d  e    	}
2}
,}
}
    u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3Ðjː
  F  F~ F F^9 uvfv)}fvfvu)~h	h jMRP%Vtj
fvvPB
h	h jN~RPVtj
fvvP
 Ð3f>^  tf6^ 覌f>  tf6 蓌j b	  V  h jh jh j鐃h  h 苒j>bh 蚐~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ?F^v&v&8 uNV  *=p t -d jHH|f6B jRPvkjzRP
jjRPjZRPꈃjJRPڈj:RPʈj	*RP躈j
RP誈j
RP蚈jRP芈j
RPzjqbT-r - @- (FF9F}-^v&&?-t^F&&?/uF ]=sjxtRPja]tjyURP凃ja>V   h	h hn  gvxvuj fh  ! hy
h@f6vfh   hy
h@f| f6vefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRPja]]fh  j Ԉ^ ` ^ ujzMRP݆j`s>R  tG  =]t( !  9  =  A  E  I jJj1fjZ   ujzRPcjZ`
t(b       ؎f&fjxRPj`>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uH>T  u	>L   >L   >\ u3T Ht	HtHt8j ]uwjJulj?jA.>\ u?T Ht
HtHtHtIjj OȐju+jRP3jT HHtH
>T  t7>N  t0f|A  h|h|j苁
> tjJRPڄ>J  t
j ^Ot  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uwG4(~ tfj fj G0F   =HtkI-
 -!- - - 
tFfA> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj Cd   F >J  t@Kt B= M- K- '-M- 0- )fjA>J  tzj \^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j襄}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFP/ff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPyfvFPfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;FvfvWFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPtWFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP豄
k3ÐSfv
 ÐT  Vfh  P FP߄f|K  Fhh|h|j䁃> t3^ÐFP^{BFVh	h FPJRPhzh	h fv.RPhd zfvhd Rz ^Ð  F@Fy
|"~FFhh|h|j:}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ Uu*u%f6vfh  f6^ ^= uv&G
 tf6v\놐f6v\?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP	
fh   vfh`  j f6^ ~@v>  WV	~ľ" f~ th	h FPZx~qFPu3^_h	h hd [vxvtj ff-   fPf6vz
f6vjFPy
f6v|j ff-    fPf6vy
f6vjFP]y
f6vb|~ uo~|ij ff-  fPf6vy
uLf6vjFPy
f6v|F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vzYFPhf6v]Y ^_Ð~ fh  h	h hd Zvxvcfp    	prff9psTf6vfh  f6^ Y= Yv&G
 Lfh   f6pfh  `f6^ %*t"f6vXfh  `^^_Ðfh   vfh`  j f6^ }
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP~
<F> tjJj1j f6 ~jh	h(      RP6~
6 hy
h@     RP~
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|jt
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   h!NNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jz> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|jy> tjk\RPv  fh  ! hy
h@O|j3RPYF  @ +FHuF F^
&@VxR&*RhRj*YF 9F}j >~Ĉf<t<uh	h2 XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRP vjJ`RPu3ø VxR&RhRjYh4XtwupÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RP9LFVfFf  fP!L;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  f|

 hh|h|jv> u0>} u)6~fv5K6fFf   fPK^_ÐfF    fFffFȸ	~4 fffFfFfFfFf-   f;FvfvJFVِf~qhXku2f+fFfFf~svBPƋVFVRPfJِ^_   jF "hRj
GVj[RPGUFF*;s6Pj:RP&UF*P4uVxR&
R뫐VxR&
RhRj
Uj|RPurju,jCRPYrjDRPIr>J  tVhhd jRPTÐ  F=fh  Qhh?t"jMQRPqjNARPqj{/RPqfh  ujEF 
jRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPSj F*P{u>X Xt	>X YvjKyRPh	h> _SjLcRPh	hD IS>J  /t~ h	h2  SF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPRj F*PlujzRPh	hH hhd j_RPKRj[ORPjZERPh	hN +RÐ  :l1fh hht"jMRPojNRP{oj{RPiofh  ujEF  jRPh	hH QF~  FF*;s>  u+ҊN*+= utԊF*PjURPAQjF*P%u>X Xt	>X YvjK#RPh	h> 	QjL
RPh	hD P>J  t~ F 8VxR&
RhRj
QF~sF F FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RRP>PjF*P"uj0RPh	hH  hhd j RPPj[RPjZRPh	hN OÐ  F >\ ut~ th	hV h	hb FP*ih	h FPLFVu3vPfh  f6^ xL= s^&G
 tF  fvLKO>\ u~ t	h	hn h	hz FPhh	h FPLFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPUCȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP0C  F /u3tF f6^ FPu1F~rh	h h	hV JFVtvPfh  f6^ ML= s^&G
 tF  fvI~ ujRPMh	hV j!RPMF*  F u3A.tt~ th	hV FPfj"h	hb FPfj#JRPFPfh	h FP JFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$RPL0F~  F ohRj
MF  hRj MFj$;F~VxR& R܊F*PjsRP_Lf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%RPL~ u~ tjjRPKF  F f6^ FP%/~uPh	h h	hV HFVu3vPfh  f6^ I= s^&G
 tF  fv`GFÐUf6^ FP/Ð  F u3F F~s7F*Pj:RP&Kf6^ FP{=uh	h2 Kh	h h	hn GFVtvPfh   f6^ >I= s^&G
 tF  fvFVxR&
R
hRj
KF hRj sKFj N*;~VxR& RՐVxR&
RhRj
'K~ uj5RP!Jh	hn j!RP	JF*  F u3At~ th	hn FPMcj"h	hz FP8cj#RPFP#ch	h FPzFFVtvPfh   f6^ uF= s^&G
 tF  fvIE~  j$YRPEI:EF phRj
JF  hRj JFj$T;F~VxR& R܊F*PjRPHf6^ FP
;FF~s#~ t~ uVwR&
Rt~ tFPFPj%RP}H~ u~ tjjqRP]HF  F f6^ FP:u3À~uLh	h h	hn EFVtvPfh   f6^ nF= s^&G
 tF  fvCFÐUf6^ FP:ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S[c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPlbFPNQVRh	h fvbvvvh	h FP3bFPFPm]ÐUvދRP]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfv\FN^v&8 t&@ ^fj <fh  vfh   !j݃RPf6B \*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0%݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0ۃFVRPZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvjكFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
X
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7؃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w׃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0уRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &pуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0΃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFPY"ÐFP>\ u*!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà ȢhDAht<thDAhِ != t= ut uу>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShBhR*F*PʃuFL| j hBhR jvʃ]FUtKjXʃhy
hd j hjlfj hG=thBhREtÐhy
hhy
h~&Ð&ÐU~ u hy
hjhHhy
hjh7F  F~ ujFÐF Df>   F{ j hChfh  >˃uF  F+uF~  ~1 F  F*@N*1 j hChFff   ffffN*+;|;s9 u(jSffYffffN*+ = utj F*Pyʃr>X Xt	>X Y6fj hF~.F 1 j hChF HFff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ 'ڃF*@N*1 j hChE>  u+ff   ffffN*+ = uFj F*P[Ƀ2~ fj hF
  fh  Ƀhy
hd fh  ȃt"hy
hhy
h幃t"fj hEfj hn
=uhhCht!hChtTfj hU~ u hy
hjhhy
hjhF  F~ ujFÐF Df>   F{ j hFhfh ȃuF  FuF~  ~s1 F  Fff   ffffN*+;|;sF*@N*1 ShFh0>  u)ff   ffffN*+ = utjF*PHǃq>X Xt	>X Y5fj hfF~.F 1 F 5Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ ׃F*@N*1 j hFh)jF*Pqƃh~ fj hF#  fh -ƃhy
hd fh ƃt"hy
hhy
ht"fj hEfj hn#=uhFht!hFhtjfj hÃ>J  tj htt t   1 ~ ujރFÐF Dj ԃud j hIh$tF F~s3c F*1 j hIh$FPuFA j hIh$he>\ utTtMztFj t:hFhIfj hn=thIh$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j hJhBFPuF<A j hJhBh또>\ ut>t7j hj }fj h=thJhBtÐ  Z1 ~ uj܃FÐj҃uÐF DTd j hKh`tF F~s3Tj F*1 Zj hKh`FPuFZA j hKh`hc>\ utTtMtFjt:hFh	gfj hn=thKh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPtFPhy
hՃ~ th	hDh	hPFP3h	h FPUFVu3vPfh0  FPLfv4FPhy
hqո U<ՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H4hLӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhT  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAhуfh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhJуm$PÐUj
0ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
~ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h=σÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hW̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̃fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth 
Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPTtFPhy
hgȃ~ th	h\h	hhFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhy
hǸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..qcf^gef[UfS..qcf^gef[UfS..qcf^gfeff[UPfS..qcf^Fgef[XUPfS..qcf^Fgef[XUfPfS..qcf^fFgfef[fX                           UfPS^tf3ffqc  f.c.c "  u  $" u [fX 0!<s3P˿y
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666QP.eظ eP.eۚj  y>	uXP 
 Py
 5! %d!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.|Vuxyyy{|w{{{{yx
x{{ru{x{{w{{zuRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }}}}~"~K~}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.2}V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33By
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3y
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![#%!uslkʻ 

FV]U- .8tK
I	]PPR.e؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUy
ء
F
F]XSQRy
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.eۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uTtT^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              y
              4.69  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This is an older version of BIOS which is not compatible with your system configuration BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                      MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) E  + , B  . / H  \ ] I a b VJ e f 8K h i 8L '  y
 `  y
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d					$		^														

	&
	F
	Z
	n
	~
	
	
	
	
	
	(		>	Z	|	.			n			6	T	n							(
	V
	
	
	
	
		$	4	                                  E    F    B l by
      C    D    B l y
      G    H    B l y
      K    L    B l y
      M    N    B l y
      Q    R l y
      P    O n y
      I    J    R l (y
      -     1    + o Fy
      V     S n dy
      *    1    ( o |y
      T    U     W   
X   
S m y
      Z    [    Y l y
      0     1    . o y
      _    ^ m  y
      c     1    a o y
      g     1    e o 6y
      j     1    h o Ty
      q    r    s    t     u     p l ry
               e                           _C_FILE_INFO=                                                         y
               
	
\ \                                  [y
  [y
                                                                                                                                                                                                                                                                                                                                                                                                                                             *y
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          fffffff               (((((                  H                                                                                                                                        "                                                     ddd                  rny
y
y
y
y
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                               p   `      POST  f   f.V .X <  
 f.d ` j  I     '           POSTF 4`  f f ; ^  .x	 pW
 
 _ 
 _ ` V nx ;  w   F   =  y `^ 'x W Y X   ! " 
# d$ % b& D^' 0( Ј) X* d+ , W- :. -e/ 0 w1 2 3 <4 5 6 @r7 p8 Ō9  : ; 7X< = > ? Ic@ pA 1B C fD E ?<F F<G H R^I !xJ PK #L M ;N _O P ZQ R S nT U 
V cW 0X Y Z [ x\ 	]@^ _ P` Wa ;b wc d Qxe #f ;g f3" f" @ ؠ   ؎  f{  3  3    ] QVW.D? PRNZX+ hX@ .X=X@u
_^rYPSظ hc [X <t
B	PW Ʋf&E1_X  fPfSfQfRfGenu fntel ineIufp%=  rifa2fuYA؀,Uhzbuf0/^0P   t
 p0fZfYf[fUfVfWfQh'rOS  rDM@hf @f  f   gf  P^ s 5MP_f^]UQWfV6  
fvh~uF F 73h{3f^_YH	h r rD(gf 
  #n3fRS B-a&< t2z@fvԹ tNhsHtDs  h{/ 3h(BFv ~&#3
Pf~f#ff   @
>tq  tgfNg A	~tfOF  ΁ ~3
[""3yą(BF{ t~y2h*Ff3ҲZhͻ7FfVFf;Fu-0j43  
 VWRQS:5>P-Ƈ<[YZ_ j<'={PA   0! <" #@ W @W ~@ W g g !g g 0w  w w Aw @ ߇   A 0    }  E  Pg gggDw ww C  ߇B 3P  
g  =S@ c W +&0@
'0!'<"'#' PQRa&F$` hKSZYXSQWa$a$a  h~U h >_Y[2揺 TCA6  @A Q C@@ @;uYð!$p hC6f`  fa.>
h0 c	 oKh

^ < @_WQ{Q@g&gOf&POX[rfX61PsE2hW'_$oh*cN(I1t'Sr3h3Wk~h}VsXh,oߺf hfQy  &  -fc
 1 @tÀtafaGfh+c}}gthԧ_fTDSDh{|< H uV}uu S3 dz%
  % [߸VWWI
$ A-#h*~vuɀ0  ]@@h[蕟su h"C҄,: @p 3ȰS4 @ufP  fXtSESh &cmb!,úv?f`Z'`~'?fqt25M Jqt	f_17G6CqH)fahs%s}  V;  p*' t* 2
4@)6&6a fc  
hgb 
`;a÷PV1X`Q: @ PQ= `t
3 @fYX _Md`ʰEd  POk'"u  = ( l@Et&R uM9NwN%uӃ~ uЋF= wt%   +PUXhϤ#`.>
  	`  a `hbp)t*)u U[Qu StPRf`WP~f.Gp D`H ~ Yf`? f` @TU061?0] @ Ia`  1YSQRf]Wf_Zsf0fV  U   g&a @.fq$<s
h3 p%GP%<@38fi =t
Gj5 sFf	wf>	@z6`e'hԮ ,s($ fޭ޺f^1ThsF s0 hr~f~ h2vr-
wt amsag踝rޟs XE1
Y<QKPP't5<t1xfs@   0@ xÆ"B<[ \ ]^C<` abc dez_  U {2,VW3㬠<9D:
` yf _t`|RFƲpR_hSh_^!Rb"R@ Zt  ZRu  Z-Z @ > {T@ P T h M e M A@ 9 Y .  >n SA ǀA	 >r (
 2` f  +0g_{!g`Q2 P f=!j6|f6 }  3 p0 6>x  .hAPSr $<t4r [X)! Ѝ
h저2 m f`7 V  %3P#h8N"ߑhdbq`|0 &D 3 Pr9heR9&߈D{Ŀ
X"prwFS92廙"D9zi8r89 98r% 98&5&D&EN<9yA	VW `h#
 ߿9uzS9
ﴌ@U:rV:~^ ؐ8!3~3R:O: Q`:f0M}f&@ U$=u&^:f= =u &n:&l:&j:F
, fgh  0 pqr  <ABCDE I@xyz{|}   PiV SC
f
 r&:&:& r
&   3x" :kCfsf5f\ v& V3
Ê^@ ..0t+.FuN.Pp'!g96GX& R0USW! 3fv߿ h㙹  ޿R&_~22ك!IN܀3T
^
u
t_NA&>8_[]f^_"GEWM
) "5! ` PNvEp S\PV&=;u&&0u_&^SH&<#I+&~&p>E&D
mSV h["^[þw`nWfP`v Rȁ  <fX_vrF9=Boot Device Menu  Lo?ading A+/r. . t=  `   N 3uQ.? $<t) \)p Z!0r  ^q1N & 	4Zò Gt
.> t.F10=ROM Based Setup EnterP Q QCV2u#M  Ҁ
a@at2rt*164sW / IQ%R !6fM r? !Pt
(*˧t hB2PXhC#sF12=Ne_tworkr2((Wake On LANAtte7mpt'to(%p  h& t8 *r	 `A'u1+ 1+KA	~/ t,sMsU. T.W.- !.xT`2-1- 7_"ss8.	BIؾMa<^*Pys ͋b8CS֠VRySNaЎNF =a3؁-a?	uCFG?~N0{tGhj7a=arvﱕhr Z^òP*Notebook Hard Drive O`#cal Disk Dock1Mb= Multibay (top)bottom)leftf	Flop;py)USBCD-!G 1
B Superu6ControllerNOIC 123                         dP  	 
@ o
6P T r @Ґprlesctゔ  ͹U8 aond _mo@=the highl@ tp`your cho .  Press3x1bose.Seconds until au;a A defa> start: V!l!(!$P !'";S a;Zip d}D`&Zrv", h2 wv."
00.&eR*" 󵤁  =a3-a؊' tA<v<st1H!& 2俲ؒ2ߍdQ#YAr
 $@y` hB.D!
*F! @F!+jjj(PjߚNA  " ~`D!! }   z>" u "w~ M 2.蔿  t03H!2Ɋ <F8tFn=a $ bPdq0 URVQ`q.,.L.T^Y^Z]S,.F!*[ݡQSVW7 s.t$Q%".<.-00}?@.@хY_^[YDQt! u h = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=Ј
=
tu zw`2҂ XʱpP0
D!!!r
;w2 {`D!JQ1gFYô.*F!<%20}fˀhڑ h΁h7 h#иd hⲦ<u	f  ` f0hrB J סWo rf.>&46fgf&G, @ f   PG0f@G, Ru
hG,f",f_ffP fQpt#QWK2_Yf= TKStfXbco    ? o Nﰆ   ?  @  y]G r "R{@   h{45wg&Fg&Fg&F"tug&F0a 1 2P޾&׎Ǎ~A@rL.7&p 9' ;q = ?-QA6C{?1EH'ϻGH@I( 
VWpL _^QRVT	  r&e^ZY&ffL ]LPp r
YSQ?'݈|\DLQH Yr)&}at&EH'T+ r
W3`$&'c ='UPfSVU_fQW ( K&C' @C$BC$華 rx  q#ȑ# r]"tsrg r7݀ K: k;WQT rQ G1"C""Y_r
E@t:]^f[XQ$C"uV6e73u!#,ABM  f. *PS [XAu.6$*f$ *IDNU.$*SfV0Q`/^31Ýf^[
3u
u rkt!q!} "6W3 h!Q_< a7c7GhU3 .59cf_p`= v[ OQ[ aP hz$@<@XJ;Q FSQRWh["r_ZMP TC r99 r/ uw t t.@XR1$tut0ZSWQR fu
ʀ;gZY_
_*eu}  Ygу< @3ɹ2 uhT{#b)¼ P% = @uX%"4g&E@0RIaX;mWi	t<f_+oH23r H4 0Q\pL# @ {"  	ni d  1 A prtf &r;&n;@ p pp 3fj$BYst$ uf*ڀsC>r; tuc ~rh^
&{; f3C<theN};  Gip2?}4 Q < t&;Gf>&I
3f30 2ɴ*f&r; uf
ffKЊ!<&<&)<fC02<Ï6.><p<fgpRf ufP3ffCf[fKfS܃fF0r0а K I+rߋ:?_f^fZЎsVWϾ u@3~_^ Տ	!BKV 
R3
t<^f~
w/v/f0kd`PfftK@`[0VQWfv hG-F&<F&p & &{P&&0&&&&< ^Uaf   rGt >~`*:u
P0WhYX`aƲ؀óadf]PPRZܐHQ  b߳h{Ҟjjj%jG{ P	dPv hqse
w  hAӣEú   hcip4 h"2sk |  (` t 	2se f?3 ffff>;3fh	 Sg&; 	 f)fw)fr?g&t` b   tHtx3srn;fǂB 0E	d~/uP~/tϲ a	pW;H3tM¡ɤ6]                                                               'Tff.63:3Wu u[rWJrR-rM:3tf݋0fqP| @Wb t#r"t߃ p ; }PJR  ZR 7pf]LCqfUr*6@^  RNZ0rG	0Kuo!!Vg&fFfFf^0ѱe rC\A@3ۿYyP8E tEG SBWAi5m r`5>?3p@ҍtm8lqlZ0hPcݰW rt r
 GC_RZt$֤b$]W  _W sp  a #`P
߰@S P  	ð D v Sذ8 ðe WR	$#
gR'
//(QWjuptPX_Yù
 d htxusz
ՏP .<u.uĀ RRu1R22< u3Z#ȴ$ t	5J  
	:bVf @,`O^hۿàhӫh8$4/ 7ܓGKhruqջv iû V NPQW 0> 3_YX,h4q=J A%h
Ss	QB~ Hð   ! $!f``STPVf@u' tf{` ha60vP<F XSe[`ؾL &>a&DEP&D >Ma_u d! %%j@ t-a}{
 +Ȁ}	 >)a 33S [tS[a> 2[sd3 th݊h܋Ws
JhOaàh;RĈD
ϰ<QDuL
p
E$<u D
@11sd
rSi&pS]@` uL
 6 6a u  u(X6 &
uhP
	\

u   	D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	& ϴ t"& xu	߈\	PS   ? @4P'>*a_3& ?! W>+a	_[XB
wt+# P xt  t  w\DPV!$!"t+h*rs
hF
1o &.@ &o  ~`"hC#r!L	vTt
vC	`WU&@t! $<vJ_`
SQ3  v
p''
u$< t"<u P>ȷXlPRtPЊ FЃ@а8й:bВ7thT^' *#ă@<B4=q4]ZXPz` 22IǿMa&Gt5=a=-atOu:0: u	Et!sE=`: u5 2sds
{t!^& q s  a
׃/ a3Ds{&=  V ?Kbu ?P ^  3f8G0zbf{_ o }0} U!    gb&egWO&MuO O}qfGtM!t$Ot, t"OGro Ǿ`NM0oOg&~b_/` v7۰(5'
!<t2>Er54_k,迷P*`THtX@LDhJ =_7_D D	 d
z=1>bctSvrG&}	r??236t`h"a&EY$f	&M&]aN`~.'`a%# rZ []cϠR0ZW&=w uqF=HNY
h M28h݅P. Rh]+mZ{5̰k_Wfat
q t|VP
 t   U!w#w !#`0|wv
h3 E.-.MZN0CtI! //(rE.58vSd+`T[uA fr@ 0\B   ڋh޲h aW$
{D ho3
hYТ@[X_
`PS@&[X Sϲ
A HWU<vLR
Z,<u(RffWf |,ZJvG! !
u
wߊ 0wS=H
sA  Uу[¡n{$pu 0Go@a  f3Ґfw<z p@`{Ph73۹ F
t):u%RC qD	& h ڿ=a &?	 h=c=a3GaR3  I  -a qSiu@ X [\ rY&N rKŀf?|q p4<t0\(&' t&1o- ח'B
Ɔ_'+QPIrMuRӈߧǆZtpt! g rh@		 & YQ`H?Sp[r%u~% = W0Y!j[f[s`U3-a+6 
HH!׋E&NQE A, Prf>fh_WxfPs  xWV @ƨu$P<PtR>ZR1pFƁ > O6.&ZK 2Z^1 hWV 0  Ph,X@_ 02+
y*2ƀƐ,?!C@?r@Dt㳰5Q0 1u,u1 
@a

+&C323&@t  %
t&
0  5  "   ( ;
u^: >d!	"	? A%o ^a{PRWD&A &]&U  ˀA] _ZX"3һ -wv2C."/#N 3=#h&_ '߸^ Z	^    Ic>u  'SX \ P`NZfCa~[f3fcu 3 Q>`\#:uBE&8Uu8p]
R +B&U
ZK!ؾNZa6fYBP)7%qr h܋  {G;1	't/u=
 춳4Ãh
qmP-
<tpZAێûPV#
E^f  X`ED
BB HA   RSSUf`3؎ FwQP.p ڎfafSfQf.KPf fff#fYf[2VftGf߾   >PIgf;t&fU <	F`$f^`2ۢۈfaf}`S@FfaPP3_X.>@P>+ . ~P	TACO Fr  
!	& .<PLc<F	>P fFf.KP  CPF.OPf.>KP;E.OP  tAPttYpBPtNp  D@SIVfB.f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p <P%f@c .ffHpCfXfQdf33ۃ!u+`s?I
s*"/S"Vf+f;wfff}33RREGPo4^q4'r44$.x71p6ɐp08333Ҹ  QW>^% |F
3}@u'JE.ȩ t0 t  110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^0* uzQ`  &t Y&  
 < tr&\]p &\U&{T 
U `&zNd -a
S &	F& $F^[_F Fx@Zp 0UW(rPVWϋذP6' QaS! _^Y[XWfQS vQ[fbt
  [fY_` t =$PnPu2MرtaPfhT6أ#s } t@( ` j &&EP?SRU@Qj@6^]ZPV` kV@ǌD^Xp~ 
*F
 ' t#cR y`nF  ʯFpKs d3ɻd hKu`<Uuùd `Vh4ﰭd & Xtû   hC& h" PhE^'`X!$!   °rs{ 
ehìB   t't 4  h^c` tKu& &  
  ` h,s@<t<uuТ 
þ0u?1*`P	hB Xh % P '@D[%ys)aPR怺NZXO÷*%#E 1*1U`)t_ZQX`$}  .`G  3`3 jDqp8\ À   ; Z x     0N@`^߃~$bhj1fF3.Z& r 
_0BFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^KہóZ.~r@V» 㐅û_< f ff @fUPyf!N
 ffFf3fvZfFsfBf〹fЬ1 r9pf3ɰǟzfAP  fa}fPVa3v޸rF3X

S,0<	v	,$\.[W D`

Lb f s  f 
T
T p s 	 
Sf_f@s Ўfv[PVZP, P袹:F~ s
uf^fNfV_f)^pPRp*fVA6OF@20h{C@| Ң
 ff  fffffXܽq p  `90^ P9Z_" v / a,P*h{{P, ۸P)9u&ն^t$ hSh7bfPRhzC2R ĺMP  _(Q * 4ff:aD0  %=f3X2St 2MMS[h   hoɀhh,ZZq?pq$ q!H̰Āu!A t0NCðvstut
t<1w(<vvPƲEohrs_0;P&
0
3q 33Ҋ|tW/g.&;u;@.ont)@)hPRtν	؀߾a`2G@t03@ @u  c,[
u93Q2,;8.Np

P0j4rX? 7Qr 3X@{Y8SQ@2P5 &&趿 &0h|C hru}ɰ h#?
t[ Ȱ t
坪ŀv#t̰j,5~-PXv8v&>궸 Ϳ㟸`t`_RP3 u? $høV
#V( G  .>Hc  22hؓ|urum&ua 
wU@c2߶ Q  hcôu= Ct= DQ tY0)衶RY.Hc^Ga1޶P$WSQRo4 @3@-a&}u -~:$ [}#%a߸WaZY[_
U ° Pf^ ]ӡr5r	 
3* OLPH      6dP8;V(6 
u^V- ^"(P*^  2{SP( 22< `2X[Bw  $P?R  Zp?               sfp{F\t /߱d& Xo   fgff+f@fABfLrkr.r^gf+Ff ^0r8[r ~8df~\ rKCdhHCab
fa<d PR 30 ZR" `&?FpKJuhPp*Xh r.>d.dpu 	AѧQRfW.d0h f3f%  ff_ѫXURQSWF^
gF=Fg^ ^0F P^fPgfv
f;v F;F
 g< uYa  < g22 IF t _茥u븱% 8t
` ppPj Ѓ;}
+V 
N JZ=u<N0ﴀ0?_[YZ]`P "&X&`PQp^ kPYPUkPk`W]]]/D              'Dff6f.gu;v` Qx0 >jh *Yj"S?wNQ f&} 'CCKg  r)`Ÿ  j=Y>SLP3rz?[M26$&%<GPXPp	 @uꝾR  β <BMtf3袰P2`@d  !XVrUVWfU؎fO  f]f_efpgfft&fVf( 7 f^3tHtHtuf@@ WvÀgF
fp f+3fGenuuufineIulfnteluc32ہ= w7= wf+tHB,x<w<
r	gf0fP.nt%t0w<wėnf^f^3R=u  @P	sfˀrڋ@<v rsKsrUt f 'u f%A?'u븑'Y=u뷟UfQ g*t`ftp  ffGg:tErIgfY]Y]`b`lf!;gtxg Q4 I 7f8"gYs gfH0\oI!"ffú f@tfHptԀsuf큀( 0    rmHmlm` ! mmm nm.nknÀ:ɰ::Y1&u (yP=<}t	<@tMt# ufff uf́@p tU $3f=@  rf,2us
ws ] ff17;r <% r 1~W3P hoBԀt _@Ḅ h+sOD tr!r	pRW`ZO 3
	xxȎp  .BB <t BB2J &ݾp   8u}!@塷`23Ұ
Shft0`́ y aut0i at]U U[aSR  4h
 h"cZW[`-1~p  h3AS	 h
 "BཀPaԀa$8uXRP<u\ZQrtwvtYu6ѹ }RPwZthU?2j{<U   f@  hcm u
3Ҹ EF]) upQst&,Ⱥ:3 s`% 't
 -f. s URmUfVf!{$: rsNp 7f. fўoof]apf.> sff@fgf0uY*KU q. u, P3	f;0pCpIfޡfgf.#fy9uppfYgw0    /p ;h  PPQ h. ٸ hR0 1  URV3%4@40tj6;߸ hΓ ;
V^BW"/fWi &g 9  f% '"3v #YFfFA^fañhV p @\  ͏
^Ah]3]< 﫾   DTDw R to 0 ȳhް  1   e l ߾( Pb @0 W HL P`A T W Xb, `z
`! p@pؾtx o A0
|\D`QWhT3 ?3_`ء 0 PQ_= `tq @YX pSPr
& p  ff& X[oca"&    ir  x"  J凸O f!QE Sa@. u4/0 a, <t.@l~) tq.ri."D.|u.:DtSIz  wD:r5+^s&v
uAm
cC1%bPQ}63^S
[f -XÑ2
O`2	  "	f\О@0fѰ%  3f3ҧfPaX Aҡh  l0vj  fb #&f
 fa dD 	h73mW"ϻ (;sQSfr?f.z
 
2@׃ȴ	40qޠ
 Q[ffY+vf[Wf+_f߃ t%xH+f@``h0Qؐ- f@rf`0z q_L2_&#y uZ=PrUf%@ uCf* f=`  t0  t( fu{f
1"0"fpha%/$_!"
 \Ƞ\cfFfZ &Ffg&{ txs  @z{f;~t	uɰ&~q|N|V&||RaWfVfPXfXU`r<wؠ.w|U5e_1f&tg&fVA83g&fpfnu=жtsaNu(g&fVPf#"Ȁf+p*)^f^ugPR怺NZX2u  w & P ғXRߋh]+Zt5vmt
t@ Z % r  h>uy ah-3&>`prqrﲁuR zsR#@uthuu	r` 	 Z-jj B6uS`` jFF phVrv+@ `nn=ﺁ ؀>t !$!֚$< uRCpx 
 <u_r<ēƑ	Vhk*#'a&f&أڡ[%(}		䡿"3`A%rU [u ĿTYP='t %
u2Ɋ،P3t<u
< tȵ E$<u&w $tuRVˣL  N L 3NprSCu û` t  P8&[E:u
@j j(ǽ(!!2g(<!1Ằe$ h>u$0;tM$_~q.#K .t4&^ tJr& w 3.\{  ".\H.d nb    W	x .|whI_DuQ&~% t PSXӹ
 ԁ.:t
 ._
vXP%8Xr6%ȸfc4;Ta    PJNL p      QKOMp @Kt  Jt P(.DG~H hõbYh  h3Y h  hAE !EE^  ` f  Hp RdmZ K 
v? %&Tt&<
&=sr&jp$qK{t1]KuB!
U@!i(q " sR$	lPP&` 	3a C 	H m=rr`2pshqvraVRQShؽ|4Th5J2.hD6越8u,2
t&6붊<r@t2 s ޝ[YZ^Sû PhB{X<?tFhe"|e~jjjj PNA &{h[\ hI[$vbwt = ;t= Dt
hcy[w WVS%@a%
詾[@ @v= u"*׿OطhsOtd--BJ=Ot10b@|Af_ rh ȣ^QﶘB @ ߲0dL P5W ?  :J2?=q%A 	
   XOFP kpfǋVW 2_2E߀t2
u
2E O
 r2䕆2&&ߋ&EA &e?
td&E&&E E &E<r&}	r@ VW^2`^2*à
&}vx߶h
qTPRQ3& 
Ь%*t,YZRPSQ Zh?tuƩ	rr P> sQ 6tXoYlw}-G: tVTJ
7*h&&  t8&t'u ⇗,V p6}$`$ " \& && <[@ `dde`P`  XC̪U @?
ڹ 0 .0B B =8uwG` A w; 5䋀w/)@#BS W6Yk"@ @A@ B C    
 dt𻰀&&'蝊<;weϋ  X؊<wM3Q#"XR<  YыȊĴ3ЇуE P\8 E
68u@u<uz`0FVv	2U
v058Vhg}Puk )waf&׋. ."/  &k @ؿ!< uf& bÊ$
B| 7Cu%1uh$Pf  f#f#f#f#f#f#f#QLfPfSfQfRVWh^Lf^Lff
f>mhVmf3f3ɹ fw Fmf0n f+fJm ! K^u*^آ^Ӡ3ہsV4C\` a^_^fZfYf[fX3hI 5U=`2Lߟ揀M0s< |&	3ytwpu4QP V-t
"ARbKBC Kernel: xx.xx
 ` $ pK    t?  .]3۸ 2wҹ5*@HaaÍ6hyh֐VWa19{_^^` h*I(3>hH2M uP$<X)4I)sf @  t<   4 k r	.$<u
 f3hh. 
d]p jJh%D=  tdbw_?s.>Nwfo t@ghGĺC	
q!U2 u@? l > ?]c 3Fd@ e f Fc~ce`@4~e uQ@@9? h#5D
P	hqBFe:Ffu1r,
 hc Fd;   	:  <g hƿtuPhh af`THh֡ou;E#f% PCAXt# Nu	n3%N r0 hfPξ   Fo^P XSĻ  y ,  o   hs,[t(t@_t,i i,>" ' À thtZdúߋw."ڒ**=ED/.pE$q+Ë؀F/VU2NfQa dYF :uE]Àg33tVtst
}t
t
u
2րt#u
tN 3t"FF0u3! :5tFFdz ulm":``F:_ uYeb +u<6FO1 ep0Fff`Gup  @j(j	R2	%aUR7hd2   @1 hA"Z]}ÃpRfB0a$ڃr@"  tۿ3hRQ Q;YsY2蔽$
 !/u$`e|Z0f`  ðXXfIΦ.߀&_f  `D΀h{r
 C ƀu0u.> 2fa
[FRtUqVHh{yk:Zn @Zp to(tq 	.3 u|#[i"ƽg Tsq@u4VfRgfA`hmfJ4< ^f[^8" ۉ\c[߂YhWr vs p١6r!UR 2R s rZQi'VqpX  `.uNҝ-a$<u7 pr& .3 t t@v t`t a%uG 9ި`
`
`
`P` ¨-aYSQ u,SӬ[r&
	!.Y[C<ff<!`00xx00`&19||	>>.w r
 ~_ (r]ˀ?'p &G =`z!<!7'O &$ ʶsC  E 7rB vuzuN D $/u00WfA ;q5F -7fp@V aU쿃fV3vCDPDQƇD 7@f^]&߰໰PPZЂ zwPduXdGd8`@ ___  /./././.$.q/ "  @f%p괛 Dō$~r I FACS 
DBwGP4BHP  309F A!  8  APIChOLm	 GZ			

 		
  ` MCFG<	?TCPA2
PrO A	 O   @( e 'o
 2'A*N     %E  E ("A)EI*RSDT(  (I(X,f`Ȏ؎hTjV hLԟf V ff.ěf<.gf^$f  "gfǆff3.ߛ.ܛݞN~$_f.> `f1F@F f7ḥd{#
3ffgf&f7.>@1Х`M@$f.&F ~ FPTR UR
g&FfyI!NpBpQff0[1(.
,.ݛt~ܛ2Pm6	~(_Nb	܁Sǆِ&  P ?fffcff+f+.)umf62mpi	(2	sYq@T>Edop 0P  Xff- ÁrV3g&fFgpY[tqff=TDSDt; St3Pt+SBSt#f=CIPAtf=PGBDtf=GFCMtf?=APCTt u~Qr< u|pܒ{RfQf̓2 tdpm@߹rUr+_v'; !}rE=Qtg&P
B XfYf8ʀufWfV@f& f~>v0|@)@7f6fP)Ȁ$ 4 
Ȱ 
ff	h⣋p<fhgthn;u3ɚ tQ fPW %fXS_ iDZfPU-ֶ@p*Fue*Xg$   ]i@g& h3u hL7af@X. _nc9700V?Q0Q=pf@0. [&D3fCvCC22CC5ܛݛ ߛo 9YXt ~P h*Ɵ 	@1 JTPdf>AttD` & b#   ifKlD*;ҫRW D ho2̀@ _ZuPSS $PwS7 ux0PfP3s f&L fSbE
L fX `hv" 03f`&?    6Kbu  P  ^OGzbfm3{ pZ䶀   U!   ~b>gb&geE E pu{MPMeGfEtXAt$Ot3 t)O$fM
rρþQpmMe&~bass[U  r.]h.Z$`te    `~ * e`mW ±f
Ph/xD0ؿf(&ttӿ' t u(뭿 e)cP%+zio_VΎގƚ`L ^&Sf`FF  hD uP hVS  $g(U,0w4'8  89FtFfN:F> h;ɀuh(fa`DؿE13ɊMh3t?

h2';r%uacUWF _^Df0GNnNBf.9fu jtc rfQPH_Drf;^uf;Nt;f[t)   
tF~߂U_ DWVf`4
` ˿@S%*$VYyRt }Q`!	Y8g&{HPH `g&@uhfP u	+fX: ht@P@@b
.ZXu .ip 3 @ & .>t= fa^_~.Вf   Q3g&@hNX
YH`g&HhXhuЋPd ݪ+t+Wu+P+ B@t&kPY|RWV^_ )lvwfSq_0~qtA"  u
3   t'gf 1G"cG$L<L }COMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR CLB REFLEX 20241 PCMCIAReflex v.2$cr$HP
  wG@U! ,O@Gd hG`   rLfK sbr>G	 .D!׈G
A"O@.d.D`4f`_ PQWح `0)
G. :uGY.5 _YX8t<t@F 
afW
"
@
B`9g"

2́%Qf_* - ,y+cP`Pߔ_aSh%Dhu=} hH Zu <tPrUr  ЎvVrr^~W  2_s
 D<tJCrE.&=t&؋.uV< ^Lx 
y z {   hAhC| w (ZehcLPt =uW  f   6
h;?f>q tQа.ߑ#湻r<t;`<Y^A~+p _*X$SQWȎ_  <p^ crd~YrS&tM tB&=r6.2থr(r%t&t2_Y[`
׎~؃^ԃ^֋ڃtU.6=N09a 9u;.>' t AJ !&2 i) `j0@雁k2!n3n4n5@o6095Ej6G.6;y rr 
;
rf	B6?c	rNb&at +?(4
	r "	!v6P73b'О@ ; P 6rj&
 v p rTv&rB@r7&}u%&E=uf&EDDpP r0
r 
t BzB
r
 SP '24=@	rl.3&:r_ vp6W Q
rP@ tI	<~ ݸ
=@E
tQ&vB3¥?GYۜJ2>QSVW	'	6	r`(= u< s_2.{
q	%I@PP  r.42x0 w	P_^{[YSQRpCТ8ؾKM t)WW؎В>'>'b?_
˃S3(QY2D5 30 3-W,A.@|_S4,x60 ;^_^Z< ׸
TT ۸,P_`v.5  p ,DPfLFs-<t(<#Ȁ0&Z hL`E^àEPRU32t
t
u
ku
 ur t!;rՀw/tM>ƻ ʇ"SQ X$Y[>"Q;>60I`u 2a=0`*SQY(E;?!eހ	ww]ZE]f``3r&thͻ3,֎fvp\@qgrgf9tЦa D2 *0 th}R1 m@ Vff3u"gf F f !3pf t
@ /0޾S3۹: 8tCýq'P qtrXûfPňf uPPRV
td,.P 0	 & &$ЛTОRu	& 8t.ZPP^ P_   0 ? 0    0   0
  З  0д CR01  _  '  ' s 
 /  $ϩRp   ]	bck$@c$@G k"$Q OM3	'JPS.b޾ӎr\v uTrL07w9q w; =Qw?A1C@E]GH` I5rx35rdxE@&=u%9J;Z=ja?zA]ACfe;rWЅ$^B+q ?D AXQClEջBB
B2C@bNqZp+uk]dn(uIQC!$R0ӆΎރ"r͐Wa ZžDTr eþ[%450
Tb
tV4Rr# t itct  t$1^ ffoL7	] 	K0V0!	RQS
5Z@+0P3r8u_QY_ 0Lr&UA>L`
ƿ
N^2U}O
ދA
Ps
t0<iu,#/+]RS݈|\DL	=(`at /Š03AM5NBB&Gl
\DLjC

ѶCPyX.סI@@H` $2L1nB0<th3H8t8u6
uBp & D?BlTt
߀zaP 03 r/) r%BBn!J@ 
; 05 aù<t

B J 2@u8` BŅI2۬2؇Pu+BTl&2]Q8uC\u rq@m ri~ ra ñ  tAc rF n r:i r5&D?@u-&a$vQ> Yr	2QQi'Y߬B@Aq Br蹐{  	W  @@ `  !f@v  f_f  S3 hvӧtf3a	0P[1f`  t?~ h
ëo tR$DVqWY h"%  '˃( wh薟fa`    ut@u):< ugup	@ ߈ `e3Hrd rπ DƆ  P rZ  s-Z@   p$Wp_߀ uu' 3g rh1 tg	 u%  .|!  ڿfVǠ!&""Y[sf0u.#un̒s3h M̻ G̻> A̻hރP F  ~f`n M t\+sf=R	H N  ? ˻E~ .@t0*@eMF t wƷ  pGN Q|F ~ tn˳	4Rpf^0֞R#TU  {hq h<XXtFE:rq ؋
00޵ D	  A;[t	q= ;t"Se[Suu;KRxSUfa @"fRfȋ³<fZ`SDDajPf` WPf3Q fY`0@ N?  ' 4buLPC:!&= t<R ZM ,r01oVQ&U f
&Y^G@^
Sf"p 	
p
PX:!@7 KH7 ؋ IhZJ#Ss 
0U{p` wH< P -q]ws0uPsu[	¡	1tQZWtg$1DJLP2@ [ fSRWE
zD&kt
 tP _%b#\{	(bffU0:T2Vt`
1e;'''':R? 
"Zt  E'
QV^ f^DOUYA{'o&{.t'H"lty{tKˠ0}`L߄ &zNO[Qjjjj PNAy{VY\ hIb
ZdvjU&F]^#^egFF= <t
ťęMOPcȝa ֓Vh' ߂ p4> 	r
׺	 0cf9Г3@ffj @/f p B'}P{tof  wfa{  0 f  @ 3gfhL6s-Ha# $~ EQ0Sf3CESVY  f
ffK`Pf@&@ ǿCp   q3B`C[ofSfWa  
f_>knq? 1@_f^KE Y s@u}e{%...̀`P t3Qu	  c t .>t*Qw YQP5Y  g $@Q  hfYfXr`!t[u . f u-
upu0sv&CEff PХQp { 
P]譿KMMF弋كt
t " !  댶t phPj wf=  p5 [jh t_c SRKZKdcu1WLMqARLTLP$FLu uLPXKLG32 D C22 ?H20@  @!DQ 
UU              i Ȏ؎6?r'63f<tB>f&f;t	`v3ҋʸE@PW
 
t_   @ك
_XSQW  hoCh _?		[Y
X@`]gY  Yfdg&3 rfTbu!g&Pg& \n1^`aP}ua_ ,V@6   @v
 nc$ńbA\ g.kґ
:8!p Pf% g.mEfg@0S6 O@mDUOD  {  rgD ODB  g  
 8t d dARrrf
QSf	g  su
O@	br	g&Ƈ0%P's ŁR
a-PhGVo6|XPR Z S .> t.Q _.Րaft.pAaɕ0Q!O H C ~0EU{Tf.NÀZ .Lַ h_~f.@P Hf@vfpRpV	ސh;cTLv=fDˀ Zu4 
  <kuq
D.t	j
;v
utiuN֪.ؐ NIqpWv`.VB؁uf@Hq{PQfZfQW 3	}< 	0|09_fYB͘ҮWCUr.
fQr~}~1fvfgfff  hӦD%f_ vύ^Q` 3fff܃YP
SfQf"9Hsf-Hֈ\0DfD Cr"
uf.`` @.) t2@[R BE@fQVff3 3f^fY 3 ~
  +    SETU ˸ @؎  Y r IW@ P& u_SV  GG0G hc ߇   Gu Fu t3  hC) 
hBt & ^[SO
&hz" '[UVW F F@    gx< F`D2ED2E
 2Eށ 2E _ 2    D(2E($
f&EPXuafa!tE/e.a ƅ @<qt	dR>t <tjjjj3qPNA .w_j5Rr$<t.<@t$t = ;t= DP h5   7"FF~ t#^FLr
F FQ  ~ t: ] *f
 h\D2%PkFAc~ t
FK_^Q
hs^Tudu   h~+$?ط hdR"hQ"h(f_01Fh{|2$..]  @Y'` 2WVe1E0PE.WV .^_U (UQSi50'i5(e1E0eEE.U s@ m2a hC3$?eU49$:8a3qr  utw
t1w
tBPSQW33 G&./N_Y[Xõ   sc3@ @   p^ D  /[xsqUmf* %  < ! 1C_  s	x QVWb>u% p u P3  | = <t ;A( _^YqRW0P  Ê %TCrr3ɺ ڑ܋XAB rN _Z1SUEH H)H
VNujvzJ`LJ5; DE<@ ;<<݀!<3Qu KKLt
Lm[VfPfSfQl mf3f3lPllXfffDDG(	Dh fYf[fX^r#0HgO Gox1mQRpA3ۊ9 @q CsuB`sxfDf3ۋfË\` 	
C  T U S V 		-	`h0uh  h h h	 h	 h-	 a1uv.L.< t)F.63.PF.h4Z[+V..^̋] yDF. P .hC҃Xhq ؃04R  16W  0"Xa Y Z #[  
\a a _nBA]a f g'^a b ` `hcij!k qp10G pppQWĀ>t?		 u	?	.G	_7   O 4a9Rһ -w C.=5/2U@0m?n8o7@W3۸ e =_f^߸^6_>QRrPS[XfhI(`fЍ
ha
3     !z     KBC  [( V   Q LGB=   0{+&!	!$03/04/05 Copyright 2003 by Hewlett-Packard mpany D@ !`t` T`  *!'p~}P >"!"!'DTTut0pwt@twt t`A	"@	# d~ Y`DD
=t@@t	0&6t!`#8TDS>0tVqt0"#D@0(tQ	>D	T0'T?@D &
%k"tatt DuaүT$*""#$%%#$"P&dM&&
@%%p$"2` `ЂЃ| u u3 2a!Txu. B/q >$4 `Op" P{ Y T {Y(
"  "tz|}~ }䓣𣮟
!`@ -"Cp`t   +,-.00..--p,,++  @p," ~}|}>p"{ z}!tu r$} |tl$h%P '%($('&G"!&3&P9@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PT~P%&$ |Q
0%
,Q
@C!D @T((s~1 8 
BO0 Qp" qt~ 33BO]pNIA,=#;". #߭"!aq ?"QUT8"uPu4"%$q4,tʎ"0"
pXp"0"_d   \5tUtV`]5"++/ÞP.%@^ Sp`A [T߀͹m{ +u.!-..3-N`I0
,3 {
	,}BSe,`C"d`"7:rb8"ps        	/ ;$w   06/16zT907/28/06 kAngel  {4{{.@RaR"x#TYT0	T@ 
t/{3") :xiv$))ÔdPx>0WG))"""d""S2gx xb} Quu) u	`	[[@)!T$3TD ȃ@VF @~`T?0	TP``T%`@@ałŃ 瀾xD¯23uw?ү bn23"xt}
~"xavvuu@mx!Du*u+u,) + 5FXGyuu!үx0PPp}Dxi``
$`$p

]x g
Ux1x txDESxxxxkoD@@._}}@ v o ;}d`xGBFC&ax}DoౌJ¯00xtxtyuu*N}m`}ts ,{a,+b(xooD0P1^Z px^Dx_T_xcDxfTi p# * -b5U
,&0#@"@G	Tx"b3
x4T02`w2} Q!T`^ `y  %P"	pT`#9 r*r0<Pg	mP	R<GQ#!
¯-u-${4?i|T-}'-fp (--Ô@_.p,
 
0%?
3
vp8b".`_02}/W0@ 12`(" "-?x'q-ȓx_`t ?">}
P}
  !	 @}A@
xнxt"xh}A!}D1" + 0}=
[Z#tr,F00x )xm`xn  pP0S-;/TB-x-¯0*@0b 9P4.}-20BZ-`xO.	- xTx k!
-:DT~rK:PF y-P>

Cp\Tdp-$!$LP--` 8`QfPÔ2@htx0  xx7x8r x00:`>%U0> BTߐI`	p!6Ur;@8HZZ10f+5@?i 	02aa_"ZZt# pO1[x,0X4xtx0x,QB@SF0xT?Tx*[-tx+r\ZtPATI rY"^O^^OP"ݠlR
,qcWp`a!puxd_HNH0= >
  _`[>gxhpbc	?;[	Pf pUP@*AVx-	+_WVNx*WgMx+` APʀ }`V0ʀ 
ueU`
`VWTT1u 0Y5 pV0j H_[ Y\NS\1az 0/  	[}\?]n0^1^1^aY a]'^_rc`	`T=V`R"_q	`A}@ A}= #-/   1798A~l B~n0=A~m uuҌВ"ǌ#9x'D
^ 39d`!9m33TT?O C`49`'`2`=`HpQxa 6uu?uuqB uu0 uu5ˏO$)))ƨ)pN`0T`
0330ԓ)`DDD"$| }(_xaய"-..E-p
0 -G..- -`x.-0p~!...--xc.."/0@T0cP7w4Ѵt
Qt&x&Tpd `+3g33Ô@2?@t#Ҍ(響12mp1l`
12d@T	E4D] 0?/12$" ,xg$-xtc`o3x7;x817tЅo"``3_^c:dq"xe_bcx, F  2=38H7i> 9 ./01+456-Z_d  @   !"%&'(]bgl@W[`ej`; y	
{ :  pqx
L  , v\af  s#t$uG)kch<VQPJ~|?~|};XoU2Kd	
!$(+.2     & % . 6 = > E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 
B K L RZ  a  " ! * 2 1
A I J Q Y  ? ) ?>!C g d  FApqIkli/ur}z'tw l k i h Ju s r p : t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "':x4D@ TP` D`(Yёű2tx1tI,'u\0'A'xuvv 'xukf\GWxw$% & & #2x1 	ү  ¯0 p%#@Kp3$b0#	Mx3G
r fJ"xvOF`X  p$" '	x30%0&<T`P$"xwcfp
0#%""tX.4} 
xw$3z 
`Hpx`p$W$ ywp°Pxsv"x0	D0$$6Ӕ@TxyD?"04h9xOqx@ DT 0
9 dlB"pxy1xzx"xyxxzxx	"x|#x{6P}y{x|f`ӀpUx| Q0wk2B|@
"20"02Ku2[ [u2K0" 
2~[bT%M:,KiXwY8[Fn?  |~
0"HD =16/(!a0"0
	20"dKp$!03¯p9-x-u T!""5673/:NP"o5756!_Q0"0"xso`xeT`Q~^xrsv`@)+r!3}TOp0@0 0 
P:AK /]P'2BP;)?P`ӀcA"?@ "0a T?4u$B40@S0"{z}yH439ſA
uA @+
`A?0A?0?@4$MCh'Ô@)_p4AҢ

$Y	0
	L@À{0-$`
$`$p"aބ"V4#@/ I:0!@À-0
\   s	!'4@0"
4xsfKt0*4d?|p0@SH{zy ! xtvJ-%_`gK@P2 ( 	4    u"H	5567q3`	t%7746r	@ :0	h0"0@`	4[A0 Lr@1 
 !
 +90 B @, 
j6	" "!`BQ
p0( @g" ^ @
-NU
]D7U @.
j'	/40"G+6H,,f-e4pO7)0	L[P85p
b3^&05	c	0
S ":"088;tfpO:2`"/c)P3
~Cxr`qe`?0}Dp h.{bg."a.a b}iA!"6xMNOpxD Te6`^}V Vp0
T6d`#"6#p~}i6zxd@5 0
5 #ѐ`5`5$`j$`6$p$$`>$`$`.2%$`p q?T%%0𖶓 DQpAh0TxߚvSۀKv`@9w06%: j`@`Dx9@[50p	5^LP Cp c	`r搬?&7¯3`yҀ@
 pTU`xo  O.*N .xv
xD}S&50{ ^`
}mT?Dt䀑PtYTˤ{S#@-`T`Q	09:9$``$pa1e:`tg:r))(*)б0'0*a a
Td`x0dp#  xF PTÔP
@*NxFttxBBzxNUN{}wxJqJp<=>t/??)x ү!<%${t?t?=2)0 )?$Px`vT"` 2'>x"3y!<= 0) =<@ p0 xvs8xV:8}'p p 9  %98(9  ""::Ô@ p/pP(q  /..d`
&~Gr7(ϻTP5O( 4 ۈ4040f`P675``/`@$p76:$I&du*);[P [x 
53oppGҽ+L2*>gp1  ';aP"T~ ,}?T#@үd`pxH m8@22P65b3e1@dq@
3/ 
m
@d,2xA%50 B3
@
 wv`00
TDT@5q0	 5:@a AP}Rt
 u4P4btl#,.
@	 _ r3l0dpe`5ߴ2qDxF105@2`e bC7xnu50 0u5r4+l(t3345#.3}p<0 $5#4  a<2 }G
3pAR ErpM{"p  d-u*x0?.u`2:.]4 2UU015-ۭ.* 2732pha.
$, O!% *R߀5 
Q'x`S-0	-a֓} ғ/R	--`@?@`p7v@}	 `@~"A0|!T``!&_` VWy
7pDxp.LDy?N%@k5߃5Eop;OCDw-qXTQQu:95:o !p	S51B5dUA`hy%%Ovt2QON@pHR/ N9
d.0
`0;X6Fp0 X-64F0572`5#O22]c6e`	S8@3
!b-?3ÀI%P/;_u3
p< u33QV+C{p4z5z5
3z+,yuv {| A`290 & nPkT0 ,	al:5pd010 upo6o.//{0rpFB}}0
P/0/rdct%.@f Wu tq70YS 8S;"W4`p1BŐ}?BT__0=_<I?`$:<p:T0Oő9]:e`pYלBxkTAx`R%dez0  :9>P$3q"WP¥A3	``uqq
r	1Q`{0[
}
9ȷrdP;$$P8"{ 2F}R&e'AChS4Iq}va X@apR`pLxpG3p?$u]1U^#5_`@TU`#v0e|T kx{}Pxzp Vxy T{xxPUxwQxv0Gxuxqxtxexs`xrxqxxpx`x|P{x{`Vxzzy@UxxRxw Gxvxqxup&xtPxsxrxxqxxp"pxov00,pTxkLү4" .4]o0.^TxkQ{k/`yp0P .^ ##////i C?".u1234B2T/43Կ^ L. 0 'q.Đ1$L7.T{AO/0`۷pGRQN0E0O.JP72pg0Y)R)y70h
P5
PIs|?`d\7]}SPn.rtar4N:0 `a32Е
p1
P

Q "u/ 09r"l  _}.n1vg8ح. : A3002az0pM=1s0D@dT:0u`z^P;DS.c.u0B0` +2 p0Ⱦ`u0Ta1lC
0%TOлQN]03p	 `` 9b  :$ :/>)NӔ@6S ? x0!  x5E0Qq7prrqxv(WUP	Xu

		0
 p`}
7P"q ֓
G1opWTrAL`>M~)80.?T`@}w}S?AP33TBDWD  Axo8"It/C9x;VxFdҢX`Tk`HT
xPM>@nC!3"x*_"Y\]=@0Qqڢ97F 03ct{v`
pYr *J(?( (BP_\P` qw0P `	qPa"RS;.eB"{TSER Є15n`=;=	A=	aYpo0:BP e0!JI$:1PJ1銰,F;KF4	D0c
^"CO`@?"LMOv30aA!Md/p`w@0tt A2bMBZN``NMxsvLM<$"xFIxGJxEKxFt@0) JT.`xJJ0xK@Ft")"Jw? 0 K=8"xB!C!A!B/)BF*( #NA
OA
MA
N/I
N+)D
JaKJaIaJ/iJK
I
cN{OPQd`NPJMT&` v0uO O@ 
?QPtS Q@LON}m}t}}{EAMI"00C_ Ô@""?  "xj?· ?""XxDoTpXAap @"w $0+HX;fD}@>qTTJE}Rp*Y~AOAIA=A'AA@@@@@@@@@~@v@b  A[BQJJ" &dfr! ?t"xfq o "BpD)6	RR#q*! * 	A]v _BqZ`R [Z$`RB%b ?$BTYӔ@Y1OǯY0	xsZÀӒ!}aAY`#`5`2$pCxGD4SS [CxeYYT^xrs)))& N)Yq 
xn0x GÔ@π<PT)xnCmӔ@)`Bzg))r
T"  PtnxjPev+xrv2P8Put04}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFT_ATUBRBAD
@B;o*F?0$0!DP9}Eb ${F0Y`Yd`*uYrCDDDDDDEEE+E7EJEUEdEsE{E@CEbBD $PstRB'
pEB.a1F
 mpT g Dߗ@$MPN7 q&T #FC7`V2x['GAS
ha?`YÏPB`9O0D=Dd
`#p`(`0<`PdP`d`YݎuY0BPRrװˌt ώtd	SxtxxWtxXtx\x]txat"xbtxJxFxBxtx( xx%tp&x)t xxxxxxtxtxtxx#x;x:Q> x=q@tI= 	Qp	0x6txTВu}.xte"Tptx!TTTD?D@xT`
T=TwTT 
TA@TxDpD? =V1D1D1T#
xov0_}Gt U0iQpiViTiP}S;"x0xJw"xl2Ms."B S?/ "?@>"$tT>A$-"T`dÔ
P~0~7%YYpiXX7%XX{ z yX0ﰇH H+H3H4H6H7H8I9I:I;I <  I%@XG Q
 I$`A 91~5HMX& 8 `;cuXuX0X"$`($_`*`-0|/vp4
TmB 0GQb U T"VPX$```$$`(`7`F$cpH\	A_}@
:3
2  *}0`9 `X!'2A``,`003`G`[$ap]Xp_"X  dpF_0$ks  `!DWTwwq2!$ X` Y "U}$pV`PM-Ud``HUxlUÔ PUH<Hq@P
qJPxlv@@KFKFKFKFKSKnKKKKʩKҪKKKKLLULZL_LdLiLnLsLxLLLLLLLLM&  M-0
`2v"xMNO`uV@oVVsx}iA ^ x(  "%:"0V]
V':p;Pҵp|"} HG}U01"uW@	0SWWT
TW0CW`} 0P 0@4xetlvaQP0@oxTxoD0FxˏHxvbx"x@$xx"x`}K}IFU	
Q@PM~0""3HjxX| } ~ J\4ߏU`*O- QVV &O-MP((sMMNNNNNNMMMMNMNSN`NNNOO.?Aÿ`P/UI."T? } 00xpf"aPWUa J0pV	 50T:uU[0`rP 030)	0PW":CO=
;-!/0Up,"xd_P P0A3"~}i z0?IGV3AP>2Z1gg0MC}Eq@JWC`X .YNZ 7U mT0""Α0O 0#0xD TAxЏm!1?xxmvAIn0T6 AA=B 13u54}'  $53T5544@"O0  "(W "  k p}"1*NP#21Ô 1pC2S22PE22000"
Axp0 " xƠ0p25678&8@"(t?6t 5x658R7U8B eexQxQD{QxQ  09Ԟ>x@T`[nT }CTQCQQRRz4 S'SSSSS>x
23!x
tP2P
32Px
  x
Q{Px
! %>0$t $T &Qxx	}XBxw0xw{P0 p%@$X$Pxxw@`O1 @	_܏4_./1u70p0=TmWү0$`&ppAPw}! f `yP0uBx0/.1]>
&xxxӔ@v%)xwvywxxP  @'0 	b>
`Lxv >txQ`r
paP!0	-xx
xB"x	0>T)`6P$# p 0> e2`TG TNTXTbTiTuTU!	UR
  U{}`xkD̴ D@2A"xDcV$P``30TOX`Y  ,D"{:5T`iO`/AE@E +@@jCEt7Um O@` { 33TO"B $@ x200f"`=!ğ`p}T``8 -5..F_5
S.  9S.`xivS. ?S.."-.10-V PVx	` }"yNJVu2 u345xj`-50(Ӕ
P!P45	D5E4NY4SS0S5u4 u64U25U3Np3%3232666P-7xp7x	632	^`_
77-Ӕ@xtA1 Y.>2c
`/p22Ӕ@:} 0-	`	PW{WWWWXX7XRXbXpX~XXXX$X%X&Y +Y,Y-  Y -`:S	Y xu1@xEP_/0_P
0˅/ ^	
x3 t?e0pt Se/0` q	#qQ2q"	`pEx@n}}ǉt*`
+.!  2#@t`w]-QivP  q} pQ t u vAO}	}50R)1`q`_y"W0 .-"`P|ZP@YYYYYYYY	YYYYYYZZ	Z&ZrZ3Z  Z0_Z̠_s  S1
tt)Tu}#	
Ypu& yD pTӮyU WT0BU
":pĴP^`p' ,`QT]P  rgZ`!L0dGNt(Di4rOBksQ
xbn)S@`DA,T
qMC#_ "gD `E - g`/d`+d`&t .ō`ȓ]`Ӕ@"@//\0t %/Ue0`0>//Ô@qG\o[\`to0`:_1U0`"U1`"".1bÔ@ɲ%O
	"P@\x&! S2C2x2
qx3tpG2x| D* 73"u-$?T"x!}1"7}89x d 	99p8980@7$7PPƯ7 B0Ώ464   `" g]p4@];]<]=]>]V]W]wf]hs]t]v]a   jps"xp02h!"02PTR1H:>\$ؔ U%E 0k55%$ڑa^e4pL2660"0526d	p*6
6 zra
sv"Ô
@7"6!fA6$`$`.$`6`G$WpWAP C02B_QR"	z163Q4AA`Ng6p-
&

D"_""! p $1_̐_.2_F_X_]_b_z___0"a/u<u4#wu42ru4!m0"t@U18u43/u4=1
A+4"010"x%0T~t@"Ô@P@@-	Tp:"P Ox6~ 5G "pܐ}t0	}{`x0x!TT`D%))ƨ)0
 T!D`!T)21 5GxDqR  m"@!x  	xӀ@ P"x;I"Dx;" 304^3 /Yx<S0Qe 4/3"0/A~ o`"PbT/"/0@03a@ { LЬ100@@"01xD"  sfc	Q
VW
MNOPb=>C	D
WX~`!bP^`_g"
% 2>xF`7w0x- -dxϜx0qc q-`[`C02+xT >D } 20|@#{ DT`y  `!TT`B0	>#1 cS 
0cx@e```9`B$cxv  ,z q DxT"ҎxStTTHb
-xS-<x.>.$``$p#-pxSwx-	x0>02^
~
0b90~"/0@/Ӕ@	}/K/$~` $ PlcbKdddd2d9dA 2dC0` }0  @PZ`@k%7pT lr0t04qu0l00i d@	P/!p} 2} 0@jCO@gɏoC0c0  fdh[fduŃ%Ńsf'@ ? ? ? ? ? ? ? ?  ? ? ? ? ? ? ? ? frf{ffff0T0
 8?g0!$6"dPgaQ6b0W2@ '  xp00Tp'j0vPS4i 0\&0&{X{ -8&Mont$>ӛP	  >͞ 0|Ý@ӛ@*PABCu t{;>t" MG=Nv"xIr" 	123456u72u<$t}5}@ߣ1phhքi#i=iTikiiiiijjj+j+jNjNjqkkk@k@kckckklllBlBlelellllllm5m5mRmRmumummmmmmmmnnnnn3n3  ni~V0v pC51}uA uB uC5{g6nT758b~ 8` @R5`u5pwuuAuB}uC{xu{u{X$:ABC{&7UhgR2pO + U'h)gU

-X><*050^E` } P0C5+1!~ .`| }` @^_N0"`"!"H
$*
#5'((INp:Id @(h
cC 003{Q 7'U+'(.))UX0,/,2U8.17.4h03g0o.|U_3O4rP@AA$__TW}&A3 u4d`
U'XA=9=U'XEUFxBwBHU˨DD(KFFSoѪHH#MPU8P!}UBfP"I1"UÔ@u511ZC6"$y` !SPkqp" ? "DE~R`jood$лoA`T}&E`##xxD}}_X} Y  Zxu1FFxxPF/LQA0%70$"Ep
  0&@EOr+ 	 	Y		Z* 
 
[
Fxx		00">?@x>TA0Q
3AT> !BC`RpPCוB I IPw0Ap¢`"0An } P' A@
఑| $ >>?@hc\0
0odn Ep6R}m`~T }"uP p#@!t\}%STTs0Xt
"DvбЀ_t5  QP$i^=-~`y--/"2yu3u4}u5ƀ2Тr+Eɫ345 Сr+T?T?`` %%O9pt2`	"35$541~pV2}sTD kt @A?31"~T_"2kPqb}qVP|@&Ip0{.:w @ 
<6thr-rh"6<kP,3s@|,6xiT`q>0>
 5>5'|}pp
"T`<"<"0u4<2{2`~`~^ׇŎ{2ۨTODԿ#3p34e4j*0 $$Qп2= 	5P#oP?0+`
?o`P @n4.PB4&B54p0?P`
Rp@P
^5"0xO"̀2<# 0Hu 0;l;829e2`21K>_$Seau2o3 >3TK`J@.N`\QP`=E	Dt/WbCD 0~!  T``Ogc#rƩD
KyOP+@bT7` McMp/"7898E7{`  @" p9'`uN` "Ke9`}R78Z8p7n`042npo`(}$	4 ӣ{@ xS\2	Pu::
::$";<;p<";<`x!D"p TV676W8_u9}u:W6WwEɫ89:QmwӰHRTNpV``pP6RU Wu7u7O78@
X9BU{7Z7`Ud"W=6F@F6Tñ__GC(u3	0:u2IA?HH*:/qb=e=ÔZ	Eu3yu2D "	BSpu4q@M}}]O~[ y@ӝ@4?u4MÙ@;pY Ӝ@42 0@[!$'Ýt#
JpAZR쁍@'L`3MRx05`	y`2f҄3 Xӟ@<?0?;`@B@	R4}cO"	Qaڶb$U'N\tА$	??P
(F$	U6
??T Lx$x7EyU2ͨ}{zyKGpal~(0|j/)$)|0<<t;u/'P~ @| }` @^/_NǇ/$|tq{~@_aqk{1 pTN`K44tpl!	ÔPtܐ!qo`{`67:;ޓ.@ o;45?5  }((s}N}}}~!~YttZ{ 	{ z y6ođ	!7P6F ,w
UI6pv7\<eL@JA15D#-t~5{u6?`u7 	]6T`pd`!Q?
p0
P!F	ڒ4	uQLB}} pm!b$3kPK`ß
Np&Ft02CIr0'
b89d8pN_9"PnR@Ĝd2/+Vy{e76l`&Iaůr^<)<2D| !5`z {D` @\]L~
W`<===<<=d!Q!d<
=!
@&2nB0|gC' s
Tڤ[c=<&d3^픜P6<02$楓
8 F FP EP{doLp{|tP#I(I#<~I_[8mpl ??\,@7qd?NptOLVKUOKK?UNp7>	r^HQՏo`QppNVSYSSni{P/y'P#vZq/i T2Jf(?i)ikkQmFCoo=J!	q>1s?Mn i`4լQ}lIDLT-K098n0Ö,98v5 ?2pv5kU~@[bƋF{z'y x [6!7A: PzyS:XÔ8@ 77P07H;6=:099(@9 c{
`88ނ`80@q 709BkC
@$}CSuABC{g&02|y"Ϗ4u5s}}@y4Єpњ6 +Ô|@u66$`E b Qc $0~ 4ɾu6x #ux45@dE`T@P*t8u!@pj90Pے
PtPo	9TT Np;[ ! `*:62u6
tu q"[e6`695"u23A`0<Tށ=C}-n`ܐ~Oe~hV-A `P	 Ϗ2!"2p@xp0!Ð}Z}Ð~' ~& Pu334
tϕ33sP`x23{}rX%ÝROCLp N U34+`}t
:0\O2*쌈~0@ :4pPeu4op`8
2y
``ӕ3q0322a`xiT`}$3ßP`$
:"}`q 
"""<}tȰt x 0 Q}
qLP
;e
0:	~STD"LION ~Y 'mp`-͏P YQ)x33$P:>| }d_"_~ K}@P@XP~]4tjP44c"4  ~d4~UX;a;Z <Y>ߔPS@~Wtu6<W643{6``u5Jp[pA_P~\	@yb
5'~cp~ @3P~_" 0~^"12756u7$*``0$pB1}pouB~uC]{po6E`e^{c/Y{20o11uA uB uC51r6"1
`:  "p	` R^[P"1"GRS`@ "0B pc!Q!V]tVbt/ P`pUZ E/ӟ@
/ > e/`P <KAptYX`
Ppۯ/"b13p0-WyxQY. `"q 0ypPsP&qPi &i`\A`[r0/.P[c%.'`-lPW.vt@p.06	b"?!$(pu  h{aZ[hP%g3344"$&`
p:~{k`oj"oT<f@O0h%a	OW"!ih-eskjtg`bST .T Bio`P~ "h0 M
0`2Shqeo`'j`#jp.pA
 dpR~02x D
 6
Sx;pP
 Dl+T<p
~"!Z+~ dGA jÀӲ ޴ 0d"?0Ӏ  "9@`o:` 	@
GD	Ba<rb~,PT i:p\P@}ep :Qe"1Q{"`"`P0C
pAb3
a@0fBdlB~ @0z {`  opn`dx"9.@:uX?`,9bPؠcP d Pn{p	:4gk:$礍";<I>=3?u@<;~nAe<p;lpe>0:<E; `vȡ@~ۀ+P" $Ȁ
r%_Wtt_==Ӕ@`=o@x#q,	= P,Ax@-=땲Q Xp@p > 
?;<0`Ae?p@`p@=@BCuD=?`F  @CCpBCB@;D={=D@	x&T 1"%T~v O:&4o@"`0P"x!To`	TT793o``]3D"GGpx!8@5򒰘K0P*D 0 Dϐ~m#J4`1K Adx'0t"u=2C~F<;<Ku= _`] I I<<;<;@} 78x>H
M  P@b887þ7P	` 
Gy~3IVD+"¯ DK2Q*-.U
.{. -. y- ` T@ QGGʔ_xt
T2xT?T3U6TDx!CD@ p
0g3d[pa5%'55+ 5+!w@
6/W6cqQp(%sq
O[c2*OTg		[etl` E#Aa""	߿F	 >	@2xpzdX LҀƀԀiq3ڀʀ3łŃ 
`	"3/?$ ̈$ P ##EN``#JsB"P""):"P%0 "b``"Τ.` "  )"u/33@p " 3@P"Ø"0	Ý0 䞭ar`_0"ſ(p p8@
!	P	t	1a
b*q2}	1	"/wt 
""̋,a   ͨ-8%`,5P`.9<-5 "BBE"""ЃПP  tsX6 s.ŃŃ+ "%~0)5bp p
s@h`/ߡ:p: $:@~:v:@In: b:V:J:e 1:1,: p:p:f:pf:f:a:#s1u 233ł3ł@03"  Y -x6`4 73@"3@}"u	3@
p<{p:0q:;ɚ:0
<C<"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
     MESSB\5m6]}!O:d>_vI,	]								

$
>
G
L
~







I.)
i




&>Tilps{l1L	)Gh
@Uj+@Pn,t#OV 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
h
R	Rorhi7n: (ABO= 'Ctrl +P=t` Del'p08-1"j: @changed2: r)mB* ne@A P+@*3/: Video	Hֿ-4: rrupfPZ5D_i)8]6_an`!expansb D  TurnB!!"ej0fs}!)b<F?1>: Abr
bARrmal820UPZ mu@P#gi!Dqwaa6#+Bk-(Strg+Untbr,QI n%T@Mf owᳫ$oOp6utom0czb4uqhed: os ToW miuX: Kbyt0Vcksumtj,fauP/Jpku`l cpWNext? EfqttibExPfa Ks/ssaPeAcceP'= p F1~0 0 F2 C S I zB Apinue mpuP}s?  MaianceDb
 uyta6.<wirS us Tmodu+mme$+requires'.  $oc.,d. LBPU7MpibOOay1__2_]re`excee !QԱ@5b1`vCirccuue Undpw lndsy..P؂(. 4dobWee.GS ١nI5c5`^ XInrLShut
downi 0 	-a:Pe Y;PINW: [
] \Nb<1%left+ 0H1HB@6 u`Uρo
v^oax00S,ZbpCer@uSлUe@dLPcuҢchipQ+be TEp퍓JovldNew_ Pԁ*upu'< *Warn0/)fTPMoVc{O2	i8xrevpo aaks,STpa Tmr aI5->rmin[r` c&n>
U0_ >: XX hours a ` @sAAf($EpѪm	hk-.t*G uhSq
IfүkGnow#E%,FsAmj0"jcthXìultI `is.2K.!bAe$=4r"Q du`Rt!>TA n ADrZ
5 aff`Hb^a@)0{ak5xPunusKVPzItmsg'com a2
f@a%greplac2mâ aSF2 _dU`qo!B's TrPlatдm!(A)!:be.Bi2(HXe[C 5A?9aA f P;o takйos]k[ 	Pgt	g/ /S OEM Spec`Wc OmEƟb,dx
NOTE: `BBcBrwitch WARNINGirs#@갇2bYRlo c01@0b
O!;pAencrypqbh!yDoso]ghBhV~applĉ^Hy
 from funr п@4RR 
ERROR -BfБr gonePyjtlUaMaPIHx (MSGIDX)        	 OSBC_BM  p ( d }0    C %   O L Ʀ ҭ V s&  ` B ! B Genuine Intel 
 '"B#@ 'B1 \ w  ^  Π @^` Z    @      >"m2#3/V"aJ<!2!-"B#}2#3/
#32#
3z>"3#* `*@  gwb.A2".@ Ϫ ̀#@` # #	
/bf `((  +*# a@ 
!ϠiAmin"2/a!3d! b2oBcON /""aoAE`#Ufgw'vf	dA !D@@ wfUVfvh!$a"! %#`IWeW
U	v  I+",J	A!/d/L* Cu`
fwUn)@&-?>*eU@TfN7`
E0Ud 
_k:$aLJVeE> v y$w@F 
BDio.FF !W.LAU F@.NtED@y_TQWv`EhT@Y@!	hW@VO[/^          @ > !*gEgTbgy !K<bfW(uO
fW.@$W2ϖO* f T
 Uf!_kq ey!!X"V,NgI%X`GysDBO&na"WM,AGi
"cy o0 _6_84 .Y`1Rb4yn1@Z   OPMk!6URl7}mQ@! x@" UOA}aO B; )oug_ ?tK`+>i@i@`.9 Cx 0DoAb`&cakh-	!vo!uXN^O!#] KdA
#	$A	Ȗg("
f._"%		7@ 5n$oo Dh
1oo7=%SB!(o'!ih@3A4 >%
a@/H@Ip&
> D
;O !8 .E .A'b7B_b/aO&A7iɕ'
]aGB8
$7a8d';# ^@`t2`ƥG%c.%
agFN@Cb!"YbR j!˃R!tUEQED	O@: |`
<_Lfj
`$	_agb^"Zg΄pObN Yྂ20dO] WXf{Pn.E$:hind``s[

'!!wat)!"d>aD2b2d!, _ ~TU e A!N\  @ !U
!Bf .  i @6f@  a BF HaV" ,@ s $ {gJy`uأG`Tbpa!@b`g	J` HaςB
 Ta="B @$a\~ Q( # c`m," " 2̀ }!8 "
d@"  8  L	   @	 OSBI_BM8  p ( d }0    C % N . @" ^C ̤ O ۿ ҿ ʳ   `    Genuine Intel 
 \ ̟  `@  ^@ " 2!Z; #3   ,$1T!4Ft  $xCo8 A
+/`OCo  Aw?q`B A@_ O ?b `4D	)A"
TB	aO@!

\b-_OD$
 Uq. @`	'@
]74`A._3#@ / `C:MB
 /Gv"BD  "  A
WD2 4 132%`3.hB": #"
n_`-%eOl & 
`'@*@BARD 
*с!B+4*i - 
-Q?%#aqAT
 ),AX )Ia/ od`& 5/ot/@B :>Co 2  Aq \/ 9"`i@Bc 1gu= ,J%A
!5"=34('d*8WMTPAS o1       aF3HGw\`[`7!*9߇ K2$hA;"gC bDI*\kCh
20 B$6!(1h
`@ 5:b8LC#	UgF@
!EO[aFWB(E'2K$VEBjD[*m I?F0oc""H[a
U[G s#k`T *`;wdEO] M
a a,[4OKaK   2"(0""ak,Ve
 "$aX o2`C@$"ZT  (\[8a [9]K< 	_q>@I U!PgbKRmQd]g  !.OEG d S@$o f
Pc dO&i
 
K O#EІ!Q 2[`  qoU
	aTWv!" @.B_"O)]	 
#	{ !,f;
%		7 (B1n.oo&DAK!3OPL@B! =oC; oWw{ :A/.@qa1 $0 A;9k $B bQ	a` 6K@@.!E$2A@J	h6 Id6!Q?J @aC:E-$!Фa@[HBDJef QwA
` a\Th¶d@ݯo WJBb^OaWx	
aA ӆ H!(CO ص"" 0/0M"[pYaNUDk0d:$avR!$
 qd^
	z Ayo"Ab9r y{$Cbo`!~ae(t'	 J]>O  
	t`&  s
aFؔ pc!3DAH(@e`+BKK@vT u[@wo# w[b2UT` B3ob#+bVA vNT$@ !D`A6b!@@ZA t`$A! A@ˣ
 "(7@ $c
 G   9(!,.@#0F`Q@ $6 H7`%    
   `	 OSBI_BM  p ( d }0  $ C % e | ˯ Ծ ɥ  Ը    s% `    Celeron(R)  \@   ^`  !\ `3Z"!1	4DZ32 Vf?TXDC _UTR*
 NJ@LjUDg;T ew  WwvwtDEkTDodvW    F m 
DO`t?e_`]eG
e
UI@_R`D@ D gwoTU
O 
_	
UU@G!
Ac
@TDFR O@
`xJUIN_aG Uo guk"f B E!DR!o!T@o@
@	F oTDy]Hw#X 8D()U6#MT4D ,h 'eU )!U@.@- xb
F) ') ) o ) V%X 'o b*d '$` D24@!%V b%o%AJ 2.Y0%a. .
 5"d!:8+ >_`>EF#	
DO_` &
GOI
`?ooPabW@Ua   $/CE8a  C6D "A	A@!"$g:WX>,&&';	 DAQ! "u@1  P'"Q!#-VRB)tQ 2fD*	$.F `/$A2A2HWuNVz ave>RZ       | p&UE2F]Hfnyof*h ]hy2xe"lg"4vy2V*z'&awX0z#zX6Jeq|Q:tvv?a2ߪ
` &
:OA&?egNRY
@*"{A(IVa1(A`^!Zo ._O  \Z	"G2Aw j8	
Y!T@\
b@fh@{os
@N$\"(r~"Km,!S:
" `
 ?2	h   # O8i~<r>jb
P`Rb"@""
"/*+'  eK	!z`
/!`x !'A &a
.!a\@ CP-O `
a  3@ u
B@;BA)b!	 5+ lo
	F- #!%oi
6* L-OO C/,0olC{7B/A8Μ@O!9.${`;AG(k >	= 
(6!9/f$Kd$A 78@[%
@?b)!@"<:A2!6A/HIDJ	 6A7b] 	!4DB(& X^1 `hF%
'd Ei\R *8"Q!
` +*"#!hoXdB_[ B^/Wy4
AQx"BwDO" PZe00M@]B U+ee6d:fC;c7D qd'
 z /c#BD	"`y$ |Aua+?O~($b1`}b_y  ̴ "b&]CL! A4d
t.$, a-#CwF*/(Bx U	 y` "~##7 xA!!D` " H`8bF@	<C$CwA	 #)!
 "+!Y!@  W $" `!B``@!(w@BŪ' #,+`	 $0 H$B`%6n@I &  
  g   	 OSBI_BM
  |p (  b0  	  C %  Ǩ ӯ ٹ  Φt F x. ` j ÒU ɜe    O O O  . "#@B@(gb0:$a&6"Ex&u2 .rO.2T,8(`z#O@2x&
	
 V 	$@:"x'w@ga
K2}8 څ <axJ>c%( ˇBrD!D`
!h *O 
 `a  O}A"!B`  	 [
W@)o C@ W`#	@
@@ ,"A!A'`H/&"x'Q`!"@'V"Yooh`9!"@$&!#C#DOM8(4$ ,!A	!$b
"($ 4-DAO>L/,.!0 7854?4 A`6O_R1!/d=$%:_on$$ 8A>da9M T
 7%%FER ='$:* >.GF	. KK A
U?!.:!6:K/>/ 90T@VOJodt`I ZC-`] KK !/*!3!i`f4@UBB WeB7 ]a`eC@g@"Q `H)
jodABa!tVfo/gDN? r8'fcF"KUO$@a&QQ_@z$4XA]"B_%_Aha6&{ hB0`]jn/$U kq mEaly4paGR0 i`uOH*',{>R tA|`}ҢuOT7yr*Zw;@{u` }B}pdz~ $`_rqkyx KWKap:AxB@ubx k4eF`*0O O O         	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-   >	     	 NVID_BM>	  vp ( x Z0    C % SSS   000  O  !_ x0O  ^ 
 b/
 Ϫ  < LON 
Р"` `  vh
!? 
Ġ`7"b,@M"	,O
,H!	8
!gD d"	.	cOdC$La>/C@C!h
LaD#!~@)>"cӀ/% د)O@'ݠ#ͺ@9<()D!"+,`""#+!? )Ak/.O%dA/
F	`A2 )haAH@/A	
"4,5r߁%,
 91
k`:</ 
!&
 	I7¥ A$`@8%+U7? 49 Ca(
  O% *3"*aH (-(ҀJf$ J@.OVj$I#
I`P!OI <4GLLI 6)C; L?AO
`cRRM`E@XWNj
TbQ`S+Ij
e`  R`0V`/bZ
@_]\aTJC[W<T@Z@M(fW$
LcTe/ 
kN<'na*acT@! pD/!+@#/{&M  /)'O*/S0/3 D	zK      ƶ     VIDEUo  0BIBM~ 761295520C??
D03/29/06,15:23:49   4 GS|<0q M56P PCI_EXPRESS DDR2 
HP AngelFire3.0(EFL80) -P 256M ATOM BIOS 425e?/378m   
YOU HAVE NOT CONNECTED THE POWER CABLE TO R VIDEO@RD.PLEASE REF` 1'GETTING STARGU' FOR PROP HWARE INPLLATION.(C) 1988-2005,I Technologies Inc.  

BK-!VER009.012.00A 7 9432 BR .BIN  164   8670  brhP$  U b20\󰠰pRq   _	  	I> zQ ..fPfQfRfSfUfVfWff2҉ "/0fľ*4tf\fL;u
f^ fN   SfPV> f=	rf f- P  fD^fX[E9 g`..  w ijELP..&fP. 
fXt f.!f_f^f]f[fZfYfXUF f3F03FRӋ4FZ]Ã>& u$.fe @pB  | r~@w@l $ȣllmPMIDbO ߰  ?  pR1f.f*`XE6A2Ct.:&,u$<u W K O JXut % r^uCI@C$< uK	3l 	<u
@^Ff	<u h
N@%Vh	<u=%I
01o
Ff:	fF#
3  .6'	<u8
uǻ * u3ۓN	0$  x
f< F 
uK'T
E3@20&F   蟍w ozF N0uI
/@
?<<<<<uD L"  qd
<u6 3$
PL
Xp  0o
̑!
9j< 
u! Bp#N?	 ¿%	$#L	muC #
'u
 p%@ 
"
 
% a	 
	*,F< p"ua
 GF \[Nu

П-xr[Q
2
tP(p+Nw
$
t 	u_ "<
~< QtU	^3f t߀
  tL
 t
f߁  p:tea
 
 
@	%@Pɀƽ @ @`̀C!V<@!jS؊$̀
"
[ø\؀
ߊ
SWt1	
̽[6B? 231
uM<uKt>"JfȱqppȰIf ;gf   Of0L_0u]SQ   f&JY[kUu@>{N nF ^F. Pwu'	PO u_RQ@@t Y;vȋZ;А G/	`G\!	vWV		b	m 	u+[Ua<^ 
= 
T
iًÀt t f!3c@w Q1
CY<u#Q!& " &鄰"Bm%w<u&\U3\~ U<u/)t
5a1B ߻ 0"<0) uHQL1p. >0~PO?tqyހ  Q_z
C$ з
Gu!Q$ 
tu23t~u%"L$<|0uCiDP VScJ[f%f
Z!eqYn C衚4	uff%{u~\$f
0Ne u$ u	 he߀u5Ѐt
pRt n$
2
οpu01v$ۙoP$eu0gx$I	 谙Du $u
ˋp ptu
#2EF} 2ЍfͲ'u
@w wPH#@0@u&M@&U
@+'
u33u3 u@&%м20Iu$"
t	g˰3\`2pBuKtC;w	aJ+ڋ+;ru;w+Ë+ɿ+Ҹ À UV+rEw;vMx +r @s߁ ؋ʋ3ҿ^]ÓP 7p7XP RfPﴀǡ$ffXZRf  2?Q  Z 躣 Cu詃k ff0 <lf4 P fXf[Z:fkQfPȾMr0fXYRQA.S@@_pf[Y"P{6v>0诡BF
YˀV4YfXPfӷgo\#aa1E F Ð܋ fOf r: 'w K*eDXRhEUz  R8
 ffЊfZ;U@3VV f
@3]`@VV FZ])w	f0.
fT`  0Q..YYÊ $?nQÊ$?1[a}Oq,&CfPS W[j  fX 80q#è9?0&@SP3Ɋϛ X[Z	}f!$f3% @[>٩p-#%:3pBt@(p@ ;0 ?fr=誔
Y qMPA?X`u5f%? u50p%ڌ) OpI``
AU323 #1t
t
|@vt#1u   (-v x'y8i. t 2Pta@t
~`
 0c nŰ蟡 Sp[tQ=Y
Á2Q0Yt'uT,;DvDu|=4v Ý+SQè S| [&
Yt SQ9G	Y [[f% $ kD&  DQt
D
d8_t0tvA |C *IG	5a 1 B,
 t tt*r
ў$ 
  t  Pq 
ʣ


賦
P 
(iVaƧ^VS0[t$ H Tfti uBaБ K*@`>D
ѣF / Df+  e@OFeA`!H	.t(+v )@LLp Et!|		  	D	  R 	&!a!=M7سt@s kW#
^= ޱB iOf &5/ /E A@@ **R0!@OF1!Aא
i
$<NG ;O?
ȃK$N F
& (^tf-) )H)Ŀ)	0lq[P:2 !	23 l		۫9u<F e !5B 8$
guoaP!r6P9u( z5`5ӰP|ZCP5		 5a	`@!6O
P0dC5 4F 2
#P- 
c@-uZ*?Fp#0'@%OS$OA{uDu''
Q  Ó @ap et $
aD?   ! ߦ W33ҋt	@ ӿ-Sn 5^V~" S_PRB$
ZXß [ `ďP"$ `<t$
[X1P }@$0pRR!$<ZS$<uf@3[]%bd a;0	Py	 S 6V ^ !#%x'P*(- 0258Qwt ~  ^u 3U
  I`K"Jn# @`YPQ 2sY6$T)dV3ɠ!ސu$/! g:LT[3t/ tJ
u$<#u 8<2 ,<3u(^ _
P& :Dt LT
^`  @Q Q AA^
1 ~Q Q b # 2 3 W`$hqL ;t	`DP2L^0SQR$ߊȸ ff3fff3fZYif12 ǵ#[2$u	% 8utCK	9pV>@fa^L(| wL|
 wEd(?3Ŕo, {:L.FG|uD+ Pu\[DP
ED(tE EQ  $ۀ  D+
 f1q (0:@t; ? tf@ÊTt\|ޠWt8_@uZVfs-fQņ^Ld\|)?TV^Nv0TA@ fQfȃPP 3Cz`KfX fYKKf۴qN3AC aĂ {Lb0b@(2ccdd d@ . tL u	lSPRb܊ ZX,QR	 pEPTR   +KK;rc2C @`p V> vp  	!  32Ĉ&! ^LC3BBaaĹ opaM S&t
 9 ~ !'"H Ѕ=[M"twW[<V N`+ 1}>(- u7p$PPS,fpg-@@t0SS )QgYQ@[$S}.fM@f:?@2 [$<vTm  t2諏DIxAK SQfVv ^@7p  	0
F  ܃Mp4^pDq~fF f0Ā P	
DpDFDFDFDFDOFF02@M[\! `
蔂 [}@
Nf1"",> UQRA P^f?\8fL 0H 8 fs` `f @~} Fba@r~:F}cDR\L=B F
bJ`"A	fokf`  j N2WN!!fqXf \Rmf   oDRff;r A`!p
 ^z fiBf;}f+_f+qP&Qu\H
1cٱ2;N}A4`d:N~	QeF}@P' t{vA11ً^ /ZY]t+!렛  r0 
pB3ðt[@+*[2FnNF VيfF> ^t!BӞS7<!\4- L^#S6 [gF0p]`*OS]Q4`[0 ;r5P[;rH/_;DHvwЫ @@z  q fЀ{f=  s2ÿQVt9yXtSH& G OtN u
t:du2YemAQ;Lu;T
u53ü@cHSS SK\+[=d$K\
!$L[
D 7}UfWfVfRfSfQ$f <   Rf3p6  \<@W  +X&^\#п0Ż|Q% tEx nA` t;|6 ߋP u& <ufo'f߃˳ @ p \A3<w
`4wXEff  tH3P	2iи`
0xB
 EedNⰹ`PaPwf Qt.3ۊRϖ .ͻ2pf1t	fX۴ 0XffZf^f_]û`/0Mv? tPfY02f}`{Iq"O3uC Y	3Í]`@ʀoPu @<upË2p
`c;<t;$?<;r%+ //R&%Í\~33 t $ tg0O"Ouǀ ÷ 	``lP  
0p
	 w 
     q[q#N 0
 X[<b 8 qKb QH1 < p+F RKc  EsAKH   PRPB X0QRVWP{ Pu
thΰfN i*҃q$`/t{	 PKwSp@(OvK~Q_^ZYø		 =ҋF @	<u2O2TNPou2= NuJ33w"2O@2 2wǲǂ
ˀ
ϋr#t3uҴô$
V\)	^d!$N? 
t$@y$ T @3eRSE|Xu:f ]3Ǿl2tfџft
FE\X^KXQfs.
,FuŽY @@ 6p 	 B pƊHt
;r23Lf^S#SfPQ:ffoYf1$
4fqRRQQ8_YZCBE@SނA-@7ݳ-g蚗[0
76u# mu #2[, )/@u6AsMu)ް2u"_^`%uQRQGpZYp{u#0Ast
2u *u֒$7Y 0`9RQteP
xp2ĿHt`
uK^tu:0ṯ_ t*q@
t KuXu
aqc
u+XR2
K1>r P~pXC޲ QfRWSSQ O$$)۹ O6Y[@uouhuaPu\uT`!auCЋu< u9 Px=uB;pxۋǴ@=P *S+{xڀ,7_eX[_YQ5W
B:@uuu	3_PqupuFudA9{诲u- u&u/uW(PRW  Ў&w&L2  +Ⱦ&&M20&!G&!W2&GFp Fn^ߊD20+`Rr#F#VLu&	0	W_ZP1
	f		t	
$@Ws@+/
E/
MNF N5rO
O
B
 O
!SVpҎq< ts<uX& uL&;Gu)kn߮&G&<	tVlWыD&)G&&@ 0w3K^.R
(&G&Gp& 3Ҡ&T֎ (.	2$r	vLt_suo&4 u!)&Gu&g&W
 G&G42 &W=.1#Ρs
̭^9Z:D(7&4&_
&&\@2; ;D;N;r  X;j;@/3(|@s#%uG<&Df,@<w]2!
.פ:wG&w@( 
	G"}$&G3aa$_!V
|&WA>>O% #12_$ Gp 1/>t8""E0@J#2.J#;vA#2ܭ"3b&$GS$`+bw!
2D
.T2#0 AP"v=l=======SQ< u";@ss_&Dx!\udw_[$<^R^WuHP_"@%O3Fo 3EE-_PB"
0c$>^_9&U&>s&W% D%`w"T=?G+Qm(ͥ".0QsWH	GICA!YqU#{G+B`oPo&_+ b@BPl&!O R*ShTgT9lrq_SPQOPwPO*3h3Y_?30
+ t[, cMW
$p^-2'0XWT<\01Bs0	BdppWЌZЌ
[	,!G fW
0i/5
j" W*2??4	R	`	!	!e7  W(   u#-
oc)7$p'QR

[#p4	0	z0U">"D
	)'D
UQR&\,2՗q3D T+\-^A12D ?TP00\@NL賅@ TW//(.^%׎}\0LQs@8q;Gu
&;W{u[0Z1ruWs3  0Z2OG((,(CUΠƃYF8FfV~?FFCoC&#G#ѣ<P!1?<s&gOB^ҲT($6ZBA!\O0Of]0\&Wt k`e4Fg-k/E#EE+CcnAd\Wb-"s	/K//~<ZZt[<cu3`~f;W
upu#&Gނ0g9Tu"{  s2 ":`g/.@݈G45;t0 q$	.2(qxGX'ʜ0<b"f5/o2ҀJD&W14T2 ~`@W.&P2PG(8`Q [߀,t&:G0uş&= ωw_F_40:200,u ?8 ĆSP* Tր ,u-+*_ߋƋtH؋tÃ pQP΀Q8ٿ؉F`ۉFFǷ f؃? V~fF F  fF  F  F~ V.^2tz&EМXȃ	2&E t3P	tAaQ^&b u!E0v1^ 
P		F2 f  _?fs  r} w^f[uPc
^^t3^&)qF2 Z@~ t2f_ ]P2٘2ɰ@r:W#CcBF! ABċfZ
f_PRWW2+=<<uSSg20˃ӡ ~ SB__d_ ؇fSk2Õ_`FòV\R"-e00</	e@UL3>
%/E%
.룀Rи 怋:v))Z]ˀ]˸Nø#NøIð5ð2ðNQ Q  (@22ð2AðQ "$!&pS4[ð0P<}&p] fPfQfRfSfUfVfW< u< <u%
 P X  <u^_ <   <V <uwNQ <P;~
T <pSP <	u8	w<
u	~ FWc<0@f@T<u
.
UC<2<uHxfV< 
K
	OC
Ff_f^f]f[fZfYfXP.$أllm X?P2=o;uFR_ 5 ]X 01.00 VESA H  aa	 b8P  ? ߃f3f>P" OGOOO "*ptL @ O2 fPG6QW _Y EE@ E@ EE@ fE> jffE(aMEW QlMUEEYQFYc@
?uQ%0. E E!`"#Ep
EE  	+ 
t@E Xt^tw
ppnEW/  j! " ##U2 O	E
t0$?$E w S`3[ȐEE.EE6E E7E!E8E"E9E#E:EE2EE5E4wW_u% <fXC2
 7OÁtC
utO:t/ 
x
$<t~  3Y%33~&J0&&Q ` Pb Ib&L  w& 
1@ 	

   ^S 	 2b kS1۾u'u&$<#u	<2 
<3 0
O øO Qq	Ytr tt:tJrj4:&0:QحtY t. 	( TR
 >`3ۭ1Yt$t(t,t)t&t.P[f Ρ * Œ 0 24  - ÐJtfCm"8!2%XCG	UT	#	&	)	x	@	*ح@	 Ё ' P 뼱	 > O P	f>	м0*m}wf `
ﺁ   uE;}H?>0r;Ј˰?HH踺$u1<u
ˑ먀u(TPˊXP3 ;wX) 
u#sS|$ƺ[  [tRcR= t*@[u`C u 莻W@RSfP? @# 谹fX[ZÜRx R緋ZÀtO fශ0ѻA
$Ȁff	PfD  贺f%f% fXf$qfe ff4a@ ff t  ikjB4 `mU FFIfб	o	f`s-	pf!2ȋ1ȇX>ffq 2҇  tf r
 I@ A0+t
tMN!;A$Y@<00t;gpUP
  `
u ߻fA@:!,:7S/QWg&R D
L.~V`,C@t?ʲ
& G OC ;Lu;T
u ' Q `1jű
t } % KAҸtN D yrE \ut%2Bּ`  -edQ {T&_
B u2
39編 -U+ b	L$ɡ|ߨ tQq@ kѪ ű< QRQ\[ Wff&^_ ߷uM@x'p80<2Sa[qW&EM
ɱ `! Qu12ɨ~` 8П
 覶P \t0buq 턠K˿Ǳ Ͽ`;u!ɀ_ = 	MuAh u	f@² uD 0V» 0) 1 u׵$u@bf uQYbSuh ƭ̹#u(x'u̹2u	̹8u
 ̹6f[jSٹ  8f[ft[r` rBdP?X.].^i^ԓGʔX\e6 'a|]' L&Pѣ;uXú0&G0Ա uI	`EAS"G
[u&.+X&cp nPVXt2S. 3 BiDV{3s3ËF / + W @2
` 02&'C[2&g  {`c	AË#PuwJqt&FмSP2۲ĀgCл@2t	F[720gûg
} 3<Jau $<~$<t <t<t@؁ ð@  'uPàÿ&`P`pЕ    
@b@# 2@3tb
n,tq`qL,tq$SIL2.`e&f[,0(0-0)0*0.0?)0.8%u.]3;u3,uC>t<I @.>"^+3u0 <~73 30 6s1uu  Ӏ 2u4$RP12XZ""c$b25uK<u@ 1$@ 
 u{ݕ15& 0 w&0[ ?PC:0u
u$0<0u  &o6o<uA	ut	
t0
 )<u+V봀1u_
t!QA;?À3u0ހ4u< u!I 
1Ep6u& <t	 @ 먜R=B"
ßó L K@2%@^N   (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   


  a r 
*   **Q p   ?  ??pQ r  @   $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h     1   h1 hm1 P,h     1   h
1 
h
1 
hC( 	 c-'(+ qw Q71;p9  P _O/PU
(
*@   w 0@ T(  \DW  
0 MA](
c 1 p>1  
   
> @_P 0JrI @' 	 
  
`%( (,%*26', 49$,0	
!&.3?+0$8=cd dgc Q K (89:;/<=>?
(  00  0 $0
$
( F 4g8O
8(8`J1Ag8	8fG(<0007( 0o* ,
 4 8@A@@	H8AL8   Lbk
BL
 *H
GTWBkr+_B$f(gCl J+e
 88P$>P˴u@b` c ef;u  : F  P   薷SPȀ>cu/n@ 3ۊP.B.EQ J `+t0 ci<8t<?_t]iBI%@.@*0Q` d `5dk Y @ 3[ 	Q, 0YpX[""` F .n  bnÜ3
pGS G0~~|| |8P8| 8  l  <~<V ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8xl~ @_ `0p{p0o t$ff$8|||
f<<a lllll  l ~|e0` 8l8vv@f P``0 @ 0`   gaac88 || x" f<| <l }|ƀ n|  ~B QpP
a0!P 
  ~
 ff|ff f< ll  b`|``5 
r < p  `b% ?Ɓ|ְi|~Zl)5 ll#<  P
| %|c| -N0x|~ I`   `̀ 6000q(v |氆8 x`flx1lp  lܢ-| p%| '| 06p'( *2
v 0d 6w1  8 vܔplp;5[ |ƅ88
l8|'!f|ƃP/&&00 %:l~n ~ހ1-7  0
	'!r~`l`fl fEK>c8c>^>a<Q4 g  ,+> >`gc= L G0`2#`?#: 0|w6> l<~61F  6ll6 ` l  "6# U# w# Rbd  6 P P 5 `ROqPJ U1UQ2d770 ?0aa`66 R9@a	
 R>     f 9x̯eb]8Pf```p_dO~̀Mi|`ӻv܀=8 Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xmaΐ<<S2tflD8p&mpK0t|  qߟҁ၁PQ#lEcFlpxpq5a q3Ԇdч >6`vf ~~`>~~>ՂR2$ P {p4`|| s4S
@0C 5t%9_2`!@@AHi P!3pxF)bfwP0v~mi "{16879
 G-3 a5әAaPp |@ѓ`;@Ҝ2#a=Ғ~ BC ҥ R*Ҥљ tPa7
`p0iQ.f`d|d`` 
`ζL ӥ񦴝Rp bq
 xp S	 	
qQF#a`( L%4bLZ ~EP࠵ 4-e0a6P6rhl q  a  	PS$j Ƿb[6 qb 
P$=b X
vO5.  'Ma0
A Β|оcǃ~ A U t"{ ځY
0x"p	#@	$@%#Qb  
#p
 
%	" Ђ#DaĲ6f0Pr 
$ 	%  		C	JC dw@`1|cc0cФ	?! 	8 ld>BPP<@ WWd! 3`p3 B7< ;8>dp` ~0]Zwl^l Q6=>6n6@s&tؕўD+ f 5ڿZ  Ed

 Z Ӥcg cb
 d
d5e 5ek 
c
eq eeu%
 

9 Ը=3;1N Q1|b0i 2S$|ҏ05Yaxp``<f	P`q|  0^0v  3 јn/AX `ix^ x8#?~ )4SY/*(ҡ P2M  "TpYVH!" tWrX"f<<fDY3\qm@ypf2hwf  w$0 I݄q  V  ts | >>]
Ë3Ҏ&&Ϭ
_&PSUSUSSSQ7PPtFW2@ _:&&M.W@
&FG_&E"&E#W_&]%&}&It2.2_
t@' k) = ~=^~=~=~ &U*&$
$

0B$
	-0
12;t4&wt  pu`2Ԋ%+Fàt6@ X2 ø  t` :t0?FË PuB%C ܊J 2  &GF %oG @GQW+& &D&TwAα !w	ʑ  p&
&TA2 [PD_ 	 I!_Y` GQW(6(5p Q65r ts | :&?Q~ 0
G@6D	ĸ 

 2
P2	2Y~Q4;G4~vn"f}2^Y/ /4 /9EPJJ  B2B0 XJw|~VBBF^ú$
Ĳ@`ğ  t Q%P䀀p;;$<~&G3u<#t<2t<3tP	u&I{RtAcNb  P3&2JGq IGLq ģ`XR23
)u 
Z`N.& un> tgp baLP>bP22AQJ2=QRP
u 32ZYYw2 XaZYYR*8}2.Zà؋!+m 2K{u(W S
u
P]`[+сÊ2+**&R9  @/ZHuÊU
J@B JK"b1 wP#Ԩ`X3d>I#t(q 2t! 3tQt]t1pd  Q@ !
+ .J
u8~` @ sC<0t ":Jt. ` S +!*2+uX  u*tX⑰ Ë`u"㨀t0 ]׊4"
Ê$"ð(cр  !$%D
m݁  +

,QVW++  o  e_^Q"YԊǊU_ S8v2QY2P  t (P
RS߂7P2 PL[[ZRРJ2ZË.{ { 03<?& t
uV EÁ,ņ!&J aZ5	 [a2RqZ 7L0 }
+ȴ@A
t
2&LP zW >&}SjcظU`T<t
K<Ut2[ðo
 6C%ŀA`A2+Q+++YZ0"Ȱ++Nuâ` $` t  2tatBñ8~
td\8tX΀|0I~D*
u
8t8`t2
8~
~Ȁ}RtɊ*_
^!NQTt
w櫋0['$jtPi"t
wwyÀ|t#GZqKR2#Ze<RMHU9Qpw@ @ AK?+>+r,+Z 	Û脷"+RTo7t|Sr`ı@ (&Ѭám +>u@F E&   P o!V1GO+>2u	&}uƀtGVW_^t##ut>|  2 	1
qh|Z`+0w!  pjr,`u
UQPЁ
6JX2D|BQ> CSu O2PpoFfKu[3dT)!o(|=?TSoUkujGPbs 1KXPk$6| 62 &tiU؊PPu'U#ëNp &Np>Xr ì}.1%   P 徖I ãt&0@ ֕"?   ì&O 8r2pÊ02fQ fduh Z `   R!Pfff  ZJ PXWQP; spfGufXYo_R
Q+IY+R3at8t褾P	pHbQu　PUwP[1@.ׅXn-VlA8|8F۶umXPRJWQͷ2_8v
VaG_YY_PP*[KZp_G+B;v
3a  sòθdcttQ˰@euu&fP - f ktf$߀t  
ء~SP
:t t&   _&]Xu3Ĵ0G`ĀP(ft mw`$eL軭ѹY0uѼ% P~%%@Ñ1Ģq>0JBbXXnIt1t_Sm)?5"2"٠K}~`bt2PI<
vJfu3JpzǪA8sYaPdPt u<
u:6u Ɖlu@L<u舉<u
t22+qt땽++&eP>Ѓۋп  y2ñ.=#t 	O3ʰpyv?F ]=8Pu\q? |NV
I_u-7ԑ!Q.t.;t$?.
DY2^#+3*22<PRs;ZXt<ty =u<s.P9" ?,0 #]^ e@О"~tÆE;P&D0=&}# 2 0<뵀wCP0$&e߀ te P ?02Nx20aJG`b`  Q&5&m&M  ǿCYð2	=$ǑN0?w u4 yàNR!v &w5&MúLq `9q4   {^o \1U  ]pOHqVk 8qW`6t*2S!q["qƿf
b  %kq[PP;PY0 d2|PXR9 ZSں[ SBB  s Ȋ PQIu0zXŋ$ ރ. 5Ӡ/<t 0ñp<wPSPRM@u@	l t@zP=s=s=|s^=Js  ZX][Xqp<t<t~ PS#[þpt@ 8 < @É.| ~ Ì@2.. 
*@ ֽn w 5
uw5wvP|&P u͎...ULF
FwnrvwS&G&g3t"<}A
<}	q-<t
<t̀
&G2  [àÐ @ߋP$ "3ҹ <u`Ȱ  3 2}ut
PpuÀu
&~̀ҧޠ@Sb[t (22QŐF t  +YsuQPW>&}t0&<t$G Ȣ&E̠+P!_X@3t__tG80hu&_2.ѫ!tR$
J	 ȋ>/u@ztHҊ& L2ܾt
vt<t FX0J>=&]&M&U&E
P0>X}21PSQR.&t	00ZY[XpD|S1P~`5[VQS&0<
@<
t2~0腀b@@Z@' t&^ Eq	貸sr AsБ+Pu 莸	rt2@SU% ][ X[YZ>:p0.dA B
 cF<u	A J.:r2@.] IÆ$0<0tu` tq
2.;tq a8~û i tPpt!(_[t0Pt#  P 2       ?     @        @  AV6tt#L6nf3۲#t	ufFFfËȀPk%;Xj^2yij?'aj k$u*d  pzIjPyzV iû`k\kP1:j P
j(j k}Zk0&qiXޱiıj2fQ 4k#'f$`uga3cojcf_  jk ~gjr ju$h ;
 jli j$i:  g ` }  j p 
  & > GjP h+v t v́k7@gUj$>'<v/
j jEf+EiiufQ Qi4+E	a?aЗuP+
F@B`"Jhf$%%&f`bc
RV+Xw wXwy+u  
[i<u ';i
wu$wtVx^ *_:t6ӿ_ڋ?t&: Gp:Du<pO+r0.Z@WV2ɐu "u0  uIPqh0Xut+*tPhE	Q	ڵ

	~!8;u n^~! /Yo	`_fQfRUfa f@ ff3f(  f F Fd R؋F ;pm2Ȁ?T@fŲ@ dAq0ftf@0;ff+	^ v,Q
~ }rF='}F_2
͊徐]fZfY5JVg`6eoJK ep <4  P;T_WÐPfwRPU.ff2ffZ OfRSWP ouDɐS,?0@@u-f f@Qf@QRk<!BB8B CfX2fPX_[fZÐRQ]paEfY@=$!a  0[RG%`f% ijHH> A4a	fa  $ff aA	4a
^
4iph $^e>"m"5YZ#fQWVSRPeulfS3d, @lf[fIf c fACmd膢d r D
u0EbppjZ[^_QSPǀt1N0`-rZ$]f`!'	"X[fRf׋fPX Lu" $ /L
" K# sL`" M^$ LK! $ >" $ 9::v;;;	<< ==>;>;y& e>?j |a|C  H   0 A 7777SM3M98877c877ф? W?@   } A @ U   @_QB @    @WD @    @DCU @    ]@UUU 	 	U 	 	 	 	rG  G@   
F U@
@
@
@
kHw 3H     ;IZ E E@  u  @U3@xUxx@x@x@x@H A ȿ@ @@    E 3+N9N?N<@ DNHNI`  NNSNXN]NbNgNNNNN5NlN1NqN{NvN   4  ƔǠ̬  d*4ϜьR8H  ܢvx&  4?^.j&P
<@|6f̾N2fn(ηڷ*^`>R۶ 8QȻDV|n	 @  0   "S\\F   < P Dҳ5F@@ w^~ NUU  ` 
 
y	p$   <w( 

HH( gK
߸8 
UH 
 
~	
U  @ XY 5j<  8H q 
8} Xx  } 
H0P VK @@ w
U@  &  d	U<  1  w 	U+0L
F  `    [
K` 0 ($
U@ `a 0*	$K `p < @ :
Uj 0 *
<4
K0=
 x 
+	,<p  [ H?	2+D
A
ԠSF
O	Y
U	  r`A O	8< `o e
K	@ pq AU	<< 
@ p
K(
   h[	@<P t
KY	   p`C B TdM "z_ Pc @d F 
@p `_ `0 a /    p4 K XdH<(  dt@t@ 
pk/
	MW:
N
$  r@FE
6  /pR
WB 
#Ac  j _ g]7df h i0     k      Pwg @ 	y yy 		



g g 4p\jU	 #20 3
jj
jUU
U


 @ 


 	
3456
STUV
c d e f !*
" 
#	$ 	0DEF
stu_v
    
 )
 l  
 -  @@3x r; (    R  `;E;L8-`$X@: $ATI5  ! ]AE 1qs 243p7bw ~ZӐ HK0EhՓD d`03  3  ? }|} ͪ   w  0`F
 #  t6Ip rUHP   @ B" D$HD$I$RJRKJߪTU UUjj0 mkZ۶m[mmn {{{} 1 9   y  	 TRp	,B0	p  	B h2_ 1P 
 	q '`χ  &0'&%$#"!  ¡J`r  J  @)7 cA 0xIc
bjW ! bȇbG0Bir̀
ÂGi)ݿDچ\ܿ
́TT́wii,ԁGH߃cȀDоTˋ8g I־QЉ)s`~>*㿬투ο\و
⿲;׿p
Vjd̿څρɇHȀs BBr퀋HY߿"Q=(ھt57ӅAG[^KQ>@CRT7uu7T%F []][	f!,'пξ)<3H;!i)i@2zoH^ <cbbc<!??)a KݾduTu*G
%~R;ž6 /IwB[k߄k >MsͿm4 SſQ%þs؀bzoP.【Hކ! 	J߽&ɿϽڀɒ-珙4+]O̿2m*{Jľ"@RR4RRG R
 ] RC RRR;R=RR	@
 zC  R?@RHR
7O3a? L} tD~ ў3@-
bC@   -Pd> E
M  71T p{ 
_%`eR7%9d%9P /5%`  R[ d[ :A[px7 @Ơp 
@}z T @ e p  TȀnpq ?  " \1 \.` Y 
  ?s; O0 &
e 
e Q  i +
 	V% &
=  p Q 
ef @h  eg T 
T T T0 T @%%
%DT A T 6

 P 
e`
P#`~!
%I%J%TPT  
 
oe
 pPԦ pT #
%f 
%h %g 
%7 `%0`R%6T_6[nV 0 	
-
  !

@A	
 !}

 @'@,b@
 	
@ 
@f-
B -
B@ V*/!	 o
6p `PBS#00q `oau"bPc
rd22`es f311@gs hzuis jAk@p' l@m@ n o p q@rst@ u@s Hv	 s  s  SA AA 3  0pqr`A :O 0&??  ?4u0r 

0A EAp 0E
>`OIp IC{> e	e`a
{ 	 ;c%$'a% a%Q   Ҡq a e	%`a%r
	! !P  ! e`@1%I`Y 
)[3[ M [7!_[1MU0b0b
pZr=% D(Y` C@6?  bP `=bP eP\Wd\d0eP Kef Pm``3%cec ^;RU7 
_  `UB
`	`a0R7[PCA%_ [ |pa eR<Z9P<- "
< $I6  e
%0QV?1 =
  W
#= QT 0W}1R[0Y
 %A3%A>%A D/ J% D	AZ	A	A0e	
`	W@"/ A
%0QX`	A1AA. 	A>AE{A
A

 AQq 
`K I RRm?![p}= D=woI K`zIO7 <`܁ w<1   >9" | 1R#T n0{u0p"*`dbss
QhT(PrPo0AA0@0@
%=`I T0 CT0!q J%< 
 1 
JP{Qu

R; ! WD:8b#*S[@c> @	%@%@"C@b@DA3 @ %@*@@ @e
0 \
  \
 U
\
 \{
\
    J* '\
(| 
& ~I` R]qР\1zP`3 `
%B\
  \ +#P`L07! 4r  Q
%
 [ bR h!i QJI#6`PJ	o D< hpiP !=e?heiP P;P[Wἂ%<I\I\^@\\`  fL% I=pCBJ @IQ 0CVK [ Qkv S6 ( <^Q!p, pJQнCP9p Pqa
 Q
e0R
s42z(2zR/ 
wDZ 
Dpq w D DQw`DD1DDFA PPs/ C6a 0h`^da%`t  r?` %_X
l~pAOIR
@  {[ R! ~ID@D>>~Q/ " | r
%0
CQB, [B[h pP  
P  @ 0zPT 0}QP@OX0 Qd y:
: 	 >D p IY` C UQ
Q
Q
Q
Q @ 0(P+PӖ


`Ֆuffg` ajaafIN1e

r
e	
@




LDT  {Dg 㿨f	 d@- >e
a gf
  zr@= >  z\ [ J[A)%q  =含BPq@p 
T&} C`1T0
`}KSDk@T0<% D~@-DNq P%K bp "	
T  
Q
 Q ep T(1[ \RD(t0Oq  Dؓ<=f@$ &
  "{ @ ' !M%b PK e$q 

%

%J% W  Jԁe  
AA	 AG p 	H@Aw > FwC[ D[0{
 ]H"> EC T

^

b  C YPC%NIQ
` [# DMGf`dpJPJ

IQHP T 	T Ch	U
JЬN [ )dH =&&Ґ: D@ Cc:FApd	 CԠcb }JAD `?U4a q 32MB

p
0 =EBQd @a``C0E
$C
]% CT `%v![[K*5= CE=J@D2 : @&T $@ %: `7! ; 0 Dڒ/pDoC:d;` p@ V1 ʐ0Uo 	 
	ސ l	 @ Wp
Z* 8S ᾀ    ]s*  U դ 
 
 PP>P 쐷  Y : }  N0Z !~ T @   UxѽEa[оw0
пUU}V Pa_3 ,塙Pc9b@<qT ޻B 0%>X%?} 
=x $'tc	!'k*' "'L 'p`('n&'$'}N"'#!'' R0ύ݄.l.#';q'*	!' 41!'>l"'9	
!'V!'- 5"'n"'-{,I4''$'."#/ؠ "'>N"'/  m /' '<0!'"' 'T  "& T $ %`$/&/&/&%&R"&x "&8]#&ET @%%`)%%g%{>l%H-a%p `%ba%L
 -
L  L$JLtAL
<LtL L%@wLA\L0> _ y/ O(L( LLLuL %8 
L%L]%LPLPrF0 00P%б%gx%%*%KKT U @U @ĀE #H@#wP? HH
JЕu[S Er5pDsUDq6p%q% U%p p` qUDqAp q%tI^p@p p!pqsut@ p4Cs !	 PQ 	"6
6ñ~p T(6[ӡ&
3{s J?%I@@ f$@( L%@Djp
r @DAwD}
7D`rr\cbV
R`'c[ ᒥ꒵ og=e6 p wDFq DV  CPd%gPe~0sT v@%e@8eQ %i8Q el l_epAp ?%ueP 
ewf
ABT ^Bp@  -
@A
B@R>`_@  C ^ Z.VAA -AA-A7  B jz^ԡki[ Q :f;V V 	
    &T0;i!_ ;`R E0 DN  (  e `2'p1 bC0T[8 ![ءDU U  IU5I  i 	% >P7D pkq CQ9 U

V 9 
 A@ 
- 1ȑ@A'@  >A G -@u
 @[  @R\  n @Ġ5[ րpP  pCDDj@PFFsà!:)tlH%Ap6BT @@=`TKTL@M
N TI@JA
H
%@>%A D V ApCޑ	 	pt32 D @RIL% DQR#T "00WT ڑ Pi!d%P'T Y6aepN0`!0I\O %% iT5 
  pP0{<0 DDRIOD<

 "
γ
!!jpK& dU P

GCD0 !T !PR 
%'?J%
 IJ` DmXCvJ
 
Ap~8<
 MR8Q3
AA Fxsw F0 h@`P5@\
m`1@%(@sJp D_ "\@j`pT0 &1`&2&3
 
4 
5Q 6q@%iI008 Ci [EaDf9bb)cP Q 	  1
 [
@V,]	9 )3   --\
! `$A"PN	1t`

	 N
"""TOAOb c[{B) c 6 cC cP c@ b co c| c@  	o Z_Z!	 UJ  ?`\%q%@e! aaE!_ W 
F  VPAMAM CMJ% D?`fA IX p? 	ACb  ]& 	 ` e@-?@=%  xP PLa@TKM
pM NHA
A@ArPMLa?y[$ZT0Q@ 0sT :pS:eoP ڐ8T8@\  QGR@'Q[r=DP-"3xpQ	8	@ B9c_T  c
#c*ZZT [ CDp f-G b2`bc ` ; s Ǣ j 9? ? uM!  `0DɠOD!iMK#`5a{0uD  D @G  t qCqp C/  T0	@8E	]C7Pp!GP Qp:[aC0P
 ~-]P|
$a* 8-{Z+0ppq-@-*@AV( :}~[ ]pl% "`px1O;%ĵ
e
p3i
`OO :RNO 1yOČAO-QOOT /b11VV TBQcXP O@VTN_PQP-9c0]P >Q`<9\%  @
JI1#  {[7%Фz>8 `6 eCu6q[ E@f$ XQ sY0pI3 "A
[>CDA#J[ Q`F1PJߐIWT @ q r -p smt<=  u -=  R%<%E0QRY& @^%pNAN @%%T
!@ WU -e%L0M `M
eNNp
OO P01Q`*̰ %RW8=e`bLN;QW`Q   ,",*@ 2ʀ :0p.,pTU(ДbB:c coUc0w73W7  p #`}>`I6 2p`e-%!eP'C%qeNA%@/[ @vb,`d'DD Qb:+C %$ ' 01& !`qp9*001= I)C 0
5BUd *P0 n$3q`IV( %` !!g 23vQ
JI`LCg5q\"pQ2e$ 
II$ eA&Dr^L[Tc $2 ~323'*%
 _22P2砰ߐ 22	&8; 6bU.CP>)=&1P% V  IgI"Cp,T0J@8v~@@
 0 :D2E 22@= D,} *
 ` ! [eQ[[y |aU  [0m!j` k\%j\%k` Qj`6k`[c ѭ`а& !)P1 0BsF  Pe CM }'@
@pV 3@!/@- !2!Pbdq=H@a@'1@bBI QA. 	A>AE  geә4U	
 
@  @	%0Y Dg  sY d@'I"
@bP [ c~@	
@1@A Ep 0E,o/ |De|]s  D!s `D DڽpD~q 
@I G `Gʁ h GC^%acCbPcAa  pf311 gq a
O wC_	 d	bwA	
	@	@	tB		@	hFwqB	q B	D	$
y

a笅`z

r:
fUQbq 
IC!spD1c 206	2(e1P
R6 
jeP[0d &&&&bC&&P $cQ"`%%D%%$D$P
$ .
 $1,$E-
(s$C'77Cs/"	h1p.)!)dp z		"9C	  C(
1"	!&p;);u'		`&.R

U
)1Q
P
a&]Dg&A  O%DʐA0b0
c O`Dq D!7vACeC   12ޡF`P
F	$B8S
(@c  $ %0Ba2B%
%"p@q !T"IO& Hsa
NOEaB`6 			
@Q3A@  A@	@C%@ #sNa,KV=ac!" Qc@ s  Q]7 HF 3 0s  Q/
@
A@  T  R[^ < C] T|╄ w  b   R;R[ A0'<% D !^y+ C(P  : J% A-A` K DW@ C`T 2AQ*r 30.>%A I`0=I0Ѐ }!yA  A`AC 3	%AP 
1	[.e=)pA8  L D- eAC- TA[T !  [ H@A~  2P "  : KD{ p > ~A   ځW%`P OC T OoT @ P0@ % &@[jªPR<_
  v}/ D! %@
 
% Qr QV @
 
@;Qq Qp [bB_! c@16Ca
ef 
eh eg fC8 fQ >
BPq    	 $	A -
B@
 B{KeНx R7 Q-
B f ?
%h ?$gp
f 
h g P[P Z     t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by{      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VW@Vσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Pwh X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{Ynus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " h۠g.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ B읜[ h!h:I:  g  P O O 	   hor@῀g h6~BȎ؎zЍ
wh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu5	  	6r]dt B
#
CB
EGB
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl2QW!#w	t
2 _Yô{A3f@@ S' [P   X.
tذu@u[f
4p#˻"gf8 3&Rff@'%gfذ  +/;w"Z" 2$Ue <u
m203< U  $4|<0%= 0q<%Q f<u	&ka[<
@']P<'E<(q:<
P)!/1f= uffX<+^&<+V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYѫ; BIAf 蔂E;uQ
Pr"0 P	Ү  sE:R,(SfRPF1fXfZ[Ó_P 4Rvr6Wl_M8Q_`	(Kf	:=Uf s#(  sf t s	  t
 @\QVWf&? f&@Q).fSP&Gf&_fXf[^  }P`
\ _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$`	 iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` bi j b cQ  0  a M   q6  00hJsw
pz	`b;@<Wff  jp
腠 FfRff
fр aV'WC-S@+)}W襢t;_t[s*`*F?[_^aWf` f xtup8ffпfGfY܂eh_ T1X fߊ$
*ff !A	S22,/Rr'!& uf 8s֊ҊʠXQ=RP
t0`-r#Z0Z  uf a/uUf}UPfPfXZ+ ]f0+ff]rff‸m`g#n |= osrsc:B
Cb_ 1f^ |w @tb;h w*f驀@Kkow  D)єuU6ѫȢ+f;q%Nf fCtg 0V0^p.RfJyZRUQf fuffVfKr=XfuNVFY[u Fߊ1MMuY ^Ys]Pg>!f0tRg'QSVfNVFfL |^[YrfqXftA3PXQM~ N O蛂P}SA` XPjWUQ`PԀ3ʡ A1sж 謱 ]fXÀ}-pЋ_P^Z`Wᐌ f} mp_;p0                                                                           )D!24O#<AC  @@ D
 uj@ t%v v t ArMv . sN-f-υ&A F'N- aύ6`׹  @Y}d3!
tr 	
F (| r
f	u뿋^'Ât %{0	1*5036诩r0/5jr,r[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>b.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20<s^s6< s
	OtE""Lt*$Ot"#Ot%"0!)A
 ؀	.EF2	
r]ss1I9  <$uw2 *<#"< u<}@v<%p!2  ÆUu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'U&]rQ[P@ [ smSQtP^Ë^6?bm!Aؠri	DEt v~(LuWMsPf} fXr4>gbUÍb.@.GTώ^ B!+./3!ʊV#:Ttt<~'t9r0
!EE&~b<DD@ % 5s $~@6gb 6u0&Mf.zbf&]f&?}20
`'QVo B@ n1F tk "aorxtn/+rTO u&~ (u	RmZ<VƎދR oZ^'pqtfR mZnr ĒLr Ynr)8r$gnr"nr
nrx}nPp
u  r@!w
u 0!RWBt:ـ?f.EffސfAUffs /GMF F
tS?uNfQPÈVgbf.WP*f8f'w*f'F'*2t*܊f
Vvf߈Vv5PފFsQU n E]YRPCXtUW:>p_]s=?r  "qPRp2B`  1RPюً½ `jR`0?B 0˶[@( S^lV۬ :Pk|{觀 5Ք)0 Z^N}lrttRZlr`a r[sz_">?biK0j}c, V5<s-gbO8L<
t" >EbG< T#<T$s@  h	b
PX kk  { x` `7krzHP{Nkrh!uPph&RZع kr.Ǵt%ttt t	?tM% sujrYk	 2OP`^ZrF sH<t<)t<(u;ё>A u/WU>4 #n]_3jr0jC~ߞ`,^a*f(PSR 2ZPfFtN+v@.Z"Xq;G	F
g+#NM7M
%,J J_F
t
RrWXfS~ t=y~^f~^^~;^~FF
!CFFF  f[fQ
tW 8vNH؈^~nNfnNfˈNnfNn"~*Ċ^
^IfYSQ0PfPv j 8rC"sfZRfXfP.Ff@HFᦈVvP 耱fXr+t@UT3Kp' tff   `Wf+ MYÀLuu$ fr2~bt
.ub^K fF! PXpH t<"u<"trV3޾x 4|Q&?s@2  s& p  &ǯG` ` G `  0&O &OfR ef&G ee  A@Wf ag  WUf- _yX 9PVQVW!:W јtNAu~!u .Qw6 u/ ?`O	
 t,6@QoAOGA&&d&D&t&ƟDc<_^YXVy=} w" uRP~b
 j ^b   @ փ׺TPQ[ٰRP  PZpn <
qCQRs귄3ɺ[^p./ 
X `6./ 7afV`f  
u 	r o+r" s` @~6	Aaf^U`@*ǿ2$ԉNT@׎ǯ~WF$
&FG &U_Ќ
	 |aW  } t2_R n`gˀ$0ZV`  `YW=YUN
NNOపNz	 @R	Y$
~X"p?WYQPX@@o  IV`غf   T 쨀t333ۺI uF;D ݀u	6!(= !v!u!>!!		c

	nS$ [ δ2r$<6R  4d p0ff#f' \Xf05f.4{ tff`                                                 x  0ؾ  >f#&s  aM6@#aw Áf0eRVSFf3f߰SS"fV$
Ѐ
tWf@W`jSTUSW"T=SV(qVSS H%`^ff WA ΁'ρfPWfVf<0f f(b;sfgf^f_f@
,  
]P  P Q u0 L
,@,Q  	
,p   
T 
   # 
@p 
P P  0 @# g&*tK)^pJa~j  @
s	 	t0
4 t	  @      T Rwv   x		ETU  m 0  pt	<p


s

u	
$AB F@z

B"@ 	#"  x  $ C  D``@D&*aЯH1uĎ&>*tXRs"R  Zt  ZRu  Z ZɉY}OP$u_ XP$ K  !! Xqf`0f   :fa͂p-"f =   ÀRg&  
 g& g&GPg&GP a#  GWfQ4E	mEE`   $C=f| f ? C_%'!PR-M$McS

TfⱾ`M@t } iwB4M3 xM j  < SQuP T$@ Xu:@AAQXn$$׵4Qtu
R=
ERVWf1.1Vp	M -cMuQ<V V<W U  0X tT `3	a;-f7P >/ 3-f d-6?-s >;-upMh-f2>d-f@``-J0Mfq#0d-dMOMf`-d .h->h- u8M /R+quY>k-tH`a ٳQ ߳ai u
b_^_Z2 U uQWpV_yч^_YЊg9 S߀r@"'u!hP n#3r@&[U@oR  r./fZfY]?11a / ~ ȑ1L1?1̐6!@BK w(V l`v!	G1z̿آ y2ؓ
a1vD	1
ʧ24Lnx1VVɗӗݗnCfWP5sA< uD|,#|p f3If=SCAF2pf_U< u
 	<! F ]!  蚱<w&< t'V3ɊȈCF`  ^ t	V<v^.
t" ؋ABN0ׁ2"4"1]U1P X2s.V Ou,]{{A --! g g {Arihiơ` l-(/D/P/$ej/O{ 1<0%iQ(r2t"S"G*PQpr $ .["2ɵ"McYʧ .623  = s@sP0Y02bÊY[$
 fFf 
tN8tS Ft f% pK@ t0PL Жt"0MT W t  #x fX
|RVs Z!
mJ
8
0
$g4 Nff`4eA fu4fafFD fP2fP tfFP? ^DP s ff
fWvfp3y#"fF$wF(F,_F0  f3srBrf-fv,v0hf_N,-u(X(@$иPN$fFfV fNuf2N t
ffFDlf3A1	`N xfր   ͡fYf#f#fq܋N0 fHfVPf#f@f+f;FLvLfFPf)FL%	f0~ v駎AfI )o auwf*͘` +pfAN
X7f%	G@ysfA d!`
;Vt
fAQ
y6"  f%"W RQ @" w"F'F`0ҮF) p" X3> vp=ff `V0MPQRWSӶ{t"_
r[_ZPSP`  p ߀@? b%k_bМQ 6u
 @ @Ül8 +  <PQ GT< 0(p ߧW%!QT! P11Nt)br(SF<`T F8F99998D <9 9 90 :P R: X:a ߹:& @ ; ";	 +;* U;-Q @ < < .@ C<
 P<G @ < <   P 	Y  !Hewlett-Packard 68YAF Ver. F.14 07/28/2006P@\˾}  Z  l~103C_5336AN  ~g a	rKBCsion XX.XX  
 
  _ /	`AP?# Pb @  A @SU10 Intel(R) { Ahrnal L1 Cachea bi2e	
 6PC CARD-Slot 0  
   	 www.hp.com ABS 70/71 79 7A 7B 7Cw 7D`o
 Ka1 
c
 DIMM #q1?Xb2hVC
~&"Ra0G 9"K  /No bautyW$"8
(_ $Wj>_T*u	 a 
yoj)Ӏut&  5߀& A?)u&0ɺ
u! _À8W@ AUs RtY }pvMuG	0bRu3uOQtru1 ta0> S:u@%8*6R:EFu E0 } ~QtTt̀t߀EtL71ƠF -t)> t":& tSu EP$<X3`Cpt	 _E>I@q u	PXuP3 t$gX랓t#%yEQ utCt0c)	'r!q=8vp
p$ +x3;r.Dv+W+Xu432c*u!.ð-# *q!	 2<Gr<Svƀ Ê,G{.#$]%J u3%
<.r "Lu2C4 %.#2K#0艦rP)<.t<+u
0 uθN<- " uJ,0r& 
56 ;6 e11Ü   C8BBaa脽a$at@0 ο@FfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~XߊÊܹP/FFYNZ1·A`Qȴ+Y`Њ  aÇً |(B"ԃ 5B & GHB.&A'@'dQR Z
  c Z` 
G XYZð
< _
7 `R  S r  `؋  P 9̻~  a!
и 	`949a@ ؀ `
UЋ؎ ]_a	p]3< t
AF `P{ C0[q$9SRZ[` Mu 3 0ؾ   fa3S 0YY VQ3AAY^` 
aRQ3ɋfp껡RAыf;v+R'TYX0GYP fWgfǃ#Eg ٰpܺzA0vT2gf鰌gƃ!g u	f@w1  f@f@ۿf_gf1 gffgf0	!fQ@;gg&fG7A;~+fṼ @7g~ggfb	_f #fgf&q
t@P	3
Ay
f?f0
_gf3  P
?@r@
A
@  gf3fS̓ Űwff#b ffyZ?'wf3f30n,;wfPf#4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
 #W!fكs À +SfVQp g46f?FCYQ  Y`@.f^\ g&GCffT0[@fVfWfSfQfR
2fZfYf[f_f^b@R
uZcf;tf`Ȁ us*1p t-r(@G<u upt dfaUQ	UdF @ E] S<t
<t p`7Y]p40wPWafv2qp ^~pRZYXɓz<1jspr2@H	{ wt0  t	  ߷iR{9`KT]r=s{ +T@H"#@OP%! `o80,Nfѿf3u
0L t"P!" aXg qfF ""Xt$4m@Tff6@U^-oc&Q.5fPQXYрS	o)Ya'уЎ^nu8	nf<tY< u#f!"nqntnfapu0EuPPu"uZZKPPE EPP runtime BIOS - Version 1.1 ptKKKK(LOLtLLLL
M6MBMRM^MjMmMpMMwU .4K]K.bm>".`m A"r "R.`m
ZpQR"P <rt2[5$ԁ !<
  -" ZY5	$ o ۆp[	!	uR xuOR]W SUUU.Vff	`_&n ^C=OS CWV	al _Z T
 J_ U PSRI <r
 j ?G 
tP ).>M .M 
   Q3쨀uAB$ 3PHP ~ SIMPLOiMOTOROLAVPSVSp~;HSr< P󤠷s˻ʆ~0]I- >U<Y>W<X>Y<﷡ [< ]<_<XSR &3-&Z[>a<Pc<﷟谢h<W襐h0<
@P+؋Òce<﷕sj<j@	l<a	n<X`
p<O
<FX@&3ɿ&M<S:Mt6N 6& 
6^VUROṥR+ׂ*WW> U @WT^UUJ @		`
V>j ʱV)ʿʴ+ 
r)><&~XPS)"
`V)[X0Q2a Y`+uWt=Xu2
f=)e6)ذf:)e3)20 )$)Ya VR*+txSR ڊZ[  Z[Ku? 𷐊Ƞ((t%PF@a  xРdQPjZ^`*u=u8qB@e
ً@p 2 聐00+i*u<xu7Gt)A:tڱۊ
lZ]PGb 
 s ]`K:\KxSYyM M>r}Q4Ys\ Pz) 3Z[x*'߻`"P3
ݸH %ٸG S QL  QK R
 pN ގpM ֎&d'    x P  X@ Y h i j@klm n@o  @ @	 
@
 @p              S M f3xffU.Uf.UXø 8ؾ|7t lf3f!f1fRVWaTT`uTU Qqff2fff˿u_^dXQuN	$ u?YÿQf.uX?ïYff 
Tf.TF	f f tf:2fuq
063ɍ6Ma.L0Z.:Ls&33.D +.L,^` 2`r2w{ }2=P- u K^Zt
3t t
t
u! "+3ұ u {t3@Kt>gb.} .~b_u}߄ P ߴJBuL2   u3puvRb`_tURQvRUK2YZ6	u>^
 .D t+ t#VޢL^~Qp.Lq ]Å@Q3 |Ys1 u&	 t 	&Uu" ώ>^ |  Êö z..| .|!߿^\0+Phښc:ZpW 3ۍ=a"_P3Xú0@/SQRW%,  .s 8 0f/#ffg&'f  @7 7_ZY9fPR{b fZ;`$<t'0#<tNc   T M_ H<u 5  %l  
 aS  #[SQVW3xu@   ?	u1@ l _^Y[WV 1 Sa X#m'^_U$	ppqu嚀<à uZPQRW H $tu`$	Qq@ s	t   ^}$
0	`@  t`<u
 @&   wM!@tA AuqP@u  , &w Xe߁ ?`O  r
 P<Fu us	 	uA
 
u	 X RtGTPRu`6?FtEudr_RtZxVr t& ?R0-ZJUu3Cu
hq< $Duh h 
XuhDbX&  U au_@ ϑr_10]rr
rAr d PSdΠ $& 8t   ~QX uSQ^ `gH o`*C: E8401M @@dY $PnP!^ ^ '^ 5fPff  @ fXtfUf]p  P"Vfg]%rdf_f≋fX]ge333
rVd4Ad^;sgu` 
3 s M tAt<VrdDg}
^` VWd_^gEdTg}:
`}gE `tr	 	t}d8tW<ytu@D`@ڦ
`PpfUf]3
t  tu Ó' .;Gt -._
u ਐQ	fg6$+' +k_a`p	- lFpoypOIEMAG  IZ P   	 {
 `# HDA-L  wHDBs A-E r Cu 0USB-[FLr CD Hs LS Intnl^PCI-As B C  % eO m  H	P 	/` <M a` c!aF	a a ?aCD001EL TORITO SPECIFICATION *578F'()+3457V
t À # v5@fЭO `
x@Wt^t]t\7;uhtF5RR3< v
<ar5<{s1$PɎb? Xa1U#ôr2հѾrVasu\} "9H2_.SbqR`0$cuad@t<az<zt, o{ttt
w
E2@t60X-q(Ԁ	`l\2A)Pā bpt"< tr r	<zw2vPQXs	} 	E`P$Qd8QPRfdx|fSdv|ASS+ SdMd5BQUpDJ V8dP <d;]ttd|d]?^  R 3
' '迿 FǠ  F/d3 .;v+GuBG
`F/ {@ Ë%	pXvNuQ
 	0ʕ NY%'
r012p46789ABCDEFSpۻe׆[S3.:et	Àr2ۊ[2U uPXd]<tpo r
tod8D^uP2@Ӡs T^u`|r&
yt,ـt&M1&G&a`ЇLAAA{a+Íu 2pt
 ۊQ ܈$FKuðWQp
u	ۍY;Y_]uS؀u u)[4  @a3ҐPS0
BJ<Zu$ u !N۰ t `aqt$t$UNN<Uu$ OyN#ط$0<:ru~@МP P`M   AХfPf_r A) QfV: (fPgfFf^Y0PRt p	t	tv
 vt	Ȏ؎ 
hh3 WfVSQfqVF! YPs^(2۹  ptF  +^D!8u3`ش^P!WVQCuKvE3 `!0 w $I^:u:\!u O8Po[_0< tG  )M
/ O F@rP
@.
 b
"d
d
$
*Or	S@-ij-a.Cذ,@u[R2p n Wl C  Ơ@#  Ȱ2Ҩtÿ
 =,pߊp$zt3x
 hаa	Z2Ss s	2 P | A: 3	 ,{2w2 	À tN~ :4
$>
$0ķ B$2
Íjjjj(k[kkkf0g1g4g  A  G@ " y" U-Q RRG      *[%	  ` `PGd[ dг",q  qa a O 
p  Gr; rrs sq]
sq"  
 6r 	I	 
 1"ţ ` u #PC[ $t$?ath@ & r 3u.`m3s' $ ] xLI<u	.`m u<? ` 2$\   ptu0vu	V $
4 }hS~0@ u7d< <u `[SfVPfWOeNO@$msc#joUocoLo  M +  *  " *a&007 *
r@-~g!8y Ay bc é uU0]E݊PU  ʋU0P
"}r2 t
jrðf`tJRQW %  d_̺ &UY U &E! ߀t &]@ Z`yfa2p.  u(<sW .p_.w ]P'Xs>Q.u..&+w.	p`@ t^P^.&u @ u42..
t 부wPUU* *Ġ&u XcY0`nP A3.G
XPV *.CrPWЃ*$_ qqqr
rrrr r'r)r0r2r=r?rVS3.:Tqu.UqK`"@[^* UFPq2SF۹ S.]qF[C3N[QF ?tiqsF2~`"7	 `  _ ø8	 }d}`d w{}A}`0}] 3`O$  $*s0s9sDsSsfs}ss`d$!<!uy!!`& t"&& x<`&  V<t @K!D8t( 2 '2233prf>"  tA" P ap( Ҋp ) Ǌ&)  * 뿸* >+#1 d>,0.- &) r..PR u(t;6X6 6 53
t,=

"=
 
0I5w<t<qFp ts<a0 0s
Ê& 
<uaw\wWQ=u& C` uL-`!A &
Ø#Y6 FF;t2zu/u=u&uS3a\"c`  \0ba3ac]@aR]D]EPGn]x@`[\!\{i\\\+t\ I|\ZP\ ZZ g}
3gE
t"6Ma7D`u [g@0E.sU I2-aYaѽ 
$&&E0d&wE
E   Fǿ˽	Zĩ>]>=t
f nE p$
 &a~ tjfaRМrte$tXP ȋyyZPwӕ1w)," #$ufQfPfR`Wfs ff+fQ @f׸@5Yrf2f_f^fZfXfYf>3-u^f sUj-
f6/- 0u6"k- ; u0j-tfr>j- t YQS WfSrf[?QSWf/ r)v!ufPs ~fXt_[Sf<t;f3f t	f }p
utǳf0nf!`?
 3ȱ P㊊ fX$g$/]$(ou$$S"$I_?"V"0H"
;m"!^ZuR@"'B"@" $p@faZ1bu gVBx 拔 tcPtt>@ KXSB$x$Pq`Xr$Qu!$
BB 豄JJq4HX^ 	
 |@Ң΅ i  p$ q qzp 3ҴĿ&./@32ƀnuo n"p'ðɆt `tw ZYJʯB<t&<t"$ AJ误_BԱ蔯BP"䠄t"
`P  ௨u$! !߀t &k XfUfPP1XZ+ f]1fŝf]rPmpָn跐 `P}
Xu!Pr<Xu @Pet@ga`
  Pfv@_SM_ P_DMI_ 8 w $G!HP  _" 
 r
R3҄  t73Ҏ¿x ȫXR`H?Z                                                  W" O7Ys  0;/%  !߁FZ' r JƁ߁4N^ `Y	r(D
@ vArHvA.GsNfj@&t FNo RV.aZr# Mu 6`r pt 2reڠ	 v t@r&@_&E0nr_"r}20RsUu
FUF -0
 [9qp
 /B
r?@e{(
	pk^F&?s  s&p  &G&w&GP`&OD
 &	G!1.Mf.u E	ffPE]EabgVfQSWf[ffY^f& u#f&GP Wf⺁   4WѹP'F#~r .u7 u/sr?`. t8.> t]u  2KrߊV ʿs`,%a	p a~t$` t u/~ǉ~ %"NV 1	s^Í6gb.|uʺUfZL艙..!a`>`~.:Uta%aaCWQS-ن? t0.}u.:Mw#.;]	w.:uwPw.o;w	@w[Y_ @o>߀?r.u|
Պ!Ѐ ʋ.E<v mfV{fv`dD @؊R
@NP.eXfwa P	rs}p2

	fX!9
dDA̎p
Uv]f^PRKBE` ? 9 3-ZPPLXuUW:>	迦_]sFr  P%$<~1 r#P@Xu>>k Tߤ$@<@ P ٤sXXty>~5+ T, b
~
 X  PR?
Z> P#s'`  o_Ѡ!  %aѳXP` n `0arSHmIrcr^t :DvL*Dȱ p u	RmZ
R譣fmZ@?
u rlR藣lZ
u2tp1
 VW
 _^ q _u
&:Ev&M
&*E
b

Wo

o

urQ
nZrAA&諢?@uq``rJ r
Hr(tu"'ZQrr2*-3Xt4B uu@uu`  u2#3fPS `*~0ݰQ/[f@SpsqD
>0MD<^Ƌ.t u a?4stЇ!$!">;,3@PQȎ bJ;r#bMwq_'t sq 2:Tt
 YXÀuOua9G  <s& ?O 0_ D3 >gb}_uǀ   Ma  =a-aVWi<ua<
uuP H<u>u0x2<t.$S!k4[|u|
v׈|`Azt\_^F] }
u}	| .)a0q܀}u	a`>ҫ~@uD?a蘫P%'0QV 3۬+^YD&v郔fff?ffJf6 mt
rj@%f F PXifP~ġ=r0&w)EfݩPu fu Cuo~A 6SVt|st t`t2
3^[PfQ
  <  !@ f	t` vaif`fff {B fHff#f+ִ f;wfgP3g&Sg&c
uff+ffaf@7SRb2r=?$j0Ef!`ffX{RRpEZssrmu}Zr
w0V2PXZ[ %)_d%&  +%dURfQvV ufufYfPQ@=fA{<\1< uQ !ϱ n -Or.V sfYZ])Tf;¿f;fZWf! rfPrR f_f\qr
8fSr#|s
a`

<f[TGM	rrBP̸XPr Pup$SOs[OBMIRE{/JOQ PfSIff[fpDufXE)t fat/+f %#fSfQf3xf!pIX2ۮ"ZfYʨUat?*$7 3#t N	pQ!Hd0
ð- V{ľ!WV@ fSP~WB Q Y_W^9pHlLst6]V! <5u G	F^B^= toصs.U<5ЙC zL>irL Xf[2P:X^2Y#WfVfUt
P E&r&< u P &B S f^b$Yô P5tXs #TG# #a$Q$!/G$Pw)
Х $ C'T
 O O$
ǊOO O N$ N$NNW $u)"%!3+\tQ	 
S;)'Yp ðQ3) +3ð&tF!`zt	*tEP
QS&"
ǆ[ <t<!t
<P	<*1`R#1A	0	`4ZQRȍ݇`- {ZYq$ 2 ) 7VPލvS<û	 ۊ[rpX2F^ ð!@萠 ")Vf@1t؃ tyD̠FQ.40l^`I3||  p$ <q;<
Q{^ vt"s ؊B% L#؋ xL{L*ZðRQVWPpQa0X_^YaQ-aXP2b}ω R[2Cql\
P' <0fq11ðWK1	R1 5 *pw޳"S+_ Tb-jYB"=@V/Zb	^P,U
*q 1`51o6k25_U27UP	}s
 q8AB77qc-ßR3ۀc!' t8tD
S螔[2P}; r<
t@$PMM WPt  pE@ f3xߊ$f
f $RWS221 r, ]`u ]8s[_fQWp
t)_r ]ff  u ]8ufXZ_aX r]pQ3z]r:O]t+aD]4 v 3]
tH]8t	
uaY@_SYSID_  q{ _UU+   IR    A&` !e&i j b c" 0n a    q6  00hsp	`~. Ȁ [p
R\_ϊͻ 
p aVWS;t `t[P 
D[_^PQRW3` `DQ[0jt`GYPFh s/$_Z PSQVI.ƿ p6p^Y[ (` tOu ($
Ҁ`!,`ô%´+ҴҝМt* uҶ$t0Ҁ^ ȋ`f`a
%_N	r`RҸ %L` +F\$<fa9>P  2XPUv F t	F !Ff ]X"X
W8pACP ݸEø@ ؎i &g +  pa pu
fN@  ]ϰ2ðq  S\8&`&G &G&GP    [ !@   栯@@\&\p F0 ]
..c3 и( и
  P
C@@ XWP<w3t u*p O $~! & X _Ϳ@P X2$31    SfQR۳4!ffI +fQ`?fYg0[ø <Ȏ3]Ou r 2VfPS=Au@u;Áp u39 u+ f?wufP@u p"Xu
_?ff`<u0< ````%uq{At{N|S({[_ k@Q  ~{{ o{KVǠ !qO {P 1{p{Q j  Ao %a.|umf3gf&
f=SCAFvV1Gqz"ffff Wu_f(#3`fPffX<s_32_p9\"}5 d_ _   of;fQ  U	 Y
 f_ f@1ABCdpژdQ fR  dS fT  dU dV dWUXYAZ[\1]^
u` ua ub `vc vd!eqf l*mm*llll_lltn %	*P' @TO xOy Wer$DYIsL| 
u \`S+[PS38[
 .X'aSQRsɄ3ɺ~r0AZY[k3tί  X fPAMSCVW  Ў`  
 
@  t 	˻ʆmrr ɍvwRF0 & O 
 30&OE?FUWn_]v
 `0w_^w 1pp  MB RW $09 D 8&= @
 9&FGvJW9v g9p cu#' :l:&`` 
;u¾b:f3ɐ_ tUVur;;&3_ZGF< u  u2D4F dNsN~ t
SZ[=_t=Nu7ut

q菸н0J fRf8h =`? f0 j H  $pUJktEbfrPf[8Q f{ 0Cf% ;tahff Kf1MBSQ
t  +}@r}l"qYQWQK  d T q r7*4f!_q CwfT  `r[Rfx }Sfú 5Z`P<XfZ`d f@@uX
f<@ ~f'"d!mQpmef%]
 |DpgB$_:B3E+A1 9,Xf`ff[tϹ"BY ffhQfRWf0f˟fӐw3ff f  qOuqYWr}yNtpNgNcNrQ!KL G B = 8 3 `з) $    7 跉\_Q@M&GY߀'gJxǀcd s`1Nfۅ   NN Pf6p~f.|.{p  $0K%f ? f@fXq A' kN|`_Nf  
VWQ
r2f3Y[WfVfu-sz ft?3f^0lo F1fZ.Mat'} <9<u 29hп< h 1qqsw`svt/  s
?2 03p |/"  |  z.Dt.D
u  ``]&&D aø}0pü 
t0fZj &&E 9$/3Լ{x9ͧQPTP !XYu/`.\.T ώǍ>^.L` `?a.D`=aQPƌМPR怺NZXXɎ6hښc fZaÐ;
(<Pd5b?K``w&҃PW<rǁ  .{_Swt 
'0u'`e
[e uu0^r!<u	rr&P` aPs"`Jr2.t2{&^r[!
se r 9q	8߸!mr 	&& rr	ôQSs+&' @>' ~@saYsQ
u>[ W r%p$S r~ rq	9 ǀ" $ ӀpQ@	Pm CX߀ u#t s@t,Radto` bpt t
@uYÜP`0LCXr_`QдPPQXdYQPPQ0N`	`d$!<!tQQ_Q  q&@tPGXÃS P .DحO@:.Df`:uhgI a'1lJaúB  $.Dύ+ݯ *qݰ "Nas@P FF
]X `j HL j v
B:-Mf.N. tI F ~r p3؊^) tѱw t&Du .⭋^^ X7a.@t&ڃ.^2Ȏڀ@Z6t6^2.p @ PSFg
t'.:t	tX._``_g }i &  @
2˰d@8a؀R,غ:3%  ZPr-s(N@rtH rr
FrvFr:s5&DC H P>rڋ֡JNFÉF(t S^$:u [r
F&F$+%&=vHH&
D0&d̠u rcu
	A	πt&DB êĪǪ AkHA@
 rpW`^b`osu fD
E$E Fн&G q
VNyN~tr>u rG DykA3F) _ar\RDQwZr=H r8 Sss#T
P
r
S s~_@}H $k $AR $VF(`r#!#rr`ip!<t 7'!r #!F( '&d&Kp#V&Ơf)&t N.$uLuﴀô "F S3ێۻr?4[PXv W{Ͳf1脄_QǨu_PkX Àu3xuC`N  f3@VCt`P	ws'` a5Cу!  #%a   aI Xτ @F$$<r$:u s
qú#t'jw 
   @(Mw  $tV̳rF.^ 4uDF&?D F%~)u*&tv&V$`
V'&L E _6F (@$3'E&f$`
ĢF f%U$oPG >ˢB(IJq4hvø fF" PXۋN8NwN 7RvoZ2NIIIrQ vI|?vmZIr rufQuAFuDIofI21./5/  &u ftg# rѯuw V/QB AB *uBY^ 
rK `&s
3
'u3` H

%uètàt  A* ;V&T0up 
* &u^!ኻ 0QPXuN%&:Lr, r&"T`t r@u<utGS.@ BD ?o r pG!t$<@t_414tN !$!信ss@и]V$$QW桽á_JpbgdbsPBjsesG]sùFcNsF<PڷSķ.øJÿfUfQ`4fVKrMu ogf@ N V FfYfu(gfFffffMufY20Yf]Ë< 3R+fQSfVffLfTfDfLGf^[fYrX	A3PXføM"øNp OÿfSQfVUfWfP:t[  fRfZ&Ý_f]fZf^Yf[PfW ttQ uUP`XY fA kPQ``YXt
 t$t taz`p  	h`_gRfVjEpZ fWYE 
2VSQWf@w#t hr@ $r	` _Y[f^; QWVܹwy^_YpQV3۬
ÿ^Y뻟 D 󃞒  z SffV1fffa.6n:fff;w	rf?;w%ы./ " `_u ~f%bp/aBR E$ ' 'ذ1y0r= <r <3f@ f
f?fʝ ff   f-   fPSQRW0>2pw3&G;r_ZYà <%F   1Sx a	tpQ f  d[@    f@fYX4Z4f4f P,p!RfWg&>tq r 	 tu f_Zr gf&^f$f tt,$
g&"Fg&
F J*$
g&#Fg&F`K	f#SF	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`~
t~g&`n
g&@
qp
 
u
g& 	TA1P a3Rf^q\QUj$
  A " * Gxx  x y 1 " *
ܮx"x 0   s @w_X _y\[8y y `b `uT ËEiذE
U c
 Ħ`y0a
豦r  Àxf`ti2tW &  d_&E3ҀtB&U
&]@ &E  t ûpguB&E@ !軚bbh(.G_q¯a==SW-a.}
u.:tL u% t>JrSgb.[t ~b.[u t	t_M_\`EfUv"v t Ar MPf .V PXF
wh@ &A0䴀2j@!ʹnrPqOk
	RVEb.6# .Z.I.
Lj@s&  |0u 
^SV#؁0.d.$ʋд^[|	ã3j0rcOt` 	OtOtLtDbt
-bt!btbܑ

1u	(u.<.}h $ B(ÁUu	U gqR#?G rp
\Zt ɹfP<r|wfD m u
 u }tQVWUP؎&Br& ȎXEbߋ,b> ..>@Z0n
Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_1&?sa s@ `b 
 ׿ЌcG_fE  Aff@ 3SRWP%sZrv [E<u<  mǀLuUE<sfQAM}3 2>gbb.  EGώǿ^ r./8<[Ür_Z[ð.>utGFr=pr.EP .&~b>U`@A%50R@rPAَɎٍ6gb DдSRt5ێËހS.&Gf.zbf&_fo&_P. 0Y2P)Z[fU0w%DTRSf]߻PeuTf`0D 0fft;  Qf31Y,65@ 00 0fa2jb0SRW*׿Oз\r 2 {H8>3_Q,ԴA(+ Y rڐx73!RQWSP b	$d3d)X Qdt75Yw a߰c@ sX SQ2c 	uB7X/2pV_ RcmZ_ #
qY 	 RPD]C[_YZÃUIc2oc<Uujac6TYJ cBcBcB cBc bϯrQ!p[P@
g6bS"
!
"X"
u	趋   *`VWQP Dt!WQ:t
Tu8v
Y_eY_XY_^Ã %fZ.Mav z  `3脱$荱Uu3&?t+aÍ>4t"tC .:Uǀ	 V tMRRZ!|p   $$<t} t	^^ Q |tYs3䆊Ѐ u*Vygbp ^t
 蟰)&VPcs)t!ɲRڻ~P-۵u3ێKZ
ta, u
u
xǿuP@s+XP xj1+z`{0@9"Ĩ@t  p 
 ް  XPJXWP29 +. s#. sXP賯&   + &X@W fW@/_ ;
rrP@u
df%  X 5u6zu f toff~Ww uSf+[*u;l u
	

 ß Vf2
f   . Z%^  rulː
uK遠 w~mAc	 Y
XO@.E;
u&fFf ` f&| uM0	^f_ffV  =UtKf MPTh{|< Epa 1 ` &uӋ :  \f^fY0vUh &]S^ ]X0yuD0D   V& fȡ\AL
^rUfWދs	TVЎp&ǀ Axft@`ʃw^pP P&t_ 'f= y'+a¡f;M E
P# W?f.`@Lzg_q`30r'Ru
Rff.Af_et R]WStQYfn /ufp,  !f0Ýu# ,Dxi;5!%U
UEW "Q*r aUD`hsZ*{Ñ"'rnOGR0w|R0q1P_@ @4_` 'Py`1%@ 5AC<t/fQ`XwY`M 
fu f =` CtjxY05Ds;5 P!4)`;T
AE6Eg"q9R88$(%a;E"#AŬPh

f
`	n
	14R@wr('/uQ ">.uf.ߣp môDf`_VQ$$@
 qB^3J
ry9
lY^rHg5 ~U5rX5"6HeQKv fp0=f(GuDPfa>PVУVWTVV KJiLJ  fS{tQؾpQWaS 4@Ef0? S^ hVTTD?{qffWfQ`WTZBS
`m"R"R`G2RWY }G`f^W^]^@׃Lp]IL@/q(]]\s(V=&e	3
7T`TmDTp%uTg1wؾ:!`U	4Vhxp`#XXZpHXWw	)!Z%l&X`kr_W3na pDqu_QthQnчn2[hnnsR`vppyps|z= rYXo,Am
1$pf[`oRRRReAqJЎSRbUriIbxbR r>tfК* Z\ `Ua  BuZYggpA *ua`~)O{݀    ' r `fHPD1 2]0[#rf[4sf # R= tJ=Y C灂f3fffX=tfX葲}YffpN]fTCPAt7fS3 f[< p! #  &EtXrwPfV$P)Ők6ng@^Xpzf^X_fSPAB?XFa N V!~n$f_  fXSf. "  Ԏff3Ҍff{f fێ $Q`Pe^ 		Wf0w f_?A_f`


27]
 fu ]
!
fa`rfp farO"f3f & qs`xR
Q[Zrf1fH!?r0Mf	~}f`34cr.| tFV.D.ty< < t&CF^ t&_ CI
Z!3tpf0r|qIr&%A rp/.D]\%ۖ 5cܲnr3f%p<f UCESsfq 36 u1fqu%f#f   t	sLr`t s` u `zmumamff#ffд Ɋmrf!RQ<t2!Cr6
+mf u g> tt flr(0E2 t]Yp[Z4Qk@L@4l3t?t
~1Hkr2fZQL8-t(kr!01[t.
J4?t:R!4`? P0cjCk8tߨ , tu
@u$2(H	p)@t'@u'-*t^p(t
־!-  t>Ҁ fAu2Ba˲S`q 
t@  t}Å6e	jri/p/zB/RZ/jrGU/Z3tt@j$߻
Ê o,Z$?t Pi ZfVQ! 0fF3PPS0-  ?(j[$2	@i$
Л  ii S@Oi4fXpG	ش  [SSQWfV~W  _ W
t<5t^uOir M^_Yr;ip5QRV3Ҿыû @f FKt
pۋ J8u^ZY`r)  5 }u;ґE sك?D@t0	SWQ wtߋуqI_[^ ZRKfl f@f=@3p fl (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.  @ A  B C 0&"g]V^t^g}
3^VgE
/ uSV^} 3E    SQ>^u5MXôu% r!<hߚ3ɸ 3 3Yp1RVU&^UX;q1xtt# >r^<t`i?Ɲ 3^dXV`ۙ`um P	@!oir
- Z褙Qm~Q  $=rc
pU^^^2Uf0g1g4g  A	  " y y y PR5wuaa@uXXZXp! / o`PR怺NZX Ü=rs
0PSp{ _ ߸ޠZYA@Qwt|.肗} ! !$j{諐 n PZQjQb;ˁPQN  KPMf' G y  P" ËEu t
$=E`tW   d_臂a:    y!rcs^&D
V F&DdH 5 
yB =r!Pres uF. pNP$FrQ迄sLWEM rr
0*. %EZ
 
FFTFPfF" pB@ BF(	r2BB2ۀ~ z`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)P r4F$
Ft+ F P   !VPXV@"aWPWR u	ZX_À?A~(tZ PS^ۋ^&t` $ueG&uF{tt@]㔻( ,\ˡ@02AI%I   6  ~0G  "JJP3@b DQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 V|s_}|789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+Vs
 GHIKMOPQRSvv?QQxyRRES S,,ß  @ ބut蘋t u3N@f6 Vwu^ u{rнF@N`R\p ShtE uk߀ut!Uv
Ppj *
]]hh  	`h     pV  G$ $  GN N P P  Gh h"Gt1$  G   
G w  $ U   0    %rr 4S]                                                                    oS A  h ? {O IYOO "vPtF X .	˸ f&q &&f"  ?и  ff0._f.]p >` 6a  !ŀ.P f.""""" ! a
#
 
 f3ۻgf+С fP s fX   Q}RX>@`@&?   Z0%T u!uOǿ<2䰕f]
 N] d `d{PQ3 }Δ7y40rdr
` r`f<0WV9.GF< u^_rس׺sArD.\RǊAߋZ[R ȊQRR `R  pok@|R8AS؀u
RNRp	P0XE%
cE%~	X< $=ZT
 !
p#
P`VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P 
2    =_^a2
u?[rVeisCr"trS ';Wr6"_Qr
Er @#)/߫e  
 `     tKw\	\*P')0\;#$ rIW(" ߳ kÿ_!Pn(B O55B< t?
0@@r4;3_r!- ,-BFw3ɰDن@D|BPDȳʠDGADjQ <ʂ ~k<˓<˿ l<0c<%Z<	P;Q<
QH<pi?< 6<
ϕ-P= uX<<p<p XL]WfPCI 2ڢu_fQf7fSt$fѻ"r   f;р:tN紃 f[_^fZfYff r } fu
N`ou ` s r 2fSRfPPcfXZf[A@~ff\׊Fm׋5	Nff s"s t s0+  QVW&P|& s fPf&Ef X E _^ bTPw`;t
X2 *W 
_ߺ ϰ#t胢X S`~HsRQуuf   fPffff P8s2fYZÐ"Z* Uܞ.:f thu.V.f]w*VRރ|   +.Z^ϼ"P .0]BBBX$JJ2JBPܰ t
葹tJ 艹XuS` ~B V tA&q JZ  C@A P*݄uP= ]Xruŀ2	o
  (8SQ2<

2ۆ.
$2rvqd<w0
u@ð  ` 0p     м  G.>i- t軜_膢r t
t4t peW%2撰濒~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>~`~~<pff f { >c8ll8x
~~tp Q pp		 0``0}`$ff$T0xx00Plll2ll  l 0|x0f 8l8vܿv ``0```0 @ y <<fc0 0  || 0p0  x̯8`̃ <l 8`Np  x@< |pH `a
 
|x  ff|ff ll bhxhb {`f> @p x p
pflxlf`bf  ΀ 8l/l8` xxp$ x0  Px ƌ2 xp``x  xa"x -'0ax|k`` p 8l`0
pv!o`lvf0 Yx0;`b    ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
!/^uEAf SvN p.k2[]Q
! ؋Pٜ?8  ڡ PRS%` +ð ;w[ZXf  {{a T{hAE eMA9Y.nSSK  Ar( 3
`3Ҵ0mu N <tD/}QYR"}r8r
}r
2:6 v| a P P2X 01 ISAF%-A YF03COMPAQꊙ 07/28/06       F10_  xi؎ ^ Ћ:V ^+3f  Gk L!$F10fPfSfQfRfVfWUfUCES>Y  fB  fZY   tY  t MstpU@p o@t-P u@d@`tڰ 	f  f   tf`   t
^Q @@  AfZf\( 3uq 6l[< tf3
@Z>l[0 Z j]>Z;\ `\f3A3"P1t
 }   2 1@&b@`a@f >r tf` f  tQEpYV ^ GP
]f_f^fZfYf[fX[fVP#3!>\ t
"y	BC$su%&\fXf^PVW 3W V_t
r
>Z_^X \ɰ۾ݷرκʮϵܧ12D_D(|1 8     y:0  ``<~ "!AC=>=  r> @'Yar?  @@@?A@ &cD$	-E	I!!
0T!-A>q

( )))**LLHSJ$$J~B ~B>
y$$$@ $
 ? >""ZFY7dd  #<r R` h3x"'yP7V<DW!2

	" Y	

tI  a~5] 
   At"#1 ((DD!@&ba$$Dc$%#A X)&)`' &Rs[^̃ZbgAvijoWt@CVXeւ\fHݒHoߕύXIۑAOԃBĂeLphd|IeuN͍}JTp\FffnL`FڃMߑIOsځwE\KxuvQƁBȉgjڃymxtԍrmÁFGsʌx݂한쐬ȑ}ł񂠂֎~HS\zԕzmQ{ǑV͈vǎҕKvd`Yi@lǉ십ċNԊO_ӌUiTivI"ىe^qlC~txEؑ{pWoYڏMȍ[hxb]Kj{# - |@  т  0 ` R 	i D  Q @' 'dD ?W" 
 P '1!!#"?& p<
~|u  0
FA~% p? o  !  % )  f"	! ( 02 Ri    0

0ec M.e     UP W F  >"6>%
!` &dEG<"F {) BFLXp0Ԃ H(,`"081+d$Ad|9  1@  ?~!BC ""!B'  /!B#b&2 33`   $*6$1aLX +>=p1@@@a%!> + ,ـ @+Bft,0Ì< @` .0`  Ct6pC R ,B
ۢC@"BD!<| D~D D<P B f<,$$0$l= 2 I@ 3`<k%b<@ѠA |a  %rm  2 Q ? " !aA<a  1$Q$${a?yH ! {HHK` ?x d $PV` @@` 0!cc $2&f# `J0;@Zxxa 
c
{AHxp!
g
 `` !`E  ((@@`)X0$x|pTT T8QC7O-  
	`E0 P $&# ` g8 o & OfT05 B`$c  L $484(d(lD &1< ?! ?&!<? !!# f4cm[\^0  *L@[* R4fBoFJ@qdp1xi?|Cad0a ѱ"i 0`E!cE,1B ,2$9`0po?"#!!;  `07#	4vg 8s  [ @ |enZIi&0xCGP(Z/cc"d{
  zzM@^@40  #2Bb"6T$-`0|p.x3 G(i@@` 0pހ ߆ ?` 0l@MY@0M0s``8xbv' ?HbK)' 
H%0#$ !"*229Hi)""?"!  f '  <p$P$%)*$ $ '` ,!## 4ED`@/$ !   BxM)A$ U\7 ga|"  ""
"4"dQ0O!  0|`bsD% 6s &@Ea! 3?! @F !dF!3#:~?;>}>; r?`8 p9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p n%8 >!n??$C @ 1bp΀8 (~l =Od<<$$$8< "***" /"$'$&*"$" ? Db2b2U?1`		
	f?21"`nд `U%2%?' X p $'!E@ox pǌwc 1$&? l@ 2?$?$?bVVppTD`$ ~  <@ D=!<$"  a\5' '$'0p6( g!}@  q6C  H2`
8h(LRN2$2q2DRD" T@""z" ""sN0 
CJ`zz| ʂM@*t<Dtd,%}IHT! ϡ[@AjDfp P
 .:23V!&    D81< @F<qb O=$! @~ 	^`/ P"Tj|>? @1l?jk  3C1(ff2/ =\  | %~j  li 	b`q0@ >)2"b>" "~"B"B>B"33aH  0DP;6[e`}  ) 4 `22"R`2   @UF|Ctd pUD H G1$?$q81 FD @@1#f~(3H2~RHH~HH `~"""6_I 6q"c  2"&	$  c2A*b$?AS%aDh|0  1    wQ_RuL!3p    7  "r0 aVU 01? c0ɟ苠?0S""C 8o`ÈA a d W>sP 1π B %z&6J J)6  #҆ژހ   0H@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>z		E@e%f|Do2D"DvDTDD6 # a ('}/`z" o7 )fb(? 8ctp"}  PpP? ȁ#}
( H k =K0{4РSO  @aBđ=  u4a8	  6 a	`1pp	  6 P>TЅ  pVL D@@Bf$,892k&	aT%@@ BgB(@Pa]1 pxPX	O 4 c!!r! 3"&,0@ġ?0blP<x @ ^ v?$&҂X 8|	(9H ;)*;*$*_%+8"e aRa
BF0L 0y@ D2"##(#`F~TT5VdV!ocp @a>b F a9$i?$	$	`  vx%` 'R	0`
JIC```WHJ  	|!W~@w_*H  K6cccN8x d?~!BC  G#" e jj0P0o!  8&CW0WcCf0` ?~$BdB  a B
BB~1I8"&D$(-( (B ,!1	8Hk
 

=I H<H$H$I$=] @ @ŀ 4R$ze US R !P@555 `6y0 ;6@bPgAwawDp! 3 ?$$$5d$Dd0R< ~   l ݀t  $D$= JGG^Avq! 2T<oDg/$y,(8p(lq$B0' % @ d  H4b2C"cy%5@ߡ0lx<D?  /"?(/(/(hOX wa@`\A %+\ 	ppsD`  0  ""bp $ & "  `c@`?6@M
3iF>D@e Zq@#opa(00of?$P?			?R" N$m|%o38"5U QHU'@S8 0@,yy {	z! p¥>""	& 0">f` |sgAA@ D=  =  2 < % 28= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$TdT?DT n%%">?R $ '$!$34, g A#A B8`nU w$&#f!|ࡖ0i#!`  b6@2~Z*\*joI0A
 PpR 3 `00 B " xBB	 0#B~5G ͈x RRpF H0	   & 	  &a K$# 'kooogp 2`zsb0AB@  F>lxPXHL0F`C0 `<0ʐQ0b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`a8 ?@@DDD! 0!cN 2"$"b)) ?()()~?H!!!aG`_c#40G zRs"r7 rC " `ȄV(  fWWkp" ">a>>b 2  "&"cb@	"00P G  x   <10K3?S"aK@ (! ~I	))iIx	1!c @>~"}`"b>2л
  >A  ;z ?A5A  ? `H ? ?$DX0b)+*{I#F(en} },lbf?"#
 1pxbj|  8 70 S#Q8#C!'8<
`NS`'  > "~&%,?(l)$ -S耝Q@ 2!;VR!q #  x p  "**~*B  h b~B_$fw D0@ @A`#p`$ 
Ei[  ~  O2R2RR 4Bb.	A4[d02 /w" u"p  bB o?~b
(LA68ɽg[]CppC}8@Tl@ l$5?b5d>qc 	()	) ( )H	ߖp `c 5_ 1 aA#?~"! "2&460ba#b @#D/ ZS?!#3"y$G! !?! #! ! ?y@wp7$   @
0y!K! `֜s `7xPe `T@$Bp8p'|"@Acp>'$ , ( $BV@b.F D !ss	\3
D(z

@ 
~~@<$4 7 a  p }#@D"4&0PPP``? ) )?)  ?2"/y1cK{PApP	١ ~"6qw@7  "r"@  ( gd&Ik	? ~!<$d$$$%=6 c`M}R  Pp @ǀC# ~
D@     ހ uUp cu`U  `U	 `}@ ..<3S.:3~hp 83  [<u.<3 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.23` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VP < t	| tL^fat PwDXMCÀt	F- u 2 4.>A3u . 2 13 `.23&1 u2CQ2P Y*2Ȱ&P aB RDr
.B3.C3PSR  && Z[X ` Op@Cp
oo._6l3FF!.W_tOT_G-p
QR.683ƳP ZwY[X  4"2S2OsP2 sP
XÃ <r<0 <rp1@D3  F3.&@Qpu'r!	F33o!a0n3.>l3P20X2$CFAPQRW ((_ZYX. 2.9 t.D3BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>>3 t3ػ@ .<3G.>3r3OO#0.<3.w>3p<`X@Y 0..n?3.p30;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV> M> tj6hjFV^Z&  _hEo>RRIW42o1^Z% = Wۘb	Ga	f"\fff;
]th X)c@vs vS_\5Rg?[X#oX%2$>_	  "JsXNq!?PZRZ'}j!	f>Z%ϼj_t$_Q$>`XX)2
fPZ	(*Ya0$Dt"E*	2C"1rHx)#4HrSDJ "$2UPZF ڲ9:9;gUiS>P\>b~p-6by~ "\$\ _zl 0ah5"\;GB
x?IK{A̦h?"C"'EBGHfbg=JD
XOt;j9=)S ? XY'jQZ$/8h  nr[  tTtPZt	fh "Z$Z:tjnA;QtfhwL"bh >
t][t= tO3>[ tjh[VfhI >C*
$j hZfjuCCfjPsz1t<a&\ ta&\fhqQU ] t1+ ]C	!	f3f
~f PFPhPXhD]"Hl!uQhf!3׉F``H[{:=#2hR[
[h R[S<od V0(5&	hH\pƀB2F3]-]±		AHZ[+ZnFBhXFP
1t@ ~}jh!`p`
	 #Z\h\xAYI $ShZfVZ΁O^05%h01!54 VyEi*hxih

$:O	Q֊Ys*YA,^_ 2FF\^ F&<
u3L) u&*V&8\tFFP9 1FOuÀыٹ F FIuF"1 F*+҉FV]+;u;uà]% ;Fu	;V@]% ě*2]@9A9BM.A 
	
7 WQO` fj h`S:C-{ f f0]0 pX&XjLfPP~]jPaj F{PE`FQ#AbcP"ڡV=ut_ Va @)# GF| R0u22|[^ h o&
 F GP	FNuWFG0?7 

^yOf4@WV3 #  DA^&@FG|埿 34!.6 "1 ! &o FWRQ`Ã rQ16HF 9d)!!!jAFߏ2 ڧ 1p RuV>]YA	UI<bf?X#Rq5$P
2&_Z%  `Z1o!T

&B]G2"\%@ +1 1B]j]RSpJP\ @bLu `Z&@3	 b3	&@
PU!]	u9bF uF3FrqX 1p!
- "`P	c`?1
2X%RX1_Xj_"	3X%zQ XjpPqQPZm1ja	#te`h~{ 3++ZjD"^!3!"J$E"Q &(C"!`! 
$
H"#@ 5 s%$N"% !Q5Ug'	5i):d/jS+*U-4 Zj~B0n1g#ZZ3Rb1Qp x8dt*!5
A77A:Ft]q8a; ##B]t"yJ<<t#AzޟK?-t8P1XAAZ2{P2/0/FQZ&Z'V&@^Z @MM&`Z߀Z_QQh  p\[W {0R
 fZ RߴZ t}
JRAbR8M8:sA:XQ@ ^PNF̌]^F lF&F~
r舩#2Or#h$ FKnA!Z@A!Z\u1(PZ(Z@zcB+  g+V& &g[?&[ &` &J[N^~`]@   \Z[@    &\C r7%!1F1쉠	pY`E  p  V6^aF@t
 2tJ[ e03t_3uY&[[ [ 4 [59% t" t 10 `
A Dr	60*@@R>
q
q
actzO
um#Y>Que̡p)2 V&0  l[!j]Z+!r΀&ZY茮nn@*EA&$.Q'"߹Z$0` Z`P  &߹Zwj.j j	 j 27vB 7#rÕF@c
9VB&D]*&d] &D]Q5&Eޣ +&FC!&GC^&ƇD]d r0 [hJk`7сM2JTZAv|K0J[&[FVTQ9 "qH\$R[	s$&_Y(q
<U*0=,rvR?[hH԰+]uP4[ [FVH\@t}]ah$	
bBZjgZ#Z	  r`  c !X|I2.A202ZM(vZagZ\a"h01 O
t%r ЋF^Nr'~#tp  @y^    % F p)`j^  ~u +ËFV VF4Ƃ4~ r~t` t uKF>v
.u.~ uWt
ƆƆ psyVsrO
Q ^ ^Ap)M~  f# F FB F~P|v^߷ KF} ^NFFߌV~ F@NHtDHtqH P 7|j
$]b`k
^F&? ujvAYDH1,([!9& u..Zaj:-RXV!<A0YvhYxi@wNN׍F@/\wv 'FQ5]FFP縙]_S^/GFPv4F]FxiP'1<kZXPdkZ9Z@g2V&@236a!p.FB@~2|FtFʲ*}QW^
6~ʠ6	/4O _/pFF:VA(FQC94p&~ t;F4.F2
z u WV~vN^PA@S
!1@
^_C
"j(c
l`

P)@\pr ,md(|WVvԇNsODPTHD D~(|W~(I0Lt_~@u"rH#}H0IB^F&W} 
 J
.pBΐW!u@## fXDi˖aҶ	
%%		 	F*P
g	}`	
g<d-UWVv<Ё~P F
&GFqw&'k*V~ߋʋv!^PF}GIun ^&^&8t #^^}j!#ù
 0GF N% }p,-Ar  ~ ߋs԰ NFN+;u0g0>3ɋFrAFC&PfrfF ~hЋsΠG^AaQFr ~
?vЂzeA~ r
CVV,GV~^&FIa&a8}FQ2^ZR1p Q>d2IGbf?b*6XX	= q0q3$2b
2&_Z%+  9r(A	oɳTrG̏"\%@ A"\1$\j]RѺo h N# J-& @	 	c_bٺ3X%Q
X1Xj`R
2X%"Xj"}aP!PZ1RZja"M]a	 (\=3q$s$ZjDZ s3	E v
QC	
	H-N.

S*U a(	 g"A*i$!~&
w3R	1. jyQ9**z*,**r.*t.xr.`0i0{b0iq		h 	EHE'#
4'#E3473U- :&ZQZf`f   R[f	 H\   ] Zxi؃2Ш& 
BZZFrVu9ZW V=@#zFRcC2HSJӺBZ3~QY ?2PWVvދ~ &F<t<
bcrԻF*;X}7axy~tF&8tFu|t<r2DVp~^}u	A(|鐠 ~wPfh#  Z`rpwF;rF f?=* F P F*N*ȁ vF7P0	@@|v
u+\^F  FOu]f\~ &\wt&\ q0@ ]% = =@*PIRAu]$<  2]% Fu! = {* Au*&]3rWQx]1]A	u6B	= +ɉN3]3[3 Љ ^	u&
? = uP`HBAV
2P
u/&	u##			}] 'FO \\\\\	\\\
\\\\\\\Â"`>Z ێ4L[>XA?X6 6 &=  t_ @3Ft   Z"\#-//

	
88qu	 )M7f6Ĵ &?&T:aV~S~ t'jPF@:I 22/ u#'j |<q Ot=Ë?3A@ >
u
[&["[2[1p   t&[S1`u\ &\ \Z\m[!^"[0#\\[]Q[XPX XZUUQ[>u[h hBh R^p2r@bBrUsfR 	Y"		Lz	
?
2÷  P)MFJ֡ An0)M W`$<W wsrjJ_ eKڀit&h\X@W&XEaZ&aZGϰ umfh  tfh   vEbaud/c
_!I$!MYC$ ˢrIBRX4VF&? t5w(u%&|Rup )u@DPƋV@RPF=FbPx_fjA
0w  	 P  jE~.~puq/ u v&PZpF>`t 0j  M3= H.=
tc-
t\-! - ; - p  r= M -  -  -  Q-   8Qۋ  &9w&EU 6P  VV 6ϱEˠ   9~޷ H  ;`!P~
f
fF>~ Kv&@u?P^^;`vĴ 4"fjt0h  <D p <V0|@]  ~jvV>ĭ vVP*^&p^ ɠVP% 
P q h
 h  <RaNF
+F@F@!vvo ߴ	F<VNFF@@{uj qCFPNQ=`_*Ps``yWVVW  3 3_^e9 #<V S!F
F<VG .
#
;F|!% /F@P!]aVv`NupDt&@AF삿`Qpc~u< tt (.`7 P@5  {f2rX F
@tሂ~sv*VA 
ơ̄Ɗ* ufU  ߋVn'] > t=ur3NFف\ |p]/NZ&8tG[JvN! ؉^GF
`Ft^ G+tp
뎐V^% = @ʃ@Ao3t`߰ߋ@!A;w êWV> u#3
1&A *;tsr1A */
@0!"?F
t t" `fh 
CO:@P.B@H?Vu	.SEHDa!E`.(ErVu`5 3l|	#5d7RP3>>Q XZ`E~38tC8 u0~^
gAqGPBJN3~({~ "u j X F;|ᔀ;YƐbC \fUVNVv<%tF` u DD^ù
 +0NÈ u0+	D
T:FD3Dj^q\們R`V!S@bVctQ}вO;v~@K^F&uዓFf
b~VbVPW}   m+΋э8svf3a[ppN&8 uNP= ;t&@D/@ѯQZ f Pr?6 }k+IQp^yYNUd_!vaqj oaWV6V&щF3v~Bv0Q&{ğ`0(}a
;~ANuǋv piFˁRЉ
~[P{ VҰ \PQP0FP~ ~
~h3ҋ W2`t4]P]svKQ \ 	y~GWqbu ^Pa9Fu
01_P_ v1ѰO9FVPą0ySv"F9F}+F- P@!$!uCq_(mFF`g/b"J T\QEP虁DPAQ2AJP:|Q!0fh  a39>_ ~jy/Z*9>u	QoA@0A/\&7k6m);
G;|2*& P `8A	kFqP@oj  ʑHjrw@V1NV?RPADA/Qd>a'? $q@Ry8"!i`EA +FFQ%Pa#
д0A S a<;aDPZQ+E"#ڠ<&5 O`,+F+`M*2cQ$zR@P9"=aD=	F3@*ǐ*A;}RvsV1@Ƕ%g*@F;{vwP4
R14t

uQ
#aQC4
eduA84	wP
V iNBB&-24hXtYY;}{`=y#DȰdf&D&[Tp3p ~
= @@&F?@u[]@Ft^dF;@Ɛ׍]q<ЁN bPO;v}}Avѣa<GF;F+F-}	@pFF&Ev;v~ }Qm~ $	o;FF	_F	} t~0Vgǋ~tOC tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F\5p%&L
q DFF 0J @вϠf@`	Pf@PFv^iEUAgGT,2s|xb<WFq o0H&vSFv.!Fڍ\ȐΒ #R@~U \3'tsqF+FJFHfh imaR( tTXT4_v`.9~ ^4aFePylk6,+F!}apu.@Z Po &OC@ +σ_Q.;+ǀ
0|wctOj[(
PkJ`yB.=0a"j]1yhm0 'YB0rQ !!a2#$QBC}ܾPCf\pL@>\\j Ww 
Ht8-t-9t- 	t "f 	!QF~ tfFf\F@F
Pj  v
u} ?1ŭpAj >PHPVpos
芝Ϲ&wCzcstBPؠQиN	VV2F
ta@D% "QDbَQh
VQ6 B tDwu33!
a_o؋!bG C pDPk*. H!Mb9>u	 ZP;:QGg	%R4waiDu(+Huu @uqt j	j/fham	"	P^	S^P7qf~
 t

a}lEPzU@ ]2FY m DVV~jvv{xX 6sG ]3?鲯S3900ްPr~#F10cPqE~
JG jdR[807+$ }/p  9z]tك ##/E=/豿FFPFGdpg
p ; ;NNNoQPL @C7 r򠽋= K = ;  -Pp---x{АMFj  Uk >@]`{ P;v1!;vFPVW>FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk'-
|5. G@6W- ;sFc?atU tP` `0a~9Fu
VVIVFp9vu@PNPN  PNNF ~9~};V 9vu< uN0빋v T`ߍ 3P Pp & !VN;
u逐xA^F;~m~aXS `
$~Du6?@] b_;|qT/QN;v}wO;഼6 Vǁf~ u[?FApL倰 9v|GI0Đ0%9F| ~-A{^&+^& 'F'302Fc731vGށV0.tCq u^ GCauK  K .f#{9Pq`m!ohb"rVt ;tt D@m~3tf4W_h
 re5@6LWV  Mc [ t\@ @ d lv[
ttUALDTnau0!O;F~ Ppف
rջN@uOp]0
<U|<7p>R[ u)>H\ td>] tl >Z ttZ l}h<b  ]hlpu"jhXh>V} o
j(h\hPWVmZ zd [hVMhZhV=^ V-
 VYhV
#>VaC%P \3%	z Z\#% [% Zz%	 Z`kz"
 
Z Y l+(`4`+(^_Eps= Ht.- t'`tF-4tc@[Ht- t4AZ/Q#Hjh5pwt1xt߀D/ODpU*䊇DuA*HЯWvGPL>t0<@v&Sy 554465245rt659h^@j h	Q C (.	7Y{ P	$觫aJj hư|"Ћ^3&~/tC&  v&8 u@*C;^k|ӣAFP98Qkϡ@]э1gd^Ц? tvN~ _"vVq߃~ upv@]FG&9 uԉ~i0N0~FR =  -
-ꃑ!אRZ0 <5<<V<s<}<R<O<`<Q<P<L<M<G<H<I<7<S<N<J<50PәI-
=\Ð8:(!;z`3C,"u+7~ 
0 @
I( `
 
} 
1Z  0Pp$ՁIŁ@0Pp$݅NtJtytsP tm;u< t>]j*|^@0r~D@F	 p!0  w  t":uNj= @@. Bҋ u
~)jcN3ɻ~* ^
؋ފ^&8u	F;|  b܄ܐj	m P 	/npы0<0p=c4
Z$  *8fuZj]8~u@qE	tP3PF |n FP\P
t)f3f_ ^f}h 륐j h}"WIz0v*u @g3y`PGWiF0	!	*QHt  L= t	Z@ &Z饫 ݐqZQu}	7 b	r	z	 &x	&	hh	h =aA4B x	@	@cDtp{	@5q
&p	`Q&Z&?Zd`\m\aW"  !VFP*^ `	@W#'*"%"$CB^FV^ W^4" D~&C~A~,A~3FB~
A~{4	@,0z|#ehZj2pj |	P	PЀf?sVxг0zbzW$Vf W " ` t&	} ;  	ME' +%bhG@		) C dhl[j SpC2	CV%  P{ R^B/ 

$*ZPE$840/05pRTRrRVUds pP%3W
$
.
bDP*=	@-z|骰}9t7-
= Mt%
- Kt0Mtb`Yn= d.Ę ߙ$,[2@0`  8&V0`'R!"ս,20`  PPWu}/qU h@h S  9XXX 	(Y&pYd 覊q=W	ZZ	@4 |	!@ VZVZax@Vfhh RY@t&
 
@U UACCCU	л	! !	@ZVZV{	$
r4 + (# +-+tp*tcm`Kt
- 7tu] &3& tGu quhhB
h !wu
j8%Ai&AB
G磑#'$''zߐj)u@{
@A&@
)3bPf w2p6
GAp>3+>8>G>E['>&!>/>'>o%>#>Xj?@);; >VtTh h
	&Vb
 j` &Vr
>BWuBWpqzaV
遠&b
_&rb  tj
A!@@G_>
> 5@Gz
G8ACD0V?&"@EPWeDWǙ#>
h @вlR#u+C 5 1;uE3\cB"M"M@%M@tN,,",1pCBW`:H`૏	6\t|3ɻ
xi &ARr hR/%u!j
R ѶpE&C&ۀ@	X$Qspa!tD)V3%,aWT
wqG 9}lWBWRy&}_ȶ.!
q{}p{=$ர0^%@Dt2w$$Sv}4W"扑p69P8ǢJ JJ[
BWZIQI`
fh%ahN"h iUyBpHgbHUx
fjj7GbX
==e=Yt,0f*q@t>tb>@>@oCor
@Dp0k;0C iHH IG܀IF FnZ
@MXoDW%I&
ᱚ 貜)` M  T0dҠS C% E0"5@0$Т@
UE
@4uRP
E6f2& 	D4
R' 
""T
~!@E
)KH4" 	lh|֣ (Ѥ N1p 1 a1!`d`^@FXnEW  "^ab@(DW 2 1 Lfb }
@( ] fDWf^ZEWfhI  H
f^ZfrA
_7v
v]a_Za:0!`Z0ڀ&DC<!>a? @̪DC@AԄTaa}

@PPd
rhr.EcvɋFFPVhe~Rv
WV 
TJWeHtHtHt$Ht-L7HA+ A@3!!>=
G<^pQ@ <%N$Qy'`8@EDWG``and5g:%B
E¤
!
Ѐ,  WVf+_fF@ ؀  FW^F΀ F FFF}NFn`_F½D== @  -  -tR>  - -*t:-~@ ߐ=`+-   vbC  - t}Qx$Ht/Ht:HAC 6  1(` `F!`"!13 S" (A
Fy
t)j pPPfsVt2;煹h}XڱY !fFgp h*HF)M~ f fFX^vfvvFPvD5FPu63F`.ʃ~%v슅X :uFG;F :`d~ t
&@}~@&pUQ   Q q t&qÃa@ߌ?"?Ht)3Ã? ? b~|b{ܧ&P	q2Q>JW uÎuHj 
3v0 R0"[HWf2fNWf W n  9F_hڦDb R
HW[[13P҂8-9t- 	t #`d
=  *@fjj a
i 5	0u.#JN̐
uh оƐ>W tuqfh  P	&-NRk>n `6
)Mh5.hB63WX& n  F |b r\0~ScA ׀>p#u>p\t&el6JW *hv`te3X13
>N*u	> 0!jj2V3tׄ;3Be'kJP t'z{80:2R%4;44  `@ǟ qAр!Fa"@[$
}$4M*tS?=<=5
5
#.I@a	P@Ba	  fh+rD_-qp)np$#;$ %N/0 X[XXZX[P·Pr ) Z%  = $4&\ ]1 52 詳Rb
b
 Ԓ
 }g
P	
	B
 Gw0p֢ Dt,-
t%-.t,-	 tE-
tYt1- t/C DpʣJW:B~AI _p}}y  oUDcV[t[u&PñP [wtu
PH Hګ[@*@@&88 j 00-Ǿ0@ut%;>_}`  {PXr%_2hs`vpjtXя6 ]HtHt `t' Q {hiu
^_ WV3>
 N3һ
 B:rZ׃@HP@FPjRw~ ѰBrPNpDt Ѻ&@QHPFV^tFj&u	d,j,,,,,, +,,.l>uh hxih[ h L jhN@c/"j@t) <3҉d65P@;~@)}r݋F 
h	΢	
B{
R 5#W<B6wf
 ~Ĳf\ v3Nv~FV
tut9v~O|܉~*Pӈf X^3
GF&F 	 u^*ۍF؊F%@-Fn"	[6FV N; 3V~&Év 9t
G;|FCFvBF  ы3$uG

41t%I6%|bnpf,Xfff3a`
`,Xt&4
S4
 TP$@0EX,bqĲ汳B0Xt&9$\$
!ǪT
5 H@	d
A	2X%rD@^3D
%D
tF^&oF!u	 D%0$F0&EPR	nG2`
rcNQ3ȑ3=B0=I-tX-+- 9=-ɚ= M%-u  t!M-Q PN P{= .ķ,:HVpa/ /  22+1 14XJ",i2  16CB !^"   Π,X,2*,.X .-@ 3j[@ jhO&oe cg`/ /  aP7@ qjwQ5?3D
l=$'G`v !'[]C؎UfX<; A"#~ X],XX$ t&,
|v	&<
,
4Q <K
@D\U}@ffhh 1*
fhZ T*"2(
B@e]
("UHBIHb"
Xu
}!
$
@B  fhfh
`  	
hw
rZ t>
4Zj `Fw\u`
6  O hEˈF<tFv
h.Vx̓ZtF V$!FC|ߊFoà6VvM߈ǰE6X8Xu^"0Hud`l/ ]JKY fd! Y}bfPY@
SHEiRͤ@iU)	!PUDh0J 1oCXn_Ar=J&^t	2	lfժwCb8XWy
U"{$U&}45cDZCD

%-3 &@+16]8X"*Յ4
`k,"o$oL"oN"o o
(- n
- Kt ^$bncn0r@san`ncnξ HXhxȿ޿
`7ak7m mk`9k xaj ; AB@ 뺠:-ـ k<7QZd&7X\ 2 % 냐ru b@Rw;Ā׀(Cu	i]!c")# y{q (
*t {By w`L!p!x|/$ P AbMPZb֣sfPZf%60^Pq@qtA vA@!b0CJ&D&B..eFFCt &Vh)跦`&? _t
&^@V@^SJfC	fnD	Un Av
vU@~~C	
@PZaq@t&6fhCA}DKa~4"6a>>@}Ld|tlT
<fh`z^_h]P
qpR3tfh~h0$^"$"#h!W~,@'1&lDh,rgà>
Vix>x@x`$`ClJ fx1DѠ￧Qip@
Ũ,?
 H)~$
q +] $] )]ŗ Cp ]- (] *]ؠ` ˘ˑ  !˶$|ĊĤĲ  @!Ǣ>@X @[ *ab[@\!@@ɽ 2 L wŋ	_"\fH "\f>XB]$t	SN?B]P> .z  pS  dKL`LCB<RMbK$OJ"OdP"GȤQC"GRIA	h-_ÐJ[t
#k&CYAYJ[@T&Z"L$4\]&d\@0@utW ;>}`  rhhQk-0FDX8V& *䣿DXPeA u$ 4 j hp_h0Q6  t~@ N>` VFZ:  0P训 j 6DXzpu.&> Fj`&NV"~xqXggF̹ǅ#"' Dt,-
t%-.t,-	 tE-
tY- Ht=- t/>C D0:> ~/t}p  cQX	@Zl"~Vfv?
  ^u  8h HvF@w:tF&<:uFF
*0N&$  0
uF ~ uF	 F
 տ=
 
 < w C
v`
HA
jq(^P蠞Y2
ag Ǟ0
~ ~ tmhQ^7J~ tD;=濦=u5'O ʋ@pp

 3 FPPP!WFF9Fr' % -
 ؋1v v s0d ƨu= wѹHʐzʠʬP	~FPX.&y ~ t 5F Ta  RR F^  :PUE " { 
ْt@~dtt' n2=t"+FI Nr^~u@P W    I߸ P @;FVF^ =uFl6,N'@,,'%uÐWV6jvEh"hrε?t*ΰ:6 faSK ;ueBh@B4AB-AB4ABSAB?gBꑀB712BFB[w9  C"C,CDBћa
 Cp&#=P6f+fF@ @Xf e X{V^aEFP6X؎ऻ )Mv3+Q OYe& t$F   fFf~ sA(GuhhXנdPfQVȡXRPSQfXfYf3fPfv`fF fh  "OHݴ`fFp;Fv?jfTAJLθd PPW@NNT
MsskbhE  p p4  V_6`qrGqrk		% 6|XD6\\ 6\|r<r"qѡk
|V073530.z4q_SrhhSvQ 7FXq	HtHt-@sYO pY  ہ> tO"/t?Rk h@p@vd>t0Rgh&;hPp"?
_K?.'.?L>)$6^>FX+>K/ x~ V6RPfhWXfhUV芰
&HXh`հpމ^	KKt&-+@
t/@-Kt
- tA,HX2HX% 1p !@@TqYUP0HVw (:?l c׀&ܰ >txJtiju,6_hlBQQQsu/"n fo8Qh/@@T P#8mһ%1^8`YQ;Y< sѭ uҏ ^a7   MHz` KB1.36@   K    Restore default system configuration mpleted!  aPlease press [Power Buttono shutdown.a <  drivelock    B C 	ut`Setup  <F1=About>  File  SInformr  Display   Ds.eC  IgnChanges And Exit Q 	 With	 Saving  o Security
PassworPoU	e4-OnPort Opa gVarious wrtsP Th`
TDJiDLĀFsHmaCard@tHSuppP) TPM Embedde.v;icPtat@$Availabcil P'Hi &O7et To Fac7(ettp!sAut?hentic7%ܣCre0tiWal po.c]sDia*s@s HDDp3lf-T?Activ`  Mem.
Che8 r  stallACct72L@2uag9elect lDT5  of grayQ4field Boo*pLbo*;'dBuilt--t 5#in5PPany key1PT`ue F10=, ESC=Cancel`JDRAccep/=Y;esSNo F],PGy o@#r=M ]+Q For addi1]/al iQ @^
T,  ^]reAf] ](>DMshBUH:wadaPSoft Guide. Ub~AfollowAP2`stK a: n^->  SPACE = Nexi2^-B'ACK vJFccTABE#d?SHIFT+&*dgF2@M+= c c^J'Manuf@[r  Not}e ,k ModA"Proc vTyyp@mSpeeZteppCacYSize (?L1/L2);Q? ROM DM BIOS VersrSer E SNuP	V`oRRKeyboDYQ,r0D{*nbQsndqVBat|y I1|23b45fAsWra	
fOwn~hip Ta+$(<d
BO3O@
GB1CV&UVX:%$ \DZ.   %F[^JErrorjFm% Wal"00&1&High A{ddRline\!4 Al0nQePBp, FloppWarn@: is 0 Owill  boUAh?VrsabqJdiskue  vcremae/ GNin *t2@wR| fxR0 A: 
eBd` was n0jd`c=) Uu P@Invali5from
)tAyouޔ wantp   ª?FO	i
`e Qs ib+-A(QuickL22[ (re`s 3 (S.M.A.R.T.) 1Eex Qmin): 30#@}&g"0%Suy0@pp@by h $
0#F!up6:1`'t4	QUnknf0qWR!mZvoRgeadS)doɀ1)4G ଡɐXrib:`w01d0aP'bG H  Old pNew| gify nYBEnc8Off OBi  `A 0E66vAKroE  eб mu@equdV
r`imodtQIzmPcaus ĩabJdch as  00п'ӝN)pB!a.` p!Ƶ>T@@loss ൨Y@  only1KcSof 
agoP{03~ev  2\?pZاcGishaR_ed? `f \tж JIU"P`"TTool0 VPPr.$@F8THգ BP fѴsuspeAnR0mp
`tWSF!Jaqvps .Tcb 8SY?%3%,% `g`4% 0#Bf p0tnd ep/cunu=*R5#En)t `iRPInfrāPCara%xQs y}a#MediarOIWA΁mk`n LAN Ambi6LQPn  USB 1394cCb.0Slo[xgaa3CD-2e@ [BPr qQΠ
7b!0d!PhѶr uRf_Q b0USERMAST `~6pepnTp@0fcaXrYQkeep iuaPe| GJ phys0&lEsepmr# =c.  `1EbKc
,XnW Y]unk 0  lmOO^AutoAcE@d@8< H<6"A 	T[t HhO
JGJdurEti !Rb1Cth`U:1tw  /k edoPerhfqdaffP+b{a,xssibqmaQpigiXGt V Is]jpl r 4mmR   ru@Ylm,reGpla`{t t (@~4] B Ԕ,c H?;2@v,`me,@K֒`)00pyib~Pty. Ifbdo"w6.BESCQx.ȣR T Rty)p'<'sq8a2F10" 0qBBrm`$`/}* e qE$ MiBgg Orw:tS ay BV ACdHSDPAB (left /h!tetqu3vSu`I Z;ipdmFir @o࣐F`thv ifp Sixa Nh E!|NhASwap Fn/Ctrl Keys P җAcU.S дd0cLegacy
(Dp6y,<Pr ~pry Vo} a NTSC@AL -J -M+r`t
BidEPP ECPd2Asize 32 MB 64a FVAlWwaynOi00AC veWWAN D Radi hB/luet h@5/rS;ch1A Sav"SATA N KDv1CotCPUh'F CPge Agqs#S`3X EP@L012-d/)#1}@1NetM KEJqn`m123TokR 1H	r m3õl  SpPSt@ Tech?nologyrxtAfUAdap'L0PXE RPL&MPopDe7( I0 10  2@ 3 4 5 6@7Fs9,bYF12O5 15@ 3 (Pe@-s UGTMopaWS NonBIOS DMA r(Transfers] VSan z!AvQtk sFa]2/ mu˂CPbomo s p! a Ple![@e s11inb  C dRse0 P賱 V҃k $ 00.0%le!bi4\#Errwdv fy[e R ı cyc}l\ <F1={o>Bei Si ԇ`|OazeipgYein{llueP Bj-kgurAign@epd *nicnehspepp@V/%#S"heitsfunkq-Kenn p 2chalt(Om=AQluss1qVp4dpne Cs.`'s-ID` -
H
O
S@~i"v Usttz!  Շ0tifiz #  boeim 'st\TPMteg"*tu<7nHsvorr1$"fgbarkGe?rts m!bnNufR3n zu/rckz!6OB 3p1@6@Yf_g{mքݸ*prDia09s@HDD-Selcbs00X) A1v3;E$:pr4g < p D =+Dra> swhG3A 4"K2gran Fel;dsLrt-e; eKc> F'%Q(˭i`<be0bQ
T>q, um 3gfahC`=A
=,q=AbbXWIkz!etTJ qqN\e, JY	=Mehd$mbe@9Icz fiq\0?A9bPQt KW   AAware-cYoft h"mb Pwafolp40n ҡKyXrron:x-> pr@D = Nch Zdnd<-R!;ch`}t-`VoAma'GTabulators2* Holl+ge:_bmJF2`@
28 = y8wEsc}lEC@E-6!ll@oz  uypRr Ntsg5esw#igY`Ӥa"1dC@-E-Gre ?(L1/L2@EGkapazitt P-@Ф -u`אnnumm GrafikR@Tx;`gr-g!woDesk -E+2ps0Ck	?8	Akku O2OO4EU_esihq3(F!k 
 
o1
oQ
oq

/WIHd :u$hQi .  C %'"bDr-!FeerKH`alZero-T<One vE0dހbAlPPaurnOBew8 Irq:es7 stpYbisLTn@*  ZiEpU,-/W:Bbߢleq_b@_or ATeib>p0in Lauf:nf6
lWge aKv/+Pt9 gl@`OL_  MDwirkal@0  q$Q?C$S |ҋQdaь
aie!qQoca
۟41 (`bn`I82 (UmfandJGQe&fhXdau(Min.): 30a݅d!`%$C%`he%O=#wu=oGpmp%ubr@BrG: kan5H	P2aUnbePK#7d4^'rvo-LB 6.
4C`3ShafAttoribuHID0a3UC1PS.M.A.R.T.%[0\BQ;s Neu0s@N Dead§ usaJaS3F>/t Fal
9g0?bAfPr9U"4YvbIdaDurq<#as pesSV<  mg?qidX!
fQF,L +(&  sϣrPva. s Zh?C6enlust9.hb sENAnu 䂾@ޮ,iceQa@s ,s`&؇! Ц B ha  crgaD	 :	 x
Wۓ? Um FunP}zu= , meFYӐjHPQztectTooSec@[ty Manag3v	enoЪ?.F*c1|'QuickLockSMund01 &PrqMPS.!P#,$biePS0Übkchutz  .Adminyo310h=im$& "+q A)~+ H* WX"d9;P#, ls გv :Qm0%I J@cȐpґZ1 ot-Par/e  v:-]$p 1!7Wake-O0AN L t  USB-PF1394-A% : C<Bu7s-S@+kp ExpmECD-ُFPee#MrvV: n %3:ymd"riveb/Fy@  ABD߁Ɓ]E9-#F\s m \@GXunbraobar.3I#T
h,7bewFLs ^a",
itnc)uހX L.eQ, r1h\-E,  ҭqɠPcBDn<Az 2³V3^Begriff \d>rautomTx~ X76>BohlvEmbedde*V'{}E>Zw@knUa8@n 1f&`}%2 [~,B bmne n Oquf `OJ#`СPN}a!sf!sfemSvt"<sEvXcAߢ"-%fnDBXf
gOgE`yagubT'qSūKs thaa $B һ Rŕ3#΀B*H@w  mZursprnӝHD . Esdr<q@empf.ч	 d=qz!uA1OL0$`. _S Е 2s, .0 9@򵦠Q 2 ⶇ 7 @a-9BtDenԧCraIt!cantVf4܀dibsc-!&Kk&p?lQ kW!'o'Z@[a F1A0eHrh:v m`8ˆ& sD l` Mu.Bayl Qנ"IUk-E! (links)QAtn"-F,abSuBZip 12 3@456* 7@89QFn/Strg!xtPo%dE|aC W (USA:Щf-ZePr B@iebssunabhng`  Dr Grafik?-Contr!PrimSek¡ VideoA- 1gmn4ǿBidirea?l Gr|Us Lf`ipCntzbr WW/AN-GfcBlue_tooth9URnBв/a EgpaN|ݰ SATAeDualcore-p AlaA!s!BAkkAgss u6!%hs0ha}C-06(o)u`! ֥E@ V7U 1O	203>To\R CF)2{}1Al Qedpp  `hnology	xL=0
adapQ`p0m2,zCA-!ppup ( @.) da9u ԑF9,qfWF12eZ IpC IOS-oDMA-2.borayPRnn0kr T-@c2gP7ch emPG5dc l`A$.DٗePЕ` Compr wdVoarRaomFRloЎ AThQв"Acib1Yb.Ctr`.y00,0 % abdFcLFe rQYmQT
jA^	so ZufpsdM-Zyk opstn <F1=Om> FihSloplysV эne Gt`ar$1nUkonf@ 3gnހ\r nr o fslut Ar 1F
 u]akg mO@nkkd Ad#ko)dr#K!s\OVp?hPstilЕ!9h``p9p `  cT0-idSq	`/
SmL-k0sfGoddel af 7pdO_  TPM IndbyggO""'Re
cpFg0aT  Skj	_w Nu il A fabr 0 UAst`Sgs	7fq]hF%@#+HDD-selvtƠðHuko1	 ;ѩ!ainҮh Sprog VǰB mo@/nedtЖt !p3q{(#ErE2B!oA=0>fTryk p
$ t0?F0R =
, ESC=AnnuCBFs!1,{JaNej "ΒO, AQ=M0Om  Y$P&a@r M7Z nс?Setup pw!|du i1U _i`jled\n H \RsofYt aru`  0XU]
u: -> r MELLEMRUM = NqX<-TILOBAGEPr1* TAB&R%w?SKIFT++zF2@	Z+ ?= Accegp!!jduc yǾe0c2-typ h`@JHpltVce (L1/L29qKo   psbx~ipArevi12a-cDa@z-bAa WcBAOri 1Ze2o3o 4z@et-taejи15(=at!)	O3OWITS :u$ T@X .   %Y] l)y`!f0=mis` 0'Nst`D1I$jPQ tn#jeaqd!vard: DeP h!r sl!%alt`tP2L_holdUABXo Q`/0Jskab-  `NxZ\਱e k1kyPy,Q 
v A:pܒ  blprfxfASUgyldig/
ffraWAltm  <ngivrb`Ú n,!pavi` H]un?O# ic?@ K"'1 (Hug)#(Omfde) sl + & (min): 30 "8% frudf`"7nsrCqv 	afbrudF t: K0Т&Bd!U9CS")C'$ervo(Lsribut:7 IDt01(odq?QyY .M.A.R.T.5@Ay1FpF9X Ny  Bekrft nDeaCŦ Fra  aAk1:!5 Ъ		=P@spG 		ry  k0me, K	Z`es, f.eks. `pbܑ a~pntific	 @ǲSHǅ< bTata. Du b!un  J fl8UlemZPv@	h DYC	X?@eD0pTb "A($:ЫHP  tectToolskK? Quick wpauLsNmus*SkcrpPamg ,r0Gvt XhTAdLi7tori8sa1,$/`H!'#qnoSwfr, odie޻ ubilpK2"Qll qp plrd Parivlash- 7POQJm@@sΡ04 USB-e 1394  CoBuso-sloExssQ$Cd-rom-и cY0:BG HoP2%:Be	u䵇Ahy1EWX@eǆ.  b+BRUGER-w OVEDADGANGSKODEN,:`\U alx@Nu,s nBi ,opbe /P0S  04&#
{	U
E# lnT L_AJp\+hjlpPAutom0DdEPJle!jQA`TfSfu6 perma`anvB>ig. 9}IyXp,''fys!!1cArbAucompir.&EDDLQ, tN
;s   l+EoplKni@ @ukW#E4`Tm0, D#-fOda_   ӟD~t. UrdSm> pviQ"x0l/c 
rkoaӹ B0/cY   xbefal`<kraf͓PNs,  'Bqˀp pla%dЌׁua}@
$q  &cP.a#v"KpCRr1Pd i`$Hu0A
ybQβ .ю:OstrESC. 4액`enC or` 'FG'B@e@F10FZ1Nsg
j/c`D+sie  Dfk `BrЯwgnOprR-T#|pIetkLDS@-baz MultiBay (dLѱ)/%hS)}floppyE!c#| wSsuSbTziprFrЏA1TredjFjx 0e SjSy2W Os Nqi ̃ Ski@mqm Fn/CGtrlգE lw(aci@sk)pegeen`UQst0!
udPnPŐ"rm-cr PrimV Se d Vॏo Ou얠¢ Tj`StrL@>1ohuko nэ BBp< 9t6nr` kO@trmcgt WWAN-"spioLBlueth/A (trdllo.netpP2	@dAS_ATA-n ~vDu`1Core/-CPUArS0POi Э UCmsty orh@[V".00top !Q2b&2E;thqt 1Ki23KToRRH$ L	e+	 	c ="X*ёi d%Jv.popup00kj"{(0.89,!UAF12[=!-:B@[begrP;pzaʐ BIOS % DMA-r:b2$W ( pa@ttF )l <{qtCc<ql%u "= P(#~zprocesAaprl.
e00,0%
DСodfejl2sfic Rlkrcyklu  figuK;masiil`qinasGjonVP HQ´`o4CkEAk1"A Iv l  UR$,la X LhEsgrT tp(tQ) @)h&A|PgK ZqmBB#tPb(	5-ۗfgunk Sm JH` vgodkja£5+TPMpneby Hat+usitЗTilgig
obake?fab PtO ɈB [7a?ȾiagnoVkk A$"pv
t  AսY' MbTЬPbBˁ_= S7pr Hel[ Tm5BE >pn3dt &0eln@1h743Eury$T ɈV2Q13ᒳ@=!,=AvbrAy@a BA pJaCNei j p&=M`Du fpa*`v¶ lysac
bmkS 9Eipl i a-Qadok#um`^"bQw {b````  \p`Xv@-> r MELLOMROM = NQ'18<-TILBAKEr8An* TAB&&~ySHIFT++|F2@	-= Goi`#o  odutatb@k-mllseNgtyp  hN#edѸcbuff(L1/L2`MQde ; -a- y(up%TP@Yr0}uuS,QkobQsABW,aoK TA@ `4@paVs
b=brPC E  >n-%(r@p`bkJoaoAo
I,XRX :$Z.   %\ ok! Fep3R\,_i  "Wal1 0s"-h1jH w A]dss пe7]"Ve Pn80 Ad:  !0@xAzholdp HGa 6"/he-,pŀJ@$ sPA/kl٢ḣcnnSpҰA:eݘ1% b ҪregaWm? Ugyld"8Dfra6 q	`)fènEt hxDpZteaen? kcaF iate?2M  H.0_ 1 (R ) Gsl l(p): 30!C`gr % full KppmvQEa}xQf7: Ka#utƖUA7$c%%0Vo(Les(020!+d0tr{ib`: IDv301s=PS.M.A.R.T.-f`ÎE F  GӀ#Ny0Be0ft[ njAvo g P3q JɱmP m v likt  ``0Ý2Q0aea0oka@q<A3ogs$w,ՠgliudzaempel`Fhΐ !.
QZ/"rQ
da=p. ?br ku Y  $mP Eベ|!&`vice.` uB_A?ed(ФW 0QI  
H i HP tectTools3curity M[anpar.'-0N$l@ lanq6paPpus LsRѵm9Sb&!giew besk02AuR+/- +ຢW%XA  . vgl`p]nosh,"x@2=$pQ U. K$RmEaAs0ord- ParllkwFlashiPPia LAN Lysf  USB2!Cpbusc-k(p@qxpr(S wCD-гp)c[: HoW
2:eG ЀilgtP1E h'oт9 b`BRUKERHOVED-: GN umu@7VEBi+I12bep Ⲅ@ \tryP
 P  @%$6 #
W,X`A 	'P7Y 0;  4,OMOEBvhjelp>automE=D!Locka 1!byQ WdVg PhE`!X0oigPd.S  Øf b rad=PB$ՠC-or 0C?	|@u/n(P.&cJ(A1s 0@dda~. UR2nommPT2Q @V0YXG 
:iPnea:#s urWP. Vmnbefa{2 өG	 Q/׃B} A0k1F rד`<aoo!1raكI7 $0%0s}0A!Xטd!ans O@E⫑v
, QPESC-Qx1 (Bx'D'- F10[
bòe:iĶ o؅  1NoriFǋOrwe MultiBay'^s вQdn(vee) Юko>.ngsba0hhyOB}w Zip5-U
Aq A0 !ba@Fn/Ct[rle E }le(USA)e pekeen0`!el`x !jermtroaVideo0@p
Tvis!rrb0p0FViA7ti` Ԑၙ1 m`Ygradi`/trOdl |t ~
WWAN) OOHOHBluetooth 5/-ft mи"1	SATA-CDual Core-pros$
bari Ag`nss st	y>i1Z ۉk.1+-e02x* (vp,c4b/!@1 Eth́u?	n3P	3 `'qR1
@N&s0oo `o/
BD#&KCi2;G1
P߀`lx9XC ($uEr`B9-y,\]F12-[жDS*ep_ute P@FpR?BIOS DMARrpG0QP!ԡ^ R TilQagsl  قEqsQZA !FC Ȳ  :Kȃ׀F.RAj007.0%pll@A
CfFe`{2v`QE5Xk f`[sykl`r Configuraci0Gm`adora <F1=Acerca>rchivoormnel Sma^qШsR@a2PNfd	o`c	bfya9 Ign
 ambios y@ Sa A
p gu7  GFnlepidadA@se|K`ciobxF1posiҫs_SIдtific e "}!KsXkSmKC G Soc0#<) Sec6ty `PM inc.da EOr9b	WponibiltegofaOcЦc3ِ8:1fbrp)6cnci@]	cDiagnM@co*nprueba HDDc0+OGV'Memo'riara)+!mPPkap/+,`.i; 	JDD`L#= rDamp'coK CgrI
o:.o? mW#i>H<&g,rim "Pquiqfec0]GinO =,A=CaP5lALrap=SSqNJ1"X, Cyoa3	=MsB`v"fy0obɀd2ei/10rav&P,ds6m sancn~SetupoGuXwado;ft . U@s:iRk0*Y y: E \ o -> = Prxb+dRences<-y/ AB S	3*# Ma/ys+#C+/ƠF2!0910 `tGs $b#$vucFaI@el[)\À35ΠA@locVUGuWXTamaAlh (L1/L2 OFF chu$Hsǐ0 Aรmeraribhvil2vqMrܑ9aB\coplamQ'`)/!e$ .1
2
	3
4
2s
zqlQeboodEtiq r@pCieԉ
I+K (MSabrasoo2ooo"o4oj? pn:$  Probanup.   %w(rss9fuErrp8Qa ;ll2sReo 00PX1'	lne®di]l +
(#Co00co FlexAd`:W EѢuir-  eǖQ3.Chcx 
/6, Dsc  cuA: fTUu00P| N2qAנ! 
S^`cvpus"(I$<ԈJ0o(a) PC!@%w?oe il@ 5
:1 (Rp`);2 (l QF3 (S.M.A.R.T.) ClntieDej@R(@s): 300 Vg`o BT0%0#Db f!ȄEЦ%B ip0Grrumq
bH: s,pu񅀐@qIS`>n𢁮h7Servof 40Dapoyatatrib`: IDb00abRexws G
X0Yi0"nue!v ZDPӾ ApagE&S`gOB".		@e@vocB	b!alfa 
0 Lt!ad ;>nsaے"][֥7 	A*# \aŋքm (025o,G1aipUBs OF E t(?LLhقrp}S"f_ Gltཱ9al ol bXnjAPievZjv. qoq  '{v?dvWapa0Au9ڱGHPP?ctTool )%6!EQuickLockQNSuspen! Blo^ratS 6"Ĳ"`nMmeja<:0 +-y	(BI	( @!)(P`0r+lg Rt0,"D,0X𶠌uPizQ,. ̔xHvOre Pu°nC  rojo%lpWC2MLme@7hdem Ino Wake-on-Lanns3luz | :g	s USBE
1394 RanCbusJEx0:s{rqd$qCD-(
EeQuc.ChUPr:aPUsio:a@uWd` 'diDriveA0!@"( tUSUARIO2R PRINCIPALѕ soe l&| ^naSman] p 0. A; >y gu ,@~`lug3b.  phj1<@#mpg.p6.
Q @de`lGS1
!A=b Dvab\pF. U0"hoau bmch`o@;]H_mbeddSityBI Wci[nb   lO1`PnQXwDRnAdD@w( R0אhuhc}y#tngBn ,@lΡsm%mu@tebooqj<6N, !{osBtQ #bŽ!K! =b`yJuĀ[D0aA!Kcub`\t! @ qШbd1a`?%k,bA bAg g.7Se oenf 9Ed 2lic큠l reazf. ?k cu`qͲ`>Ain #˨2CtTB"fi @[`
@|ܩipons2Xu9`, 0iӲ ESC.  `"08ub'&e'  ,F10c:L&2sqfМ ŧ7CT/qEspaol OҺ`uMultiBaBNPb|pxOCDfMbbco+(Ciz(jech-   byIAE&Su@x
kdgZipcme0ᯀe TerIoK C 5t#p Mx SOv NoŀD Cјus Fn/ TIngls (EE.UU.)!aWӱqm6pplSo!~ele$b
@b_ a"Ac@ PGְeo MoPu0z!  Bidi΃ Tam`&CmO!2i#	si0ѣfuБ BXSICAHRP1 WWAN cor1L BluetoothA
1{Pyqho#ergR %()n oSATAPU_nclepoڀgNpzbaPsu`	[po0osrbj n B7^B(s!3ior)Eth>et, NTL 1/,2/rL3/Tok0R lOO%r12a3C{qD2bl21- Arranȑ.^pB?`c<U_D!:PpNg ŢPZ PaH@F9,m F12OJFJdpJAmbTouchPP o N`u@T0s#r DQ DMAdBI/OS L~iL5_@6d}opCclez½o R4 lPYPersKap|2)b`<t0Ps8`^9.  Aأ``ѐaLa AaPO%;CP0qcℲưui	N	  GrPs
$ 00,0%rletaC  AE MgavBftFCic1cPdGՇQO֥  <F1=Sobre>`UruInԇs@S ePE`$G?4padr0([ndr3	sIgn0cr ``pairs+'.seml' Bv;UQ7na nhDadgFOp㰡ar v0~qsW/t w (@_
j
h&Q$St sd⑅O&pࠌ
"ƿ  TPM Ib`'V`KRn `*6_S7`cvAɏ
	R@ -U54fbr瀫faut q  8Ijף1 lj[a lagn#sĠ%TNGo>HDD A۟ VGrDe MempPA8= q@ -ciyBu?Sele+is8 8ampoinz q]`G44o?>	VUw
!x;A+C% sss kaqltin ='SC=CelAceimNAKR, Q%oup=Mais4^ ob\Dit]t
Wa@vӁ10,s<L  seeePSetup!KGuSHBwade Soft UizPsqgtw cr u$2@0 ->
PAO = PgrxL\<-QoBACKCEp#{TABP&SHIFT+ !(* F2 	O-: =  k  9n`ULgTiP1ad⌕sRbVcPPcas\nhr@he1/L2Ԧf>a ROMAs s sN1BWriXVReviAn'm! Aۚ
OBp 4
#cEti`Ap mFj'(E( eps onoo`.o	&alY fd :u$@B}g.   %o0#foi a
 v!'Wal ޾WalMkq 0 g1i	apteneklƮcҫnqGP j!ed0tc: @  4edOsacP0*VDò/,|i um v)pu: ŊA: nd@Ad N S3`p@ jO@"Ca	0]
 v@D2ztaIT= kTcxtߐeja $,C?ЁC iӓ͠N >pߟc1 (|a2 (Abgf3 (S.M.A.R.T.xr>xecuqz0(min.): 30<%NandA%蒟?q=bucedeA@p!h'ostDCRr01#: I0~ss-P$Eg
Che(*a=rmec e l %Q3sbPtrib@ɁLD`04^!Oa xa`Ls waQUUig:TBrg`rRl Ls  ѫ LBaiPArr1rDig @АsQgp6S%`GQS o%@modCs|5>  faz0 rArACV QaQRs, rigorosa (S"9pcurity)`4ҾrІAfJrPusafe1r0؆. Woq~S]1lLa o2mrvi?os. I1{o`&qZp+QV6?eeWP!rpk
8nS.e#QuickLock1Suspenso tD¬$u ttaR  1W%:1n+ mabpdP}0b%I GAd0XA,@$"""@.2P sa giUiS, o u3seu s0ema@ExigUJre)PbO0SP 0per#me@$Ql0Tr5Fh0dP&re`am"rNs0Xuz ambiQn$s wUSB139SlotCbu&ExHsspY!@CD-1$GkP!#Fm1e:dZ@usuAM: Vocc0q\I" rҔuRxo0Drive-W WtaqIWUSURIOJ~bMESTREi 0<P,@1?0D``apazB Í. An6X4@de-pA$V`iAs`I3Ep\. N9v@Pev/w_ ,@!` LAiS : abB*fa Ldef[fa5B. H'7{ \ &H. />JЍEmbeddedjhoB
e (1Usuvz%"pnEuo,,$I Epa%gD,mߡ #́kE]RBВ:a1)X5n a  2xqu2= Sip`R`'"!d^ G0tgP岋]
 afA]P@,`<DaF  4oPPRea-
f SRcat{F sub tudC?h&3+. 8-l B Ky2XLs"AZ  Lembre ,HvQ1Na+ÔbӦ8
@2quiq`mpe ESC"v`^%2`  Р A$\Ӽlav'g'QrF10.rbA:BMr*TAcV]S1a AAu?gus OЏѺ˖: MultibayNdƉ
D2wp2܈pb=Baa baP/copld(RPXditCRbh
ziprime[ir"rc QutOvx ߂cim`InaтAs F?n/CtrlCIngls (E.U.) VQPip)si!1DAy SQhpౢ0troaCRߡde`/cund a @hx LPadrcBiQTa=hOmem0OBysempy fuw F>@{ec0CQAR 0lm sWWAN)` @ooLokBloot5hkAAnڀ(a/ EomCEnergp= CPWU DC wreg.rp.AWa Ge3reA1ag2JceG21v932o57suЩ070Et0+netg	O`p
/*3/CToken Ring OO oSflexR@dapҼ9Aa>`hS@PopupW`D`y8  3F9,i0F12*9L duplos Var7Na NumԠV@{s#!7s DDMABICOS@~@es o{Poplez"sbl Id0  PerQsqM!Eo.pag1t R$T@xq s܏.  A2eьqO  mCP QzA
	
	'R"P
$ 00,0%lO	Oa Erg+`| oif Cic0eatbA0vTi Wk 9/tukP  <F1 = ja>b!wJrj!lmtQt Nytt[ v tu`kP 2PP0 o
j%jnskon @lh` mup	 @l0!ta Lr 
 ta;llmat7!WT^Tpou] aur>plisuu/Pan m󄄁1Kyn1yM k. La@tt8%M@
ila.f
pusn'ume'- 
t lykin  "'
$ nnu`kiG
' TPoM Su#et C0&T`Q0vy iss Piil's1e-tehd f3fG" 3It$&j
8a -cin`s'cKi`b05v`
; O]t$0Dk @ a5np<h:m*@>G;Kieli@ePpk Nc  ha:1@1/ (2H..2'J"2'C#a!SistgNJatktm	jot  nppU =$
,=jD@ơ=Hyvksy=KyllEi M, Joku,J=LP@XY KatPAĳ#2-[JDtev@o-Sohj[ oppaa`ko+``L.b2&aL`3se`a9vmi ->Yi VLINPPINbdSd[ <-bASKELPALwAUTEdeN!/ÂrSARKA+$#tVAIHTO+',F2n+_q= 7eQs"D11ajw'io ]ASyyppRIn cPaskhV"=Џ1/L2#>qu  ROM-P-vQi%  -@s| sarjaa Vi`Ndst%abko3jpp)0` `)@~Ak01I:b2o33o44m.hq| p|y0q.(jCoa)

 

\	Z
:e$\\`^a .   %_c lNp!ivirhaʈepo3i Wa;lkq0 -[1Yloso@QgVaihtoe@ `Zuvio^'mkkeB@̀us: T-0lG@T!patvnhp s. J` uluoxpzus-  n,Kuir1jQonc <-pA: L"  eipvu{C1  1#7 0A^Vvi-ǺHko{E@A:n? kS r`  ?4b/i ((N :J2PQaW3.M.A.R.T
.Ar'ѬPi(min): 30
%s x%Ld3 Is`Q pysљi30keD ]V8-#voic
b%u$( ;K*jServomoo3tt0g
Lu7?6ma*tuќ݄@aka-ribti2`P0a1@a 6` KsetQJJ=:hUwusi Vah@x`ba@ @DwdB!2A"+ p2ua	-Êk>p  t/ v y4Nk@smys`TPU,v,kn v	@R$ۡ! *}e T 	 a
@p2 WUOOTjWF un!nu߇!kyselvel~pahtum`^
ZGza bEJ /:vii R⮀7HP P@ectToolscuqger -apu3a\.#6iB!l>Quickq
~Pa hiirlPVA1(F ]raU `'
((Pek` 
U$iT)H@xdAy!apypzyh p 8&#5Q en R.ad:uuA0|	ASAporK InfrPnRP"akkaisq |"km4emE5.s2lhr`  tB1а@USB-"`1394 nCardb ti 
LxprlCD-Ѿ-l((ąc3wQ@%P:`߂TjMWAiot'Bsn DeC-(u4,)0$:.P@O"`' KYTTώJNC10 PSpSANAN,0f"s"8m.raA- Ԁ(r`ltur0Qm  ]kaR0bՀ/sir
.VnI-`P P,~p´u1wLLAgU0nuOW5y  op}s %Vh su`mG2?E9E,#tuHx	>rr$ Y
 U7kU r
\'~UrsM. NykylRJ`+RKPw00b,n8|
tp\`Y. TxtU@iІ$lãihqeip=Puper_D<eh? IPa*?-v@f!etHCta_0h=c OAojAaiem0  wֆtzC. єV qym "3 tbTV@G.2!` ZX{AF_fуPĵ e1vw@ o#\Xc#3,aTESC-nsR;nQ,\'%'A8>!F10Y4aa:	o .VQ  llіxtЁ Ȥys uBbn MultiB
aOpc&6& el miuU (ena/$oi)q䎂b)aZip~Ensimmr 0BbKoe7lj@}Vi }KRie!mK5akp Y gKymȁaiP Fn/Ctrl"m(Enyg`(USA`UsP s  a !ҡ-RsѬ$&nAjBQs CڐPs VolhpqN kios2sNc0Jg`uu`ґH Dl4 Ѥko ~WWAN-ruoHLOBluWWoth @/F@hA`Lի-sATA- @s Dual Core -PsaFaAgpUd VP@Ws  `?P}0AGebP 斳31iHE\62V3- 2 (ylosP2OGCO=Etherp(vn9E Yoeo3o@Tok_g OoH workQ-G  {8E޷!CPBDP0Br7 avu']>P4 `i@ (?eoI Q@F9:`k:p0F1S2:i ZPaǾtappiqkoskж)mK`i mjn BIOS DMA`iedo\`>otf uhd閡!p"Dpoo Nope  ParaMuQ Tț2!w kki1 `Var`b6 ky
t tySqNQba uho {c9&㐤Qle$ 00,0 %Qiupr3he tatarkk S1n1Ut  asyklipConfiguratiordЕteur  <F1= propde>  Fichier Infor # @. ,m/Aff age R1urer"
`sЗr df*a cܚ	w duGIgync#modi Lt	qu1S7~pe l'inP:auveogardns{regom|	\ Scu k!8+`e
:p so$@s``a6rt		~frent l@NBl'$IDy'A3
Fq Sma'rtCpUr")r * ph 6G  `Ӟb#a +3seTPM F	ʂgrςe ,poriphP qubDnibi:?? Masqu %)#H
f+98gam+>'u  l;?& @r"#c-$ta @0Qc)0s`Ni`1LActᨢGoV6!mmoir@}c DO@E!JLang ChH 1Ind(́mps gH7d-rU
Z ]\V#,5>U,AppuyDsuQDgoucFipo [ub =Sle0or, ECHAP=A@l`h|Accep\0=OuiuNA'#Q_, N'+imeWewD
a=0n PQpp0i
m }S p, re'z-vU0s`ͫmp r kMa l!lri xplogic s. UWsr3ai -`  C- :-> ou BARRE ESPACE =+ ~pؙu%IEprece vTAB`C*'jMAJ+iXFa21= !v-#!&`abrpz0ModeذuQVab0 TypvJsV`rwXwDbiS]TaiQ'0ca1(L1/L2)@luCv4FD` ROMerg""Numrqo^P#
Rv E>vido&qp8rRlav/yoc'a@uF"	 2rb%e	1/,2/LI3/l4*1iCҫrita[y/((`6te	)q?v0.OOOoOOe Mii :$1q*l.   %mrussi? ! Errq#tʕp ^c;Walk0}1Nlig֠d uQfq*C	od͊alppifSHg~ A@ti7t Ca;ePrt3ruq}anpWniя&PU`csn /0!a, z{ 1Pc 	dнr1;A!]4av
 tro  ͠c
@s 	!_[Rp줐Iab'J.HOn m: XGfinEzcP"aiҽ{l" |?OH@-?+epO>1 (rap`)?2 {(clet)u`pexbim@C(min)ƠC30!`s \CR0% 1mvD;0l'hA+BFerrqF: Gw	Hin6nud'+,FvoS7.Lu( 0IAttrib!QQ: P= 0oSppk"s S.M.A.R.T`AbanGXY AI N!=aPYE.@7/@;Ksaς A rP v KS n';A,(frgco ccP 	oQ;mme, vz"I*re4`ʲT	@^(Μ
L`a?pe@a@"cRs%"@us1Du@?i_B ǤOVo.,r0bPdpL=la ps.Ԅ8z!%͸pa av0nou TQ$ȡ&irb.g y	 	0`UL'ҮnfonnQ̠  ^q>l1egaQPA!hHP PqTo+ol<ey0r =%:/_& ckLocksuspend b~ŰF!ri; E3?S^2&ol'ЍcbqCc8`jM)ad@f|nur,  x k3//  / L'(Aa
$S$
ud!v
 NP
dra+syst
inpqpQ`ZExip)Q@Yred%Pb  4ra Q8ll0F[flashrveil"appel rsP_%a#pi`ambi0C	s USB	1394(n
$C@b0<Ioe ExPss yd CD-'EbpalM^@Sү:>?&DɎE Drive2. SII"J%Kq!dez "deux+(UTILISATEURXPRINCIPAL)*#N	Ф$alori*% N`DzR a`` O!!P,*ޑtsr biffe9celu/0ՓDordi 0@s3. Au bY ZV@	(`{ W_2oz Ifetc}|@E@"0t"~"a"ɣfa"!GoaopVD [D""eR! 0ݑ^N)eF0FSanr<  `m5#'kH
U#!2\//r,B=ϻ!u!  3`a!! !!{e`VW
g%uPRnA'R13^ :Hp" t"" #op!a8uEb#O' }oW'aRi+hw#1originIlRv`O2Caa B	uD(
vqS"ap AQy9ɗt0M
5djavs[o"Pbce*ŀ-$WqaPprsН ע on: to򺑿BQa1ө440pPZabЂt3kh
Q7j,a|uyPK `  ECHAP. hTzR'o'', p"CraDF10Tap 0SXр1xCxY^u}	Uڢ/ ~ Frana!OgrAC@tЈiMultiB3ayul UR.d2DX,/%socqv'a(ga!)OOFy)m	q7Q&W
jZipÛ : D hi @sβ QuaQCiynpSixi Seȑ  Hupd NeuvCD`Perm r$(s Fn/Ctrl˓ gAngl0SA) Pph@ o1ms A`stanpàhnNd'00adml!trl:S'Tich"@&m`
d 9=ilidoBidݒ|/1 mmoJVl0@j2EKal $Ӳ R o<prйWW/AN ( @0il)1grĠ
LBlooth7SkB/?1Po`$pc0if @%A&oPldoyChar rapДmbaPSSuG g a^u r0WPfexs7?1bloc-nHoCB2ooyu{ @	=ccu@odogB Et*# 1a,23TokRingo to/EA׵Y:b\AmorC=5 RetpZTeиec)0J F9,pnqF12r.\`apos0-fJixLD aP?tDCNA
cunXP;0BIOSmQHDMAOaQ4@T䀡j   jr# R6 Zs@H7s va6AsJ$P!\fѓl6ѥBVnpk QJlpA3cְÏ	нtruV	»ֱ
uc0@ơ>% 00.0%aE / I Errv@~cfCy0mżaOlatQc Ipmzl!Nlt <F1=Infoi> )qemagisuezzayRipr0 faudgř0` aIgnocP*! ed ci EP l'ix
`	salv SQ	etupa@ep 7sswҿOC	[ens_Op6ֲZ ID'` ID 
h	# x%Sаt =CO SupcⷎTPMqgp(S@oRv1o)TniϐIPtohe Nasc04
K	)0w7p4i fabbrp9	!I3Q2nzib#[
?caa4`$Rai
 qdi Z(Vx0R(a me qiAW `=PO(%IDL`}ue 0$Dim@L6 r6asso  eA 1g@vv!G7oJ "qDI x9*apkaolsiata$hqak"u   =, ESC=AnnuTaADteo=SiSN1!T},altro#	=A bba PӰP|`u! SQS,  v]XpYt=h  h!"OGuida dwq\uoft . {UsQesegupGeAun'e:-> o SPAZIO =suW@vm<-pBACKCE@c18G~ TAB@C'oMAIUSC+8)XH F2	.= Xm"A"I}e|duttoAAllwo NPboo@_cTi
1VeP|SHStepp!MkpԐ/(L1/L2dBD@CROME#a > Nume(aA$ڧ	Rp=cVp'4roqI2"erMbas~GaggancA	~Ba@  D4bG `M0 PY P/ Mpcѝq&
Ʃ(G)8	2
3
4Md:$ Ttjzg .N   %OIupZ!·0EomR|lTSpr>bbit 0 itQTdira	U T`e ['~vFloppy pnso:fD=~gger "B`uTNch`cA_punS/rR,   -෎qmfavq f	P q_'=u A:, UA:@.nG  0o ciuANJ I

qŸQa Nl
 /YP"IOyƗSeՠRvo@Mgu t?oԆiepbRb iwurea?oҠp: A?051 (Rapz )62 (Cglet"uti o (): 30>%B56a0"3'hD5 @CA:3sB@ᰇ-l' 峆PP¤(DB-%Aerv p̓")L,!0BQ0'	 ribv  i0gol:01NR7a9nŠdeg`Yi S.M.A.R.T.uT0UHvecc9hfnuo 2F0`q(`p#U#L  LXL?pbi)dʂA {@v ! \Ⴊ?vh)6i%  iCAmP+AVfASaWa2>K<ng0M"	tD`eq^Џm3Cee,<#Se ~'.!R^@FovoberdAdrKd@ xEff+!Kizsoin`ari9qu^!0`vgaO. Qm 륺 %psnJ͔r@~uQocq|eV1pϡe HP tectTools&/R2y `
ick0suspen3B#0Z mousп8 M] (X(fO#A#Ъnup'! oހ&F0`e$)B
) )@C4t!`݆Psm]0vaa Ģ	,'DU#Sar.i lQNR<(| RVa0 a@Q)ǰeL1r`h pashmgnASQLA%Nn_u0Na!	e USB Slot@rdgbus@S ExssbBo CD- S&,PdHf^pp:_C!S`3rqxcusanuD e.. D>(NCX  r]V[l'UTENTEPRINCIPALE  r 2 !a Πmanq;fu,ŀo.o\VNBfkpPz Yp_@A)e1JDPjBP4. l`lPaˁupUSTjs,fh	pu0`ao@ sb2C:re$^r.@!T  6TAgo`=  ! qQkrGH!ty,ʄ@",d@(0As !jAs!<πg!=rV!luog
B w 4"B!!G$N a|t~ ̀vNA# un"G``By #2дsm f0u4yjFC  $"6|o!ӍPZ4ap!) "(E'PAz `DgPd Bip  	p1Чp`^lu+{ A+u% af$PQQ;.,Զ+CB4w0quR`9"
!.BZ)`z!B FG@ nqPq0d LP!RCh,m0|"qo ESCfCN'){)dov1r 'fo'poRmnF10. J k+zst`\@wT AIi 3  O 1!:sAp\ $eUM MiBay bagga40s$") og(Ch iB 7JQ$Suk\cZipPP7oPP;Terz POvN@ec AЦ" Fn/?Ctrl T fIngl I (OUSA)A@Yi`uO mpl B Legacy7#pl 5a  Ր[ BidpHACapacѪmemq0Y5CqsbFa/lلR2C10wO0s (WWAN){oBluetoothCommu	/V (J)Cs}m energ`anva SATA PPrapi bѿ0aq*8$`icutց.1S N2/2HB2PLa62(P o)ol4sp EthetW V123e Token Ring 'OE73 AV   KC`fTېU7b|QRQq (F@#.)SМe`F9,A_PF1	2PDْ%Z27C@AC`\N=u@Tras cSDMA BIO!StE<As2puQab V RP pxc~o2c0tuq\`Rsu.  AG r q cocmp08 cQgIC<Qd𮢿cM CiѮtru1	Ӣ$
`fsuo0$ 00.0%!P "a Errrs<BCiclBupAmup Arkiv Sys/infotc]s~ stllfpn6<ardk5Łenuka nd`` ochsl [5  
 an0l) S_ Skerps -l`ȢKAEStPvx#olik@yrCorn-IDJa/
t @ld-s5Std fp, !Yav 7 TPM Inbyggd  I s!usi=TillgPigOeaPl(?fabrikP#H,Jsbehq"%bsktsagnpi~@SjlvtV HDD Akpr_V Mi̀4b)a#t;  VljПrD C8nedt00@-X*'ck=r2"@$!sX0Tryp valfringT nu psU =,q?=Avbry ;aFD!bp XF, V=M`YQ(2P oYm"y3S f s`` Kt Cc m i Maskin-MuhQb. MeQ(ljReUP5Sdu  DD: -> r MELЭSLAGSTANGENTE?N = NuOyg<-BACKSTEG FregeynK TABfa$O  SKIFT+Hr'qF2 `),?=" geOwAh"I@tk `, mo7Pr, t	y hAhpugCa-rlek (L1/L2)=d ROM-0`umGenummQ6@0#<243b i0VyrsRBqW9B 1.$z234cg0RUd1
o {in/ (@`;
ITS. :U$  TaZr.  c %EZ!\@k!ðClmisslPades WalBg 0s - `P f1zjHr Add Os lip7Ae P"n#`W k0E@ar! DhWqwsttidQneh' yNBJC[skap` җ/-4Q^i skb0N$рA:`ϓ
KfeaouIhеtfqISpeskyddadawg

*r@ifW O᲎np5o  	?ϴ iд?gRӵF0 1PnabbHf`n" Upp  d skR&d (0): 30Pp߆gr % kl06`2Tpp3ьvrd4(a~t8
:@.t q2$	8AOkB'S!*1( erv[o-L lî, |r*V&`|ttribut: IDz01Bnskҷ.M.A.R.T.-5 iG` gNyVa߁nAv`. ? LDĀ4Q Ra6d p0Ҫ mМ0"m聩 krvs  tGOm$CBrLؠ?k`  pap321És t ex!I#S! .	_ŠTa F;s&AGlo. GOPm  Thpglqm3Adtj`eh`:else.!1P `uqu cZ`=83funЮkr  ưAji HP tectToolsF$I	lQuicksv7el?ge Lwmau HQgk
gbhB)`7sadzi p&n !!p!+Pgo"rJs14bliWan`d`pt. K7!omGip 2`f `"P`l o Flash-9 sSen̐Bom`=Bljus USB-q|bus-kplats ExqphCD-s{ T(S~x HuvudLv An: D`1 q{hrd2a F. sC4qB abr ANVHUVUD HdP[mavt W.3a P`H`%PQU`0ild an-A
 MNuUhxp@ L ;l%upp<-@l!T.A] Po1 _TX3 5bBbVg@8glng\a1!b  h.  !na L<Acni nD 0Sk0hsk@ p7c
@Edim	 
sRG'-pKx_@ktupa*pt,so.jnnsa PW0uqmмutQaGtg 0rs+ b0\QZyP3yvurpungd0APO. Vi?  reko@HQmRF	c	D&rn qs`b. A JTф2@l3g@eB1gWAp!7-be0zfPrse`vm ih@qfljjns. Tr  HESC-tuA1ܶ >"fwà23r_'B'9sedrtF10`Ui2a:c䧑sh~ vSvoka r̀: D?, M@iBay?pNp[0Bg6h B1a  (`}yr  (haҠvawG@x Zip-c<FFj!1Աstto NRT VxPFn-/CtrlǕ EElsp(USApkdAA b mrmsPtro2w,ffbbel!SS`plek6Peo 2n-ekYlG"nPaInObygg`1s˻iotr1t1K (WWAN)LBluetoothm p/() -v@ANƔmbe SATAJCPU:pSlad)ekir0rRAgr3ssBhaAB #hi [4 (ODEP)C .-1,Ĉ2vy[,p  &-Ned ECth3& 0	3n ToaRaPNT&"@4(Gjtbrp4P 9d/sadapl `Ddrj%&R (z%.>F9-,YF12- F(Sek)e*AB=d StyrAJPB g BIOS DMAaBsC1Qg[ 1 ZymAnpap  ҄07  זK$d)GH< Wproc@8F RӒ0ea.
i00,0 % klEB FelAB=g`afiSlumpm CqcykBen@`e @P~a@-  f> ]` QѪA@& bemc?onfigu`~Wijzig#ne`«qgrammaaq  znr wop slaanopB9s`veiZgqwachtwos. 
6. A1aatbhOgl$ ID's 	WG!\XASm!GCL7 OA@uf)v@c(c#mȧ`jQK"O
T?PM Ge`N@oe 'Ptusp%svzie2!/chikb0,he3 !  	qFabrieks2ugz@CstVref39opnieuw5OEecB ώbzela -jfeai AcOvGeheuP@1C "h ACgDf-)Dalz!a Telec-emK rijsgema$ @Rl 9o /97LsD9Qbouw )S&7Drup `U 0ذ{egAL=S
,=An#nu@DG~0=AcceAJacNeeU fi,t^=M00 EA`u[P6aoam ݡZ) v0t  #dCompur R]  
#Hpel9B0q8P<f dw1YofPT3re@olp>8a`ruiPqb  X:  -> of SPATIEBALGK =7m <f BACKC=EVorij TABb	c&}?SHIFT+%S(
 F2-K1= saȭV cIk@f-mwode5ypebnelRU sppx Om@`jPre (L1/L2 @apacz&i@ROM--sa enucmm@d nxqrevi!Q FdpOb`c7m0u 12$340FisЋgIwts atjReB'n+$Ԥ(n|W2zijde 
 ` DKt`_k :u$&d w0t>g .   %%rhge1gd
!ou djps7$0de-0-*1TQpho BasrlQafwisQknd pao!pO!}zLop: ^bt4Ǵqss 1ege@t P$
"fb!ofWQ A:gSg-  /t	1TmapӢ3e6ะroffaGGoFa\f isFd"AB @%a

o@g VanafWtpwOhͬ'Weu kuP J'wil"6?СP"8"au{?`
Z.1} a).2 ('Uitw) Pe vostG (p.): 300Ae$dt&%~too 6>P]`ho8=c8broa+:o@qE@geqdonbfD42#N@kvo-IЬsC&K2G2dezL 7pk:Њ0hMU S.M.A.R.T.-a~afPaSS`ud(  N"/xS=aBlok.b  aK-W =V~4qk cm!A00mPVX8
 Vr!5B@FS "WPA-ke(kunn³9&d,  zopikIv S ! ᑶ@A gqGS f_W, gF zerlo@G.p8 5(t% 1ub"y0Hfhoud 'H :0 aP`JS̀Q%r2rfɺVHP Pr@ctToolsH)'oD蠰 $S `g3q0# TשcmumSt_p@H$M"g zQb   erW++,Qh8Pi(?(a
g( o( S(628b"f k@nP@,@HsyP+e	mXAbs K[>A:@\Q"ĉ QpP$t >frapd  P  Flash-medialPY Ir` m!$Aia Pnetaw`W`doli B<bUSB-"	1394   Cd-r  'HNxQơGHoofHGdI?}f!)! Auto.c DqL>& C`gr r#KR ]HA  
-goedL!`j=Yq6bew1 T sP2PVucomp@' 6[
aAM n @P '{50OA"B3U1@p1 DA(  zowPbCOO!2Jz FF!4A !6,pMawAB!!t J!. Mo`/oP,P   c ; $? = ? 5 @hui ,̾dБwwas to/!k @OgeaBj. 0Կ`nvlp<Bׇ kPra snjk;cUlE0rkra>`8	!6toHh/) ge#t. o
 s vN.dun
`h!LefE&aQgol q OubA,ͪB$~bh Q #8ep3ruk3ESC- (A9  Ul 2T<B'm'typAw0knRF10 0@AT*pZ:`KxS4ѳd '3i3X4  NEel 'g MultiBayk@tiឍV9&Fd]Ѵbase (ksY)rea)#5cÎKڛp-B E`we AѪV V\ Zes?Zʒ @A@:N F?n/Ctrl!wiss1ʶ'0ñSta"MXNijsappaOu@e @Pa@dl Z"-ij` Vo-aG0A+ Kd`ditwion  G!vg=uyVilat ֨$䵳ppXdr&p>Radio2	l WWAN-aofLooBluKet@h/qoP-eniepʠΠ SATA-us cesP>dubbO @Dl2]secuPDcu PhѕaVQ r1`j`AefF7(b)dkEtـ 1 2
3aqToRq/-OMo w02A3fEa<7adap` Pfa> B(pp!.)pop-upsq#I"F9,`F12 (% OD'cur ݠtu2+EasyPod-qG> DMA-0drB BIO9S #gez"Ġg\e Saniti (&n)sc 1 (qa` AQp akWjq0gePVtZB^ tijps= cedu8@Fsl!I.G`|*;`lo`\b`B n!.bQt00,0%% lpIGx]< Foua"ld_Vn`leke!Ecycli  Rs[^̃ZbgA` viSETUPj <F1=o W> t@C VXe Ɋւ\܂ fHgɐݒ  Hoד ̥aɖ%XɿI  oۑaAȌԻ܃`eoBa L(a
eǩLqC p0e0h̲d㎞8o |~g Iv,e#ID B%h]u!NSA?͍폜T  #}
Ja 		 )0*T3OHTPM *, 0)o,X"p Q \  -/-("B6kFظ
 ؖ 9
f@In1% 6B 9ZP6t9X!>LɆ; `Fq  ? *qFt2Mp1F)@H4BCP#߂AI(D`Kp
G OPL"`
sHu 2-0u"$=V#&$	8L[C]10=
AEsc= CXsA50=g͂@)<aRA ^p)^; []` ď\́A w$E0!A_у\ag# K0bhx u[CySetup]v_QIψȉ
 gpYA'jaj ?e->F`iy`mk = ER  <-3I[Back?Space] b<%+ [Tab!A'&[Shift]+gF2 !///`
p/mF/[p"%  z  ɰ   ۾  xï  ށiL1/L2"OM̓Õt 7&ؿٔԍrʀI  ް ۰ׂްޮ ޯ` ްwi ޯO 1#2.3N4	
mun"p[As ^OŰ̧ (4)	(c	-3N4hxZB[F :$\a .   %'^"cj`R0!̃G[MsE Walkq0s?1nC Шhd1UGp^Ot"so  x:Т2bƁAW ⥳ B`ׂĎǸDHa/ߜp쐬=TA:@݁ȧ

O}RO
  FłиW	qX`փ~bXopsOoC  VāB`kɢςH O ׌ȯН1iNй2iS3.M.A.R.T0 \zsԁij: 30נB% 9 OK zC7`&E~ D: @	)g;mQE3kT{ݨd@"A"4MFIDt01 >.Qa  UUEpDI&ܐV!'/} 2B m@!LJr>?(ᕌ}檓ͤDLhv"SDbA缮ݤtN  Ǘ߽܀|KvQB9ARWdPȂJ& u֌`Ȃ!WVNBۅ	b^œA"g`
}Y@cꍇ
ԓi̡r	8׾Ƃa7dh!f
?b\@feviHP ProtectTools!A}lǉTs#j .0oMu "TDphS{-EPO'OHpJ8-.))Tی삪D<D%蕴   gz4 Q(!ċNyb8vq" Q ԊO Gu!~3VG 0Qlpነ_BVӌ`6T  USBD1394&Jpo!Xg ExpressCardFC#D-I 4
Ud&}^% Y:'UKѢ/*i K eeC'5D|g Q`qa>`p2*	 ;@bE`]?AT@B aleU#1Bi	@6N	i"!qM	͎Y  y ~PSȠU-ǂv )M)N/5/@`fƓ} Rh^C`gC@΢
 >BSd_pۏ؊ԓ`łb͗LŏCk@qς`k)/)%)@G  &B:J`wv\qpbv+̒*"6J OJN	(0lOQP%a֯)/I* /*!j%
F*   p_2* b*))g ̬Fpo d=4ɑ`&ƈ)gO3 fR?ɉeNЅ^fL/)3"jj@  GD'ӑO"EO CRBhr4%6f̯B&L:िȗqlӔC`!W2h?BG[Esc]Q@π~%noaVn@DriveLock t[F10> @U  A{a=7$:  狃`A:FSxuJULJڂb O xui1oiEcaB$	bXP{p{H Zip&1Ԗ 2b 3 4"567jB8910r Fn/Ctrl~'̐ؑ {_p (USA)>ѡ| uB#f0CXbKV1(Ԥv@C_g͍0 `R}UdJ_ r0Io ݂Wઑoϕ%݊ACY@OAǐڑPi̧YlbNi!WAN{j%ML Bluetootg/#jւpȓd^pSATAC+uURAWCPUi b̍[d @ns'h~0.1620k2o2odhEthernetX 123 g Pq
AOKO3O0'O3 Intel  SpeedStepR technology⨭NH0 p_PSd Ӱ q%9x(b) F9AdF12=̱ibB +_ERE ^`"bIB1  BIOS 2 DMA])t^Ni/>aVpgˉf 3 œKCcm* @bc}0IڀKKƏ#xqKׯgjw00.0%@LtGoHfN`u I]N                                                                                                                                                                                                                                                            ` a b c d e f gt )M      \   v  	 
   
     *        P        \     bc(  * + F  . / l 0 1   2 3 2    j  % & \  ' (     xi > 
$ u@0) ~ xihxi0xi!xi'xi-xiX3xi 9xi>xiDxixJxi@PxiC* <BB<> ߨ0`8l v x|v||~p0pc   c 2_0 M  =
=$$$<   DDD  A  O aƄe  i  o䔕 u _ y !$n $A   EP%  I%O Q&U `   Y'N' ~ `' ^    `!c)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>0(? ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'7(

C$: |  s+'()+'*&83&

OO
\()|O@276'6 -=
^~+]}@`)Y;+(:*[{s\_}\|      RgtxiA  > Vxi@ &@  Zxi@ ED  f@Ծ&xiD@Rx@ I o ]Tq R\Tr?r@TsAsBTtCtDTuPvFTvGv; 4 xi9 ([xi.ZxiRXxiYxi\xi]xik@U@ D@Y@U J{Kt|UL|Mt}N}Ot~]q&  PtQR[H 9 !
	$
 
T> 
	^xib
 UH`
`
SUTUĄVWąX` Z(6{%>VxiP@ z   @ʀ
 {aZ( 
( 
bU^ _ @ a 7 .*  } | 8 `	Qt$ 	)D*@@*dcUP "b  @Qw u`U`ƪ4#y9  4 !TҤ@@7 2
#t rt!Cq  "%T G2ÔǪȔʔͪ@

Ѫd  d!ժ!d""d##d$$ 6  f$&*''((5	 dI#&*>@ 佣!"!C$" з 5 @3Dr5EdFF O5 * D"  
      U*	d	NSxI 0ŲE\SGz  J{"    E*C  ;8789:;	<	=
>
?@A.O@&^aDb\
bDccdUBDe2e%DfafU(Dg)g3Dh.h/Di0i1 Z
xiFh*k+
dl,l-dmT 2^xSi++%*jT$a@<6"&qVO` @ O : ( ScUd 2jjtkUltmg U&e[fd\d@GQ GXhء efb@?`el: mF4 8g h ijxR`fvpj )M@   & : V@h @ހ @ . @ \ j@ @ )M)M4@ J j  @ @@ @ V v @ @@ * @ Z r@j @
@ 2 8 b @  @ D f R A  @
)MU@ 2 > H UZ@r վ@Ѐ 	T
@ 0 P h U@ @ 

@ > P d v@̚ @@ F ` ~ @ )SM$@ B P Uj@  U @_
)M(@ L Ux  @ )MU@ 0 R n U@ U@ހ U@ S @ X p Ն @܀T @ N   5@@@ UJ \  @U @S@ ^  U @_ )M@ " U2 > T@^Uhv @U @̀M@ P Up  @S2@ f  լ @,T  @֚@@ p   @$)M6@ d j  @ 9@ ^   j@؀
 ?@   2 F Z@x @ ު@ @ 5@    .@8@F `@t @ @Āت @&
+@  ADU6 R@nU @ƀM *@ < UP l @ո @T +@ 6 N f ~@A* T @S?@   U @"& ABDHL P@flv @ @ހ   
@ \ ~  @솀!@S@ AV\, 6@<Pn @Ā"@P@ Z p  @ #`@ @ T v @Κ $O@ n x  @Ц%)@ ` j  @j @&a@ . > \ r@  @'[@ D n | @К ( ^@ hj   ) mR@ r A @UĀ @S* m@ 8 J U` v@5 @+r@ U4 P j @U @LA,S@ > UX l @5 -Y@ UF f  @5.@y@ UX   @M/@e@ R Uh   0@*@ \. V @ 1@^@ > T h @j 2@^@ 6 B L P@TZ^ h*@ A&M3@ p 5  4 V@ U|   @5u@ \H d@ 6@ t  К @ 7@@ , F V b@nx @ @
8 l@ . X | @9@E@ f   @:@@ j   ";@l@    < z@ |  ڦ =@ x    > p@ nj   ?}@ X x  T@\ @@@ L z  @Ԫ @܀ @j @A @ ( 8 N z*@ \I@\\2\@\B Z@ UZ |  @պ C\0 \ @j D@ h   @
EC**  R r@\| \\QD\\̀j\F @ > L Z r@ G@ x   @nHT@  0 J U\@ M@I@@ 2 UX p @ @J@ N tt @ 
K@ 2 V  @ȀF L@@ \T Z h @ր M@ J d ~ @ @N@@ V f  @O@ AUl v @U @M
P@@ 4 UP l ~@U @MQ@ 6 EJ ^ AxU @΀ R@@ H Z |@Ț S@ > ^ | @ @QT@  : \ Uj @j  U@ , J l ~J@@MƀV @ . U> V `@hlp \t~ @W @ \ t j @Ԁ
X@*@ X j  eY@ B T  @Z@ Z f t @R@̀ @ [T@  4 @ UR@f 5@\@ UZ |  @Mހ]@@ t 5  ^ @ Un   @S _@ \  5 @`@ U|   @S a@ t  5 @ b@ R, @@RUd @U @Mc@  U " *@2:B \`f| @J @
XA  d UH X@tղ @e @ < R pR\@5 
f@@ > T j \A*U @΀b@\g\J
&@8> UH@Nht @\ ޚ@h@@ h   @i\, 0 B ^@tj @j@ F V v @ @k@ N b  @̪l\0 R z @ m@@ D b v |@ @Fn@  < UZ p@ @\oE@ h  j @p 8J@ X ~ A@U @q\  2 J ^@x @܀r J@ H b x @Aրs@*@ , > T j@j @t S*@ b n  \U @Su@@ N p U @  e@\
v (@ L Z p @ ښ@w@ T* f v @\ @\j@x.@ F r  К@$y'@ |   @ zP@ ^ l | @̚ {@2@ t   @ʀ@^|A@   \, >*@Pbt \U @M"}@-@  ը  @ ~T I@ Z   M@n@ n ՚  @ T W@ T   M@S@ ` Ր  @0T@ j   M@@ @ U^ h v@U @S@c@ < 	J \Z\@[ R\j@ @\$ 
@Y> Ur  @܀M 8@ > UV r @5 @ UL j  @ʀ\<J `@\@D\\D\\Z\@ \
 \$@\RbT \x M@x@ H b z@ @
@ V   @΀ @ H@ b   @Qg@ AJ j U@ M@  w@ n U  @ހS@ R l Ut @5 @n@  J p @ @3@ 4 l j @ހ@@ P p  T@A @S@ B f U| @M  @ P Up  @ЀM$@@ p   @AS@@ J j U @S @ N v U @րM 0 y@  ժ  @T@@ J l | U@  @M@ . U\  @ƀ @ L ^ z@j @@ . 6 @@DPh j@@@ b   @. @    B Z ~@j &@    j@ڀ ͪ@ ( @ L X@l @΀  @ n  ʚ @&@    @  @ l  ֦ @    @ R |  @@@     @ T z  @F @ L U^ v@M @ : UV d t@|U @U @U @M @@ V ` l 
|@\ƚ@ @ `   @"@@ Uh @M @@ Z U~  @ڀ4A*@@@ B V@\D\ @ЀA  T@ > J V Uh@ S
&@ d  E @E @M@ * UN ` @5 @h@ U4 R d ~@U @
@ > f @U] , T U|@ M@&@ f ] @j @@  V ~ ]J ]M@@ z ՚  @ T@@ B f  TA] @M
@@ 8 UD X t@հ@  T @ N l  5@܀ @ EN t Aվ @T @ D Z  ը@T@@ 2 R d Վ@@ J X |@ ޚ 
 @ 4 J ` @j  @ X p  j@Ѐ@ : F \ f@nx @ Φ@ @ L tj  @ĀϪ@    2@A  +@ ]R h@j @0 ª@    j@ހ]U . : F@UXn @U @S@ n  5 @(@@ Ն   T @ B n  5@  @ ~   T@ l   M@"@@  5    @ Uv   @C @ ] d Uz@ K ] ]  )4@]>H ]UPX `@fn]@ @V
]@2I:HdՊ @Ҥ |@ v ]  \ Tt@ R ~  ն@؀T@W@ f   A*] @EՇ ]ND]n@]l@ @L ] @ $ UJ z @ĀM"7@ X v \@ @@n@ B l  @΀ ـp@ : J r @2 c ڀ+@ U< \  @U @K(@b3 b U @Ā @TM@ J \ v U @M @ > UF h @5  D@ UX   @A߀{@ . B X l@z @Ț@ < R h ~@ @Z@ AN j@ @ހ@@ R v  @ր  w@ P rR   @
䨀E@  8 P `@p j@e@ P h ~ @ @@ : H ` p@~ @ @@ P l  @ @ h z  @2  @ Uh v  @Sꀈ@ d  U @5 @ e@ U< H ^ t@U @5Ԁ @ UX   @M"@@ r Ո  @T@k@ \   M@@ V Պ  @T@B@ n   S@   M Z@ v Ն  @\ $ : L@d @ƀ@ % j@ J@   " ,@6@Z f@l| *@Ȁ @@  0A`@t @j  @ R ~  Κ@U@ h   @@ ^ A**@A 1\\UH@jt U@@   S@@  * UB ^@z5 @@@ QN ² @U @S$@@   5 @@@ U^   @5ڀ @ UJ r  @M܀: B b @  W&],@ R ^ U| @} &]Ԁ^U 4 J n@U @_&]6@ R Uf  @} &](@ UX f  @M
 @ f A @ @&]@ ( : V j@ @&]0@ R n  j@΀ @ A` ~@ @&].@ L f  @
	&]8@ J n  @
&]>@ b    V
( T 5j z@
U @_&]F@ ^ Ux  @΀}
&]&@ U: P r |@U @U @S. @ p  } 6&]h@ 5  @ U`   @8&]N@    
@    @&]$@ 2 B Z v@ @Ѐ@@@@ V   @&@    *@    @ xj   
 %@ b   @@@ z    @ j   1@ v   @-\  6 X p@ &]T@ , < D@UNXb l@Ut~ @U @Ԁ &]@@ J V 
dJ |@ րT@=@ X   ժ@Ā TA@ Z   M@ !@
@ 8 UT r @E A*"=@ < J@\jD\ @j @
# (@ LF P r@ &$ :@ t   Ҁ R`%@@ < R U @ҀS&K@ : ^ Uv @5 @'@Y@ UB Z p @5( B@ U > b @U )X@ b |  @ *&]"@ 8T  V |@ղ @+T@   J n U@ S,@'@ b  U @S -"@ $ 8 UN ^@nU @ԀS.b@ D ` U| @ʀS
/=@ J j TA M@0@@@ H Uf  @ʀM1d@ n U|  @2I@ H x @Z @3 ( H ^ n@\ @Ѐ4w@ H d  @ܦ5@ 4 D ` j@r~@j @6 x@ R   @7@E@ t j  @8kJ@@ R \՚ @9To@    S:F@ 2 B UP h@vM : ̀U @S;|@ 0 ^ Ն @ހ<T P@ n   M@=@ v 5  > @ ~   ?T e@ x   S@@ f  M AV@  5  BS@ Ut   @+C\  ] U4@Rx U. \ @H4  ^ D@@ U   4@U>HV z@%  @
IĀ\ VE\6 d U @؀KҀF@@ D U` t @5 Gz@ UB b  @E@+H@ F \bD\Ư@ª @$I@@ > R x @ЀJT@    ԀH @
K@ L l  @j Lv@ < L n x@ L@A My@ 6 UX  @ղ @NT@ < X ~ -@%@m A OT\@ 6 P ~@ M@in  P @ X   @&Q@ R  A@SR@ . B X f@O)MMp P@D  @ST@ D ` | @A4@A T j@ U4 H b x@U @MU@ X Ux  @5 V @ U< X t  U̄܀W@ 2 T z@j @X@Ū@ " @ \ Tw܀ @ʀpV2 ( @Y@ V r  @Z@ `   @[ [@@ ^ v@j \@@ V l  @ ZT   M] @ 0 U> R X@hUv @S^@ N n U @ЀS_@ ^  մ @(`T@ t   M@a@ j 1 @b@ U   @S"c@@ l   @J d@@ < X  d@@  @cW)M @U @U @
e @ A@@ ҄)M\0$@L\Z\p@\ @f @ N f t @j @&g@٪@ ` ~  j@ڀh @ V A*t@J ď\D\iT@   , 4 U:@Tb U@ 5@&j@@ Ux   @n,! q@暀k@@ \   @l@ " @ R r@j @m@ F `  @Ѐn$)M @ b @`@[ 
o @ R ~  @ښ @p@@ 2 T x@j @qS'@~ 8 b @@ Ѐ  r@@ ^  T Aր S s @ 4 J \^@n @܀t@ < T r @΀u @ > A`@ К@
v @ H j ~ @j w@@ L n  j@րx@ª@ > f z@j @y 3T@ * P @U @S
z _@ . > Uz @5 @{@@ * . 2 \6>\ z@j $|@a@    }@ l ~  Ҁ
~Tv@ ( D n Ղ@T@%@    @T @ 0 F R U] ^^p @0 @S@ ~j    @@ \   @@@    ~@ p   @$@@    W@ ~   [@ ~   @ Ia@ v  U@ M@O@ 2 UD R@ZUbh p@xU~ @:]R@ȀM @@ 6 < 
J b@l$|@ @:@ X n  @()M<Z@ C f  @Ț}@ H A** ]fx \1D\ @cUl  8 >@U`t @Ȁ T@@ \   @@ L p @j @ o@ T h  j@̀ @@ . L X p*@ AS@ @ ` U @ @T@@ @ v  ժ@ʀ T y@ H Z x U@  @o@ D T d @@ @ b  @@F@ H P ^ j@v @j @^@ , > P b@t Ȫ@ڀ A& > XTA @M@ R Uz  @S@ N ~ դ @J& D `@A @
@ . D \ @j @  @ * @ n @ Ԫ@ @@@   < `@j @0b   T@ D n  ը@T@ 2 Z n ՜@ʀ(T@x@ j z  @֪@  w@ 0 B V \@pʦ  W@  V *Cp  M (@Y@  5  @ UZ   @S @ z  M 5< Uj @ЀS$ r@   M $@@ v U  @5 @ H Z n ~@ R@ @U @5
@ B N Z \fJ@~\@AD @ ` l  @ @@ ` v  @ʚ@@ VJ v  A* @ \
 D\>`f t@ @j   8@ \   Ц@  @ D Z AV$PnPxi / /       P DSDTDSDT/  HP  nc9700   MSFTC000
q 1
 [B
\._PR_CPU0  !2
 HCSTH %p
p
 \/_WSB_34 _5p\/L67``3INI_ ,{8R	9
sISMI
=
 ! PPC_{ 
A[6
s12
NaB
 t apa[#o
a
CA!D

E`0`
 Qar|1/tc3}c
gc
T c~Fc
['b
1\C0102
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 71ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD12phg	gi
} '13g m4 phpi 0%f%`'ϓfg`f b 4f cufbc'@%56E
Microsoft Windows ?ME: Millennium Editions NT 0AC
 jA1+9D5p\_OS_`p
g*.ag)`6
braQ915ua
 !D	"
6p B[I`J 
%2 AP> SP2RPB6Dqp@9@>15A_B  +09n`+CHD
$fpig
fHiPE g0Ih Frgfata
apaa9aah@*ha `a u
 bbi+ibub`
\1Mm0E1EIGI[K
4F_HIDAJ	_CRS-20)
&3	pV 
  pWW U o y 
 P3  4J25T 6Cw7py8
P27@D"7 S20 29X A BY S2C pI2B@%E#O ``
FBA~A7[C030   
,[ 	30\Q3121	Ap[
 33׀ 4C
o[1 0BaU567Q89j3A BHCA[  @0	DE@3F@
a
40F@[E041P42V+43l9 4*45m46Q 78 9AAB2C14E!
[08P1EAFPu50Q 1 2 3k 954U5Q678AQ5A0B !5CDQ5]F"60 6E[B(v63 }64H666H7@U(8b 9 A"UBCDBEF70b 1 2r"375@a n77H(78b q7ABr7DMB7E
c!pp4Ea}aiapa ib{{ab[ĀG037
_C~ _ADR!:&@:  _STp/c	C080p
q,81 .83
T
C[P:83qr 2 D`40PM8484ED85& @? < A286 [#
7KP88\`p` p`bS84ewe` ap` dpy@cCdc88
{a
 b di8U88bbtd
qAruR2dcrdl85` dza
af Pfuff }aPhdu`['A
\a
BL

   PpGځ
UsV`9 H2y '^&9A z3[7 BQDpibpkdrd
edA
d hb @brb

bhb&E j F909jqESA F68FcrBbN1!warp8Bab@obBom`o
o
buoatb
bP cPpa%
`bac `1
$92SKRn`k80
  90c)FP}93P=aaÉ`l93@25_HPP


@_S3D
p 4D
`w94U= PRW

i95i @5[ a9_6 [`7%A 
"A`98
 aAO{^.h2CfBI=%E 9
`
[mN99p9A V"9CADRk9au9aAaA1^A2aDA3s 4{  tA5 gAAhA7AhA9  nAAAB!AC H
 !0H E~"bAF

@o1FB0wB1 
0y [ @@B23e1NGQ@N@K4	B	0BqB728  @B	`xB	Bk0QBCD/`ɁP ޠE	 ABFP
TCT C	DPC2{C3CzC4C5
<[́WC5 C67  @ C7 q8C9@
[! ЄCA=CCCEGaF_GL_ҳbp
`O{ O [!
dv`J`CCACD{h@Q jp
p
H\rp"a0CEbfQaq	rya
c}cbaaD0 (8` aD1x0 D2Bhiq`y`j0O D3
yhQA9: \2 8+6a+ACW*GwD40ikp@BmA5RMbA
qi1M0z46-+r37p
4D}jCG51D6G[+ pDzQDQD9 D#DAC }CЭDD
A`8`wC
	0M  z{` pya 0 
bw
t
	ra]blC#
 1@9б(U{ u"OL$E
pI6'BDF
y
rw iv`H,DA`"Ca{` ` 
p{z<1 wiɀнQ{a` qbqsDEb yCE0	_8`pAw
wh mc }q  (  A12
ccFE1
l
E2 @BE3 PEs@)e _{ky
0.p;E2c} se? j
=3a{` -xq4p #`b}e_
e/ !`	We `oe$}`@@dAy~A4{k
 	p`:}q9
 D9 y!-9p/?d1n67d D7"8 8e@fzE5q E62T c`dyce@
QT@E7hif"f
_j
6?
EbdBW	!ba'cPx!Dby
PAS6JCTH@BIBb(p`Ab	s@bAu/cyacaASAw'B`BCe  dBp@R`TAAp
8p/8	%E9} Q`^0400ha.`
i@6LTEA5Ώ #!EB

EB0EED5_PSWa!^EC rP(DD[EEF C F0"	FՐ			 	A;					2		 	`					U0			Nd'[MP15Cc6#A@""8*90
[@0FB5 FC
P
[5   ТFoD K EAFFC10O: 1   2@3104 
  5OT 9 62[
 UDp=:9
c`7
  T: 
9 YAA 10$/
10' //*.D 'D//Pf!e!(. G!G!@($3( >N #F(FX//M 10@ #F   //A eA !A N A GA "A \C 1X/6B 12G 12//. 3'@/n0@a0%1a0%1a0n0a0G1a0G1a0@1[  
q
H5	P6	
#  y  Q618h```
P{`@`apa!m p 9		PW`	j!~"A`Уu'#B	p$C`q sѡ	A`v [O@_HIDA_UID
`~^^04A!_DIS@@x)O_SRSa h__CRS5HWaB r)$^+b!Cr)4;c1Dr)XC 1DM hA Er) U[(iQ(F r)$d`k0j`0A0r)s82${8k1r)71>B9[!V
02[22 123}
r 4
 <5 [#"Gq7u[@K226v1(W 6JISMI7k[#\_GL_phC05Cpi` WDpj Ea	/ 032	k['2	7Pm5CO>C07"G>``2Aqr B CaT2BBD
,1AD2E LF30 :_REGˠ31AU2E@pp` p3p$S3D
p 4p w31(]{2
 3q{56` U5`3c7s@K
4
58`
{	 }`h`{`hp58o{i  @
n$ qD135tҊ{._DOS4
` a![^6bb ha[b+3c@@xDCBf31
 G 3f SS hrR!** % NqA-!  \/c'7Fa%" *
 %
h3BE32	8hpdp
=`P{\/gQ}OC7
P`BFD 4

  Q k    @H
@
hiJq
AE `
P1P'&'E>pBA +h{` +}`  \2Q\/a	0RPq5 u5s6|6"13C
PiFC0D3hj	 4hij 0D
H@kl2E18aa1H밙Pc	_GPE
	
  _
Gb bGf f@y [3FAL40[41[`[42A3

d44F4046`
7+/I(ITp\P9
 a	i4248[N  @9@``49P4Ap #  	B!C)DAEFp50Q 1V5a5354 55m5657Q 78  59s FaB[]DE 160Q 1 2 3A45617R6n69`6AB @Cs D@6Ea7071773JQ 4 5 q7q7891A7YBQ 
7D7 8`p 1@8283_INI 84 0 q86G[  I07 @`L88& 9A~3F2@~R  720v@
v|3F8Avq"B`\`c 8C	wh
@axa
db`t
@`| b@	
a
p@}a1
y`pj}`ar87.`U8Dk azw`
d`xr`
  
@bauP6"PE~	81lw	
F	
81^ 90
q 1s 2
Qe@15s 8
05a9AB
Unknown 
NiMH 
LiIon G9C9ApO~  4 2Q9A|4a5`a 1a1{9394a59C 93 19D4Dn447st`pu#@V9q5#Q5@- I}&92a{a
092}Q`I90!>3 
0QQ!1!r@9E	0p Q] F	Qp
N{`#I0A0
[)h`pPQ11`
csc
  dziPr`a[)absdb1/2J*(ccC1k	yg3
qFg
ҁ!9059A{`g P2M 3h=C s;55Q"90Na4h 4 5C wa$8axra
c 
_dcbpbq[bPa999rA6E*6F*`a$0/0g0$I5
I+Ep_
 1W 	ip
 q=#AQ0"5Fc1c63 3T}7
{``	{``#LFA7$>ޱ  9RO2ccdp eeez
cpOecpci1t%4p?q p
Pw98p
qL!'9`p
`4^905}657C-37b@+1N)P53Q-  T(}
>
>K8(P2pz
 5^%*!E9(%BB6F`*!e(aUBh)2C2	7Datoa
al
b, zch!
C	p

10aߠa6A?
@ ra 9PQpupaRHf:bcChU6ACAU>DD2;4UR=55Ur?66o [
A8rAA1
H{P   a70
Sp
SIMPLO0SMp
MOTOROLAr`w^9A9
p
 
Aj000C000E100DAAAB~0O_Q03
Clj!06`(4>4[^ACQmo 	0PR_CPUw0
 1
5_`TZ`ADv E
 ['W1 TZ4_`OP
ZUqN
߂t~AF
1ה	2
21i_2 NQu8z#L
aHB_1#09PPuO1169@ͯ_116

,Q
U{P (i280i789
B2ACop
75N@F
F70AA !,H6Z6! !7[kHΐ
3
B4
N BFBB6 `B77 09r 0!B FpBCBEFC0s 1 2C1C4C5
[  CC7CqC9aCbCp<CCDCq
UapA
ACA3MCDq`a` A$B/D`
  CEOPvD0ED16ᾜ`cAC0baFc3yg2b }aA1AC4c1D1`ya
 d
b
 ШbdpdSࡑc
_ c
c
ED1B@D2CDP`ka~0ޕa
va_ albab`b
vbbBCQC0p=b9q!2#!<dEzj
arC1C4=b 3#'BBbЍb/	aQ obbqD4ËCD7Aנ`_D5
L`B76" 96"A
q6
{C044
`{  ia`n `Fhp!o
`!`}K D7	CFhcD0t0$sb c  d}yd ycuc_DabcA ԃ_KD8 p^^*9cIbDAL
!,B

Gy3 1[DD `<DE	0 0DDDDBʰ[ADFG_C  _DDN
COM1E0yE16
30U"]    w8y uS n`,E1oTA!w`!pE2 E06
W+_DIS s043E0 
F@RS^h
a37`E3r )RE0@
_C 20

` `c
А
pw s@RA[PoE?4   
B4
_ON_a 5_OFFPR0}4[L$5CgM6 C
_G 0" *
W~S*"[!6 y2K
@@E6 POE7C0^,4q0EE372AX
I A *` 
 	 EB
r
;@/!)6!B"s"7x"$"u"4B#2le[0]ECm$i$!P%`$ $C[C:BD1AEp/`   UEF
." qU3AcSPC>FCF FvHH
1 Gxx&x?x"q){x)xx~) #*o r^r_ _uH\RRQFQW
ai%QQTp"F6Q1QN?3?303?<R3rR|nKF0Gm3 *o3dSb qF144pF24?V!4V55 X5v|wxp
)q1PQ	p`r88!]F3=]75]0]&2]q6qqX:F3)FC4 > 3(>`{fx  b|/|Pm{\/C6
BFdg$1F6G`T ?7?8P  P9AAFBHz!
G``Gpp 	`[  P@ LpfAEp5 FC{baCI vA9
Aa`թFmBF7F7FB1MD
=6N$SNE
1.0"
Fu h200T`7uFGV]$_DSMpSh`PQ2`F;} 1hijk;J A Owj
j
 B
  A)k`M`Y
 @
7@ 5~@(
 Е`@H}@p202f
  } ն  05E
G` 
 
Y`E2J3yK p{z2 
TA 	sB3Ipk~7[FF
E e/ 
N nPcE!4	p Qp`}`
`>Q:%'95 0"  y s6E48b@ @ ;" _[5: 
@:    _ *"`/v>a a !-18eT@
? p Gr r k" 9U` `0Gd ud"[IAE
" y8B
[0P92P `@Xp[G20DS" !
&sO.k    `_[+AEBܹ     `wKC09`5DADR   PW210
D
[ 
11 INI11[+`2u3K 14[GJ1	j9Ƞ2=g00p4 tr8!2Qn 14L
C0FBWpNE	
pIlCaEiD P
0
n^^q@616!2
nFBD["

uo`{`67 p[0hGPE_L1A?`aaAPd"W
B8
>
[! `9 I	 
 A BGqb1B"C   _
0[ PD  @ EAq)`C  RM
F
0UFE΢	a
dNhpa}a0p'| dDa#"11E!E$4.Bb`g'$
	{
@bJp	q
02C220O 11)0@PP

'
@_>@p,RMVr,%_EJD 0B.lqP F4 EE +A. 2`Q1pB 43%& T& O'cM(CK)[BFACELC 2Ak B 
<@C
O IPA<@o,0;
 
 a{a p2}A`2AARIF
:r !
H!"
D4
9fA5
'6
a	>C:
?
</=
#p@*DH!`@qQ007`I\+/b20BI@O
0@pq`8
?::0"
<xF4C?	H
CLRID
@bKq``a#1B1wD AI0M  a{`a`
{`
!bb"ALRD	/!4h!ALWRoc3hiDALED	.h}o6{C6-/6A`%	ͤ|&pMS3D
pS4p `twT
wk`x0m@4Uo
OVVsVqV(WtV(Z `Y1Y3tb3Xm3t_07S	
# iA8O09O0AO1DO1EO1FLP6\_PIChp>@a MT M
?E

)  T pUP#C BA	 GC

 
	
	AF@1P
		!Q 
a57! q? "ncG	 94![B!:! $ $DG !Aa0-A4@	F
 IR  Bd
d
Primary 
10  
LIon 
Hewlett-Pack?ard Ey?Traveloka	3~a@ J2-9_q 4`L c1^gh`/`%
 ?4 
l"  
f4hk32=0i5	 /32a1L2rp oa5ha`S3hA!n&
;_U CO9F@
_BIqF2BST 5bCL\I4 ;?;h:6<Iy| 
ACPI3{F_PSR oDDaߠJ` $J PړctqHPR_CPU02Ĉ  G 瑒` rbpbNy05#`A&aq 4F34j5QX@(pa1(3[s:!
*C7  դ`1'7
	/15?@SXR((`R1)Ag

P1 N1u/Bj")C 3D  3E`vF`kAk` u`ph`piaFaP?{q@p
 a 0gs }a
a~ap`k{pap  x0, z4 q3C@ SC240R@w w+` y`2W`{hp}
yj   >p1b1`h)σh`0	40` ib1pbasabcpcau`a42
 y3 C44ۃ`
34a5 ! 0b  H6L 47if48 49 A4B	  ` p3
b P  `pr?
` a0C DBe{0p@ e[0wre
 
EQE@933pFAI84Cp hpO/48SEgCUp@}AKAY9AAM^`FbbUwq50}r12]R3-N3iP
c (54cWp

5
U	
6
7U8mb95AF@A G р&t\09O$7Bx5C1DX"Fi2SPDf6061$624$ (135u|!21SIMWE6T____F,O0 bR1JT7 YѕF b W` ψar`6ZPGASSa:)QI68/aOS6t"05 p `{p!ap	1_ a`!DTH [SU;	2YC'>ab\@ab `ab ub0Ng55v"s6Pph<piK5#M6M7Fx
q !SP_WDGD
4_c,E=DAAyB{M4C~ C+KGYР@!f )AB L\F˛K^B IK--0AJ<	Q3BC' h5L>j<BD FΘ@pEMEBE ( /2IQv-BF =2=f'CBG  6dBB$BH  5MI
WMAA^dijKqWFi,StBqn0k`pP56
PE}| !sC5C{h
`Bȝ7FC128@ CߠD{b54 0`*5V056
K7zq$z0;.	 {@58Q3b10  D GPl516
 W@,OC6J0#UEPtE63C i52P=q~`;{B   3$;M	F	K60wqZ4!hQǢ7Wh	M
5 

1a04Bsa
AH` 
;!m   bpWccA`p b  ca7Qz._	8E.@&hFhV"JI9
b`a
p
1O5B5=p
B7a\7B[5<	p

p
	Ar0lp
c)//GD/7.(
/916241KO@58?#GPk m) j;)!OG1(yE2t	
?  bUgD
}{zw #&`BZFD @\NdKA[RbWTq[b^b^blor[yA @? 
@[ zBwCwD1xE @0|F y70Q 1 2AA6B
?Tb1B3
3
a	F Va70 1`q 	?
`CBPBa"b?1CA9Dar (D3N&
BIOS Configuration Change 
  NGSecurity 
An attempt has been made to Access features unsufully1

+
Unknown Event  e  typeC	_WEDB`栠p0r73 ~E Hs"`SѶ6bapr r 74s5'%5@!%6 7%89P'A a(BW
  *UC2+DP+E Fp80  1 6l8283 `!"!q1!1x118B C
serial portA8D
infraredGE
P@)llel PF
My asse0ag90
Enable 1
Di1 2
  , *h3
* 4
 *PXE, RP]L5
 *6
 r7
U8
*F1,Boot, Allow u A-rejec`No prop/sR9
 I*__9A[OA*fB
GC
cD
|
E
*AvailHiddenbF
 *A0
 1
Q%a3
 0, 5, 1p 1 2 2 3p35       
      D6O       ;7'@	
Ss963 
\Sys[k`\9 Op!asQd
1`a1 9
9;X? B	IeA?	?	?	:	n?	?	@=	[I?	?	?	ex?	?	iqCD-ROM3>			aD}			Floppy			$		$
$tern gNetwork Adap0?
?
?
.?
?
	.J?
:
 MoAdi

8
SELECT * F"HP_aEnume4WHERE Name='' AND CurrValu#x'Rr Ёr2rj>OqGwap Fn/Ctrl Kepb5?Device{UH,	iHA#USB Legacy SupR/
/
/
.
@/
/
o	RN .Fan ways pwhile ACwe!r



h

?


Multib7	-ifoifGJash Media Re	]op		mKF9,p0 and2 Delay()@@
_A
]0
0 
1p U1p2 23pqzDpfJSt0ard , Bidiral, EPPPEC!P?
(,=J(Ed 
PP@CP _cEWExpPopuAplׯX XX2oWkWiM-Оma+CqRBC-OM/d\L4W?3Pp:wdfSet6SIs`=134)`LAN/WP  Switching
=u?ilt-In )C>_
_
? e'mbepd Btth%Radio//// [//? QLp&








W 



 


+8 Sav**F
?
SS{|

_	ϕBA7uthHicCKC&Cy\#mCoCoC oCoC`CV.	%AvailabilMW='R??? ҇
ompc DrivelockWX*/ HЏ\
Ptra 
Glio(`l +++?oo
? h䞰Requ  P}Rest{


vn	I`Data ExPrev&o!n	oNoNoNroN
	 ߡ+ DMA 2Transfers



^

	bSATA0tpC




_	ޑ	Շ		O	1394					O:~1bus Sl?	?	Š?	?	@㽏			9Ϫ		MMDua9lMCPUO	O	...	/		Wake @n 		 W	/	zFBAmbinLighnnsor



 _
	\Lecoqy Batte Fas haragM??

/
N??0=*&, Hin?____Sv 
%	o{Acpfate ~0Next B0?
` /Я${|$y rolic*F1 toR, Allow us|@rejec`No prompwONOOOO OOOOOOFq 
c) C2A8CO
!- OrdeRqOcPh .k =ar(C:), Floppy  erCD-`sNet0kttroller,  . NYB
;YQN??Multibx<  
 p?!V 6Z_9G?dp*^΃Xu` 
kb
 C
OIbOa$AB
?
/!
 

A	iA
.BJ
[B~1\#2D	43#`	D43D!T5Cd6St76CCP%6`d	234567r>DNOLqssetcking Nu0ntag PlaHol@G9IuDb!GwOwnhipU  tpha&PManufactur

FilenfGormB0,ProducAtZqIcor TCyp(*=JSpee:\ 
2Mtepp!<'Cache size(L1/L2)qFF"emoSP!C2aDOOO!Z:'KDi V2Q$\z,H=SeriPO=-^2NPCOVideqRЏu8_?
KeyboAph9`>E 
0 
 SU1p 1S2 2 T-3p35FooB0%
Sta1 sBidirlp alPP@CP 	WMBH
 ] A2i
pj`p`ap
 bp`b dubub e0fpccC27CP c uic F82C82F355c 6 7F8\._SB_C077 6 87A8B?ed
;f eufa /f
F"J 1
q 2p/*
 `K` . >u``
 p
u63 u`p`c
 c0u`p
cucr`
cFi|aa 42
  a
0ߔa
9t ap Aara

a
pp aDc d@dOdAd@ d@d
Adrd

d@d@0d}ya
 dd{d
dpdb e u`p  p
 g *yd *'e9A7d 0'3\C01A!+ q(3 dv bugudvgF)
	p
bO'
gp
2sLs7Fy ~14 ucrw;s6z.B1B1eFy/9`)F 000000B()
p
?(?(?(?( ?(?(8?(7(2?(?( ?(?(?(?(;7:(LbWe7VDVVVAvVCP"FC290090 YQEIMk1a1fCKD820Кl Port Modeճ%'
*g

	 
!`GggF9?, F10  2 lay()_ 
0`$m5
У

	  
DP0zZJExpr@ bzPopx CInter Netbk Adap01"y,PXEr,;1.RPL.0OHE@dded +uority,vi Availabi}l@ 
%&8lp: 9#g;Hi8?Ar v2 Alic#F
F1 tPP 

@1h
llow usP rej 
mANo promptsACU%Trh
'gFXLracking3SA4dap1Fa; a4QeveudueIvPb`lVV(Wkpdm581כ81vo6p pAwH׳Own hip
	ՒmPa06?7a uap &u|pugA2Pg)1dcbvbGF-v\eae!9$9 2a@aP@,d  p
Oauauőx3G4m89
Optic@5Disk_ DrivP4I RDB, OHP3(C:LxJ	USB F/lopp7
8
	@iSuperqp		CD-R#OM	t	г	K9RControz1 E
.*P%_R"
 aBf5dr
'
gGp8uAfӮ"a@\`@6ADV97A8B!E
6f3%pqxoaH$135{
gf
 &7Ba74`	234
{ep	F(i
 3
! 4 5
 	
 pj`p`Jbк`b dubQuAM[cKcyB=B3c  ^4A(cD@bf eufa RheP82aB3 >uaarbGapalϡ`afϡaiςc1b`bJ/b!b ː b`b
Abrb

b`b 0so`ood3B4`.|7:X(|
A (0&((~(oI{WQBCs1`phEbK3  4{K4Q bH3@}99
 4Dq 
!i7#h ` ᑈ83
/ASC/cy7Cdfc3d e 
,0* *|p0|ށf@AELAN/WP  Switch !L{f
z

.z 492
 U%a3n1k!Xr		
"z"OBluet hRadio 
23M&fJ0	LP
NfFbJ	  fbWml !` !f!bN_(_Y,$5i8*7W:)#,4M6IA(%F,A1(EM1#L666N(MF89KParaJ`l rŠuf
k0fAM22ء#! aKF9, F10 and 2lay(@' kf
zf
cPAEExpress#Popup3/2^!F//J$PpV8,B
!Y9]/C[A1D$vd f
*h1l`ϡ-+i2m)iggf13hq8sf dusN;{D{{rh
'{"h)|9[zBW8#079W9BGU8OA9OEBwChpfBŅBD7
COEpwDRRER	FF"
V70NCU0bG1O1Q@B2
3`QaFQ7q 0 q"q7 $r1/B   aBP%a[)!`pA1`
asa
 MHz@ 4"	FC4!5nC4ar 5b3a
d esd
/ fsfegsg
 KB 7cpcGw66a  @&b<`bsb
	`
CD $]B
=<D­;. HE;3<egR;75`; 0Ā '7B@qpa60NG
P > eJߠ0A  g1GdgI¸Y80dZ wCe `PH`1e?48`  Kp	bb$04ᘱ 6aa , a"b 	 \ 6Tq	8VC1! agFޤHG.8BqGAKAr*9C8o
{
 !b bbC2OOOOOO@KKFgBCW8X 
	$
"s9JsYAp Hs I WQABFOMB     DS }T% BGFb IA ԟ@~ t(@ "W6`Qv GGnhQ ]R.7w' `T΀ iD!D
qFt~Hp*~:ٜ`r<H  ,4"kcN
a$8%$¥@hl'E,yJIQD6'(%BX&v/ sq1ښ,^BHhQ*L0\F)V -@THA<\=rgpIO85f|Ljh8DI=R`w2
^~&=ӊ1!o !#x(|8g  Qav38G +}(|)O5Nw8|dqD99O"'@ày .?@~xH#Dk<B,SE!c|}t z7=.>F~ L>:v?K!#Ɵ|
 Otԁ2A6[@E0"ENZcDy2@{2F\,_p?p
zBS9S5Lg(-| ߙDp)3
x|@ C
`A'*u\aFYƧJc^I}1T7P7g
5LJ5j? j GG8GF \Rp4 G!0_h|ePBBSĳ/?^}
!G!c(_|bPA"Hg@?

@7G!YN|B(tg*#;K&,}	YP?!_ v pG/ 	Ag!3:$_/=Ӈg!u>1MCp0?^WN	,0ȸFmۧg!A.#!L)	E15
,dx
xa{2cY}<%^

53|V{q#: 
s)|rlV3O B!4DAm
P{9vt6p
:%jg3S	|1^d @Ql"!D3:b cM=_t؈1!&"XCc7e0Ή]|:yt~2|zha=C8Yไ0; N5} ٿcE]מRs /)F0
ЏemxCmo(m@<3n\7 0*)'h
Pn~^	ࢀo oX~ |1
碀o `7(m=!x|98yvLp<hbr48?aG8 VmPa :>8t78T塀q2i(S)IC
<1lduK2Do8Dy߈bgP]ȣB(/F#	AXOőF:x>x!9s{T8N_%L
׀3X>l	,!L`':c/|2|M0"}\oع:hN>(*`U`!C=.s>\gppqippM `
,I&#0() )ؓ0hzL*?0c93$Q';W
qw)+cFr/ul`9 
Xg<i1VaAu?+iGܢ
<ӂcKXl\X!!`IF >8G#}3{:"{ў-|x4B8vHN09y@ۗ6*߈b e., T7__^pq=t 
<0Q19Jx;rhBOO>)
&P
>(>x-N✉j8c85$=-#8<2ǐ!yq|ge|.hhd|A0쉳 wP B yV5Jg_pSd
SLuGQMTvZ`g!v]Iʳ/Yp ܳ8up/D2 Q'YI0q WC )8pdxP F{ޓ>-9!SŃ1*ivK~sxUi"/{1
}#J=-c wz 8zz y qGP8~lG qCy 
%Rp;.k(!03O1{38Gvx#Cܑ6vp!@dCǎ߬ǎ;P10	&LG-c&<!"@> c	W<x~Z]Г9Ǉ,Oq҇Yܠ]k)C'_=YؽOuL9Wv!wI6
!g$~0<
3xG8ˆ|`uQ2;Ã7K>vy3`|4AM{D8_`EC	8P$8/>4y>p{P@=!3=FN٩wf?<~.=
S_>3pׇ
Mχ
pa
Q j/S`hg1TPg1z \> 3#*u>	~6Cf@ph܆
04zq9; Ꮝ`]1۷g+6@ĂNFaPc#<~lph̑h؀R)>8*W>1]7t_.|1/->!KR!ЀOk>0UW!I
|Ox`ãg%c;xp018PqC`YO_Y<(@ 8*8ۄGL3(a`Pg2pE 9g8C=h=kߢ)\*N ^
|yhh;Q熁;P n!>xTg;?N5Gv.`"O	[!{sloaG9=xo>=0pL1-Ptx"G0a c,JWGV8i=l'PU .u} KP P#36cbbO6||}6;~ g@?`*n\( ,HGNrd{!zOcy8±Ntp.Nގ؆#'Z*ŏ!,H{<Gt;KFgW9#Dahv#:.X%D׉gG:&Ct`ɀ?`4Н]uHwvz.g0Pae zjP \|8ZQ	#X-=}
_C|'% s1FTF;-x8ܳyx8|:^?!p6> G5`+Q9
#
uT]|}"p!^"Q`oQ
0o7V@Ol/j!<tQ
j<a Ql'??<  Ίá# p9*3^ȩ=rJ,TE
WOO18CI _^|1B
?]t1.wV8zgXOX%`X/ƌ0#G-c @1`	
XOPɣ P Gˀ݅1
.a *EkC^8U_	A?4X(~h>{ohzA|6v)P
/<X^x)Kw&ssf4 U<	&y
=MI08Jb?|p! B<H$NI_&<PFy43dWI
~O,u,O1g ya #x
c<*$ÂT<Nz,a| }B
u	Ω pӅdB9i#X:	x #$FpqĹTS?qyni};\5 aNO%
67Z{p<8eZ]>,$lp,[=]ft6Rq 8!iGC:[/{ه|p4|!:m0'd_XUz	|;{/a	jTE00$sŷ|
f7o:zH"y>8xRW#lPSa.v,\'쓍O`ǜ}Gih֗kg	@0 Ӵ.)Wx}l|13?HT'"FbhtHp0=s  H7}A]kǍ}gSx?8!^}e7}E	"hC<
ex(>34x /c5> C20wG
wZMɠG=qQAtlP7qt|18.sᛎGaF`ϼ`f'10Ż>.cEw9M0q0.9Op8G =޻|vbi
!U'0(I:5=Ёh6=2 %\w_BOK=`XÆ^0Pzx#@q3&#&nv*M:L:#!>`3?k FyED`w:('G~I
 t/@>8Γ\Xk|t`\[{gy3	k+8j0-0"{+?d0>Qn`*f<+uhsw);wlO',j///oȾ)=x7)dcM(0l4FX@^. 86'|'}hM'
p<I|ĝ<wey}c$F닏 cX!} .!	4s YGّcEW`9G>~V@cQG$~Ns"88-3%v'%rсx&P|wC9R;"w q
w07Gp?RhӧFV
(VJ
(b18,%?boLa%pn#P:@XLH 1bi	X$a@|5 L@z8&
B=0H@W@Mi51
"9C@`
Eby] r旟Hr/ D@(hk& !j0=B
P1,"0pT	h*T 4% S
Bt TP@ޗ D@NB|2 T'#(P s6 Z1 4qsѬ 4;  y	AfBM 'h $AfoY=M"0gq<[ 4#}<0DG"Aj4LAӀP_+ȗHB@@h^An~5A@ȫ&0j d@AL@4'
B|q4L"P}!iAhX x[=8BhmwP T3M  2&tR5`R`&Mp$*DkѨ 4> B 4 "D 4i	PD&)fAh ,

8LP"PKʢAhl*	,*69PD`DDa@h *
 )@,
C
y.G
B 4W-sx T/%&Xh
sd 4SADã ur S 
;| dR([C127 JC135[# l[#\_GL_yh
C05Cpi` Dpj Epk Fp
 C060\01hp `	l[m'['` 2D3 ` 4
w 	 B D 0E9EB7EC !C2EC@
 QD aF	`8\_TZ_ 	Fw0
dq 1
F w2
<Q3
(4
15J
"
 %   ~0NX v8n
T

blYOF0B @1
6PJ
ϐ
0S67w

1
8x
QF9s A
1B
C
D
E
F300s 1 2S3@304 56o
Q*AD0$?1AE
(b_1B2
!78	&A
py
i a{h a p
`+``B
 	Bpi dpdaQj ,h
}d`d{d`dKad/e 0be
}b^Ce buqc1)b
 ?{b
 q@c `q
pzabrc
c\/_SB_C003@ 4 6C18A`K0C
qpha
5i cc
hr@Q! +Di `bbE
{h
 th ph`i
r`bt b
{b{ /p
bE	Fp\.3D` EbFaEߕa`+!ba dwd

drd


 P61at`sc/,ua=C310Q&F!{	" p1$52A%@1>e
47
p1 AqCr
1 U2r3sB4C (  pZ7FX8XC``ڑ6 YAD:q0p
A4!X 0s 8 9'(3`
q./3`s5 b#r$` u(`+6a[ADD  2xt\/qVTZ0__AC0paxa

`bpA(0brb
b\//CF
g
 b2zCKRTzr 

9

	
 !!

T'-*p
S|`TGG]1V&13[11 {F(@!4	J@G
5pRPUb۠+@1EfA4F@50ccbpcbB	  V00?qvbr"
4!Z"KKS'`3[PbPMbwb

ara*MpLa pF2 1[41K=\7Da`pab2\)aPj3h 0qr;hc a0q#g@mcpb a$&Cmh E{tbA}Axcx#{yb pchaUa2`(  v`bB`jhI0SJ0p`DA#\.B
|$F5`h4rb*AEIaN
|nvh `t`b`x`@fmf
Gf
f qtJcbb,3Bobq`sMCat)!M,DN
f1CAqLOMH2FIUO"W-3 	 Bq6*f`08    PR_CPU0 1w[:d7@_STA _ON_qkBQ=FF(8*9*CAM*IB

	C O@QDEF`I20	E*21z%9Cb%D#q p2lT t
(Õrq 9)<Aa 2㊚9[22_INI N 1_HIDA__UI@P60 	17[U" 3MH8CE4p5UA6
		UB	7MHCCU8

D
9UEA
FBM	G20CC
H1[{D
_AL2 1CAL2AL3A;L46a1UC "1&C$2FOb3fR4A
@'_TMP!/`v%2,2v@W14 UHf	PSV	F U L;^_TSP,@%TC1%T#C2`SIaE
B[A " WAL5BEHH -CDBdJA5
@O@`p`֤`[F3_pl2a^[MP4Is 1[G	TZy5,H
`ooo`4	`
d`wP`r EDt32DfOpJcOaE F 30 1 2[Z33  4 r31 5 34
[ 6@(A3728 p[ A9 A`d39UyA
	`rh`Я`kF	Bq361c@aJac
0`rd
  b}y   
 baya
aw0a2EcѾ  eraye
	 evep}eFc ucdcM
CrBcpc  bpbgC	bdp apbe)e}c2Ee ffg
fape`pfafgvdueϠA0F`[ gTb 	`cC2F$g~17agg7agubdMD087pŁ532p0`c@"30 1` u`?pyC028 859 8  0B "Ғ Fh H
bhxԐc `r +Acada
e֐@%-adft`f	ru'aduc2ftd cgq;`5b0 7-EQۀ,7&-6Z%CD`Q&2 /
RB
Dpibh	  C40
j401c11"bF@2 w6
ar0 b.0+bab`babuaaxP `bua 3/PKS!3f`20PHt42DR`btX3E``6pD9XD!

	         y p343QHG	SL34GdHD
H45B
^GG  @    5Ps3	7	P 	 	^45[7K34W4R
1D9N
zG	 G$ $ GN N AP P Gc c Gwe e g gwt t     @ @  A-`1F5


WC090p
`q ^^.C1B38\_S0_ 3R 4z5   M\_PTSph42HhAh
Y_j o9E @238 2G7\_WAKa EGXu-f9<+I
_
w5A0`y||
|AP~Y9||O
3æa
 2r 3={Uzs08Pz0*H
 \9
~ISMI
=#!hxpzFD[1EG$r
0
?2345Q 
 6
В007b3Ob4acbcc:c1AF
@
PR__CPU02a 
 mq,b,19`fN0EP+F1. pLĀ\=R; *11 (LACEL/C22C`A{ME
@B\_GPEAXA"L?_L00 PkR0CF
 j
c?0
`Կb{` %{`
 }a
a{  {cUc` %{bb 	;a
a<Sۿ1AD} Ea a301d}dc7@;&{
.9B gI:g1:1 C	09R96` u2CZjFBC102}
`G@bH+< !["7J*FO	A	;&%0BC21F%0qI

Ipb{*
+
["
dO-Br2'BCp?59`H'C`
L1 O"v7FC128@ C?C268;E`
ᷠqP`3U`
))r*'jV$3G0H4ޯHO (9 gH)(HO%0*_'oR)Rp'|'' T"ok[++ +So+o/]q"B94$CeDfC!EM!3"I_L17 AE_?`} [@EU51E2a Q 4R/m#m9n{LW215F7P3l8P::*(=sq;
!S?̮TD uCV
OdA0` qC7`q7 1J}`4BH`9Dob`8@LMs>PN%9Oa64&!LSD~	%W
.}aA  `p`bAߕRWr2EP|E(		PDE31	C|Qݻ-
ID  BB
BBBBOaa`Q	b c.  '8nt{a*ccNQ(_	$6@,.D{Ƞ+D[@tA  ?
[ Fp
 OqvGhv|61g} pF&0zSSD{TYҺHP  HPQNLP _MSFT@PNI_EJ0P=16#pPPTA ?: oPATE1D5_ADR  [Kpy9"E50% E_GTM? p
 S`p1 2 @53pDر E03{P\!q
pa!`O_STMhhO	i @`_p
w7`a:` pA` bwb
bw`
c@ib ac  r0  rc ua`A
p!abq5%
2#BbcapP*h^9[$4d0F 4ha5
6pepG13E
 
KTd6\6
 19\369S3C7>[ׂE173CF4pH_/SDD"!h+!58

 ?  ' 9 UAc`8B9C0Dsp:E#P5FqՇh
C360p60N5{9pAp
p
A 8ΰAC CI#CCC 6[O _D,N,,,D
3p_E_E_E-7,P0p
xp
}5330E462kԔq346 )63FKJ
KKS
hT
LJ
6 5 5555NNN5M
     N    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй *s# hfP u	fXc  h ǦZY[Xg&ǅF C9   Ã tfPfS
u	{p  9f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tȎR>tKtETfu
0]t`t	dpX  f]ZYPSR uyvhryv&2qStN tCu+?7:ǅ%. *'<t<  
+Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3Ҡ;:  :t ffKf;+)a3  `49f 'D%g$ЊFb	艐 F-葐r4Vu'v
x l %`^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
Fff.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfV fKFt!hu\gvu U>tU6f뿢@)_a[af^f!aFV  ^SQ  60Qa@9taT% G舆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRV u2lr QER: ߳ u  ;&pIS]0`@h1	[( ZP % `f3۹ fs_Ձ@T@" V2: 1Bj0 fy=EFfC`?	5	_tt$yGv葕xs~ !"Ⱦ
Ќ (o
d
~uW
1?MSiqp1~uZ/'7FF}u #*V$^fȢO__o0Vﯻ mX^ҎD	%ÉD	f?r2fpɁ v Ss<v PfUf f fa$f6f> f	>fBfff]X߀ t @PԁfPQ6[f_~RӃf3 cZՐyP5b> t5zV`50@@Y!|p5 ೀ
P}@@x6<{=f;tff* F#cG/$K ëӫq  ~gfEـ>  fù& fσ;t)gfm+ C k H2|`Ekv tߢqzÿzPVw  ^fh3 ;u}; n0;b7yP7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
 xy _P b6_PSS N SPQ O _   _ _  _ _ _ @__  _  _ _ @_ _  ?P@kЦ?1?D?1?4?_>_>W=r;\/D<Z1Hl7HC0H9HF8HI_CST pP H`s;Ga H	#
 


BK `
 
A
of`qI T
9
dGESS@րO3Z `C
*OeA&KG&e@I&C_C1__Q
&"1n6D6nPmo:n\ pC
nIST  43A1OU0(:L*\q 1d`xL
 C}"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)G؟pXq9SAbDAk
 1 CAP0IID  1 2	3sU9S
 E  1c`23?6q 1223ޡp
!
  ki_
p

G}B? !L%A9D3	 
	{ } q[=` 0   [ }I NRJ2`M5kH!7Y!1!q !!!1!1!!!1! !!1!1!1!1"!1!!!S!C!1!1aF!!U1!!!1!%"!1!!1! 4' !
!!1kf`<r^faf`  ufc3pֻ0v ) f!6j,gfwP׋F GPrR(W-n<AvPUfVf>n, uf% j ffZ	f\y{, a ufzifr,鸀, 
Y j,z` 20v1 nf?WfA_fr1f
={rGXZ0r2虆f`_ rRfGf>|,f r<
r7 	`g&V0fqf+Ug&D
3G#NafaY
! 4f	 g&?u@u 	t`;vڕvu&9OpCqQfRfVfWf-sIg&wOf! ff9
f  +pffff+g&of0^fS$@f[ @    	`@  R|5O;;O SZ !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXh[( ZP % @Zf_ >;u<aPS- pu;;` ;;;/;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; P j0fdQu!;! ȃ uddfdd l >P6Sd d\dtP ʱ(;;P:Ug&t=` T=f]t,>@u%ttt t	tfN tF ߍCr@uAalaCs
 1Qh 6-buoF . u$
TVێeS tEbrtـ?XD@?f `fp`T fffXs "qy#uptLe; ` ; uY^f3ffe;gbfWYдe*&;8fw*fF*2t*܊e&;fX^fY[w'!(; kW" b  ĀuBTv;|  tB2|k}SQVWU& t r]_^Y[LS-120ZIP 250PSQRV:1:2:٢2ؑ2PKp
x
~
5	<;2E:k>
s!hfP u	fXc  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfG(`*X*Xu ͠HAZY[0^`u ;Q;;;;;v0 RW1h27

-a} tE@/_Z[M-SysPDiskOnKeyP#jB ut @  f<x fP f(0QA˹"`z|= 2r 0w"1s ?sU3IH $ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&,c-\w?t,f_߸ A% rLTf<Q?(UP5Qe}$ b
ԯ1p<p< t0hƲ4t u u2$3=@Af?MpI`N 
fXuײ?0 000J000FF 	  FPRdoK@3W~2>#>;2>
a_YhG; 4  hZ| ZXSW0+@0s!$?
u$˄[y_ - ࡥi B t`UA	qAq 	  8
		 
	 						8
 fWQ ˹O?Yf_qD=f; D=;FD
$>;%
ĈD
%詠;IbΉs@s
<rI`d
Qr7R[USBS{u\ t t
U	 	`;KTB <;9١ p arQr,< C0' +% 7F`2PsD QrIt2sQfFa׽fAY{rٜSfigf^qf@FH\
؀eˉ\b$K
prA
x @
`0
!?
0
"7sTq
aWa'"CS#PD=qq0*W.?43'T2'úg0^oZ(ڒZ(
_7
qO_=%t9T$RQ$2Q	@ ?WK@RP2 s с>bu g&` T=
XS<(fiʐA & y~j6; ~ r}fPQt:A3>Ϳf+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9?y?,B3ПU+*/sG/%QfP<h`gffXY"~Nv0\OސJ?^;G7/Osc`sMoDA b@Ac7e=S$l=38%p;bt -bt !b`;D$
ƈDaz ϋP!l r
9rYAݿ /p%tFIðtT= 2:t+:u hoety(u~~(rt@b=@t-b=t!b=`	tb=Ѝ bq6`oWfa0V
<8dtd߶}٠rlپ<8Dt_D$PQFxPhr٠dl^SQEO	8t`g	G	҅< !" !  3  @O 

  !vv xQfWf>_l Fo'#f_YØPSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYf[fRfVgfeG`-PgeG,fQ"!
6'Ps ,P!V _f^V;wfaf]	6&ys'&P/ryRvRr30
?geu t0 AO@ra'P1806*i%AfgfC  ggf	 
s>r8PjQu:YrPiAbp
fMPs
f	 

 { 
!U?W'eGseG`~i_VRP 31P@gZ!
\
(#5W0
S
B
%?q}~r$$ <
`flpcC4C萟s!hccoreeJ1*A<tK< uMf5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl |u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
_ww?`}pR翋qx& r&L&T7 <|PFh3P(Pf_\3VAf?_ffXqf 
qfXuײ? fffW Nfqc:fp]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF}reCRC5P5PI7+6p6P b!1fY♠
W 
KA

$I#j
p QY6BeQep+	Y	xr1 /
U2WQ
s⺑SAOn}%tJ?wA0(PZ`S1_Xf7񇟘Bu 㐊_
u }% 
 !?g!%KO 5Ϟ     }3f  Ptot 	2fp ufxqtp  >tfq f	bCfff@Orfurffɐ+fԐ%ЮQSt3f

 sఠqr`QRޑ0cD?f3fAp@HR
fâPXpAw f>l`_rfC
.@VS&7 ! P`0Uu

C	ݾ3ݎ˵fmqC &V" PB3
q a1a!@%[pxtff Q)`"(! BRUu@$#o%"*E   u=s5# r,Hr'7
 NPSSg
#[@P)'C,R"G-
"10v)%

2 }Vf>/U`˝8?&B?f P?!?Dpu%f<E t
t
t&[ sPf
Z͉6/- gwFq	g7gFq gFyps fbB,3u +0+   < t?  ;v?ȉq tv  f@-^fflgf
GG͵gG-  	R
 Q
Gfyǁ0ffHfbf@@I1&} t@q qg fy00SfRg fE3A,3;	@t`$2f&߷F tm	DG^^ϵ!  sfu@Q	Ffy  ǀ=`G
  A !Iy>					d+ఃd	@	nO	@	D@4 2@B462=fAى7K"xfݹf59щ"hRa{TboHfuKZ<0i f&$usZ@U t`)% efc	W\Du=F t5f\{lf  f+8f;rߔ      ߔߔ֔ЁЁv"6_WA~____T&䁍ti@____YS __________|___b_____Y___XP_S"^ ______Y3uyU=6Wc(
   ____ 				O	0ScfSc 	Z=&   vA	w.s  q@ D `@  "eE `i @w/
@ АRj@F  Z"z SR  hfP u	fXc  h  Z5=f3fZf[lf M@Q~gfwe@Qw_faEA	>dlu?cl}@fQfCdfld 2hlil%PWf;f+Va++ *@ f=~ ЖfGS	XAhvUftQ3я_;ad̿ /p1Ж$4	C:cl63
f
?)I34ө% 
3и@tBՠEuGf>%2ggefFfGff!g {@]] f2+ǐ?fj-Ѿ@t#of+ qHt-Af
 uh97gk)c)Xt(8{;f	 p~7el A}flf_-c;q `u @Gu
g⺀ele<>tf Wflr lsc`u1ge~M} 	C =OBG рK~f   $<Pbt΂ t
@ >hP
>i~
 PHj		%PgP3=- 	 ?D9D
eVfrFsr?2 r" f( rFu&&P'Psp_"Sge8Ftff;rqK0D>$O 0 ,d0f7Wl@c 0d	fВ`f! W jgg_$"/ւaj_`e{OeW$kGb plgq2bY!BfβA cGROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
qr   2!	A.>  
 x  x uuo        St[Pu&u u!KrouBuB ?C > XPS tuuu>uuu~ uR[ CruïKuuuuYQ	`P[K`
3؀`u&svutv3 upVS@t	V[^0QVug&"uvpJ3fu1uq.4ߧS1ਿéu跩[^PSVfU>S>zv>ϳ&wvt(
ug&uuN[艳f]^Vt>uu r1߻vuw%0r~@!60aSɫuP  5[6̨TWai`z2穀ОQ	2pUt1vuIh[Zuzv~yvfPSQxvĉY#\SPćuff3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvb?yLr;(qurqsVW@fFtAQ څt(PǴ:vvu 
  gXfC[Yqq q9~ w2vvkY?ⷠuv`Ct&tv8r #>tPw{
$_P#0%uxv.v2 uf? t<CP<tSQ@Kذ&Y[ـ u
lq ` -  i8_ @` @8h
@ 0p*	qk l8 
		
			 				
 

 fWQf&D=QYf_侁gD5 ;6;;ysR.;Py``}D
$&;
Ĉ?D
 1Fs fg&|5 EBr`r  a`|	 		M|0R		`R}H?\
 {;
܉\se7 bb}Qoab}f`ߡg&`r ql=Br`h >;bt -bt !bt;D$
ƟDf-Pfp&߸ &p;W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;连j(wf
T= &Prjrpbu6;; 6 rDQfP.?f.6;8+܉fX2fXYffrhl*`	 Y*a 		$Z	hb %G0F
/
PsV ` !sJ%|=td%"t+T=:ur?|`B(uq!(~rgb=@t-b=t!b=`	tb= .bh27_2q62ogfaaoVPCL	;t	wPAq$ضR}X <R^ASQ2|O	8tg	G	ßY[i0   0    RoO d q n  A` о 0_0 3`  
& Aa t%  	B%
0 #
	٩*
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
aT S<R"G 3 D%M TVaX'K8'(XAIc  WpI O  x fSf fV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 ffYkf[ f PfHzRf3ۋu#MufVku
 @ fC  ZwW fu$޳ -U~T fP%offXrdqPt@5f90f  f
Wf f;Nf_AS0>߀fz薶r@!fff]f3ɠ  0[  U@ Ԁ   U@\ Ut@dl fVf$f&o~   wt   
f}D`fd.f^<wtP# Q5 R*Nhz4<t
_t %Z[_( ZP % Qޠ$0@f"E$!4",޶-PS1#|&3M38t< t 4 v-#tt 0&#V>`OgV8p < @DHPMr:t"`B-Zݡu-.GGa?;-?rfTDaff} DI	fAKfg8u#HDϵqQrf1s
f@ (`+1HSHPS'}? OO&n:`f`h|(!G@<<t<=t<>t<Ft<Gt
45z5qGN1Z]    %`M3f0V| tf<x  $ fcP   t#@r7fuB aqftQS0^fC`BUc U44`f&V f>/q% }! eIf!ig~>uPi

qCDq; ^r
7rC
°Ro-?  &f ߡ6wf  sZqf9lu gF9u 9u
gF?9͵tz2/g-tvVf>l  r?xsFf!` gFqg^ g`A  ^Fq 3:`kF^ t	f#;QoG;.;f@B23
 "4 !Ix	`				D+@i	@	nO	@	r&+롛   0a }BM ;vȉq tv  f@ 
f`3fۡlgG p ͵gG-PA	qGfxi@U@Y՛f&Y8z"!1gGA&@t@ af9Br SfRqof3_!^5{	@ Sfttt.h.uu7  V  	  i@ Ԁ Copyright (c) 2005 Intel CorporationN1OS@eP%2p`"ѣt2Cqt"Af%  =  ҟ <pdt<tH<tN<tL800uxuju
T4fPF<:f!a<ISGou%fц	f`C s
gJНRVfUf❁z f6bt*ZpGt
B s ` nouhC%t.At#Oǣ4ǣ%>ӥR#S` @ İZ-% ` $fQ]]aUP.W)`t411wgf#f  ϊfYR1txT	ː!,	ba'""ԕR4bSHЏJ
>Pe]֥u}xt*HIT$$*	g&<ж1	2a?5c	07t$N<t/5)
`FO0E	@HK0Rr+5$Ad pT6g%q6jqf$, ;g[S.y1l?lSMQ@	r#<0~^W:XX`q @O0 u(P*P  rwyr} Yr)fߋfWRdhZf_rJPSflp>8Pu	1Pil3 hl&P%P[X} &zs	f d w 68PBA*P?È`
 fd!7P! ȃ ud|d~fddf@l66`>>á0\ dtffd!! d7P!gewP Wttt t	t&}z>t| Ƚs
跽s1|SQVƾEbtـ?鰽&Dѱ'߶fATff_fXs2B	x3p&t&L5P 6P ߀uYËiވ5Pgb>W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	&  	-a&} 
&_ZS/-e`&-	
[`9t4hƲ4t1
&u ?&uP@px
W  g&?t?f K(g&~QffÁ (r~cfvg& uxrI`@PeA
f  qf  paG,(i
 !m
"sGkO8b <fT tf$B" Qpff
of' f?  ftɥÓ f&
pj V 0 @ s	<W% <t+f R
 %u<  	 z,R
/"?r>f{	%r
 PBg %O +fp_U/ErEF?<p)  
 Ѓ@ η`#ujRca$3'='pf 4"b',f2"u#}   qsZ ] [ \   z @ b  L ` oa e^ @  A @c 7g 2e @ uf @ @  k ij  @(T @  zն  \ @   6`gVf.VP Zo!f! ( @O |'E$0 fpP	x	s| L Ifl  h@ Bdf?f;  Wfff;sgf9t LSf_ѱ쟣f-q^ZQSf3ퟳ hVOetowub$r	tf1GI#d4@  $t؃ u˸착ա͵dոfZfdTfdTDA$Rzh۪W!pw!芔藓hLoԀfof~ ea.d@t0WyJf`a؎}  @܀g_fapq23 g&s g&C#gӋbSf3Bpc0zC
uBUÁ{=P>u`zt  X +R0ff%f`O@UՐ Flyp_ZQT0e rcL~" 	
сD. P2Xöf fЀ 0	PR$Z  fPx{^pmCX zCׅC >#sB3"     ;?t@ b~tuft  VC4"Bt;'B(Bu `o 9QV *N0K`!c!ЧKm
qXSV [(ĺsd^3#g&KZ
 4CZ
ܓ@ Zd t 	
 !   ` "`aPva{ JQ7RVW   ` Sx>"ٝ್ k&q,pq{(f{@C!	u*:5:6>6  66p 1	|1	wP"~@ w>:z!K$33zn!	%@uQ VS&S?3'1u*xG# Gu` $<܀Su ߼PΗ;tF	t
 w 0id:u> u4d> u	1 t#u9ufPm5dFރu<u2!^u	I^9 _^Z7g&8!u	g&g B%DtFsPVS Шu h8^:RVȨWu^_*/»ب` 1`u0`Uf詀(o
tox?f]1; `}r;f.;t3Uuf=#Pf
b`?zR߰yË= v	 +v9A3{f́  rf{fvP  6ᙿÃ tL;Sp ݉ Pwǋ;@tߋ .mNҠbLf1r9 w0`b h>[Lʑ[afϋfQffffROMIfMAGE;u!;Wtpg!3\3KPQ@J 2fG}@ZYXu@nwa G*SG "2h\t"t 0 t	V  W\ cu'f t!AUwb
G94 G7\WG fCftk27O0E01 RD;gf?-   21"XŤ6+- pHP."Pa
>P1\ayPrbn ##  Q A7v P1	!)SV.etv4q^ Q Pu>98SR $u<v
7::,; [8 7Gmrr )0PppJ8  u)xS	بGPp4p9v9`_:8w/?sp
QQ	 tTadV
ow&F-org&ۅуt
o}ro_dr%#oKrQo2s
 Jkh_a	Io=7	t %,o 2?f#n
u0$MXp Z$,q[p&p&u`c  ? DPeа?t<СGfVf搩f Pf`表!krПcfǱm\GRБ #aįf f%f
 s&'f0Pf	@ sa  f}&u&   
ڴ4 OD T0U ab bG `g!	O`SQFZ  NZhFZ~qR  >b !=  '| da c%,Cދ ${`D0sO4~7f=	   0$pY ,oX 6D@vfۺk xfgEٵP^ϵw͵*bl			fǵ5 `~-Wf>ǵ)  7_yq_Qp@~f% k˵P1ffE/2f5M9 5`xYt)` ;sff+c f6>a9t
3T1I!APk
 !
f=fof1 A6 fffp	յf9՟r
f)p @|VVf?_Vf^  u$fӃ\Qfq+f%=?x h1
[|_Hʢ\/)~]/IfVQt> u ~Q &*:&  PS!
X~h f Ӡ 8r
Z Q0

h%>@t t  ~ #fp+SQ	@0*0=tuf_P9% n0<s<0v0u@ =N_R  ? fLSdx	 rk6%U0f0u @~Q f@ ߋY#h;3.<`w$hӬ;`C! `! ]>ftg:Gvg_fgV !тIf0ࢂf
~H( XbWt%h@	g&G  6X(Jp.p tp㹛sf
"t
p $C7s2ZhL)@ fff1GȐ6Ƞ\* * GfGݑW`dȣuc@tU'ax3w6N=t=tO"t?C hVO4r#
uU0 fd&2
z oZQ:б ; nu5fuHpw na}x~f#~ s<5	u uztI S01Vt)LfufKn s	`s4te[}0uuWrZtuL#[P1Af0UFQ~Vf%
&
 =ps uv0_  u*f&VB  s~kfo*Ӣ=RSDTu}`w_$!f=FACPt?f;vVfc!Ow u-Cѧ(_b D!+4T u ,3$pgSuüPf Ȁ}|f!" u	ClP`g3 W23f_
 G	Z^pu#f0₄ ~0؛铠wgfFf{fۃ>u2ff@ s 6oRpg61p>{gp^0&0fsPՋ>BG0{AR Z^R _ ` aP&abpZ&&FadXPR< u@S_RgtXr),uRG`SQr9R'״$8thY[	tr$VO㰆HAr(QSFr(!sq轳trp@ppq[`irDrT~f}iY0Yd>:t	[ fa !  rTvy La@f`yt>A _{ G{faa~h'`q e>wAkO?/P#S.J ð@ð Wj@ȰKg&Cp&Cf  @_@t} G QH!A	W 6sf_ҞVfWbqwog@g<P^fuZf3gfACDff@rg@?C7|P@Љ Qg&;t4g&Ct,g&Cf4@d$<12Yf٠
t
g&:#tfCfYFa;tft S e޴r7fg&?F t+_`Omr! g`Gag&O@` Nb O cz_ QfVuu=+rB f UrY(al
"Ȁ$
Q3Ў{tK@a \_f q@Q<a迦 ߻8r p312Kˠ P<0U `<r<9Pŀ&Yqtuq= "t؀><~: sº7g?   7d+ A4! L* R  X
 d 22 /U$ 9( C Kw U##GK~"
u
UvPnȇF X PS P&[p YȎ؎[XPS?[Ȏa@sXބQA x @} fP& pơ`gP,qQfX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `    ( X(    _ ښ   u ς  g    h cX   ;p    / h VwS         ?  P          %X%H_&                                                                                  3f3ۻ  f@yfg!)A  f" 0 gf+ >n `h27fPpu	fXc  h  fUf&af&>` 6a  !ŀX[ &SP`@ /'a&&WP `XP&EX% &E_YǨ dooooǸoc< up < h <u2<a
 1                                                               UPRPRVFZX}0RR30ZO                               a{ Ѝ
h;3   f`ffot$op$Ūor쪺  .<t
../ժ NA NfafPSRV+fpr؀tU./tA
 NUNh,ZOd^Z[fXɨ4 ?h/_À> t%%f
`fft6sPSfQW _fY[X ʁx |ʁ?køPRBZ B3 $ `%>&ɺ%	 
  3  t!   fQRW0_Zr 
-RZ` XfP2T ffXýf
 $$
 fh_V` 6 6  60616 6 6aPQfW =@Ъ f  g&?t"g&Gbg&Gbu 01 uf   λ(  
uf_`a$$
a C PB 밀B;ra`H%;譺,h'q ˚]Q  7* :V ,
 22R8ĺZP 쾘,ȡ%π(؁ 34 `g&Dց4 F*
 <0vR(0h!!nU:f`1 fpL2f3f% 
 0p!P!q  f
 `0XXw!Kf`a"f g?ff%@ @ gffP] `BaPfS,)CP0
K   g Cw CIhFlh Xg?&CfXCfARPfV uf  guugf>u
߻ Qf^X A
f!65  ftt4 p { P7hI,fl;f&'qfh@ hl^'}hz&@d& hf3/
&G4pFtG_GrBFBt
6
f_pg  !hf1LU  gh*A   ddh=< d>il thLFndSRh6dCgdb0WfZ+'Qfff f"% f_dSl41;AfdWlffa6ddl fݩ^ t fdclhLf  ed[l pb_lfdW2_f; Ae{fYWf f_#B*J"eRd轾 ҁZPQ:ury܈qCYYWAx;T/;  t2&>Q1  ;j3 OhmoB4_PRb^ hc,ZrJ\Z ߀&F t@Fp>'E r>cr>ZR%t;7T q0 b0  T\*! zRp8S0|hw1 f|~f# uOt R\f Ɛ0t1#%9tf!!@zt1ff0 t0{f.fuf mYa! 
#9Y沠 m`a * u31 uI80 *0/tCu t	fD< _à@gfSVs<r<?wh-`@`<Z_u0ж%ryз<P߻ Q^f[Ð  =f`ai@tptf@g`l>0jJ Ā b _d u"A=
s  	`=f `0u aV@ɐE)
`p %@ 7&%Aܑ Q\Qƣ0Cc#@АG%bIiC" 8M!''}V  ~ Of 3Q'
f~Qɢ0R	ϠQ s'g' Mp
`IËfG0sC?qfd3 5So؁ a! VP#ot6p%ȿ ff`t33u?^ x@R3X3t@s9r ` ( hBq2 *+ 41 q́obTQ/1@İ"cjy&?$tT
 QPAW؃2q2PD0	Rf\Zhsl h*s $ T%f2g`1PSu<w5V$<w	iVA t<u> tU0uR uIB<t>ףt9u29r-@r!\PItmG! _ p/áS'tZ|tKU9r3Ȼ 薞s0G <u$
 L O  2RCG"9rPd tkpS3S	
   SQVȾ#0 8t"8tŝr[^Y[eApt,&
s蝝>ut
$lsET>t> u.-}"t$	&
-s@ fP
tm  >	>!2
X7ɡtI +$3`#ȡ褡tCƠ # %< t'$  
u%躜a>؀	 >t +,tW0 P-u@.g *t%r0.> uBu
 ߴi  (Ƞt#诧r1ߴ q4Jb{tV 
Ur j6G#tBH0/-萛r1 //YD]a5t_h5&tP ߛrBs\13L5svFP=%
X{u "265 55B#輟tzu {4طc㚨tb蒟;sW;sQaU4u	,u@"
uEӚ"
23/4谚  3' à3'%t`b2@M) !)PA5tXS/!
~tp_8؊ ["M#j#cftsg]'  r&
0]
'< u)50
)u$$t$
 $'). J jH
*U PHN+_ VH(,
[ H-
% M܄W3 ` ht-c   ff Q _p$tBg6tO蝙8t 莙 u
8@XFQS n[1+Xfs_ qSQ2藜t2ÀIISQO֡=SQ{BdR74ꘊ3tp, *b5tP 貘[X3t8t=蓘`a
Q, f`>*C
/&r
u32/W~"_@H ErT &&E&]~  ՗f !
>1躗Q%	f c{@t_f>`PNݸ`Xњt3 tfDIVNfgf0 AI  8  2gaQr`σt.!FfGYqeP33߲,LPo(ʖX`(AS@u%t _荖2Q.p&u#>Q`h[9訙t4xt,0 @~~.v2a
f`ft9 pdBfaa`Ht{  8t 2K2$u _ _ ` غ   nBnnntnJFn aS  À 3ێ7!C &?!CuC3ۏR .;Z`hof:o X^Q+'&::k}>&v.pu	 puQP
,^ ts+t@QWP; PR怺NhX@.X=X@uX_YWQՊu{p$ qa!.n-$б:rP*F+Xt0`uQð6C @B T A@Qgffg<Hu.g=:ff3`eff3ffߋgfffSC<(.&!@;BfsD?P
hh"
4	fR諷c6Uw4 p

m(
uXO0fyZWf  _fTj@]Np Mp 0XhPfRÃt%tg0&g!ggf`fZRft9tg>E @~9g5CggfxRVf),g>E %g> !P(^d`g
^
. U  f! "Q2` 01_YZJbP0a _0F`0
tP`ձvؠu x`;؎`Rf쨀u ZlOfaan?  @(001}k}@AEfh3 p=ǰ  D  &E{t"D  $D(Юs `ف&tȀ S4>2@"oQ
g𓡂
_ 0HL &}u?p ?u8&= r1	&
Ip$Br P
` ݂ m  m dm p's 0a`װr * $OQa	 & a=# $$<@t"h_STSKuKK<uK&Ku`.>}st&3r	#rO&37!AA&Qaô`prrX ? 1tr_<0vqw#8:9Pza){fRQSx[YfZt'2 tu
| eya0r&C
RADjG>t  f谸  h\dp菇ruf}нQrfr{wd3 @f̋0Z襆r<fffHff#f+ִ f;wߴfё3g&SѺc0ff+f뺀
] @,.028 pĻH<2;C;8|yw>X59x?8,K;/l|ܤxUzHwyDc;w2@U_ 6ލ#16s; Z?K;2`;`Ⱥ tЀ  q&aPRu1   
ݡ0@h{Z! Q   )^pR ؑPfffX fff݁` o˰s?  3 ` ?
PE""ߑR787 33 ##}f 	   8f P0 f +Gf0a4ff%\h ft0/"@^`    EyaC6
P
f8	  t(	!	#	RfPRQ$% = u
M= uL=  4`& W8ް6f1f_3&Ü@Y@ 0- (˺,Q 0 qPD UQ   ,A048 ҢpWZ#!B`R MP%d#a#o&    ih[( ZP %  G  %_Ö                      vY`00 	3<ɀ$ t		T 4<v	4N u B4<KRPt@B u$Z0fQWP C	kXgg_ Q
`	fgapNfWp,3f3ɿ6<f?0<  ߋPٿ7=f; XaD at}5<[Eù@ fPfpLfX,fVPАP0E gf^! f^	V	R				:	^	5<	^	n	f	W		`	_@;g&'.G`@\0HQWV!  tO=TS"}!UhhtT(Q ysYl^_>uDJ7=p
x xa3SV[C vS3ۀ>@܅taVt:aVt pC Յt<w>08 ᭐5
 1Xñ ~ S  芅t,} IO !VVVWt r"05>`fP	yRAVrA aЄ	 fX`	td譞]P	4Q@لt1-w㋇V.trzwRat0
p0G7C< t
8C:@   V >@ubtVaÉ  H)

p/I% J@؃@P2
s3y@si~  Y &
1F0\CCCmH:Cu;pu;th@pP7Cкys7C!  CCCCotww
210[Cra 	߈&]ѻ
dÀ
vw  {>2d22tfRVhƲ??TtDh/5h̴hrr f^fZ?f`2 rb" <pCTvrhf0fPf`QX
bf3a//8qb X!7"" ϬhGtc{Qf`/)
4/O
 "	 	"	?/	(	&!_!!!p!hotÓhdwG	f3f/f
,B0&su` 2fqSRt F<tv$rfz Zf^tQVWrQq 0 _^Y}Tfy7Ef؁ePѣfބt
t^%S^ygfQ?3\1 P^YfqW|PWVh?rGыt(
tuu ue tt uʋ?^_7fQf`;Eb/4;EG Cd6W p 2:> u6 GHt\o hz/T3Ҭ؋hoeB^_`P!f
K̈́
{>
2
Y
T[>T2@OHp
N(u.
~PϏr22dgMU\L7`\U/ \ao/ / /  OU\N<RwS2.L[0ø`
 
а	

fQh_DfY\lQ P`FXQ&G     &Wf&{t ffBf;Pg&Gww~rtwRtpff@hɜASp3QgfYgho%ƴAXГY[Ua>taPS{ph(߯WhH2f[WO   &WOWO
K!v 
8s vt 
tȰaV$<
v
ط   tǀ>OO t r$
 /'$0 u
d t䷷P@ `^!bh|
}
0d	
	
s	 
0{u OO&POñ OOPOP>PO u
8wPPPPPPQQQ%Q0Q;QFQQQLMOQTYhzM dzMRTY_^cs O ezٰ RW\az^inuPf}޳ kxYcnsx y^ikpORTW\uW\i ]Qà@ PP ~pXÀ~R,0:%  3` ZQ<  q,Y {f 33 3ðG}	  Gĳ	P :	XuRB&D>m	bvS! u%qY2 [2P F.X`	@M	29P{2ې/ˀa	$

Àu<X[X ft1at؀a
2t ,P@<KrK7X PR0 zRZ01.R BZ s  ""
ZP1@QSQS Jq vJúQ R (% PBǅX
	Pذ4%fQSW  _[fYh Qrt7>t CT $>p u09  >b\_X`0(u< 8qt3mr-<t)mu
$&or.a𱠴qt%mQt2tBg&G Q !P oulWou'> Q2&QtaM:k  
 MdP:6QW<u
88y ;8{8M_<+z ;88|ϰ+"k~bٜPR~{NZXWðuh,ZZvq	誆 Y
| hp8_d`T\ۉ@! t" @OiOa
W% AA {A% YXX r x[WT\WQO[ WXOA<ƀA! T\% VVVVV}[aFWO 76Wi DV% Q0.&,;W0|> {|WW2~_s 2||{c[{UV<20{2 PظW$L y[.xx>\=Qx^]xx2 	g?sPh tiu%?thu<%r7,< 
]W`@uC`
 
 Ё-ò  Tq@AssLf.f@- ff.q  箰,' q1 'r 8 a KR3 o1Q	$?ugqhiY/.eYp&3YS r0@pYr2r<wAف.t nrnu_  ?Bt@(ۖT2& h[Os^氁uuu&gq 矀]p  Dw[XPyXaOghKUvP[F X PS1&Z&Z&Z[XPS"ZZZ~[q&~[~[$DqdÀ^S8rddвrS<dr
d2* .Oc躠@0oStpO\đvàÔ<D bUνP?0P&XX                                                                                                                                                                                                                                                                                                                       p( f fo龗hp8fP u	fXc  h @   foMgeuge&p #t)fSK _Q f  f[ 1u $?  g
ulfe   h[q ]Q 0uIe	:f f  gf&e /-ggø0&&o  P            $ >        w < h  D ` d`  _  @@   ܂w @ @Ub  "H@
X \EHT` o1 2]L 34 _0                               Z 1    14   @  8 @ 0  0_ 0	6	T,1l        Z PXYhijklmno 	

                      - 
_,89:GNNO OhiqfPfSfW"r@u  h'/th(vf  0i@g&OZ	(f_f[gfX0Z &g&f   [#Gх  a(t w q[fwXf[XQfRVW fk Q  !Q i A!!ȑf%}uuf3f3f.2fffu?_^fZfYf":Q ء f' u}
f0PR5 % ZXPSVWfQ `-aي t
ut upf  fp w h*_ԓr ǀu* pv @uf  fY_^[X`'QfWfVpff
  ffmt  p$ѐ f    f^f_Y# ¶ubR5 ?  茠fPSQR	0Ƨwq-q-f"x6x+@ f-$<s!h85 !@QtE1%<@1u=t
@44Gj6y
sK  *P
f>6O@
 _	X	;'>>>
sǺ$>> foޭ"ZY?,-./01289ioM      `a{{{ 3 vwRRFa`{$a,PG3""
P![2t*:aÜ`>@ l> l!GA lBla6~$?C o! G @ A  B  $0sϊF  ؎(|n  "(|  BnnnJF$a %JFx{P {<{ tq ̢{P {̠_̡УР&|ޢ' ޟ{p8@llB  ؿ{ lBB@| l@    @ l$|Т_%|N&|'|| /$а 
@  JFF/n  	Un	n	n	n	n	n	nnn 
 $|%|п t{ˏ{a  K{PSCd(ρ΂`  3nnC q
p		 nA
` n&|`4'q a|4!IQ'!$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`ftfdP lerFrAfW}f_迗 1 hP/?Yxg& fajW33۹ G.%/Nޱ߰_Y 
tn
kdr' t
( scr)S0_[f
aay
e[  t@
ÊN
h!sji	V_Êˀ t bQhdYt
~uS"@P}[} h,L	r!?
$4>)uhz?h&2)؟&_
-t  ƕY6{D	`GߊD	'6;1_4/_&7/17!2@47 7ʧ77GxL>OeRUYX[ -V!a,"d#g$=3E芻f% ff UCES t HG)  !t`E@a2J!a\t+W @uY-@ u@ostFz 

8 w 0!S蛲2q
e!ddf0  t[fp %J.  B2* qfgdא tQMKkM tD B&{G& rG跲w@/H=F|a' f   fif   u"'XBP#I t8 t%PR怺NZX!qvp蜹"fPVw\'h֯+r/hufq ^ k <- t! E}  ! '-c2d> 2   Ъ&p1x%f( !C>ãwZ hq ]Q  h譒< zfzP'E'P'g!{:fFfGR5|G:g< t	 .f_øW9 I/GfF< ucAg 1G' :*F
 ( l:z
`:@:` :f3ɋRD $f3L MB 
r;;j3%043
 ܈<9`SC 3
w TQ+T!ZB"QPbF2  `F{fY$fǪf>3r	f_"@@f9e#dg&GLUPV  }0%vB+++Q +Ǖ(	((123ff20.$gNgVq	f0J@*_qfWa4fV2@A[
0352f^
k+f_rBi _^XPV"'PfSfQfRfVr RSSS*SSgf&ǇB6c bR2 R
!P&B(@G~G@bRH B@t@g`aT@y@rtY3 ~ r t	 @@t ޱPf& _ t=臲f	 u&d,ߓfV7 Sf^5 фJ@} -20 f) 
gf;tzgf=f3Jbfݩfϱt
    2 1@`@a@fBfߨ t1f^fZfYf[f`uj PwKFaOff#ffдgL rofpa,`-RQ<t2*f3h,OfuDd9g> t'h_ޯt  rmI2qR uY [pCMc7LW \nf1De"_1$&~؎zvEj(t_

A
r:fu%_X0r2F G0r/8u/ f3ZYs"~A    Ƨ ׮47 o       _PS  *Rp [X3ŷ {$0l$Ĵ  M Dpʳ;)A4)))\))kJ)y#8_Ntt/)VsP ? t ?r=G5+?+<+: 8+#r+q0rQZǂY1LPtD6e5+O5
k 22fZRLRQ /  ZFpS7`ߖTl«&C! r
p@@a	[fQ[
u?蹬hIoIof;tA34`dVf`ۊȰuasl1t-r(8) <u0;߀u00 `
РG` 賗!gpA]P	!gf>tq  u7gf!Ѵùb!g!faQfVWo,!`f$؃<t<7}Qoa YqpS%
fgu n!!C߀06_	 Y PQ1fWhd  </(v
rhMoR"ZY0Vs	!<@!g@ F UY]0W, ,e
mq+fPfS0t0q$͂Z.%tV
ffҷf&^q
UJ 7SQ"» h
<wNOfWaCfG?:	f_1$pN  Y[R|֡<v{mA
tR}s?Opۊ؋h	5BhEf_Zp Pt`iXs SRrb9w~cw Z[P0fXf^P1aM蔦@@t8B`d?oD?@tB* !!!q$1EZzEf`~tfdP lSIMWuUffCp  ~pܾf ;w(hLoX@_fapxp !f31??SECUtIfuffdq0F  R Phz'XcV 
uo4f%QX!uOB-芻ۨ@ @Y@Uh,/d.S;%!sGt<S"
 3TTV &V[tP#VXuTTtS贺Gh&
wR}LAG= "%= n =
=uf.쁿>>@ ƀ %]j#ffw	bï#
%On& @{f_r@'f$g&$ ff%g&	 =t0ǁ  #9W$IfGtt2t~tyf%/ Kp& f`8a ,,0x?x fȠ1^ûu`4
f rF`jr>0:t, pur%prQY	a c  Y% 
ДtI`A
A!:0.A2 r&&"

rr(@lRVÐ
\ _rP#j   t
ff;t;2
 + t D@@D+^@[XнP<gavq$FG@V ߌ،w	0R uB	
ff!` 


fff#Lp pB
grC
`;fPfXA3aq&3k vR%hcG~fQVՃP61=`7:u"Z-*.$f+, 1fY7~@ w.	A_S 
fUfp>	 --

f+0f
"'f]^ -##炃 /I?Xv O?An@u[%f  '  
$$$$$Y3\[Yxry=tf \&{q\A5:
R




gVXl2l9l^l?frAheRwwP& Sns/ґy t@R]fЅf^zAcgs@A91pl`Ƅ`   ;a ѐ   i "p`x}6f!!	"q&



s 
pf>_ r @  _5vf 
ls̸Ћfff_lA?Iff޼dhsoBv18)^ö@fs@KaOLG ߙKF!%QqUW0tC/u*!+1΂_ f& kͳ,e@2r1 t
 Ή`f6v#+s
stNt`a |GE؀AGa%ÑQjO  3!4f;Gu Yб.Dq&Dh'	TQr>?S@g&	PfZ!8RQvP `f{f@  R!$^> }  3Ҁ(FffZo5f 
Ƅ
萤C
__?_7Y@6@VQSv>f"
 @O9B1\#hHQ   ___*[1)Z`V/#_	
`R  eB   MWVQh -=
j Y^_S  2ۊ F`&+ؾ8u `&
0Y[fPWQ+t++P+fX}"pY_fXkذ/KfV}f`f&\ta d G&P&Y` X _v
``.f&tr&&faõr6r5] P$s  XY
 At   Pfoh'>Ք ƌX(10u쨀t	<u <u õr+r&h#r oD8&&t8#2QOrr,6r%}轮pPqu`0"" QYaqP &` Ob v~j%'/D&* r!%%F%&&va cRqpMZQRr#*H)t2в`bٵƀtqulltE@>ZY?h*#s,   hOPa
/Wr#
35E4 #C$Pٸ {Uq< _  & &EZP 2 ;&r豂r8tW2@f`.&EO.tGoS`1o[&M.2` t{
$Rm`#S[95 09WW 84̟fRo2ɿgbfZr pvw5 &E
7, C!	A	2ahz
%00`P 0S\!^%Pg  Da`6(    j aV魆^`W  3 _r-"2˸ fDEDCՀ ֻB DB O D D4rruX 3W2&*G_Y{S	  ?&*P.u&}Zu&wE_[KH TZNF  20<Otb	B<tmPm:R:!:IrPF"Tѯ: r1 r,? hOd}d:SQt?
pujt)u$<Pt+o'KuҴqayB@]oY[Qw @s"suDa~Y+V Wo^W mQfR hƲ_dtD/>(I>>rN|UtGV@u 5^t1V?hI_ 6f1^Df@h  D ; Z x     0NmA݊$
Pdu	q  52̿/Xrÿ	  H6ȃI$J2ȉ`\' ﳹŹSQRf⤋ .xZp"ka  k`)c$tr+ccR] *0hhEϰd/(#/J+(*f(fYhR`k/n Sf>lQPH_ug(20?&fá ݖ d̀[`-r(1ˉQqˉProzryq#tr?fSfFfVfWp0>f9t  tf<b @` f  f`fff!02g&g
~fKfRg gre hj7Ur6 g9Vhr4
a5f_qfYf[` r  sZfbXPSfRj07W6uLt;wEf6fPf8 r/fg&bP Bfg&rfj0  Z[XfWPu
 f   酀>_ Àff`g0? t]ǀ t
t@  f?
 : ) @(d! _  f` ; 6frv`gGwf3ې fPf`kfPr:p> ff0;w!fVg&f^ufFtsf1!Q.Ȋ$pf_t Qg&$@%D&v@<f=ATADtlf 9&Ǉ Ǉs  S3a  울bց 1 PD 0覚3ɊE@s q胚`U  EGWP XUЩ.߀>:   ub >u `
`
	`pg$ v0

ڙ$_RC . D  ZH +GZ uHG 	.ȇ
9 ɪ H`3 0[Ʉt( ,a	

 @`oQW t#f`d ofJ  _Yk.fUf.6f]Df]** End SetActiveDisplays: \ R$#t5<m )¸ӿ8t  u
8uY AӀ\QS^{[rY VQ2t`Àt P  o@{paPG !<uȸ
 " ?uҸ	
30p  - )0Sa pPgY  ZOI	R	<Z9 dRr  苎Pp2R{ċ zXrXX\PSR8QPKC)j``%b tQP À@
XQRPS [X"3 {lw
!f`p
u&Or
u02,RWt_Zr&&&E&]P $fas  
B(p"BI???IK  6+6AU]!vWMXð PR Z .6trH r Xtw<πftD*` 聀N=_4׸ fcs#fWPA`XƊrP  f_Qb`r/`?t"f ITAfgfPAFfG2gapC Y {p`>{'rd 
`tXWH`u=&M_0g.g͵ ǃ? t0;r+gCC 0Ѕ\0#uud\tvQ Ц`|f° P6밢`X\f1ˁQdDtOߊ1 Atu PR'P
u3
u#Qhz`
u"Qϊh%9u
3&uC*ur'p mrutg&OPNW  2 Q#`yUu#6aif`tb?dL`atUfte+`%aúff%f
f?]HC #g&O hYɾPft KfXrX$nh׸0;l&"	  Aܑ
HD0V *#tCMIyC ك	
ڈ
C
vO ʰfff+fM?hL?f-Efʟffq[  RPAMSuff>dr^t
q"wS0<S<ST  f|	! "\f#bQﰏfRWVf1hq_ ]Q  rY E6fP hvh-rf f6h
^Qm>
hƲt.rB1ؾ@
E<u@
Pe
`ovf,t߾0*_x"aAi`uc<tD"ЎzQwr&=t&} tV" &GF^rYՃ"G
\~Aؾ 	 h[_4+
!
"s

j
i 
9=Fh@(_______M2Ȼ ZHC
_P DL~R ĺqSRغ0 t@>:tߜhS tP&zX`\/ `\8>ߙڻ!V͠ 2AK [@'[c"@0$`\!׵`\4'cj Wa99J}Es(͇`\G`\`\3.`\U`\P\TP\Ȑշ!	`\cCnL:R`\bBڭ'%7`\>VA'xf.\NHz!u0X<~w2.߇7f&@c2dN\mP0f
f 7
gcpSHZpذsrAZS|gf&;xV4tڠ ? u@_[\f[_Î@X`b1ؐt t!w4@`背RuWps	7.hUծ=Hfт vq~	swҋNoBoj0cGƱv:hhr h<	pߺ@ hr,_XfV`WpћsQ$+Zfq^SQRd\_sZY[!s!7O͠U	Wa覂⨲P=p-f`뱬q̒>2Ϛr/Q?fc
]
f?_
fbϑfUubF =6  h/8 
~tJ]
/0t"(Q	_
f c
 o,1u&c]r21]QWrHuOrJ&A/
uuo t&
&&ƅ]
"rs:_YUfV4MOqT3I^TÞY ZS+r[z?ం0y PQ>b uιWc r\d`bYf}CtCb>r-t`w0 r uҊ1 r
-`u`d7 Y0P rdItf s`}QRf30ZYSRNr&r!ww3҆r r	[Z hPRcP_@/t Al'ro/2׺^Z PQ~s
d Sr	r\!V>RPF dt?gfaxuwR =}hk%?߰C Z555.  P " Y `2 ,u   P h_4ER쀡Z@uS* o _rQ(`( !S  IЦSQ RئR rrΡ&DC	$ 4}tS t3306J* Z``R
t#4 c tt@+ÈqF  PQRWVܹܟ+3aO^_##31G<u
tV 4^W =_ "  !(<tݹ /	
R
q0xP#H	
g&Ơ/ܱ1q;`?-r@QWPR(X 蕐J2u@d eRVа$rN ;rCr<,	r32;tPrr;wҀ tsڋƿ^ZW
m  АqѢ0u
߾  锠|uu B f uf_& J332[2t@@ 0	rn
$	"
ſuƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_..\.q.q.q.qr.p.BpRE{|ȈVPC紆 V%H Pf f?  t π> upQ^|4   f 헿  ^0x
hVRRf   %=t=:fA!,hGVRofF0fAf.:.~u"f k ֥l
  Q7UfE &g&fRPf2f% n`am މf~ fѨf   2g&tD
Ae	7:f f f$gP`P |Pgff
3

 0f1f%p$
! Z        8ЄhUbzf0R'
0
yVS@rt*~2	覐#2 u!,0  f   "0.0p0f%0"@/t	!03Df3& 3psf3 sCXPfSRVW سTaTffP f
0u_^fZ[@
 nD &PfWwxG@f`J& DfBHaLflPfQ8 f@ Df BHf@PPh >|ft	"fǙ@ 	qPAf@rS<t<t<tÁ88PS$<w .mո`3}qVW  _^0Q1 6qJhL=tr	fO@D 53  -                                                                                                                                                              f`8P%,Ⱥ:#%h  t
ف     t(  !d^Xtp%@  Pé t( @~ a3 %tVtGf3ȿ f ff3{uSbfff#f  f*% ΂  HQ0X
fa?PSQR.#؃ ӑllC	%߰Q#cY3#`` ZYPR).5  @%?
 g&Z0	hFq ]Q  h,DQ
  _u远3 # `u胑
 3 ah
 hhRw=u
ߺff}%ZFgw Ph
t߸Ef0 tFf6r %f$#a $% 5 q PfmQ#
 PAQRfP0 3)u7u
q(qof+ZsPSg4 gT~ TgVpVgh&հmH1S,f~ fg&?/Ha 1R-f@t3P5  PX4P@	Xt 3 *QZR3ȓ _ u8@`f؀@uRfttA@t
1{fs!
9uU"f%1fr 3tSGP
fSR(7,7f !5 @@tfC f fy 跽f { 譣 z fZ!c@ 6;tܑ@@L' tf  7 t`B PB!(  <R! 
03!47	R+t
3NO+t3GNO`UNN쪺P a^TSRo``aIDQ PJß                                                              T\O Qa dY             p                                                                                     8     N    
 S2X3                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй *s# hfP u	fXc  h ǦZY[Xg&ǅF C9   Ã tfPfS
u	{p  9f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tȎR>tKtETfu
0]t`t	dpX  f]ZYPSR uyvhryv&2qStN tCu+?7:ǅ%. *'<t<  
+Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3Ҡ;:  :t ffKf;+)a3  `49f 'D%g$ЊFb	艐 F-葐r4Vu'v
x l %`^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
Fff.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfV fKFt!hu\gvu U>tU6f뿢@)_a[af^f!aFV  ^SQ  60Qa@9taT% G舆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRV u2lr QER: ߳ u  ;&pIS]0`@h1	[( ZP % `f3۹ fs_Ձ@T@" V2: 1Bj0 fy=EFfC`?	5	_tt$yGv葕xs~ !"Ⱦ
Ќ (o
d
~uW
1?MSiqp1~uZ/'7FF}u #*V$^fȢO__o0Vﯻ mX^ҎD	%ÉD	f?r2fpɁ v Ss<v PfUf f fa$f6f> f	>fBfff]X߀ t @PԁfPQ6[f_~RӃf3 cZՐyP5b> t5zV`50@@Y!|p5 ೀ
P}@@x6<{=f;tff* F#cG/$K ëӫq  ~gfEـ>  fù& fσ;t)gfm+ C k H2|`Ekv tߢqzÿzPVw  ^fh3 ;u}; n0;b7yP7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
 xy _P b6_PSS N SPQ O _   _ _  _ _ _ @__  _  _ _ @_ _  ?P@kЦ?1?D?1?4?_>_>W=r;\/D<Z1Hl7HC0H9HF8HI_CST pP H`s;Ga H	#
 


BK `
 
A
of`qI T
9
dGESS@րO3Z `C
*OeA&KG&e@I&C_C1__Q
&"1n6D6nPmo:n\ pC
nIST  43A1OU0(:L*\q 1d`xL
 C}"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)G؟pXq9SAbDAk
 1 CAP0IID  1 2	3sU9S
 E  1c`23?6q 1223ޡp
!
  ki_
p

G}B? !L%A9D3	 
	{ } q[=` 0   [ }I NRJ2`M5kH!7Y!1!q !!!1!1!!!1! !!1!1!1!1"!1!!!S!C!1!1aF!!U1!!!1!%"!1!!1! 4' !
!!1kf`<r^faf`  ufc3pֻ0v ) f!6j,gfwP׋F GPrR(W-n<AvPUfVf>n, uf% j ffZ	f\y{, a ufzifr,鸀, 
Y j,z` 20v1 nf?WfA_fr1f
={rGXZ0r2虆f`_ rRfGf>|,f r<
r7 	`g&V0fqf+Ug&D
3G#NafaY
! 4f	 g&?u@u 	t`;vڕvu&9OpCqQfRfVfWf-sIg&wOf! ff9
f  +pffff+g&of0^fS$@f[ @    	`@  R|5O;;O SZ !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXh[( ZP % @Zf_ >;u<aPS- pu;;` ;;;/;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; P j0fdQu!;! ȃ uddfd԰  >P6Sd ddP ʱ(;;P:Ug&t=` T=f]t,>@u%ttt t	tfN tF ߍCr@uAalaCs
 1Qh 6-buoF . u$
TVێeS tEbrtـ?XD@?f `fp`T fffXs "qy#uptLe; ` ; uY^f3ffe;gbfWYдe*&;8fw*fF*2t*܊e&;fX^fY[w'!(; kW" b  ĀuBTv;|  tB2|k}SQVWU& t r]_^Y[LS-120ZIP 250PSQRV:1:2:٢2ؑ2PKp
x
~
5	<;2E:k>
s!hfP u	fXc  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfG(`*X*Xu ͠HAZY[0^`u ;Q;;;;;v0 RW1h27

-a} tE@/_Z[M-SysPDiskOnKeyP#jB ut @  f<x fP f(0QA˹"`z|= 2r 0w"1s ?sU3IH $ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&,c-\w?t,f_߸ A% rLTf<Q?(UP5Qe}$ b
ԯ1p<p< t0hƲ4t u u2$3=@Af?MpI`N 
fXuײ?0 000J000FF 	  FPRdoK@3W~2>#>;2>
a_YhG; 4  hZ| ZXSW0+@0s!$?
u$˄[y_ - ࡥi B t`UA	qAq 	  8
		 
	 						8
 fWQ ˹O?Yf_qD=f; D=;FD
$>;%
ĈD
%詠;IbΉs@s
<rI`d
Qr7R[USBS{u\ t t
U	 	`;KTB <;9١ p arQr,< C0' +% 7F`2PsD QrIt2sQfFa׽fAY{rٜSfigf^qf@FH\
؀eˉ\b$K
prA
x @
`0
!?
0
"7sTq
aWa'"CS#PD=qq0*W.?43'T2'úg0^oZ(ڒZ(
_7
qO_=%t9T$RQ$2Q	@ ?WK@RP2 s с>bu g&` T=
XS<(fiʐA & y~j6; ~ r}fPQt:A3>Ϳf+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9?y?,B3ПU+*/sG/%QfP<h`gffXY"~Nv0\OސJ?^;G7/Osc`sMoDA b@Ac7e=S$l=38%p;bt -bt !b`;D$
ƈDaz ϋP!l r
9rYAݿ /p%tFIðtT= 2:t+:u hoety(u~~(rt@b=@t-b=t!b=`	tb=Ѝ bq6`oWfa0V
<8dtd߶}٠rlپ<8Dt_D$PQFxPhr٠dl^SQEO	8t`g	G	҅< !" !  3  @O 

  !vv xQfWf>_l Fo'#f_YØPSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYf[fRfVgfeG`-PgeG,fQ"!
6'Ps ,P!V _f^V;wfaf]	6&ys'&P/ryRvRr30
?geu t0 AO@ra'P1806*i%AfgfC  ggf	 
s>r8PjQu:YrPiAbp
fMPs
f	 

 { 
!U?W'eGseG`~i_VRP 31P@gZ!
\
(#5W0
S
B
%?q}~r$$ <
`flpcC4C萟s!hccoreeJ1*A<tK< uMf5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl |u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
_ww?`}pR翋qx& r&L&T7 <|PFh3P(Pf_\3VAf?_ffXqf 
qfXuײ? fffW Nfqc:fp]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF}reCRC5P5PI7+6p6P b!1fY♠
W 
KA

$I#j
p QY6BeQep+	Y	xr1 /
U2WQ
s⺑SAOn}%tJ?wA0(PZ`S1_Xf7񇟘Bu 㐊_
u }% 
 !?g!%KO 5Ϟ     }3f  Ptot 	2fp ufxqtp  >tfq f	bCfff@Orfurffɐ+fԐ%ЮQSt3f

 sఠqr`QRޑ0cD?f3fAp@HR
fâPXpAw f>l`_rfC
.@VS&7 ! P`0Uu

C	ݾ3ݎ˵fmqC &V" PB3
q a1a!@%[pxtff Q)`"(! BRUu@$#o%"*E   u=s5# r,Hr'7
 NPSSg
#[@P)'C,R"G-
"10v)%

2 }Vf>/U`˝8?&B?f P?!?Dpu%f<E t
t
t&[ sPf
Z͉6/- gwFq	g7gFq gFyps fbB,3u +0+   < t?  ;v?ȉq tv  f@-^fflgf
GG͵gG-  	R
 Q
Gfyǁ0ffHfbf@@I1&} t@q qg fy00SfRg fE3A,3;	@t`$2f&߷F tm	DG^^ϵ!  sfu@Q	Ffy  ǀ=`G
  A !Iy>					d+ఃd	@	nO	@	D@4 2@B462=fAى7K"xfݹf59щ"hRa{TboHfuKZ<0i f&$usZ@U t`)% efc	W\Du=F t5f\{lf  f+8f;rߔ      ߔߔ֔ЁЁv"6_WA~____T&䁍ti@____YS __________|___b_____Y___XP_S"^ ______Y3uyU=6Wc(
   ____ 				O	0ScfSc 	Z=&   vA	w.s  q@ D `@  "eE `i @w/
@ АRj@F  Z"z SR  hfP u	fXc  h  Z5=f3fZf[lf M@Q~gfwe@Qw_faEA	>dlu?cl}@fQfCdfld 2hlil%PWf;f+Va++ *@ f=~ ЖfGS	XAhvUftQ3я_;ad̿ /p1Ж$4	C:cl63
f
?)I34ө% 
3и@tBՠEuGf>%2ggefFfGff!g {@]] f2+ǐ?fj-Ѿ@t#of+ qHt-Af
 uh97gk)c)Xt(8{;f	 p~7el A}flf_-c;q `u @Gu
g⺀ele<>tf Wflr lsc`u1ge~M} 	C =OBG рK~f   $<Pbt΂ t
@ >hP
>i~
 PHj		%PgP3=- 	 ?D9D
eVfrFsr?2 r" f( rFu&&P'Psp_"Sge8Ftff;rqK0D>$O 0 ,d0f7Wl@c 0d	fВ`f! W jgg_$"/ւaj_`e{OeW$kGb plgq2bY!BfβA cGROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
qr   2!	A.>  
 x  x uuo        St[Pu&u u!KrouBuB ?C > XPS tuuu>uuu~ uR[ CruïKuuuuYQ	`P[K`
3؀`u&svutv3 upVS@t	V[^0QVug&"uvpJ3fu1uq.4ߧS1ਿéu跩[^PSVfU>S>zv>ϳ&wvt(
ug&uuN[艳f]^Vt>uu r1߻vuw%0r~@!60aSɫuP  5[6̨TWai`z2穀ОQ	2pUt1vuIh[Zuzv~yvfPSQxvĉY#\SPćuff3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvb?yLr;(qurqsVW@fFtAQ څt(PǴ:vvu 
  gXfC[Yqq q9~ w2vvkY?ⷠuv`Ct&tv8r #>tPw{
$_P#0%uxv.v2 uf? t<CP<tSQ@Kذ&Y[ـ u
lq ` -  i8_ @` @8h
@ 0p*	qk l8 
		
			 				
 

 fWQf&D=QYf_侁gD5 ;6;;ysR.;Py``}D
$&;
Ĉ?D
 1Fs fg&|5 EBr`r  a`|	 		M|0R		`R}H?\
 {;
܉\se7 bb}Qoab}f`ߡg&`r ql=Br`h >;bt -bt !bt;D$
ƟDf-Pfp&߸ &p;W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;连j(wf
T= &Prjrpbu6;; 6 rDQfP.?f.6;8+܉fX2fXYffrhl*`	 Y*a 		$Z	hb %G0F
/
PsV ` !sJ%|=td%"t+T=:ur?|`B(uq!(~rgb=@t-b=t!b=`	tb= .bh27_2q62ogfaaoVPCL	;t	wPAq$ضR}X <R^ASQ2|O	8tg	G	ßY[i0   0    RoO d q n  A` о 0_0 3`  
& Aa t%  	B%
0 #
	٩*
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
aT S<R"G 3 D%M TVaX'K8'(XAIc  WpI O  x fSf fV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 ffYkf[ f PfHzRf3ۋu#MufVku
 @ fC  ZwW fu$޳ -U~T fP%offXrdqPt@5f90f  f
Wf f;Nf_AS0>߀fz薶r@!fff]f3ɠ  0[  U@ Ԁ   U@\ Ut@dl fVf$f&o~   wt   
f}D`fd.f^<wtP# Q5 R*Nhz4<t
_t %Z[_( ZP % Qޠ$0@f"E$!4",޶-PS1#|&3M38t< t 4 v-#tt 0&#V>`OgV8p < @DHPMr:t"`B-Zݡu-.GGa?;-?rfTDaff} DI	fAKfg8u#HDϵqQrf1s
f@ (`+1HSHPS'}? OO&n:`f`h|(!G@<<t<=t<>t<Ft<Gt
45z5qGN1Z]    %`M3f0V| tf<x  $ fcP   t#@r7fuB aqftQS0^fC`BUc U44`f&V f>/q% }! eIf!ig~>uPi

qCDq; ^r
7rC
°Ro-?  &f ߡ6wf  sZqf9lu gF9u 9u
gF?9͵tz2/g-tvVf>l  r?xsFf!` gFqg^ g`A  ^Fq 3:`kF^ t	f#;QoG;.;f@B23
 "4 !Ix	`				D+@i	@	nO	@	r&+롛   0a }BM ;vȉq tv  f@ 
f`3fۡlgG p ͵gG-PA	qGfxi@U@Y՛f&Y8z"!1gGA&@t@ af9Br SfRqof3_!^5{	@ Sfttt.h.uu7  V  	  i@ Ԁ Copyright (c) 2005 Intel CorporationN1OS@eP%2p`"ѣt2Cqt"Af%  =  ҟ <pdt<tH<tN<tL800uxuju
T4fPF<:f!a<ISGou%fц	f`C s
gJНRVfUf❁z f6bt*ZpGt
B s ` nouhC%t.At#Oǣ4ǣ%>ӥR#S` @ İZ-% ` $fQ]]aUP.W)`t411wgf#f  ϊfYR1txT	ː!,	ba'""ԕR4bSHЏJ
>Pe]֥u}xt*HIT$$*	g&<ж1	2a?5c	07t$N<t/5)
`FO0E	@HK0Rr+5$Ad pT6g%q6jqf$, ;g[S.y1l?lSMQ@	r#<0~^W:XX`q @O0 u(P*P  rwyr} Yr)fߋfWRdhZf_rJPSflp>8Pu	1Pil3 hl&P%P[X} &zs	f d w 68PBA*P?È`
 fd!7P! ȃ ud|d~fdf@66`>>á0 dffd!! d7P!gewP Wttt t	t&}z>t| Ƚs
跽s1|SQVƾEbtـ?鰽&Dѱ'߶fATff_fXs2B	x3p&t&L5P 6P ߀uYËiވ5Pgb>W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	&  	-a&} 
&_ZS/-e`&-	
[`9t4hƲ4t1
&u ?&uP@px
W  g&?t?f K(g&~QffÁ (r~cfvg& uxrI`@PeA
f  qf  paG,(i
 !m
"sGkO8b <fT tf$B" Qpff
of' f?  ftɥÓ f&
pj V 0 @ s	<W% <t+f R
 %u<  	 z,R
/"?r>f{	%r
 PBg %O +fp_U/ErEF?<p)  
 Ѓ@ η`#ujRca$3'='pf 4"b',f2"u#}   qsZ ] [ \   z @ b  L ` oa e^ @  A @c 7g 2e @ uf @ @  k ij  @(T @  zն  \ @   6`gVf.VP Zo!f! ( @O |'E$0 fpP	x	s| L Ifl  h@ Bdf?f;  Wfff;sgf9t LSf_ѱ쟣f-q^ZQSf3ퟳ hVOetowub$r	tf1GI#d4@  $t؃ u˸착ա͵dոfZfdTfdTDA$Rzh۪W!pw!芔藓hLoԀfof~ ea.d@t0WyJf`a؎}  @܀g_fapq23 g&s g&C#gӋbSf3Bpc0zC
uBUÁ{=P>u`zt  X +R0ff%f`O@UՐ Flyp_ZQT0e rcL~" 	
сD. P2Xöf fЀ 0	PR$Z  fPx{^pmCX zCׅC >#sB3"     ;?t@ b~tuft  VC4"Bt;'B(Bu `o 9QV *N0K`!c!ЧKm
qXSV [(ĺsd^3#g&KZ
 4CZ
ܓ@ Zd t 	
 !   ` "`aPva{ JQ7RVW   ` Sx>"ٝ್ k&q,pq{(f{@C!	u*:5:6>6  66p 1	|1	wP"~@ w>:z!K$33zn!	%@uQ VS&S?3'1u*xG# Gu` $<܀Su ߼PΗ;tF	t
 w 0id:u> u4d> u	1 t#u9ufPm5dFރu<u2!^u	I^9 _^Z7g&8!u	g&g B%DtFsPVS Шu h8^:RVȨWu^_*/»ب` 1`u0`Uf詀(o
tox?f]1; `}r;f.;t3Uuf=#Pf
b`?zR߰yË= v	 +v9A3{f́  rf{fvP  6ᙿÃ tL;Sp ݉ Pwǋ;@tߋ .mNҠbLf1r9 w0`b h>[Lʑ[afϋfQffffROMIfMAGE;u!;Wtpg!33KPQ@J 2fG}@ZYXu@nwa G*SG "2h\t"t 0 t	V  W cu'f t!AUwb
G94 GWGfԣ fCofk27O0jE01 RD;gf?-  i 21"XŤ+- pHP."Pa
>P1aPrbn ##  ʢQ A7v P1	!)SV.etv4q^ Q Pu>98߰SR $u<v
7::,; [8ʀ 7Gmrr )0PppJ8  uߊ)xS	بGPp4p9v9`_:8w/sp
QQ	 tTdV
ow&F-orgo&уt
o}rodr%#oKrQo2s
 Jkh_a	Ios=7	t %,o 2?f#n
u堻0$M{Xp Z$,q[p&p&u`c  ? DPeа?t<СGfVf搩f Pf`表!krПc7fǱm\GGRБ #aįf f%f
 s&'f0PfW	@ sa  f&u&   k
4 ODS 0U abm bG `g!	O`SQFZ  NZhFZqR  M>b !  '| da %,Cދ F${`0sO47f=%   ܐ0$pY ,X 6ֻD@vofk xfgE{ٵP^ϵ͵M*b̰			fǵ5 `݂-Wf>)  *7_yq_Qp@f% k˵P1˵ffE/2f759 5e`xt)` ;sff+c f6>a9+t
3T1I!fAPk
 !
f=ff1 A6 fffp	յf9յr
f)p @VVf?}Vf^  $f\Qfq+f%=x h1
[_Hʢy\/)~]/IfVQt> u ~Q &*:&  _PS!
Xh f Ӡ 8r
h Q

h%>@t t  ~ #ïfp+SQ	@0*0=tuf_P9% n0<s<0v0u@ N_R  ? OfLSdx	 rk6%U0f0u @Q f}@ Y#h3.<`w$Oh;`C! `! ]>߻ftg:Gvg_fg譶V !тIf0ࢂf
f~H( XbW?t%h@	g&G  6X(Jp.p ;tpsf{
"t
p $C7sw2ZhL)@ fff1GȐ6Ƞ_\* * GfGݑW`dȣְc@t]U'ax3w6N=t=tO"tC hVO4r#
uU0 fd&2
z ZQ:uб ; nu5fuHpw a}x~f# s<5	u ut% S01Vt)LfufKn s耀	`s4tee[}0uuWrZtL#[P1Af0UFQ~Vf%
&ߡ
 =ps u0_  u*f&VB  s~kfo*Ӣ=RSDTu}`w_$!f=FACPt?f;vVfc!Ow uCѧ(_b D!+4T u 3$pgSuPf Ȁ|f!" u	CP`g3 W23f_7
 G	/ZƔ^pu#fǳ0₄ 0؛魓wgfFf{of>u2ffm@ s 6oRp61p>{gyp0&0sPՋ>BG0{AR Z^R _ ` agP&abpZ&&FadXPR< u~@SRgtXr),uRG`SQr9R݋'״$8thY[	tr$V簄OHAr(QSFr(!sqtrp@ppq[`irDrT~fiY0Yd>:t	[ fa !  rTvy ʿLa@f`Nyt>A _{ G{faa~h6'`q e>wAkO/P#S.J ;@ð Wj@ȰKg&Cp&Cf  @_@t G QH!A	ޑW 6{sf_ҞVfWbqog@g<VP^fZf3gfACDff@r?g@?C|P@Љ Qg&;t4g&Ct,g&Cwf4@d$<12Yf٠
t
g&:#tfCfYFa;tft S e޴r7fg&F t+<_`mr! g`Gag&Ou@` Nb O cz_ QfVuu+rB f Ugr(al
"Ȁ^$
Q3Ў{tK@a \_f q@Q<a~ 8r p312K˿ P0U x`<r<9Pŀ&wYqtuq "t؀><: sº7g?   7d+ A4! L* R  X
 d 22 /U$ 9( C K U##GK"
u
UvPnȇF X PSø P&[Ȍp YȎ؎[XPSء[Ȏ|a@sXބQA  @} fP& pơ`gP,qQfX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `    ( X(     ښ  Ւ  ς  g _   h X V  ;p    / h ZwUS          P           
%X%H_&                                                                                  3f3ۻ  f@yfgW!)A  f" 0 gf+ >n `h27fPpu	fXc  h  fUf&af&>` 6a Ͷ !ŀX[ &SP`@ /'aߝ&&WP `XP&EX% &߈E_YǓ oooooc< up < h <u2<a
 1                                                                UPRPRVFZX0RR3=0ZO                               a{ Ѝ
h3   f`ffot$op$Ūor쪺  .<t
../W NA NfafPSRV+fpr؀tU./tA
 NUN?h,ZOd^Z[fXɨ4 h/_À> t%%f
`ff6sPSfQW _fY[X ʁx |ʁ?køPRBZ B3 $ `%>&%	 
  3  t!   fQRW0_Zr 
-RZ` XfP2T ffXf
 $$
 ?fh_V` 6 6߻  60616 6 6aPQfW =@Ъ f  g&?t"g&Gbg&Gbu 01 uf   κ(  
~uf_`a$$
{a C PB B;ra`H%;譺,h'q/ ]Q  7*Z : ,
 22R8ĺZP ,>%(؁ Ë34 `g&[D4 F*
 <0R(0hϹ!!U:f`1 fpL2f3f% 
 0p!P!q  f
 `0XߡX!Kf`a"f gff%@ @ gffwP `BaPfS,)CP0
K   g Cw CnIhFlh Xg&CfXCfARPfV uf  guugf>u
 Qf^Xk A
f!65  ft4 p  P7hI,fl;f&'qfh@ hl^'}hz&@d& Oh?f3/
&G4pFtGGrBFB
6
fy_pg  !hf1LW  gݰh*A   ddh=< d>il thLFOndRyh6dCdb͡0WfZ+'Qfff f"% fdSl41;AfdWlffa6ddlw f^ t fdclhLf{  ed[l pb_lfd}W2f; AefYWf f_#B*J"eRd辁 ҁoZPQ:_ur"yqC*YYWA;T/;  t2&>Q1  ;j3 ?hmoB4=_PRb{ hc,UZ*r\Z~ &F t@sFp>'E@ r>cr>ZRn%t;7Tg q0 b0  ëT\! zRp8S0|hw1 f~f# uOt R\f 0t1#%9tf͹!!@zt1zff0 t0{f.fuf mYa! 
#9Y m`a * u31' u80 *0/tCu t	菓fD< _à@fSVs<r<wh-`@`<Zu0ж%rз<MP߻ Q^f[Ð  f`ai@tptf@g`>0j) Ā b _úd u"A=
s  	`=f `0u aV'@ɐE)
`p %@ &%AܑϕQ\Q\ƣ0Cc#@~G%bIC" 8M1!''}V   Of 3Q'
f~Qɰ0R	ϠQ 'Н}' Mp
`IËfG0FsC?qfd3 ;5¾S؁ 1a! VP#t6p%ȿ ff`t33u^ x@R3һX3t@s9r ` ( hq2 ƭ* 41 q́oTQ/1@"cjy&$\tT
 QPAW؃22PD0	RfZhl h*s $ T%f2g`1PSu<w5V$o<w	iVA <u> tU0uR uIB<t>ףt9u2诩9r-@r!\PItG! _ p/áS'tZ|tKU9r3诞 薞s0G <u$
{ L O  2RCG"9rPd tpS3S	
 ?  SQVȾ#葞0 8t"8tr[^Y+[eApt,&
s>ut
$lsET>?t> u.-"t$	&
-s@ fP
t  >	>!2
X7ɡtI +$3`#ȡ褡tCQƠ # %< t'$  
u%{a>	 >t +,t_0 P-u@.g *t%r0.> uBu
 i  (Ƞt#觜r1~ q4/JbtV 
Ur j6Go#tBH0/-萛rY1 //YD]a5Ѿt_h5&tP ߛrB\13L5sFP=%
Xu "i265 55B#輟tzu {4طc㚨tb蒟;sW;sQaU4u	,u@"
߀uEӚ"
23/4谚  3' 3'%t`b2@M) ?!)PA5tXS/!
~tp_߃8؊ ["M#j#cfsg]'  r&
0
'< u)50
)u$$t$
 $'). J H
U* PHN+_ ZH(,
[ H-
%r MW3 ` ht-c   ff Q _p$tBg6ڊtO违8t 莙 u
8@XFgQS n[1+Xϙf_ qSQ2t2ÀIﶇISQO[=SQBdR74ꘊ3t}p, ?*b5tP 貘[X3t8t蓘`a
Q, f`>*C
/&r
u32/W"_@H ErT &&E&]~  ՗f !
1躗xQ%	f c@t_f>`PNݸ`Xњt3 tfDIVNfgf0 AI  ؾ8  2gaQr?`胚t.!FfGYqeP33Ҳ,LPo(ʖGX`(AS@u%t ~荖2Q.p&u#Q`h[9訙t4xt,0 @~~.v2a
f`ft9 pBfaa`Ht } 8t Π2{K2$u _ _ ` غ   nBnnntnJFn aS { À 3ێ7!C &?!CuC3ۏR .Z`hof:o X^Q+'&::k}>&.pu	 puQPo
,^ Ͼts+t@QWP; PR怺NםhX@.X=X@uX_Y_QՊup$ }qa!.n-$б:rP*F+Xtg0`uQð6C u@B T A@Qgffg<Hu.g=:ff3`eff3ffߋgffOfC<u(.&!@BfsDP
hh"
4	fRc6ޅU4 p

(
uXO0fZWf  fTmj@]Nwp Mp 0XhPfRÃt%tg0&g!ggωf{`fZRft9tg>E @~9g5CggfRVf),g>E %g> !P(^d`g{
ز
.U   f! "Qw2o` 01YZJbP0a 0F`0
vtP`ձvؠu x`;؎`Rf切u Zl?faa%n?  @(001}k@AEfh3 pǰ  D  &Et"D  $Dw(Юs `ف&tȀ S4>2@"Q
g𓡂
~ 0HL &}u?p ?u8&= r1	z&
Ip$Br P
` w肐 m  m dm pZ's ~0a`_r * $OQa	 & a=# $$<@t"h_STSKuKK<u?K&Ku`.>}st&3r	#rO&37!AA&Qaô`prrX ? 1tr<0vq;w#8:9P?za){fRQSx[YfZt'v2 tu
| eya0r&JC
ADjG>  f  h\dpruf`Qrfr{3 }@f0Z襆r<fffHff#f+ִ f;wfё3g&SѺc0ff+f뺀
 @,.028 pĻH<2;C;8|yw>X59x?8,K;/l|ܤxUzHwyDc;w2@U_ 6#16s; Z?K;2`;`Ⱥ tЀ  q&aPRu1   
w0@h{Z! Q   )^pR ؑPfffX fff݁` o˰s?  3 ` ?
PE""ߑR787 33 ##}f 	   8f P0 f +Gf0a4ff%\h f0/"@^`    EyaC6
P
f8	  t(	!	#	RfPRQ$% = u
M= uL=  4`& W8ް6f1f_3&Ü@Y@ 0- (˺,Q 0 qPD UQ   ,A048 ҢpWZ#!B`R MP%d#a#o&    ih[( ZP %  G  %_Ö                      vY`00 	3<ɀ$ t		T 4<v	4N u B4<KRPt@B u$Z0fQWP C	kXgg_ Q
`	fgapNfWp,3f3ɿ6<f?0<  ߋPٿ7=f; XaD at}5<[Eù@ fPfpLfX,fVPАP0E gf^! f^	V	R				:	^	5<	^	n	f	W		`	_@;g&'.G`@\0HQWV!  tO=TS"}!UhhtT(Q ysYl^_>uDJ7=p
x xa3SV[C vS3ۀ>@܅taVt:aVt pC Յt<w>08 ᭐5
 1Xñ ~ S  芅t,} IO !VVVWt r"05>`fP	yRAVrA aЄ	 fX`	td譞]P	4Q@لt1-w㋇V.trzwRat0
p0G7C< t
8C:@   V >@ubtVaÉ  H)

p/I% J@؃@P2
s3y@si~  Y &
1F0\CCCmH:Cu;pu;th@pP7Cкys7C!  CCCCoww
210[Cra 	߈&ѻ
À
vw  {>2Ԁ22tfRVhƲ??TtDh/5h̴hrr f^fZ?f`2 rb" <pCTvrhf0fPf`QX
bf3a//8qb X!7"" ϬhGtc{Qf`/)
4/O
 "	 	"	?/	(	&!_!!!p!hotÓhdwG	f3f/f
,B0&su` 2fqSRt F<tv$rfz Zf^tQVWrQq 0 _^Y}Tfy7Ef؁ePѣfބt
t^%S^ygfQ?3\1 P^YfqW|PWVh?rGыt(
tuu ue tt uʋ?^_7fQf`;Eb/4;EG Cd6W p 2:> u6 GHt\o hz/T3Ҭ؋hoeB^_`P!f
K̈́
{>
2
Y
T[>T2@OHp
N(u.
~PϏr22dgMU\L7`\U/ \ao/ / /  OU\N<RwS2.L[0ø`
 
а	

fQh_DfYQ P`FXQ&G     &Wf&{t ffBf;Pg&Gww~rtwRtpff@hɜASp3QgfYgho%ƴAXГY[Ua>aPS{ph(߯WhH2f[WO   &WOWO
K!v 
8s vt 
tȰaV$<
v
ط   tǀ>OO t r$
 /'$0 u
d t䷷P@ `^!bh|
}
0d	
	
s	 
0{u OO&POñ OOPOP>PO u
8wPPPPPPQQQ%Q0Q;QFQQQLMOQTYhzM dzMRTY_^cs O ezٰ RW\az^inuPf}޳ kxYcnsx y^ikpORTW\uW\i ]Qà@ PP ~pXÀ~R,0:%  3` ZQ<  q,Y {f 33 3ðG}	  Gĳ	P :	XuRB&D>m	bvS! u%qY2 [2P F.X`	@M	29P{2ې/ˀa	$

Àu<X[X f1at؀a
2t ,P@<KrK7X PR0 zRZ01.R BZ s  ""
ZP1@QSQS Jq vJúQ R (% PBǅX
	Pذ4%fQSW  _[fYh Qrt7> CT $>p u09  >b_X`0(u< 8qt3mr-<t)mu
$&or.a𱠴qt%mQt2tBg&G Q !P oulWou'> Q2&QtaM:k  
 Mdg:6QW<u
88y ;8{8M_<+z ;88|ϰ+"k~bٜPR~{NZXWðuh,ZZvq	誆 Y
| hp8_d`T\ۉ@! t" @OiOa
W% AA {A% YXX r x[WT\WQO[ WXOA<ƀA! T\% VVVVV}[aFWO 76Wi DV% Q0.&,;W0|> {|WW2~_s 2||{c[{UV<20{2 PظW$L y[.xx>\=Qx^]xx2 	g?sPh tiu%?thu<%r7,< 
]W`@uC`
 
 Ё-ò  Tq@AssLf.f@- ff.q  箰,' q1 'r 8 a KR3 o1Q	$?ugqhiY/.eYp&3YS r0@pYr2r<wAف.t nrnu_  ?Bt@(ۖT2& h[Os^氁uuu&gq 矀]p  Dw[XPyXaOghKUvP[F X PS1&Z&Z&Z[XPS"ZZZ~[q&~[~[$DqdÀ^S8rddвrS<dr
d2* Ҝ.Oc躠@0oStpO\đvàÔ<D bUνP?0P&XX                                                                                                                                                                                                                                                                                                                       p( f fo龗hp8fP u	fXc  h @   foMgeuge&p #t)fSK _Q f  f[ 1u $?  g
ulfe   h[q ]Q 0uIe	:f f  gf&e /-ggø0&&o  P            $ >        w < h  D ` d`  _  @@   ܂w @ @Ub  "H@
X \EHT` o1 2]L 34 _0                               Z 1    14   @  8 @ 0  0_ 0	6	T,1l        Z PXYhijklmno 	

                      - 
_,89:GNNO OhiqfPfSfW"r@u  h'/th(vf  0i@g&OZ	(f_f[gfX0Z &g&f   [#Gх  a(t w q[fwXf[XQfRVW fk Q  !Q i A!!ȑf%}uuf3f3f.2fffu?_^fZfYf":Q ء f' u}
f0PR5 % ZXPSVWfQ `-aي t
ut upf  fp w h*_ԓr ǀu* pv @uf  fY_^[X`'QfWfVpff
  ffmt  p$ѐ f    f^f_Y# ¶ubR5 ?  茠fPSQR	0Ƨwq-q-f"x6x+@ f-$<s!h85 !@QtE1%<@1u=t
@44Gj6y
sK  *P
f>6O@
 _	X	;'>>>
sǺ$>> foޭ"ZY?,-./01289ioM      `a{{{ 3 vwRRFa`{$a,PG3""
P![2t*:aÜ`>@ l> l!GA lBla6~$?C o! G @ A  B  $0sϊF  ؎(|n  "(|  BnnnJF$a %JFx{P {<{ tq ̢{P {̠_̡УР&|ޢ' ޟ{p8@llB  ؿ{ lBB@| l@    @ l$|Т_%|N&|'|| /$а 
@  JFF/n  	Un	n	n	n	n	n	nnn 
 $|%|п t{ˏ{a  K{PSCd(ρ΂`  3nnC q
p		 nA
` n&|`4'q a|4!IQ'!$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`ffP erFrAfW}f_迗 1 hP/?Yxg& fajW33۹ G.%/Nޱ߰_Y 
tn
kdr' t
( scr)S0_[f
aay
e[  t@
ÊN
h!sji	V_Êˀ t bQhdYt
~uS"@P}[} h,L	r!?
$4>)uhz?h&2)؟&_
-t  ƕY6{D	`GߊD	'6;1_4/_&7/17!2@47 7ʧ77GxL>OeRUYX[ -V!a,"d#g$=3E芻f% ff UCES t HG)  !t`E@a2J!a\t+W @uY-@ u@ostFz 

8 w 0!S蛲2q
e!ddf0  t[fp %J.  B2* qfgא QMKkM tD B&{G& rG跲w@/H=F|a' f   fif   u"'XBP#I t8 t%PR怺NZX!qvp蜹"fPVw\'h֯+r/hufq ^ k <- t! E}  ! '-c2d> 2   Ъ&p1x%f( !C>ãwZ hq ]Q  h譒< zfzP'E'P'g!{:fFfGR5|G:g< t	 .f_øW9 I/GfF< ucAg 1G' :*F
 ( l:z
`:@:` :f3ɋRD $f3L MB 
r;;j3%043
 ܈<9`SC 3
w TQ+T!ZB"QPbF2  `F{fY$fǪf>3r	f_"@@f9e#dg&GLUPV  }0%vB+++Q +Ǖ(	((123ff20.$gNgVq	f0J@*_qfWa4fV2@A[
0352f^
k+f_rBi _^XPV"'PfSfQfRfVr RSSS*SSgf&ǇB6c bR2 R
!P&B(@G~G@bRH B@t@g`aT@y@rtY3 ~ r t	 @@t ޱPf& _ t=臲f	 u&d,ߓfV7 Sf^5 фJ@} -20 f) 
gf;tzgf=f3Jbfݩfϱt
    2 1@`@a@fBfߨ t1f^fZfYf[f`uj PwKFaOff#ffдgL rofpa,`-RQ<t2*f3h,OfuDd9g> t'h_ޯt  rmI2qR uY [pCMc7LW \nf1De"_1$&~؎zvEj(t_

A
r:fu%_X0r2F G0r/8u/ f3ZYs"~A    Ƨ ׮47 o       _PS  *Rp [X3ŷ {$0l$Ĵ  M Dpʳ;)A4)))\))kJ)y#8_Ntt/)VsP ? t ?r=G5+?+<+: 8+#r+q0rQZǂY1LPtD6e5+O5
k 22fZRLRQ /  ZFpS7`ߖTl«&C! r
p@@a	[fQ[
u?蹬hIoIof;tA34`dVf`ۊȰuasl1t-r(8) <u0;߀u00 `
РG` 賗!gpA]P	!gf>tq  u7gf!Ѵùb!g!faQfVWo,!`f$؃<t<7}Qoa YqpS%
fgu n!!C߀06_	 Y PQ1fWhd  </(v
rhMoR"ZY0Vs	!<@!g@ F UY]0W, ,e
mq+fPfS0t0q$͂Z.%tV
ffҷf&^q
UJ 7SQ"» h
<wNOfWaCfG?:	f_1$pN  Y[R|֡<v{mA
tR}s?Opۊ؋h	5BhEf_Zp Pt`iXs SRrb9w~cw Z[P0fXf^P1aM蔦@@t8B`d?oD?@tB* !!!q$1EZzEf`~fP SIMWuUffCp  ~pܾf ;w(hLoX@_fapxp !f31??SECUtIfuffq0F  R Phz'XcV 
uo4f%QX!uOB-芻ۨ@ @Y@Uh,/d.S;%!sGt<S"
 3TTV &V[tP#VXuTTtS贺Gh&
wR}LAG= "%= n =
=uf.쁿>>@ ƀ %]j#ffw	bï#
%On& @{f_r@'f$g&$ ff%g&	 =t0ǁ  #9W$IfGtt2t~tyf%/ Kp& f`8a ,,0x?x fȠ1^ûu`4
f rF`jr>0:t, pur%prQY	a c  Y% 
ДtI`A
A!:0.A2 r&&"

rr(@lRVÐ
\ _rP#j   t
ff;t;2
 + t D@@D+^@[XнP<gavq$FG@V ߌ،w	0R uB	
ff!` 


fff#Lp pB
grC
`;fPfXA3aq&3k vR%hcG~fQVՃP61=`7:u"Z-*.$f+, 1fY7~@ w.	A_S 
fUfp>	 --

f+0f
"'f]^ -##炃 /I?Xv O?An@u[%f  '  
$$$$$Y3\[Yxry=tf \&{q\A5:
R




gVXl2l9l^l?frAheRwwP& Sns/ґy t@R]fЅf^zAcgs@A91pl`Ƅ`   ;a ѐ   i "p`x}6f!!	"q&



s 
pf>_ r @  _5vf 
ls̸Ћfff_lA?Iff޼dhsoBv18)^ö@fs@KaOLG ߙKF!%QqUW0tC/u*!+1΂_ f& kͳ,e@2r1 t
 Ή`f6v#+s
stNt`a |GE؀AGa%ÑQjO  3!4f;Gu Yб.Dq&Dh'	TQr>?S@g&	PfZ!8RQvP `f{f@  R!$^> }  3Ҁ(FffZo5f 
Ƅ
萤C
__?_7Y@6@VQSv>f"
 @O9B1\#hHQ   ___*[1)Z`V/#_	
`R  eB   MWVQh -=
j Y^_S  2ۊ F`&+ؾ8u `&
0Y[fPWQ+t++P+fX}"pY_fXkذ/KfV}f`f&a  G&P&Y` X _v
``.f&r&&faõr6r5] P$s  XY
 At   Pfoh'>Ք ƌX(10u쨀t	<u <u õr+r&h#r oD8&&8#2QOrr,6r%}轮pPqu`0"" QYaqP &` Ob v~j%'/D&* r!%%F%&&va cRqpMZQRr#*H)t2в`bٵƀtqulltE@>ZY?h*#s,   hOPa
/Wr#
35E4 #C$Pٸ {Uq< _  & &EZP 2 ;&r豂r8tW2@f`.&EO.tGoS`1o[&M.2` t{
$Rm`#S[95 09WW 84̟fRo2ɿgbfZr pvw5 &E
7, C!	A	2ahz
%00`P 0S\!^%Pg  Da`6(    j aV魆^`W  3 _r-"2˸ fDEDCՀ ֻB DB O D D4rruX 3W2&*G_Y{S	  ?&*P.u&}Zu&wE_[KH TZNF  20<Otb	B<tmPm:R:!:IrPF"Tѯ: r1 r,? hOd}d:SQt?
pujt)u$<Pt+o'KuҴqayB@]oY[Qw @s"suDa~Y+V Wo^W mQfR hƲ_dtD/>(I>>rN|UtGV@u 5^t1V?hI_ 6f1^Df@h  D ; Z x     0NmA݊$
Pdu	q  52̿/Xrÿ	  H6ȃI$J2ȉ`\' ﳹŹSQRf⤋ .xZp"ka  k`)c$tr+ccR *0hhEϰd/(#/J+(*f(fYhR`k/n Sf>QPH_ug(20?&fá ݖ ̀[`-r(1ˉQqˉProzryq#tr?fSfFfVfWp0>f9t  tf<b @` f  f`fff!02g&g
~fKfRg gre hj7Ur6 g9Vhr4
a5f_qfYf[` r  sZfbXPSfRj07W6uLt;wEf6fPf8 r/fg&bP Bfg&rfj0  Z[XfWPu
 f   酀>_ Àff`g0? t]ǀ t
t@  f?
 : ) @(d! _  f` ; 6frv`gGwf3ې fPf`kfPr:p> ff0;w!fVg&f^ufFtsf1!Q.Ȋ$pf_t Qg&$@%D&v@<f=ATADtlf 9&Ǉ Ǉs  S3a  울bց 1 PD 0覚3ɊE@s q胚`U  EGWP XUЩ.߀>:   ub >u `
`
	`pg$ v0

ڙ$_RC . D  ZH +GZ uHG 	.ȇ
9 ɪ H`3 0[Ʉt( ,a	

 @`oQW t#f`d ofJ  _Yk.fUf.6f]Df]** End SetActiveDisplays: \ R$#t5<m )¸ӿ8t  u
8uY AӀ\QS^{[rY VQ2t`Àt P  o@{paPG !<uȸ
 " ?uҸ	
30p  - )0Sa pPgY  ZOI	R	<Z9 dRr  苎Pp2R{ċ zXrXX\PSR8QPKC)j``%b tQP À@
XQRPS [X"3 {lw
!f`p
u&Or
u02,RWt_Zr&&&E&]P $fas  
B(p"BI???IK  6+6AU]!vWMXð PR Z .6trH r Xtw<πftD*` 聀N=_4׸ fcs#fWPA`XƊrP  f_Qb`r/`?t"f ITAfgfPAFfG2gapC Y {p`>{'rd 
`tXWH`u=&M_0g.g͵ ǃ? t0;r+gCC 0Ѕ0#uud\tvQ Ц`|f° P6밢`XЉf1ˁQdDtOߊ1 Atu PR'P
u3
u#Qhz`
u"Qϊh%9u
3&uC*ur'p mrutg&OPNW  2 Q#`yUu#6aif`tb?L`atUfte+`%aúff%f
f?]HC #g&O hYɾPfܱ KfXrX$nh׸0;ؠ&"	  Aܑ
HD0V *#tCMIyC ك	
ڈ
C
vO ʰfff+fM?hL?f-Efʟffq[  RPAMSuff>r^
q"wS0<S<ST  f|	! "f#bQﰏfRWVf1hq_ ]Q  rY E6fP hvh-rf f6h
^Qm>
hƲt.rB1ؾ@
E<u@
Pe
`ovf,t߾0*_x"aAi`uc<tD"ЎzQwr&=t&} tV" &GF^rYՃ"G
\~Aؾ 	 h[_4+
!
"s

j
i 
9=Fh@(_______M2Ȼ ZHC
_P DL~R ĺqSRغ0 t@>:tߜhS tP&zX`\/ `\8>ߙڻ!V͠ 2AK [@'[c"@0$`\!׵`\4'cj Wa99J}Es(͇`\G`\`\3.`\U`\P\TP\Ȑշ!	`\cCnL:R`\bBڭ'%7`\>VA'xf.NHz!u0X<~w2.߇7f&@c2dNmP0f
f 7
gcpSHZpذsrAZSgf&;xV4tڠ ? u@_[f[_Î@X`b1ؐt t!w4@`背RuWps	7.hUծ=Hfт q~	swҋNoBoj0cGƱv:hhr h<	pߺ@ hr,_XfV`WpћsQ$+Zfq^SQR_sZY[!s!7O͠U	Wa覂P=p-f`q̒>2Ϛr/Q?fc
]
f?_
fbϑfUubF =6  h/8 
~tJ]
/0t"(Q	_
f c
 o,1u&c]r21]QWrHuOrJ&A/
uuo t&
&&ƅ]
"rs:_YUfV4M0qT3I^TÞY ZS+r[z?ం0y PQ>b uιWc r\d`bYf}CtCb>r-t`w0 r uҊ1 r
-`u`d7 Y0P rdItf s`}QRf30ZYSRNr&r!ww3҆r r	[Z hPRcP_@/ A'ro/2׺^Z PQ~s
d Sr	r\!V>RPF dt?gfaxuwR =}h3k%?߰C Z555.  P " Y `2 ,u   P h_4ER쀡Z@uS* o _rQ(`( !S  IЦSQ RئR rrΡ&DC	$ 4}tS t3306J* Z``R
t#4 c tt@+ÈqF  PQRWVܹܟ+3aO^_##31G<u
tV 4^W =_ "  !(<tݹ /	
R
q0xP#H	
g&Ơ/ܱ1q;`?-r@QWPR(X 蕐J2u@d eRVа$rN ;rCr<,	r32;tPrr;wҀ tsڋƿ^ZW
m  АqѢ0u
߾  锠|uu B f uf_& J332[2t@@ 0	rn
$	"
ſuƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_...q.q.q.qr.p.BpRE{|ȈVPC紆 V%H Pf f?  t π> upQ^|4   f 헿  ^0x
hVRRf   %=t=:fA!,hGVRofF0fAf.:.~u"f k ֥l
  Q7UfE &g&fRPf2f% n`am މf~ fѨf   2g&tD
Ae	7:f f f$gP`P |Pgff
3

 0f1f%p$
! Z        8ЄhUbzf0R'
0
yVS@rt*~2	覐#2 u!,0  f   "0.0p0f%0"@/t	!03Df3& 3psf3 sCXPfSRVW سTaTffP f
0u_^fZ[@
 nD &PfWwxG@f`J& DfBHaLfPfQ8 f@ Df BHf@PPh >|ft	"fǙ@ 	qPAf@rS<t<t<tÁ88PS$<w .mո`3}qVW  _^0Q1 6qJhL=tr	fO@D 53  -                                                                                                                                                              f`8P%,Ⱥ:#%h  t
ف     t(  !d^Xtp%@  Pé t( @~ a3 %tVtGf3ȿ f ff3{uSbfff#f  f*% ΂  HQ0X
fa?PSQR.#؃ ӑllC	%߰Q#cY3#`` ZYPR).5  @%?
 g&Z0	hFq ]Q  h,DQ
  _u远3 # `u胑
 3 ah
 hhRw=u
ߺff}%ZFgw Ph
t߸Ef0 tFf6r %f$#a $% 5 q PfmQ#
 PAQRfP0 3)u7u
q(qof+ZsPSg4 gT~ TgVpVgh&հmH1S,f~ fg&?/Ha 1R-f@t3P5  PX4P@	Xt 3 *QZR3ȓ _ u8@`f؀@uRfttA@t
1{fs!
9uU"f%1fr 3tSGP
fSR(7,7f !5 @@tfC f fy 跽f { 譣 z fZ!c@ 6;tܑ@@L' tf  7 t`B PB!(  <R! 
03!47	R+t
3NO+t3GNO`UNN쪺P a^TSRo``aIDQ PJß                                                              T\O Qa dY             p                                                                                     8   x  {S    
 MBA U<<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.4 
Copyright (C) 2000,P 5 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:\` 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  t\`A%D
hX p t `SfQfRfVv&  &\f?UNDIt?h o
}
3EC4:  ROM ID structure was not found. Gs<hh^ '5is invaliPPj Sj < uf. fGf;sfA7 f   u `Ef
@ &6 +&p fRSfP& ߎfA%3ffJtuہ 3fX[fZNwp' W.;	s.
`6&PfP WfUj j f2 R0	RVQ캐	&v &D_6E  U   
 
 Ff 0'VuH6U9Whw
˃f6UfV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6'drivimag{'.8: A!0c_.S.*c1fsegabp
pgNV+.> >u=h2!a! +%93C44f)J4Nf04^f.P sLhP  roo  AH" ԴN'rv&D &L. &;D&s_&D&Q- @] Bq.HPeJR&DBVB&(Dv
AzEA	666Wj 1_\0
0 uvv| t  uj@GH F_F  R{Xt&t1u1f
G HF+F)F[fSVW |1N  6,
òTۑ IfT     f`_^f[PA^@@f]f_f[fXw t8sVTUf1 ڑPUUJt u VYY1i< fo^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  
 s@8r &f.+RQA)ufqAA	f]r.ۀ>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to aborMt?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZ~ 	AxS@xf>f . . .P 2`<t8hnE^WOpѰKrequi
 DD?IM supS=f0'  ˂)B	.<0g~fh fRjfj0~fЃhQplrzfu0h|%{
I# PMM func>2
numbec` u)hgE allocufP~pfprgfgfff_-.kJah   .tf.>J r$t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j ( |  LIENT MAC ADDR:A  #x     GUID{: DHCPPXECli:Arch:@00:A 0# I5P PSKePROXY3@
GATEWA MD  BD` 
Auto-sel:
  BOOT ?SERVER)    -->  MTFTPTT l! A1Hed@roxyser?vice d 51replyJ?est  @> 4011.  ul25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[>/cred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeo{utcopen+EQ - F@ NAcchViolrg SrecedPom ##unknop!c$re*	<	connp!pRB NoS7p6)offers we	'  ]f#nam %e.RAPI}e 5u{ICPr multicastdwh~0thr /)PHY+figur3lDataL+@)aW8EEPM7i
sett<a,rrup(too many /packsdF ; MediGa tAE7,D8cable NBYPabi o=basE> BCQ4FdiscopDsFlim6H-u a7nd/)mpHC CPFO&%s`DQ,nE6jbn-mq.Pp  /-\r]
SM/DMQIŏe Hd+_Us_u	 Db
 
`~ uː  u^& 鐃>.3 u3^.3h]t0F-  r- vHHt
- r 뾐w:: MP3   fv?FF)~! o'Ґ f  -u
hx9~P\FmCt\놂[mo{cA벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t¿ Mff99f2 hR99@t{Jtq ^h
LShSF` S^TF9*9Fr䡸9N KpL?2#ZQ"1KNJHJ t0 tEVPhSp"
FPH*9Fu9R 9뮐3>'u> (t
KjJ!
; 
ta@0`9^0   V@/[0.+Ҋ*A FVF	$FVu3^Ã>гt3y(3*3(wh2v Es05	(3;7f(3 fpsEy O뜐WT3Q44h96:6@ 636H3 |38tְE<2u}% 0ҀĀ FVfF^}IFf+	`v6 FoV7u>P>f6(bK
:	@" 9IW:XF@V^fGPVr$=NVu^F^G(P	eYD^  G-- v%0&iGN ^& u*&GO=p u6`&&G G#7&r&`O0 	[!W8"`7u7'G P99HG9@Gf9  fP2 VH@&#P6VS*&	&R&(G G0FF`FF9G6@NfNfQhA UVU U^*&O;~S*Q
u3s  S3#G$PpTqQ(G	\1'G!EI<<hW;?.3%lB  t&} }??XgFdְSV RPV`T 
 C3& _2,Ph!o&Gk3?F3:Yw			7pf(21sK,  8-tHHu9N5COBv-*}OO$+SEA20 GP)a b   Q  u  P  Hx3cV";{G& 4@ P`_

6D/*WE T3WAe1kDiuQX\(PB@	=3 =2{ }NcwE-6 t`KiuhBC 8f#30QG.o'Dp'P3Bm"ol~N~ tI01DR{fQ [:×3URF)v; 			[
";S`
 HǍG0**c&W7p![ 0XFP V1Y+`ppp q`q$JfjFH$*F $ t
{! HËFFt|y#fÐBaf'dUmB`G?F$ 5dg2
I2
 2
8
1
I~zf0fFB
%a "2
P 7,G9bF&$U'b
81_H~fPo'F萟{FPtM +;Vr
w;FvF@F3!h3F^>M@Q"dP򻐘p (Fb +ﾭaޠ+)6H)ࠩ?FN)z) t)hE)`WuC` WV2! \t2^_2&spO( IP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Mf2fx{3RN|r!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"DH			th&Dժ	#Eh.dDf>	 t.ڳa Fp&J>1u(as$])I)K &^lQ_@	+&`aL h6npVIǺ
  /daF^q ur}t ,1R#F&3GF>t'h*FFb5-0wf% JZ3M.3:F!^333&PF63_9F|׃>> B.3Bf FgQfG9m9!Kбh: C$-h:LiHPV3 Qa BFgjƒCG<Dp w o@*DNHL刁i	TX\.
`Nh#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^- t@9vO0j>`c  Pjqn@mv0*-< -`d.F;Ƌ}	r58X	 1"o@*F69Fr3pqQ#z{#=4PhK{0Htz0ӽNh - j F<B&&B$6'GIr(p7l)q&W#qNxCpA&tiG]		$ 5$"qG$Bs!FQc"  =! @$[W
vS12Uc~j,hPWb	,5,ԚD+,&_*&G|&_~-5ps0-+@)t- t:' t $ u&  u
&0B2)?tₑ&9Guf& u   t؍G){
p*tP\WJDvvv87Vj
 &fXfYffff99A : ;SFqTjФP+hB`ix  qS2CRPT
ix &nF}Ljp3#b F=zӂP0z07u~ t	Ơ`82[Dlp@aAg3kp-`'C<  ǆr Dӯe8}8 u9c9*`Ӳȍt0 t^u_f~}R9Glu]"pu $%#Aqm Qn4!"&`afP
bq;2ge2dp&O#a77# q8#8u)̋- Dt-guB%t) upuh)5'@D04Ȍ#XP}Piܠ,)oP-)I
#p&&b``y
FP11&Æo%ca;iv1t u-iF f"3u30RӖ
Rv35erѲ,u1}.iv; 
t۶0=>P-"RhQ,"-

uۡ	? )&j&hy4B{sX5tۢdtxuHC$N"lT=1AiFUPA9=% pXD` 2?	 9t>2Pc
4 c_*\6p^p0)HtHti 4H
5&6
2{-Ęo4F@Ch92 < c+|<, 4t	"]
5lW
!!
~
3iF 2pah36!1$30 #םqpqQ&$ ;' cb;
D?'0
	!5
0
ndu>2; tpy)j{pn:9&Y` RP3@"{4dtq  u
ѨC D ~ rq rરlFP ^ V Cu~3?++v^F1*"  SRPW^Qu0@|1a}1̿P M"8k@1au`ug\p1:O790qiv<"ĘT1 F9GwxO#N; ~w taRVEPV9
4P`XG&W%?:FVЭAi39Fsq93u93ut[~o tHS`׋Fa-2ovi~`؎FQ@>PSS;\u>St
FR`_s	.!P`V\7hbn21f>&fp9f9thx轌 p~hq9 t@3ޠf 1ƹ +uh?1 .9Ps!1rh1^`2
b2 f|
fPȡp`:޳1h:U777ubQ^dF@R1Ċ 9F~A !@ux  k^ ^}
 ̽L  ?   }/^ۋ  FPС0eޠgQ&>pSp8Qe @
uTRRS pېF~!uU @u1rBK+o t'Muft1eРxy҃yy \t1{Ðfv0pߌ 5b# qO4 t&Gt,!@ &!t&lŀ (| ubl t | ~GlpS u0pUxTxTp _ {t--Ű%`Ez G+3Bf&)f1F?FtbQ~ t^ݰuK{ 률ؙ99̴ t
w^MQ5ף:pθ #^85:FFu_	63PaX`ɀ	* 5*6 FuH^4H3 u9,3ܒ	4<  4  t^Q`u
43	VVCg `= = > w$1,̋V; -^Gqك#tOaf6 K10*da@&ğɤV*@L"A!i2P8PR&73c 
pI3T f+@F^h
&F>pS^qecNF#	9FsA^b?	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 0(q@;EP tutp@6~ t]z>_T9PI0hw*Z*#$(pK@|%0z&F
`](R0>z`c 
Zs	
hfp w/			/	&			cu^ABsI>0_)FyV)vf&0a`_f`~^NvVFn
fa
@P~ǿ  hRP&$ RNh^V6  u*	gA$d t^!U$tfX u	   $uy$T u
vxay%2     v wr#@4
XpnXs$htfuCwt&h⸻=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw~d\ `n`t`1 t\nr0eR
Nx!
\^%
R
"


 Gq(e
OR
d'3`&8g &3;v
軖&`Frb@s
hu8p@?Ht',ha&)&Q[NExE#i3o+Ǎ&k&K!%}%"_%+`Is)tr %eH!up%  )fǆl @ Ɔhj%2&  %hJ% 0O&= Btw3-O-,u 1!?0hI! t#*Bb- [t- 
tQ Ğ&8t& `	
uAp@_*h$ǆȁ
 v}/$׃Ƞ ɋ$
̃ P#&
h [4j*"8gb X9A	
@R$ơR
9FrF
0r%*+P/Їvߎf`fߥ^z2hXfhp VoV3QP
wPʿfh  pv>)vp+- PY3 $=.t = t -ot ) [ tNfhs
V
$q

pc
g
U鿀=K_F{0=ikI'HS-	t-
߄-= K-w- 9t-
t- ,Mt- ttrV>Pu$ >=T 9  r'9>
 tFu'^ !^ fq q24RPV>90
 ^)@Zu)°N J?63L3١FVx'p#) rt	tp	M ht3h9 2~9
 8 .!L3 (R 6 jPP ff92uvf u:9u1Sʰ~(v(;w l!d  f9S&:Qt?F3u*֡Ju9L3 =2 g2 
>J3`kE~F vN3'@'toHHt	H?Z !"(~ u"hdhl{p  ڰEP ظ; \&u< Ou	=  6 t?4ft3DpuxPp
 `_7N3? >r-&+'Ht
&pVtge9ԑ&- P9pQ~L~~?? ?D#)>2 u@ܿ9 Pp:?h2 $7"0-2C{ur_? ScjRY~O d< #@@=t9느p
Fߊf=E` v`W W QM [(3*3'$v_	v	1b
 g}^c    	-C$а=Jv9s!vp29a|Y&v9P31%PQv9X#> l
GڰSM>4J4Mېp9$ G*GLQ?MV?tfG[GGID:D/p
L
3LL9 3t\Ni2uY@:ADE5 9莠(뻁>? K9Y#9U]-U"Us>":Pe 3df;ÐnP3|t 1*䊇N tqu; wb ѐ:Аv+{2@Вfj
 fXfYffffF~"FwF`^)FX@/9Fv	F_F ;Fs"O=~#vPp ?F~s}{@~f+f:uP63
H3r~tR}P? tH9}b  3OF
z:Aj` mP
  E03v9f"0fPfF  FQ3?2 23-6@|p[~6g{!H~FP@2R}Y	9"
C<	vaRs
9" *vOb__{P @X)W) ffаHYj&ڙڿN^+wFV;r
w;ȏv:k@+؋F K@H$d +3
`6@3s/ pq(~6F:7`6t 843[`Ff(3f@ 9Fg-/	
 SP]dF\

ׄt)2|3a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*N-008 t` 0rn 9v҃ F~   WVA?P0bNq؋ɻB  RV3^_V @'=@Sw~u!tF0T QN?V
 FXơD!@
P"{
 ވv3 vaufpocteσF t  q9[EuEc>f4avm3dҕ%|! c~~ t?!(r4@q0]B3^
0A 	 r"h V3 V3X3LY)Z3@03\3`3pa3Kbr`qpȣl38n3p8`aͣ9Х99p399ֱ9!ʰ9~Zv?r:qd3vh3 f `ZP	@M^ X3
 UCb!ggu	W3 &?r"` wh83t\A۲ 1  >kuёaa_{	`{V` FV
22##b&w#2#62;u5;+u1`=1;Sa7`N
 Z3;aǨS$Sp"p-}`f`m  3AF
a%RV x
b- PZFp ^ $ !tF f+F;FwSGsp"8@O+V  " 	2  @3QFFf>6 tK;8rBw;6v:j> '
?+v6 68{P 
@и@;"	P~t;Vwr_;FvQdau> uBuХ12122;Fu$<ut
f>W  po M% Ht pZM"69@2$ t*f`Ŧ^&G&tp&9&9WZF N%  F9FИu t6"u
ǷFe P$ 0V `Mr0M97AM@MQ@M 99~ u-B1N =tu1QO
p
  t6_F^r't"&
9F29FXa2"cK	
$`$a8	 
B@Au.n tohXASF9?F{P<@F= ^\l3n;FDVFRq@  9F9nJi	+QmlpmKv	~`-t<1Z΃e_q0!v`$,)P(_%4 18r6\dk^9u9ukF?P!d0ABs
 uߺhh? 3}!Ƈ¢h9 迵9P9P
9Ȼh9
 fPSS3&R39p9p9 34G2p9 эG
Paf
! :
":ukFC	qB*siQC


w
t!9

	
|`ЮAf@o= uE 6"~ {
C 0\
u[
 ufs9u6a 苀6X_6PPR@`霁@^#br`@Q {a	 Sf f h:F3Sp099oh.:  tPá'`b ?q3[g5wt38FPj9&_0`Ð*GKC!ՍFu:~aua J~Ku.~Tu(~Bu~Pu?
  st`" Đz   ǆ~ /x ~bB F  !MSQ @@  ;sY[S `F@0Fآݮ֣Rԣ`ң9"\FHb	X AW`FFV6!ZPFFw~oFH  FFF^0ċFFFF u0F&uF@ͨB 0FFF%'?A`VF *|k%ōFP#
L@.OXf* PWQRU>@ ~> j>*]/ us>@ ul>_L |is b w[>* L &D F +ȋѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tF.."
0 .!
<!
0t9а r   fa.>O.O! 9r & ӄt"QfpO u8Pwh3ظfP&.O&G.O[i Y0HYKSQ3ۿËȋ$tFhf_tbY[Pf.OI f.p	PpPQRvo`q
˃ӈ`
  .O
X tZYXÿ."˒O
jЄV3pӋû^]
 PY@ pσt2W  _^]Q  2sY >[
 u[
`lZ
OX
 ^!PX
R5?T
V
aaaX
c_  p}b> uV+T
VfTm
sff  2p+9Vwr@wA)
i댐>
 tZF  ץв` hl} * %w^$9N P m@NQhUAn`PV7$
F 8Ft)F ~ t/$$* ^ u`+OJ F ⟡Rq$Toh`y?	-t-,tzPWVVN ^4~&&Q#2#222##;u;u3Fsޠ7f9 usD99r;u;uo'^_`VA;Ftip9^Qaf	L24	9a9FPt4ŷͱuPPR"`fSfQfR?f`<`Pf;sf;wf;r v s@fZfYf[]SQr QY[ PS [2BppFt%&?	u
h*tЯF
Qm!:P'  0Őw0: .W9'1:aqa*'I+@0>ɱMQ 
p~q&Gf \DR 
4Cn9w*d !۔	u$
wdw
ڤD1u`2Ru	s2G2ZPRZXPRZXp6aIP
 w F`N0C L2aGÀ0v0V^  F+2@ @tHH  ÿ\`^^
 t\
!f`
fq d?
-	k d
 @hc td
37d
+
@2f
9pucf>`0i4ߣ@h
0f`
fj
+j
l
f6j
2+[TQUp΋d
)R%0PÃ>S j
^0]uݡmV+ɉNFu3P\^f&@gp ws0WI &O
NԀPU `FF&9wv1hV_ a9GtS
uжVdoY@vthn?
V	`an
 `܊q ܂ rrÌ ơOVfWOˋf V0 +N uf3lf3@fƉFfFfF /lVVgv ^`^~320Uf_f^]н2Z
OfCORPfEODOMf`ްW'fufuf=23AIt
f=46AI`(࠸[`^_`p< htFqKV1Ym`ЋV
l/FtSYnF&PU #@P*C#~ ~ON.`xDN;׋Vw"?WV~ӤyÇWVRft x⠅.F&%G<ar<zw, arzw :wr? `SpwਉGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ϒໆ^FV m*&'*@?@ &l &n of%$Pf P%#f#f#f#f#f#f#fXS & [Ì؞WVS3й}G@9ڃVp 
VN3Q||8 pVفKu~f
r;Vwr;FvN3ҖOu؃ [^_N
Ȑu	!Sf
΂Ӣ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@uP{09t
 t`Cr< u	ZXCu33_[ö΀__SM__v_DMI_0 _a$PnPB@_M_SYSID_BP ʡ1/ tc'dD@3NtaA t䞊аȑ +tۂ6 0S                                   5k   
 UNDIUL+B    @ ` d$ UNDI  ; :`PCIR$I  w      ?L 	 #$PnP ]u_ !
HP Ethernet Boot Agent v8.3.9 Copyright (C) 2000,P 5 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 A  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tx\.  <`!68\.	 VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX3S2.ur*= eu 4= ]f   @g@0  .9u
>l :@ tIu[SY@ @@ WuB    1*WSR..>f&=QEu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E u}qGG1G؀}|E$t2Z[_ϋ]  .Vf p .f XtfX; fRSfPp u'fXff)Q)0*	f ffX[fZ? sf 1f  f
f
kf
fa PfRfQ`
 q\
f'Rs
f_ufdQ
fIu sfݺf$qV
5fYfZ` 9
 sf3(
V3qfR	fQz
fPh  u
f`h  u0zf&	Iu`}^(u
1 *40"t*	3tt"t!
tuA- .-0h  fPh p @ &eKPy)}v ohSQfRWVsf.> t.@   ځ>  Uts r r hPH 
X%
nEC1: Base-code ROM ID structure was n`{found.   3r덊  t	}Sfj j Rel>  t;sf>BC$uErPj W"뛌ێÅ0 2B ʀ
  w.6C6Q   j Ph
	D
CZDt'h.	RRBX
BC_#~() ==  srp@hY	M0F: Exiting P6 X^_fZY["
fXgX=eKt}, q . fТ 0l S&t  D
c&6 +&p F& Do3ffJtuہ 32F,G.0	pi6&ԋbIPTWfUj j @RV{0l&@.6E.{ ..ā.e
`Y{v(VVE6UYW0f6U_fV  !eX t tk Ȱ6 ɀ4WPoO3203IOS extended mry c` error66:3driv0image is invali5%98: !$o8b8;seg9:NV+%GFjXGWhIf "` p)ӎF.3v wFV 5pI3ICOII=f^f sDh
PFx5  AH@Rdrvf&DFO&D@ B!U H`PeJR&DPVS&(DovAE@	ǃO6O6C6Wj 
&\P
/nf "zp WhX6 u96} t2 QL ` N ?b 6EF` 6]
076u7]/fS˶ RfZ  YpjUu
 [$8v uj@OH F FRvXtauPtfыG HF +F )F[fSVWFU  6@e0(!(pQfT`k   f`_^f[^i?f]f_f[a!8s]T\0 !%P\\Jt uw ]`)`T%T0pofPp = t.. ﾭmޡ.s	N]&}t	q t+{f&} us.z9wf&+f&;Esp `_fXRw/=  
 s@8r&f.+EQAuf  A1f]e3_` GY  ГPb tMtAC< ޣ@^p.G3. G3Z O0 Ra_Q Q Q^p0p	 aTTR!U'U$郑H.w 16%_%IOs
  ]'uTtTs
 Ჺ	`&<jt.;60 r }RMXrإM=< u wG&DA 0S  &LpS&S S"]GT(T*T!T0PV8UV2Vi:1QWXzUqUQrt }VV,rUY˲Gu*.
n T
 b	$ZD	R$?``f[]s,$ QSxQ/'f[ B :$|0K ! 2Rf.>2fPh7fA @SV ; pp m@f{raPpEs6 <u-ftq຿  O,m~ 7F`uP4!T1h@$"uz	!X taN@ M ۊl 	:p u@X2@+`TRp f
`RúfffZSYPsfXSQȡ8tYQf`S Gf;ta#U	CODOtSfQh= u.fU f
af= tAg(of<ac rp"uX3.P.P #.QW.m@P	P@@..( SXf%/bx]Etherneot Bo Agp v8.3.9
Cright (C) 2000,P 5 Hewlett-Packard Develop Company, L{.P0All 2s reserve MBAnfiguration Menu `  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"ChanpValue3$FieldRSave Thop2
@1selectable1     Dis   En 9                 $Protocol  eb&Execu"EnvironR#(j@)Rpteqgram Load (RPL)! *ap (BOOTPx 1W}S-6  #  X/S"Type  Auto`-t BSI218h 9 	ix@π  Hi0Setumpt 1he9:displaypdurin}ginitiz5 6 { G@ Y]`anKeyok`5SP+B6B  kPcs ` t!1c; u 1 @Bann Mess!Timeout  1  Q6  2 `9  3 45y6I78910 5 7	7
7  NonB  ;HUbo|4'3F y   LHSpeed&Neg.10Mbps Half	FuT( M]m}M%810;@ :-;Wa@On LANp)1Bc9АC ff tf5 fQjOuIuЖQ@ #-_WsZf ؠ> u
fUPf]T ` dff˾!@΋f< qf0f	u 
2
E,=
u=nu % P> t 4 011auyH9=П0|
E2`u
F)fZ_W VfEPE`ff%>! t0@ƀf¾>0	BD`	
>u
>s 1pȅ		E` ff Ns*2˸ᶪ`Ԫ
Q##ѬY[_q 3KtRMtpPtHt.ct>  Ρ =C} Cs }h 륃} t=P u7} uEEH _E 22@;Ev3& b.# @uUC)RVUmP	Xum
>n ]^ZQP>*=; uXYWQUQR=m uUZƄ]Y_PRR0 ZXQR	 ZR {  ϰm  [ ZYQR 2f4RvO裿 xS2_SQ  Y[P<P>FXô
PSQUE  >
]Y[XUP3>F 
tEA@]PQS >	o  &
 [YXø  RU n 
uP	]Z(*q3ɺO	f`
   `!p:ޅ 1.? PbXL7RZRZP0L>
[3faCWa.f8B  ` of܆ܫ`4Hsp [ .1LPu"=!OQX?tP۾Rm c@ffptN ]#
t=`aiwu	 Pf_f#Hpd ݇\!_ tÐga`8 ~ f%5t|  s5u&f @S%	f(U|PwuJZ/$yohrm uC}!kfnr!afRmQg.	Itf{f]s`};d}f1^`zrp{fSs.k3r05t.?0zmy pAxf@! b_$t$t
%	t nqxf ,u1 n2q t#T3QCG34F"u+tf  'o)[T$t:+t:AhSr;1BPq(Pq})
f y%T$[Q0r rffR2 u	! ޅ7f7&7'7`8
݃Iu_cM37ro.Je_da [qQ ۻP?_SM_ts OvQj Sjo `jA u ЀwrgrafG24tWOpQШ Yuf= wSX,g8It#gfXfg f@@:g@tgef&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[e3?t2)W >u>^> Mu	>p GufQb` Pfj D< uf> f^s PQ1߸fAf t;h_)cYP2
PXE-E07:  PCI BIOS calls nsupported. .	uL.;D u3 tnh/*U1: Un6Device! hb*׊P^	4: Error readQ
space. f3ffwY}~ hxjkBus =# FuncAQW *_YSSϬs<f f rfh*.Ph*$PP*rP׿fX53QUf
|70M&V ] YAUi ٻӰp`!.>B@P5 .]f[j  wPРXu
U |U.P  >.{@[TORPu$.SAFus
.B ` t'?hUp    vh!Q .P 2 <t@h,PH X}U.6: OpB#ROM %quires DDIM.. 9c7~ ~f;G0jfjf.`9afPj,(-?fQ˃Qlu0hH-Ԑ2=x
Invali0MM f'"-number0- u&h{-6E;:oc/e1. @@Cf	 `frgfgfff_ .f.>1 &փ0t=t	 tz` b 3fd @d f   $ Ph   ^.(%tf'P r
 1	. Qr 
 < pxcDIX+802.3 Media test failure, checkMble 
CLIENT MAC ADDR:ownload"ed

`SearchFfGRPL Server ...  AbQBCM570?X FounERVER NODE

Transf`Kdata fromrs,xne NControl to program @  :   /-\|@ ă tttttWS ˌt& 0ˍ$Aȍ!`X)R#ڀ| df `  fNV+S,#/E@ @f`G#?VfPF= t
= twM. ~
F&LێӼUh@ WPC
P \Xf^tq[f3]1pu
 /` jv
]w.6 j p>
f0<
	g]g}
wcr^c
f&H؎p
fU
S

f]
f501&7uPPf]f܃>Dj v[SJJ/f@Aa@ . 3h p f&D []` 9h uf. fh ``  V hg&5+g& ^RЀ+?>S_\[$`0	eP
fX&
=PVuwNVf. sf ]ϝ# 0$ . . SR[.9,up r   aVSv"q GfD[^]f`p1 > t;u Tb%@ ߰ Wfabp-. °t!  r Nӄt"Qaf֠48Pw h3 &.@&G. [i YpYйÜSQ3ێËy`#tFhz'09t`Y[*P#~ Hkp	03PQRv`q
˃ӈ`
BOp
X tZYXï"kO
ZSKJ7L_PHK+ 73TuVV6R6pgK^ySKK3tڋVN[tUVKJ:2	3V}Ȱwf~ PH   u^&Uꐳ ;FS{Fk @ϐ{C5A#cE{됣C逩Uq gCY]SރI#{?5c+g	!	C
= tw%= w@."= tw!-
lHqQ v {HtFj+=~w
-~- t-ڠϐ~@ː!>54 t^pj  h12uV&G)4p *4E+q - /Q1
3419r <:54!Oqu|C3A3!
% 2}
&1c ېV"!+f"43F4fUF3^|@lAGK T>3ua@B .<b	  	a? >4{	B
P/p20o54	}	Nt	\Of"4SP
L/	!	;p/	#	 		-S F1p&%@ F+PvnP TFFA#9Gw"^;)q c''t""n3*" xFw1F(GNR  ba0E&

z

F

^
FV]0+  V7!&;F^Î 	
w 00	PPX	F9F~'}*ffP <	 " ttf
fjmr	RuQPF?(; ^<#fNpG F^sF`=p{  t.&ЂN
P
~}-^v&.F&E"
|P O6F*DHtH|pH~I)b FF^/Nft0vQOR\0Fb e0Fv:f&p &@
R
p@
 w뻐+GfGFG0G2 4G6u<tfG"fG8$?, G
AFar93RK-B9999Q99x?zdIVZ%2F3v!ވR3@0f#|eff*C=G=G=D=!e49'	l
a/E[uE^a
adG"G!nGS.S]G
 ,H ?ZY@REա{1.J20tQGf 
ffEqrE|1hnSaRRv=Pjcvǰn:nj^$_&G	c .rG`"Pzss _WG  
-v9l1s
 +4#AfF @8MfsGЍ3 @\2\Fn#t7qW?K_t"
|@#'@@b05 FБHt- rP `ȸ0DVc+
0[ <	 u' f#Fkf0ee 菥 mJƇReG$PsfPh蜂/Gf3>PNt
4F} r\>t& 3{W_Pl
pR%ڠ6P| *G7i  xpj0|^!^vb
*&oFD: A`lu+lu$@mu#z") Fɠ1@08?&cD - t- t鑤 {^K
Gu!Hb @ 7N~XFǃ1F~w}&*t1) Gy+3  @5l4E<<69Gu9Wt +V-(++ *+ :++8t!U0ufhr0fj22,,1@`ރ8Ë mu2ÂP#SVp 0pNo9u2vv@VGGPlÐO p@RPx,,A,1P,`|10e|0b0k GG؉FG5 _^ Va5@ 
~qG_Q"HOW #@0GfuF@>*b{u tfwl`$""02F0Vp(ډ`p ``f~
t2 t(CMtn{t~t
#mu
Ƈ'  ,/=(u uPڈ@	<}t	ވ!fj  w/@ ZS`/T8hPuC% p Pu?p]   uǇ`.hfƇ^a\ږ1 t&b ě}#Ft^p{tq qtǐ@  Ǉ_ڰƇ]O f'rw% i}G
~uc]`.R&'T&	BTveK"Fm XS"%0 +- tQ $F8
%  P- t/5@% - tQ 	Иc00ZfC t_P@T 4t.'(,d
먃u0	Bt Ft' +w  p@⿹tR/a ,f5'0a>(DfG - 4.va:s ]A;P- u~ .|<Ǉ, dK fch j3lnp rtv&0 FV VFFuP0--$ suV@ L?ՀFV H*AHFFa c?VĊUSǻFAvQFރ~|~auae8`#u(psu)w)s+ҊԊ*A SjD2 >% 0# V		V!#B  Kt@^ $#Ƈ&E  $-@ ` =0 tuС6 9C1еU  6#P10{@c t+
u0-I5u~ptt~t~ux2Ln`ugƇMЏ5 0j!	RpP. `D- 4-p --t~ tF	@7'gtrTfu ށh E3of@7wZ=Uufux+<<s,@Mr AA  s$p>K$[`]?u>@(V?-bq	`!wVwixgHHt ABib=Fi\`c*n?C$bA$Ibg uxDq 0AyRHQ0C)¸ 襴  [Î  U¢sr``% WT̀P-װ9Fސ^WPF"~!]" wǇBP1ƇzP /0q!9Yv(kD]pG`]0!!ǐfv
Gv)6gG
P_ pc uu# (x ]zPP|@hCwSAVEpQO@xN/lp t譀lBp\% o@'FCC h@jt! 2"ʹ!ѫAuǇT p+V|PVT P-t0.ˡfFPsPPV"eeB_f 	pP `ue `-aqT4 $vfj@Dՠ t q @`@]4
8Q`4 _P?$0~p=Pr#Lq`@ A>-/(遰T`smğ`vf&0B`fV-  fj 0#&VP$A@T ^!"XX `  \fjH*P h!GfP,g{ӸMǇl& &YLp  B   [ Nc
J?s
$q
Q/
PwHÇ(`Oru Z4r rRר t`B| ٔR>c**䊇*   %5vP8Bfh<5  &dP(p
_ @b 506q@c 
fh fj s:d'<K h , lp`t( 8`^Sw<@yu0o4a$$@T %D`GT	 P	8A
*
B+0 p`
 -4T aLsπUHZs P`P(PJ0dA
CSLW<H 05O(腠 8 0ޣ qg7{82S. P8I?  +\ Z߇tP\s1W\\XXXh`!P +HtHtHtHtHt3.   Hi2ҧ ō&J]
wQ^'ss1p!2*RP_+yDȋ+p13w4+Nѣ4ha낲PxPzfps!!s tfah PF1tt2gQu; UP[S5A`GW$ Rh~s3|hcPOEWlRP}hlt*"#+!"+3@ЁJ3  PSV7؋GFF H߃00$[ F I	07FFPn4p`
v@%IfDrRېb0f)OGp0`8И$sw*^f@Q @@p@+Fц^ GW BcNA#FF+9W߇ r]O0E`͉@WrBੋV `+;Fu;Vܠr"wYr@$%'8E
	
FM=F M99Y讵 6  y~0>c(  R%3{f@HZ WFtWf  @BfF֠NfPV!`!S aP@NvMZx z_P___FX! ^ҁ+ FVڊF$F$`Fހff  Nfffvށ 	B	RF9߇)v frpN\~|DSV^^^@_[&遹Q^iW']un.ab";p0 6X  P54F~skF|FlBEP
PwPHPP@G69Gu9Wt*w ?@aI^1::}DUPS~ tL ;
 qQ;4`G~qP	QBCJW߉FV!f?9Fд0a߀W _ t a F@'Z- GGQp3Gof Gr !KV=PC
wW0{s@lPS;C;^ |Sq졐 0f#Ff0dBf@@== u; t뇌q t
NO	pONFBtIFt)` tF{t  7 t1 *]#" @	q+^XtDC
PQcvg\ěE( S
x:0 uh $3qǇ *IS
F~}PtpSt}Ru]h%`  F u<h@QWhfaW$Pea	-	 u&`7`3x}qF]9{aJ )0O
 ,B=q 3t9I^C@}!A % = u݁ksut`F-a2S+u
h,}SV=(u# u^q ^ '2FF`  F䋇 RVH! h=A \ > Pz!p?D@@  P  3@a#!u- = w.2F2P2\2h2t22
:!v}&vC 	 m~@}<))Kk M CŇkjֳ#_ hp0 0
 %1J]
x tP,Ht0B#~ t']C1 }0B1>Ft@2Kuz= u\ t:C	Ra.a{䐏TQfN	*䐶  F9F~BoNuN,  x䊧puq'! `xtohcʚ;{u%Q= w3"4W40  X"   *VV!"89w!/3`	9_fj"gZA q&?00VAQjP
@ wNpML௑*ө  uFQu#QJ INRPQi	U }RPxm߸ 21
@` 1FMm@t]F~|߄c 	@վ@D^b{`TveK ۸P ]p ,~ޣ=` unB
RjްBa5``X   V ޠ| P q޸(grPh~n胠g ww (u:@ t\q>Q 
Mu
@s@98 ss=ut	 
m
QDPfB @t |蟇݀ ݆*RP=
0t0A u PJ T&#	I
Nz+,fj@P$ 6"ݔ tutAP 7Fp	}+Fn&ΐf!Ftfv? `9F}@͊ *+1F1VC
Ң@ Wh{ <l a [0
1ీ_0)'Wh@ba0bP p:`(~ `V@CO3Α5fq"f% A WVd uBfh /RPfXfYf3ff	fQAv~pt8AV*@?pSfh4  Fj dݝ`Q Pp
Ra{t!W
;E(A#^_S``u
 uP2u'u
6`c$	Sct<S=8H:"4@LAڸ zЯƇdGh%?%  e`tku75|@F۾}pu:Q8{ٶ` u
 a8u@q62P A/{P5$<q,t %u<فfvP28̰QspRtK|t?fj7 $j#]Paoy u
RPِ!ff_Q!"s`ɂSh j1#h;"h h@EhPC`Ma0tT֋PtHt<Vt0"$(x$@uï2Ç!@`'P*"40ك~g
})`'ЖRiQE@AX9FuΊF$u%U`)8R. `p;Ft 
RE˰2Rpuu1ݥ?u0SPCWqZ'zQ_0%j Oth ^RB"b| ur?v= @v#` uv	Ѿ@vl hM" @ҽP?+`R@R"|h |
 ؈}^Bo0tfb_uDPn yu8fhU a! n=u;tdN"d|ݸ[4<bfj`Mқ@VPSƒG`
PG` (9Gu,B)`@+wac9Wu2{>|7@0P)G}GpuGNW9HvYG`k@	3yO>@W ?`8_GGf׋Gt@f9FtgH6XP^Wi`P	ۋGpˏ$I#+5< !ufGxf8A^P(GtWvc`w6"xgh2 =t(MCuF 爇h %fh@D>f+f|a?Ǉ  sG dUfSh j#[lnp r!DvtDƇP֠>>P` a? ? {a@ @O ">H= wsvC&C2C:C?BCJCRCᨐN<NFXඡX+9W$rLw9G"vE&e-iPЩwGA"Gi^ðU8$Wl뤉V) rOw90vG  [GtQsP&YlS"W$a|g1"
@Qe[Pu9ïFNFPaA+K F &@BEE?PS;FtN@  l &gn c of5^A\и GA1@BP409FvߪB+F 3p7::`f!f6ulGFAfhA880ؾÐ3S/P /P/P/P/P/P+PA"G 2f
#f  Q0  РȺff-$˝]WO@>"f_] H2C@@!PQRN;ssZ?YX]1t
X	S[`[PMVB^H& p 1蘼H4hh4J4 JK4fS4Jp¡ʰ	p^,*n3*sk at$?h: 倨߰G hZ e@Ccvވп: >RN:uFo~rѳ q 0hn  tfb4qA>f4 v:W4 }D
wq'h  3 h 軔PÀ>u+0C$Pj
 .{S4Tf

YJ4*HtHHt7K>O4}H<O4uU~]
@Q4wV4Q4Q	HB7`F\a|^<`Okc	@! 	rqސX	!G@WB`%'&!(0&:@#|< Q
&c	A(r]/1Av	P0OXif`<@s}" SE,;$?~'|6"A˲0P@Vµ1⟁~Gefqf+G0 43<ga׋G" 8Pȋk,*C
N"ha<u AM؋G PS  G1GpGQmE @ BW  0W	@ !W#%
 'W) t+@
  -W/;=@1T<|@ 7׉W9;ߺ( 虃<W>$ {臣@WBhPDB|PNNs	LH4B3
N 6
G@R ~u	BS3
XQ1Z Phߨ Gad gCRjLC][4C^ceѫQhaP baK4ߋM42kG/WwIe#JG,) w γC}a	YC	=2U"r1nq@!6F^^&߇}^Љ- ^?a׀ Y QG0G QF=C]$Ht	HH~ : W	=@W
t=WtueNu	f{   }Cp@}-uf0\ߊ@"|N t݀N@AW4[}btt3R!G<]0 h Bb ||/` wu_h oflqw  uG G tGWnP^4`0W@t)GWRI Nb4d4f06-f^4fߠ^4%F @@ +^40ua)	)h Z
p1蕷`t1Yw h Ih
d4
h"[
0

!a*`` +`ġA׳rV1ʱ {+{q.|&-q_ P@_RVFeЀ^&9G,~_! &x2 ~G f&p.1@2w
!1PpXq)F|@Ε1@ _1 	`1}PV3q qPѶ@;fP L^@Mp6hFf #8vY' QP<s9PV3P~22ooooooodЀ>1 u111p 1oRQ?11a1#苧@! u  V+10퉿Vf1 sf  rp+9Vwrw V)
q댤F, 8`,ߊF,q t$*$* 	v	6aĊf!V¾pȋp֊n* VԊ:	 	-t-,u!GAdapter - BCM570x NetXtreme Family B57HHardwareDriverMLID}  
 QTo  UE Q   /	  
R 
 ^<      < ]@   ¡pO   5  
ں  _W@   BUFUUub1!XWWzX"]rYWX{WXhYX]XXXXXXXYYYYZ'Z"]! YY[XUV4 8Y+& Uu[X  	 
 ]˺wW<SVsrt*ݕ+V^[ø.V* &D&Tr++D&5&].Vù VøtK
t(S [;Wrw;GrWڋR [;u+uo+DDuP Xه\.Et. ǃPG*_G,_.O7HuR.4U tlUu4  glvgn@w7 ñ..V.V"Vr0]7GûV  7t&&TW?L+0`~< .:uOu+.V&V+.: uuL
Lt\
DPX~u< 0s"UU+Ұ.:Vt+EZV]~  &V0B_OΌOWt&PDB#V ^uV&U+pE"u.Va!".VVV^cEU觫.QuMZY`Q Xu.VeZYQ.>V u _u;BVp Wu(gVVD,ث+|t#6"UPU <rg3.U.U &u&D=vV U3ɈM .Ɛ&0\`!##Atʢ.9Vu.9Vu.9Vt@0.UrF;wrtI着tJE ]P9
UD&D tz}R@Mt>2 s.
 @_ Q&|u~`dE

E
ED)7
 Y@۱PQ<wpU
Dxt.VU;wŉ5EEEU.>UtE  m.PM
u+P.UEP E E
EPVE.;Vu"VuJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.	U3Ã
Ëŋ+HstCP
u&PIٽ{r+\2!&/GIu*\  KBPUSQRWYkX_ZY[]XA6D*VV+tV,T+ێÊ&S&G[ú<V|w! Lr	t+񬿪u+<VTLʉLuIuËD頋D@ V^\uA߃!D<w<XøWø~Vø.UøUWVQ.U0]P U.$UVP  Q   AVY^_PS [X FFt%&?	?u
h00S`&F}QÀ? uޡ~\ V ӣpV~පu20QR 3ɺO@ 30`ᰠV
 Ftf~ t _F&VRPWV~@N{V^_< $~ӤAWVS3}GVpVF

VN 3Fp ӳ80pV`ٱu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3E^	۲	ɰ	ȱ	f		+FV
?+FV	Vhoi^b&$0<9vF%@܁                                                                                                                           -     P16X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                               .6                                                                                                                                                                                                                                                              eUPQRVW3fu@F(.;3s0k@.$~ ˁ ;u
t.$t@~ f^rf(_^ZYXWQ3.>32 .ǅ$?.ƅ$ ` P@hc .3 Y_$
fPSfQW	3.3^h ^ hoRNwFk@"~ h 
N~f.$=&@.$2.>m <$uΣ4.B$f<t	of!hS$< F.4 
_fY[fVF~r$F F;F FBu~ww
fF@ M~UfNf!t
fN!$pu
ffsfF;^P2$p4Q$
fqDF$<u&f36$F # ~$wp` $.
u0 <u8 P^`)V.k63@..3;.`/^V0&0
09t@-2x@2-
E/^S 65^5#5$u+:Nt@?ֻ_^13$::
t3-S9)Q9$um8Nuw_^7fPf3Vuh  fhA] ?^fYfP%
S?  $(t uq5u0j !0 `*-fVWfpF(3Fq(('F~Պ^^h<֊FՈF 0ff
J,F f^Vf^qu? @  QV3 fz ufZ^Y诿ft23fN Nf~ tFt"f~ 09FvAFH;F{`0Z 	Q}I Af9Fv9fHf;F!:F׊F8F uE3!:fuI"<`<Af+ ;NsGf?.\ :^3(tf+fD;<
I;f0Q~uK~ ktE2aP_F?.3NnP3I3@K_fd'ag	i"?
S#0K"# Lt#^`#F  FψF$
$F$Vf` ^$". $$ "`UqVڀ"ư NҀ" tFt'fځ"U"tmj"+d"b1"a2"f;>1"7 %A/ %'%S %#% %ъF8F 4  NhsU"  $&(U,VP2@Dc ffbh.$Ntt(sPeSQd?9FvI" 3f%h   f. (쟊Ϳ  BykN0z30b
t
F%  .`, q> hă~O t!~/ h*< VWUhC t  ?f yy@N f?Ah 5 PhQe 6 h{<rg&>Ut2g&FP3EXYPьX_\P0(vX0}f	][Xf`Sffff h23   f;r[hU WX
_ WH_SSJ {rPgNAOg	rH. u \fawWfgf&Qfؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_zU!yg^&N;=g =fb> U?  q^6-A])QRWV^NV v0Wt6Q4pdCY$DʫξE^_Z QкК tYfWV3ff1%^f_cfSVR߶ÉFon1Z^f[ffABRffLЀ`2fTf;w
2ZǖfPRft#f3رzfdpZfffNN 8ss4
t}7u+%
u	afFf `^^ZuW0ZF8^~nI^B"8uAffF@b_QWVfvnAF׼ϋ~f3`RiAМ$ч45SV ޾3; t	 r^[à,Vk߼pPW#A[S?^@俊$*&t@;v7!tk~@t 1;FtFk^% Bk^P؊ap 3҃  V3k`Ջ
C*;FuR3t7*t-k		# a
@S
+FHu
4uGrvFvVBs0;4VW@B΂tSދ[NuVp 3ҋ-`@_^P@ʠ**ˣ^S(IRl2XH⠻-HP$뷋A37Z  fGVRfQFu   kv@kF.b~$$I$@frDfw;=< u r,.$<u r_ s0	 @vFfYZu@0.3FNf1Պ~߲d
t".tt؍׍pvXv둀~ }ZPRρ00;F~f!20a㐥""0P2N~ tKv њ0`X9lq.A\$`
fPQ3I> FfP"f
	M SQh3	_ \PBfq23QR.3Ѯtf.7&3.`.83tYflPRWfQ
(5.'{ "  u߿8ufY_ZXNW!` u1V#3
6G_@+fz`  Pfj7/@
xVfWf.
ۉ^2ۊ~$=`&	?ftufP f.3| 1cf.@( h9S
uF,8Fuf_@EbgR.>3s$	Q.k63.3VЁ #eq 8
 v@a
#3t#ًËȁ :u!d;  v t'f#~pffBpp=prc#n;VǯF"y:` up/oBqr[tހ~u (i/ t>x"`{(`Z J I<`:<F?  .3;2;sN0 t4v;2&;zf~~FN@I.3Ƹe:2fV4P]b0)6SJJe{([tҋ\fۂf`K8faS/ $ x!V V03  1@ ^Y?X@Qu~ O u0V833LitQn
tw
ɻu7Yο y	G_^Ha? 㷀chppL" "  ta#2JP ؎Xu	Axu/ u5   (ru.LÀ^A. $0G WoC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   A     TPM U(    G  N K 3 U fWfVfSˎێf3  _f=G<t<t
<t<ti  f[f^g.$`f_tIFXTPMDRV-MP-SEG16 v0.95 Copyright 2005, Infineon Technologies	QfSfR
gf. 
g.a3g.1Ƈ3 4 Ǉ,J gf   u u  fP< fXf1ZYcQ讱Ot[RS  gq	o <  3[Z0 
  
2%uP 	xcst	 0	f{
A
2

 WDF<		
g1$u	
E|C3f
f%Q`&3ɽ
$f6Kfff˰ gCA 7u3gF b`RfgD`"gC"f(g3fGf߹ \"agf4$ +Iffg` fG(  (	Z	_fGg'3gf`Ufr)tfJrr`i,Z4.;gM1"2.3N4g1  f_fY`>Zf^f}PA9!F3RQT/ʃ`ʊP a  3YZRfQSڃ <u1 u%t<u u3
߹ w 0 <	IR	컊T		 0 tϸ 93 s d _ psOJu0t  $&&A	ML'a
pn qv2fR&St2p  f  `OQ f"FB? 49 f t|gf> tup ~ tmށ  te t]ffֶ-N0.^.6A\RZf;sEA\u
 ',[5 1 
@JB$
gb +\^Ðdr
3ҷqBH ` u
5J
0bu"K ЃuBw1dUogG"GH!G[I#JHf<k>gu0hph~@ Y	uBjd<u/
uG u\  OƀtHDt$2ED$@ff+f+#Z舢qu  q^rQQBNL$K		v
u YpC0b%3 wz}ǀ 7ujPbT[4\ tL2`Qxff3ff%f  gf!a	QRdgAbetff<f;s gb
fgucgB`ZSoVo oA!o'oBmpEqfgPR%S%"R%Q%
iEgxr	S t9
 [_Ҩ% Ƈz1yn 吞RБ tk [@eP{m `rCfRS2 !@^R nook n```` s
@l  @nr
 蓦 PagdTf_3g3-3-t
1#H GCCQw	000
000 0j=ݱP>~p%a"Q,k+A-$#qrqrtP Dtt%53Q . ) t  tA@tt
 22: T,.bFg%65f fQ! !Nql݊q5qt21?  0w6a`qtnf+fH  gV ]M6kLPaG.O_!t4DY+*+s0,rF`"atfSuN3 (`H0  W. usIu3PiY mX7PS[`4 !6&  SIuއY[Xp$
pqS oq[ჿA tKC>X p3P   = pr" fR
4A1f}f+8f#b%  t	fˁf{jf%j
tpe/$z Fidk&   x < BufН         2 8   ^      SEC3(     SUW3_3 G܍M  S.{0.r ۏ R f= uf&TCPA W HPD1\_][U˳ "P		  @ z
  @  A   < t.` t<w!3ۊ.;@ !W 
 t_  @  4  `) nzp
`<wX1R[1a b > 3@ upawP.Q< `0~ u~tPfAi /@
t%f=uaebS
RuCfUf   0k "q  
 FC1ލ
u
 
s4"#@A0f] Íݷ&]0'7F!'4s  iR !}j]@

% 
@
fǗ  %?34QR
_u" 8?	%:U	0?H
2%8L8  6WX
hrsqˉX
WFR#_  "-H  u7fEfp2<#5#6
M)F <0<Q6=U6fPvFWfX(> ?U@?΀?? @U @7@@X@p@E A@AA BWBTH2QBHH@83 ]. 6us9]Յ@κ軃%"c᪥tK%
%
\\"
I%v5	u;2# 	t	1
T
Rfu aZRwn u
1PYUjc1@1VmP@aPaul=qG`fQot<tvq `,^,YPu_ƋA'ar	u_̴ٍq6QlC
{u/FfvuQo}uxA k e0Mw@\
q~
~P:
@a `mbcPhpuf]ZVSvbrl蝻vZR8_`q9hgA;gBrQR`p|ZYqUCŻaDtxw3&uwԄB{ux$ pP|N9`tA|ba f;tCC` 7C@C
o0bC3ffFfCfr#=qLsuM4@pNF CO`,OP
tpTP,OTtWK{@Yff_fC@XPS
rYUY D~!֋sKRp5ӜqaoOfUV1(a Zё#a ѫoXCr'C m)%!	*ѢDVPV^t@up H
CXPq8VWx_^ tKS[t^8srN)P^rNfǷ u  fF3sSV+1-$ 끻qD;w4ƀ1W_r#^?[Vs1	Vfu1+^&F QVW/$q}Y3^ѻ TA FKZtVW7{ P^?                                                                                                                                         0    o ]FprT@F"` qqSb@ eCompressed BIOS codeOther     Calling INT 19hReturnP
 via#8hBootBCV Device 6E6    IPLCPU _patch                                                                                                                  #EgvT2b`4  WWsհǃPǃqǃ9ᐉǃ01wЊƃ1r u
@ow*`Q  	@g@_p
ȫ_a`Q;d&GX7 ;w+В +ȃ73󪋒@&ast@3CÍV_3P Q 3ff@r	#3Sɰa pw#@ yZ1'w33n!;wP##X~ܼ	2b[
fۄſPAbc"aW	RX APۂA𓍳&a   
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf           M52TU~o  0BIBM 761295520C??
D05/16/06,10:30:17 !  !S|<0Jq M52T PCI_EXPRESS DDR1 
 BIOS 392e/300m      
YOU HAVE NOT CONNECTED THE POWER CABLE TO R VIDEO@RD.PLEASE REF` 1'GETTING STARGU' FOR PROP HWARE INPLLATION.(C) 1988-2005,  Technologies Inc.  ATOMBK-!VER009.012.001 5.020223 BR .bin  265011   11052 hP$  U <20~pRJq  ~ 	  	I`	 ϻ<S ..fPfQfRfSfUfVfWff2҉ !./0~.!f*4tf\fL;u
f^ fN  ~ %9 j@../ w k]kULP.P	.&fP. F
fXt f.y!f_f^f]f[fZfYfXUF f3F0FRӋTFZ]Ã>  u.fe @B  | 
t~@x@m ȣmnnPMID<O0     R1ffV`XEACt.:&,u$<u W K O :JX{t % rtWuCACˏ"< uw	3R 	<u
@^Ff	<u o
zP"Vc	<u=> u
01
F,f5	fFO
3  .6"	<u8
uǻ  u3ۓN 	L$  
f< '
F 
uK'T
U0P/0&F    ouF RN0{uu
*@
9999<uD *Lo"  q
<u6 3$
PL
Xp  0
̑!
9e< 
u!	 na;#N:	 %	$#L	O_uC#'u
 p%?@ "
 % 	 _	j,F< p"ua GF >[Nu

-s
m_VQ
$0'{O
'$R	nu@襢x #n
	Ġ< QtA
^3f t
  tL
 t
f pQfWtea
 
 
	%@Pƀ @ @`̀# W< jS؊$̀
À"
[øb؀
ߊ
S?tB	+	Ȁ
[A>{ 231
ubM<uKIfVt7fD^fPIf :hf   f"0!L`0u]SQ   f&`JY[}ʘu=wN pnF ^F.  wuI'P	N u_RQ0@@t Y;vȋZ;А PG/	\!	vV		h	n 	u+[TaB^\Ђ
> 

Àt t fSb@ Q1?CY<u#Q!4& " *&酰"Bn&x<u&] @QxAs U<u/ )t
5[a0jN  @"<w@) uHLb. >0 OZt!y  _0z
~C$ 
ouP$ 
鴰u2Ntu=%{2L$m|0uCiDP  PS1c{[f%f
Шd!Y0CN4	u^fEf%q{u\%$f
誛 u$ u	 heu}5t
Rt n.$

Qc!LC}pu@u $ o A$eu|0_$J:#Du &$/u
ڵoo$P%u
#2EF} 2䀍f}St)2.&qN V3zu
@w w[`KC3Bu&MC&U
C+'
u33u3 u@&%߀2IVu$"
۱t	<˰31`; 20uKtC;w	QM+ڋ+;ru;w+++Ҹ À ۓUV+rEw;vMx +r Ps߁ ؋3^]Ó{P:⑀:XP RfPa$ffXZÿRf  2£Q  ZÜ {躣 Cu轩k ff0 Ppff7P fXf[Z=f_k QfPMrfXYRQA.SbPC;_pf[Y"p~6a:B軦F
Yˀ@V4YfXPfgo\0E`a1E F Pߋ fIf 2: }'w *)eDXRhEUz  R
 ffЊfZ;U@3PKVV f
@3]`@VVpFZ])@w	f;0.
f`  0Qj..YYÊȀ $?n Ê$?[}Oq,&CfPS W[m fX }8%{#9|O@& ``P3Ɋްқ X[ƌ	f$f3% 莡[>Qܩp-#%:36pBt`˜p@ ;@0͍ f Y辕S 	 1MPA?X5f%? u5@s%݌) pI``
U3 2p3 >#1tk
t
|@vt׻#1u {  (-v x'y8i tް
 2Pta@t
a
 0S 菡 S[tQ-Y
Á2Q Yt'u,;DvDu|=4v Ý+SQè S| [
Y?t SQ9G~Y^ [[ᜓf% $  k@ D & `DAt
D
d8t0^ta"j1 U75N	?  1,
 tuttr
ٷ$P
  t  q P
+


p!ڢ
(0/WV۹ʕ^VS0[t H:mȠ^ V fpHti u * vP
F T/ D 6fW  !e@OFA!Ki	\ಊt(k!v `O( Ht!y		  f -Â  	&!daA@سt@s ܫ#
^ )B 5m (i /E fW@ ,*0!@O1!c!VP q׋ʆ$,1QK ;yRm
+,@$N 0,& ;,`v)  )MĿ)	g1_2 		23 ÷c9u<F  !5! 8uoaP!bP9u(@}PP5`5upP5		B 5J	HE,6O
P0
4DA 2
#P-b@-u*?p#Qz0'u0 @%HOS$OO1Au ߀`W D2p ݵ  0  PW33ҋt	@ l)n 1^V~_" pP_`?  0[ x P$  <t$
[X1𥴷 {V$FR7$<ZS-$<ug!fa3[]o%bd a	V拜^ !#%x'P*(- 0258Qt  y  Pu 3Y  Mv0n# BeYPQ 2sYRP$ s}$V3 (0u$w g:@}LT[3t/ tJ
u$<#u 8<2 ,<3u( T
& :Dt LT
^  @Q UQ AA^
1 Q Q b # 2 3  ŢqL ;t	@DP52L^SQRA1$ȸ `ff3fff3?fZYf.`"[1U2$u	% 8uðtY1	ШOeVf0!^Á =2uD& L(| wL|
 wEd(?3u, aV:L .FG>[D`
ED(t)E EQ  A%$fdo| 5 D+
FpQq (0:@t;  tfÊTt\|Ot?f@uaVRfGfˑZ^qLd\|)/PV^Nv PA `ߐfQf7ȃ  6 3(C`KfXo fYK Kf춑3ɱ߀Ă {L0͐(1 @˨ . tLu	lL@Rbܰ ZpSQR	 E`QR ~ +ؐKK;rZXÜ2C @p V> vp  	!  32Ĉ&! ^0MC3BBaaĹ pa@NS7Vt
 C 讅@d`r!P"R 2߅[S0!oY[Ày <V N+ $@ uI 1 @t4SY[t#Su	QY	!uff0Z [$Sx.fM^f:Pt@53 $<vUm  t}DJuY K Se}Ѧp
fVv ^7p 	
F  wMpjpD !
fF# f P	
 VDpDFDFDFDFDFF/' L@M`[!  
z[3@
NfP#",fWff;uf_W _UQRF  P`6f\8fL PPJtf8 fsbfs@~}O A@A~:F}cDR\LWS___ =W   FJa7F	~Ч0B
f^ ff@?F
 N0#ZNabQ\f{ \Rq}f  0rDRff;r AC`q`t ^z0 fiBf;}f+ f+q
P&P Uqyq	H
fٱ3;N	}A4@h:N~	hF }@F  t}@vӑ4Vfً^ZY] t+z  rz 
ﵤpB3ðnt[@+*;HnN F :يfFPat!BsS<~q_8-N^#S6 [F` amci灈!aQPS"8p[ ;rb8`[;rXu1;DHv{pVnࡡ0耸{)q ff=  s2Qt9Qt覊& G OtRu
t:du2YpT;Lu;T
u53Kc怘SN\?+[MdN\
1$CP[D [~UFVfRfSfQ$f < o   Rf36  \ < W  +X&^\#@ċп/Ż| % tE ~Ap t;|6 ` u&`<ufDf˳ @ p \A3<w
Б`4wXEff  tH3P	2BXV
@xB
 [EdOPٺ`PaPwf` Qt.3b .2pf1t	fX XffZf^f_]ûV/M0z? tPfYǿpf~IT"O3uC@Y	3Í]}`ʀu @<uoBBË2p
`Ъs`<t;$?<2#K¿r%; //R&#%Í\~33 t 	$ t]0O"Ouǿ  	 ul  
} 
	  
}     qqj#N 0
 X<b 8 Kb H1 1< RK@c EsAKH   PRPB XQRVWJ u
tѰfN i* ҃ѩ$`t;	A {Pox$(vyK ;Q_^ZY		  ҋ{<u2O2WNP4u2= NuJ33Â1@2 2ǂ
ˀ
<#t?3Epô@$
V\)	{^5do$N 1 !
t$@$0T @3!fRSu|Xu:f $3Ǿd2tf1ft
F%\{X^LXQfs.
,FuY @%@ 07p 	 r PpƊU@:Ht
;r23Lf^S#SfPQFffYf'$
4f}RRQ8YZCBE@SނA9ݰ@7&ݳ-gݳ覗 {[0
76u# nmu a#2[-o )/@u6A:Mu)o2u"&`%uQQpZY{u#0Ast
2u *u֒$noY`00:RQ{teP
xp2Ht`
uK^tu:0ṯc t*q@
Qt Ku@
X7u
a8c
u+2
14r P XC@@QfRWSSQ _O$$5۹ 6Y[@uouhuaPu\uT`aauCЋu< u0" Sx=uB|xۋǴP **S+ڀ,}7qX[_ YQ5W
B:@uuu	3_ PqupuFu?dA9诲u- u&7uuW(RW  ،Ў&w&L2  +Ⱦ&&M20&!G&!W2&GFp Fn^D2p+`Rr#F#VLu&	0	W_Z1
	f			
$ǐWs+
E/
MNF N5rO
O
B
 |O
!SVpҎq< ts<uX& uL&;Gu)k&G&?<	tV?WыD&)G&&@ 0w 3/^.R
(&G&G& 3&T (.	2$r	vLt_suo&4 u!)&Gu&g&W
 G&G42 &W.81#s
ޮ^Z:D!(7&4&_
&&\@,;;>;H;l  R;d;@/3(_|@s#%uG<&Df,@<w]2!
_.:wG&w@( 
	G"$&Gi3a>a$_!V
>|&WA>><% 12_$ G 1/>tዠ""Ep0@J#2.J#;vA#2"3b&$GO$`+}bw!
2
.T2#0 AP"p=f=z======SQ< {u";@ss{_P&Dx!\udow_$<^R^WHP_"@%O3F 3EE-_PB"
n0c$>^_9&U>&F>s&W̻%D%`w"T=?GG+m(ͥ".0QWH	aGCKCA!YqU#G+BoPo&_+ bbdPl&!Oj R*STgT9lrq_SPQOZPwPO*33Y_?30
+ kt[,: cސMW
Fp^-'RXWT<\01sds0	BdppWjЌЌ
[	.,!G fW
i/5
j" W*2??J4		`	!	Y!e7  W   u#-
o c)7$p'QR

[#Rp4	0	`z0U""D
뢨	)'D
UQR&\,2Wq3D T+{\-A12D TP00\@NL@ TbW//(.{%׎\0L1Qs@8q;Gu
&;Wu[0Z1ruWs3
  0Z2OG((,(CU;ƃYwF8FfV~FFCoC^&#G#ѣ:<P!1?ю<s&OB^ҲT$6ZBpA!O0Ofq]0&Wt k`eFg-k/E#EE+CcnAd\Wb-"s	/K//~<ZZt[<cu63`~f;W
upu#&G0g9Tu"  s}2건"`g/@݈G45t0 q$	.2(qx7GXʜ0b"f5/2JD&W14T2z ~`@W._&P2PG(`Q [|,t?&:G0uş޷&= ω7w_F_40200,u 0?8 ĆSP* ZT ,׀-+*_~ƋtH0؋t pQP΀Q8؉F`ۉFFߋ f؃? V~fF F  fF  F  F~ V.^2tz&EМX	2&E t3P	tAaQ^&b !E0vu1^w 
P		F2 f  _?f  r} ^f[uPc
^^t3^&)qFϊ2 ߬Z@~ t2/f_ ]P?212ɰ@r:W#CcBF! ABċfZ
fPRWW27{H<$+uSSg2&0˃ߡg  SB_d_ ؇fSk2+_`FòV\"9e00</	q@UX3}
%/E%
:룀Rи 怋:))Z]]˸MøNIð5ð2ðQ Q  (@22ð2~AðQ "$!&pS4[ð0P<}Hp] fPfQfRfSfUfVfW< u < ſ <@ <u^ <   <V <uNQ <PP~
T <phP <	uM	w<
u
~ F_c<0@f@T<u
C1RC<2<uOxfV< 

	OA
Ff_f^f]f[fZfYfXP.أmnn XP0;;uF a] 5 \X01.00 VESA H  __	 `P  ? ߃f3fP" OGOOO "*ptL @O2  fPEYQW _Y EE@ E@ EE@ fE> ffE(aK5W QNMUEEYQ(Yc@
uQ%0.E} E!`"#Ep
EE  	+ 
t@E Xt^tw
pplE+-  ! " # #*0 O	E
t0$?$E w S`3[EE.EE6E E7E!E8E"E9E#E:EE2EE5E4wW4_u%PfXo2
 cOÁtQ
utOHt=~ 
v
&$ht B%Ͽ3Āu 1&33R&J&&ƯQ ` Pb Ib&L ݠ x& 
r2@ 	

  p FS 	 2J SS2u'zu&$<#u	<2 
<3 0
O øO Q5	Ytz tt:tJnW;&;QحtY t6 0 !TR th?A`A83ۭYt$t(t,t)t&t.P[f Ρ * Œ 24 뫾 - K芽fC@m"N!H%nC]	T	#	&	)		@	*{ح@	 Ё ' P 뼱	  O 0R	fT	F@m5/3`1
 R  uE; J?p@1>;0?HԺHκ$u1Ru
dˑ먀u( PQˊXP3 ;wXA* 
u#sSa-$ܺ[ _ [td= nt*ͻį@[uDPAu 褻WRSfP @̹ fX[ZÜO+y RZÀP0Qf{@ѻA $Ȁff	PfD  ʺf% f% fXf{$Ѻfe ff4a@ ffV t  ikB4 `mU FF_ܰfб		f`C	f!Hߺȋ?ȇX>ffq 2҇  tf@ r
o I@ A0+t
tMO!;у$@<00;g
  
u ]fA@:!,:MSEQm^ g& D
L.!W`,Ct?ʲD
@& G OC ;Lu;T
u? ' AQ `1}jű
t  ڸ % a~A踨tkN D mrE Fu߸t%2Hy`  eIzQ0
=T<_
yB0
u$2
30
 sUy L	 tqo@ j|Q0 E< qQQ>[ Wff& ]_ 3uM`x'p߻8p	<2S[q{&EL稿
ɱ   ب(Pu12 ~ 8P
PCp6tPawu:p
 9 x: 	ǃfZh u	f  ʲau6D 0ћ» $ 1 u	2$u@`^ uQY^Suh ̹#u(̹x'u̹2u	̹8p
0̹6f[fSٹ 3f[ft[` rBï`PX.甂]>ü]t^arvPӛ:՝7`p]~' fݿ&P;uXú체0&GP uI	 AASH
[u&.+X&cǰ 
pPVXTtB/U 5 KD
E谶44ËF _/ (` S.
` 02&'C[2S`P`^	Ë#гuߺEt&F~PSжo2ĀbCPB4t	 F5[
72
ûf
} 3<Jau $<~$<t <t<t@ð@  &uPÁ@ÿ__˕  @
@@ b #@23tb
-tq`q-tq$SIG2.J`e&f[,0(0-0)0*0.0?)0.8%u.]3O;u2B+߀uC>t<I @.{>A3u0<~`g73 3/`50u骯  ˀ 2u,pQ1q2$ 2j5uK<u@ #@ 
 uz1'` 0'0PW P!Ea9 	0u
u$0<0u  &o6<umA	ut	
t0
߈ )<u+V1u
t!Q:À3uހ4u<p_Gu 
Cp6u& <t	  먜`B"
ós JI1%^N   (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

?			   


6   r 
*   S**Q p   ?  ??Q r  `p   $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h     1   h1 h1 
P,h     1 ?  h
1 
h
1 
h( 	 c-'(+ Ѹ Q71;p9 =c P __OPU
(	@ C  7 c0	@ T(  \PW  d
0( MM](
c P1 pJ1  S
   
> @C_P 0VU  %@߄   bk  O
 B89:;<=>?
$ӄ*
G$WBk+_B,p/1  4 	 B 
  4      
|%( (,%*26', 49$,0	
!&.3+0$8= ((,$(c $0  ,
(d 0HH0  (	H 8H 
8X j PgX8	X0@T`nMgT<	Tf(XHHH(F H* 4
$$ < PXAX@	dPApPf?n d+e
 ~288׼x$w&π cÃf;uA  : ՔF   P  _QS  ,ߵtSȀ>cu/o@ 3ۜ.B.EQ Jߝ &G+t1 buj<8t<?tj~.BI%P.P*@Q` c pcg Y @ 3W 	Q( 0Y[RRPF Q.o  boÜ
@GȠT QPդ~~|ֺ| o|8p8| 8  }l  <~<RÁf ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8xh~@`[} !\0pp0kl$ff$n8|||
<<a lllll  l ~|0a0` 8l8vv`b >P``0 @ 0/`   caa88 || x" f<| <l |ƀ j|  ~1B qlP
a0AP 
  ~
 ff|ff f< ll  b`|`` 
r < p ƻ `b% ΉƁ|N|c~Zl) lly#< 8 P
| %|| -'N0x|O~ `   `̀ 6000q(vU |Ђ8 x`flxld  	lܢ-u| p%| '| 06p'( x*2
v 0d 6l1  8 v5plp;؀5 |2ƅ88
l8|'!5f|ƃP/&&00 %:l~n ~ހ1 -7 0
	A'!r~`l`fl fEK>c8c>0>a<4:   ,+> >`gcc=  G0`2#`?#: ̿0|6> l<~61F  6ll6` l  "# U# ݑw# d  6 P P 05 `ROpqP4J%UQ2d770?2?0 a!66R9 2̃a	D
 R>     f 9x̊eb]Pf```p_d~̴Mi|v܀=8 Sl8T(r(l`"8fnj~C|q^/ 8`T`/Paa! b~ Y f`[ ps xma0<<S2tflD8p&mp0t| 7qҁ၁PQ	lEcFlp xpq5 aq3Ԇ@ч >6`vf ~~`>~~>ՂR2$ P {p4`||s4S
 UtE9 _2`!@AHiP!32pxF)bfwNP0v~m i {16879
G -3a5әAPp|@ ѓ`;Ҝ2#a=Ғ~BC  ҥ R*ҤљނtPa7`p0iQ.f`d|d``
`ζLӥ 񦴝Rpƀb q
 jxp  S		
qQF#a`(L%4 bLZ ~EP࠵ 4-e0(a6P6r hlq   a 	P S$jǷb[ 6 qb
P$= bX
v O5. 'Ma 0
AΒ|о cǃ~A U t"{ ځY
0x"p	#	$@%#Qb 
#p
  
%	"Ђ#D@a6f0Prʀ
$  	% 		C 	JCdw@`1|?cc0cФ 	?!	8 ld >BPP<@ WW~d! 3`p}3 B< ;8>dp` A~0]Zwl^l Q6>6n6@s&tўD+ f  5ڿZ Ed 

Z Ӥc gc b
d
 d5e5e k
c 
eqe eu%

 
9Ը= 3;1N Q1b0i2S"$|ҏ05Yap``<f	`qe|  0^0v 3 ј/AX`ix x%8#?A~ SY/ c(ҡ P2M  "TpYV!" tWrX"f<K<fDY3\qmypf2hwf
x$0 Iwq  [  ts | >>8]
Ë3Ҏ&&
&PUSSUSտSSQRPtFW2@ _T&&M.W@
&FG_&E"&E#W_&]%&}&It2.,2
t@' -) = ~=^~=~=~ &U*&$
$

0B$
Ļ	-0
12;t4&wt  pu`2Ԋ%+Fàt6@ X2   t` :t0?FË PuB/%C ܊J 2  &GF %G @GÜQW+& &D&߉TAα !	ʑ  p&
&TA2 [PD_ 	 I!_Y`y GQW(l6(5p G65r ts M| :&?Q }0
G@6D	ĸ 

 ﱿ2
P2	2YQ4;wG4w~wvn"f2^Y /4 /9EPJJ  B2B0 XJw|	 VBBF^ú$
Ĳ@`  t Q%P䀀p;;$<~&G3u<#t<2t<3tP	u&IRtAcNb  P3&2J&ߊGq IGLq ģ`XR23Ұ
)u 
ͿZ`N.  un> tgp baLP>bP22AQJ2=QRP*
u 32ZYYw2 XaZYYR*8}2.Zà؋!+m 2Ku(W S
u
P]`[+сÊ2+**&R9  @/ZHuÊU
J@B J"bt1 P#Ԩ`X3d>I#t(q 2t! 3tQtt1pd ; Q@ !
+ .J
u8~` z@sC<0t :Jt. ` S _+!*2+uX ʻ u*tX Ë`u"t0 ]׊4"
ވÊ$"ð(cр  !$%D
m݁  +

,QVW++    e_^Q"YԊ_Ǌ_ S8v2QY2P  t (P
_RS߂7P2 PL[[ZRРJ2Z.  03<?& t
uV EÁ,ņ!&J aZ5	 [a2RqZ¾7L0 }
+ȴ@A
t
2&LoP zW >&}SjcظU`T<t
K<Ut2[ðo
 6]C%ŀA`A2+Q+++YZ0"Ȱ+Ջ+Nuâ` $` t  2tatBñ8~
td\8tX|0I~D*
u
8t8`t2
8~
~Ȁ}RtɊ*Ŵ
^!}NQTt
w_拄0['$jDtPi"t
wwyÀ|t#GZqKR2#Ze<RM5HU9Qpw@ @ AK+>+r,+Z 	脷"+R|T7t|S`ı@ (&Ѭám +㛋>u@F E&   P !V1GO+>2u	&}uƀtGVW_^t##ut>|  2ǋ 	1
qh|eZ`+0w!  pjr,`u
UQPЁ
6JX2D|BQ> CS O2PpoFfKu[3dT)!o(|=yTSUkujGPbsg 1KXPk$6| 62 &tiU؊PPu'U#ëNp &Np>Xr ì.1%   P I ãÀt&0@ "?   ì_&O 8r2pÊ02fQ fduh Z~ `   R!Pfff  ZJ PXWQP; spfGufXY_R
{Q+IY+ÿR3a賆t8tzGP	pHbQu　PUwP[1@.Xnf-VA8|8FumXPRJWQ2=_8v
VaGYY_zPP*[KZp_G+B;v
3a  sòθdctQ˰@euu&fP - f ktf$߀t } 
ء~SP
:t t&   &]Xu3Ĵ0sG`ĀuP(ft mw`$eLnѹYѼ% P~%%@ƑĢq>0JBbXXnIt~1t_Sm)5"2"٠K}1~`btՊ2PI<
vJfu3J⇊pzǪA8sYaPdPt u<
u:6u Ɖlu@L<u/<u
t22+qt땽++&eP>Ѓۋ󥋹п  2.#t 	O3ɊʟpyvF t򴉠=8PMu\q? |NV
I_u-7ԑ!Q̊..7t.;t$.
DY2^#+3*22<PRs;ZwXt<ty~ =u<s.jԞ	S! .FJt #x @<~tÆE;P&D0=&}# 2 0<뵀wCP0$&e߀ te P蟰 ?02Nxߋ2䯲0aJG`b`  ËQ&5&m&M  CYް2	=$ǑN0? u4 yàNR!v &5&Mú`q `9q4   ^뽜 \1Uu  pOHqVk 8qW`t*2S!p[û"pf
b  %Wp[PP;PY0 d2|PXR9 ZS[ SBB  s  PQIu0zXŋ$ ރ.2:OI<t 0p<wPSPRM@u@	l t@zP=s=s=|s^=Js  ZX][Xqp<t<tˊ߀~ PS#[pt@ 8 < @É.| ~ ÿȎ@2.-. 
*@ ֽ
p ʽx 5_
uw5wP|&P u͎...ULF
Fx
p
t
xxSۜ&G&g3t"<}訽A
<}	q-<t
<t̀
&G2 _ [àþ @֋P$ "3ҹ <u`Ȱ  3 23|utﻲ̰
PpuÀu
&~̀zҧ@Sb[t (22QŐF t  +YsuQPW>&}t0&<t$G Ȣ&3E+P!_X@3t_tG80hu&2.ѫ!tR$
J	 ȋۀ>/u@ztѿHҊ& L2ܾt

xt<tc F0UJ>=&]&M&U&E
P0>X}21PSQR. t	00迧ZY[XpD|S1P~`5[VQS&0<
@<
t20,b@@Z@' t&^{ Eq	Dsr AsБ+Pu  }	rt2@SU% ][ X[YZ:p0.d~Ӷ B
 cF<u	A d.:r2@.] IÆà$0<0tu` tq
2.;tq a8~û i tPpt!([t0Pt#  P 2       ?     @      0 @  AV6tt#L6f3۲#t	ufFFfËȀPj%;Xh^2yUi?'Mi j$?u*cPN pz5iPyzV hû`j\njP1&i Ph(h |Fj0&qhXзhıh2fQ  j#'f ug 3cicf   if߾ir |iu$g ;
 iXh i$h:  g `   j p 
  & > 3iP g+uf UúkQ@gAi$>A<vIh hEf+EhhouQ Qh4+E	aaЗuP+
F@B`"6gfA$%%&f`bc
RV+u wXwy+Yt  
Gh<u ''huu$utVv^ *_:t6Ӌ_ڋ?t&: Gڋp:Du<pO/+0.Z@WV2ɐs /s0  u@PqgXu!+3tPQg
	ڵ1
0
b	Б7;u n^~! Wx`	^fQfRUzq~a f@ ff3f0(  f F F߶d RF ;p {2?b@f@ dmAp~*ff0fTf@;ff+	^ v,1~ }`F='}FQ͊Ŀ]fZfY6J:f6doJ/ dp <4  P!<@U_WÐPfR QR .ff2ffZ0OfRSWP ouDT,Q@ɰ@@u-f fQf@Rk<B C8ACCfX2fPX_[fZÐRQ]Ef@Z@=$!a  0`\R H%@af% ij`IH> A4a	fa   $ff aA	4a
^
4ih $Q_e>"mq#5YZ#fQWVSRPeulfS3d, lf[fIfc fACnd膢d@܀r @E
uEb qjZ[^_QSPǀt1N0`-Ps@y$R^f`!'	"X[fRf׋fPX Lu" ~$ )L" K# mLZ" G^$ LK! $ >" $ 9::p;;;<<<=>5>;y& _>?1k||C  H   0 A 1717MM-M98277]817Q? W?@   } A @ U   @_KB @    @D @ D  @W>C @   u @UUU 	U 	 	 	 	 	lG  G@   FW    @
U @
 @
 @
e߯H 3H]     k5I E E@    U@-@Urrr@r@r@r@H A @ @@    E -%N3N9N6@ >NBNC`  HNMNRNWN\NaN|NNNN/NfN+NkNuNpN P.f&0ɤɸB6˿αx
ָRL\  b:n|  "  Z*AV  0:d:  `ndκζD	N| ķзNtx  @   @  0  g"\\F   < P D5F@@ ^~ NUU  ` 
o&	0$   <( 

HH( K
8 
UH 
 
	
U  @ tXY ܒ5j<  8H q 
8} Xx  } 
H0P VK @@ w
U@  &  d	U<  1  w 	U+0L
F  `    [
K` 0 ($
U@ `a 0*	$K `p < @ :
Uj 0 *
<4
K0=
 x 
+	,<p  [ H?	2+D
A
SF
O	Y
U	  r`A O	8< `o e
K	@ pq AU	<< 
@ p
K(
   h[	@<P t
KY	 @Su  `C B ܔdM bz_ Pc @d F  >
@  ! _K @@E!`Q0`a ~/    p4 Kχ  h<( `dt@t@o k
P
	M0t:
N
$  r@FE
6  pRG  Z(\Э
  r m 2    _ 5- ef gh i    [   X 1bXyg @ 	y yy 		



g g g g 4^jU	 # 20 3
jj
jUU
U


 @ 


 	
3456
STUV
c Ud e f !
" 
#	$ 	DEF
stuv
    
@+
ԠZn  H
 ?-  @5	{ r P (      =E > K8-@X<a5 $ATI5!w1HS s 4l4 d2 "e`hÑZR_ =~6"LNB l03 3 @A i}~}t  
 1z  0H 
 #  c7`L`p 耱2XPKP   @ B" D$HD$I$RJRKJTU UUjj0 mkZ۶m[mmn {{{} 1  
: }  	 TR0	,C	p  	B hx2_ 1 
 	q '`  &ѓ0'&%$#"!  šK`r  J  })7 f` zP@Jpfeb@jW `" bȇbG0Bir̀
ÂGi)ݿDچ\ܿ
TT́zii,ԁGH߃cȀDоTˋǀ8g I־ѿQЉ)`>*㿬\و
⿲;׿p
Vjd̿څρɇHȀs BBrH鎲Y߿"Q=(ھt57ӅAG[^KQ>@CRT7uu7T҂%0G []][	f!,'пξ)<3H;!i)i@2zoH^ <cbbc<C!??)a KݾduTu*G
%~R;ž6 /IwB[kkBq >MԀۿśm4 SſQ%þs؀bzoP.Hކ!߯ڿ 	J߽&ɿڀڀɒ-珙4+]O̿2m*{JYeB`  YW	a%@#@mRR4RRGR
` Rs7pR  31B L DE a3s-
@fCd@   -g>j E7Pw  
M>
B  D $L%  
p \%eR7%9 i%9}P /5%@
R
`
f	-
B YA`

A D 
[k 8i=%  :pAMAK3A_A
 A N!L# A[@ dp7 İp 
@݅ T~T      1@Ű ?~  "0 \1 rY ; O@%&
e 
e QЊV .
 0C% *
20~ 
P 
  ނ 
ef h  eg T 
T T TP T @Uߕ%%
%DT A T 6

 P 
%epv( ݀`! 
TpT 1}0T #
%f 
%h %g 
%7`s% P%-%0@ : ;e: `%0
0\!P h !-%6T6[z /f~0.X fd.ހ* >$PD4  3`>>e  I V0 b  3% 
% "A2 -Sb % -e R   	% 20@
`?	*C p:푑/<  H 2T2 B - 3cTe. 08P40 041 #5 BBT ATA:`.z6< A @s   73f3p  3
qp:  `T  C
0H(2
SRh

P
;
p8@
 
1
s  \ 
,3H
$r 
h
P
 
	- iuxtPY	
B
8	3Ds f@@ = A?Q A C >L@Q B D \NOѪ1ijQ k 0qrQ at y zQ { | A AcDcfv`f` l[s  <p6r ^5  `/ \e5 @pj@/@Qڰ b/  e@2@4 5@ @	e@
5A//A[ bg[Ig% [  A%R<^9A8A-@ >A
< $I6  [%sm
lQVA1A
A
  
AmQ2LADyST PR0NR[. %A3 	>%A D0 J% D1 Q
K DX \
 7kCl
= 
`_ "
% DQ@``\RQ QI  5
 QT ` R/R;R=V C RR 
I RR@RH[ ΐP D=I KIO < <1  PMqS>9 D   1R#@ST 0u0p"pU|
Q`qoT(PP0AP;A0 0I@`=@I T0 CT0!q bJ%`g< 
` 1 `
gTfa aud
*aaaaJa`bdgx `b q! wD:/#Q2[e @	%@%@"C@b@D5 @`%@*@@0 @e
4
 
 `  " 

 

 

  

 J`  n  `o P' J
( 
& 
Q ] \r`1 r3  %`
 \ ~e+cLPe
 3p Qr q 0%
 [N\ \` P%0 PJ%k @=


!9p[p %< \%\ <pQ\е` PI< J`OCA;  IP@K`C}U< [X // WA 	A>_A I;pWQ2YDX
@'A
` [6vYP"\3\ \  ce]	
@2	f01 ^1QVp/ XPtdR 9@%ARI`n
x 34Њ$r A0H4F`rC5'C0 @JA Pq J I3__D5` SD)`as  DU s  S50C`ʀRh\7 x1!
/ b
sq \
 pG\
 e0: 4$a &?1A2dFB;,34%"p "4*
 ??????f*	/EiivpE\% P/_ pP1
`s2aఖ1)IfxhM. S8_R S Qa s p4&2q 
5SD6pbF!2I2DWvPyMW0Dd8s   BMzO??3iAjkl1qArP yAzU{|1ѿ}! [:f5=I/Q  
  "
C9p fQ [Ba[}V@={   D+q : K
0I7 e@@  P 
 J% Ik T 
T0j@T` %PAT PT @Qd 	 _
2
P :  2 : QI
 >PD(ceQ C 
LD_e  z <b
j CF" *Э>eIf	-
B d~- >e pe 
eЕf
  zr@= >׳\ C[v
%    = Bp T 
忥T%C  1T0
`KK@k`|@T0<% D~-Dq 0% b "	
T  
Q
 Qp"pep T(1[ 0ഀ.  ߍ.D% D/ D30  %

%

% )߿DU  JqDb o~  
A@įAG 0	H 3
A Ft>C/À D/ɼ
 
H֐1
  E C_ T
@
!

p
b  AXPC+{?I* 5@[ C0! DMfd19@8

oA7QA7  T 	?T Chp
U
P7%9T  [ V AqCD) e C CfؕT(qJd	 Ccb J2D @0J	 釂Iz_ eAA@AK0T 42 @!AC e
zL[!` [[GF)=  J尾D2 : &T $@ %J!7@YDb6AYs D [DCA  	У p
!Ղw 0:e!׈ c0<UW 	 ~f
	>P o	 @Pp
*Z8}PS }N @OsO bs G@  
 
 P}T>@UߩU L !w pW :  N K !!WT @   UxE{a[Sp|0
TUUV  `3 ,W塙 b9b@<qT !B  %>X%? 
=Gx $'c	!'k*' "'Laq 'pP/('n&'D"'}"'# -!'' Rv!'݄lُ.#'q'y*	!' 41!'>l"'9	
!'V!'- 5"'n"'-ݤ,Ip''$'."#/	 "'>N"'/U  m /' '<}$"' 'T  "& WT $ %`$p/&/&/&%&R"&x "&8]#&?ET @%`%`)%%g%>l%/H-a%p `%ba%L
 
L  L$JL(L
,LL L%PyL-Lۓ + % O L(RL( LLLuLuL ,q 
#L%L%LPtpLP2S0%ж%gx%%*%KKT  @ @ĀŢ #H@#;P? HH
J v[T5DDU6%%%U  DUA %^R@ !Equ%4C !	Q (	°6
a6cp ?T(6[/Tr7s[S J%  P$@( L%@ u

` AuD @DqDpC DD0rB\qc&
"(¾ƾ//"# /& } g=e갓eFq DV Ddo%ge0sT v\@%e9eQ k%i9Q el lepAp~ %ueP |
ewf
ABT ^B @  -
@A
B@R>t``0_@_ C ^ z Z.XAA -AA-m  BԘ z^ki/[ sb;f0 ;V V 	
    &T0;`J% D}h 0'Ih P>  FS i! ;BR˂"!E31N ( e #D1` bC0T[8 A[! U U 0 IU8I k 	% >:D p`nq CQ<U

V 9
 A@
- 1PǱ @@A'@  >A G -@1
 @[3  \ ? J%
0w   pۊİb ưp0Pf  @CDPWD@ [FKFp`0g a+H!%A`9BT @?`TKTLM
N TI@JAҳ
yH IS@>%A D V ACp
 	x3`6 DCRIL% DQR#T "` T pڑ  ܴ![%*0!eTk `^aqjSQ0#0 #0Iv0SP%%``T5 [p 

ưCX`@
< Dm@RISD`PQ "S!qP( jPj0y
`eCh`pdT ! W 
%'?&IJ 
 D_CJ
 
Aps?PR:Q3
A?A?xs@w Fà h@`P7@\
m`A\(u@xJp Dd "\@j`UX0P'1'2'3
 
4 
5Q 6hmI`18 Cm [Gdj9bb)cP Q 	  1
 0
 יBV .	@U *3  --!`
! `AC"PP	1
u

	 N
"""VQAQb c[B) c 6 cC cP c@ b co c| c@  	o Z_Z!	UL  ?`^%1%@e! aa[ 6£T   
G  VPlqNqN sNJ% D?0jA` IX t? 	ACb  & 	ڐ@` e@-@=% ࣑ Q0QMaOMN
NPOHA
A@'AQN0GN.Бa @[`\T0Q@ 0sT : U:oe;`;08@V8]  Q0e@S3 'Q-[m!U?=D-@
"|pQ	8%@ B_9c``T c
c%QZT C? f- Cd3"ea ; !v ढ m9? ? M1  p0DfaDհ bbP0@}BdD  D  q  t lCl C*  T0	8E	XC2`@  QGK0 Q :P[ a 
  -a]~I
* 9- }!,0 pq-A-* AV(u Ѐ[ i( "` p1J@fD] P%
e
ថ
3j
`PP ROP zPAP-RPPT b11WW UREVQ P@WUO_QQQ .9c0^P >R` H<:\% @ 
JI1#  {[7%Ч@>8 `6 eCu6A[ N FPIPT @ q rZ p s0|!j 81!9 ^q -:  R%<%EٱQRpVM @@@JAN_ @%`|%|T
@ WU -e%LM\M
eNqN
O`GOPo01@HQ`* %R8=e b0L
N;`Q`Q   ,",C,2 :0*@,͍PU(0bB:c cUcs73S7&p p P`>`I6 2pm`e-'%!ePOC%qeNA%@!+[ YBsb,`GDDQb:+CQ$ '@ 0W1&! qU9ЀPЀQP1p=I0)C $h0@Qd *PAn3$3m`#IR(  % !!g 233rQ
JI`LCg25PX"Q2e$ 
II$ eA&DrI^L[T $ `2 `z323'*% _222R2AA 22	&8; 6bU.CP>)=&1P% aPV  IgI"Cp,T0J@8v~@@
 0:D2ְ22=pD,} *
 ` ! [eQ[[ pxU  [*R7`A7 \7 P7 AW8 88 Ac["}& !-C1 BsF  d CM }'@
@U 3@A/@- !2!Pbdq=H`@'1@b"I 1A. 	A>AE PPJI1; C .r`45	
 g
@ p 
! r	%Y D sBZ @g`@'J3".@[F@@	
@!@>
@& H3 A0E, %@CEq p RA %Pp [وc%AA D=  > ?@ABCD\i \jb k l"qrsBt[r1 ׀<% ڿD  <!@+ C(   : P A-A`ڐ K@\DWq C`T 2AQ*r 3%=AsA I`a-=0`IؙyA  AAC_ %AApN 
1	[Ж)A -AC-A[%9T [! [ H@A;  s2P ;"  KD     p{A @ { ځ%%P OCjpOPPPf@ % &[wff 
h} g B!U0:?5Cv fCA fQ  >
uBSvD ~J  $	~ -?
B@R7[        b     G71_UK7400LwVIDEO 
    '  IBM VGA CompatibleJ06?/28/063   <0 0/" QȶPMIDl o    3*ʛ ?  j! Z HWEAPCIR   `	  G71M HP Mobile BIOS

  < Version  5.71.22.24`  PCopyright (C) 1996-2006 N Irp.߭߱߯ߪόp Board - hpg71m  	Chip Rev BIT  F2 <B @C YD gI kL yt {M
 NrP S T@U V ci% s  )$"q" {  UU!\0^l____``_dήʹͺ2JJ`_'/  &J  B P7(00##^ 6)2	pP,p_04/13* +1 I@$C			.
\
(~/@ PZba`oZe ! n q t vx w6 Q

f`_.	  ufaf`3 fa.CC . uȊ8t2
tQPfVfD  QPQ.XQf^XYf.7fQf.# .q u裙QIQ.C	_QfW+SK^[V&Sf<f3fo$pUofg`f 
Pwf fq`BP!."C.
Cf.CB."''fDQ
k22t

t3OYg. a YQL  @"迡tNP.Csf7fQ$
61
֏3RжeORp
 OS..[QUPRf4"^ r$ROfZX+]f'_(&.O3L^fV?OfPf3~(Oe NfXf^NfP@b	OfNp_t[P*7  b SoƢ_ -LP-î_02 3GN[YSkρ_4N:4G4;GP;"QSk	`.)D."d.L.\ؠ*."D.:D&b* R蹵<!lP,X- 1>rS=ft	M[`*&ol"ұ!RJ<`ZRZ[ ##BӋRQ#YZ<Y<t?ñ<IBS[UQ C3KPQcYq cfdY Kp>XdYs٠7CdtcX0KY]APcMfs[R8JGdc"QRSe[.W"
YNfYpbXp].w0Yu
SJa*[ðoh @ ( @ + r#VJ8^ ufߋfƁ	]	if\+9fHKYK."G.
G(Kf;Kz
faQr]Z`=GqzQnVCCPHPV17PRX_NuXwKV>h~dK>YV
tm"
3XU
^.
ô2.0.F FE ?B RAM

  XH t`..F
u74  t:

.ZsKM= r
G.^M0.f % uj.JÜP)$)2)F)000099999::::::::#:XÜ@ B P.: ߣ| .0~ Xe
 m)R`	$ o U u"&60  /*@ & u$AbfZ9r
t3PR%
ĲZX<u	~`X @cp`` r ( HfHf  $H@dfSfQ3W3=_iu3Ұ it6}}s2"_fYf[1wCfTHfJHf^trN<uf3f1	
<ufhAh f4HQ2tQf= s	f
 oGrSfV@]Gf%FGfp0PAGfh_ufנ$G

f,h PG%G
G
GFfF	F
  `
FFfPF%0|F$FFF{tPFf["	=#	fX t Gf [f?1@A0%0^W@"t< t.z ؠI	? E@܀uVF 
FFwFF F^F[_ @q.
w'ViֆIFdZRPߺ<0XZuBH X  t
~	=OtPZPUF]X OuO =Ou
uw~
ÃPQRFF7F BFW8JB"
JF8 BB@ZYXwLC uJ5JJF FыF
F
uPX@
	p
L CQ .=f܆ i,yy>y&Ciwji[C6D9gHf' z; RaI  VOfs.z P^8øO@  <w9tic6ttt!X߄t<ut	u߸Q*NN;t
` 
I2YхuXSQRWl)ȫI 󤠄@ 5ë.. r ? I@ h x + 
 +_ZY[ r&O
 uHr&G	+Ҁ>It)+= t
B=^tB=tB`%%
Ętc2e%
Ŀ
4s*t@&_t@
DHߌ;   uك.+ <wtwSRW t&?@PԠf@ X@t&t}2 @PLܐVWB0f^P SXĀfXu@_EX}02=_Z[SRP.@Xޓ7v _u@ՐGw#_w>Q.gDP5A 82*@X?AQU@R쪰$@J&q Ĵ ZR=P X ι	A]ūΰ迯P հ"ĪǿX]YVD=@u5 I ĸ.|@\pC﬈u^Mƿ 
¬A&d p ~R"hZVʰDѿDu!ъEĊΊE_^`Qє0`99   P tQ |ޡ W]"&
0F`UP=U_fS\BtHتB*BB `J?tJxАFFpB[JGÊĲ ~C/@q 50nZ
Z Z" RPgWXP XZ0}=PXR=]1oAA>BXPWXXDU6J    BJ`aSwr&otq :Wad c``a`C3BBaPa0 Xaf+lnl ;r;vaPQ ++uP tYUXqvtquq_u 01aItu tUEPSu2;P22P;Xthsnٝ! ǴuX;[ 	`" P(A"p#9u
a! #㬆āu CPQ ۲Ԡ `PSPRK;《ZX
߀М<s<u vp [&?t
&8t+XQSRVQsG	e. 
..dBn^Z[YP.z`	gtX0PR:Pߺ: Xۆ:PSqz%&_
Ju@   &WfPL<c&.Lftf	@E.U_ Pr W>-_Gf.;5A_S:fk;
u
P ᪶@o;f^9Psfxnv;=9ђ|o]X9QW2&%G
yK 5%r!5t55qS@CA}@ 2[/RP@.&5 B XJ QY+Q@8+}+w{Y)Q
 RP9 p1T#w9Gc#P#@h
@߱r,u'fPCI u$t    u.0Ntfa ffsafP΂XfVЁtB{w ^ABFFd&GGR&lGR R'8YV7t
h< ub^VP7Xߜ7HЪ 7e*裩prbo7' eW<^4T$rsR
.


$ض6f`01ff +ffPf3f<% ;|A3f`p8fs2R`y'`tZP2JsހPp	N HPRW66!S6cXÍ6J.dA@	u.8S@#6P X6<Piֳ ;t"m2]۳5Pk5
[@
kGf aڀ
rA CPfpD0ΰQ2y]
u+YÁ ! ބ   PS 3f.fZfcPth 
t  fAh1"5
M  	0)	(Q"Fcunsi4P2pD9l(Pfp\XPN`0$p0-osr2հ;"
5T4 Ü`HhwiQ34P Дʕ1	 %@v@8_2Xic IiB H;EX3Da13PP&~2#wSWQ#t	.EP|Y_[PRPrJg	=?gU O]0@3PR!g{
ff
cU2	)ݑ K`*g0(h
q
2iV`f	9u "Pȸ j# f~wtZ Q
tu&6pz1] t+{"u7  X^YVfWf30Of$f_^ SQ<s.O"$ s ۠1P <u@>!
(t3 " <tP]!&˲!t X1VS t `^r^!=P2%uvsRKG 80aP v8rX
CuwgKDwATO^BsfP
V<"s' UUH< V_^P u
 u?0 ;u u$̬ԀVVPS0иG$P($
 ~$[X	q/$ t`fV/
us27fQB1"
1f@s21 1?f^YV2<t[ Zڻ^Xu 	.\
 c[R	if%0f`z
ff_fZ Qj FSLP#tIpMt>S/fV;u#R"t"ҳ.?"uǋ&SWTs.{]
`Bz@wP9s=5 a[.Df A@f^.;sp._QSPWs"pRfXSuu؁ *"8'fHh fh/<"PSRO P$P<P[uL-@'8t{fRSQoVx\ L}+ :u!ЄW<f @f}.f_S왇[ gv|x j    ff< pfff|`` q yr ~ I  xu 2$ff$ӌ0  <fÐPM   1T  Oۙ "V  f<QW/ffaX!qY2!DZPÆ0`ÀE  m! Җhwq
Q Ѯn;~ ~+~
  w Pbfo ̐	Λ { fΖ>P  P> g_OPT O
ᶜ(Pj89:;<=>? "  ҳ" E.) H 0 B     Q 	?}tP  S> @(/ @ӯ7'  h&  @ DaH,L<fPUn T]aP$MTe]aa]5 
  p@ U   cDhAx|bo ~Ƣ	&(   aa.

, 
	 g{*ďz!
ǭ	j 7G P&/C&K 
@ 

}F 
A6-''* ` 51 4-'(*3`@939>  = 8d]cq) %4 Q=U%Q 	?5@$?
_OOSV@O3P=9[2 	ccjrYWWsM ( 2k8 $%I  28 ϟ()DT28 :!;a=> 鳳H HaǇ	ﯯ  /љ 1?``@ ?c4 5	 ?@ (1  ( "@ (A#!({DP]PȒ 1(^P`!C 1PUA E Xd$Q /a  ?q  2#qxJ!8$q@JA%qK&q~  `"061*+ 	4%0#]&ED`mb\]I'O'|} rWo  spP& p&!!%"% (%%)&# :7  ;8ήA  )#   A  ސ#Ak=`:  >;#C<=A@  NVIDIA+C Corporations!1F{{ P@0L	6d0*4V$b*
=
Y/Gh )z9tK  V(@ p
		p1 @z	c0 @

 0

   @ 
K
	 	 P
_ jP2 X0}0@ 1{1 2 2 > 4
 4wP 5
 5  [
 = =D @Q Z 
\ 	d]_
@W^ 	_	k
n o 	k

r  	aEEF FG
GZH H^zR_    *!,"
k3366>>? y/@0]Ԡ0  Ρ2  /h@ ! ! 6@@A  !@
		@@@
@@@@@*@/@0@1@2@Z@[				(B	%)	3 BCE	EF	FHB-	 PZ
 @!!	 	"@"@@!!A 0 @ 	p0
(88(	B B  
 00 00000000	0
000
00   0	   Ł   @0 @@@@@@@@@ 		@9@AUU	U	UVV	V	  B(%(-  Eq@BB `@a@b@c@d@e@f@g@h@i@j@k@l@m@n@o@p@qr@s@t@u@v@w@x@y@z@{@|@}@~@@@@@
4 W'+P440	   `p   fPfp fuff  Pf=KDASfXfVfPufufifXf^ur$JW{fQuaTf+PG@  $It 1f^fffX`r fff3rYf3fff_fSfPQf	u'pAf;tTRf3Y
[Íс Ȏ. 	+x	. . .Q &.E 3f.&E2߰؀
 .H u 0tFj0y] .>'<	v 'R VހĸZ 
t΋W200'f`ъ*U  +Ju]faSsS*.| .<[ !
tWa_[ E:q:::::;<;U; n;!~;";#;$;<0thPSQRW 9.8tFFOu._ZY[X|02 : @ 	b   &'@ I+  D Sw.į9&n [)Auu;u
:v +p
:S{[:A}!B[d`@e:|Nú!X:]s	O߮ 
9 	*	 '	=%	4'	) 	 Z	 趐( Ü.| ~  +. 
t*.z;kJ># OIO2O; H>@Hf 	(ۀ
@a `&JLËcڊ̰ڊ@
At tAË0"Pڀ́

oXa p}  SRk6Z[A2.z 6u0.;6'u)ˌ;u!V.6:298tXX^¹ 4f`$ru2$faf`PCj
t!Zj2rr苆rj HXP$XPᐰKo
 X P:X`ZPuxs$rr
DrOrjGfh f
al RZ5ow\um	P2
r	tr2۰SI؀
<~P  ,ǴuX莎D	hf%W<C	X,T% ߢI@	w
̈ 0Ϻt70`{t&Ԁ!u	+>&GNt"0t
u8A0 t-i  uQu
*	c<tB,(-)*.)W	 N+_Sb
w.u?ef?߀t 0[.G	e.3.DJp <  G@+.ģ`.G
;W!;R*Y Z>&}t5 
 +uu#&M&e&uߘ &]&U_JAA@ Q  B  I <
t<tV&_*	r ._@ 89:;<=>?` $(-28 (-2 $ /?'/7?-16:?  

 Pt*!  Xu. . Ñ%t	3úB.u?2b2À@r@ s#@    8 3u t.@HFA@r@0 t*t?2v	*v?Pv @.PP++ @F;rIu{G; N A;Ou@r͹ 2qs@ s*ۊC3  #uU8+Ҋ1v[Uu K*ۏÅ_uvRW//"s*@`p2Rp	BZP	3_ZÊ&I&8t<uHà$
Jr>b tCnCwCqC`twrf%
Ā
R 
ĢfdR rӜt a Ztf0.zC p ? aNDDDD" E$ECE #w E@+FDDFbFkFtFF<sQauP.CXR6tt*twuHƈ<p
$
 
@ϱ-sJ1Q_WӒbJ V}^p *RN00XҊ$?
0	Ժ7ҊrԱ	7b&g?
*Q`0!Jq50 a	QR=pD%0Y$g P{Ü1&@  #B3 ZY밑w;T_ _O
u$
}0u[0ǒ
BZ! R _<}ܰ軡 )@pr!QzCYaSذ;ذ+d wȊ._sPaN1'p2``\oB !2)aPRPStϾ ,

[WTXZX,
u8 8ϸw2πt
  wp$2.;Zv.Zf^ø@ `qO: +  @ r7 t~ !6 +R  >IvSр 
 v@ހًuBNu+aÐ.z *v/O*  ъǘ&ENu2 0r  RHR"IfSffVWQ rfQY>
Y_f^ff[ZfRfMff#f׀ ffP?3՞dfXr qfX{f2ÿ8]q]s
@u8tfuâB2Q
Gt 
0Yf[0f5mQM`Yp&'J

%S


[$P3f`(` 'Wt   u P
^0KJzKK&LSW.-G.? ?toSf3f3fJ`%  *fuSf< wQf.~aYWQSU4[.~ .IY_[@|_[Ê˿	.N`tut

t	ЭP
tt	t PɗXr!Pta	@
 uE	s.V0ͰD"
&Зs[μb [JI0 @O18>&5Q@.Ff` tt0uJ
- 
A
S!	>@Ds#P"ǫ
2B8s PSR3ۊ̀N)?0P7w7'ʐ^) ʀ軜ECɂW%&b ccVJhCd$WpSs]ӣ{P 4U^+IX`P`(s˰(;2ɀP&URXaqf`PX ﾅ4)GQ5)4w10,0!2muS60|/pvD6@ȀcX  ̀y
 ʰ?fa[qò_"e~JUP`:MPlurr
QfvYR \YX߱fe%s
 >u[s " <"fPPs謿
蓱 
Xd\PhTK#p#sVt胿;^
a@`m;npXCVots
2ΐI } @pVf`J ktrvts"&GP  S0.[  r s.< y&o Stp.|f.<xP2
Y5sB?h @;w>@#@f`( @u=۰0FG YHtƀuXXYfaPWR.z qu+At$ =،;t
u-y(Z_XPQRJȰ=Pિ Ű ƊĪ% ˴(Ű- /Ź 9AϰEuGxe
tL^S
u\r%
 	r
urr
S8 U+Z#Ź$ `XZY`P*$X& f& & 1y& &P  f01 2Saaae`"/$Q W S f_~0P]Ppİ=a JCŀ$?
 A B%zL@$@o()vB-/!hư3ĀE߰39aPAH"E}G:Po$L<u{SƳUƳZƳ`DƐeY\f`P Vf   <r1_pr,`Jf  Tab``bLOb f f#ff#fafn 
Fŋʳ8"p"`"p06hIhhI(h@ &h_h@ 7 U;  7@;hC   7fófQ@f~@.  f#fYf#f҇f^fZfYÜRS0D]P=aX[Zp@sI  RRPrXSP$X ܓU!!$A@Da!aRPZ
Z> Z"`WP8PP8 ffVSR|ef`JJXX_Vhh Vf^W   PSPwE) ;؜@@G XPZfX fSPf@Er"Ë8
P8XY RqRrfZ8fXQRfUPOfts`T8
QUnQUY33C[[Gu+t
͊3"tVsOCǝt8usutkG3b8upbOprFpjs3
 
t6f3PCt$@fG	r3 -ft;r} 2C 
GtC   z0Ɗt<tCa@@UJU3Pt<ΰsC:Cʃ
e
!s)
P	cKu<tYF8t
$Ik6St0a(b`
`c:İct;2t u t'tSO 	iSӰ ] `33ŊԀfft` uB%  0 vfÃ8u .Y__} f f`f%?f
   a > UVRSjYfVŷfpf^ 0Ũt q)ϡr I	}Y-[Z`W}YPAPRĐP⼀XtZ wp	ZX`*0f+.0

J V`P`fPfXOfZ^bpf}uf|QsSf1f1tf s P2   ct0z0 bV.Hf`f	D`\@   ˿f;fQP3f~ uu
ufYx1 lPYPxg|uL[XX 
pfY$Aq#vf;fߘu
'f; fߺ	@u:V FufF!% E^'fE.:Ev.EfJ?"ȑtf| ?P@% Qϑ 
@PfFϬCq	s
2 课0 18@}$@?<@q!gfaA:Sܔ"q
wu5@"~@/9[oPfq!K( Rٓ} !#`  d ,   K 2  # A pK k 1  2%!a10
6R @`  @  
	
o@PP0Q  QR
Iu]]] [=2<y   a x<O< >C <p<a z=<a =<ba ]><Ba ><"a '{;M<N<rI<?   CQ&}u uCc]V1O< @   00 ^^^^^ ___@!___0  vː 2=	   
[_qE_q`   F$ Gر K1Q  aqR_V_Z_((  + Nq@2Na*-CY  #7  ZJ`0R?`RqU ؄܈ B1SB 'C A1   <p0]@@ /! # E/e xD  9nQ̰\! ]b`>:ft Gr9&
+/ nAPC Ab!0glr9t( rq)L~`ofNBIW !K!PT@rAjpU` 蛂 oƠkh/1|$5|_2|	 p{p~P~~]~p uݠz XbAOWR`n0+  % ?bAbbb/bbq;RSQ<r
.aYp:f.a.d|r< ]Ugr 膹fL/fP4ifX$bi1	S n!fD<aa62Pf.a$r =aٺP.0tX .r	*\`\@0wf^V]fa}κfk
xfF'F
FFF zqfF 2~x!zFސzF {{Fp{F{FP|F|FFɐ}Fw2Fƀ~F~FʿFҊf FpFPyf3fqfpf.?E
fiNЈs2FUfpfVP+f2p f9Nvv^~Nfࠋ^ӈ^f^
:^]	F`  
]]FFÀ~  8Fۇ
_fF]ux蜰n^҈^׊^Q_PXq]n0@0d00Đf^f fF:F:F N uF2:F ;FpF^FJ,] F p23< <
WrPRFf9Fs
,,;^@f)$߃ t$=0avp؊FWF P<@ 	soeFFG`  f
#؊VA )fi) p{1ǁi@~f$ZPxi<t7<t
4
taXSQ\.MP ]\f.;5t Y[fSRد f5 ɀt03f S Y@0/ǰ8Zf`0q 9B [ PR._G  A_ _f`>ˎۋذ(t'^;vƷ䮡d`  fa g h0/h1Sh2fh3wh4h5h6hg.8tgr.Tû>ct*Ü h À 		<w.)h&o&P <w2t
4!W&Qe`p`+؊b*P>b+o# B:Jr
 
 *:6vZaPR+`+ii=i" 
j'jDj`PSI迯&w[Xr 	 s	0ria. +s  P >Iu$À˞u&"
ê&0!Ce?jǘ&L| J
u0 Y ̰Ɗ*Āu*&θ | @p
cǪ &w_Ѱ	Xjjj" Lkek7kQR4\?0Pej
ZYWS+. u00A$[ A[S#j #!' o| P *", 
ݿ aÊ[uPXs R=/r3PI 䪋؀תXZRQVP蝥.D< u
XP.貪<uyt	XP X^YqpBq 2o	pI
Ѓh_1O] E0@0t
  ) L  葮7 uaQ`"ES ku	aKu[XH B
 e Ð,"S<t
 rSR r ׭Z[S Q@oYp8?HiZǀu[`o&U蝭t;5QRPXr2r-S	[r$ rrrOrSD 0[ZY!  r0upE	0-ؾuWV2D3ɊLtFf
rO1rG Iu^VL/&Gwr*A"zNt耬}^V^_f`~VSR r?  DD0dTLZr@b$aAa`@aD r@u\s q [^`SPQhYX"
܊[ rbaWQQ&  S   [&YY_QSRPr<r7XZRPr,r'XP܀rrErSwc[`XZ[YWRQSPr#r[S}rr[So іr X[YZ_%PbXwPr)wr$Q%C[rirS	5 
[?rS$$ &= t&=H2&Et  `NUV2ұ&PȲ<X=u@r %ёu`Ttt
u"W-Rf3&E&ef(S	Hf 
f8
 # èuf$00P,X(}Sf3۳(+f+k[		0	0v3	O
f4
UAqU( c
#fp
$C
$ RPX=uğArzf3of%
 ^j<u
sX
 PXf B^V豰<u<኏f+`#t ^]LUGΫ$ 6W@*t'.H u}6.ts K_ _&E# W f譐_~$ =u  r*>F# ~ r1 l  r)	
@;}VU`]_
(W	U ]_G/f~A`]SV3At! s[3;r{^[;ESQPRA=ue&VRPpbt Xt@st@<W`$ë1
0uyt@A;ZXY[IfSVRUP333t1XPns*2;r<{X } ]x ]Z^U^pPSX?uH z O232QY
(t 
 V v^Ap wP.H  u;W~VS[P3Ҵ  ^_OuWQV'vf^Y_uF t?=  
fOo U[fXf^V 	^P2V`P
fCS_$߆S SK Yf^ t+>f@a ou }  u
&}tNú O (LRZ@t .;6| u
o_pt \ XZPXRSP <t 
t܊X[Zr
u(Q" P裣XYpFGtRuZOO	S 0`P	RQ
 YX PXuKu
#@7r`l2aPRo,1!P@k1VESA 0          @     |  ~  f&RxBR8qx# 42 v<s"-VPX@w^èt<r$ff'  fSrg[r&_u*S+Ҹ v"PFXtBt rϋ0[ReB$ZÐ%蟞蘞̰%  m
u@oSgܿ*-[
܋X؊@;
-
[ oyhy! 0S[R씟 s΀,y0~  *LË㋟PJÀ & (z!zz|! u}! `>y~~7R" ! y.a13N***A*B.J ًW_Jut@*8w!P*SP0[+X^_YAыK
R&߅ZR>Itѹc2ꯊRWcc_Z  

S**ѿŊ6*ǰ**@XPRZX_RWV^;  SWQ
P_[!b
Rpү jY	APnXЊǋ+˪0vssjJuU@*|QC%+\m1PR
ƚ
Z+{Q
υP
 Ju
c
QS
ϻKe
j#SR*C^f*~r^  sr
 S  ЈVpCyċN)NQ@d~rYKu]FV USP;[&G
F$FX[uJ6>P:Jr` ʞ*ًQ< =sA
0D
NE
 S C
,@
VY3[S-,f,&pΠ-S+t26vr<0[R<Ya?\FV{d t[I!֧II+IIb gK" @`p^Ua^U0sFa4^]`]P6LKu_P+
u݋P XݡP_S_ƗXcIPXB+9 e[PPas;0Yqb嘞ݟrpGXÐ+" Rk&6kW jrb>b<
v%P>N5X11s*r*
<
wr::6sQn 6]& JY<t
<u
tJr*	R>mZrAzq+@ q  @! +   > 4ݕ6b^V6(	1r6StsOxxRr#+JJَk!SfQRP&JowP6X 
$+tAÀun &@~u~QP &131O&0_oZfY[0+@s
 >Lu
UP+p?*XqvXT踓**@_蝓Q莓&|h+@?]
PXp1|"ɋXѬ
*s{CBJu޴pf`t!<w2@栨m@sr@a LLP`F ESQV<
w#p
wt<w<rSA[H5 SRVW^Z[BBq S
SVD^[
}^Y[Z@_____^}Akj:&^ EoooZ  p}  
u `	u  oco
P@J8}
Ɋu9Q4v/8rJ*͊кpDIʊ` aSWR+lBy:eu N zGBx؂0Hw`[`b+ۘP
tLHupr.XuD[uxanu4fPfVQf@h 脕spQefYY Yf^fXf۾HB .>4 
7Α+q  `UVIf3gtf`#f%f^fYf[PSfRfV(胎s3z 
<PbprSb~WTP L^V2`Ζf^f

 \oftBH`^fZ[舖3p,NVf?
 ^肕2Ҩtq  z<ëۋ
ᾱu 
"h`̀-~aa?m {ݳEs^@r 2
$Ս0$p	
6f`P[আ
u4tu)*rt SV 2^[suÿ<te u
T* 0!fP' f(#"^ft/PT
˔^	eP֍N芎Xfa'VS<usє#!B[,PlBtXÜ#tu,:tS 
u
Ws?u0tSQߠM rt,? 1 r(ݷrt A0}p~ r tawRQ$   YZtd
蒋M
>%
!pPSdİYP102kdUfQWF芗 /$i:hf#  twRPPL2_EP Pt7 Ht/F0#.H u d.\V赒^
/Evw_fY]B3=製R>0wɂIgcL`豒fHuɋؾfIhfБI9fJQfKL6+3n׉̰oЉ؃h轉i趉a)V:f3f3PPu;$DuS=f^f,54@!&M+;}+w`@21:aPfYm$CAQ 舩p=Y^u`;*&u6G%V@JbPd;&P;u4W^1Wf3 q_PV\PfW Zf_ X#^`Rú6İ6d   WB `ΰI
t 6D
.w.߀rf߰}ɀ̄L6T	+q Xβdwy
EŠnR6.p J6"6d
p 6D
 @
P
   ZptQU[HP[Q[u;%~[h p.t<DYX`3̀u ɀ&8;G|<u Pt @hX]a`rvkPQ232!Y`X-aчza  Mp1	
 
3 r1q  6 r 0 H9S	! h#9#2qt@~   [qض 
 '8
S0,
PP
}8"8q tgӔsb .Df%ffXfQP͎2@t? u !O  f^% ^u3o fYa6IK]@觔XS몍zP0|X A [g-t.;r._q-Adf@ fPfrP$`` ff# &Ff fYt ^r<t!	
қu R_(s& 
_Q aE 
6Y rYp[ VpPfP0i1f?MÊ!1PV  PX Ppr`rSQWV0֐@93w t}  p¯;r1r]}q]	Zp_Y[qVatD^VS7ā|.[^`JJXVQsα<u`w0E> t tp!P  .##Y`RՂQK  9 r߰0`tV󊆮su1-Hxy 'Q(f 'z5EY  J 4;f8,T0|$C!
x#J`:&	fѽ
FfԽfԐw֏2&[Ep  *I^@VԔ* #$~h$D^[&&L& VP28t
 ۇX^Q肈2fqOYһ1rt	`誯GcPPQ2rʡtf  pPvff^ 8д 1l#eh  1X (Cfld @A &06cg`0* Q *@0pd  K  ?  % 	p / )  xw  wH?@?  ??o@ /?_ ]xx  GXW WX\sB$'{+ )@ ?	
f H?  ?   P2хs[[9q~ P.@0И[ P  ) qAC h/ 0 1 2 3 P qPs.: 3p/tP/!,P0
˽NJVdx]#Ss 'Ѕ(P n #   073?>  QPO  10 1pq"#     Z
%! 0 A006 < 0s1  
1
100w	0
0'@P A  o  FrҿsSg,% 	rP$0Aq$} S `?
 [ST~&P[&<t/r"pk= r&9twCC&CCu&PRWSQ+&=VBu	&}E2u@P wW *۪_ `Ϋ&E&M@ "&]&EYXtS S.&G&&G0?   01 #  X +QO Y[_ZìgQRUW" r >x_]ZY[øOs|~rA.G+ 	e.pQ.LQ.ۆW +__XQ Q߲ rt.F!u.Ntzr$v
v@.z uр8t$Y`Q@&E&E.^ѿ.wU0p@` `2	*u	.Du	&U@P.Fu_ t}@*Bv
BB<vB<tBB  	w}@&uPf~f&Ma UfU fPsfft1p-H<vHt%ZEtrtBtPKt"_]uHH5 4&ƀ`&}r#w  tw	 VWQ}.Y_^I}6 pPSfVQ-&E<w%<Uɷؑ*S&
 P|&
@f^[!`p!z&G201%_Of3>SRAyr.V&GZ[b-Q<,r0;r+PS
*r[X8Iu@o @/r 2.`,$@B`RI؃u@
$
 `QqQ7 
utM05E ~?vZXu	8|b8|YO>IyJ )@=QRxʸWZڑ

 RѸ Y >Q
Jwu	xzuUWӦ#(< !< @ ׮Ou
 ;ȻwfSPfٰfffKff3f7f גyJff[Q fXfZf[W >qDq7pJ''41" 4" SRVQw$& qB..$	  ^@$Rw	B@ZSQwLN& tq u ^0SPSR׊m P*[t0  ;s ËZ[@ wvu
N %]n
XÂ*pyP `tPZYYRQh֊ȊŘ*Y  vu%@
Ċt t
t*t@ 8PRƒ3xN ~  ڣ/d  פ
_]'@3tPRtWtJtyuSu2RSu3Z	
[Zau`R4uuZ[	.farMBRutZPfBfPհ@ZfYXPR$2ZXQ71qqSW"_[*+6Bus	
3Ԙ ڙLՀ	uKy q Q *X$7h0UMAcX$0#~rRRMuP3XZ";!B의Z=0@aDԊȘItrľ@4A@<	r*ǋȋ@D ʋWӢ~ʓ%e
@CKd0*+\Prt%C<v C<tCs(rt
Ct` tCP+fVQfS)wQrTfP简uf &h `mf00l6fuf#f[Yf^ZSf$s E
[wp3uSPxXt-SPQ2	ѳpT fͯX[ t$f
ޯ w{- \e@77t7v |uMRq`4BffS ofahf`0}0Bf+ T faܐФ÷P=s
XP}wvf^VffXZ[o.:>,_sHVf._Ppvu&Rfp% dv0Zr }tfP<觪RQ"	s#.H t_2<_t3.Ӱ
.5PS}2uYY[XOTRp #|uS2SR@t(w#uv> p
诬[û!`2v08yuu
o )ypuxp xaGMx% ߨau "ó`V 2߹  WpWV zZu/"{^@u:wts]ts!3ɑ8J@`=f^DD  f fϫ_r&wItc ;
t - t
tv@p  Ou뱘  q@ xuq" xqq8fڬq+ŭ ` ql^qA	r
rv!sP#X[ 4 ,r`'$s9$`uo h E p  
 ۀ'ոsRJotZZ[mԫu pH(pLnPr0@q1Z!_2@ n2fOø_Xa܀t1R+趩
ҩZ  0Cz5  AQ膜Pf8P R2ۀ@\lu\t 2KVPtX X %V[fV^f`0[s*Aǀtt@Z43.UF^]faL$f@f^ö
~ 1r22Ɋrwt*t8u!r ssS.[
8uZ[ P
.QY"| ;B ;M
܊Q%vrȵ~j
jYjt߰ ̠ @u@!.Bp/ ( .@  f.6D  ]%o
Qpv
pvs6S[?r"褜rS" su[>
PXr2br,GqdQ"tPusy, uCִq !7ak@1Ios @5osaZf   uf^YKBs
upVasbiS7[QS`i'2`P h{2[S !"X[Y fuEnP6fVPpPotot<u
pP]XإX<u(rt,[S"2wt8tt
P>O [X莯^A*q pݘq(1@OuuP@H_Xp]`PLRzZ' 
uR SOATu u@kkpAW5u̿@yJl=_0
R#
uPlgJX
uO
I RZXnaOXbU]o<pR@M 9pSJpKif09?vtf':1 ZQP@ 躥! 5 _6#^fVW] j t"$s-lPk0|l4?  B)fŀttwfntdD>ff̾df.\f3fWAfᐷf[fSfP% ff@fä[tf  `of i_ZT: t
*s
2srA1z #z[դ GxNUiuS2> r  sQ`w%B  t[W 3 _popuSPSg[P |AX=XR0s;3^ŜobpqAˀ ø 6ø kø  Ãuó w!	`BqA`#!	w`ҠN0#\3ҀtBHBD U lnf(åv&EA$<0C<P= O 1+&]~W  t2&s$w  2πt3Q>l = u|KuT H= u }p<vwFv Ku-T#= P XHVYt@trt u_ja@>f&EBt fW~`_R]&= uf&}8  u	 < "ր t_ "\uQng`Xac
Yàf`vVrNF:f`Hp?wo3f᧠q 0f&葠a^fa] VSQtFt?miu*&0 $y?V.\.|S.\P L`.$ 8[`@q[^`j  	v<PWm<t!m<u߿4.MX XP& !X1[L
tHrw(@ 3tpñSg $u
MaafPSQ
 $0%2B"Y[Z^SQVo$u*$^Y[in
n	qn ^ @ N /qVPSL[X^Z. FT.z 99T 5Ê*8)S *ъʋ.J6*@ǀ +**@*A>ItXPR*+ZXê| /_  5PR_!Z+Qup 9YrQp nJuc^bXQBޓKuaUSPI2`&G
F`Fp"ėޅًQPNf*~r;N  r
 S wË +~	VVY[S
WfaPr
v*?PNN^Qt*t+Y~s(}vP JuQ$b!Ku]Ȓ#Q  QUW+Q>P&J_*%P@+ QWË<uN  u` R N^Y+ًtu[_]Yp2 ސ @ W+ۊӿP.G      _Ê*㋗P6LKu
P+@@+POu3qJ0\P*[Pq;u B| [PQ uK22ЪsYX! G 	Ƌ>J*
R"Q ٹ +<\Fr%;t '`ǀ
'ڋ}`R5| 4FϐZKB*FFXYB_SOIDCeKO G`|j	 8WQ7Po XBXq8*<
vRW Z: sq*r*e<
wr#:6sSQ +HɊ JSY<t
<u
tJ+YSfQRU?P[Q@fR P  ^KX~  &GG Z;t
Ku]Zfq$O
O
I
mG
M
F
tF
RM
WW
G
L
I
wX&@
I
&


K#$Ζgf ÖU8tmQfV܃+RQ蓖Y^ YBW=WZ蔖$lfX[6LNp N 
Nf^Y]A thW ^ގŃ0: 
'RX튿܉^ 	Z$ߕ Y@PSQs#2QtJu3p ̃P 
  Y[XPVpV V VX2RfP	`0(V#VfXOZ:\2[UU!PP
KV_DVX	 y  U0ѦxP<tVp   =   1QȠ/kƴ]F^sV.PfSff  ѯf,%h t,x蠔fqf[pff%2t0 PYB' s WPSV.]踇k.[[X_ÿ 
t0{UUVÜRf*fP(TCVL]f ffQ 
ԓ^\c+]<t葇rS胠xTTP mT1fYZPQwSRЯz `I0YT ]T
)\, bЖ *rAc\b&Lo}Na~a:Q藖}\Affr3S(SSeb1
+苑RS貆r
S_S  -SZ[Y0.R0@?PP
Xt@ZX`2_r_P{Fc_r3pvZ`<t!@  Pf= a /t + {+>X	aÂʐĀu
̀k RPV舐@Zt
Z~_^XZPwPXoM1m u=8 k	sr4ž6.ߊGʿ0PQY!;-''1*?   %-'(0*@A]cOoD _OPbT`-9_OOcS_ /%		'ccjz rW  Ys] $%	oo C/f`GUPܿ   2lRCGAQAQ]Xf00P<r$fP`:fXr
7J m-fa1YS@RWͺ͹  >͹   t߀t$-tt%t+2@*ߺ  Ϊaa2 	J}f3b\f`荎`誎肎׿.4 ffLҐ0rf%f
 fDp"Z^2֐&@[L" rSg5$

*"f> f$
ϳrpf٠   迍_[LpSfp@w0iVRKqz`# pf
 D
,"P^\~Q4T12-p``a{ (anð:蓋SO&G}!<	t#of`Ҍ{ ƌ`b[Q QYl.I tiJ4Tt#!(@ #"Ѝoi3/sG5 j0b90qf3`&G[vGGB1re#f$<'W` g m @ɋcGu
^GuTGYY(̴ ((f'G S Gu
Gt $ G[ f%]}zRc l
/ C &̀苠0Kft?x_ffU&PX<X|wf`*@t%{ u2xb%Ɋd  f% 諊fX
u=Fu8Ft
S
(F[ f3$
L.LXS؊p!3t=f/t `SAOXs		 Quf!#Ê 2VW^<
tu?t/Et
E^Es,0wK<u?pW^w(͊ ?sf  )   sgz[X" uzPKWf!0j_퇴3<u?<u  2HffY$4PwfdR-Ҁ/fDtD 11Ոr0<bIN]Q2rsPpg13=Dl_l
@% pmXf^$0< u
ft.f0*{6rf[YP2utR3M3 t&[4 $) CI125 ~B 	
 "),34<=!|DvC F<   J <  Dv/! @J *	@2#>>I>뜜H FD0! 4!tt  ϶Ϧυ\D e	

[O.t>q N [@ϯ D*  [Z DP a  /!@C 	h)`* / bPO 
qPqMSKAO zԠq `uVP/@q p0p9.   p#p @9? 8 1@*[F[qx  P[ɪz Sz jcz qnh Rd  pP .h1 2 3 @ CtP0  b;p*= > ? : PI0 gP.: P C 3/oqP zP   X   #%¯'n8szqp.6q]f萄fPQIi     f`2ru_~#  3F  r=MX f _ Z{< d w@,F:^ Dtp~< < < <! `Z<}@]RVpZ<rtQuPYrȁVߊZKPrY qCCp 7PT  pS[CC@ CCC CD١ :Z_P $ÿJ  PSC> [3sp$ttxupSQu20]8Y[S[QCCYVCV.DC赁 C{C襁C.D^QV `FCp^Y÷WQ  uu9 _u/bQ3ۿVpCf9 Yt Y_fVQtTcYtf臁w.!3"NrteIP'JȨt$$
X _IuOsP eR?v Y2	w4wa߿n߿߀PLat 
fYXVPQ2<t)ʆȐ1P1tQNr
|YYXYX^R.$
.	ZB	 
 {}f@pB0肀3V@ؒ  .,pc[0
4R16C@ AR 0Z@B <PXff=W  rf=+  (.5> wP '/P `q3~~p~ 迊a`O:@ 3 3 G 2&}|}P'aP'P0VH ^`8 ?= ,:cf(~t<}~f%   ?0p
 ?.F tZ3޿ _SIpuDQ0?
ኾ?f@T؞i~Yupγ2@ u
J st Pu[t	` 1|	 t-2R?	t2.4 $
.4 +?`¯a`{9=Ot
(?!?a>?aò
tZ%茽sYJYrEqKtg`OP   kEf322Q8t0ANE`At6t| s*XP`s# luRsFsAGH.T8sMQ;
uE ؀ {X2P3WDj!4
Fu?XY0pPk8t8t X`{P 8Xz" tD"@`lPRK{,{ZXzpPzBr=@2WQ#t
.EtY_CuXa8z 6.E 33.4	@.&E3{~+ t+9- t
,2 aSfRVP[D2Pt_	f!ɯ  0 CEQȻ Y ML IIDD<utkti u`[
tu,vptDqRPt6t41  u+& Ӏu:t uX^fZ[PVQBhH`2p賿H0u2
Y^XfR f- fZ	pB.$.APV'B p00., V~pf]Bf.$f.	fY^ D?$QfVG@LW\ufpo[qb	z2nB25
AlPFH@P2.  t-`$>؋&%8t x;aP=Xr
zcPUP. 5X6/O .z*s//Pi444Lo4]rP 4KB "[`ыˁ ь.'.߁'. ڐ  q:.@ :
  `: 	:aKDASHARE@A p fP+ fPx܀x  x`Џ!e%d '34834@x34AːER ,$ pdddd1_   TP;\ !A,Z PS "}@X R #

_  MKKM  
   		 "  			J  IodE smx}PBIMSDx SD  e n1 =n nw` n nPzTp X ( /!X@^@?s `ؒ T0z- {zb.1z=  /  4A $8-X@
 o/( I zPz` :0u b<8a  r7 z F
  ϑn4 c z@i!1bz!
& p% IV  K$ @
 k[}	@e E 	M GC@0 q3 " Oo  O s+   Z #  EG#Y cI'	"?  !!o                 
8 9O  @ O  OO O O ?O O  M c@ pQU n
    zn@B\A	n\ co UD\ yUI $YQpp  	*%%;"+
#-
"'		


@ 	 	@ " ,!$ ( 	 
( r 
YW
YTV	X 0E K 3 wwwڼfww)fzo " $ 
  ! # 6sA 70t9D E8BB 
| qX(P|	DP" 33
 yD txP~
`* z( XPPwzA z X0  >X@!<"t/  oQ  sc uCJ  K unjrDM  I 0 U
#O  O l opQ!O  qp.rA Jp/8 0uq̀1 	O  9[8[r9['r9[/rX H}~0_"O  X~   $z Dq@    x  < ͟਻ IΉϙܛ
ͫ ^3Ӝ
                s큐I
Iޜ~	ʫ󩙉ߙ0    #D P #@` MDPMd HMh!LpNlP OpATOtX Pxja\P|P        
#   q {0      8 B2g	hB33#dC!l22mq       !E32Dx334zT44C{2"QUqKh pV}=ж0 n0 R+  T8 ?( 3 !CRS@, : ; J K@L QWX ~L(x `  SDR+O T
<y D n	ĵn,wn,% \nH  `WnH( cɭ" < qJ<p@  @
O  $O  q[)[2A ` 2  b`2j`p"tP?3
o6nd okqkzpVc x n8 An< PPn `܀P$#RqX 
p3?̟  zlzd ݑh        n`2zTqMp	q       ` 7 0IPp H HLPTP"3>*>@@@h@@@3)C
$W rø&FfFF''@g5
Ppo~CԘd,(e4 I$'1?
|:<<xX\llx<llt ?l\t\ll,>\636l:n.11p/xt8>1@ P`P x x
	
P 
 XuH H@ sX9:!"#H$#%	%#$dBQ1qp2QAaX
 h a((H
*+ ۉU X 
,	,
 -	-ɰh
( 0؈(	82@0*
X/*,
+*012H,
X
հڰ荲	x&`
հpXBҰ2 X
*@)*
B*0*5 X+Q:
B0X
 *rx(݈a h
,  rph
a+2#0		X5 95 2:/U Y% qsr 788/a9:	X X)% "ձZ7	3@*";	6<
w : Z36
,S)
"!
B
= X@ `(X3+	:
9	*0/*	yF2@S# 8*
.,
Xq 9
2*PE
*	1>+1q(9
  XPAY p"x0;*(YJ
~ I
Xq%*`+XQ9@4Y1I
 *@RX	'	U(SXH(à2p*,
UH`+ 4
H q)1 p   qð ;0)%uXH?  1 %8 :*Ӑ( !Bu	B

 X*Ӏ
 qP r* H* %HPI*D#RXG(T%C6H)HA1Ұ#2R Q# #"`ã*' 5@ 
 p<p+0:@95/u*a2)'2 <D'E( @A@ oXEF+ GH+ IJ+ h%\Px| |T CH	;C x x%xV xVVK
KlL̴LP  M p PP| VhGch^ ~`P%@h_h#,21u)AX	1jh0Ѱ@Px##X )o
rJ98:5r9`(D`P+#E
A0Nx	 	!YP4R U߷(QT Pj##h  xN4HUȊ ~l|8<fBx?30pcg>{`($vbh:Zd6nDUw7  PUBt2>V Ft4F]X3ff<t,r"&PyCQY>с  rOuCCf`60>k.>.yfa9 }1              K ,ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$U)CompuTrace V80.829 \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      Ow qOqP WWsUPX!	 nlAmNa &f`2a UVW~
3vNWXZ_^]
 !~3АH9E}!/f`!
u`"!W>WVIVhF۪U rr	rH0n`w	fmq29%fUْ!om̑3ɊF0r	wk
"e <ar<zw$ߓ&G+tdwCu*䉵D]f͏ ^m^ǓGGް;v2Ft	
n[9ؗW75Fb,1hCV~<=t }[2F uƕ@]GscQm^|
HۙG}~wWCfEnGff;sB_V 2mtl9
3ڸ W+vOΚ))_J?JѰ[.	<	6V8d]l,\l]Pj{[ lOPhC
DC>C5ul1?C4u uxytG
	t
ƾn2jn^6]~5?t$xNF[
jPw^97w3 s)PP-՗ }6uUۀ |F#juu6>b{,.)'?8Dj
4
2
wMv21
@uf
Ϛi4$hЊF#bPk

h&Y
Jv
,1oCjel*OWenhh
0=}kT{Nw?^>|::VJ
UUK\rP h0t\V4Qdx?$dF3PJ

ݭLAL-hRPӀ'j9sT!A{ r!HG;tg
[4J |;luh\":2fRf9Kt8a'WF뜳\&서Δ\ެף"<Wz摅V_>u]XZWoQ hLDn\'އ2k$6&>O`/"F)#K<Den%ᄳ6$vP %,`uVP' vjX6n;vt_kj|ԾwF
5x sD_G@ui5FfdE+
w;Z bu.hVkD #Wlvu6r83
o^ rn ~ޝu&j o{F uWkÃpLF3{Ulk%o[T#
N&"c?٠(`58^	V1
)@@>>)BxeJ",h"Dd,
@^~y
 JD(PypZPH,E%d|(@WuJ,|PNB?XfpE'7	=r
$oyR#f1 2Pu]VnK=kv=,l|."]	 (PhֽоT"brR" !mVB3xV
Ђ:
0&
~Dk>)Vb.WIG<@|] Ze%' ]$D0ݶ(4
 5dEhVDMuc5 W
'90|{"`FJv-t- tt
tuCnu7u9/u/yUu%}7wXeoԀ}% KRPS4ǨW,;2j-RN,u
۱<<S|-TbfInr JYp!/xxNF>'27Yv 
<z%':6JC$I3gk-$Kn
W	6<-b~9uCQ*jK,2?$ X#t
YKjVmZ:ZXm8:X:mmO2u-62<9;_"K0hH!FT2nP#w`L7[[PP,dw$l\ kaJ5o9t<I{r_uG7M6Jv>g:Avf#aA]Wq	sc ,7E	P"A۟|R`\#< XeXZ'^cN,"}wV( w#VV!uU33
O y-[!bύW~ePhJe'BVWBr$KukEKLLfMfXfꭆ[5Nf+,9tk'7KwKY-\po=w!u:5o*tA<3_Pҕ,*$CƙMtZнt
.-
4	s#DeYS?\t iFt+ted7ORNޭ+GH#FDuu <fH+#$7#H3l;N3Y|(U*ۢx EG"7I,5P( W?4~r͋JK:MRP ٭[j1I>
#26U$<uT$_f@t=%? 	W{%N;xf8$ۂ\^FOwmto㲆e*c:ğ
a^8mč۞d&ًM$NX&(zl NfPfd "ƅ0CYJ%6h JiI\	j-[Ife[~ƥ3tE^<R;lu-þV.GV$hs@	fGF!"+= r9puB[0~k 0y	t Jxt]K0Nʷ`H;;u	Xd0+}-^? ?CCG%[!L:
cȁmWs]i5Ѷc)xR+:ʋwO
9UuNw, 
~HOo %l4(@Z
6JGDsuDJҎfǓFN#}`  
HgClD(?F6,H/Dhf#'`J-`{ #~T`^,/'Ui=hC|$-Blxn޶.ئt}w" M6N	q".C"Plwƾl۹ZߠD= w({.2@usyj95Gt/@nd+@u2{|@tR~
׽vuaJ?C:?7@
?+1+s>{u$N0BKϹ6. ؙ
;~rc
i./a8CRU+z"TkBNO	rm{d
\q&	2
 r	Xvt9rw9~6
?P
|+RH6Nr45x4H	^$#l?tDD>$S
=yNQ-H:+$زE<>:4!SH / :}3G61B'R
2$!<ezi~O#<>e[(@tetK?H! mΰl#EG|js%W?	N7N*q(>gϦҪf࠾?wE ۴,ۍQ)b˴o;WPP!{;P tIV%Hnk4h;$Kaz#VNAJ|BdFpn*UFń }歷.DR
j4'ZIzJx ~SHPIә(s
`|G V=IKu'w"dr!:c'I?F*R<Zf#Q,pnBT>'OV@[%tZ
t=.DA;pwE8`ȇ,^l0Qfɪ3bEMPUG mtٳ!Չǆbt#MfU<Y	]äFedt6ƛ
;c5뻄D j;xa<2`p@¼-c@Bnr
M9vMu	P3DVP<ZvLuMѡ7"+ҋE0g;tcF[fF8rf`˚ R$;F3u/-agf'/OB;a;Z!c떼:\a&NQ\fN{v3FWyRȦγ`2Z,)sZ}7j Za3Z|R u2ϊs0j0'/^ 9uH9Fo[+C2&D6L_P=)?nq֥&MvV;lNQ7Vl]G3kvB` 	
|,*rXGrLv!L.fSҗaCGL%'=A #"A'l#at$!!U"ۀ	
	/0'vL&DY.LrHC6c;l6,۵2ތR##*eT\2ʎ;6ƣ~ǖt6\-3߱_5+~u&# _̌.ƷH(j|v^[@%Y`PC[Ё
4-4m3dn9W#t\Z#@9jt [BSԽn#lxF"XFe]Eܶ	
@K%^3H+-P ո~&pV
B	LmG=Nzfh`;65b;'!f%T0eJmLtştdkꃀmdPVYGV-U"t*{¢ST{L鶆R),Q
@
XPjҏ47`Sr@Ĵ F/Of@v%
{l;Qpx>R/2)35T@ SVjd]Wj
+h^YQ#
N Q#_7;l*=#DD wr͢FWD 'hu!*rŠ%,k{BpWI|}0:.	!wFnm&(.,
ptXEj$$;+*^%4%#5gy {OMP״5t~
!`C)%Bev`?}"0;vp1+J	B7+h2~Lp`՚Ko%GtU꥕ϲdkw@D[MQ
09pv*ι>l
MN
o
7
:*m9sV-nTO;v})
e۽9,0FP;cKSWЋU'9`*R-xɽ'q{zU+x1lR1u4W	<{P%; X:,
t3,;K;Tt%3vi9	;uVRR1#}sS4 u;|0k"aox^;+D
-7k	WN8^E@t
zxRe.b{etw :^	wߛn!°
D\3"&C34v<-[
LQFmG/haٚM@Mj@r.G$9bd2/HH\ -EZ(?'lhOl8'_ms(9yq{YGYwQY2r<pS[AE/9[rK"r SuS.h1_m7xjP.JD
+~jz8/epֽ?W)`^l
A1^E*}~ /9|W7[3? l+/,;rw;r-	6"	pf:0(#6{\{!N
*A}t( C1 BaiR3 REٶW"$W۾ge:|Jowzrgcss+;T*6nG^Gwj=& Gso{uV܃i~5JбG݁26T|Pl͊
BWh A@fbG!a]oՕ4;u)^LQWc`N;P<@;;(
y<Nkw{p5і9
kG[uՎ?`s@? =GKpcG]+=\
tE_@Iv~@nPyt¶uZ9seD܋ʃ{+[; @kaqR1t	D	&,q%<H)F`*R,(!7L.66E@bG]ŗt K|	SԾ}ݮHu|CCQ+!"ZusHǜɄ^+674$GAB
v"dO&7gcD0m;4tfKάʴwJ(`_\Zc#!V(65'L8,d`#hJ8
uDkLs,5\VVbѦ "aAH![bхQ;<*bL
(${k$Hx
]Рktq,|=0yUzDNoR
fQ6pf]wP
ߞ6+T
TK|wt1f+4A&`Tyi+ȁqxΈSd/NPG&&>*0xhnl
?"oVWVvB=[%.85;)n?6oL6@m&TS*蹳#66**OdD̽ LluVzJ
!
Hoq|-+!VcXs)I%ቦ%di1GNIs2xpvN X\L1dlHBPF/a[d]Qm,#&z#rr6Xrv]ANY^Tte<@'c5a5fj8#'2R$<Mؠ4XwHmTq2 ;f)gRN Q{u$A/V3.ј5G-f1Ujh QP,cO9WBtH/{C:Ame*PJPќ_Wf<OT+NB F;sfB;v,)N-PO
4lӆp04(!dYKBOSº%칗ɲe_0!{ lcτu{E 0aclt"9
ֶ	
lV[7)l7SdrA#^\K=^IP+`7|`SZ޸Mp -wr(rwk5"RL6,3#@|bVBD~=<Nm4aL0wm&&ҥr<xذ*\BVA6	"U7d(NΠ,T$lL-TRsab[	MVO½
r r&wvd He;+BBkM;˂7b49
5aFUG)K0G@8{	P'+5OFpEovP
QueuKtj/kg.3YЙ*mFo GG:k9|f.'|pp+VR'&_$>DOuҿA#2V]DEnl~ͳ#uM+n	>6w@ 0t1@;wGJщBbG
m5HIc,o.HHLWJ${DDt:ln
Fe4@Bb[
L8
%<Kw%6Pg+$LN%\rV.J W"Cô,ۋyDFV۷HTJo< ,>ޭu)D^m(AhgTD#6fȻQjqÛl@xYHF+JCFdDRzAXT֗mnVX]5@(N*ʋHG18v
6^8:3kUr9(JBsBs;V^~R9r
eЩxcx.FF}tj
5){^ƎEa~
D)W[2$0Fo22Ȉ
`e
0-81sRk2Y:\htfƴǄ|0<H_8G2*w96 w]9~ v$+ǹvCmTҞuk2(S odZvyr9Rg)>k6ΥAv;9u@;?S~v/8f5]!raeA-q+'multi(0)di`skrpartion(1)\WINDOWS \Sto| Menurog{ramsupIAUTOCHK.EXE)ystemo	BOOT.INIvMSES.SYS7inBootDirė7BAK8-rpcnoetp.exe&ϗ&&MZU{m-@1I(ǻOǶ$Ǵ/RichSPELiD1\%uk% } O 4XW(
e [d<.tta_#n`.daή2K
.c(E0'mAsAR'reloc'VB  4G4
*4MDRb4pz4Mbi
Kֺ/D7i	Rk\??\C:Rp"k\ee%,{Regi-ry\Machi+&Ԡ}
ntColSEU!ervicesO Local OhbjechImagePeh TypmEGorF#0  : \^Ib	hl@ d:$7ۉl+SVEeտE9EEdރ,VB-O~=hom9N3Vmo"jh;7V#PhPPu	@}` C|+E59640kkud	m@(-P˲7݃@-)Vbe} M}H ;̽
vk2MIv#3"H߶
ܭAR8H}
t'hn!)s>8?mf]_^[: ۗN/8F> Dt3(;p`P+L4afR@JbAu#8ƅ*H~݌K#@|L(<2j[B xC&0Lp!Nj	&e[Pxf2'j)_RYY3۳`4g-;u2j0(
j.7tr;j+̅ tWfCZ)A:p9fqiI:li Fvk{3}C؊(un\f342#	gtUW$6EfY
fY˳3WWiZ;)We}}c}cf9=ޭq
V

xt}S N<ƹI	W	gPSDn{pWI݉M@86\	9>uu[Ac%,Y8$S*:UW?  	mO0vz(MLavӀV.L6S9DWPZ>uS;5[̭̔ Q} 0f[R 1MaR%zBB7X
VjhAJ oӎL*[Xy_禷M}6ZZ`
Ë1l7 U949O`a'@o N7hȍeFilrwcscatRtlQu
yEnoףnme,Viab(_U c9Fs4wCDeleRRd0g
F9lKKeyW
E,|orchr nInmUcoden%
$ng%١s[=PTmk(6osٵupys]EAmwdQtdBll.@JK[
j9z>9ǚ3b9o<~<9?99{#sc ,6
NR5PHaCݰwF>dMpJNP563L=:S<|`Gr<&p'@HEYpiZL8$D,HMum7zAi*@LZfizi+aa;4,<MR`t44MMiC 0<NiZpi~Цi
".H^A@4Ҿ4MMӀp\4J>
R(sEI0Uzsvo&EyEږ ImOp**L,t5Ht2H4fois,kxklrc.ed+SRd^RequeZsk,lclI5kD:AvaXcvs Moz/4.0 (.mp*i$ۿ; MSIE 6;f)Eַ5W%}HatpMi_BjOSTGAd극HBsMX</'Softwav\MAr^]
\WKowsV8\App m&ip&ڟ{SgTagI'D-Lmg;: %d
%sts;}0
,V%%++*/ *!K.!@"rp(t(77./--K/ܒ//?3n#@.r#fF}MVWf=A3t	|$Kgw{dDuP&l&^ʋUa7jHkEBXYtVQ-m4-N]n'V 
&	V>4ڳ6f.ZsZ}}50Q!"E43>wr
C~^חBRtuKKF]jD}dH!G ssb# 燯KAXN<
HDm(+P	JQS39tuSSjPQ<0u 5&c7/;[z}8
	/4Dt '(!
	ɈH܍鴧+6Vu<VOX6u%A;*?AAYtlruE;>YP@4@C6k1pky~Eh/
hy75c64wf(iJ<
Epc
Z<< w8bƝ&HɋT/z
/01^uJFPQ _`cAC_Ph`l!=>sW`:u۽YLRmciAwoudBWw\(a!hZD4d#dxe FS+cY^>-W;\s6M%D0G	@3ҹMNvV`gVC~_^[j$hHr\eZi;Hww34D\@S2~rA.WnaHlB.jT6HCԑU(Dv%ލLPbg ^(uS^B*{xfZcR
[$9ߺ'v4+Q3 :"shYnxl"ܳO9]v/k u޶VQLЍQPfͧLI@mg0?P(upkNOZlj
,qKZ] -`̄vnR,ׁ`\̛`r/_tm׊2_DUW$lU{͒Ķ{=H
t"ǾTh
q7'dD1ӋeVU'ԝn_][%@\ppVub	lV0Ę.a6eVhM
N"^k >;-hɱ=URu
g{ؽ`6}PbniDCۮ-jC1 ~ H?a({(9VD]-u$0~PHB%NiP	(0mwmuQWj\d"Y2RFU.ܺxkGxׁRR@W݁
|3 hYW7v0;s<Uum?G:\hQ2Шr7:r]S][/Hy; }	^xfi;|AB
X9${whJG h@YSGA_@1?A
,rh8isl ،g,EVlSad9.$WnVOhlם8Sdkl mFZf~X<[>0)vCFxV#`} JSP^h~TV\DSb(hF9XDE&3s	09Cu}^u$HhdčV6@z6LQjn('^:F*͍劫&s.Zm=Bp6Wmml`叚kt5;t19PjTRDvWhK,k#gFࡡd`6𪋟^n|c|DhdCp'5C`<y4B}j<(/fv
P٥=3p2z`xL#z8RhXn5( haM6
Gp$eӫA؟'OB޽хu	=x!<]qh,`U8T
fǀRoCah`(ǅd૯h٬7p1XÚstN;u	;(8@'EVIw=bW$l9zsFS]]s9t	RoLC(jHv8Dr[H^.8
j(zkZ^^}W݃5`MgB+}9k
xt9t0+}J
06ٞed]\\]>x@u`tm-<M4^x-%2B!4,B:Yҩ |CQp$ ;!OJN^g$<@ 	^&3ھ
CQ"63Y 4XF@ ;|ܭI7Y䱾h5<VFxWQʑV88І@KN\77A謆&,7mb*eR9P/QvHR4IIs`ET-ԍ/n؁8!rcYf,SHH[3l-w{-6atqFW/dujd'8+APD3Iz%quSh'5$04,Eepdnw>d@-йP(%NÐNl0P2STg}̌<}V58Q$|($Da4
4SnoXO4 ٟ%JlFk(ܺH }nhb{u2!^qHQY.Wyz&5\s<tudYO;tiFltNpNl}T˝S^<;5.h+8+=,^+0tjh.\ր$lСY^t 6NT~Zwb!|{:u,ZW n,i. 
h[\DI4L%c<2l,,40=@@?*Du8B!ρ-jw9.u9'|Ohj`U֊4fՆԢ'Ǿ*njЩez+R;`3Zj5fKtdA{&FxPQsQ4ᓊ#lqbWK^&Hk!nX*
=ƸRVIVJ=hwUAK:o[SێQ 㬇 ;< xV`xXlHp3"Ԇ98o9SJ忢K-,CDVuύ-rj[ = iGob[m~$	1`v5<h0پF$\(
0L,$#,gwFtVR39w:Ib\ x^{hɭ75m4tFP,FmPZtL5J=:azhq~\8SFg!:`W0k}C"F3U<ȋX+Ѓ9Ul\A>
%wVRW+8h8Iͯ(p ϽnS ns
4PS wĕșV$Rnh<RP&% W4Wػp2x`r@$
X0{t
?ى=2N7juf(0sh8$ʸa N멸-4ԃCAZV4,+hX&8 t&Ĳ(rn3PVwKGu|Fc^vrU
-jfQqlw7@YWhЧ3$`t+l8QZj\
>hoHi98$X\HӬ>j(h*>}Kh F+atPX(|coWUZ;u|l|mtċF<6@?UYY`-1DGKe"A-r
'ez	p	0ń\|j3AC^GEr:H=1>R
H`x@~ Í3+K
X603<@GyVi
ion|;Jkl(mlYUk"K̆Qjz\\
3';mt;^
%;%>XtǺ#*u
E^,(fmGrIþFc:D_٢p}'f:՜!A,mܯ!l2(	Tf7CttlR:QOSqk3XSi|l5:{ӣ=ECe7 l|,> +L2'0@(vtza6E0!}
t M p4$wa?u:0ɯ?ldTXЛ[oPs?y"95\P8h8*LaX,qpP
y%@f^:
8zoWtt	øV5%+!CS[lp(8vIVA)O  H"0V
lj%谋L- et|Dvhy-DHVJ-q->t`5/9X(5Uuo* >W@(d8F;[tDA_%<x=)Cr"
n'gtb=hf+l@>P,kŅl3*DExAnt]v֓S#c9\W*\JW][Sŋa]-PbGt0Zh(Qb=XCVθ8|ڣh0T}[wQUV3ퟵEh0+p
«"	* R- Qu
V%][$==)]k J&V1_[$=93C>j{ӡ]ӝ^Pg**7`Uy\^`]Y(VTG.ThCT{Kt>=x [
rp Q PG/F׻X!kXУ!2uݡM Sx@@b*Y54AGS}h?ץG'"B_Ɖh`ɨˣ
%	9=&hä:﫱P}NzC"I؄1)cЊ0&pOL0 <& L
(
 9c-}WrيEdɖ!j4h`~OȨre{8;GzF\b^>Gu{vB9 jnUeb?DJ
J\j@ZPhX(UR[9N>~׀%y<kT7b?jHPXh6@Pڀ	cQrHP]
d
QqBfxJ%VQo
@A)!x]=Bt(JaR0ַƹ f
e/Rl?OGodtI+σNmL#pуwo$:
}p/\}9->w-SpK9
۱
-V
{3L"O 3}
Co^Bw;˓uGq:	IQ`)4$/M9DR3`c2ڮbӀ؁3X2ۋkapV2sf+!u!FBh3%^\Q~dl%5ow9d;u;},<t8;4/k	/;5q(]@h	sj}f[  xG9nn|~@<֡nw]6 xS]&z<C&gc(vCzEջFH	E
ӍY\/}tIuʻASB/m27u /*e2IUڢ+;_}
kA5oD~o3 ]5Kz62[ Jlx%À
w8~ۈo
}}}qwrhwb6Q}W)	V(L
V_	+<#8}[%G8۫̆<b#;2^\0^T Ph,<~mUkS{\1VO;bP}O;|Ԋ.b?dtSrv6R[PWtt
%+f|,aj.bS~[BXK~@$2\9a!Ȓӽك2. nD? A 4{8>r2ˢEP-OCK32)PuThdMkUK~TimerD(>vEx
is vch1G,:GeezfCN ECla;?Qui0 Translv-aPeekڗwݠZtf첑efK`USER K
K͛Ar)۪ayA}ForS leG 	Ev(@ hAlv1R
FFPO7eØ책ddrgStd[⏬f(m0mmzy sqkeG!
ZikAS=GI|&  ,itg޾+dAR`9#S4Codw{um#홌ObrppedltLZwCna!iL t
NZVP1|:B3Te2iL6;$(a%. X; Lib;(
QVt+pS=py|8lx*t@HB`iB[@l>[M ]GvT3 "O-P7lٶi6l.;́aMFpswH8aYp<atG4lP0f f"lizxStԜғKNELDz(Jڱ=d6Cn'r?N79[\'5	_=$sUs*{~KeTokju]5h5\6Qo
⾀Y٩QUXқqADVAPI EfyE5AEB!Q|%@(wʔDM5(MhGeSP=@
m893c(&
d@`! A1iQN
] F(GHdĢ̛
'i<9~a |6M=-3+(8G#  W 11333333333333333 444 4,404<4@4L4P4X4\4d4~4445R5t5y55555555556	666 6&636>6H6`6t6}6666666666677777!7P7T7778388889
:(:::
;%;M;;;;;;m<<<<<<<=(=R===+>|>?-?7?^?y??umPw0/0P000K1m1u11H2j2{22223Z4c45:6K6\6d6k6q666666657 7߱777888ߐ8888'9.959i999999:B:K:R:X:m::::]::DS;Y;c;i;n;v;;;w<<<1<?<^<u<<<<<=$=*=/=5=L_=m=w===>>8>R>m>>>>>>	??!?(?:|?V??Y<0H00I0U00000001>1L1U1f7%11272e7)22$3 ;3\3x373344#?4++G4V4a4g4r44444/44555!5)5L5W5d5v5}5555555?566+99|6?S6[6b߀66=

ރ%767C7W7k7|75777777tAz88
9q:::::::::w;(0(0,0 80<0@0D0H0L)TX0% ibP111142@2KU2^2?3H444ė5p5~5;6x&677(7DTGAа˂(     : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       07/28/06YFA' U(   2 G  N            N   U      WVS3    _3   G<t#<t
<t
<ti        	:  [^.$   _tIFXTPMDRV-MP-SEG32 v0.95 Copyright 2005, Infineon Technologies   QSR  .   .   3f.   f%  Ƈ  Ƈ  fǇ  J '     u#  f u   f u3P9   X   Z[YfQfSR3.     f t	   3   Zf[fYfQfRfS      f%    f             f3f[fZfYfQfRS          f%      .     .   u .    3     R   Q  .   t	  >   5     
  0  f t   u
  f JK   f u?   j
     `
    $u
   <
    $u
   (
  f3[fZfYÜVRSQW3f ?  f   5  ލ,  f 3f fǇ0    z  f W  f3ۊ  f@  ff ,      (  Gf \   57  4$f f+ffI߇Gf( \   5U  4$f( f+ffI߇Gf	 \   5~  4$f	 f+ffI߇Gf5  4$fG5  4$GffJrZ5  4$f5  4$5  4$G5  4$G5  4$G5  4$3
f f _Y[Z^<t.!   f3fRfQf%  ff`fʊfʰafʊff3fYfZfRQfSf%  ff+  ff<u9ff<u+ff<t<uff< uf3f 
f	 f  Cff[YfZfRfQf%  ff!`ffʰaffʰ f tf f3fYfZfRfQf3  fs*f fd f   f3   fs
fJuf f3fYfZfRfQf%  ff0ff3tf f ff3fYfZfRfQf%  ff&ff3f%  fʰ'ff%  ff3fYfZfRfQf%  ffpfʀfʰqfʊff3fYfZR.   ff3t2f2ff3ZR.   fZ VSRQf       	       fǇ0    tw> tr~ tl~ tf~ t`   ֋N^63f  f;s  uf
 4    f u  f u	2   f 
f f fǇ0    fظ   o  3fYZ[^QVSRf3ҷ  f      f      fu  f 8     fu  f   fuB&  f   f             $3   fu   f   f    @ pf	u    f   f um@   Jfu
o  :f
uJ)  f uf S  d  f uTƀtMt$8  2D$t$++ȋt$  '  f uƀt  f u      f  Z[^YVQt$L$	  f u	t$f3 Y^SRQf3F      f u7t      f u"3Ɋ    tff t  YZ[SQfR    3f  t tf;sf          fZY[fSQV3f 5    f uv  ^Yf[fSQ  Ƈ          Yf[fSQV3f 5  (  ^Yf[fSQVR    fS      f3ۈ    3f 5     f[  Z^Yf[fSQVR<    fS       f3ۈ  Ƈ  3f 5     .      f[  Z^Yf[fRfS     ff     f t     f f[fZfRfS     ff t   f t   g  f f[fZRfSf2 f  K   f u.   f nf3
f f f[Zf3f sf f f3f fRfQfrf
   fr
fJuf f3fYfZ RQ3Ҋ    t   f uOf        ;w(     f u  f t  f f YZS  s   f u+    frfrtDtt*<f :f 4f .؀f t#f t؀@f t
f	 tf
 [fSQV3f 5  ;   ^Yf[fSQV3f 5     f u5  f% tf ^Yf[RfSQf2 f {f u.   flf3
f f Yf[ZRf2 f A2f u.   fff3f Z QVR3f 5  ,  3f+HHdf u  c   f t	   f3Z^YQRS3f  .   7   f tZf tf f3[ZYf3Yf f sf3f3Bff rf3 Q."   tf  uf3   f      fr   fsfIuf3fP   m   fX."   tfYfPfSfQ."   tfC   fB   0   f '   fsfIu   ."   tffYf[fXp$
pqfSfp$
pfqf[.    tUf tJ   Y   fs
   3      9   fr
      3'     S'     [S'  #   [Ë%  t     %  t  '  $IFXTPMz       $IFXTPMFidk                                                                                                $IFXTPMBuf                                                                                                                                              f   ff   2fff   ff3.7tZf.;|u.Dtf   f   f30fy   f  f\0fnf30f   f3f30f   f   2"2B     9                               &`"L1^9M|ȵ-M0%V\FWFVՄI/N#~j0
\3GVcz7PAF
͹"MWa
&i,#,γŔ(4İٖD'9m	yι7sM'pUgrDkA[JN

΂5hqYTV?z2oKqYs!Ј]vFwl|g<۲^пIS!A w`J_
s
	_KPP{V+{+~6ooXi(?>ֻ>aPU|G)XbHc!d[bcSy,\ޜ~N
_Y
(V,HgRQк'XS#@K^alf\г EW"YFh&}=tU@	5syz[s~q]To,M[
$+X)f7ꛮm$TȪ~%<?ԐBR4Fvc߬znuNax$iZDxoI:'0"֖߫S-ӭa;ya
"|4'",wK(`sRO8YZD۩|;ȱ84h$]DVJ^:F]^H.jc@> >޿K8f^ u.I(֜SM8rն{~Z/,ATOk@**El_}#	;l}(QS[!8}TeiԔv2ʄ"y,^묆-+oXÄcXAJ<H_|+f"́&DsKƵ+8l~cr+$@m#%LCh.E"s&7}8emg-ϧKv1T}QR5BaiN*W?[3F	߆1,Hb'EBޒ_s6v>i Iċ"#k/SԋOm#,\䎧ܿT0Hͩc,#rд~!Q^GhMm_[` npkm4R{`Y;/ 2NS\
Ub2y,PP"d1-y(Q
ЯJg q=`*q̼F4-|^ŵ_~ExcJ3'tfW8;("x (,Đ<rC֓Ftu0ls,LS5mWg$EكGf%f9l ڀzFM[9p06LMVP4SX>~?%Jcg~qc6XFO4U*a`ɣe /t-zc`|QMe鎝jz#̗~k\&hFq0l%F#l`;TsC lk+O[>T##G 'j/q>8[6ie>::D#.2" K6ɥ馺t6`6IQO"ɆLb]LE}}cPgҝ靼` U"ܖ6Cg#OJ
j\CidyfuB+^zp~&$`!}_+@P0oBCO3'Oh@ONpU5ه y
T)ئqmո.a8DߗF#7!m
0`/[uٓj8ehxy8j
L>GgoO.8g6Ɇ~7GG#2g^	D/W/J	OlKت(x՞s?0I+֧xa}*b>$V{=[u[_6mRn>*YZBn&Z*Oy$$d1rW|/c ,&\>W]~:xjM=я&
/Ը]U"=!9a!Cʄ1Fp.\^7\lUI#ȆN
%â)-)Cdg*cFQ׾F'E7lU\=|8|5embBA$!}!4o|4řb??R
)g`t,t.VثbkHdT`pQ_PT<q%툐H.
7SVsh:nIs?$jL- D^t6.W?d$xHGʏ\պH|lEk#[{68C~U#+7X
]v&e*%[GDmg*	QIf*W>jLNJXSbZi~`5={
.$	tRbN0z_hTw(# T<NXQ[16;6Ƒ{-tr1Bw8.rXX3HK(͉r.J
%ah5$3~Ԅo,-D#zI7[z;3sD^>$έ^si
Ad9dttQQz@0cZ|f-]>И'?|@ٓN=;Dt~y8`mSѬ7}'CޞK0po/8_ߑ]66Sbu:	Z?xqLGO&jM@cNbBjfo[Z*cs$ʻ߆g70N]Ɯ~h	.HyWٞ21<AbZĜqZC(}dq[eTsٹYqލ@nP.BU"z(Qb[ pE0GH	ѿ2Ƭ񃄗Sf	wS:}$AL.M4Ys%ȯH0[׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   T      fp                        c~l݁|TL3cOE1@HJCI'>zηן+H?.
Wynl,,>"D:2)y-zf܉t	=]]%>|QlR(ݖR!kV>
Ky!gx|8<ޱd'C5%LK&t3`(.lHwKCG@Y*\.Ɯ)Efed%*B<fw\lu	`#_i2l Z0)3%>{u?2aC×)R'Y:ʞ!Wˊ?ZȺ0*Нm$Wꯒ@j;S
 pƯ=eUix~;dڋ7 ؟vkndX̠\\Y_8g7tuȦYd(1Iք|+<Z-J+\e25[,57-閔 7xRC1i\L %
8/lLjۇ+sԄjP5,HdsKJs$֑{k(!-w?n=1 Vc	S/TORu.M7ԛ'
ܩm <k@9 G<9N퍥5)4i<u3(A\8 	nW !;aS>~<JVüC#3㛟0נn?Ê*:ES'G3ޚ`Wؾ#Qx9v=QMH][.3t;aN 脓7l,(a4Bb2 VuFW82
֞4?&,Sr A0-pjۼ;AOsN"m[to_ց=h%CKQW6ή+.
cV?H&+u>G(^*"mxuwĠoo)&@R+<{ug	Ҹ3NcRf^Hōփ~Hޤ" ts<MkfXc퇪ws9P'ܛoj3k8XN5w}4{01*߼Q\Y@^	A2/4^AO._c̡;ͨ:ߒZ.[W4C
`N XiK_denЄ9#CL8%|Us6 7[(AV
,0gDx&8<Q&_'W)9ȴ\Gc4>Ȩۀam!KN!M_X=2th(dn9O'|^J»l!"=1܅h=/D	C'^Q<@P|>@@V?;Y-b1ɾ
 \FhAX%46)unҮ/1h87C6ʅ|޾LEgŵk]LV64gz/!=)M?+sqZJSJ],)qȱ!>øYx%ok,-29td] 0
nxnZE+zb5mҫf7Q$-"S,(Y(W@Ϯm[L'TY9>JqUna7UgKeJo83T\cp, Wij(X
<euB2I(N-d,0ժ	_>^3졗pLs-ZBǻBѣljs5KJhxF9"ۚcJ!9[w+KXzݷ=6bΫz{܁׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEc
1FCvx=T-~߯ilΘsމ5:nK%aťxC=E$'=?oxlߒ.*?4z7	Iw8WDC{EpfX`*dU8&b/)<TA<E[zd)G5TKQ._Jq2PH SEcx=N,E|n:C'>@1y4VҸ/\b*IIm ʸh+);vKj=~do{>s,[7<[o!	q3$?ūkW$F޲7x]K2ώ|R]j>%ϖJйVXrxEC<ʆM:#CTUŉ9bw 4f>#){~qŖ62B6	%]7LRކ
@d|
}
Xi>'MJ	1ȫw)0,a@oaޒy	ǉ }eûH}_FrJ?)1^,0)oWEt+n#b#
Mf>t_OGzp3	T8fs2dNGdiP &ҍ82ɢjbˇ7ScnkA'vaOΏMi!"r/|׏#&2̴"ت/Powz0!3{[n8}I	b$BJh!fH"PNŗ${	ÊHG?--kqxå^bS,1e!H5fjdjāk1Gu'Jh>*:M<ۿga|hb-
K`8 D%Iɘ,ɯ[5>   6    #  ZU                        @-w`VM|RJ O9/byOWه#2KجPꆜU˝_2:HB["0#huM4˝'<Ÿ[_Ŷ[IA1|[dKF.Ɠ<jp>`3iFݟ
a+mQ fF;"	 Sҝ iu*A [`Z\]4 \]8
M̒_]+ۊod
U	g|J#	jMè|(B楌ͼ]CMz˂u3Z&daQs;[F,D~s;DZ6ݩl#Fw]@I=.ُ7	(9RżҷĜ qg(	P*1"8Yr-mfjt։:ZjͲ6xͨS!kJ`~
P+;|N 6_qRnq	>!ctydBggٖ\U6)
ۙ!	s9|ct{ 8_nm]vJgfBdᇙMÕ,ԯչ)Z!&"<iJ4B"dUfBSjDl'	ܚ= ;AJU"# P5J&W}zQB4JһN1'ĉ$\O4Ru<y
2Cƕ.}k82NBG?kTHJR#ϗi+2EEչba^!(ySns
lIЇ2̟&4؊EEwzg@DȻ3{xR2e$$Gxbp.IW=)0L5uatWx@ϻQ
@Rx@Pl&ݩd|];λ;i(cs?Z2놫mJ;})Ӹ_캸LC'~e0}ހ._'dߧ4s*C`O6҈T
UP;`j0Z)=#Xr2
OWH
ty"!RE%T#4m?̗57`|6	
zO`_P|mi!h9hZv᯸; &Dtwt,:%9>-VG%.Ro7[>[''<Bw<zi_>.$xD7{וs 8-慪 {U*\.hCc6+32ѹ	qL>ρ.ů,CpTÃ7iG׮q7Ժ_
φ6׭(>Ӌ:itӨÓwPz
(qMaHiEb拉]+E_f34=do:Fckb\A
?&XO,}'9lŹI؉Cpf﹈LSJ6l0N]+9k+d=>!S<o786Texa
C^wiږAvcov~Bq兦(RR*""J(b}ڬ4+>":Cf=,fݬ:NRK~";+50%`W~Q \(z=يE+
o	XuM驤Taфяjcw+wW)K&HD2>e7RՀ0yAf9w@,[2
V>-3p^3e
e\ˉR.Ռ-\n2iK"C;&|8hI$ZTK6Ҝĕe`=29H 30j;/:LoF8,.>~iue$Cft<~wԀR3$rN]a1oXҵD_ɤojяOu	d;S2`/|Swa	Fi6_4$Mp'B}3Tɉ5UL,0VJyvMΖ@GXT7UzF؋hKAWl.'!kkdt
m2\1h\)
<^V6D";m*]}ъpqz~n}*~[.	iwJ`<%O;m[m]SH<pצH/%ӐEL НHD"CPn o)4҆A#SWRK*H^0
x寑|i.4EDE޲0r-'_Q1c&h&Zw rDQL}xuv/KN@i(a6#ǢR/
-)ƵpnwcC{w҉ZOm_FQ?Ɇ
嚠93HmRf \'sAϊ;ХӋYzǞb0Bk+-!@^o7Mڞ۹O0`/~Y%ie7{wNM`Rgd'<ާ%pbR9qg+
	!L
j@ՋZ%raAR}rL,37Ydkj\"%"hX#-FQj =m
+v&Lq pْks]j}'l;	>q֚Mѹeޔ7"s',LI_{+N٣ÚIGӓ	Tvt+FHv(js ΆkV^`7?1GǻϗEIc5]	ǲ5oDM拆}
uҋQ7*cz`n?Ĝs{ou*!Pݕc~XT3a֒53n 1q#Dd7\](".m>PFn&UԜlJP/aCZc׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   H      }                        #=Byf[WsgqF oy|.'E6=3zToh@ǿyc'խBKSCT<ң]坆峮|	n+UnujrY$>ii[bcamuP35&Rʟt;)+E*%}0!`2Qn_RK~RoE@ɟuXV@|ɞRMߑkFƺ9uK@ay5q]{D 
+W;1Ucʹ8Hza4	L*♀6qTy}9ASƶƒO*BJH
݊c)<LƙCmR5lsErrmYڠW3ϑ/FH{yj&'4ɴl1ܿ3ڼg8BjNƒbȏVK
2M73@q=BC
ނsc2H7\>'So7ۢtv
uCapQ {qżs^jJ8ꧾ3#o1rf&ɱ2ȧ/QEʼq!
K,s<ɂ@eʱ۔Qd.}U
i( 
ٜ9frFˑTFm"򦉝z17ԇ%IJ}Тd'5JP˭$;?.Vσn/<%$Y-@.DUCRIMDwG	UR eE;Q(M^;|aRΘ8.^H4 tJc48w<$jk2M.g|5z߂JaAbS.˶G]ZzȜxH4q;!xND35p@Hnj;g4Ȭ0ϺYOeYɚ\i@d4
NV'H4W77s^:R	KaWyƀ]MC@E~b}>j?cԓTa5ovJ/G{?̡0&{er:_1ove3˃wh8 fˡO@Ζn6B&]Uy]hUV*ML缟JP<<DD蕋Z
=*)!Nh8&6FD# ml2p?OP=.66'Mp~*3k+:R%zF5\	f6=?x1VYvv~a}a,HQmRݜzNo.^A4Wd22:>qUK+PK?~$4WSTtD|"2D!/2n>p\5)mpTgrK<D}-i'"g/,wpr9{HW9М :t K*Tv$2lOwy{]% n"C9M(c *3CI6@c?/f*bK@
?[kM8t˓:w<%{"pA#J91FLMv')\xm;{aPPVnMA2ARl;4!ZɽX-K6%FV/;&͌yӃ%12u?hK͇Dn*"I0BeM7f	ߣ4Sm"o o=ేFȲ1w0{+*K;Wk6ƣ(IۀAl2Upa{E6,.\JiզBu%y
g38Ya5&R&md.y"gnM |x@w /J˦F0lҥo&z5iQ0&#N4^A6a;Qu%/RuWeG+WgVR+F`Z]s8x V[-T>H_
O};w]kwȒobm 2M\:p
x{xdCG:L_ ;KmojŘ:fd<.*e %@b1یyq骾Ǔ@W(C!ΪZDkb3LQ2 grG&^Z"E((XW*s5:MC[˪[G|5lױ/?`2V25V!F3*,$~M#r\,C3`W!.|VC2^J
><Xpnm܌x4#jftXzn6;A:cóݺcU 'tZnK#wp<3ȗINN؁syoSuQQS\GKxAClcb!?#{%WB:F-HlܐPGt} 8{)7F79y|c{I^You8WKނ97og, buJ&vza;p

t良/^e5N2f<ߤa'F=$բWp
]&uUސ99
\0I9<ѳNГn):}z

k<to]'A})L*~_x7BiVsQTW|z};3!lR[1[NKIKʐɰ]Sm2l[Hqp-jGɺ`d5IZjYUŸf#o ݸR`&6pжF-@K)	 "/`FTd	1a-9MǅZoxGQʍG!#P+|RJG1dUӋr֭EmE
TQlL	J0ۿdB۞PZsv]JF)׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H       fffsf fsf f
   fffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsffffsf fsf f
   ffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf f  tf3f)U  fsf 9r!f   tf   fLU  fsf f~fsf fsfff%   ff  g.02fU  fsf vrgfU  fsf  rRfU  fsf 8r=fU  fsf gr(fU  fsf rfU  fsf f fsff@Cg&;f(V  fsf f;V  fsf f   u
tsf fsffoV  fsf Rf@Cg&;fV  fsf zf   tt"ssŀ2ɀ@v8sfV  fsf  f@Cg&;f fsfs退@s,fW  fsf  f@Cg&;f fsfrBfQW  fsf pfdW  fsf  f   uf   t
f fsfr'@s+fW  fsf f@Cg&;f fsf$fAg&$;g&$;fBf u
g&'g&'g&f fsffffsf fsf f$Agf&;@gf&$;f3f tf@f   ufAg&fffffsf fsf f   gf&gf&   f~fsfBgf&f uff~fsf fsf猸N匋 f
   "猸N匋f   fY  fsf f   uf  g&t猸N匋f>Y  fsf 猸N匋fgY  fsf 猸N匋fY  fsf 猸N匋fY  fsf fY  fsf 猸N匋fY  fsf A	o猸N匋fZ  fsf o	F猸	N匋f@Z  fsf 	猸N匋fiZ  fsf U猸N匋fZ  fsf 猸N匋fZ  fsf *猸N匋fZ  fsf y猸N匋f
[  fsf P猸N匋f3f9[  fsf $猸N匋fb[  fsf f|[  fsf C
f: f	"f   f[  fsf f   uf  g&tfffsf fsf f   f   f \  fsf f~fsf\  fsf 
A猸N匋f4Lf  gf&f Lgf&fff,  g.fLg&g&'g&f\  fsf (1猸N匋f\  fsf 
猸N匋f\  fsf 	猸 N匋f\  fsf _i猸!N匋f]  fsf 猸"N匋f?]  fsf 猸#N匋fa]  fsf 猸$N匋f]  fsf u猸%N匋f]  fsf !猸&N匋f]  fsf "猸'N匋f]  fsf G猸(N匋f^  fsf  猸)N匋f-^  fsf &猸0N匋f   ufX^  fsf "猸1N匋fz^  fsf !猸2N匋f^  fsf &猸3N匋Ћ猸4N匋f^  fsf &猸5N匋f^  fsf 猸6N匋f_  fsf &猸7N匋f3_  fsf "'猸N匋 f%"f   t
fC1'1焋儺N匋f  f_  fsf tv$f  f_  fsf f  f_  fsf f  f_  fsf tf  f    ff   ff  fIuf  f(`  fsf 4f fsff   f  ff   fb`  fsf tff   f`  fsf Gf   tff̀   f Ag&u\f`  fsf %r8u=f`  fsf %u$f3f   u
ffuf  tf fsffLg&   f  tfOg& t'f   tfOg& tfOg& f  f{a  fsf $f  fa  fsf f  fa  fsf f  fa  fsf f  f    ff   ff  fIu fLg&  f fsff   fuff/b  fsf $t,fMb  fsf g$8uf   uffuf fsfff   ftfb  fsf $$tf@ff  uf fsfff   ftIfb  fsf #$<t,<t2fc  fsf #uf	ff	ff  uf fsfff   ft+
fVc  fsf ^#<t<tf
ff
ff  uf fsf8f   ftfc  fsf 
#t"ff  uf  tuf fsffffsf fsf ff @  f   fd  fsf h$t5<w&t<u ff @  ff    ff f:  f~fsfffsf fsf ff   f fd  fsf "2ff fff+ff4  g.fd  fsf !<  ff `  ffg.:w%g.Ffe  fsf !<  g.:Gv;fffcff `  f    f;thff `  ffff  "ffftfu	f   	f    fe  fsf 'f~fsf fsff3f@  ff `  f
fg.ff   2ff   f   ft6ff  fsf  < tff8fsftff  uffff fsff3f@  ff `  f
fg.ff   2ff   ft,ff  fsf  < t8sfwff  uff ff fsff3f@  ff `  f
fg.ff   2ff   ft,f3g  fsf < t8sfwff  uffff fsff   f    ft*fg  fsf $t<s
f   <tff  ufff fsff   ftfg  fsf uff  uf fsffffsf fsf f3f@  ff `  f
fg.ff   2ff   ft,$fwh  fsf =< t8sfw$ff  uf~fsffff fsffffsf fsf f3f@  ff `  f
fg.ff3f3f3f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t3f   t@ tfҌ  g.;sf3tff  T2fffff  f~fsff fsf3f   fu5f	ftfftf
fC  2ffg.<u f  t2kf  uff  uflj  fsf ,uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsffffsf fsf f   f    f   f%k  fsf f    f    3f   ftfYk  fsf fftfvk  fsf fftfk  fsf fftfk  fsf 8uf Bgf&'gf&f   4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   f~fsf fsffffsf fsf fLf   f3f3ftx2fsl  fsf At	ffffl  fsf <	rLаfl  fsf <
r1$,
	
2g&	ff  rf~fsff fsff   fm  fsf d稀uxf   f   f   tf    f   f    f   f   f  uf3f   uf   f   uf3 f   u|f   tf   f   f   tf   uVf   f   Hf   f   f  uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsffffsf fsf fLf3g&f   fu	ffffˌ  fg.f	ftf	f~fsf fsffffsf fsf fffsf fsf f3fLg&'sf   f   fo  fsf f%   f	ff Lgf&ffft
ft f Lgf&ff%ff  ff% `  f
ffff; ffgf&f L fffsf fsf f  fo  fsf $f  fo  fsf nf~fsfgf&fff   gf&f   gf&'jf~fsf~fsf fsffffsf fsf f Lgf&fff Lgf&fpfff  ftf  fthfp  fsf {f Lgf&fff{  tff  t+f Lgf&fpfffq  fsf f~fsf fsff|Cg&'g&fCg&'g&f`Cg&'g&flCg&' fCg&' fq  fsf fq  fsf fq  fsf 4f fsffBgf&f   fq  fsf < u	f   u}fr  fsf Zf@Cg&fCg&fBg&$g&_
ó{fAg&G$fAg&_
ócx 5f@Cg& 3fCg& 1fB$g&'g&g&gg&_ fA$g&gg&GfAg&gg&_f$Agf&@fAgf&@f$Agf&'fAgf&'fKgf&f fsffBg&'g& ff% `  f
fc  ffgf.gf.Vf Cf   gf&gf&Ggf&   gf&   ff fsff(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsff30t
0t}f  ffg.fDg&1f
  ffffg.fDg&g.FfDg&f3f{  0t	fffffffsf fsf ffDf   g.g&ff0   fDf   g.g&ff0   f  f~fsff Ef   gf.f@   ffffsf fsf f  ffffsf fsf f   gf.f~fsf~fsf0   ff@tf Efǀ   f{  f   gf.f Dgf&f%f
  gf&f Dgf&   f fsffff8Af   gf.ffAf   gf.f fsffffBf   gf.f fsff   fAg&' fAg&' ft#fffftf  ug&Pg&ff   tfAf  uf fsff@@gf&f0Bgf&f fsffffsf fsf f Agf&gf&'fAgf&gf&'f   tf Agf&   fhw  fsf 
f{w  fsf fw  fsf ff%   ffftfftfffff~fsfffsf fsf ff%   fffffff ffffffAgf&'gf&	fAgf&'gf&	f   ff% `  f= @  ufCfffAgf&'gf&	fAgf&'gf&	fAgf&'gf&  t fAgf&'gf&  t f3f Lg&$<ufff% `  f= @  ufff%   ffg.ڌ  fAgf&'g&	fAgf&'g&	f~fsfffsf fsf f3fff fff8ffff   fff  f
fff   fff `  f @  rf   fAgf&' gf&	fAgf&' gf&	ff% `  2f=    r\tfffsf fsf fLg&%f   ؃ ttKu
fuff~fsffAgf&'?gf&	fAgf&'?gf&	fAgf&'fAgf&'fAgf&f%   f
ff `  f
f  f tfw  ftf,  ff3 f+ff3ff%  ff `  ff  fgf.ffAgf&'   gf&	fAgf&'   gf&	f~fsf fsff$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsffffsf fsf fdAgf&   fAgf&   fLf3g&f   fp~  f~  fffsf fsf f fffˌ  fg.f   uf   t	f   ugf.zg&'gf.:g&'ff	ftf	gf.:g&'ff~fsfffsf fsf ffffό  fg.f	fu$f	gf.>g&ff~fsfffsf fsf if    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsffffsf fsf fff  f~fsfAff%  f   g&t3fAg&f   tf   f~  fsf LՋf   f+~  fsf V֨t	 v  v f   fZ~  fsf f~fsf fsf AAAAAAAAA	AAAfBgf&f%?f
 
  gf&fBgf&gf&gf&Pgf&fBf  ugf&   	gf&   f   ugf&   @	gf&   f  tf$Agf&   f   tfAgf&   f fsffBgf&@@  gf&   ff%f=  tfhAg&gfAg&gfK  ff%   fffhAgf.gf&'  gf&	fAgf&'  gf&	fgf.flAgf&'gf&	fAgf&'gf&	f fsffAg&' gf&0fAg&' g&0f$Agf&   fAgf&   fD@gf& f fsffBgf&'?gf&  fBg&@f Bgf&'gf&  ! f$Bgf&'gf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsff3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f    fŀ   uf   f   tf   fgf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f uf=   u fffsf fsf ff   ffAff~fs@f   tfffsf fsf f   t
 
 fgf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfgf&f~fsf Bgf&'gf&   f   f   tf 8  ffgf&f Bgf&'gf&   fgf&f}ifAf  fffgf.~gf.6g&? tg&g&&fAuf   t2f   uf8tf   tfff fsf AAAAAAAAf Bf   tgf&'gf&   fӄ  fsf 1f@@gf&'f0Bgf&'f8Bgf&'gf& f fsffAf   tg&f   tg&fAf   tg&f   tg&f fsff   uf   f   f Agf&'gf&	fAgf&'gf&	f fsff Bgf&   f fsff Dgf&'f fsffBgf&   fDgf&f Dgf&   f   f(  fsf Y<twf Bg&$uf Dgf&`f fsff  fn  fsf $f  f  fsf f fsf fŀ   u<f fsffffsf fsf  fff.0ffH $ttf~fsf fsf䐕 	
P`=P0E       I   &&&&&&&&""""""""333333333333333333333333DDDDDDDDDDDDDDDDDDDD        """""                                  DD D DDDDD D D DDDDD D DDD D DDDDD D D DDDDD D DDDDDDD D  DDDDDD D  D DDDDDDDD D  DDDDDD D  D DD3333 3333 3333 3333 3333DDDD DDDD DDDD DDDD DDDD    " " " " "                                                                		


 "$&(*-049		



!#&)-159?


!#%')(*,.02 !"#$%&'()+-/13579;=  	

	

 	
	



"%(+/258;>>>>>>		


"%(+/258;>>>>>>		


 "$&(*-049		



!#&)-159?                                                                                                    @                               "3D  , 0  @  P   P Q  P U  P      P    P       P    P       Pfffsf fsf f Lgf&ffff% `  f
f;|ff% `  ff% `  fff~fsf fsffffsf fsf 
f  f  fsf w3f   f   fsf $< t<tM<t! <sfNgf&f   t&f   fN  fsf 3$p2<u f   ft  fsf 
Ɗ< ufLg&'fNgf&f   uc   ff% `  f= @   f=    tf Lgf&f#f Lgf&ffufLg&'fu_f   f  fsf f
   fffsf fsf ff   fR  fsf Qf~fsf  ft  fsf %f  f  fsf Yó fNgf&f   t@&f   fď  fsf $p2<uf  f  fsf $
f  f  fsf Uf  f   fsf aĳ

f  f=  fsf Àf  fY  fsf Àf  fu  fsf f~fsf fsfnnfLg&nI)
. hῺ! jǐ {Ԑ f3n          D  @    L      @       H   H       `       T  
$   	L  R  	L  	L         	
    %   	  	 
   
   
   ā     Ё          (               $     (     	                    	       
H@,@      ā    Ё    (            $    (    4    8           @      
B  
B 
B0 T     T    T0 !   L     L    L0    D    P   X     `  D     X      P    D    X      P    h     `               	 J             
  @      I         	  	4@	04
    	' 
 
> 
H> 
> 
N> 4    	1 	 4	$	  	  	  	  	 
D1d 
B1e 
@1P 
# 	P 	          @  4 $       	4		 		0   4      @ 	
. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L  	 *         0      4p                                                        d  ` h   X  '      @@       A   \   Z 	  X 	     ? \   Z 	  X 	     ? \   Z 	  X 	     ?                                        '     >   !    8      ,B      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0           <fHf%f  $f$
tppqtwfcfupppppq}ffupppppqf  f  gffLggf^gfngnff   fܚfupppppq ؎gf
  flJfRfupppppqg-  f;)ffKff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аfқf% = ufvf faf %  fEfU../0./.	/`./a. /0./. B쨀u?fsf d< uffd< t<t
u掰ff䎊fȜffڜf掺<ufff >  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ怺N ^@'f3
f  i t
^
ppq<&uf  $f$
tpqq$q
p&q+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  $f$
а f  $f$
и f  $f$
аf  $f$
аf  $f$
и<f  ff| ff  @$f@$
= uQf  ff ff4g&`g&&g&f  H$fH$
и f  L$fL$
а08fffUN&N䄰`O'N䄰ON8tf  ff9 ff  ffL f N U
BJ<Zt. U
BJ<Z B0JBJU0
BJ<Z0BTJ1BJ2BJ3BJ4BJ5BJ7BJ B$JB$J&B J'B JB$JBJ(B J$BJLN33LN3N BJ<uj"BJ&BJ)BJBJ`BJaB8J0BJ)BJt8B B tf  ff    f8ffffv  8f  8對 f    < tgfSf  g&  u
gf&>uf[68YAF   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    焋猰怺N匋 so1 f    QsY 焋猰怺N匋fݢ  ffТ  f   tf ffݤ  rfBY 焋猰怺N匋Yf3gCۢf3f   焋猰怺N匋[fHrHf f焋猰怺N匋儰f焋猰怺N匋rfFf   f   r% 焋猰怺N匋(s 撰焋猰怺N匋3.&f  f   f焋猰怺N匋fSj(f[f   f   3f   f  焋猰怺N匋g&7(fFfCg焋猰怺N匋o&fPfSfQf   fQf3یffݢ  fYsfYf[fXSguݶ  ;u[fPfSfQfRfWf   f3یffݤ  	 pfBf   ۢf3g}ݶ    fgݤ  r%fG;wg}ݶ  f_fZfYf[fX                                   	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  )C vZ[XPSR Z-Z[XPSR  )C v
 K-Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
ɈD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ft+vugf&>tgf&6f٢ɰ &f+~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR   +  *Z[XSR  :'C vZ[PSRRZZ[XÃ<t  *  *  *PRt)t<ZXfPfSQfRV%&  &f3۹ f   gfdT gfdTgfdTgfdTf   &"UC v 4*  < c&qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f;fC f	CfGfff]X t fffC f	CfGf  ff;f_f^fZY[fXRfŋӃf3ӃZfPSQ  %fA vY[fXf` f;.t
f. b%  >%$C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f+  g&"  @v@ g&  s f+  > u&g&.  ug&.  ug&/  uD
f^Z[XÃ t                          /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         焋猰怺N匋儽9焋猰怺N匋儽3İf?%fIfUf_ðfkfu8ff f%"ff[Eİffff İfwfİfaf f
   `"	f   f3f30f  0f7-fbxf   f f    0f  f f   0fffP  0f  f   f    0f  f f   0	 f%"fff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.fX  
fc  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
              p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v f  G >f  ɸfaPSQV@݋L	;t	 P ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6ɻjs>t fafWf   g&D= g&D= f_`r r8 a`f@  gF
$&
gF
&ɻsw>taf`f  gF
$&
gF
&ɻs@f  g&|5  t>tVfarfWr<f_    f`fߴf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>߹ gf&D5 gf&fff>fXYsufa`fP  &ɹ gF
$
gF
fP  sF>tma        PȎf   > ttus>     >rfg   ( r  Z>Qff@>7fffrfff> wf   >ff%fAfff> trf> wf   >F>,'q>hff   fJ>A0>'>
ff  > ff'f6r$fff> trf> wѰf     F >uug>u`R D>u=/>u(f 
-  >	r  H
s 撰t X8|.Hb~&4IefSgef[gefPfR>u
.fZfXfSfR$$8u4@fZf[P$4XfPfSfRf@
 > u= 4tsfZf[fXË.usfZf[fXPR tċZXfSfRf@
 > uA :H@tBs*؃,-@u's.fZf[R쨜u	u
sZ                             "                               @  
     @  
 Uf`ircgf&=  f  gf&f  fffFffFff^fF   f  f,  f^fF   faUf`f  / gf&Fp  gf&F    gf&F`  fgf&~fA  gf.>f  fffFffFff~fF   f   f   f~fF   fVf   f  fVf  0 f    gf&f^f   fF  f    lff  0 f   gf&f^f   f8  f~fF"   fF   3f~gf ulfVfOLPHsf  . ff  ! f  ! f   fF  ff4 0  gf&f^f   f8  f~fF"   fF    f  g&]
  t
ucgf&  f% f   uLf   fZ  f~fF   fF   g f   ff  f~fF   fF   A faú`U` B<u(``B`apB`0B`f` f"4(  ؎Њf      f%"X 3؎faUf`f   f"  ؎ff3Ҍffh f  fPg6D* gf6|*fg6l* f%" 3؎ffa            `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva3b f
   `"	f3f3f   0 f%"	@ ttu! 0
 Ds3ig&+g&ô b uR Zts+R Z<u+R Z<u<uR  ZfSf. g;xxf[ú          Tf  ?   f  +   f     f  W  f   fHt	f쨎tf<w' H$tt
ffPf fЀfXfPRf 0ZfXfPg& g&gf&{gf&CXg&Cg&CXg&Cg&Cg&#sPR$ZXPR$ZXPR|$ZXPRnZXgfgfgfgf&Ggf  f  gf{Tg&s g&C   PHR            f`ffWgfǃ  #Eggfǃ  gfǃ  ܺgfǃ  vT2gfǃ  gf  gƃ   g  u	f@w4  f@f@f_gf   gffgffaf`fQgf;gdg&fGfXf7   f;wf+f@   f+f7g  f3ggf  fffgffgf&faf@   g  tf@gf3g  gf   f` gffgf@ ffgffgf3fgf3fgf3fgf@rfaf`gf  gf  f   gf3fSgf  gf  gf  wff#ff#ffyZ?'wf3f3fn,;wfPf#f#ffXf#ffܼf3f3fbf[gf  fgf   gf  fffPgf  gf  gf  gf  gf  fgf  gf  gf  fXgf  AP
gf  gf   gfgf&ffa  fPfSfQfR3Yf  @]f  $f$
f  ܺ$f$
ЋfZfYf[fXfPfRfS3f @ Uf  $f$
؃f  ܺ$f$
Ћf[fZfXfSfW3f3f  Bg&cg&C
uf_f[
P.>u.  t. .6XðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X               .V.^ð@ ð  fSfQfWf36>t	f  se>tf  rf  sJg&C g&Cf  @@tf  G f   f  G 	f  W g&s g&C f_fYf[fSfQf3>t	f  sK>tf  rf  s0g&C g&Cf  @qf  g@<tbg&s g&C fYf[fSfQf3.>t	f  sk>tf  rf  sPff?g&Lg&D<?u9g&C g&Cg&Kf  @fg@?fg&s g&C fYf[Q f  / f  fPQgf0f  f    n YfXf    fPSfRff  ! gf&V2gf&;Ftg&~ u
u
gf&vfgf&NfZ[fXgf~gfNgfVgfÅfPfSfQfWK<w#f.5
tf:f_fYf[fX焋猰怺N匋fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fXfQfWfVf @  f   f  gff^f_fYfQfWfVf   f    f  gff^f_fY                           0 k PS㋇􋇚[XPSQRW0  3  3  3  3_ZY[XPSȎػ       !    A    a   f   /       w  l[XR # 1 ZSQW   '_Y[SQW   _Y[SQW   _Y[SQW   _Y[         PUN
NNOపNzXfPR3t3$UNN<Uu#NNO<u N҉ZfXfPQRU0
BJ<ZuW0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$w u-@u&UNN<Uu$NNO<u Nu3҉t;B B t	 ZYfXPRt ZX               焋猰怺N匋3ظ  м{x fڦffǦfBf鴦f                                           Q  YPSR+;wZ[Xf> tftf`f  
tf  f    f3f3f3f @ gfffCgftftfaf   {fuQYfVfSfQfݢ  f   fSrffYf[f^          fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     2ø     5  @     07/28/06YFA*<  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        