%define ver      1.0.9a
%define rel      1

Summary: Advanced Linux Sound Architecture (ALSA) - Utils
Name: alsa-utils
Version: %ver
Release: %rel
Copyright: GPL
Group: System/Libraries
Source: ftp://ftp.alsa-project.org/pub/utils/alsa-utils-%{ver}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
URL: http://www.alsa-project.org
Requires: alsa-driver alsa-lib ncurses
BuildRequires: alsa-lib-devel ncurses-devel

%description

Advanced Linux Sound Architecture (ALSA) - Utils

%changelog
* Tue Nov 25 2003 Ronny V. Vindenes <sublett@amigascne.org>
- include all manpages

* Thu Mar  6 2003 Ronny V. Vindenes <sublett@dc-s.com>

- removed wrongly included doc file
- changed BuildRoot from /var/tmp to _tmppath
- use standard rpm macros for build & install section
- updated dependencies

* Tue Nov 20 2001 Jaroslav Kysela <perex@suse.cz>

- changed BuildRoot from /tmp to /var/tmp
- _prefix and _mandir macros are used for configure and mkdir
- DESTDIR is used for make install

* Sun Nov 11 2001 Miroslav Benes <mbenes@tenez.cz>

- dangerous command "rpm -rf $RPM_BUILD_ROOT" checks $RPM_BUILD_ROOT variable
- unset key "Docdir" - on some new systems are documentation in /usr/share/doc

* Mon May 28 1998 Helge Jensen <slog@slog.dk>

- Made SPEC file

%prep
%setup
%build
%configure
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
%makeinstall

%post
/usr/share/doc/alsa-driver-1.0.11/snddevices > /tmp/snddevices.log 2>&1
                                                                                              
#
# Copyright 2006, Hewlett-Packard Company
#
# Create a local copy of alsaconf for non-interactive installs
                                                                                              
                                                                                              
                                                                                              
export PATH=/tmp:$PATH
ALSACONF=/usr/sbin/alsaconf
LOCALALSACONF=/tmp/alsaconf.local
DIALOG=/tmp/dialog
MODULESDOTCONF=/etc/modules.conf
LOCALMOD=/tmp/modules.conf

cat > $DIALOG << _DEOF
#!/bin/sh
#
# Copyright 2006, Hewlett-Packard Company
#
# Pseudo non-interactive dialog replacement for RPM installs
# Make certain that this is your current execution path FIRST!
                                                                                              
case "\$1" in
    --msgbox)
        # Debug only
        # echo "DIALOG msgbox:" \$2
        ;;
    --gauge)
        # Debug only
        # echo "DIALOG gauge:" \$2
        # Consume stdin while we can as required (bogus gauge)
         while read i; do
             echo "" > /dev/null        # do nothing
         done
        ;;
    --yesno)
        # In this case, always return "yes" (we assume this
        # this is what we want for all responses)
        # Debug only
        # echo "DIALOG yesno:" \$2
        exit 0
        # "no" would be
        # exit 1
        ;;
    --title)
        # Do nothing for this request right now
        ;;
esac
                                                                                              
# Return zero on all other calls
exit 0
                                                                                              
                                                                                              
                                                                                              
                                                                                              
_DEOF
# Make this pseudo-dialog script executable
chmod 755 $DIALOG
                                                                                              
                                                                                              
if [ -x $ALSACONF ]; then
    # change shell to sh to force inheritance of PATH variable
    cat $ALSACONF | sed -e 's/bash/sh/' > $LOCALALSACONF
    chmod 755 $LOCALALSACONF
                                                                                              
                                                                                              
                                                                                              
                                                                                              
    # execute this with defaults (assumes "yes" for all responses)
    $LOCALALSACONF > /tmp/alsaconf.log 2>&1
                                                                                              
                                                                                              
                                                                                              
                                                                                              
    # clean /etc/modules.conf of all blank lines for Firstboot
    /bin/sed '/^$/d' < $MODULESDOTCONF > $LOCALMOD
    /bin/cat $LOCALMOD > $MODULESDOTCONF
                                                                                              
    # cleanup
    rm -f $LOCALALSACONF $DIALOG $LOCALMOD
fi
 

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

/usr/share/alsa/speaker-test/sample_map.csv
   /usr/share/locale/ja/LC_MESSAGES/alsaconf.mo
   /usr/share/man/fr/man8/alsaconf.8.gz
   /usr/share/sounds/alsa/Front_Center.wav
   /usr/share/sounds/alsa/Front_Left.wav
   /usr/share/sounds/alsa/Front_Right.wav
   /usr/share/sounds/alsa/Noise.wav
   /usr/share/sounds/alsa/Rear_Center.wav
   /usr/share/sounds/alsa/Rear_Left.wav
   /usr/share/sounds/alsa/Rear_Right.wav
   /usr/share/sounds/alsa/Side_Left.wav
   /usr/share/sounds/alsa/Side_Right.wav

%doc ChangeLog COPYING README

%{_prefix}/sbin/*
%{_prefix}/bin/*
%{_mandir}/man?/*
