' VB Script accessing RootDSE object to show all associated properties       '
'                                                                            '
' Version 1.00 - Alain Lissoir                                               '
' Compaq Computer Corporation - Professional Services - Belgium -            '
'                                                                            '
' Any comments or questions:                  EMail:alain.lissoir@compaq.com '

Option Explicit

Dim objRoot
Dim strMember

' -------------------------------------------------------------------------------------------
WScript.Echo

WScript.Echo "Script RootDSE.vbs showing some RootDSE properties"
WScript.Echo

Set objRoot = GetObject("LDAP://RootDSE")

' If we contact an Exchange server, we do not get an error for the Windows 2000 related properties.
On Error Resume Next

' These properties are Windows 2000 related.
WScript.Echo "configurationNamingContext='" & objRoot.Get("configurationNamingContext") & "'"
WScript.Echo "RootDomainNamingContext='" & objRoot.Get("RootDomainNamingContext") & "'"
WScript.Echo "schemaNamingContext='" & objRoot.Get("schemaNamingContext") & "'"

' These properties are Windows 2000 and Exchange 5.5 related.
WScript.Echo "DefaultNamingContext='" & objRoot.Get("DefaultNamingContext") & "'"
WScript.Echo "currentTime='" & objRoot.Get("currentTime") & "'"
WScript.Echo "subschemaSubentry='" & objRoot.Get("subschemaSubentry") & "'"
WScript.Echo "defaultNamingContext='" & objRoot.Get("defaultNamingContext") & "'"
WScript.Echo "HighestCommittedUSN='" & objRoot.Get("HighestCommittedUSN") & "'"

' We use a loop to examine a multi-valued property, so we get all the values
For Each strMember In objRoot.Get("SupportedControl")
    WScript.Echo "SupportedControl='" & strMember & "'"
Next

' We use a loop to examine a multi-valued property, so we get all the values
For Each strMember In objRoot.Get("namingContexts")
    WScript.Echo "namingContexts='" & strMember & "'"
Next

Set objRoot = Nothing

WScript.Quit (0)