' VB Script loading all objects from an AD context location into an Excel sheet '
' (with properties and syntaxes)                                                '
'                                                                               '
' Version 1.00 - Alain Lissoir                                                  '
' Compaq Computer Corporation - Professional Services - Belgium -               '
'                                                                               '
' Any comments or questions:                     EMail:alain.lissoir@compaq.com '

Option Explicit

' Set this constant to zero, if you don't want indentation in the Excel Sheet
Const cIndent = 1

' --------------------------------------------------------------------------------------------
Dim    ObjRoot
Dim    strObject
Dim    strContext
Dim    intX
Public intY

' --------------------------------------------------------------------------------------------
' Start the Excel Worksheet reading
Public objXL

' Bind to an Excel worksheet object
Set objXL = WScript.CreateObject("EXCEL.application")

' Make it visible
objXL.Visible = True

' Open Excel and start an empty workbook
objXL.workbooks.Add

' Put the cursor on the A1 cell
objXL.ActiveSheet.range("A1").Activate

' --------------------------------------------------------------------------------------------
intY = 0
intX = 0

' Read RootDSE
Set objRoot = GetObject("LDAP://RootDSE")

Dim objArgs

Set objArgs = Wscript.Arguments

If objArgs.Count = 0 Then
   ' Prompt for the start point in the Active Directory, by default: "DefaultNamingContext"
   strContext = "DefaultNamingContext"
   strObject = objRoot.Get(strContext)
   strObject = PromptBasicParameters ("Enter the Active Directory start point: ", _
                                      "Active Directory start point:", strObject)
Else
   strObject = objArgs (0)
End if

WScript.DisconnectObject objArgs
Set objArgs = Nothing

WScript.Echo strObject
objXL.activecell.offset(intY, intX).Value = strObject

Call LookInsideObject ("LDAP://" & strObject , intX + cIndent)
WScript.Echo

Set objRoot = Nothing

' Close the Workbook, this will prompt the user to choose where to save the generated XLS.
objXL.workbooks.close
objXL.Quit
WScript.DisconnectObject objXL
Set objXL = Nothing

WScript.Quit (0)

' --------------------------------------------------------------------------------------------
Private Sub LookInsideObject (strObject, intX)

Dim objObject
Dim objObjectClass
Dim objMember

        Set objObject = GetObject(strObject)
        Set objObjectClass = GetObject(objObject.Schema)

        WScript.Echo Space (intX) & objObject.Name
        Call GetMemberInfo (objObject, objObjectClass, intX)

        For Each objMember in objObject
            Call LookInsideObject (objMember.ADsPath, intX + cIndent)
        Next

        Set objObjectClass = Nothing
        Set objObject = Nothing

End Sub

' --------------------------------------------------------------------------------------------
Private Sub GetMemberInfo (objObject, objObjectClass, intX)

        intY = intY + 1

        objXL.activecell.offset(intY, intX).Value = objObject.Name
        objXL.activecell.offset(intY, intX + 1).Value = objObject.Class
        objXL.activecell.offset(intY, intX + 2).Value = objObject.ADsPath

        ' Show object's mandatory properties with syntax
        Call LoadPropertiesInXL (objObjectClass.MandatoryProperties, objObjectClass, intX)

        ' Show object's optional properties with syntax
        Call LoadPropertiesInXL (objObjectClass.OptionalProperties, objObjectClass, intX)

End Sub

' --------------------------------------------------------------------------------------------
Private Sub LoadPropertiesInXL (PropertyList, objObjectClass, intX)

Dim strProperty
Dim objProperty

        For Each strProperty in PropertyList
            Set objProperty = GetObject(objObjectClass.Parent + "/" + strProperty)

            intY = intY + 1
            objXL.activecell.offset(intY, intX).Value = objProperty.Name
            objXL.activecell.offset(intY, intX + 1).Value = objProperty.Syntax
            objXL.activecell.offset(intY, intX + 2).Value = objProperty.Multivalued

            Set objProperty = Nothing
        Next

End Sub

' --------------------------------------------------------------------------------------------
Private Function PromptBasicParameters (strTitle, strPrompt, strInitial)

Dim strInput

        strInput = InputBox (strTitle, strPrompt, strInitial)

        If strInput = "" Then
           Wscript.Echo "Sorry, but you didn't enter anything !"
           WScript.Quit (0)
        Else
           PromptBasicParameters = strInput
        End If

End Function