' VB Script creating Security Descriptor for Active Directory objects and        '
' saving it in the associated Security Descriptor property                       '
' (Exchange 2000 mailbox or Active Directory object are supported)               '
'                                                                                '
' Version 1.00 - Alain Lissoir                                                   '
' Compaq Computer Corporation - Professional Services - Belgium -                '
'                                                                                '
' Any comments or questions:                      EMail:alain.lissoir@compaq.com '

Option Explicit

' -----------------------------------------------------------------------------------------------------------
Public Sub SetSD(varObject, ACE_Entries, strObjectType)

        Dim objSecurity
        Dim objSD
        Dim objDACL
        Dim objACE
        Dim intIndice

        Select Case strObjectType
               Case AD_OBJECT, MB_OBJECT

               Case Else
                    Exit Sub
        End Select

        Set objSD = CreateObject("SecurityDescriptor")
        Set objDACL = CreateObject("AccessControlList")

        objDACL.AceCount = Ubound (ACE_Entries) / 4
        objDACL.AclRevision = ADS_ACL_REVISION_DS

        For intIndice = 0 To (Ubound (ACE_Entries) - 1) Step 4
            ' Create an Access Control Entry (ACE_Entries)
            Set objACE = CreateObject("AccessControlEntry")

            objACE.Trustee = ACE_Entries (intIndice)
            objACE.AceType = ACE_Entries (intIndice + 1)
            objACE.AccessMask = ACE_Entries (intIndice + 2)
            objACE.AceFlags = ACE_Entries (intIndice + 3)

            ' Add the newly created ACE objects to the new access-control list (ACL)
            objDACL.AddAce objACE

            WScript.DisconnectObject objACE
            Set objACE = Nothing
        Next

        ' Use the created DACL instead of the default.
        objSD.Revision = ADS_SD_REVISION_DS
        objSD.OwnerDefaulted = True
        objSD.GroupDefaulted = True
        objSD.DaclDefaulted = False
        objSD.SaclDefaulted = True
        objSD.DiscretionaryAcl = objDACL

        Select Case strObjectType
               Case AD_OBJECT
                    varObject.Put "nTSecurityDescriptor", objSD
                    varObject.SetInfo
                    Wscript.Echo "  Security Descriptor for AD object initialized."
               Case MB_OBJECT
                    varObject.Put "msExchMailboxSecurityDescriptor", (objSD)
                    varObject.SetInfo
                    Wscript.Echo "  Security Descriptor for MB object initialized."
        End Select

        WScript.DisconnectObject objDACL
        Set objDACL = Nothing

        WScript.DisconnectObject objSD
        Set objSD = Nothing

End Sub