; File Manager and related sub-routines for CPE
; Copyright (c) 1997 by Ulrich Doewich
; cyrel@interlog.com

;  v0.01  Jan. 11, 1997 - 18:09  fixed quick sort algorithm
;  v0.02  Jan. 14, 1997 - 23:13  implemented jump to file name on alpha keys
;  v0.03  Jan. 18, 1997 - 21:39  archive support + file system cleanup code
;  v0.04  Jan. 21, 1997 - 19:23  optimized select_file
;  v0.05  Jan. 23, 1997 - 23:34  highlighting found letters
;  v0.06  Jan. 27, 1997 - 23:03  fixed returning to root w/ directory highlight
;  v0.07  Feb.  1, 1997 - 00:46  safeguards against improper path specifications
;  v0.08  Feb.  2, 1997 - 13:07  code cleanup
;  v0.09  Feb.  5, 1997 - 23:04  code cleanup
;  v0.10  Feb.  9, 1997 - 20:02  reordered code; image/snapshot selector callup
;  v0.11  Feb. 10, 1997 - 23:50  coded snapshot selector routines
;  v0.12  Feb. 11, 1997 - 21:19  snapshot loading
;  v0.13  Feb. 12, 1997 - 23:24  snapshot saving
;  v0.14  Feb. 15, 1997 - 16:29  write protect and side toggle
;  v0.15  Feb. 24, 1997 - 23:38  delete file under cursor option
;  v0.16  Mar.  2, 1997 - 19:46  new ZIP handling; changes to selection process
;  v0.17  Mar.  3, 1997 - 23:35  temp dir cleanup; fixed access to other drives
;  v0.18  Mar. 11, 1997 - 14:35  converted source from variable to fixed tabs
;  v0.19  Mar. 11, 1997 - 20:03  fixed temp dir cleanup; support for lower-case
;				 filenames in ZIPs; fixed alternate drive access
;  v0.20  Mar. 11, 1997 - 22:13  added VESA mode screen handling routines
;  v0.21  Mar. 17, 1997 - 16:51  fixed DTA handling when searching directories
;  v0.22  Mar. 23, 1997 - 16:49  changed all highlighting calls to print_string
;  v0.23  Mar. 25, 1997 - 21:35  temp snapshot cleanup; non-sequencial drives
;  v0.24  Mar. 28, 1997 - 16:01  independent ZIP processing for DSKs & SNApshots
;  v0.25  Apr.  9, 1997 - 22:46  fixed handling of 5+ files in ZIP archives
;  v0.26  Apr.  9, 1997 - 23:03  fixed display of drives Y & Z in file listing
;  v0.27  Apr. 20, 1997 - 00:10  delete file prompts for confirmation

;  v1.00  Apr. 28, 1997 - 11:19  first public release

ideal
P386

include		"globals.inc"

STR_WIDTH	equ	12

MAX_FILES	equ	1000
SCR_LENGTH	equ	25
TEXT_COLOUR	equ	7

NORMAL		equ	0
ARCHIVE		equ	1

ESC_KEY		equ	01h
BACK_KEY	equ	0eh
SIDE_KEY	equ	0fh
YES_KEY		equ	15h
SELECT_KEY	equ	1ch
WPTOGGLE_KEY	equ	39h
HOME_KEY	equ	47h
UP_KEY		equ	48h
PGUP_KEY	equ	49h
EJECT_KEY	equ	4Ah
LEFT_KEY	equ	4bh
RIGHT_KEY	equ	4dh
END_KEY		equ	4fh
DOWN_KEY	equ	50h
PGDOWN_KEY	equ	51h
INSERT_KEY	equ	52h
DELETE_KEY	equ	53h

LAST_KEY	equ	32h

; from fdc.asm
extrn		open_disk:PROC, close_disk:PROC
extrn		track_tableA:WORD, track_tableB:WORD

; from ipe1.asm
extrn		OpenTextScr:PROC, RestoreScreen:PROC
extrn		move_scrpos:WORD, print_string:WORD, scr_colour:WORD

; from misc.asm
extrn		ClearKeyMap:PROC
extrn		keycode:BYTE

; from snd.asm
extrn		sound_pause:WORD, sound_continue:WORD

; from tape.asm
extrn		TapeBuffer:WORD


public		init_filesys, select_file, restore_snapshot, store_snapshot
public		cleanup_filesys

public		current_drv, CPCa_pos, CPCb_pos
public		rsnap_handle, rsnap_name, ssnap_handle, ssnap_name, buffer, name_table

group DGROUP	_stack, _data

segment		_text page public 'CODE'
assume		cs:_text
assume		ds:DGROUP

; ________________________________________________________________________

select_image:
		mov	si, [current_drv]
		cmp	[byte ptr si + FSACCESS_offs], ARCHIVE
		jne	si_initnormal
		call	zip_info
		jmp	si_initscr
si_initnormal:
		call	fill_name_table
si_initscr:
		mov	[search_offs], 0

		mov	si, offset scr_layout		; normal screen layout
		cmp	[current_drv], offset CPCb_pos	; snapshot menu?
		jle	si_slloop
		mov	si, offset rsnap_layout		; restore screen layout
		cmp	[current_drv], offset ssnap_pos
		jne	si_slloop
		mov	si, offset ssnap_layout		; store screen layout
si_slloop:
		mov	ax, [si]			; get screen position
		cmp	ax, 0ffffh			; end of screen layout?
		je	si_sldone
		call	[move_scrpos]
		add	si, 2				; skip position
		mov	bl, 0				; 0 terminated string
		call	[print_string]
		jmp	si_slloop
si_sldone:
		mov	si, [current_drv]
		mov	ax, [si + POS_offs]		; initial table position
		mov	[current_pos], ax
		mov	ax, [si + ROW_offs]		; initial screen row
		mov	[current_ROW], ax
		cmp	si, offset CPCb_pos		; snapshot menu?
		jg	si_loop

		call	update_screen			; highlight drive A or B
		mov	si, offset CPCa_pos		; show image infos..
		call	update_diskinfo
		mov	si, offset CPCb_pos
		call	update_diskinfo
		
; ........................................................................

si_loop:
		mov	[byte ptr scr_colour], 1fh
		call	print_names			; print file name column

		mov	cx, [search_offs]
		or	cx, cx				; search in progress?
		jz	si_getkey
		mov	ax, [current_row]		; paint search highlight
		mov	ah, 2				;  on current row..
		call	[move_scrpos]
		mov	si, offset search_str
		mov	bl, cl				; string length
		mov	cl, 4fh
		call	[print_string]
si_getkey:
		mov	[keycode], 0			; clear input
si_getkeyloop:
		mov	ah, [keycode]
		or	ah, ah				; was any key pressed?
		jz	si_getkeyloop

; ........................................................................

		cmp	ah, UP_KEY
		jne	si_notup
		cmp	[current_pos], 0		; already at the top?
		je	si_getkey

		cmp	[current_row], 0		; cursor at the top?
		je	si_upattop
		dec	[current_row]			; move cursor
si_upattop:
		dec	[current_pos]			; move table pointer
		jmp	si_next
si_notup:

; ........................................................................

		cmp	ah, DOWN_KEY
		jne	si_notdown
		mov	ax, [entries]
		or	ax, ax
		jz	si_getkey
		dec	ax
		cmp	ax, [current_pos]		; reached end of list?
		je	si_getkey

		cmp	[current_row], SCR_LENGTH-1	; cursor at bottom?
		je	si_downatbottom
		inc	[current_row]			; move cursor
si_downatbottom:
		inc	[current_pos]			; move table pointer
		jmp	si_next
si_notdown:

; ........................................................................

		cmp	ah, PGUP_KEY
		jne	si_notpgup
		cmp	[current_pos], 0		; already at the top?
		je	si_getkey

		cmp	[current_row], 0		; cursor at top?
		je	si_pgupattop
		mov	ax, [current_row]		; move cursor to top
		sub	[current_pos], ax		;  of screen..
		mov	[current_row], 0
		jmp	si_next
si_pgupattop:
		mov	ax, [current_pos]		; move table pointer
		sub	ax, SCR_LENGTH			;  by one screen length
		jnc	si_pgupdone
		mov	ax, 0
si_pgupdone:
		mov	[current_pos], ax
		jmp	si_next
si_notpgup:

; ........................................................................

		cmp	ah, PGDOWN_KEY
		jne	si_notpgdown
		mov	ax, [entries]
		or	ax, ax
		jz	si_getkey
		dec	ax
		cmp	ax, [current_pos]		; reached end of list?
		je	si_getkey

		cmp	[current_row], SCR_LENGTH-1	; cursor at bottom?
		je	si_pgdownatbottom
		mov	ax, SCR_LENGTH-1		; move cursor to bottom
		sub	ax, [current_row]		;  of screen..
		add	ax, [current_pos]
		mov	bx, [entries]
		dec	bx
		cmp	ax, bx				; beyond end of list?
		jle	si_pgdowndone
		mov	ax, bx
		mov	[current_pos], ax		; set to end of list..
		mov	[current_row], ax
		jmp	si_next
si_pgdownatbottom:
		mov	ax, [current_pos]		; move table pointer
		add	ax, SCR_LENGTH			;  by one screen length
		cmp	ax, [entries]
		jl	si_pgdowndone
		mov	ax, [entries]
		dec	ax
si_pgdowndone:
		mov	[current_pos], ax
		mov	[current_row], SCR_LENGTH-1
		jmp	si_next
si_notpgdown:

; ........................................................................

		cmp	ah, HOME_KEY
		jne	si_nothome
		cmp	[current_pos], 0		; already at the top?
		je	si_getkey

		mov	[current_row], 0		; move cursor and table
		mov	[current_pos], 0		;  pointer to the top
		jmp	si_next
si_nothome:

; ........................................................................

		cmp	ah, END_KEY
		jne	si_notend
		mov	ax, [entries]
		or	ax, ax
		jz	si_getkey
		dec	ax
		mov	[current_row], SCR_LENGTH-1
		cmp	ax, SCR_LENGTH-1		; less than scr length?
		jge	si_endmore
		mov	[current_row], ax		; set cursor to end
si_endmore:
		mov	[current_pos], ax		; set table pointer
		jmp	si_next
si_notend:

; ........................................................................

		cmp	ah, RIGHT_KEY
		jne	si_notright
		cmp	[current_drv], offset CPCa_pos	; viewing drive B?
		jne	si_getkey

		mov	ax, [current_row]		; store current
		mov	[CPCa_row], ax			;  position..
		mov	ax, [current_pos]
		mov	[CPCa_pos], ax
		mov	si, offset CPCb_pos
si_redolist:
		mov	[current_drv], si		; restore old position..
		call	update_screen			; update drive highlight
		mov	ax, [si + ROW_offs]
		mov	[current_row], ax
		mov	ax, [si + POS_offs]
si_filllist:
		mov	[current_pos], ax
		cmp	[byte ptr si + FSACCESS_offs], ARCHIVE
		jne	si_dispnormal
		call	zip_info
		mov	[search_offs], 0		; clear search
		jmp	si_loop
si_dispnormal:
		call	fill_name_table			; update listing
si_next:
		mov	[search_offs], 0		; clear search
		jmp	si_loop
si_notright:

; ........................................................................

		cmp	ah, LEFT_KEY
		jne	si_notleft
		cmp	[current_drv], offset CPCb_pos	; viewing drive A?
		jne	si_getkey

		mov	ax, [current_row]		; store current
		mov	[CPCb_row], ax			;  position..
		mov	ax, [current_pos]
		mov	[CPCb_pos], ax
		mov	si, offset CPCa_pos
		jmp	si_redolist
si_notleft:

; ........................................................................

		cmp	ah, BACK_KEY
		jne	si_notback

		mov	bx, [search_offs]
		or	bx, bx				; not searching?
		jz	si_backcont
		dec	bx
		mov	[byte ptr search_str + bx], 0	; delete last letter
		mov	[search_offs], bx
		mov	[current_pos], 0		; start search at the
		mov	[current_row], 0		;  top of the list..
		call	find_str
		jmp	si_loop
si_backcont:
		mov	si, [current_drv]
		cmp	[byte ptr si + FSACCESS_offs], ARCHIVE
		jne	si_backnotARC
		mov	[byte ptr si + FSACCESS_offs], NORMAL

		call	fill_name_table			; update listing
		mov	si, [current_drv]
		mov	ax, [si + ARCPOS_offs]		; place cursor on
		mov	[current_pos], ax		;  archive name..
		mov	ax, [si + ARCROW_offs]
		mov	[current_row], ax
		mov	[search_offs], 0		; clear search
		jmp	si_loop
si_backnotARC:
		call	parse_dirstr			; determine path end
		mov	bx, cx				; last name on path
		inc	bx				; skip over '\'
		mov	dx, si
		add	si, bx				; copy directory name
		mov	di, offset search_str		;  to search string..
		call	copy_str
		mov	[byte ptr di + bx], 0
		mov	[search_offs], bx
		or	cx, cx				; at root level?
		jnz	si_backnotatroot
		inc	cx				; skip over '\'
si_backnotatroot:
		mov	bx, cx
		mov	si, dx
		mov	[byte ptr si + bx], 0		; shorten path string
		call	fill_name_table			; update listing

		mov	[current_pos], 0		; start search at the
		mov	[current_row], 0		;  top of the list..
		call	find_str
		mov	[search_offs], 0		; clear search
		jmp	si_loop
si_notback:

; ........................................................................

		cmp	ah, SELECT_KEY
		jne	si_notselect
		cmp	[entries], 0			; no entries?
		je	si_getkey
		mov	ax, [current_pos]
		cmp	ax, [drvs_start]		; in drive listing?
		jge	si_seldrv
		cmp	ax, [dirs_start]		; in directory listing?
		jge	si_seldir
si_selfile:
		mov	si, offset name_table		; calculate string
		shl	ax, 2				;  position in table..
		add	si, ax
		shl	ax, 1
		add	si, ax
		mov	eax, 'PIZ '			; ZIP extension
		cmp	eax, [dword ptr si + 8]		; archive selected?
		jne	si_notARC
		cmp	[valid_tempath], 1		; valid temp path?
		jne	si_getkey

		mov	di, [current_drv]
		mov	[byte ptr di + FSACCESS_offs], ARCHIVE
		mov	ax, [current_pos]		; save file list
		mov	[di + ARCPOS_offs], ax		;  position..
		mov	ax, [current_row]
		mov	[di + ARCROW_offs], ax
		mov	ax, [drive_str]			; copy filename..
		mov	[word ptr di + ARCNAME_offs], ax
		add	di, ARCNAME_offs+2
		call	trans_name
		mov	[byte ptr di + 8], '.'

		call	zip_info			; get ZIP directory

		mov	[current_pos], 0
		mov	[current_row], 0
		mov	[search_offs], 0
		jmp	si_loop
si_notARC:
		mov	di, [current_drv]
		cmp	[byte ptr di + ORIGIN_offs], ARCHIVE
		jne	si_donotdelete
		call	close_disk			; close active image
		mov	dx, offset temp_path
		mov	ah, 3bh				; set current directory
		int	21h
		mov	dx, di
		add	dx, NAME_offs
		mov	ax, 4100h			; delete file
		int	21h
		mov	dx, di
		add	dx, DRIVE_offs
		mov	ah, 3bh				; set current directory
		int	21h
si_donotdelete:
		mov	[byte ptr di + ORIGIN_offs], NORMAL

		mov	ax, [word ptr drive_str]
		mov	[word ptr di + NAME_offs], ax
		add	di, NAME_offs+2
		call	trans_name
		mov	[byte ptr di + 8], '.'

		cmp	[byte ptr di + FSACCESS_offs-(NAME_offs+2)], ARCHIVE
		jne	si_normal
		mov	ax, [word ptr temp_path]
		mov	[word ptr di + NAME_offs-(NAME_offs+2)], ax
		mov	cx, di
		mov	ax, [word ptr drive_str]
		mov	[word ptr cmd_arcdrv], ax
		mov	si, di
		add	si, ARCNAME_offs+2 - (NAME_offs+2)
		mov	di, offset cmd_arcname
		call	trans_name
		mov	si, cx
		mov	di, offset cmd_filename
		call	prep4zip
		mov	di, cx

		mov	ax, 4400h			; get device information
		mov	bx, 1				; standard output
		int	21h
		mov	[device_attrib], dx
		mov	ax, 4401h			; set device information
		mov	bx, 1
		and	dx, 0fdh			; clear standard output
		or	dx, 4				; set to NUL device
		int	21h

		pushad
		push	es
		mov	dx, offset cmd_path
		mov	ax, ds
		mov	es, ax
		mov	bx, offset cmd_paras
		mov	[tempSS], ss
		mov	[tempSP], sp
		mov	ax, 4b00h			; load & EXECute
		int	21h
		mov	ss, [tempSS]
		mov	sp, [tempSP]
		pop	es
		popad

		mov	ax, 4401h			; set device information
		mov	bx, 1				; standard output
		mov	dx, [device_attrib]
		and	dx, 0ffh
		int	21h				; restore original state

		mov	dx, offset temp_path		; change to temp dir
		mov	ah, 3bh				; set current directory
		int	21h

		mov	[byte ptr di + ORIGIN_offs-(NAME_offs+2)], ARCHIVE
si_normal:
		cmp	[current_drv], offset CPCb_pos
		jg	si_opensnap
		mov	[byte ptr di + TYPE_offs-(NAME_offs+2)], MVNORM
		cmp	[dword ptr di + 8], 'KSD.'
		je	si_opendisk
		cmp	[dword ptr di + 8], 'ksd.'
		je	si_opendisk
		mov	[byte ptr di + TYPE_offs-(NAME_offs+2)], BSNORM
si_opendisk:
		call	open_disk			; attempt to open image
		jnc	si_exit
si_opendiskerr:
		mov	si, [current_drv]
		call	update_diskinfo			; clear image infos
		jmp	si_next
si_opensnap:
		jmp	si_exit
si_seldrv:
		mov	si, offset name_table
		shl	ax, 2
		add	si, ax
		shl	ax, 1
		add	si, ax
		mov	ax, [si]			; get drive string

		cmp	al, 'B'				; drive A or B selected?
		jg	si_notAorB
		mov	dl, al
		sub	dl, 'A'				; drive 0 or 1
		mov	bx, offset name_table
		mov	cx, 00ffh			; invalid sector ID
		mov	dh, 0
		push	es
		mov	ax, ds
		mov	es, ax
		mov	ax, 0201h			; read 1 sector
		int	13h
		pop	es
		and	ah, 80h				; timeout error?
		jnz	si_getkey
		mov	ax, [si]			; get drive string
si_notAorB:
		mov	di, [current_drv]
		mov	[di + DRIVE_offs], ax
		mov	[byte ptr di + PATH_offs + 1], 0 ; start at root level
si_refresh:
		mov	[current_row], 0		; set cursor and pointer
		mov	ax, 0				;  to the top
		jmp	si_filllist			; update listing
si_seldir:
		call	parse_dirstr			; determine path end
		cmp	bx, 1				; at root level?
		je	si_sdatroot
		mov	[byte ptr si + bx], '\'		; append '\'
		inc	bx
si_sdatroot:
		add	si, bx
		mov	di, si
		mov	ax, [current_pos]
		mov	si, offset name_table
		shl	ax, 2
		add	si, ax
		shl	ax, 1
		add	si, ax
		mov	bx, 0
		mov	cx, 12				; append new dir name..
si_sdcopyloop:
		mov	al, [si + bx]
		cmp	al, ' '
		je	si_sddone
		mov	[di + bx], al
		inc	bx
		dec	cx
		jnz	si_sdcopyloop
si_sddone:
		mov	[byte ptr di + bx], 0		; 0 terminate path name
		jmp	si_refresh
si_notselect:

; ........................................................................

		cmp	ah, EJECT_KEY
		jne	si_noteject
		cmp	[current_drv], offset CPCb_pos	; snapshot menu?
		jg	si_getkey

		call	close_disk			; close image if open
		mov	si, [current_drv]
		call	update_diskinfo			; clear image infos
		jmp	si_next
si_noteject:

; ........................................................................

		cmp	ah, WPTOGGLE_KEY
		jne	si_notwptoggle
		mov	si, [current_drv]
		cmp	[word ptr si + HANDLE_offs], 0ffffh
		je	si_getkey
		cmp	[byte ptr si + WPSTATUS_offs], LOCKED
		je	si_getkey
		mov	al, [si + WPSTATUS_offs]
		not	al				; invert current setting
		and	al, 1
		mov	[si + WPSTATUS_offs], al
		call	update_diskinfo			; update screen info
		jmp	si_next
si_notwptoggle:

; ........................................................................

		cmp	ah, SIDE_KEY
		jne	si_notside
		cmp	[current_drv], offset CPCb_pos	; snapshot menu?
		jg	si_getkey
		mov	si, [current_drv]
		mov	al, [si + SIDES_offs]
		or	al, al
		jz	si_notside
		mov	al, [si + SIDE_offs]
		not	al				; invert current setting
		and	al, 1
		mov	[si + SIDE_offs], al
		call	update_diskinfo			; update screen info
		jmp	si_next
si_notside:

; ........................................................................

		cmp	ah, INSERT_KEY
		jne	si_notinsert
		cmp	[current_drv], offset CPCb_pos	; snapshot menu?
		jle	si_getkey
		cmp	[current_drv], offset ssnap_pos	; storing snapshot?
		jne	si_getkey
		mov	[byte ptr scr_colour], 07h
		mov	si, offset storesnap_str	; display prompt..
		mov	al, [si]
		mov	ah, 18
		call	[move_scrpos]
		mov	bl, 0
		mov	cl, 0bh
		inc	si
		call	[print_string]
		mov	[byte ptr ssnap_name+2], 0	; clear filename
		mov	bx, 0				; character offset
si_input:
		mov	[keycode], 0
si_wait4key:
		mov	ah, [keycode]
		or	ah, ah				; was any key pressed?
		jz	si_wait4key

		cmp	ah, ESC_KEY			; abort?
		je	si_notinsert
		cmp	ah, SELECT_KEY			; done?
		je	si_gotname
		cmp	ah, BACK_KEY			; backspace pressed?
		jne	si_notBS
		or	bx, bx				; at offset 0?
		jz	si_delchar
		dec	bx
si_delchar:
		mov	[ssnap_name+2 + bx], ' '	; clear last character
		jmp	si_showname
si_notBS:
		cmp	bx, 8				; at max char count?
		je	si_input
		cmp	ah, LAST_KEY
		jg	si_input
		mov	dx, bx
		movzx	bx, ah				; convert scan code to
		mov	al, [sc2char_table + bx]	;  ascii code
		mov	bx, dx
		or	al, al				; invalid entry?
		jz	si_input
		mov	ah, 0				; 0 terminate string
		mov	[word ptr ssnap_name+2 + bx], ax
		inc	bx				; updated offset
si_showname:
		mov	dx, bx
		mov	si, offset ssnap_name+2		; show current name..
		mov	ax, 1203h
		call	[move_scrpos]
		mov	bl, 0
		mov	cl, 0fh
		call	[print_string]
		mov	bx, dx
		jmp	si_input
si_gotname:
		or	bx, bx				; empty name string?
		jnz	si_validname
		stc					; aborted..
		jmp	si_exit
si_validname:
		mov	ax, [drive_str]			; get drive letter
		mov	[word ptr ssnap_name], ax	; prepend to filename
		mov	[dword ptr ssnap_name+2 + bx], 'ANS.'
		mov	[byte ptr ssnap_name+6 + bx], 0	; 0 terminate string
		jmp	si_exit
si_notinsert:

; ........................................................................

		cmp	ah, DELETE_KEY
		jne	si_notdelete
		cmp	[entries], 0
		je	si_getkey
		mov	ax, [current_pos]
		cmp	ax, [dirs_start]		; in directory listing?
		jge	si_getkey
		mov	di, [current_drv]
		cmp	[byte ptr di + FSACCESS_offs], ARCHIVE
		je	si_getkey
		mov	[byte ptr scr_colour], 07h
		mov	si, offset delete_str		; display warning..
		mov	al, [si]
		mov	ah, 18
		call	[move_scrpos]
		mov	bl, 0
		mov	cl, 0ch
		inc	si
		call	[print_string]

		mov	[keycode], 0
si_wait4yes:
		mov	ah, [keycode]
		or	ah, ah				; was any key pressed?
		jz	si_wait4yes
		push	ax
		mov	al, [offset delete_str]		; remove warning..
		mov	ah, 18
		call	[move_scrpos]
		mov	bl, 20
		mov	si, offset empty_str
		call	[print_string]
		mov	al, [offset delete_str]
		mov	ah, 18 + 20
		call	[move_scrpos]
		mov	bl, 20
		mov	si, offset empty_str
		call	[print_string]
		pop	ax
		cmp	ah, YES_KEY			; got yes?
		jne	si_getkey
si_goahead:
		mov	di, [current_drv]
		cmp	[byte ptr di + ORIGIN_offs], ARCHIVE
		jne	si_delcontinue
		mov	dx, offset temp_path
		mov	ah, 3bh				; set current directory
		int	21h
		mov	dx, di
		add	dx, NAME_offs
		mov	ax, 4100h			; delete file
		int	21h
		mov	dx, di
		add	dx, DRIVE_offs
		mov	ah, 3bh				; set current directory
		int	21h
si_delcontinue:
		mov	ax, [current_pos]
		cmp	ax, [dirs_start]		; in directory listing?
		jge	si_getkey
		mov	si, offset name_table
		shl	ax, 2
		add	si, ax
		shl	ax, 1
		add	si, ax
		mov	bx, [drive_str]			; get drive letter
		mov	[word ptr di + NAME_offs], bx	; prepend to filename
		add	di, NAME_offs+2
		call	trans_name
		mov	[byte ptr di + 8], '.'
		mov	ah, 41h				; delete file
		mov	dx, di
		sub	dx, 2
		int	21h
		call	fill_name_table
		mov	ax, [entries]
		cmp	ax, [current_pos]
		jge	si_delposOK
		mov	[current_pos], ax
si_delposOK:
		mov	[search_offs], 0
		jmp	si_loop
si_notdelete:

; ........................................................................

		cmp	ah, ESC_KEY
		jne	si_notescape
		stc					; aborted..
		jmp	si_exit				; return to emulator
si_notescape:

; ........................................................................

		cmp	ah, LAST_KEY
		jg	si_getkey
		cmp	[entries], 0
		je	si_getkey
		movzx	bx, ah				; convert scan code to
		mov	al, [sc2char_table + bx]	;  ascii code
		or	al, al				; invalid entry?
		jz	si_getkey
		mov	bx, [search_offs]
		or	bx, bx				; search in progress?
		jnz	fstr_searching
		mov	[current_pos], 0		; reset cursor and
		mov	[current_row], 0		;  pointer to the top
		jmp	fstr_cont
fstr_searching:
		cmp	bx, 8				; 8 letters entered?
		je	si_getkey
fstr_cont:
		mov	[search_str + bx], al		; append new letter
		inc	bx
		mov	[byte ptr search_str + bx], 0	; 0 terminate string
		mov	[search_offs], bx
		call	find_str			; perform search
		jmp	si_loop

; ........................................................................

si_exit:
		mov	si, [current_drv]		; store current
		mov	ax, [current_row]		;  positions..
		mov	[si + ROW_offs], ax
		mov	ax, [current_pos]
		mov	[si + POS_offs], ax

		call	ClearKeyMap
		mov	[keycode], 0			; clear input buffer
		ret

; ________________________________________________________________________

; itoa		converts value into printable string (decimal)

; IN:
;	al	value to be converted
;	di	pointer to string buffer

; USES:
;	ax bx di

itoa:
		mov	bl, 10
		mov	bh, 0
itoa_loop1:
		mov	ah, 0
		div	bl
		add	ah, 30h
		push	ax
		inc	bh
		or	al, al
		jnz	itoa_loop1
itoa_loop2:
		pop	ax
		mov	[byte ptr di], ah
		inc	di
		dec	bh
		jnz	itoa_loop2
itoa_exit:
		ret

; ________________________________________________________________________

; copy_str	copy 0 terminated string

; IN:
;	si	pointer to source
;	di	pointer to destination

; OUT:
;	bx	characters copied

; USES:
;	al bx

copy_str:
		mov	bx, 0
cstr_loop:
		mov	al, [si + bx]
		or	al, al
		jz	cstr_done
		mov	[di + bx], al
		inc	bx
		jmp	cstr_loop
cstr_done:
		ret

; ________________________________________________________________________

; copy_name	copy file name from DTA to current name table position

; IN:
;	cx	file attribute
;	ds:di	pointer into file name table
;	es:si	pointer to file name

; USES:
;	ax bx di

copy_name:
		mov	bx, 0
cn_clr_loop:
		mov	[byte ptr di + bx], ' '		; clear table entry
		inc	bx
		cmp	bx, STR_WIDTH
		jne	cn_clr_loop
		mov	bx, 0
		cmp	cx, 10h				; name of a directory?
		je	cn_copy_dirname
cn_copy_loop:
		mov	al, [es:si + 30 + bx]		; get character
		inc	bx
		cmp	al, '.'				; reached extension?
		je	cn_extension
		mov	[di], al			; store character
		inc	di
		jmp	cn_copy_loop
cn_extension:
		mov	ax, 10				; tabulate correctly..
		sub	ax, bx
		add	di, ax
cn_ext_loop:
		mov	al, [es:si + 30 + bx]		; get character
		or	al, al				; reached the end?
		jz	cn_done
		mov	[di], al			; store character
		inc	bx
		inc	di
		jmp	cn_ext_loop
cn_copy_dirname:
		mov	al, [es:si + 30 + bx]		; get character
		or	al, al				; reached the end?
		jz	cn_cdn_done
		mov	[di + bx], al			; store character
		inc	bx
		jmp	cn_copy_dirname
cn_cdn_done:
		add	di, STR_WIDTH			; advance to next entry
cn_done:
		ret

; ________________________________________________________________________

; trans_name	copy string of 12 bytes length

; IN:
;	si	pointer to source
;	di	pointer to destination

; USES:
;	eax

trans_name:
		mov	eax, [si]
		mov	[di], eax
		mov	eax, [si + 4]
		mov	[di + 4], eax
		mov	eax, [si + 8]
		mov	[di + 8], eax
		ret

; ________________________________________________________________________

; cmp_str	compare two strings of fixed length

; IN:
;	si	pointer to first string
;	di	pointer to second string

; USES:
;	al bx

cmp_str:
		mov	bx, 0
cs_loop:
		mov	al, [di + bx]
		cmp	[si + bx], al
		jne	cs_exit
		inc	bx
		cmp	bx, STR_WIDTH
		jb	cs_loop
cs_exit:
		ret

; ________________________________________________________________________

; OUT:
;	bx	length of path string
;	cx	position of last '\' in path string

; USES:
;	al bx cx si

parse_dirstr:
		mov	si, [current_drv]
		add	si, PATH_offs
		mov	bx, 0
		mov	cx, bx
pds_loop:
		mov	al, [si + bx]
		or	al, al
		jz	pds_done
		cmp	al, '\'
		jne	pds_cont
		mov	cx, bx
pds_cont:
		inc	bx
		jmp	pds_loop
pds_done:
		ret

; ________________________________________________________________________

find_str:
		mov	ax, [current_pos]
		mov	cx, ax
		mov	si, offset name_table
		shl	ax, 2
		add	si, ax
		shl	ax, 1
		add	si, ax
		mov	di, offset search_str
		mov	bx, 0
fstr_loop:
		mov	al, [di + bx]
		or	al, al
		jz	fstr_done
		cmp	al, [si + bx]
		je	fstr_getnext
		cmp	cx, [entries]
		jge	fstr_failed
		inc	cx
		add	si, 12
		mov	bx, 0
		jmp	fstr_loop
fstr_failed:
		dec	[search_offs]
		ret
fstr_getnext:
		inc	bx
		jmp	fstr_loop
fstr_done:
		mov	ax, [current_pos]
		mov	[current_pos], cx
		sub	cx, ax
		add	cx, [current_row]
		cmp	cx, SCR_LENGTH-1
		jle	fstr_onscreen
		mov	cx, SCR_LENGTH-1
fstr_onscreen:
		mov	[current_row], cx
		ret

; ________________________________________________________________________

; IN:
;	ax	current selection

; USES:
;	ax bx cl dx si di

print_names:
		mov	ax, [current_pos]		; start with current
		sub	ax, [current_row]		;  selection
		mov	dx, ax
		mov	si, offset name_table		; calculate offset into
		shl	ax, 2				;  table..
		add	si, ax
		shl	ax, 1
		add	si, ax

		mov	ax, 0200h			; start screen position
		mov	bp, SCR_LENGTH
pn_loop:
		cmp	dx, [entries]			; processed all entries?
		jc	pn_cont
		mov	si, offset empty_str		; continue with blanks
pn_cont:
		mov	cx, TEXT_COLOUR
		cmp	al, [byte ptr current_row]	; on selection line?
		jne	pn_normal
		mov	cx, [scr_colour]		; highlight colour
pn_normal:		
		push	ax				; save screen location
		call	[move_scrpos]
		mov	bl, 12
		call	[print_string]
		pop	ax
		inc	al				; increase y position
		inc	dx				; next entry
		dec	bp
		jnz	pn_loop
		ret

; ________________________________________________________________________

update_screen:
		push	si
		mov	dx, [current_drv]

		mov	ax, 1100h
		call	[move_scrpos]
		mov	si, offset drvA_str
		mov	bl, 0
		mov	cl, 07h
		cmp	dx, offset CPCa_pos
		jne	us_notdrvA
		mov	cl, 1fh
us_notdrvA:
		call	[print_string]
		
		mov	ax, 3100h
		call	[move_scrpos]
		mov	si, offset drvB_str
		mov	bl, 0
		mov	cl, 07h
		cmp	dx, offset CPCb_pos
		jne	us_notdrvB
		mov	cl, 1fh
us_notdrvB:
		call	[print_string]
		pop	si
		ret

; ________________________________________________________________________

; IN:
;	si	current_drv

update_diskinfo:
		mov	dh, 18
		cmp	si, offset CPCa_pos		; CPC drive A?
		je	udi_drvA
		mov	dh, 50
udi_drvA:
		mov	ax, [si + HANDLE_offs]
		cmp	ax, 0ffffh			; no disk in drive?
		jne	udi_valid
		mov	si, offset nodisk_str
		mov	al, [si]
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 0
		mov	cx, 03h
		inc	si
		call	[print_string]

		mov	dl, 6				; clear disk info..
udi_clrloop:
		mov	ah, dh
		mov	al, 9
		sub	al, dl
		call	[move_scrpos]
		mov	bl, 22
		mov	cx, 07h
		mov	si, offset empty_str
		call	[print_string]
		dec	dl
		jnz	udi_clrloop

		ret
udi_valid:
		mov	bp, si
		mov	al, [si + SIDE_offs]
		add	al, '0'
		mov	si, offset side_str
		mov	[si + 6], al
		mov	al, [si]
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 0
		mov	cx, 07h
		inc	si
		call	[print_string]			; print side #

		mov	si, bp
		mov	al, [si + WPSTATUS_offs]
		mov	si, offset nowprotect_str
		or	al, al
		jz	udi_nowp
		mov	si, offset wprotect_str
udi_nowp:
		mov	al, [si]
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 0
		mov	cx, 0fh
		inc	si
		call	[print_string]			; print WP status

		mov	si, bp
		mov	al, 2
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 12
		mov	cx, 0bh
		add	si, NAME_offs+2
		call	[print_string]			; print file name

		mov	si, bp
		mov	al, [si + TYPE_offs]
		cmp	al, BSNORM
		jne	udi_notBSNORM
		mov	si, offset fmtBSNORM_str
		jmp	udi_printfmt
udi_notBSNORM:
		cmp	al, BSPACK
		jne	udi_notBSPACK
		mov	si, offset fmtBSPACK_str
		jmp	udi_printfmt
udi_notBSPACK:
		cmp	al, MVNORM
		jne	udi_notMVNORM
		mov	si, offset fmtMVNORM_str
		jmp	udi_printfmt
udi_notMVNORM:
		mov	si, offset fmtMVEXTD_str
udi_printfmt:
		mov	al, [si]
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 0
		mov	cx, 03h
		inc	si
		call	[print_string]			; print image format

		mov	si, bp
		mov	al, [si + TRACKS_offs]
		mov	di, offset tracks_str+1
		call	itoa
		mov	si, offset tracks_str
		mov	al, [si]
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 0
		mov	cx, 03h
		inc	si
		call	[print_string]			; print # of tracks

		mov	si, bp
		mov	al, [si + SIDES_offs]
		add	al, '1'
		mov	si, offset sides_str
		mov	[si + 1], al
		mov	al, [si]
		mov	ah, dh
		call	[move_scrpos]
		mov	bl, 0
		mov	cx, 03h
		inc	si
		call	[print_string]			; print # of sides

		ret

; ________________________________________________________________________

; file_scan	search current directory for specified file mask

; IN:
;	cx	file type
;	dx	pointer to file mask string
;	di	pointer into name_table

; OUT:
;	carry	set if no files found

; USES:
;	ax bx cx dx di si es

file_scan:
		pushad
		mov	dx, offset buffer
		mov	ax, 1a00h			; set DTA address
		int	21h
		popad

		mov	si, dx
		mov	ax, [drive_str]			; get current drive
		mov	[word ptr si], ax		; merge with wildcard

		mov	ax, 4e00h			; search for first match
		int	21h
		jc	fs_none_found

		mov	ax, ds
		mov	es, ax
		mov	si, offset buffer
		mov	dx, [entries]			; append to file list
		jmp	fs_check_attrib
fs_loop:
		cmp	dx, MAX_FILES-(26*12)		; prevent table overrun
		jge	fs_all_found
		inc	dx
		call	copy_name			; enter name in table
fs_get_next:
		mov	ax, 4f00h			; search for next match
		int	21h
		jc	fs_all_found
fs_check_attrib:
		mov	al, [es:si + 21]		; get file attribute
		and	al, cl
		cmp	al, cl				; compare w/ required
		jne	fs_get_next
		cmp	[byte ptr es:si + 30], '.'
		je	fs_get_next			; ignore '.' and '..'
		jmp	fs_loop
fs_all_found:
		mov	[entries], dx			; update table entries
		clc
fs_none_found:
		ret

; ________________________________________________________________________

; quick_sort	x86 assembly implementation
;		Copyright (c) 1996,97 by Ulrich Doewich

; IN:
;	stack	sort range end pointer
;	stack	sort range start pointer

proc quick_sort near

		arg	ilow_val:WORD,ihigh_val:WORD

		push	bp
		mov	bp, sp
		mov	cx, [ilow_val]
		mov	dx, [ihigh_val]

		mov	di, dx
		sub	dx, STR_WIDTH			; high - 1 position
qs_check_low:
		mov	si, cx				; low address
		cmp	cx, dx
		jge	qs_check_high
		call	cmp_str
		jg	qs_check_high
		add	cx, STR_WIDTH
		jmp	qs_check_low
qs_check_high:
		mov	si, dx				; high address
		cmp	cx, dx
		jge	qs_cont
		call	cmp_str
		jl	qs_cont
		sub	dx, STR_WIDTH
		jmp	qs_check_high
qs_cont:
		cmp	cx, dx
		jge	qs_noexchange

		mov	bx, di
		mov	di, offset temp_str		; copy 1st to temp..
		mov	si, cx
		call	trans_name
		mov	di, cx				; copy 2nd to 1st..
		mov	si, dx
		call	trans_name
		mov	di, dx				; copy temp to 2nd..
		mov	si, offset temp_str
		call	trans_name
		mov	di, bx
qs_noexchange:
		cmp	cx, dx
		jl	qs_check_low

		cmp	cx, [ihigh_val]
		jge	qs_next
		mov	si, cx				; low address
		call	cmp_str
		jle	qs_next

		mov	bx, di
		mov	di, offset temp_str		; copy 1st to temp..
		mov	si, cx
		call	trans_name
		mov	di, cx				; copy 2nd to 1st..
		mov	si, bx
		call	trans_name
		mov	di, bx				; copy temp to 2nd..
		mov	si, offset temp_str
		call	trans_name
		mov	di, bx
qs_next:
		add	cx, STR_WIDTH

		mov	ax, dx
		sub	ax, [ilow_val]
		mov	bx, [ihigh_val]
		sub	bx, cx
		cmp	ax, bx
		jge	qs_above

		cmp	cx, [ihigh_val]
		jge	qs_other10
		push	[ihigh_val]
		push	cx
		call	quick_sort			; .. recursive call
qs_other10:
		cmp	[ilow_val], dx
		jge	qs_end
		push	dx
		push	[ilow_val]
		call	quick_sort			; .. recursive call
		jmp	qs_end
qs_above:
		cmp	[ilow_val], dx
		jge	qs_other20
		push	dx
		push	[ilow_val]
		call	quick_sort			; .. recursive call
qs_other20:
		cmp	cx, [ihigh_val]
		jge	qs_end
		push	[ihigh_val]
		push	cx
		call	quick_sort			; .. recursive call
qs_end:
		pop	bp
		ret	4				; return & adjust stack

endp quick_sort

; ________________________________________________________________________

; fill_name_table	fills the filename table with names of images from the
;			current directory; appends a list of sub-directories
;			and all active PC drives

; USES:
;	ax bx cx dx di si

fill_name_table:
		push	es
		mov	si, [current_drv]
		mov	ax, [si + DRIVE_offs]		; get drive string
		mov	[drive_str], ax
		mov	dx, si
		add	dx, DRIVE_offs
		mov	ah, 3bh				; set current directory
		int	21h
		mov	[entries], 0			; reset table

		mov	cx, 0				; normal files
		mov	di, offset name_table
		cmp	[current_drv], offset CPCb_pos
		jg	fnt_snapshot
		mov	dx, offset wc_CPD		; all CPD files
		call	file_scan
		mov	cx, 0				; normal files
		mov	dx, offset wc_DSK		; all DSK files
		call	file_scan
		jmp	fnt_continue1
fnt_snapshot:
		mov	dx, offset wc_SNA		; all SNA files
		call	file_scan
		cmp	[current_drv], offset ssnap_pos	; saving snapshot?
		je	fnt_continue2
fnt_continue1:
		mov	cx, 0				; normal files
		mov	dx, offset wc_ARC		; all archived files
		call	file_scan
fnt_continue2:
		push	di

		mov	ax, [entries]
		mov	[dirs_start], ax		; store dir start pos
		dec	ax
		shl	ax, 2
		mov	bx, ax
		shl	ax, 1
		add	ax, bx				; ..multiply by 12
		add	ax, offset name_table
		push	ax				; range end
		mov	ax, offset name_table
		push	ax				; range start
		call	quick_sort			; sort file listing

		mov	cx, 10h				; directories
		mov	dx, offset wc_ALL
		pop	di
		call	file_scan
		push	di

		mov	ax, [entries]
		mov	[drvs_start], ax		; store drive start pos
		dec	ax
		shl	ax, 2
		mov	bx, ax
		shl	ax, 1
		add	ax, bx				; ..multiply by 12
		add	ax, offset name_table
		push	ax				; range end
		mov	ax, [dirs_start]
		shl	ax, 2
		mov	bx, ax
		shl	ax, 1
		add	ax, bx				; ..multiply by 12
		add	ax, offset name_table
		push	ax				; range start
		call	quick_sort			; sort dir names

		pop	di
		mov	ecx, '  :A'
		mov	bl, 1				; start with drive A
fnt_drvloop:
		mov	ax, 4409h			; test for drive
		int	21h
		jc	fnt_invaliddrv			; skip if not present
		mov	[dword ptr di], ecx		; add drive to list
		mov	[dword ptr di + 4], '    '
		mov	[dword ptr di + 8], '    '
		inc	[entries]			; update no. of entries
		add	di, 12
fnt_invaliddrv:
		inc	cl
		inc	bl
		cmp	bl, 28				; processed all drives?
		je	fnt_exit
		jmp	fnt_drvloop
fnt_exit:
		pop	es
		ret

; ________________________________________________________________________

prep4zip:
		mov	bx, 0
p4z_loop:
		mov	al, [si]
		or	al, al
		jz	p4z_done
		inc	si
		cmp	al, ' '
		je	p4z_loop
		mov	[di + bx], al
		inc	bx
		jmp	p4z_loop
p4z_done:
		cmp	bx, 12
		jne	p4z_clear
		ret
p4z_clear:
		mov	[byte ptr di + bx], ' '
		inc	bx
		cmp	bx, 12
		jne	p4z_clear
		ret

; ________________________________________________________________________

; copy_fname	copy filename from the central directory of a ZIP archive

; IN:
;	cx	length of string
;	si	pointer to source
;	di	pointer to destination

; OUT:
;	carry	set if '/' character was found

; USES:
;	al bx cx

copy_fname:
		mov	bx, 0
cfn_clearloop:
		mov	[byte ptr di + bx], ' '		; clear table entry
		inc	bx
		cmp	bx, STR_WIDTH
		jne	cfn_clearloop
		mov	bx, 0
cfn_loop:
		mov	al, [si + bx]
		cmp	al, '/'				; path character found?
		jne	cfn_normal
		sub	di, bx
		stc
		ret
cfn_normal:
		inc	bx
		cmp	al, '.'				; reached extension?
		je	cfn_extension
		mov	[di], al
		inc	di
		loop	cfn_loop
		stc					; should never get here!
		ret
cfn_extension:
		mov	ax, 10				; tabulate correctly..
		sub	ax, bx
		add	di, ax
		dec	cx
cfn_extloop:
		mov	al, [si + bx]			; get character
		mov	[di], al			; store character
		inc	bx
		inc	di
		loop	cfn_extloop
		ret

; ________________________________________________________________________

; zip_info	obtains filenames from the central directory of a ZIP archive

; OUT:
;	carry	set on error condition

; USES:
;	eax bx cx dx di si

zip_info:
		mov	dx, [current_drv]
		add	dx, DRIVE_offs
		mov	ah, 3bh				; set current directory
		int	21h

		mov	ax, 3d00h			; open file read only
		mov	dx, [current_drv]
		add	dx, ARCNAME_offs
		int	21h
		jc	zi_error
		mov	bx, ax
		mov	dx, -256			; last 256 bytes
zi_endcdirloop:
		mov	[file_pos], dx
		mov	ax, 4202h			; move file pointer
		mov	cx, -1				;  to end of file
		int	21h
		jc	zi_error
		mov	ax, 3f00h			; read from file
		mov	cx, 256				; block length
		mov	dx, offset buffer
		int	21h
		jc	zi_error
		mov	si, dx				; buffer address
		add	si, 256 - 22			; move backwards
zi_findendcdir:
		mov	eax, [si]
		cmp	eax, [dword ptr endcdir_sig]	; found signature?
		je	zi_foundendcdir
		sub	si, 4
		cmp	si, dx				; reached buffer start?
		jg	zi_findendcdir
		mov	dx, [file_pos]
		sub	dx, 256				; next block
		jnc	zi_endcdirloop
		jmp	zi_error			; signature not found..
zi_foundendcdir:
		mov	ax, [si + 10]			; entries in central dir
		mov	[cdir_entries], ax
		mov	ax, 4200h			; move file pointer
		mov	dx, [si + 16]			; central dir start low
		mov	cx, [si + 18]			; central dir start high
		int	21h
		jc	zi_error
		mov	ax, 3f00h			; read from file
		mov	cx, [si + 12]			; central dir length
		mov	dx, offset TapeBuffer
		int	21h
		jc	zi_error
		mov	ax, 3e00h			; close file
		int	21h

		mov	si, offset TapeBuffer
		mov	di, offset name_table
		mov	[entries], 0
zi_cdirloop:
		mov	cx, [si + 28]			; filename length
		mov	dx, cx
		add	dx, [si + 30]			; extra field length
		add	dx, [si + 32]			; file comment length
		add	si, 46				; start of filename
		cmp	cx, 12				; valid length?
		jg	zi_fname2long
		mov	bx, cx
		cmp	[current_drv], offset CPCb_pos	; snapshot menu?
		jg	zi_snapmenu
		cmp	[dword ptr si + bx-4], 'KSD.'
		je	zi_validfname
		cmp	[dword ptr si + bx-4], 'ksd.'
		je	zi_validfname
		cmp	[dword ptr si + bx-4], 'DPC.'
		je	zi_validfname
		cmp	[dword ptr si + bx-4], 'dpc.'
		jne	zi_fname2long
		jmp	zi_validfname
zi_snapmenu:
		cmp	[dword ptr si + bx-4], 'ANS.'
		je	zi_validfname
		cmp	[dword ptr si + bx-4], 'ans.'
		jne	zi_fname2long
zi_validfname:
		call	copy_fname
		jc	zi_fname2long			; '/' found?
		inc	[entries]
zi_fname2long:
		add	si, dx
		dec	[cdir_entries]
		jnz	zi_cdirloop
zi_done:
		mov	ax, [entries]
		inc	ax
		mov	[dirs_start], ax		; store dir start pos
		sub	ax, 2
		jz	zi_donotsort
		shl	ax, 2
		mov	bx, ax
		shl	ax, 1
		add	ax, bx				; ..multiply by 12
		add	ax, offset name_table
		push	ax				; range end
		mov	ax, offset name_table
		push	ax				; range start
		call	quick_sort			; sort file listing
zi_donotsort:
		ret
zi_error:
		mov	ax, 3e00h			; close file
		int	21h
		mov	[entries], 0
		stc
		ret

; ________________________________________________________________________

init_filesys:
		mov	si, offset name_table		; CPC drive A path
		mov	di, offset CPCa_drive
		call	copy_str
		mov	si, offset name_table+80	; CPC drive B path
		mov	di, offset CPCb_drive
		call	copy_str
		mov	si, offset name_table+160	; snapshot path
		mov	di, offset rsnap_drive
		call	copy_str
		mov	si, offset name_table+160	; snapshot path
		mov	di, offset ssnap_drive
		call	copy_str
		mov	si, offset name_table+240	; temp path
		mov	di, offset temp_path
		call	copy_str
		mov	si, offset name_table+240	; temp path
		mov	di, offset cmd_extrctpath
		call	copy_str
		mov	[byte ptr di + bx], 13		; end of command tail
		add	bx, 32
		mov	[cmd_tail], bl			; length of command tail
		mov	si, offset name_table+320	; archiver path
		mov	di, offset cmd_path
		call	copy_str

		mov	ah, 19h				; get current drive
		int	21h
		add	al, 'A'
		mov	[byte ptr initial_drv], al
		mov	si, offset initial_dir
		mov	dl, 0				; current drive
		mov	ah, 47h				; get current directory
		int	21h

		mov	dx, offset CPCa_drive
		mov	ah, 3bh				; set current directory
		int	21h
		jnc	ifs_drvAOK			; path exists?
		mov	si, offset initial_drv		; if not - revert to
		mov	di, offset CPCa_drive		;  startup directory
		call	copy_str
ifs_drvAOK:
		mov	dx, offset CPCb_drive
		mov	ah, 3bh				; set current directory
		int	21h
		jnc	ifs_drvBOK			; path exists?
		mov	si, offset initial_drv		; if not - revert to
		mov	di, offset CPCb_drive		;  startup directory
		call	copy_str
ifs_drvBOK:
		mov	dx, offset rsnap_drive
		mov	ah, 3bh				; set current directory
		int	21h
		jnc	ifs_snapOK			; path exists?
		mov	si, offset initial_drv		; if not - revert to
		mov	di, offset rsnap_drive		;  startup directory
		call	copy_str
		mov	si, offset initial_drv
		mov	di, offset ssnap_drive
		call	copy_str
ifs_snapOK:
		mov	dx, offset temp_path
		mov	ah, 3bh				; set current directory
		int	21h
		jnc	ifs_tempathOK			; path exists?
		mov	[valid_tempath], 0		; no archive support
ifs_tempathOK:
		mov	dx, offset initial_drv
		mov	ah, 3bh				; set current directory
		int	21h
		ret

; ________________________________________________________________________

select_file:
		pushad
		push	es
		call	[sound_pause]
		call	OpenTextScr

		call	select_image

		call	RestoreScreen
		call	[sound_continue]
		pop	es
		popad
		ret

; ________________________________________________________________________

restore_snapshot:
		push	es
		call	[sound_pause]
		call	OpenTextScr

		push	[current_drv]
		mov	[current_drv], offset rsnap_pos
		call	select_image
		pop	[current_drv]

		jnc	restoress_exit
		mov	[byte ptr rsnap_name+2], 0	; aborted
restoress_exit:
		call	RestoreScreen
		pop	es
		ret

; ________________________________________________________________________

store_snapshot:
		push	es
		call	[sound_pause]
		call	OpenTextScr

		push	[current_drv]
		mov	[current_drv], offset ssnap_pos
		call	select_image
		pop	[current_drv]

		jnc	storess_exit
		mov	[byte ptr ssnap_name+2], 0	; aborted
storess_exit:
		call	RestoreScreen
		pop	es
		ret

; ________________________________________________________________________

cleanup_filesys:
		mov	[current_drv], offset CPCa_pos
		call	close_disk			; close any open images
		mov	[current_drv], offset CPCb_pos
		call	close_disk

		mov	dx, offset temp_path
		mov	ah, 3bh				; set current directory
		int	21h

		mov	si, offset CPCa_pos
		cmp	[byte ptr si + ORIGIN_offs], ARCHIVE
		jne	cfs_AnotinARC
		mov	ax, [word ptr temp_path]
		mov	[si + NAME_offs], ax
		mov	dx, si
		add	dx, NAME_offs
		mov	ax, 4100h			; delete file
		int	21h
cfs_AnotinARC:
		mov	si, offset CPCb_pos
		cmp	[byte ptr si + ORIGIN_offs], ARCHIVE
		jne	cfs_BnotinARC
		mov	ax, [word ptr temp_path]
		mov	[si + NAME_offs], ax
		mov	dx, si
		add	dx, NAME_offs
		mov	ax, 4100h			; delete file
		int	21h
cfs_BnotinARC:
		mov	si, offset rsnap_pos
		cmp	[byte ptr si + ORIGIN_offs], ARCHIVE
		jne	cfs_exit
		mov	ax, [word ptr temp_path]
		mov	[si + NAME_offs], ax
		mov	dx, si
		add	dx, NAME_offs
		mov	ax, 4100h			; delete file
		int	21h
cfs_exit:
		mov	dx, offset initial_drv		; reset to inital dir
		mov	ah, 3bh				; set current directory
		int	21h
		ret

; ________________________________________________________________________

ends

segment	_data page public 'DATA'

		even
entries		dw	0
dirs_start	dw	0
drvs_start	dw	0
current_pos	dw	0
current_row	dw	0
current_drv	dw	CPCa_pos
search_offs	dw	0
tempSS		dw	0
tempSP		dw	0
drive_str	dw	0
device_attrib	dw	0
file_pos	dw	0
cdir_entries	dw	0

endcdir_sig	db	'PK', 5, 6
valid_tempath	db	1

POS_offs	=	0
ROW_offs	=	CPCa_row-CPCa_pos
HANDLE_offs	=	CPCa_handle-CPCa_pos
TYPE_offs	=	CPCa_type-CPCa_pos
NAME_offs	=	CPCa_name-CPCa_pos
DRIVE_offs	=	CPCa_drive-CPCa_pos
PATH_offs	=	CPCa_path-CPCa_pos
FSACCESS_offs	=	CPCa_fsaccess-CPCa_pos
ORIGIN_offs	=	CPCa_origin-CPCa_pos
ARCNAME_offs	=	CPCa_arcname-CPCa_pos
ARCPOS_offs	=	CPCa_arcpos-CPCa_pos
ARCROW_offs	=	CPCa_arcrow-CPCa_pos
TTABLE_offs	=	CPCa_ttable-CPCa_pos
TLENGTH_offs	=	CPCa_tlength-CPCa_pos
TRACKS_offs	=	CPCa_tracks-CPCa_pos
CURRTRACK_offs	=	CPCa_currtrack-CPCa_pos
SIDES_offs	=	CPCa_sides-CPCa_pos
SIDE_offs	=	CPCa_side-CPCa_pos
CURRSIDE_offs	=	CPCa_currside-CPCa_pos
PREVSIDE_offs	=	CPCa_prevside-CPCa_pos
RNDFLAG_offs	=	CPCa_rndflag-CPCa_pos
WPSTATUS_offs	=	CPCa_wpstatus-CPCa_pos

		even
CPCa_pos	dw	0
CPCa_row	dw	0
CPCa_handle	dw	-1
CPCa_type	db	0
CPCa_name	db	'x:xxxxxxxx.xxx', 0
CPCa_drive	db	'x:'
CPCa_path	db	80 dup (0)
CPCa_fsaccess	db	NORMAL
CPCa_origin	db	NORMAL
CPCa_arcname	db	'x:xxxxxxxx.xxx', 0
CPCa_arcpos	dw	0
CPCa_arcrow	dw	0
CPCa_ttable	dw	offset track_tableA
CPCa_tlength	dw	0
CPCa_tracks	db	0
CPCa_currtrack	db	0
CPCa_sides	db	0
CPCa_side	db	0
CPCa_currside	db	0
CPCa_prevside	db	0
CPCa_wpstatus	db	OFF
CPCa_rndflag	db	OFF

		even
CPCb_pos	dw	0
CPCb_row	dw	0
CPCb_handle	dw	-1
CPCb_type	db	0
CPCb_name	db	'x:xxxxxxxx.xxx', 0
CPCb_drive	db	'x:'
CPCb_path	db	80 dup (0)
CPCb_fsaccess	db	NORMAL
CPCb_origin	db	NORMAL
CPCb_arcname	db	'x:xxxxxxxx.xxx', 0
CPCb_arcpos	dw	0
CPCb_arcrow	dw	0
CPCb_ttable	dw	offset track_tableB
CPCb_tlength	dw	0
CPCb_tracks	db	0
CPCb_currtrack	db	0
CPCb_sides	db	0
CPCb_side	db	0
CPCb_currside	db	0
CPCb_prevside	db	0
CPCb_wpstatus	db	OFF
CPCb_rndflag	db	OFF

		even
rsnap_pos	dw	0
rsnap_row	dw	0
rsnap_handle	dw	-1
rsnap_type	db	0
rsnap_name	db	'x:xxxxxxxx.xxx', 0
rsnap_drive	db	'x:'
rsnap_path	db	80 dup (0)
rsnap_fsaccess	db	NORMAL
rsnap_origin	db	NORMAL
rsnap_arcname	db	'x:xxxxxxxx.xxx', 0
rsnap_arcpos	dw	0
rsnap_arcrow	dw	0
		db	CPCa_rndflag-CPCa_ttable dup (0)

		even
ssnap_pos	dw	0
ssnap_row	dw	0
ssnap_handle	dw	-1
ssnap_type	db	0
ssnap_name	db	'x:xxxxxxxx.xxx', 0
ssnap_drive	db	'x:'
ssnap_path	db	80 dup (0)
ssnap_fsaccess	db	NORMAL
ssnap_origin	db	NORMAL
ssnap_arcname	db	'x:xxxxxxxx.xxx', 0
ssnap_arcpos	dw	0
ssnap_arcrow	dw	0

wc_ALL	 db	'x:*.*', 0
wc_CPD	 db	'x:*.CPD', 0
wc_DSK	 db	'x:*.DSK', 0
wc_SNA	 db	'x:*.SNA', 0
wc_ARC	 db	'x:*.ZIP', 0

		even
scr_layout	db	17, 18, 1, 11, 'ENTER', 1, 3, ' select file / change directory', 0
		db	18, 18, 1, 11, 'BACKSPACE', 1, 3, ' return to previous directory', 0
		db	19, 18, 1, 11, '  PGUP PGDOWN HOME END', 1, 3, ' navigate file listing', 0
		db	20, 18, 1, 11, ' ', 1, 3, ' select CPC drive', 0
		db	21, 18, 1, 11, 'SPACE', 1, 3, ' toggle write protect', 0
		db	22, 18, 1, 11, 'TAB', 1, 3, ' toggle side', 0
		db	23, 18, 1, 11, 'GREY MINUS', 1, 3, ' eject disk', 0
		db	24, 18, 1, 11, 'DELETE', 1, 3, ' erase highlighted file', 0
		dw	0ffffh

rsnap_layout	db	 0, 18, 1, 15, 'Select snapshot to restore from..', 0
		db	21, 18, 1, 11, 'ENTER', 1, 3, ' select file / change directory', 0
		db	22, 18, 1, 11, 'BACKSPACE', 1, 3, ' return to previous directory', 0
		db	23, 18, 1, 11, '  PGUP PGDOWN HOME END', 1, 3, ' navigate file listing', 0
		db	24, 18, 1, 11, 'DELETE', 1, 3, ' erase highlighted file', 0
		dw	0ffffh

ssnap_layout	db	 0, 18, 1, 15, 'Select snapshot to store current state in..', 0
		db	20, 18, 1, 11, 'ENTER', 1, 3, ' select file / change directory', 0
		db	21, 18, 1, 11, 'BACKSPACE', 1, 3, ' return to previous directory', 0
		db	22, 18, 1, 11, '  PGUP PGDOWN HOME END', 1, 3, ' navigate file listing', 0
		db	23, 18, 1, 11, 'INSERT', 1, 3, ' create new snapshot file', 0
		db	24, 18, 1, 11, 'DELETE', 1, 3, ' erase highlighted file', 0
		dw	0ffffh

drvA_str	db	' CPC Drive A                 ', 0
drvB_str	db	' CPC Drive B                 ', 0

nodisk_str	db	2, 'disk missing', 0
fmtBSNORM_str	db	3, 'normal CPD format    ', 0
fmtBSPACK_str	db	3, 'compressed CPD format', 0
fmtMVNORM_str	db	3, 'normal DSK format    ', 0
fmtMVEXTD_str	db	3, 'extended DSK format  ', 0
tracks_str	db	4, '00 tracks', 0
sides_str	db	5, '0 side(s)', 0
side_str	db	7, 'side 0', 0
wprotect_str	db	8, 'write protected    ', 0
nowprotect_str	db	8, 'not write protected', 0
storesnap_str	db	2, 'Enter filename', 0
delete_str	db	10, 'Permanently delete selected file?', 0

label sc2char_table byte
;			    ESC  1   2   3   4   5   6   7   8   9   0        DEL TAB
		db	 0 , 0 ,'1','2','3','4','5','6','7','8','9','0', 0 , 0 , 0 , 0
;			 Q   W   E   R   T   Z   U   I   O   P   _   +   CR CTL  A   S
		db	'Q','W','E','R','T','Y','U','I','O','P', 0 , 0 , 0 , 0 ,'A','S'
;			 D   F   G   H   J   K   L   "   ,   o  LSH  #'  Y   X   C   V
		db	'D','F','G','H','J','K','L', 0 , 0 , 0 , 0 , 0 ,'Z','X','C','V'
;			 B   N   M
		db	'B','N','M'

initial_drv	db	'x:\'
initial_dir	db	80 dup (0)
temp_path	db	80 dup (0)

cmd_path	db	80 dup (0)
cmd_paras	dw	0
		dw	offset cmd_tail
		dw	seg cmd_tail
		dw	0, 0
		dw	0, 0
cmd_tail	db	0
cmd_arcoptions	db	'-o+ '
cmd_arcdrv	db	'x:'
cmd_arcname	db	'xxxxxxxx.xxx '
cmd_filename	db	'xxxxxxxx.xxx '
cmd_extrctpath	db	80 dup (0)

empty_str	db	22 dup (' ')
temp_str	db	13 dup (?)
search_str	db	13 dup (?)

		even
buffer		db	256 dup (?)
name_table	db	MAX_FILES*12 dup (?)

ends

; ________________________________________________________________________

segment	_stack para stack 'STACK'
ends

end
