/*
    Re3002 - An M3002 RTC replacement
    Copyright (C) 2013  Oliver Tscherwitschke <oliver@tscherwitschke.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


; =======================================
; Wait until EEPROM programming is finished
.MACRO EE_PROG_WAIT
_ee_wait:
    sbic EECR, EEPE
    rjmp _ee_wait
.ENDMACRO


; =======================================
; IN:  R25:R24 = adress 
; OUT: R24     = data
ee_read:

    ; In case EEPROM programming is active from a previous command, wait until it is finished
    EE_PROG_WAIT
    
    ; Address
    out EEARH, R25
    out EEARL, R24
    
    ; EEPROM Read Enable
    sbi EECR, EERE
    
    ; Return Data
    in R24, EEDR
    ret


; =======================================
; IN: R25:R24 = adress 
;     R22     = data
ee_write:

    ; In case EEPROM programming is active from a previous command, wait until it is finished
    EE_PROG_WAIT

    ; Address
    out EEARH, R25
    out EEARL, R24

    ; Data
    out EEDR, R22

    ; EEPROM Master Write Enable
    sbi EECR, EEMPE

    ; EEPROM Write Enable
    sbi EECR, EEPE
    ret


