/*
    Re3002 - An M3002 RTC replacement
    Copyright (C) 2013  Oliver Tscherwitschke <oliver@tscherwitschke.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


; ==============================================================
; Read and Write Adresses of the RTC chip 'RV-8564-C2'
.EQU SLA_W = 0xA2
.EQU SLA_R = (SLA_W + 1)


; ==============================================================
; Write Data to specified word address
; IN: Word address: R24
; IN: Data:         R22
rtc_write:
    push R24
    push R22

    push R22
    push R24

    ; --- Send START ---
    rcall twi_start
    cpi R24, START
    brne write_error2

    ; --- Send Device Address + W ---
    ldi R24, SLA_W
    rcall twi_send
    cpi R24, MT_SLAW_ACK
    brne write_error2

    ; --- Send word address ---
    pop R24
    rcall twi_send
    cpi R24, MT_DATA_ACK
    brne write_error1

    ; --- Send Data ---
    pop R24
    rcall twi_send
    cpi R24, MT_DATA_ACK
    brne write_error

    ; --- Send STOP ---
    rcall twi_stop

    pop R22
    pop R24
    ret

write_error2:
    pop temp
write_error1:
    pop temp
write_error:
    .IF DEBUG_OUTPUT
    ldi temp, 'E'
    rcall putchar
    .ENDIF
    
    ; --- Send STOP ---
    rcall twi_stop    
     
    pop R22
    pop R24
    ret





; ==============================================================
; IN:   R24 = RTC Address to read from
; OUT:  R24 = Data
;
rtc_read:
    push R24

    ; --- Send START ---
    rcall twi_start
    cpi R24, START
    brne read_error1

    ; --- Send Device Address + W ---
    ldi R24, SLA_W
    rcall twi_send
    cpi R24, MT_SLAW_ACK
    brne read_error1

    ; --- Send word address ---
    pop R24
    rcall twi_send
    cpi R24, MT_DATA_ACK
    brne read_error

    ; --- Send Repeated START ---
    rcall twi_start
    cpi R24, REP_START
    brne read_error

    ; --- Send Device Address + R ---
    ldi R24, SLA_R
    rcall twi_send
    cpi R24, MR_SLAR_ACK
    brne read_error
    
    ; --- Read Byte ---
    rcall twi_send
    cpi R24, MR_DATA_NACK
    brne read_error
    lds R24, TWDR

    ; --- Send STOP ---
    rcall twi_stop
    ret

read_error1:
    pop temp
read_error:
    .IF DEBUG_OUTPUT
    ldi temp, 'e'
    rcall putchar
    .ENDIF
   
    ; --- Send STOP ---
    rcall twi_stop
    ret



