/* Dissassembler by Edouard BERGE (roudoudou@cpcscene.com) 
This software is freeware.
If you make modification of this source, feel free to send 
the upgrade to roudoudou@cpcscene.com */

#include<string.h>
#include<stdlib.h>
#include<stdio.h>
#include<ctype.h>

#define OFF 0
#define ON  1

unsigned char z80[65536];

void (*FirstJump[65536])(void);
void (*SecondJump[65536])(void);


int Display_Comment=ON;
int Org=OFF;
int pta;


void DisplayRegisterLight(int r)
{
switch(r)
   {
   case 0:printf("B");break;
   case 1:printf("C");break;
   case 2:printf("D");break;
   case 3:printf("E");break;
   case 4:printf("H");break;
   case 5:printf("L");break;
   case 6:printf("(HL)");break;
   case 7:printf("A");break;
   }
}

void DisplayRegister(int r)
{
switch(r)
   {
   case 0:DisplayRegisterLight(0);printf("\n");break;
   case 1:DisplayRegisterLight(1);printf("\n");break;
   case 2:DisplayRegisterLight(2);printf("\n");break;
   case 3:DisplayRegisterLight(3);printf("\n");break;
   case 4:DisplayRegisterLight(4);printf("\n");break;
   case 5:DisplayRegisterLight(5);printf("\n");break;
   case 6:DisplayRegisterLight(6);printf("\n");break;
   case 7:DisplayRegisterLight(7);printf("\n");break;
   default:printf("\nInternal Error (Please report bug)\n");
   }
}

void DisplayOpcode(int n)
{
if (Display_Comment)
   {
   int i;

   for (i=0;i<n;i++)
       {
       if (z80[pta+i]<16)
          printf("0%1X ",z80[pta+i]);
       else
          printf("%2X ",z80[pta+i]);
       }
   for (i=n;i<4;i++)
       {
       printf("   ");
       }
   }

printf("  ");
}

void UNKNOWN(void)
{
DisplayOpcode(1);
printf("DEFB #%2X\n",z80[pta]);
pta++;
}

//************************************************************* ADC *******

void ADCAR(void)
{
DisplayOpcode(1);
printf("ADC A,");
DisplayRegister(z80[pta]-0x88);
pta++;
}
void ADCAXH(void)
{
DisplayOpcode(2);
printf("ADC A,XH\n");
pta+=2;
}
void ADCAXL(void)
{
DisplayOpcode(2);
printf("ADC A,XL\n");
pta+=2;
}
void ADCAYH(void)
{
DisplayOpcode(2);
printf("ADC A,YH\n");
pta+=2;
}
void ADCAYL(void)
{
DisplayOpcode(2);
printf("ADC A,YL\n");
pta+=2;
}
void ADCAN(void)
{
DisplayOpcode(2);
printf("ADC A,#%2x\n",z80[pta+1]);
pta+=2;
}
void ADCAIX(void)
{
DisplayOpcode(3);
printf("ADC A,(IX+#%2x)\n",z80[pta+2]);
pta+=3;
}
void ADCAIY(void)
{
DisplayOpcode(3);
printf("ADC A,(IY+#%2x)\n",z80[pta+2]);
pta+=3;
}
void ADCHLBC(void)
{
DisplayOpcode(2);
printf("ADC HL,BC\n");
pta+=2;
}
void ADCHLDE(void)
{
DisplayOpcode(2);
printf("ADC HL,DE\n");
pta+=2;
}
void ADCHLHL(void)
{
DisplayOpcode(2);
printf("ADC HL,HL\n");
pta+=2;
}
void ADCHLSP(void)
{
DisplayOpcode(2);
printf("ADC HL,SP\n");
pta+=2;
}

//************************************************************* ADD *******

void ADDAR(void)
{
DisplayOpcode(1);
printf("ADD A,");
DisplayRegister(z80[pta]-0x80);
pta++;
}
void ADDAXH(void)
{
DisplayOpcode(2);
printf("ADD A,XH\n");
pta+=2;
}
void ADDAXL(void)
{
DisplayOpcode(2);
printf("ADD A,XL\n");
pta+=2;
}
void ADDAYH(void)
{
DisplayOpcode(2);
printf("ADD A,YH\n");
pta+=2;
}
void ADDAYL(void)
{
DisplayOpcode(2);
printf("ADD A,YL\n");
pta+=2;
}
void ADDAN(void)
{
DisplayOpcode(2);
printf("ADD A,#%2x\n",z80[pta+1]);
pta+=2;
}
void ADDAIX(void)
{
DisplayOpcode(3);
printf("ADD A,(IX+#%2x)\n",z80[pta+2]);
pta+=3;
}
void ADDAIY(void)
{
DisplayOpcode(3);
printf("ADD A,(IY+#%2x)\n",z80[pta+2]);
pta+=3;
}
void ADDHLBC(void)
{
DisplayOpcode(1);
printf("ADD HL,BC\n");
pta++;
}
void ADDHLDE(void)
{
DisplayOpcode(1);
printf("ADD HL,DE\n");
pta++;
}
void ADDHLHL(void)
{
DisplayOpcode(1);
printf("ADD HL,HL\n");
pta++;
}
void ADDHLSP(void)
{
DisplayOpcode(1);
printf("ADD HL,SP\n");
pta++;
}
void ADDIXBC(void)
{
DisplayOpcode(2);
printf("ADD IX,BC\n");
pta+=2;
}
void ADDIXDE(void)
{
DisplayOpcode(2);
printf("ADD IX,DE\n");
pta+=2;
}
void ADDIXIX(void)
{
DisplayOpcode(2);
printf("ADD IX,IX\n");
pta+=2;
}
void ADDIXSP(void)
{
DisplayOpcode(2);
printf("ADD IX,SP\n");
pta+=2;
}
void ADDIYBC(void)
{
DisplayOpcode(2);
printf("ADD IY,BC\n");
pta+=2;
}
void ADDIYDE(void)
{
DisplayOpcode(2);
printf("ADD IY,DE\n");
pta+=2;
}
void ADDIYIY(void)
{
DisplayOpcode(2);
printf("ADD IY,IY\n");
pta+=2;
}
void ADDIYSP(void)
{
DisplayOpcode(2);
printf("ADD IY,SP\n");
pta+=2;
}

//************************************************************* AND *******

void ANDR(void)
{
DisplayOpcode(1);
printf("AND A,");
DisplayRegister(z80[pta]-0xA0);
pta++;
}
void ANDXH(void)
{
DisplayOpcode(2);
printf("AND A,XH\n");
pta+=2;
}
void ANDXL(void)
{
DisplayOpcode(2);
printf("AND A,XL\n");
pta+=2;
}
void ANDYH(void)
{
DisplayOpcode(2);
printf("AND A,YH\n");
pta+=2;
}
void ANDYL(void)
{
DisplayOpcode(2);
printf("AND A,YL\n");
pta+=2;
}
void ANDN(void)
{
DisplayOpcode(2);
printf("AND A,#%2x\n",z80[pta+1]);
pta+=2;
}
void ANDIX(void)
{
DisplayOpcode(3);
printf("AND A,(IX+#%2x)\n",z80[pta+2]);
pta+=3;
}
void ANDIY(void)
{
DisplayOpcode(3);
printf("AND A,(IY+#%2x)\n",z80[pta+2]);
pta+=3;
}

//************************************************************* BIT *******

void BITBR(void)
{
int b=(z80[pta+1]-0x40)>>3;
DisplayOpcode(2);
printf("BIT %d,",b);
DisplayRegister(z80[pta+1]-0x40-(b<<3));
pta+=2;
}
void BITBI(void)
{
int b=(z80[pta+3]-0x40)>>3;
DisplayOpcode(4);
printf("BIT %d,(I%s+#%2X)\n",b,z80[pta]==0xDD?"X":"Y",z80[pta+2]);
pta+=4;
}

//************************************************************* CALL ******

void CALL(void)
{
DisplayOpcode(3);
printf("CALL #%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLC(void)
{
DisplayOpcode(3);
printf("CALL C,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLNC(void)
{
DisplayOpcode(3);
printf("CALL NC,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLM(void)
{
DisplayOpcode(3);
printf("CALL M,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLP(void)
{
DisplayOpcode(3);
printf("CALL P,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLZ(void)
{
DisplayOpcode(3);
printf("CALL Z,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLNZ(void)
{
DisplayOpcode(3);
printf("CALL NZ,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLPE(void)
{
DisplayOpcode(3);
printf("CALL PE,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void CALLPO(void)
{
DisplayOpcode(3);
printf("CALL PO,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}

//************************************************************* CCF *******

void CCF(void)
{
DisplayOpcode(1);
printf("CCF\n");
pta++;
}

//************************************************************* CP ********

void CPR(void)
{
DisplayOpcode(1);
printf("CP A,");
DisplayRegister(z80[pta]-0xB8);
pta++;
}
void CPXH(void)
{
DisplayOpcode(2);
printf("CP A,XH\n");
pta+=2;
}
void CPXL(void)
{
DisplayOpcode(2);
printf("CP A,XL\n");
pta+=2;
}
void CPYH(void)
{
DisplayOpcode(2);
printf("CP A,YH\n");
pta+=2;
}
void CPYL(void)
{
DisplayOpcode(2);
printf("CP A,YL\n");
pta+=2;
}
void CPN(void)
{
DisplayOpcode(2);
printf("CP A,#%2x\n",z80[pta+1]);
pta+=2;
}
void CPIX(void)
{
DisplayOpcode(3);
printf("CP A,(IX+#%2x)\n",z80[pta+2]);
pta+=3;
}
void CPIY(void)
{
DisplayOpcode(3);
printf("CP A,(IY+#%2x)\n",z80[pta+2]);
pta+=3;
}

//************************************************************* CPD *******

void CPD(void)
{
DisplayOpcode(2);
printf("CPD\n");
pta+=2;
}

//************************************************************* CPDR ******

void CPDR(void)
{
DisplayOpcode(2);
printf("CPDR\n");
pta+=2;
}

//************************************************************* CPI *******

void CPI(void)
{
DisplayOpcode(2);
printf("CPI\n");
pta+=2;
}

//************************************************************* CPIR ******

void CPIR(void)
{
DisplayOpcode(2);
printf("CPIR\n");
pta+=2;
}

//************************************************************* CPL *******

void CPL(void)
{
DisplayOpcode(1);
printf("CPL\n");
pta++;
}

//************************************************************* DAA *******

void DAA(void)
{
DisplayOpcode(1);
printf("DAA\n");
pta++;
}

//************************************************************* DEC *******

void DECR(void)
{
DisplayOpcode(1);
printf("DEC ");
DisplayRegister((z80[pta]-5)>>3);
pta++;
}
void DECXH(void)
{
DisplayOpcode(2);
printf("DEC XH\n");
pta+=2;
}
void DECXL(void)
{
DisplayOpcode(2);
printf("DEC XL\n");
pta+=2;
}
void DECYH(void)
{
DisplayOpcode(2);
printf("DEC YH\n");
pta+=2;
}
void DECYL(void)
{
DisplayOpcode(2);
printf("DEC YL\n");
pta+=2;
}
void DECBC(void)
{
DisplayOpcode(1);
printf("DEC BC\n");
pta++;
}
void DECDE(void)
{
DisplayOpcode(1);
printf("DEC DE\n");
pta++;
}
void DECHL(void)
{
DisplayOpcode(1);
printf("DEC HL\n");
pta++;
}
void DECSP(void)
{
DisplayOpcode(1);
printf("DEC SP\n");
pta++;
}
void DECIX(void)
{
DisplayOpcode(2);
printf("DEC IX\n");
pta+=2;
}
void DECIY(void)
{
DisplayOpcode(2);
printf("DEC IY\n");
pta+=2;
}
void DECMIX(void)
{
DisplayOpcode(3);
printf("DEC (IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void DECMIY(void)
{
DisplayOpcode(3);
printf("DEC (IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

//************************************************************* DI ********

void DI(void)
{
DisplayOpcode(1);
printf("DI\n");
pta++;
}

//************************************************************* DJNZ ******

void DJNZ(void)
{
DisplayOpcode(2);
printf("DJNZ #%4X\n",pta+2+(signed char)z80[pta+1]);
pta+=2;
}

//************************************************************* EI ********

void EI(void)
{
DisplayOpcode(1);
printf("EI\n");
pta++;
}

//************************************************************* EX ********

void EXSPHL(void)
{
DisplayOpcode(1);
printf("EX (SP),HL\n");
pta++;
}
void EXSPIX(void)
{
DisplayOpcode(2);
printf("EX (SP),IX\n");
pta+=2;
}
void EXSPIY(void)
{
DisplayOpcode(2);
printf("EX (SP),IY\n");
pta+=2;
}
void EXAFAF(void)
{
DisplayOpcode(1);
printf("EX AF,AF\'\n");
pta++;
}
void EXDEHL(void)
{
DisplayOpcode(1);
printf("EX DE,HL\n");
pta++;
}
void EXX(void)
{
DisplayOpcode(1);
printf("EXX\n");
pta++;
}

//************************************************************* HALT ******

void HALT(void)
{
DisplayOpcode(1);
printf("HALT\n");
pta++;
}

//************************************************************* IM ********

void IM01(void)
{
DisplayOpcode(2);
printf("IM 0/1*\n");
pta+=2;
}
void IM0(void)
{
DisplayOpcode(2);
printf("IM 0\n");
pta+=2;
}
void IM1(void)
{
DisplayOpcode(2);
printf("IM 1\n");
pta+=2;
}
void IM2(void)
{
DisplayOpcode(2);
printf("IM 2\n");
pta+=2;
}

//************************************************************* IN ********

void INAC(void)
{
DisplayOpcode(2);
printf("IN A,(C)\n");
pta+=2;
}
void INBC(void)
{
DisplayOpcode(2);
printf("IN B,(C)\n");
pta+=2;
}
void INCC(void)
{
DisplayOpcode(2);
printf("IN C,(C)\n");
pta+=2;
}
void INDC(void)
{
DisplayOpcode(2);
printf("IN D,(C)\n");
pta+=2;
}
void INEC(void)
{
DisplayOpcode(2);
printf("IN E,(C)\n");
pta+=2;
}
void INHC(void)
{
DisplayOpcode(2);
printf("IN H,(C)\n");
pta+=2;
}
void INLC(void)
{
DisplayOpcode(2);
printf("IN L,(C)\n");
pta+=2;
}
void INFC(void)
{
DisplayOpcode(2);
printf("IN F,(C)\n");
pta+=2;
}
void INA(void)
{
DisplayOpcode(2);
printf("IN A,(#%2X)\n",z80[pta+1]);
pta+=2;
}

//************************************************************* INC *******

void INCR(void)
{
DisplayOpcode(1);
printf("INC ");
DisplayRegister((z80[pta]-4)>>3);
pta++;
}
void INCXH(void)
{
DisplayOpcode(2);
printf("INC XH\n");
pta+=2;
}
void INCXL(void)
{
DisplayOpcode(2);
printf("INC XL\n");
pta+=2;
}
void INCYH(void)
{
DisplayOpcode(2);
printf("INC YH\n");
pta+=2;
}
void INCYL(void)
{
DisplayOpcode(2);
printf("INC YL\n");
pta+=2;
}
void INCBC(void)
{
DisplayOpcode(1);
printf("INC BC\n");
pta++;
}
void INCDE(void)
{
DisplayOpcode(1);
printf("INC DE\n");
pta++;
}
void INCHL(void)
{
DisplayOpcode(1);
printf("INC HL\n");
pta++;
}
void INCSP(void)
{
DisplayOpcode(1);
printf("INC SP\n");
pta++;
}
void INCIX(void)
{
DisplayOpcode(2);
printf("INC IX\n");
pta+=2;
}
void INCIY(void)
{
DisplayOpcode(2);
printf("INC IY\n");
pta+=2;
}
void INCMIX(void)
{
DisplayOpcode(3);
printf("INC (IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void INCMIY(void)
{
DisplayOpcode(3);
printf("INC (IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

//************************************************************* IND *******

void IND(void)
{
DisplayOpcode(2);
printf("IND\n");
pta+=2;
}
void INDR(void)
{
DisplayOpcode(2);
printf("INDR\n");
pta+=2;
}
void INI(void)
{
DisplayOpcode(2);
printf("INI\n");
pta+=2;
}
void INIR(void)
{
DisplayOpcode(2);
printf("INIR\n");
pta+=2;
}

//************************************************************* JP ********

void JP(void)
{
DisplayOpcode(3);
printf("JP #%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPHL(void)
{
DisplayOpcode(1);
printf("JP HL\n");
pta++;
}
void JPIX(void)
{
DisplayOpcode(2);
printf("JP IX\n");
pta+=2;
}
void JPIY(void)
{
DisplayOpcode(2);
printf("JP IY\n");
pta+=2;
}
void JPC(void)
{
DisplayOpcode(3);
printf("JP C,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPNC(void)
{
DisplayOpcode(3);
printf("JP NC,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPM(void)
{
DisplayOpcode(3);
printf("JP M,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPP(void)
{
DisplayOpcode(3);
printf("JP P,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPZ(void)
{
DisplayOpcode(3);
printf("JP Z,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPNZ(void)
{
DisplayOpcode(3);
printf("JP NZ,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPPE(void)
{
DisplayOpcode(3);
printf("JP PE,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void JPPO(void)
{
DisplayOpcode(3);
printf("JP PO,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}

//************************************************************* JR ********

void JR(void)
{
DisplayOpcode(2);
printf("JR #%4X\n",pta+2+(signed char)z80[pta+1]);
pta+=2;
}
void JRC(void)
{
DisplayOpcode(2);
printf("JR C,#%4X\n",pta+2+(signed char)z80[pta+1]);
pta+=2;
}
void JRNC(void)
{
DisplayOpcode(2);
printf("JR NC,#%4X\n",pta+2+(signed char)z80[pta+1]);
pta+=2;
}
void JRZ(void)
{
DisplayOpcode(2);
printf("JR Z,#%4X\n",pta+2+(signed char)z80[pta+1]);
pta+=2;
}
void JRNZ(void)
{
DisplayOpcode(2);
printf("JR NZ,#%4X\n",pta+2+(signed char)z80[pta+1]);
pta+=2;
}

//************************************************************* LD ********

void LDIA(void)
{
DisplayOpcode(2);
printf("LD I,A\n");
pta+=2;
}
void LDRA(void)
{
DisplayOpcode(2);
printf("LD R,A\n");
pta+=2;
}
void LDAI(void)
{
DisplayOpcode(2);
printf("LD A,I\n");
pta+=2;
}
void LDAR(void)
{
DisplayOpcode(2);
printf("LD A,R\n");
pta+=2;
}

void LDARG(void)
{
DisplayOpcode(1);
printf("LD A,");
DisplayRegister(z80[pta]-0x78);
pta++;
}
void LDBRG(void)
{
DisplayOpcode(1);
printf("LD B,");
DisplayRegister(z80[pta]-0x40);
pta++;
}
void LDCRG(void)
{
DisplayOpcode(1);
printf("LD C,");
DisplayRegister(z80[pta]-0x48);
pta++;
}
void LDDRG(void)
{
DisplayOpcode(1);
printf("LD D,");
DisplayRegister(z80[pta]-0x50);
pta++;
}
void LDERG(void)
{
DisplayOpcode(1);
printf("LD E,");
DisplayRegister(z80[pta]-0x58);
pta++;
}
void LDHRG(void)
{
DisplayOpcode(1);
printf("LD H,");
DisplayRegister(z80[pta]-0x60);
pta++;
}
void LDLRG(void)
{
DisplayOpcode(1);
printf("LD L,");
DisplayRegister(z80[pta]-0x68);
pta++;
}

void LDAN(void)
{
DisplayOpcode(2);
printf("LD A,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDBN(void)
{
DisplayOpcode(2);
printf("LD B,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDCN(void)
{
DisplayOpcode(2);
printf("LD C,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDDN(void)
{
DisplayOpcode(2);
printf("LD D,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDEN(void)
{
DisplayOpcode(2);
printf("LD E,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDHN(void)
{
DisplayOpcode(2);
printf("LD H,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDLN(void)
{
DisplayOpcode(2);
printf("LD L,#%2X\n",z80[pta+1]);
pta+=2;
}
void LDHLN(void)
{
DisplayOpcode(2);
printf("LD (HL),#%2X\n",z80[pta+1]);
pta+=2;
}

void LDAXH(void)
{
DisplayOpcode(2);
printf("LD A,XH\n");
pta+=2;
}
void LDAXL(void)
{
DisplayOpcode(2);
printf("LD A,XL\n");
pta+=2;
}
void LDAYH(void)
{
DisplayOpcode(2);
printf("LD A,YH\n");
pta+=2;
}
void LDAYL(void)
{
DisplayOpcode(2);
printf("LD A,YL\n");
pta+=2;
}
void LDBXH(void)
{
DisplayOpcode(2);
printf("LD B,XH\n");
pta+=2;
}
void LDBXL(void)
{
DisplayOpcode(2);
printf("LD B,XL\n");
pta+=2;
}
void LDBYH(void)
{
DisplayOpcode(2);
printf("LD B,YH\n");
pta+=2;
}
void LDBYL(void)
{
DisplayOpcode(2);
printf("LD B,YL\n");
pta+=2;
}

void LDCXH(void)
{
DisplayOpcode(2);
printf("LD C,XH\n");
pta+=2;
}
void LDCXL(void)
{
DisplayOpcode(2);
printf("LD C,XL\n");
pta+=2;
}
void LDCYH(void)
{
DisplayOpcode(2);
printf("LD C,YH\n");
pta+=2;
}
void LDCYL(void)
{
DisplayOpcode(2);
printf("LD C,YL\n");
pta+=2;
}
void LDDXH(void)
{
DisplayOpcode(2);
printf("LD D,XH\n");
pta+=2;
}
void LDDXL(void)
{
DisplayOpcode(2);
printf("LD D,XL\n");
pta+=2;
}
void LDDYH(void)
{
DisplayOpcode(2);
printf("LD D,YH\n");
pta+=2;
}
void LDDYL(void)
{
DisplayOpcode(2);
printf("LD D,YL\n");
pta+=2;
}

void LDEXH(void)
{
DisplayOpcode(2);
printf("LD E,XH\n");
pta+=2;
}
void LDEXL(void)
{
DisplayOpcode(2);
printf("LD E,XL\n");
pta+=2;
}
void LDEYH(void)
{
DisplayOpcode(2);
printf("LD E,YH\n");
pta+=2;
}
void LDEYL(void)
{
DisplayOpcode(2);
printf("LD E,YL\n");
pta+=2;
}

void LDHXH(void)
{
DisplayOpcode(2);
printf("LD H,XH\n");
pta+=2;
}
void LDHXL(void)
{
DisplayOpcode(2);
printf("LD H,XL\n");
pta+=2;
}
void LDHYH(void)
{
DisplayOpcode(2);
printf("LD H,YH\n");
pta+=2;
}
void LDHYL(void)
{
DisplayOpcode(2);
printf("LD H,YL\n");
pta+=2;
}

void LDLXH(void)
{
DisplayOpcode(2);
printf("LD L,XH\n");
pta+=2;
}
void LDLXL(void)
{
DisplayOpcode(2);
printf("LD L,XL\n");
pta+=2;
}
void LDLYH(void)
{
DisplayOpcode(2);
printf("LD L,YH\n");
pta+=2;
}
void LDLYL(void)
{
DisplayOpcode(2);
printf("LD L,YL\n");
pta+=2;
}

//************************************************************* LD ********

void LDABC(void)
{
DisplayOpcode(1);
printf("LD A,(BC)\n");
pta++;
}
void LDADE(void)
{
DisplayOpcode(1);
printf("LD A,(DE)\n");
pta++;
}
void LDAHL(void)
{
DisplayOpcode(1);
printf("LD A,(HL)\n");
pta++;
}
void LDAIX(void)
{
DisplayOpcode(3);
printf("LD A,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDAIY(void)
{
DisplayOpcode(3);
printf("LD A,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDANN(void)
{
DisplayOpcode(3);
printf("LD A,(#%4X)\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}

void LDBHL(void)
{
DisplayOpcode(1);
printf("LD B,(HL)\n");
pta++;
}
void LDBIX(void)
{
DisplayOpcode(3);
printf("LD B,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDBIY(void)
{
DisplayOpcode(3);
printf("LD B,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

void LDCHL(void)
{
DisplayOpcode(1);
printf("LD C,(HL)\n");
pta++;
}
void LDCIX(void)
{
DisplayOpcode(3);
printf("LD C,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDCIY(void)
{
DisplayOpcode(3);
printf("LD C,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

void LDDHL(void)
{
DisplayOpcode(1);
printf("LD D,(HL)\n");
pta++;
}
void LDDIX(void)
{
DisplayOpcode(3);
printf("LD D,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDDIY(void)
{
DisplayOpcode(3);
printf("LD D,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

void LDEHL(void)
{
DisplayOpcode(1);
printf("LD E,(HL)\n");
pta++;
}
void LDEIX(void)
{
DisplayOpcode(3);
printf("LD E,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDEIY(void)
{
DisplayOpcode(3);
printf("LD E,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

void LDHHL(void)
{
DisplayOpcode(1);
printf("LD H,(HL)\n");
pta++;
}
void LDHIX(void)
{
DisplayOpcode(3);
printf("LD H,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDHIY(void)
{
DisplayOpcode(3);
printf("LD H,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

void LDLHL(void)
{
DisplayOpcode(1);
printf("LD L,(HL)\n");
pta++;
}
void LDLIX(void)
{
DisplayOpcode(3);
printf("LD L,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void LDLIY(void)
{
DisplayOpcode(3);
printf("LD L,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}

void LDBCMNN(void)
{
DisplayOpcode(4);
printf("LD BC,(#%4X)\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}
void LDDEMNN(void)
{
DisplayOpcode(4);
printf("LD DE,(#%4X)\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}
void LDHLMNN(void)
{
DisplayOpcode(3);
printf("LD HL,(#%4X)\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void LDSPMNN(void)
{
DisplayOpcode(4);
printf("LD SP,(#%4X)\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}
void LDIXMNN(void)
{
DisplayOpcode(4);
printf("LD IX,(#%4X)\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}
void LDIYMNN(void)
{
DisplayOpcode(4);
printf("LD IY,(#%4X)\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}
void LDBCNN(void)
{
DisplayOpcode(3);
printf("LD BC,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void LDDENN(void)
{
DisplayOpcode(3);
printf("LD DE,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void LDHLNN(void)
{
DisplayOpcode(3);
printf("LD HL,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void LDSPNN(void)
{
DisplayOpcode(3);
printf("LD SP,#%4X\n",*(unsigned short int*)(&z80[pta+1]));
pta+=3;
}
void LDIXNN(void)
{
DisplayOpcode(4);
printf("LD IX,#%4X\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}
void LDIYNN(void)
{
DisplayOpcode(4);
printf("LD IY,#%4X\n",*(unsigned short int*)(&z80[pta+2]));
pta+=4;
}

void LDSPHL(void)
{
DisplayOpcode(1);
printf("LD SP,HL\n");
pta++;
}
void LDSPIX(void)
{
DisplayOpcode(2);
printf("LD SP,IX\n");
pta+=2;
}
void LDSPIY(void)
{
DisplayOpcode(2);
printf("LD SP,IY\n");
pta+=2;
}

void LDMHLN(void)
{
DisplayOpcode(2);
printf("LD (HL),#%2X\n",z80[pta+1]);
pta+=2;
}
void LDMHLR(void)
{
DisplayOpcode(1);
printf("LD (HL),");
DisplayRegister((z80[pta]-0x70));
pta++;
}
void LDMBCA(void)
{
DisplayOpcode(1);
printf("LD (BC),A\n");
pta++;
}
void LDMDEA(void)
{
DisplayOpcode(1);
printf("LD (DE),A\n");
pta++;
}


void LDMNNA(void)
{
DisplayOpcode(3);
printf("LD (#%4X),A\n",*(unsigned short int *)(&z80[pta+1]));
pta+=3;
}
void LDMNNBC(void)
{
DisplayOpcode(4);
printf("LD (#%4X),BC\n",*(unsigned short int *)(&z80[pta+2]));
pta+=4;
}
void LDMNNDE(void)
{
DisplayOpcode(4);
printf("LD (#%4X),DE\n",*(unsigned short int *)(&z80[pta+2]));
pta+=4;
}
void LDMNNHL(void)
{
DisplayOpcode(3);
printf("LD (#%4X),HL\n",*(unsigned short int *)(&z80[pta+1]));
pta+=3;
}
void LDMNNIX(void)
{
DisplayOpcode(4);
printf("LD (#%4X),IX\n",*(unsigned short int *)(&z80[pta+2]));
pta+=4;
}
void LDMNNIY(void)
{
DisplayOpcode(4);
printf("LD (#%4X),IY\n",*(unsigned short int *)(&z80[pta+2]));
pta+=4;
}
void LDMNNSP(void)
{
DisplayOpcode(4);
printf("LD (#%4X),SP\n",*(unsigned short int *)(&z80[pta+2]));
pta+=4;
}

void LDMIXN(void)
{
DisplayOpcode(4);
printf("LD (IX+#%2X),#%2X\n",z80[pta+2],z80[pta+3]);
pta+=4;
}
void LDMIYN(void)
{
DisplayOpcode(4);
printf("LD (IY+#%2X),#%2X\n",z80[pta+2],z80[pta+3]);
pta+=4;
}
void LDMIXR(void)
{
DisplayOpcode(3);
printf("LD (IX+#%2X),",z80[pta+2]);
DisplayRegister(z80[pta+1]-0x70);
pta+=3;
}
void LDMIYR(void)
{
DisplayOpcode(3);
printf("LD (IY+#%2X),",z80[pta+2]);
DisplayRegister(z80[pta+1]-0x70);
pta+=3;
}
void LDD(void)
{
DisplayOpcode(2);
printf("LDD\n");
pta+=2;
}
void LDDR(void)
{
DisplayOpcode(2);
printf("LDDR\n");
pta+=2;
}
void LDI(void)
{
DisplayOpcode(2);
printf("LDI\n");
pta+=2;
}
void LDIR(void)
{
DisplayOpcode(2);
printf("LDIR\n");
pta+=2;
}

//******************************************************** NEG ***********

void NEG(void)
{
DisplayOpcode(2);
printf("NEG\n");
pta+=2;
}

//******************************************************** NOP ***********

void NOP(void)
{
DisplayOpcode(1);
printf("NOP\n");
pta++;
}

//******************************************************** OR ***********

void ORR(void)
{
DisplayOpcode(1);
printf("OR A,");
DisplayRegister(z80[pta]-0xB0);
pta++;
}
void ORN(void)
{
DisplayOpcode(2);
printf("OR A,#%2X\n",z80[pta+1]);
pta+=2;
}
void ORIX(void)
{
DisplayOpcode(3);
printf("OR A,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void ORIY(void)
{
DisplayOpcode(3);
printf("OR A,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}
void ORXH(void)
{
DisplayOpcode(2);
printf("OR A,XH\n");
pta+=2;
}
void ORXL(void)
{
DisplayOpcode(2);
printf("OR A,XL\n");
pta+=2;
}
void ORYH(void)
{
DisplayOpcode(2);
printf("OR A,YH\n");
pta+=2;
}
void ORYL(void)
{
DisplayOpcode(2);
printf("OR A,YL\n");
pta+=2;
}

//******************************************************** OUT ***********

void OUTNA(void)
{
DisplayOpcode(2);
printf("OUT (#%2X),A\n",z80[pta+1]);
pta+=2;
}
void OUTC0(void)
{
DisplayOpcode(2);
printf("OUT (C),0\n");
pta+=2;
}
void OUTCA(void)
{
DisplayOpcode(2);
printf("OUT (C),A\n");
pta+=2;
}
void OUTCB(void)
{
DisplayOpcode(2);
printf("OUT (C),B\n");
pta+=2;
}
void OUTCC(void)
{
DisplayOpcode(2);
printf("OUT (C),C\n");
pta+=2;
}
void OUTCD(void)
{
DisplayOpcode(2);
printf("OUT (C),D\n");
pta+=2;
}
void OUTCE(void)
{
DisplayOpcode(2);
printf("OUT (C),E\n");
pta+=2;
}
void OUTCH(void)
{
DisplayOpcode(2);
printf("OUT (C),H\n");
pta+=2;
}
void OUTCL(void)
{
DisplayOpcode(2);
printf("OUT (C),L\n");
pta+=2;
}

void OUTD(void)
{
DisplayOpcode(2);
printf("OUTD\n");
pta+=2;
}
void OTDR(void)
{
DisplayOpcode(2);
printf("OTDR\n");
pta+=2;
}
void OUTI(void)
{
DisplayOpcode(2);
printf("OUTI\n");
pta+=2;
}
void OTIR(void)
{
DisplayOpcode(2);
printf("OTIR\n");
pta+=2;
}

//************************************************************* POP ********

void POPAF(void)
{
DisplayOpcode(1);
printf("POP AF\n");
pta++;
}
void POPBC(void)
{
DisplayOpcode(1);
printf("POP BC\n");
pta++;
}
void POPDE(void)
{
DisplayOpcode(1);
printf("POP DE\n");
pta++;
}
void POPHL(void)
{
DisplayOpcode(1);
printf("POP HL\n");
pta++;
}
void POPIX(void)
{
DisplayOpcode(2);
printf("POP IX\n");
pta+=2;
}
void POPIY(void)
{
DisplayOpcode(2);
printf("POP IY\n");
pta+=2;
}

//************************************************************* PUSH *******

void PUSHAF(void)
{
DisplayOpcode(1);
printf("PUSH AF\n");
pta++;
}
void PUSHBC(void)
{
DisplayOpcode(1);
printf("PUSH BC\n");
pta++;
}
void PUSHDE(void)
{
DisplayOpcode(1);
printf("PUSH DE\n");
pta++;
}
void PUSHHL(void)
{
DisplayOpcode(1);
printf("PUSH HL\n");
pta++;
}
void PUSHIX(void)
{
DisplayOpcode(2);
printf("PUSH IX\n");
pta+=2;
}
void PUSHIY(void)
{
DisplayOpcode(2);
printf("PUSH IY\n");
pta+=2;
}

//************************************************************* RES *******

void RESBR(void)
{
int b=(z80[pta+1]-0x80)>>3;
DisplayOpcode(2);
printf("RES %d,",b);
DisplayRegister(z80[pta+1]-0x80-(b<<3));
pta+=2;
}
void RESBI(void)
{
int b=(z80[pta+3]-0x80)>>3;
int r=z80[pta+3]-0x80-(b<<3);
DisplayOpcode(4);
if (r==6)
   printf("RES %d,(I%s+#%2X)\n",b,z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",RES %d,(I%s+#%2X)\n",b,z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}


//************************************************************* RET *******
void RET(void)
{
DisplayOpcode(1);
printf("RET\n");
pta++;
}
void RETC(void)
{
DisplayOpcode(1);
printf("RET C\n");
pta++;
}
void RETNC(void)
{
DisplayOpcode(1);
printf("RET NC\n");
pta++;
}
void RETM(void)
{
DisplayOpcode(1);
printf("RET M\n");
pta++;
}
void RETP(void)
{
DisplayOpcode(1);
printf("RET P\n");
pta++;
}
void RETZ(void)
{
DisplayOpcode(1);
printf("RET Z\n");
pta++;
}
void RETNZ(void)
{
DisplayOpcode(1);
printf("RET NZ\n");
pta++;
}
void RETPE(void)
{
DisplayOpcode(1);
printf("RET PE\n");
pta++;
}
void RETPO(void)
{
DisplayOpcode(1);
printf("RET PO\n");
pta++;
}

void RETI(void)
{
DisplayOpcode(2);
printf("RETI\n");
pta+=2;
}
void RETN(void)
{
DisplayOpcode(2);
printf("RETN\n");
pta+=2;
}

//******************************************************** RL RR ***********

void RLA(void)
{
DisplayOpcode(1);
printf("RLA\n");
pta++;
}
void RLCA(void)
{
DisplayOpcode(1);
printf("RLCA\n");
pta++;
}
void RRA(void)
{
DisplayOpcode(1);
printf("RRA\n");
pta++;
}
void RRCA(void)
{
DisplayOpcode(1);
printf("RRCA\n");
pta++;
}
void RLD(void)
{
DisplayOpcode(2);
printf("RLD\n");
pta+=2;
}
void RRD(void)
{
DisplayOpcode(2);
printf("RRD\n");
pta+=2;
}
void RLR(void)
{
DisplayOpcode(2);
printf("RL ");
DisplayRegister(z80[pta+1]-0x10);
pta+=2;
}
void RLCR(void)
{
DisplayOpcode(2);
printf("RLC ");
DisplayRegister(z80[pta+1]);
pta+=2;
}
void RRR(void)
{
DisplayOpcode(2);
printf("RL ");
DisplayRegister(z80[pta+1]-0x18);
pta+=2;
}
void RRCR(void)
{
DisplayOpcode(2);
printf("RLC ");
DisplayRegister(z80[pta+1]-0x08);
pta+=2;
}
void RLCBI(void)
{
int r=z80[pta+3]-0x00;
DisplayOpcode(4);
if (r==6)
   printf("RLC (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",RLC (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}
void RRCBI(void)
{
int r=z80[pta+3]-0x08;
DisplayOpcode(4);
if (r==6)
   printf("RRC (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",RRC (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}
void RLBI(void)
{
int r=z80[pta+3]-0x10;
DisplayOpcode(4);
if (r==6)
   printf("RL (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",RL (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}
void RRBI(void)
{
int r=z80[pta+3]-0x18;
DisplayOpcode(4);
if (r==6)
   printf("RR (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",RR (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}

//****************************************************************** RST ****

void RST0(void)
{
DisplayOpcode(1);
printf("RST #00\n");
pta++;
}
void RST8(void)
{
DisplayOpcode(1);
printf("RST #08\n");
pta++;
}
void RST10(void)
{
DisplayOpcode(1);
printf("RST #10\n");
pta++;
}
void RST18(void)
{
DisplayOpcode(1);
printf("RST #18\n");
pta++;
}
void RST20(void)
{
DisplayOpcode(1);
printf("RST #20\n");
pta++;
}
void RST28(void)
{
DisplayOpcode(1);
printf("RST #28\n");
pta++;
}
void RST30(void)
{
DisplayOpcode(1);
printf("RST #30\n");
pta++;
}
void RST38(void)
{
DisplayOpcode(1);
printf("RST #38\n");
pta++;
}

//*************************************************************** SUB ******

void SBCAR(void)
{
DisplayOpcode(1);
printf("SBC A,");
DisplayRegister(z80[pta]-0x98);
pta++;
}
void SBCAN(void)
{
DisplayOpcode(2);
printf("SBC A,#%2X\n",z80[pta+1]);
pta+=2;
}
void SBCAMIX(void)
{
DisplayOpcode(3);
printf("SBC A,(IX+#%2X)\n",z80[pta+2]);
pta+=3;
}
void SBCAMIY(void)
{
DisplayOpcode(3);
printf("SBC A,(IY+#%2X)\n",z80[pta+2]);
pta+=3;
}
void SBCHLBC(void)
{
DisplayOpcode(2);
printf("SBC HL,BC\n");
pta+=2;
}
void SBCHLDE(void)
{
DisplayOpcode(2);
printf("SBC HL,DE\n");
pta+=2;
}
void SBCHLHL(void)
{
DisplayOpcode(2);
printf("SBC HL,HL\n");
pta+=2;
}
void SBCHLSP(void)
{
DisplayOpcode(2);
printf("SBC HL,SP\n");
pta+=2;
}


void SBCAXH(void)
{
DisplayOpcode(2);
printf("SBC A,XH\n");
pta+=2;
}
void SBCAXL(void)
{
DisplayOpcode(2);
printf("SBC A,XL\n");
pta+=2;
}
void SBCAYH(void)
{
DisplayOpcode(2);
printf("SBC A,YH\n");
pta+=2;
}
void SBCAYL(void)
{
DisplayOpcode(2);
printf("SBC A,YL\n");
pta+=2;
}

//**************************************************************** SCF *****

void SCF(void)
{
DisplayOpcode(1);
printf("SCF\n");
pta++;
}

//**************************************************************** SET *****

void SETBR(void)
{
int b=(z80[pta+1]-0xC0)>>3;
DisplayOpcode(2);
printf("SET %d,",b);
DisplayRegister(z80[pta+1]-0xC0-(b<<3));
pta+=2;
}
void SETBI(void)
{
int b=(z80[pta+3]-0xC0)>>3;
int r=z80[pta+3]-0xC0-(b<<3);
DisplayOpcode(4);
if (r==6)
   printf("SET %d,(I%s+#%2X)\n",b,z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",SET %d,(I%s+#%2X)\n",b,z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}


//*************************************************************** SL SR *****

void SLAR(void)
{
DisplayOpcode(2);
printf("SLA ");
DisplayRegister(z80[pta+1]-0x20);
pta+=2;
}
void SRAR(void)
{
DisplayOpcode(2);
printf("SRA ");
DisplayRegister(z80[pta+1]-0x28);
pta+=2;
}
void SLLR(void)
{
DisplayOpcode(2);
printf("SLL ");
DisplayRegister(z80[pta+1]-0x30);
pta+=2;
}
void SRLR(void)
{
DisplayOpcode(2);
printf("SRL ");
DisplayRegister(z80[pta+1]-0x38);
pta+=2;
}
void SLABI(void)
{
int r=z80[pta+3]-0x20;
DisplayOpcode(4);
if (r==6)
   printf("SLA (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",SLA (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}
void SRABI(void)
{
int r=z80[pta+3]-0x28;
DisplayOpcode(4);
if (r==6)
   printf("SRA (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",SRA (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}
void SLLBI(void)
{
int r=z80[pta+3]-0x30;
DisplayOpcode(4);
if (r==6)
   printf("SLL (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",SLL (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}
void SRLBI(void)
{
int r=z80[pta+3]-0x38;
DisplayOpcode(4);
if (r==6)
   printf("SRL (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
else
   {
   printf("LD ");
   DisplayRegisterLight(r);
   printf(",SRL (I%s+#%2X)\n",z80[pta]==0xDD?"X":"Y",z80[pta+2]);
   }
pta+=4;
}

//**************************************************************** SUB *****

void SUBR(void)
{
DisplayOpcode(1);
printf("SUB A,");
DisplayRegister(z80[pta]-0x90);
pta++;
}
void SUBXH(void)
{
DisplayOpcode(2);
printf("SUB A,XH\n");
pta+=2;
}
void SUBXL(void)
{
DisplayOpcode(2);
printf("SUB A,XL\n");
pta+=2;
}
void SUBYH(void)
{
DisplayOpcode(2);
printf("SUB A,YH\n");
pta+=2;
}
void SUBYL(void)
{
DisplayOpcode(2);
printf("SUB A,YL\n");
pta+=2;
}
void SUBN(void)
{
DisplayOpcode(2);
printf("SUB A,#%2x\n",z80[pta+1]);
pta+=2;
}
void SUBIX(void)
{
DisplayOpcode(3);
printf("SUB A,(IX+#%2x)\n",z80[pta+2]);
pta+=3;
}
void SUBIY(void)
{
DisplayOpcode(3);
printf("SUB A,(IY+#%2x)\n",z80[pta+2]);
pta+=3;
}


//**************************************************************** XOR *****

void XORR(void)
{
DisplayOpcode(1);
printf("XOR A,");
DisplayRegister(z80[pta]-0xA8);
pta++;
}
void XORXH(void)
{
DisplayOpcode(2);
printf("XOR A,XH\n");
pta+=2;
}
void XORXL(void)
{
DisplayOpcode(2);
printf("XOR A,XL\n");
pta+=2;
}
void XORYH(void)
{
DisplayOpcode(2);
printf("XOR A,YH\n");
pta+=2;
}
void XORYL(void)
{
DisplayOpcode(2);
printf("XOR A,YL\n");
pta+=2;
}
void XORN(void)
{
DisplayOpcode(2);
printf("XOR A,#%2x\n",z80[pta+1]);
pta+=2;
}
void XORIX(void)
{
DisplayOpcode(3);
printf("XOR A,(IX+#%2x)\n",z80[pta+2]);
pta+=3;
}
void XORIY(void)
{
DisplayOpcode(3);
printf("XOR A,(IY+#%2x)\n",z80[pta+2]);
pta+=3;
}




void DisAssembleLevel2(void)
{
SecondJump[*((unsigned short int*)(&z80[pta+2]))]();
}
int DisAssemble(int size)
{
pta=Org;

if (Display_Comment)
   {
   while (pta<size)
      {
      printf("%8X - ",pta);
      FirstJump[*((unsigned short int*)(&z80[pta]))]();
      }
   }
else
   {
   while (pta<size)
      {
      FirstJump[*((unsigned short int*)(&z80[pta]))]();
      }
   }

return ON;
}

int InitTable(void)
{
int i,j;

printf("Building Table ");fflush(stdout);

for (i=0;i<0xFFFF;i++)
    FirstJump[i]=UNKNOWN;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0088+i+j]=ADCAR;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00CE + i]=ADCAN;
FirstJump[0x8CDD]=ADCAXH;
FirstJump[0x8DDD]=ADCAXL;
FirstJump[0x8CFD]=ADCAYH;
FirstJump[0x8DFD]=ADCAYL;
FirstJump[0x8EDD]=ADCAIX;
FirstJump[0x8EFD]=ADCAIY;
FirstJump[0x4AED]=ADCHLBC;
FirstJump[0x5AED]=ADCHLDE;
FirstJump[0x6AED]=ADCHLHL;
FirstJump[0x7AED]=ADCHLSP;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0080+i+j]=ADDAR;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00C6+i]=ADDAN;
FirstJump[0x84DD]=ADDAXH;
FirstJump[0x85DD]=ADDAXL;
FirstJump[0x84FD]=ADDAYH;
FirstJump[0x85FD]=ADDAYL;
FirstJump[0x86DD]=ADDAIX;
FirstJump[0x86FD]=ADDAIY;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0009+i]=ADDHLBC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0019+i]=ADDHLDE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0029+i]=ADDHLHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0039+i]=ADDHLSP;
FirstJump[0x09DD]=ADDIXBC;
FirstJump[0x19DD]=ADDIXDE;
FirstJump[0x29DD]=ADDIXIX;
FirstJump[0x39DD]=ADDIXSP;
FirstJump[0x09FD]=ADDIYBC;
FirstJump[0x19FD]=ADDIYDE;
FirstJump[0x29FD]=ADDIYIY;
FirstJump[0x39FD]=ADDIYSP;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00A0+i+j]=ANDR;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00E6+i]=ANDN;
FirstJump[0xA4DD]=ANDXH;
FirstJump[0xA5DD]=ANDXL;
FirstJump[0xA4FD]=ANDYH;
FirstJump[0xA5FD]=ANDYL;
FirstJump[0xA6DD]=ANDIX;
FirstJump[0xA6FD]=ANDIY;

for (i=0;i<0x4000;i+=0x100)
    FirstJump[0x40CB+i]=BITBR;

for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00CD+i]=CALL;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00DC+i]=CALLC;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00D4+i]=CALLNC;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00FC+i]=CALLM;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00F4+i]=CALLP;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00CC+i]=CALLZ;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00C4+i]=CALLNZ;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00EC+i]=CALLPE;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00E4+i]=CALLPO;

for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x003F+i]=CCF;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00B8+i+j]=CPR;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00FE + i]=CPN;
FirstJump[0xBCDD]=CPXH;
FirstJump[0xBDDD]=CPXL;
FirstJump[0xBCFD]=CPYH;
FirstJump[0xBDFD]=CPYL;
FirstJump[0xBEDD]=CPIX;
FirstJump[0xBEFD]=CPIY;

FirstJump[0xA9ED]=CPD;
FirstJump[0xB9ED]=CPDR;
FirstJump[0xA1ED]=CPI;
FirstJump[0xB1ED]=CPIR;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x002F+i]=CPL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0027+i]=DAA;

for (j=0;j<64;j+=8)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0005+i+j]=DECR;
FirstJump[0x25DD]=DECXH;
FirstJump[0x2DDD]=DECXL;
FirstJump[0x25FD]=DECYH;
FirstJump[0x2DFD]=DECYL;
FirstJump[0x35DD]=DECMIX;
FirstJump[0x35FD]=DECMIY;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x000B+i]=DECBC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x001B+i]=DECDE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x002B+i]=DECHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x003B+i]=DECSP;
FirstJump[0x2BDD]=DECIX;
FirstJump[0x2BFD]=DECIY;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F3+i]=DI;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0010+i]=DJNZ;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00FB+i]=EI;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E3+i]=EXSPHL;
FirstJump[0xE3DD]=EXSPIX;
FirstJump[0xE3FD]=EXSPIY;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0008+i]=EXAFAF;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00EB+i]=EXDEHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D9+i]=EXX;

FirstJump[0x46ED]=IM0;
FirstJump[0x56ED]=IM1;
FirstJump[0x5EED]=IM2;

FirstJump[0x40ED]=INBC;
FirstJump[0x48ED]=INCC;
FirstJump[0x50ED]=INDC;
FirstJump[0x58ED]=INEC;
FirstJump[0x60ED]=INHC;
FirstJump[0x68ED]=INLC;
FirstJump[0x70ED]=INFC;
FirstJump[0x78ED]=INAC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00DB+i]=INA;

for (j=0;j<64;j+=8)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0004+i+j]=INCR;
FirstJump[0x24DD]=INCXH;
FirstJump[0x2CDD]=INCXL;
FirstJump[0x24FD]=INCYH;
FirstJump[0x2CFD]=INCYL;
FirstJump[0x34DD]=INCMIX;
FirstJump[0x34FD]=INCMIY;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0003+i]=INCBC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0013+i]=INCDE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0023+i]=INCHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0033+i]=INCSP;
FirstJump[0x23DD]=INCIX;
FirstJump[0x23FD]=INCIY;

FirstJump[0xAAED]=IND;
FirstJump[0xBAED]=INDR;
FirstJump[0xA2ED]=INI;
FirstJump[0xB2ED]=INIR;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C3+i]=JP;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E9+i]=JPHL;
FirstJump[0xE9DD]=JPIX;
FirstJump[0xE9FD]=JPIY;

for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00DA+i]=JPC;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00D2+i]=JPNC;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00FA+i]=JPM;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00F2+i]=JPP;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00CA+i]=JPZ;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00C2+i]=JPNZ;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00EA+i]=JPPE;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00E2+i]=JPPO;

for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0018+i]=JR;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0038+i]=JRC;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0030+i]=JRNC;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0028+i]=JRZ;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0020+i]=JRNZ;

FirstJump[0x47ED]=LDIA;
FirstJump[0x4FED]=LDRA;
FirstJump[0x57ED]=LDAI;
FirstJump[0x5FED]=LDAR;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0078+i+j]=LDARG;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0040+i+j]=LDBRG;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0048+i+j]=LDCRG;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0050+i+j]=LDDRG;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0058+i+j]=LDERG;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0060+i+j]=LDHRG;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0068+i+j]=LDLRG;

FirstJump[0x7CDD]=LDAXH;
FirstJump[0x7DDD]=LDAXL;
FirstJump[0x7CFD]=LDAYH;
FirstJump[0x7DFD]=LDAYL;
FirstJump[0x44DD]=LDBXH;
FirstJump[0x45DD]=LDBXL;
FirstJump[0x44FD]=LDBYH;
FirstJump[0x45FD]=LDBYL;
FirstJump[0x4CDD]=LDCXH;
FirstJump[0x4DDD]=LDCXL;
FirstJump[0x4CFD]=LDCYH;
FirstJump[0x4DFD]=LDCYL;
FirstJump[0x54DD]=LDDXH;
FirstJump[0x55DD]=LDDXL;
FirstJump[0x54FD]=LDDYH;
FirstJump[0x55FD]=LDDYL;
FirstJump[0x5CDD]=LDEXH;
FirstJump[0x5DDD]=LDEXL;
FirstJump[0x5CFD]=LDEYH;
FirstJump[0x5DFD]=LDEYL;
FirstJump[0x64DD]=LDHXH;
FirstJump[0x65DD]=LDHXL;
FirstJump[0x64FD]=LDHYH;
FirstJump[0x65FD]=LDHYL;
FirstJump[0x6CDD]=LDLXH;
FirstJump[0x6DDD]=LDLXL;
FirstJump[0x6CFD]=LDLYH;
FirstJump[0x6DFD]=LDLYL;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x003E + i]=LDAN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0006+i]=LDBN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x000E + i]=LDCN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0016+i]=LDDN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x001E + i]=LDEN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0026+i]=LDHN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x002E + i]=LDLN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0036+i]=LDHLN;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x000A+i]=LDABC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x001A+i]=LDADE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x007E + i]=LDAHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x003A+i]=LDANN;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0046+i]=LDBHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x004E + i]=LDCHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0056+i]=LDDHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x005E + i]=LDEHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0066+i]=LDHHL;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x006E + i]=LDLHL;

FirstJump[0x7EDD]=LDAIX;
FirstJump[0x7EFD]=LDAIY;
FirstJump[0x46DD]=LDBIX;
FirstJump[0x46FD]=LDBIY;
FirstJump[0x4EDD]=LDCIX;
FirstJump[0x4EFD]=LDCIY;
FirstJump[0x56DD]=LDDIX;
FirstJump[0x56FD]=LDDIY;
FirstJump[0x5EDD]=LDEIX;
FirstJump[0x5EFD]=LDEIY;
FirstJump[0x66DD]=LDHIX;
FirstJump[0x66FD]=LDHIY;
FirstJump[0x6EDD]=LDLIX;
FirstJump[0x6EFD]=LDLIY;

FirstJump[0x4BED]=LDBCMNN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0001+i]=LDBCNN;
FirstJump[0x5BED]=LDDEMNN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0011+i]=LDDENN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x002A+i]=LDHLMNN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0021+i]=LDHLNN;
FirstJump[0x7BED]=LDSPMNN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0031+i]=LDSPNN;
FirstJump[0x2ADD]=LDIXMNN;
FirstJump[0x21DD]=LDIXNN;
FirstJump[0x2AFD]=LDIYMNN;
FirstJump[0x21FD]=LDIYNN;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F9+i]=LDSPHL;
FirstJump[0xF9DD]=LDSPIX;
FirstJump[0xF9FD]=LDSPIY;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0036+i]=LDMHLN;
for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0070+i+j]=LDMHLR;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0002+i]=LDMBCA;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0012+i]=LDMDEA;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0076+i]=HALT;       // laisser a cette place

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0032+i]=LDMNNA;
FirstJump[0x43ED]=LDMNNBC;
FirstJump[0x53ED]=LDMNNDE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0022+i]=LDMNNHL;
FirstJump[0x22DD]=LDMNNIX;
FirstJump[0x22FD]=LDMNNIY;
FirstJump[0x73ED]=LDMNNSP;
FirstJump[0x36DD]=LDMIXN;
FirstJump[0x36FD]=LDMIYN;
for (j=0;j<8;j++)
   FirstJump[0x70DD+j*256]=LDMIXR;
for (j=0;j<8;j++)
   FirstJump[0x70FD+j*256]=LDMIYR;

FirstJump[0xA8ED]=LDD;
FirstJump[0xB8ED]=LDDR;
FirstJump[0xA0ED]=LDI;
FirstJump[0xB0ED]=LDIR;

FirstJump[0x44ED]=NEG;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0000+i]=NOP;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00B0+i+j]=ORR;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F6+i]=ORN;

FirstJump[0xB6DD]=ORIX;
FirstJump[0xB6FD]=ORIY;
FirstJump[0xB4DD]=ORXH;
FirstJump[0xB5DD]=ORXL;
FirstJump[0xB4FD]=ORYH;
FirstJump[0xB5FD]=ORYL;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D3+i]=OUTNA;
FirstJump[0x71ED]=OUTC0;
FirstJump[0x79ED]=OUTCA;
FirstJump[0x41ED]=OUTCB;
FirstJump[0x49ED]=OUTCC;
FirstJump[0x51ED]=OUTCD;
FirstJump[0x59ED]=OUTCE;
FirstJump[0x61ED]=OUTCH;
FirstJump[0x69ED]=OUTCL;

FirstJump[0xABED]=OUTD;
FirstJump[0xBBED]=OTDR;
FirstJump[0xA3ED]=OUTI;
FirstJump[0xB3ED]=OTIR;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F1+i]=POPAF;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C1+i]=POPBC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D1+i]=POPDE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E1+i]=POPHL;
FirstJump[0xE1DD]=POPIX;
FirstJump[0xE1FD]=POPIY;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F5+i]=PUSHAF;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C5+i]=PUSHBC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D5+i]=PUSHDE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E5+i]=PUSHHL;
FirstJump[0xE5DD]=PUSHIX;
FirstJump[0xE5FD]=PUSHIY;

for (i=0;i<0x4000;i+=0x100)
    FirstJump[0x80CB+i]=RESBR;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C9+i]=RET;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D8+i]=RETC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D0+i]=RETNC;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F8+i]=RETM;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F0+i]=RETP;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C8+i]=RETZ;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C0+i]=RETNZ;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E8+i]=RETPE;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E0+i]=RETPO;
FirstJump[0x4DED]=RETI;
FirstJump[0x45ED]=RETN;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0017+i]=RLA;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0007+i]=RLCA;

for (j=0;j<8;j++)
   FirstJump[0x10CB+j*256]=RLR;
for (j=0;j<8;j++)
   FirstJump[0x00CB+j*256]=RLCR;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x001F+i]=RRA;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x000F+i]=RRCA;

for (j=0;j<8;j++)
   FirstJump[0x08CB+j*256]=RRCR;
for (j=0;j<8;j++)
   FirstJump[0x18CB+j*256]=RRR;

FirstJump[0x6FED]=RLD;
FirstJump[0x67ED]=RRD;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00C7+i]=RST0;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00CF+i]=RST8;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00D7+i]=RST10;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00DF+i]=RST18;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00E7+i]=RST20;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00EF+i]=RST28;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00F7+i]=RST30;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00FF+i]=RST38;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0098+i+j]=SBCAR;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x00DE + i]=SBCAN;
FirstJump[0x9CDD]=SBCAXH;
FirstJump[0x9DDD]=SBCAXL;
FirstJump[0x9CFD]=SBCAYH;
FirstJump[0x9DFD]=SBCAYL;
FirstJump[0x9EDD]=SBCAMIX;
FirstJump[0x9EFD]=SBCAMIY;
FirstJump[0x42ED]=SBCHLBC;
FirstJump[0x52ED]=SBCHLDE;
FirstJump[0x62ED]=SBCHLHL;
FirstJump[0x72ED]=SBCHLSP;

for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0037+i]=SCF;

for (i=0;i<0x4000;i+=0x100)
    FirstJump[0xC0CB+i]=SETBR;


for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0017+i]=RLA;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x0007+i]=RLCA;
for (j=0;j<8;j++)
   FirstJump[0x10CB+j*256]=RLR;
for (j=0;j<8;j++)
   FirstJump[0x00CB+j*256]=RLCR;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x001F+i]=RRA;
for (i=0;i<0x10000;i+=0x100)
   FirstJump[0x000F+i]=RRCA;
for (j=0;j<8;j++)
   FirstJump[0x08CB+j*256]=RRCR;
for (j=0;j<8;j++)
   FirstJump[0x18CB+j*256]=RRR;
FirstJump[0x6FED]=RLD;
FirstJump[0x67ED]=RRD;


for (j=0;j<8;j++)
   FirstJump[0x20CB+j*256]=SLAR;
for (j=0;j<8;j++)
   FirstJump[0x28CB+j*256]=SRAR;
for (j=0;j<8;j++)
   FirstJump[0x30CB+j*256]=SLLR;
for (j=0;j<8;j++)
   FirstJump[0x38CB+j*256]=SRLR;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x0090+i+j]=SUBR;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00D6+i]=SUBN;
FirstJump[0x94DD]=SUBXH;
FirstJump[0x95DD]=SUBXL;
FirstJump[0x94FD]=SUBYH;
FirstJump[0x95FD]=SUBYL;
FirstJump[0x96DD]=SUBIX;
FirstJump[0x96FD]=SUBIY;

for (j=0;j<8;j++)
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00A8+i+j]=XORR;
for (i=0;i<0x10000;i+=0x100)
    FirstJump[0x00EE + i]=XORN;
FirstJump[0xACDD]=XORXH;
FirstJump[0xADDD]=XORXL;
FirstJump[0xACFD]=XORYH;
FirstJump[0xADFD]=XORYL;
FirstJump[0xAEDD]=XORIX;
FirstJump[0xAEFD]=XORIY;

FirstJump[0xCBDD]=DisAssembleLevel2;
FirstJump[0xCBFD]=DisAssembleLevel2;

//*** opcodes en doublons, non documentes

FirstJump[0x4CED]=NEG;
FirstJump[0x54ED]=NEG;
FirstJump[0x5CED]=NEG;
FirstJump[0x64ED]=NEG;
FirstJump[0x6CED]=NEG;
FirstJump[0x74ED]=NEG;
FirstJump[0x7CED]=NEG;

FirstJump[0x55ED]=RETN;
FirstJump[0x5DED]=RETN;
FirstJump[0x65ED]=RETN;
FirstJump[0x6DED]=RETN;
FirstJump[0x75ED]=RETN;
FirstJump[0x7DED]=RETN;

FirstJump[0x4EED]=IM01;
FirstJump[0x6EED]=IM01;

FirstJump[0x66ED]=IM0;
FirstJump[0x76ED]=IM1;
FirstJump[0x7EED]=IM2;


//********** seconde table de saut, opcodes complexes **********

for (i=0;i<0xFFFF;i++)
   SecondJump[i]=UNKNOWN;

for (j=0;j<64;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x4000+j*256+i]=BITBI;

for (j=0;j<64;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x8000+j*256+i]=RESBI;

for (j=0;j<64;j++)
for (i=0;i<0x100;i++)
   SecondJump[0xC000+j*256+i]=SETBI;

for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x0000+j*256+i]=RLCBI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x0800+j*256+i]=RRCBI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x1000+j*256+i]=RLBI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x1800+j*256+i]=RRBI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x2000+j*256+i]=SLABI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x2800+j*256+i]=SRABI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x3000+j*256+i]=SLLBI;
for (j=0;j<8;j++)
for (i=0;i<0x100;i++)
   SecondJump[0x3800+j*256+i]=SRLBI;

printf("OK\n");

return ON;
}



int main(int argc, char **argv)
{
int i,size,ifin=OFF;
FILE *f;

printf("-------------------------------------------------\n");
printf("DIZASM v1.1                         Win32 edition\n");
printf("-------------------------------------------------\n");


for (i = 1;  i < argc;  i++)
   {


   if (argv[i][0] == '-' || argv[i][0] == '/')
      {
      if (toupper(argv[i][1]) == 'H' || argv[i][1]=='?')
         {
         printf("Options:\n");
         printf(" -h         display help\n");
         printf(" -o <nnnn>  org source at <nnnn> in HEXA\n");
         printf(" -s         generate source without map\n");
         exit(0);
         }
      else
      if (toupper(argv[i][1]) == 'O')
         {
         if (i+1<argc)
            {
            Org=strtol(argv[i+1],NULL,16);
            i++;
            }
         else
            {
            printf( "(3) Missing adresse after -o !\n");
            exit( 3 );
            }
         }
      else
      if (toupper(argv[i][1]) == 'S')
         {
         Display_Comment=OFF;
         }
      else
         {
         printf( "(3) Invalid option [%s]!\n", argv[i] );
         exit( 3 );
         }
      }
   else
      {
      if (ifin == OFF)
         {
         ifin = i;
         }
      else
         {
         printf("What do you want ? This is provocation !\n");
         exit(3);
         }
      }
   }

if (! ifin)
{
   printf( "(1) You must specify a input file name !\n" );
   exit( 1 );
}

f=fopen(argv[ifin],"rb");
if (!f)
	{
   printf( "(2) Please enter a VALID file name [%s] !\n", argv[ifin] );
   exit( 2 );
	}
   
fseek(f,0,SEEK_END);
size=ftell(f);
fseek(f,0,SEEK_SET);

if (Org<0)
   {
   Org=0;
   }

if (size+Org>65535)
   {
   printf("Warning - size limited to 64k\n");
   size=65536-Org;
   }

fread(z80+Org,size,1,f);
fclose(f);

InitTable();

DisAssemble(size+Org);
	return 0;
}







