/*
 * @(#)Arnoldj.java 1.1 26/Aug/2001 Kevin Thacker
 *
 *  ArnoldJ emulator (c) Copyright, Kevin Thacker
 *  
 *  This file is part of the ArnoldJ emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  The Z80 emulation is not covered by this license and is covered by the
 *  original license with the Jasper emulator. Z80 emulation has been
 *  distributed with this emulator with permission.
 */
import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;

/**
 * <p>The Arnoldj class wraps up the Amstrad class into an Applet which emulates 
 * a Amstrad CPC in a Web Page.</p>
 *
 * <p><center>
 *   <applet code=arnoldj.class>
 *   </applet>
 * </center></p>
 *
 * <p>This applet can be supplied the following parameters:
 * <ul>
 *	 <li><b>diskimage  </b> - name of CPCEMU style disk image (standard or extended)
 *   <li><b>snapshot   </b> - name of CPCEMU style snapshot
 *   <li><b>rom        </b> - filename of ROM (default=cpc6128.rom)
 * </ul>
 *
 * <p>The <b>rom</b> parameter can be used to specify a different ROM to load
 * other than the default CPC6128 ROM. This file must be 32,768 bytes in length.</p>
 *
 * <b>Version:</b> 1.1 26 August 2001<br>
 * <b>Authors:</b> <A HREF="http://arnold.emuunlim.com/">Arnold HomePage</A><br>
 *
 * @see amstrad
 * @see z80
 */

public class arnoldj extends Applet implements Runnable 
{
	amstrad     cpc = null;
	Thread      thread   = null;

	/** Version and author information. */
	public String getAppletInfo() 
	{
		return "Arnold Jnr by Kevin Thacker. Z80 code from Jasper by Adam Davidson and Andrew Pollard";
	}

	/** Applet parameters and their descriptions. */
	public String[][] getParameterInfo() 
	{
		String [][] info = 
		{
			{ "snapshot", "filename","name of CPCEMU snapshot"},
			{ "diskimage",    "filename", "name of CPCEMU Disk Image or Extended Disk Image" },
		};
		
		return info;
	}

	/** Initailize the applet. */
	public void init() 
	{
		setLayout( null );
	}

	/** Start the applet creating a new thread which invokes run(). */
	public void start() 
	{
		if ( thread == null ) 
		{
			thread = new Thread( this, "Amstrad CPC" );
			thread.start();
		}
	}

	/** Stop the applet. */
	public void stop() 
	{
		if ( thread != null ) 
		{
			thread.stop();
			thread = null;
		}
	}

	/** Parse available applet parameters. */
	public void readParameters() throws Exception 
	{
		resize( preferredSize() ); // once borderWidth is set up

		/* get base URL */
		URL baseURL = getCodeBase(); 

		/* get rom parameter */
		String rom = getParameter( "rom" );

		if ( rom == null ) 
		{
			/* not specified default to cpc6128 rom */
			rom = "cpc6128.rom";
		}

        /* load OS & BASIC rom */
		URL os_romURL = new URL( baseURL, rom );
		cpc.loadOSROM( os_romURL.toString(), os_romURL.openStream() );

        /* load AMSDOS DOS rom */
		String dos_rom = new String("amsdos.rom");
		URL dos_romURL = new URL( baseURL, dos_rom );
		cpc.loadAMSDOSROM( dos_romURL.toString(), dos_romURL.openStream() );

		/* reset CPC */
	    cpc.reset();
	    
	    
		String diskimage = getParameter( "diskimage" );
	
	    if ( diskimage != null ) 
	    {
			/* attempt to load disk image */

	        /* generate URL for snapshot  */
	  		URL	  url  = new URL( baseURL, diskimage );
	
	        /* open a connection */
			URLConnection diskimage_connection = url.openConnection();
            /* read the data in */
			InputStream input = diskimage_connection.getInputStream();
			cpc.loadDiskImage( url.toString(), input, diskimage_connection.getContentLength() );
			input.close();
		}
	    

		/* snapshot specified? */
		String snapshot = getParameter( "snapshot" );
	
	    if ( snapshot != null ) 
	    {
			/* attempt to load snapshot */

	        /* generate URL for snapshot  */
	  		URL	  url  = new URL( baseURL, snapshot );
	
	        /* open a connection */
			URLConnection snapshot_connection = url.openConnection();
            /* read the data in */
			InputStream input = snapshot_connection.getInputStream();
			cpc.loadSnapshot( url.toString(), input, snapshot_connection.getContentLength() );
			input.close();
		}
	    

	}

	/** Read applet parameters and start the Amstrad. */
	public void run() 
	{
		showStatus( getAppletInfo() );

		if ( cpc == null ) 
		{
			try 
			{
           		cpc = new amstrad( this );
				readParameters();
			}
			catch ( Exception e )
			{
				showStatus( "Caught IO Error: " + e.toString() );
			}
		}

		if ( cpc != null ) 
		{
			cpc.execute();
		}
	}


	/** Refresh handling. */
	public void update( Graphics g ) 
	{
		paint( g );
	}

	/** draw the cpc screen */
	public void paint( Graphics g ) 
	{
		if ( cpc != null ) 
		{
			cpc.repaint();
		}
	}

	/** Event handling. */
	public boolean handleEvent( Event e ) 
	{
		if ( cpc != null ) 
		{
			return cpc.handleEvent( e );
		}
		return super.handleEvent( e );
	}

	/** Applet size. */
	public Dimension minimumSize() 
	{
		return new Dimension( cpc.SCREEN_WIDTH+cpc.BORDER_WIDTH, cpc.SCREEN_HEIGHT+cpc.BORDER_HEIGHT);
	}

	public Dimension preferredSize() {
		return minimumSize();
	}
}
