;============
randomnumber:
;============
;
; produce a random number in the range 0 to 39
; formula:
;	  for i = 1 to 8 do
;		A = A .sl.1 + ((bit 5 XNOR bit 0) into bit 0)
;	  od
;
; entry: d = last random number
;  exit: d = new random number
;        flags b corrupt
;        all other regs preserved
;
rn10:	ld	b,8		;go round loop 8 times
;
rn20:	ld	a,d
	and	21h
	jp	po,rn30		;jump if not even parity
;
	scf			;must add a 1
;
rn30:	ld	a,d
	rla
	ld	d,a
;
	djnz	rn20
;
	and	3Fh		;mask out 64 & 128
	ld	d,a
	cp	trackcount
	jr	nc,rn10		;loop if number too big
;
	ret


