$PAGINATE
$title(Arnold 5 test)
$subtitle(Variables destined to be placed in RAM at about 8000h)
$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
$pagewidth=131


        DEFSEG  TestVariables, CLASS=DATA, START=8000h

        SEG     TestVariables

        PUBLIC  ?IntVectorTable         ;used in RASTER

        PUBLIC  ?RAMstack               ;used to init SP in TESTPACK
        PUBLIC  ?RAMTestStack

        PUBLIC  ?TempSPStore            ;used to move SP to IX in RAMTEST
                                        ;also used in SOUND for ESC exit

        PUBLIC  ?ArnoldType             ;in TESTPACK holds 4 or 5

        PUBLIC  ?NumberOfRAMBlocks      ;in RAMTEST

        PUBLIC  ?ErrorRegisters         ;a mini "stack" used in ERROR

        PUBLIC  ?PrintCharXORMask       ;in SUPPORT

        PUBLIC  ?KeyboardBuffer         ;used by KeyboardRead in SUPPORT
        PUBLIC  ?KeysHeldDownBuffer     ;used by KeyboardRead in SUPPORT

        PUBLIC  ?ScreenMode

        PUBLIC  ?MenuTopRow, ?MenuBottomRow, ?MenuHighlightedRow
        PUBLIC  ?MenuCursorPos, ?MenuAddrTable  ;all used in MENU
        PUBLIC  ?MenuTimeout
        PUBLIC  ?MenuLastKeyPress
        PUBLIC  ?MenuDebounceCount

        PUBLIC  ?TestLoopLimit          ;accessed by COUNTER
        PUBLIC  ?TestLoopCounter        ;accessed by COUNTER
        PUBLIC  ?TestLastHighlight      ;accessed by TESTPACK

        PUBLIC  ?IM1InterruptCounter    ;accessed by INTTEST

        PUBLIC  ?KeyboardTimeout        ;accessed by KEYBOARD
        PUBLIC  ?KeyLengthTimeout       ;accessed by KEYBOARD
        PUBLIC  ?KeyCTRLPressed         ;accessed by KEYBOARD
        PUBLIC  ?KeySHIFT1Printed       ;accessed by KEYBOARD

        PUBLIC  ?Palette27Background    ;accessed by PALET27
        PUBLIC  ?Pal27LastKeyPressed    ;accessed by PALET27
        PUBLIC  ?Pal27TimesKeyPressed   ;accessed by PALET27
        PUBLIC  ?Palette27Timeout       ;accessed by PALET27

        PUBLIC  ?Pal496Background       ;accessed by PALET496
        PUBLIC  ?PaletteLastKeyPressed  ;accessed by PALET496
        PUBLIC  ?PaletteKeyCount        ;accessed by PALET496

        PUBLIC  ?SpriteMag              ;accessed by SPRITES
        PUBLIC  ?SpriteBeingMoved       ;accessed by SPRITES
        PUBLIC  ?SpriteMoveControl      ;accessed by SPRITES
        PUBLIC  ?SpriteDelay            ;accessed by SPRITES

        PUBLIC  ?SplitScreenLine        ;accessed by SPLIT
        PUBLIC  ?SplitSecondAddr        ;accessed by SPLIT
        PUBLIC  ?SplitIncrement         ;accessed by SPLIT

        PUBLIC  ?RasterIntLine          ;accessed by RASTER
        PUBLIC  ?RasterIncrement        ;accessed by RASTER
        PUBLIC  ?RasterIntHappened      ;accessed by RASTER
        PUBLIC  ?RasterFaults0          ;accessed by RASTER
        PUBLIC  ?RasterFaults1          ;accessed by RASTER
        PUBLIC  ?RasterFaults2          ;accessed by RASTER

        PUBLIC  ?TapeBlobPosition       ;accessed by TAPE
        PUBLIC  ?TapeSamples            ;accessed by TAPE

        PUBLIC  ?sectorbuffer           ;accessed by FLOPPY
        PUBLIC  ?verifybuffer           ;accessed by FLOPPY

        PUBLIC  ?formatbuffer           ;accessed by FLOPPY

        PUBLIC  ?roflag                 ;accessed by FLOPPY
        PUBLIC  ?verifyflag             ;accessed by FLOPPY
        PUBLIC  ?driveflag              ;accessed by FLOPPY
        PUBLIC  ?quicksector            ;accessed by FLOPPY
        PUBLIC  ?paratable              ;accessed by FLOPPY
        PUBLIC  ?monto                  ;accessed by FLOPPY
        PUBLIC  ?moffto                 ;accessed by FLOPPY
        PUBLIC  ?wrtoff                 ;accessed by FLOPPY
        PUBLIC  ?hdsettle               ;accessed by FLOPPY
        PUBLIC  ?steprate               ;accessed by FLOPPY
        PUBLIC  ?headuld                ;accessed by FLOPPY
        PUBLIC  ?headld                 ;accessed by FLOPPY
        PUBLIC  .paralen                ;accessed by FLOPPY
        PUBLIC  ?rcount                 ;accessed by FLOPPY
        PUBLIC  ?motorrunning           ;accessed by FLOPPY
        PUBLIC  ?messdisable            ;accessed by FLOPPY
        PUBLIC  ?tickerrunning          ;accessed by FLOPPY
        PUBLIC  ?xpb                    ;accessed by FLOPPY
        PUBLIC  ?motortimeout           ;accessed by FLOPPY
        PUBLIC  ?intflag                ;accessed by FLOPPY
        PUBLIC  ?nmiflag                ;accessed by FLOPPY
        PUBLIC  ?statusbuffer           ;accessed by FLOPPY
        PUBLIC  ?bufferaddr             ;accessed by FLOPPY
        PUBLIC  ?savehl                 ;accessed by FLOPPY
        PUBLIC  ?savesp                 ;accessed by FLOPPY

        PUBLIC  ?messtab                ;accessed by FLOPPY
        PUBLIC  ?usertable              ;accessed by FLOPPY
        PUBLIC  ?savedbc                ;accessed by FLOPPY
        PUBLIC  ?savedde                ;accessed by FLOPPY

        PUBLIC  ?CurCmndChar            ;accessed by FLOPPY and FLOPCMND
        PUBLIC  ?LoopCount              ;accessed by FLOPPY and FLOPCMND
        PUBLIC  ?MaxLoop                ;accessed by FLOPPY and FLOPCMND
        PUBLIC  ?ErrorCount             ;accessed by FLOPPY and FLOPCMND
        PUBLIC  ?MaxError               ;accessed by FLOPPY and FLOPCMND

        PUBLIC  defbase                 ;accessed by FLOPCMND
        PUBLIC  cpstack                 ;accessed by FLOPCMND
        PUBLIC  ?cmndtable               ;accessed by FLOPCMND
        PUBLIC  autodefenable           ;accessed by FLOPCMND
        PUBLIC  cpbuffer                ;accessed by FLOPCMND
        PUBLIC  lencpbuffer             ;accessed by FLOPCMND

;
; These variables are not initialised (hence the use of DEFS). It is up to the
; test routines to initialise variables before they are used.
;
; 8000h is chosen as as good a place as any to stick these variables. Unless
; there is a screw up on the RAM switching front this area should always be
; fixed as block 2 and the screen should never be positioned there.
;
?IntVectorTable         defs    8
;
; The Interrup Vector Table has to be aligned on an 8 byte boundary so that
; the lower three bits of the value programmed into 6805 can be 0. The easy
; answer is to copy the table out of ROM to this area that I know is fixed
; at 8000h.
;

                        defs    256    ;stack grows back into this area
?RAMstack               defs    2

                        defs    256
?RAMTestStack           defs    2

?TempSPStore            defs    2

?NumberOfRAMBlocks      defs    1       ;either 3 or 7 (64K or 128K)

?ArnoldType             defs    1

?ErrorRegisters         defs    20       ;in ERROR all regs are PUSHed here

?KeyboardBuffer         defs    10      ;10 keyboard row bytes
?KeysHeldDownBuffer     defs    16      ;assume max of 16 held down

?ScreenMode             defs    1

?PrintCharXORMask       defs    1

?MenuCursorPos          defs    2       ;in MENU (holds top left pos)
?MenuTopRow             defs    1       ;in MENU top screen line of menu
?MenuBottomRow          defs    1       ;in MENU bottom screen line of menu
?MenuHighlightedRow     defs    1       ;in MENU Obvious (?)
?MenuAddrTable          defs    2       ;in MENU starting point of the routine addresses in table
?MenuTimeout            defs    2       ;in MENU
?MenuLastKeyPress       defs    1       ;in MENU
?MenuDebounceCount      defs    1       ;in MENU

?TestLoopLimit          defs    1       ;in COUNTER times to perform test
?TestLoopCounter        defs    1       ;in COUNTER actual variable counter

?TestLastHighlight      defs    1       ;in TESTPACK

?IM1InterruptCounter    defs    1       ;in INTTEST (counts IM1 interrupts)

?KeyboardTimeout        defs    2
?KeyLengthTimeout       defs    2
?KeyCTRLPressed         defs    1       ;in KEYBOARD flags possible end of test
?KeySHIFT1Printed       defs    1       ;in KEYBOARD make sure 2 SHIFTs print

?Palette27Background    defs    1       ;in PALET27 used to hold colour
?Pal27LastKeyPressed    defs    1       ;in PALET27 used to debounce keys
?Pal27TimesKeyPressed   defs    1       ;in PALET27 used to debounce keys
?Palette27Timeout       defs    2       ;in PALET27 used to count down time

?Pal496Background       defs    2       ;in PALET496
?PaletteLastKeyPressed  defs    1       ;in PALET496 to help de-bounce
?PaletteKeyCount        defs    1       ;in PALET496 to help de-bounce

?SpriteMag              defs    1       ;in SPRITES magnification=1 2 or 3
?SpriteBeingMoved       defs    1       ;in SPRITES identify one in motion 1..16
?SpriteMoveControl      defs    2       ;in SPRITES addres of its control reg
?SpriteDelay            defs    2

?SplitScreenLine        defs    1       ;in SPLIT (line where split currently is)
?SplitSecondAddr        defs    2       ;address of start of 2nd screen
?SplitIncrement         defs    1       ;in SPLIT going up (1) or down (-1)


?RasterIntLine          defs    1       ;in RASTER (where Int will happen)
?RasterIncrement        defs    1       ;in RASTER (1=down, -1=up)
?RasterIntHappened      defs    1       ;in RASTER flag says if its happened yet
?RasterFaults0          defs    1       ;in RASTER counts wrong vectors
?RasterFaults1          defs    1       ;in RASTER counts wrong vectors
?RasterFaults2          defs    1       ;in RASTER counts wrong vectors

?TapeBlobPosition       defs    2       ;in TAPE where cursor should posn. for blob
?TapeSamples            defs    2       ;in TAPE

?dskwrtbuffer           defs    514     ;in FLOPPY
?sectorbuffer           equ     ?dskwrtbuffer
?dskreadbuffer          defs    514     ;in FLOPPY
?verifybuffer           equ     ?dskreadbuffer

?formatbuffer           defs    9 * 4

?roflag                 defs    1       ;in FLOPPY
?verifyflag             defs    1       ;in FLOPPY
?driveflag              defs    1       ;in FLOPPY

?quicksector            defs    2       ;in FLOPPY

?paratable              equ     $
?monto                  defs    2       ;in FLOPPY motor on timeout (x 20mS)
?moffto                 defs    2       ;in FLOPPY motor on timeout (x 20mS)
?wrtoff                 defs    1       ;in FLOPPY write current off (x 10uS)
?hdsettle               defs    1       ;in FLOPPY head settle (mS)
?steprate               defs    1       ;in FLOPPY step rate (mS)
?headuld                defs    1       ;in FLOPPY head unload time
?headld                 defs    1       ;in FLOPPY head load time and non-DMA
.paralen                equ     $ - ?paratable
?rcount                 defs    1       ;in FLOPPY retry count
?motorrunning           defs    1       ;in FLOPPY obvious
?messdisable            defs    1       ;in FLOPPY messages disabled flag
?tickerrunning          defs    1       ;in FLOPPY obvious
?xpb                    defs    2 * 11  ;in FLOPPY 2 lots of XPB (A and B)
?motortimeout           defs    2       ;in FLOPPY (x 20mS)
?intflag                defs    1       ;in FLOPPY
?nmiflag                defs    1       ;in FLOPPY
?statusbuffer           defs    8       ;in FLOPPY
?bufferaddr             defs    2       ;in FLOPPY
?savehl                 defs    2       ;in FLOPPY
?savesp                 defs    2       ;in FLOPPY

?messtab                defs    2       ;in FLOPPY
?usertable              defs    2       ;in FLOPPY
?savedbc                defs    2       ;in FLOPPY
?savedde                defs    2       ;in FLOPPY

?CurCmndChar            defs    2       ;in FLOPPY
?LoopCount              defs    2       ;in FLOPPY
?MaxLoop                defs    2       ;in FLOPPY
?ErrorCount             defs    2       ;in FLOPPY
?MaxError               defs    2       ;in FLOPPY

cpstack                 defs    2       ;in FLOPCMND
defbase                 defs    2       ;in FLOPCMND
?cmndtable              defs    2       ;in FLOPCMND
autodefenable           defs    2       ;in FLOPCMND
cpbuffer                defs    255     ;in FLOPCMND
lencpbuffer             equ     255     ;in FLOPCMND

