;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Test of the analogue joystick ADCs)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  AnalogueJoystickTest    ;called indirectly from TESTPACK
;                                        ; out of MainMenuTable
;
;        EXTERN  SetCursorPos            ;in SUPPORT
;        EXTERN  PrintStringHL           ;in SUPPORT
;        EXTERN  UnlockArn5              ;in SUPPORT
;        EXTERN  RelockArn5              ;in SUPPORT
;        EXTERN  KeyboardRead            ;in SUPPORT
;        EXTERN  PrintAHex               ;in SUPPORT
;        EXTERN  .AnalogTestMess         ;in MESSAGES
;        EXTERN  .AnalogChannelMess      ;in MESSAGES
;        EXTERN  .AnalogColonMess        ;in MESSAGES
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;====================
AnalogueJoystickTest:
;====================
;
; Analog input channels are one of the Arnold 5 new features so I must
; enable the new bits (and make the I/O page appear at 04000h) before
; I start. That'll also do the standard check to make sure the new features
; are active.
;
; The test cartridge will have two pots. on it that are wired into pins
; 1 and 3 (horiz.) and 1 and 6 (vert) of the 15 pin analogue port.
;
; These are connected (I assume) to analog channels 0 and 1 whose I/O
; addresses are 6808h and 6809h. These registers are 6 bits wide so they
; will hopefully return values between 000h and 03Fh.
;
; This test just produces a display as follows:
;
;------------------------------------------------------------------------------
;                       Analogue Joystick Test
;                       ======================
;
; Connect the 15 pin Joystick lead from the test cartridge to the Analogue
; Joystick port and then move the pots. The following display shows the values
; read from the analogue channels. Only Channels 0..3 are active (4..7 are
; tied). The range of values you should see will be between 00 and 3F.
;
;                       Channel 00 : 17
;                       Channel 01 : 2C
;                           :       :
;                       Channel 07 : 00
;------------------------------------------------------------------------------
;
        call    UnlockArn5              ;rets C if switch failed (i.e. the
                                        ;new features don't appear to be there)
;
; The ULA register page is now switched in at 04000h.
;
        ld      hl,.AnalogTestMess
        ld      b,1
        call    PrintStringHL           ;tell the user to move the pots. As he
                                        ;does so he should see the channel
                                        ;values swing between 0 and 03Fh

        ld      b,8                     ;8 lines of "Channel n :"
        ld      de,00B0Bh               ;start row 11 colum 11
_AnalogPrintChanLoop:
        push    bc
        push    de
        call    SetCursorPos
        ld      hl,.AnalogChannelMess   ;"Channel "
        ld      b,1                     ;screen
        call    PrintStringHL

        pop     de                      ;get row counter
        push    de
        ld      a,d
        sub     11                      ;make it 0..7
        call    PrintAHex

        ld      hl,.AnalogColonMess     ;" = "
        ld      b,1
        call    PrintStringHL

        pop     de
        inc     d                       ;step down a row
        pop     bc
        djnz    _AnalogPrintChanLoop

_AnalogTestLoop:
        ld      hl,06808h               ;channel 0 address
        ld      b,8                     ;8 channels
_AnalogPortLoop:
        push    bc
        ld      a,(hl)                  ;get current A/D channel value
        inc     hl                      ;point at next channel

        push    hl                      ;save channel addr pointer
        push    af
        ld      a,l
        add     a,2
        ld      d,a                     ;row = A..11
        ld      e,24                    ;col = 24
        call    SetCursorPos
        pop     af

        call    PrintAHex               ;print current channel value
        pop     hl

        pop     bc
        djnz    _AnalogPortLoop

        call    KeyboardRead            ;give user a chance to get out
        cp      0FFh
        jr      nz,_AnalogFinishTest

        jp      _AnalogTestLoop

_AnalogFinishTest:
        call    RelockArn5              ;rets C if switch failed (i.e. the
                                        ;new features appear to be still active)
        ret

