;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Handles test software loop counter)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  IncrementLoopLimit      ;called indirectly from TESTPACK
;        PUBLIC  DecrementLoopLimit      ; out of MainMenuTable(MESSAGES)
;        PUBLIC  PrintLoopCount
;        PUBLIC  PrintLoopLimit
;
;        EXTERN  SetCursorPos            ;SUPPORT
;        EXTERN  PrintStringHL           ;SUPPORT
;        EXTERN  PrintAHex               ;SUPPORT
;
;        EXTERN  .LoopLimitMess
;        EXTERN  .LoopCountMess
;        EXTERN  ?TestLoopCounter        ;defined in TESTVARS
;        EXTERN  ?TestLoopLimit          ;defined in TESTVARS
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;
; These routines are used to maintain a loop counter so that when the user
; selects "Increment loop counter" from the main menu a RAM base variable is
; increemented. Similarly it may also be decremented.
;
; When tests are being run from the main menu loop, they are done as many
; times as the current setting of the loop counter. This includes the "All
; these tests" option. So, for example, if the user increments the counter
; twice and the selects the "All tests" option then the complete sequence
; will run through 3 times.
;
; The increment/decrement function changes the "Limit" value. When a test
; sequence is started, the "Limit" is placed in the "QUESTMARK_TestLoopCounter" and
; this is decremented at the end of each test.
;

IncrementLoopLimit:
        ld      hl,QUESTMARK_TestLoopLimit
        inc     (hl)
        call    PrintLoopLimit
        ret

DecrementLoopLimit:
        ld      hl,QUESTMARK_TestLoopLimit
        dec     (hl)
        call    PrintLoopLimit
        ret

PrintLoopLimit:
;
; This will print a "Loop Limit = xx" on the bottom line
;
        ld      de,1804h
        call    SetCursorPos

        ld      hl,.LoopLimitMess
        ld      b,1
        call    PrintStringHL

        ld      a,(QUESTMARK_TestLoopLimit)
        call    PrintAHex

        ret

PrintLoopCount:
;
; This will print a "Loop Count = xx" on the bottom line
;
        ld      de,1816h
        call    SetCursorPos

        ld      hl,.LoopCountMess
        ld      b,1
        call    PrintStringHL

        ld      a,(QUESTMARK_TestLoopCounter)
        call    PrintAHex

        ret
