;;$PAGINATE
;;$title(Arnold 5 test)
;;$subtitle(All the static messages and fixed value DBs for disk test)
;;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;;$pagewidth=131
;
;
;        DEFSEG  FloppyDiskTest, CLASS=CODE
;
;        SEG     FloppyDiskTest
;
;        PUBLIC  .Channel0DMAData        ;accessed from SOUNDDMA
;        PUBLIC  .Channel1DMAData        ;accessed from SOUNDDMA
;        PUBLIC  .Channel2DMAData        ;accessed from SOUNDDMA
;
;        PUBLIC  messtable               ;accessed from FLOPPY
;        PUBLIC  meshello                ;accessed from FLOPPY
;        PUBLIC  mesbyebye               ;accessed from FLOPPY
;        PUBLIC  mesremovediscs          ;accessed from FLOPPY
;        PUBLIC  mesAdisc                ;accessed from FLOPPY
;        PUBLIC  mesAandBdiscs           ;accessed from FLOPPY
;        PUBLIC  meshelp                 ;accessed from FLOPPY
;        PUBLIC  mesnormdata             ;accessed from FLOPPY
;        PUBLIC  mesinvdata              ;accessed from FLOPPY
;        PUBLIC  mesrdonly               ;accessed from FLOPPY
;        PUBLIC  mesrdwrite              ;accessed from FLOPPY
;        PUBLIC  mesenver                ;accessed from FLOPPY
;        PUBLIC  mesdisver               ;accessed from FLOPPY
;        PUBLIC  messeq                  ;accessed from FLOPPY
;        PUBLIC  mesrandom               ;accessed from FLOPPY
;        PUBLIC  mesquick                ;accessed from FLOPPY
;        PUBLIC  messpin                 ;accessed from FLOPPY
;        PUBLIC  mesformat               ;accessed from FLOPPY
;        PUBLIC  mestrack                ;accessed from FLOPPY
;        PUBLIC  mesformatreadonly       ;accessed from FLOPPY
;        PUBLIC  mesclrAdrive            ;accessed from FLOPPY
;        PUBLIC  mesclrBdrive            ;accessed from FLOPPY
;        PUBLIC  mesAdrive               ;accessed from FLOPPY
;        PUBLIC  mesBdrive               ;accessed from FLOPPY
;        PUBLIC  mes2sided               ;accessed from FLOPPY
;        PUBLIC  mes40tracks             ;accessed from FLOPPY
;        PUBLIC  mes80tracks             ;accessed from FLOPPY
;        PUBLIC  mes80tracks             ;accessed from FLOPPY
;        PUBLIC  messysformat            ;accessed from FLOPPY
;        PUBLIC  mesarnformat            ;accessed from FLOPPY
;        PUBLIC  mesbadformat            ;accessed from FLOPPY
;        PUBLIC  mesdataformat           ;accessed from FLOPPY
;        PUBLIC  errtrkcount             ;accessed from FLOPPY
;        PUBLIC  errbadformat            ;accessed from FLOPPY
;        PUBLIC  errverify               ;accessed from FLOPPY
;        PUBLIC  errreverify             ;accessed from FLOPPY
;        PUBLIC  errvok                  ;accessed from FLOPPY
;        PUBLIC  errvabandon             ;accessed from FLOPPY
;        PUBLIC  errread                 ;accessed from FLOPPY
;        PUBLIC  errreread               ;accessed from FLOPPY
;        PUBLIC  errrok                  ;accessed from FLOPPY
;        PUBLIC  errrabandon             ;accessed from FLOPPY
;        PUBLIC  errwrite                ;accessed from FLOPPY
;        PUBLIC  errrewrite              ;accessed from FLOPPY
;        PUBLIC  errwok                  ;accessed from FLOPPY
;        PUBLIC  errwabandon             ;accessed from FLOPPY
;        PUBLIC  errokspin               ;accessed from FLOPPY
;        PUBLIC  errslowspin             ;accessed from FLOPPY
;        PUBLIC  errfastspin             ;accessed from FLOPPY
;        PUBLIC  errspin                 ;accessed from FLOPPY
;        PUBLIC  errdrready              ;accessed from FLOPPY
;        PUBLIC  errformat               ;accessed from FLOPPY
;        PUBLIC  cmndtable               ;accessed from FLOPPY
;        PUBLIC  sectortable             ;accessed from FLOPPY
;        PUBLIC  fmattable               ;accessed from FLOPPY
;        PUBLIC  initdriveparas          ;accessed from FLOPPY
;        PUBLIC  leninitparas            ;accessed from FLOPPY
;
;        PUBLIC  sysmestable
;        PUBLIC  syscmndtab
;
;        EXTERN  setdrAonly              ;in FLOPPY
;        EXTERN  setdrBonly              ;in FLOPPY
;        EXTERN  setbothdrives           ;in FLOPPY
;        EXTERN  setnpattern             ;in FLOPPY
;        EXTERN  setipattern             ;in FLOPPY
;        EXTERN  setronly                ;in FLOPPY
;        EXTERN  setrafterw              ;in FLOPPY
;        EXTERN  setverdata              ;in FLOPPY
;        EXTERN  clearverdata            ;in FLOPPY
;        EXTERN  testsequential          ;in FLOPPY
;        EXTERN  testrandom              ;in FLOPPY
;        EXTERN  quicktest               ;in FLOPPY
;        EXTERN  spintest                ;in FLOPPY
;        EXTERN  format                  ;in FLOPPY
;
;        EXTERN  syshelpcmnd             ;in FLOPCMND
;        EXTERN  sysseterror             ;in FLOPCMND
;        EXTERN  syssetloop              ;in FLOPCMND
;        EXTERN  sysquit                 ;in FLOPCMND
;
;        EXTERN  ?CurCmndChar            ;in TESTVARS
;        EXTERN  ?LoopCount              ;in TESTVARS
;        EXTERN  ?MaxLoop                ;in TESTVARS
;        EXTERN  ?ErrorCount             ;in TESTVARS
;        EXTERN  ?MaxError               ;in TESTVARS
;
;        INCLUDE "Equates.inc"

LoadAY          %MACRO  reg, data
                defb    data
                defb    reg and 0Fh
                %ENDM

Pause           %MACRO  delay
                defb    low delay
                defb    10h + ((high delay) and 0Fh)
                %ENDM

Repeat          %MACRO  count
                defb    low count
                defb    20h + ((high count) and 0Fh)
                %ENDM

AYNop           %MACRO
                defw    4000h
                %ENDM

Loop            %MACRO
                defw    4001h
                %ENDM

AYInt           %MACRO
                defw    4010h
                %ENDM

AYStop          %MACRO
                defw    4020h
                %ENDM

AYPlayChanA     %MACRO  note,volume,delay,enables
                LoadAY  0,low(note)
                LoadAY  1,high(note)
                LoadAY  8,volume
                LoadAY  7,enables
                Pause   delay * 9 / 10
                LoadAY  7,3Fh
                Pause   delay / 10
                %ENDM

AYPlayChanB     %MACRO  note,volume,delay
                LoadAY  2,low(note)
                LoadAY  3,high(note)
                LoadAY  9,volume
                AYNop
                Pause   Delay * 9 / 10
                AYNop
                Pause   delay / 10
                %ENDM

AYPlayChanC     %MACRO  note,volume,delay
                LoadAY  4,low(note)
                LoadAY  5,high(note)
                LoadAY  10,volume
                AYNop
                Pause   Delay * 9 / 10
                AYNop
                Pause   delay / 10
                %ENDM

AYNoPlay        %MACRO  delay
                AYNop
                AYNop
                AYNop
                AYNop
                Pause   delay
                AYNop
                %ENDM



;===========================================================================

        defb    "The following is all the MEJ disk DBs=>"
; console 'messtab .asm:18 - 15 dec 86 - message table'
;
;=========
messtable:
;=========
;
; message table
;
	db	messagecount	;count of messages in table
;
; sub messages
; ************
;
sm4spaces	equ	printsubmessage + 1
	db	'    $'
;
sm12spaces	equ	sm4spaces + 1
	db	sm4spaces,sm4spaces,sm4spaces,'$'
;
smname	equ	sm12spaces + 1
;CJL mn05:   db      bs,bs,bs,bs,bs
;CJL         db      bs,bs,bs,bs,bs  ;back space 10 chars to start of name
				;assumes cursor is at right edge of screen
mn10:   db      '    DTEST V3.7$'
;
namelen	equ	$ - mn10 - 1	;lengthof  name string
; confirm (mn10-mn05).eq.namelen
;
smerrdetails	equ	smname + 1
	db	': ',smdrive,ptdrnum,ptsidenum,' track',ptD,' ',smsector,ptC,'$'
;
smselwindow	equ	smerrdetails + 1
;CJL        dw      escsavewindow   ;save current window number
;CJL        dw      escselwindow    ;& select heading window
;CJL        db      windheading
	db	'$'
;
smheadwindow	equ	smselwindow + 1 ;select heading window
;CJL        db      smselwindow
;CJL        dw      esccuraddr      ;next 2 bytes will set cursor addr
	db	'$'
;
smendwindow	equ	smheadwindow + 1	;return to previous window
;CJL        dw      escrestwindow   ;restore previous window
	db	'$'
;
sm0trks		equ	smendwindow + 1
	db	'0 trks$'
;
smdrive		equ	sm0trks + 1
	db	'drive $'
;
smdashtest	equ	smdrive + 1
	db	' - Test $'
;
smtestdr	equ	smdashtest  + 1
	db	smdashtest,smdrive,'$'
;
smdata		equ	smtestdr + 1
	db	'data $'
;
smdatapattern	equ	smdata + 1
	db	' worst case ',smdata,'pattern $';must have space at end of message
;
smdataver	equ	smdatapattern + 1
        db      smdata,'verification $'
;
smtesttracks	equ	smdataver + 1
	db	smdashtest,'all ',smtrack,bs,'s $'
;
smpseudo	equ	smtesttracks + 1
	db	'pseudo random $'
;
smtracktest	equ	smpseudo + 1
	db	smtrack,smtest
	db	'$'
;
smtrack		equ	smtracktest + 1
	db	'track $'
;
smtest		equ	smtrack + 1
	db	'test $'
;
smcorrectly	equ	smtest + 1
	db	'correctly$'
;
smsector	equ	smcorrectly + 1
	db	'sector $'
;
smseccorrect	equ	smsector + 1
	db	smsector,smcorrectly,'$'
;
smfailedto	equ	smseccorrect + 1
        db      '^Failed to $'
;
smabandoned	equ	smfailedto + 1
	db	'abandoned$'
;
smverify	equ	smabandoned + 1
	db	'Verify $'
;
smread		equ	smverify + 1
	db	'read $'
;
smwrite		equ	smread + 1
	db	'write $'
;
smre		equ	smwrite + 1
	db	're-$'
;
smnlsector	equ	smre + 1
        db      '^Sector $'
;
smnormdata	equ	smnlsector + 1
        db      'normal',smdatapattern,'$'
;
sminvdata	equ	smnormdata + 1
        db      'inverse',smdatapattern,'$'
;
smtesting	equ	sminvdata + 1
	db	smtest,bs,'ing $'
smrdonly	equ	smtesting + 1
        db      smread,'only ',smtesting,'$'
;
smrdwrite	equ	smrdonly + 1
        db      smread,'after ',smwrite,smtesting,'$'
;
smset		equ	smrdwrite + 1
	db	' - Set $'
;
smbadformat	equ	smset + 1
	db	'has an unknown',smformat,bs,'$'
;
sm10ulines	equ	smbadformat + 1
	db	'__________$'
;
smformat	equ	sm10ulines + 1
	db	' format $'
;
smsystem	equ	smformat + 1
	db	' SYSTEM',smformat,'$'
;
smdisc		equ	smsystem + 1
	db	' disc$'
;
smdrvs		equ	smdisc + 1
	db	' drives$'
;
smboth	equ	smdrvs + 1
	db	'both$'
;
sminsertdisc	equ	smboth + 1
        db      '^Insert ',smtest,bs,smdisc,'$'
;
smspinning	equ	sminsertdisc + 1
	db	smdrive,ptdrnum,' spinning $'
;
smerrspin	equ	smspinning + 1
        db      '^Error:',smspinning,'too $'
;
smtestaddr	equ	smerrspin + 1	;set cursor addr for test name
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,40 + 20h ;will be row 3,col 40
;CJL        dw      esccurdown      ;line 4 (4 + 20h = '$' !!)
	db	'$'
;
smsequential	equ	smtestaddr + 1
	db	'sequential$'
;
smpinspeed	equ	smsequential + 1
	db	'pin speed $'
;
smready		equ	smpinspeed + 1
	db	'ready $'
;
smpin	equ	smready + 1
	db	smpinspeed,'and '
	db	smdrive
	db	smready
	db	smtest
	db	'$'
;
smspinerror	equ	smpin + 1
	db	':speed = ',ptbc,'0 micro seconds$'
;
smfast	equ	smspinerror + 1
	db	'fast$'
;
sminto	equ	smfast + 1
	db	' into $'
;
smable	equ	sminto + 1
	db	'able$'
;
smdroption	equ	smable + 1
        db      ' only (give optional ',smtrack,'count of 40 or 80)^$'

; messages
; ********
;
meshello	equ	smdroption + 1 - printsubmessage
;CJL        db      smheadwindow    ;select heading window
;CJL        db      0 + 20h,89  + 20h ;right edge of window
;CJL        dw      escwrapdisable  ;dont roll window when we write last column
        db      sm12spaces,sm12spaces
        db      smname          ;print program name
;CJL        dw      esccuraddr
;CJL        db      winbotheading + 20h,0 + 20h ;last line of window
;CJL        db      sm10ulines,sm10ulines,sm10ulines,sm10ulines
;CJL        db      sm10ulines,sm10ulines,sm10ulines,sm10ulines,sm10ulines
;CJL        dw      escwrapenable   ;allowline wrap again
;CJL        db      smendwindow     ;restore previous window
;CJL        dw      escclear        ;clear main window
;CJL        dw      eschome         ;& home the cursor
        db      cr,lf,lf
        db      '$'
;
mesbyebye	equ	meshello + 1
;CJL        db      smheadwindow    ;select heading window
;CJL        db      0 + 20h,79 - namelen + 20h ;right justified
;CJL        dw      escerapend      ;erase program name & rest of window
;CJL        db      smendwindow     ;restore previous window
;CJL        dw      escclear        ;clear main window as well
;CJL        dw      eschome         ;& home the cursor
	db	'$'
;
mesremovediscs	equ	mesbyebye + 1
        db      '^Remove all',smdisc,'s from the',smdrvs,'$'
;
mesAdisc	equ	mesremovediscs + 1
        db      sminsertdisc,sminto,smdrive,'A or press any key to abandon test^$' ;'insert test disc into drive A'
;
mesAandBdiscs	equ	mesAdisc + 1
        db      sminsertdisc,'s',sminto,smboth,smdrvs,'^$' ;'insert test discs into both drives'
;
meshelp		equ	mesAandBdiscs + 1
;CJL        dw      escclear                ;clear the screen
;CJL        dw      eschome                 ;& home the cursor
;
        db      '^Commands available are:^'
        db      'A - Log in disk in drive A (if changed)^'
;        db      'B',smtestdr,'B',smdroption
;        db      'T',smdashtest,smboth,smdrvs,'^'
        db      'N',smset,smnormdata,'^'
        db      'I',smset,sminvdata,'^'
        db      'R',smset,smrdonly,'^'
        db      'W',smset,smrdwrite,'^'
;        db      'V - En',smable,' ',smdataver,'^'
;        db      'D - Dis',smable,' ',smdataver,'^'
        db      'S',smtesttracks,smsequential,'ly^'
        db      'P',smtesttracks,'in ',smpseudo,smtrack,'order^'
        db      'F - Fast ',smtrack,smtest,'^'
        db      'X - S',smpin,'^'       ;'pin speed & drive ready test'
;        %if      testformat
        db      'O -',smformat,'^'
;        %endif
	db	'$'
;
mesnormdata	equ	meshelp + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,0 + 20h ;row 3,col 0
        db      smnormdata      ;'normal worst case data pattern'
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesinvdata	equ	mesnormdata + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,0 + 20h ;row 3,col 0
        db      sminvdata       ;'inverse worst case data pattern
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesrdonly	equ	mesinvdata + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,40 + 20h;row 3,col 40
        db      smrdonly        ;'read only testing'
;CJL        dw      esceralend      ;clear remainder of r after w message
        db      sm12spaces
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesrdwrite	equ	mesrdonly + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,40 + 20h;row 3,col 40
        db      smrdwrite       ;'read after write testing'
        db      sm12spaces
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesenver	equ	mesrdwrite + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,0 + 20h ;will be row 4,col 0
;CJL        dw      esccurdown      ;line 4 (4 + 20h = '$' !!)
        db      smdataver       ;'data verification '
        db      'en',smable,'d '
;        db      sm12spaces
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesdisver	equ	mesenver + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      3 + 20h,0 + 20h ;will be row 4,col 0
;CJL        dw      esccurdown      ;line 4 (4 + 20h = '$' !!)
        db      smdataver       ;'data verification '
	db	'dis',smable,'d'
;        db      sm12spaces
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
messeq		equ	mesdisver + 1
        db      '^'
        db      smtestaddr      ;set cursor addr
	db	smsequential,' '
	db	smtracktest	;'track test'
;CJL        dw      esceralend      ;erase remainder of line
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesrandom	equ	messeq + 1
        db      '^'
        db      smtestaddr      ;set cursor addr
	db	smpseudo	;'psuedo random'
	db	smtracktest	;'track test'
;CJL        dw      esceralend      ;erase remainder of line
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesquick	equ	mesrandom + 1
        db      '^'
        db      smtestaddr      ;set cursor addr
	db	smfast,' ',smtracktest
;CJL        dw      esceralend      ;erase remainder of line
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
messpin	equ	mesquick + 1
        db      '^'
        db      smtestaddr      ;set cursor addr
	db	's',smpin	;'spin speed & drive ready test'
;CJL        dw      esceralend      ;erase remainder of line
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesformat	equ	messpin + 1
        db      '^'
;CJL        db      smtestaddr      ;set cursor addr
;CJL        db      bs
        db      smformat,bs,'ting disc'
;CJL        dw      esceralend      ;erase remainder of line
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mestrack  equ     mesformat + 1
        db      'Track ='
        db      ptD
        db      '$'

mesformatreadonly equ   mestrack + 1
        db      '^Format abandoned - ',smrdonly,'is set. Use W before O to continue.'
        db      '$'

mesclrAdrive    equ     mesformatreadonly + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      2 + 20h,39 + 20h ;row 2,col 39
;CJL        dw      esceralstart    ;erase dr a message
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesclrBdrive	equ	mesclrAdrive + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      2 + 20h,40 + 20h ;row 2,col 40
;CJL        dw      esceralend      ;erase dr b message
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesAdrive	equ	mesclrBdrive + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      2 + 20h,39 + 20h ;row 2,col 39
;CJL        dw      esceralstart    ;clear down old message
	db	cr,smdrive,'A'	;'drive A '
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesBdrive	equ	mesAdrive + 1
;CJL        db      smheadwindow    ;select window
;CJL        db      2 + 20h,40 + 20h ;row 2,col 40
;CJL        dw      esceralend      ;clear down old message
	db	smdrive,'B'	;'drive B '
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mes2sided	equ	mesBdrive + 1
;CJL        db      smselwindow     ;select window
;CJL        dw      esconinverse    ;display 2 sided message in inverse
	db	'(2 sides)'
;CJL        dw      escoffinverse   ;back to normal video
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mes40tracks	equ	mes2sided + 1
;CJL        db      smselwindow     ;select window
	db	' 4',sm0trks
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mes80tracks	equ	mes40tracks + 1
;CJL        db      smselwindow     ;select window
;CJL        dw      esconinverse    ;display 2 sided message in inverse
	db	' 8',sm0trks
;CJL        dw      escoffinverse   ;back to normal video
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
messysformat	equ	mes80tracks + 1
;CJL        db      smselwindow     ;select window
	db	' JOYCE',smformat
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesarnformat	equ	messysformat  + 1
;CJL        db      smselwindow     ;select window
	db	' ARNOLD',smformat
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesbadformat	equ	mesarnformat  + 1
;CJL        db      smselwindow     ;select window
	db	smbadformat	;'drive n has an unknown format'
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
mesdataformat	equ	mesbadformat  + 1
;CJL        db      smselwindow     ;select window
	db	' DATA',smformat
;CJL        db      smendwindow     ;restore previous window
	db	'$'
;
; error messages
; **************
;
errtrkcount	equ	mesdataformat + 1
        db      '^You may only specify 40 or 80 tracks per ',smdrive,'$'
;
errbadformat	equ	errtrkcount + 1
        db      '^The',smdisc,' in '
	db	smdrive,ptdrnum,' ',smbadformat
	db	', using previous ',smformat,'$'
;
errverify	equ	errbadformat + 1
	db	smfailedto,smverify
	db	smseccorrect		;'sector correctly'
	db	'   '
	db	smerrdetails
	db	'$'
;
errreverify	equ	errverify + 1
	db	smfailedto,smre,smverify
	db	smseccorrect		;'sector correctly'
	db	smerrdetails
	db	'$'
;
errvok	equ	errreverify + 1
	db	smnlsector,smre,'verified ',smcorrectly
	db	sm4spaces,sm4spaces,smerrdetails
	db	'$'
;
errvabandon	equ	errvok + 1
	db	smnlsector,smverify,smabandoned
	db	sm12spaces,' ',smerrdetails
	db	'$'
;
errread	equ	errvabandon + 1
	db	smfailedto,smread
	db	smseccorrect		;'sector correctly'
	db	sm4spaces,' ',smerrdetails
	db	'$'
;
errreread	equ	errread + 1
	db	smfailedto,smre,smread	;'Failed to re-read '
	db	smseccorrect		;'sector correctly'
	db	'  '
	db	smerrdetails
	db	'$'
;
errrok	equ	errreread + 1
	db	smnlsector,smre,smread,smcorrectly
	db	sm12spaces,smerrdetails
	db	'$'
;
errrabandon	equ	errrok + 1
	db	smnlsector,smread,smabandoned
	db	sm12spaces,'   '
	db	smerrdetails
	db	'$'
;
errwrite	equ	errrabandon + 1
	db	smfailedto,smwrite
	db	smseccorrect		;' sector correctly'
	db	sm4spaces,smerrdetails
	db	'$'
;
errrewrite	equ	errwrite + 1
	db	smfailedto,smre,smwrite
	db	smseccorrect		;'sector correctly'
	db	' '
	db	smerrdetails
	db	'$'
;
errwok	equ	errrewrite + 1
	db	smnlsector,smre,'written ',smcorrectly
	db	sm4spaces,sm4spaces,' '
	db	smerrdetails
	db	'$'
;
errwabandon	equ	errwok + 1
	db	smnlsector,smwrite,smabandoned
	db	sm12spaces,'  '
	db	smerrdetails
	db	'$'
;
errokspin	equ	errwabandon + 1
        db      '^',smspinning
	db	'correctly     '
	db	smspinerror
	db	'$'
;
errslowspin	equ	errokspin + 1
	db	smerrspin	;'Error drive n spinning too '
	db	'slow'
	db	smspinerror	;'error = nn (in 25us units)'
	db	'$'
;
errfastspin	equ	errslowspin + 1
	db	smerrspin	;'Error drive n spinning too '
	db	smfast
	db	smspinerror	;'error = nn (in 25us units)'
	db	'$'
;
errspin		equ	errfastspin + 1
        db      '^Disc timeout in s',smpinspeed,smtest,'$'
;
errdrready	equ	errspin + 1
	db	smfailedto
	db	'clear ',smdrive,smready,'status$'
;
errformat	equ	errdrready + 1
	db	smfailedto,bs,smformat,'disc ',smcorrectly
	db	smerrdetails
	db	'$'
messagecount	equ	errformat + 1

; console 'cmndtab .asm:22 - 16 dec 86 - DTEST command table'
;
;==========
cmndtable:
;==========
;
; table of supported DTEST cmnd parameters
;
	db	meshelp		;help message
	dw	defaults	;default tests
;
	db	cmndcount + 1	;max number of cmnds
;
        db      'A' + bit7
        dw      setdrAonly      ;test drive A only (& set tracks per drive)
;
;        db      'B' + bit7
;        dw      setdrBonly      ;test drive B only (& set tracks per drive)
;
;        db      'T'
;        dw      setbothdrives   ;test both drives
;
	db	'N'
	dw	setnpattern	;set normal worst case data pattern
;
	db	'I'
	dw	setipattern	;set inverse worst case data pattern
;
	db	'R'
	dw	setronly	;set read only testing
;
	db	'W'
	dw	setrafterw	;set read after write testing
;
;        db      'V'
;        dw      setverdata      ;enable data verification
;
;        db      'D'
;        dw      clearverdata    ;disable data verification
;
	db	'S'
	dw	testsequential	;test all tracks sequentially
;
	db	'P'
	dw	testrandom	;test all tracks in pseudo random track order
;
	db	'F'
	dw	quicktest	;quick disc test
;
	db	'X'
	dw	spintest	;spin speed & drive ready test
;
;        %if      testformat
	db	'O'+bit7
	dw	format		;format disc
;        %endif
;
cmndcount equ ($ - cmndtable - 1 - 2 - 1) / 3 ;number of cmnds
;
defaults:
	db	2,'FX'

;===========
sectortable:
;===========
;
; table of track numbers & associated strings of sector numbers
;
	db	sectabcount + 1
	dw	0		;default
;
	db	0		;track 0
	dw	tk0sectors	;string of sectors to read & write
;
	db	1		;track 1
	dw	tk1sectors	;string of sectors to read & write
;
	db	38		;track 38
	dw	tk38sectors	;string of sectors to read & write
;
	db	39		;track 39
	dw	tk39sectors	;string of sectors to read & write
;
	db	78		;track 78
	dw	tk79sectors	;string of sectors to read & write
;
	db	79		;track 79
	dw	tk79sectors	;string of sectors to read & write
;
sectabcount equ (($ - sectortable) / 3 - 1)

tk0sectors:
	db	4,0,5		;last, first & second sectors on track 0
;
tk1sectors:
	db	3,8,4		;last, first & second sectors on track 1
;
tk38sectors:
	db	2,7,3		;last, first & second sectors on track 38
;
tk39sectors:
	db	1,6,2		;last, first & second sectors on track 39
;
tk78sectors:
	db	7,3,8		;last, first & second sectors on track 78
;
tk79sectors:
	db	6,2,7		;last, first & second sectors on track 79

;=========
fmattable:
;=========
;
; sector interleave 2:1
; table produced twice to make wrapping of table pointer easy
;
	db	0,5,1,6,2,7,3,8,4
	db	0,5,1,6,2,7,3,8,4
;
; confirm (($-fmattable)/2).eq.jfsecpertrack


; initial drive parameters
;
initdriveparas:
	dw	1000/20		;default motor in timeout (in 20 ms units)
	dw	5000/20		;default motor off timeout (in 20 ms units)
	db	1750/10		;default write current of time (in 10 us units)
	db	defheadsettle	;default head settle time (ms)
	db	defsrt		;default step rate (ms)
	db	defhut		;default head unload time
	db	defhlt+defnd	;default head load time and non-dma mode
;
; confirm $-initdriveparas.eq.paralen
;
; confirm rcount.eq.paratable+paralen
	db	retrycount	;initial retry count
; confirm motorrunning.eq.rcount+1
	db	false		;motor not running
; confirm messdisable.eq.motorrunning+1
	db	false		;messages enabled
; confirm tickerrunning.eq.messdisable+1
	db	false
;
; default xpb parameters for drive 0
;
; confirm xpb.eq.tickerrunning+1
dfaxpb:
;        %if     not (ant or joyce)
	db	sffirstsector	;first sector
	db	sfsecpertrack	;sectors per track
;        %endif
;
;
	db	sfgplrw		;gap length, read/write
; confirm jfgplrw.eq.sfgplrw
	db	sfgplformat	;gap length, format
; confirm jfgplformat.eq.sfgplformat
	db	filler		;format filler
	db	encsecsize	;encoded sector size
	db	0		;2 sided flag
	db	false		;default drive A to a 40 track drive
	db	0		;current track
	db	false		;not aligned
	db	false		;auto select
; confirm $-dfaxpb.eq.xpbsize
;
; default xpb parameters for drive 1
;
dfbxpb:
;        %if     not (ant or joyce)
	db	sffirstsector	;first sector
	db	sfsecpertrack	;sectors per track
;        %endif
;
;
	db	sfgplrw		;gap length, read/write
; confirm jfgplrw.eq.sfgplrw
	db	sfgplformat	;gap length, format
; confirm jfgplformat.eq.sfgplformat
	db	filler		;format filler
	db	encsecsize	;encoded sector size
	db	0		;2 sided flag
        db      true            ;default drive B to an 80 track drive
	db	0		;current track
	db	false		;not aligned
	db	false		;auto select
; confirm $-dfbxpb.eq.xpbsize
;
leninitparas	equ	$-initdriveparas


;==========
sysmestable
;==========
;
; system message table
;
        db      smmessagecount    ;count of messages in table
;
; submessages
; -----------
;
ms      teq     printsubmessage + 1
;
smefaults	equ	ms
ms      teq     ms + 1
	db	'efaults$'
;
smommand	equ	ms
ms      teq     ms + 1
	db	'ommand$'
;
smrror		equ	ms
ms      teq     ms + 1
	db	'rror$'
;
smloop	equ	ms
ms      teq     ms + 1
	db	'Loop$'
;
smbandon	equ	ms
ms      teq     ms + 1
	db	'bandon$'
;
smabandon	equ	ms
ms      teq     ms + 1
	db	' a',smbandon,'$'
;
smcount		equ	ms
ms      teq     ms + 1
	db	' count$'
;
smdranykey	equ	ms
ms      teq     ms + 1
	db	' drive ',ptdrnum,' then press any key$'
;
smdiscin	equ	ms
ms      teq     ms + 1
	db	' disc in$'
;
ms      teq     ms + 1
	db	' $'	;spare sub message
;
; messages
; --------
;
ms      teq     ms - printsubmessage
;
; confirm sysbadmessage.eq.ms
ms      teq     ms + 1
        db      '^^Bad message: Program',smabandon,'ed^^$'
;
; confirm syshelp.eq.ms
ms      teq     ms + 1
	db	'E - Set e'
	db	smrror,smcount
        db      '^'
        db      '? - List c',smommand,'s^'
	db	'L - '
	db	smloop
        db      '^'
        db      'Q - Quit^$'
;
; confirm sysdefaults.eq.ms
ms      teq     ms + 1
        db      'D'
	db	smefaults
	db	' are: $'
;
; confirm sysnodefaults.eq.ms
ms      teq     ms + 1
        db      '^No d'
	db	smefaults
	db	'$'
;
; confirm syscurcmnd.eq.ms
ms      teq     ms + 1
        db      '^: C',smommand,' ',ptvarchar
        dw      QUESTMARK_curcmndchar     ;print current cmnd letter
	db	': ',smloop,ptv16
        dw      QUESTMARK_loopcount       ;& current loop count
	db	'$'
;
; confirm systestabandon.eq.ms
ms      teq     ms + 1
        db      '^E',smrror,' limit reached: All tests'
	db	smabandon
	db	'ed$'
;
; confirm sysaskabandon.eq.ms
ms      teq     ms + 1
;CJL        dw      escsavewindow   ;save current window number
;CJL        dw      escselwindow
;CJL        db      windstatus      ;select status line window
        db      '^A'
	db	smbandon
	db	' (Y/N):_$'
;
; confirm sysclrstatus.eq.ms
ms      teq     ms + 1
;CJL        dw      esclclear
;CJL        dw      escrestwindow   ;restore previous window
	db	'$'
;
; print loop & error counts
;
; confirm syscounts.eq.ms
ms      teq     ms + 1
;CJL        dw      escsavewindow   ;save current window number
;CJL        dw      escselwindow
;CJL        db      windheading     ;select heading line window
;CJL        dw      escsavecursor   ;save current cursor addr
;CJL        dw      esccuraddr      ;set cursor addr to line 1
;CJL        db      1 + 20h,0 + 20h
;
        db      smloop,smcount
	db	' =',ptv16
        dw      QUESTMARK_loopcount
	db	'(',ptv16
        dw      QUESTMARK_maxloop
	db	'), e'
	db	smrror,smcount
	db	' =',ptv16
        dw      QUESTMARK_errorcount
	db	'(',ptv16
        dw      QUESTMARK_maxerror
	db	')'
;CJL        dw      escrestcursor
;CJL        dw      escrestwindow
	db	'$'
;
; confirm syscommand.eq.ms
ms      teq     ms + 1
        db      '^C'
	db	smommand
	db	' ($'
;
; confirm syselq.eq.ms
ms      teq     ms + 1
	db	'?ELQ):_$'
;
; confirm sysnopara.eq.ms
ms      teq     ms + 1
        db      '^^Para e'
	db	smrror
        db      '^$'
;
; confirm sysrundefaults.eq.ms
ms      teq     ms + 1
	db	'Running d'
	db	smefaults
	db	': $'
;
; confirm sysbadcpcmnd.eq.ms
ms      teq     ms + 1
	db	' is not a valid c'
	db	smommand
	db	'$'
;
; confirm syscontc.eq.ms
ms      teq     ms + 1
        db      ' !C...aborted$'
;
; disc messages
; *************
;
; confirm sysnodisc.eq.ms
ms      teq     ms + 1
;CJL        dw      escsavewindow   ;save current window number
;CJL        dw      escselwindow
;CJL        db      windstatus      ;select status line window
        db      '^Insert',smdiscin,'to'
	db	smdranykey
	db	'$'
;
; confirm syswprot.eq.ms
ms      teq     ms + 1
;CJL        dw      escsavewindow   ;save current window number
;CJL        dw      escselwindow
;CJL        db      windstatus      ;select status line window
        db      '^Write-enable',smdiscin
	db	smdranykey
	db	'$'
;
smmessagecount    equ     ms

;=========
syscmndtab
;=========
;
; system cmnd table
;
	db	4+1		;nuber of entries in table
;
	db	'?'
	dw	syshelpcmnd	;help cmnd
;
	db	'E'+bit7
	dw	sysseterror	;set error count
;
	db	'L'+bit7
	dw	syssetloop	;set loop count
;
	db	'Q'
	dw	sysquit		;quit cmnd


;
; The following 3 blocks are the date for playing on each of the 3 DMA sound
; channels. A always "plays" because it is used to set the AY enables
; register (7) as the 4th parameter. However, when only B and/or C are to be
; heards its period and volume are programmed with 0.
;
.Channel0DMAData
;        AYPlayChanA  GO1, 0Fh, 100, 3Eh         ;Channel A only
;        AYPlayChanA    0,   0, 100, 3Dh         ;dummy to enable just B
;        AYPlayChanA    0,   0, 100, 3Bh         ;dummy to enable just C
;        AYPlayChanA  GO0, 0Fh, 100, 3Ch         ;Channels A and B
;        AYPlayChanA  CO1, 0Fh, 100, 3Ah         ;Channels A and C
;        AYPlayChanA    0,   0, 100, 39h         ;dummy to enable B and C
;        AYPlayChanA  CO0, 0Fh, 100, 38h         ;Channels A, B and C
;        AYPlayChanA  CO0, 0Fh, 100, 38h         ;Channels A, B and C
;        AYPlayChanA  DO0, 0Fh, 100, 38h         ;Channels A, B and C
;        AYPlayChanA  EO0, 0Fh, 100, 38h         ;Channels A, B and C
;
;        AYNoPlay     200
;
; The following is Eine Kleine Nacht Musik
;
        Repeat        10

        AYPlayChanA  FO1, 0Fh, 120, 38h
        AYPlayChanA  CO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh, 120, 38h
        AYPlayChanA  CO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  CO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  CO2, 0Fh, 160, 38h

        AYPlayChanA ASO1, 0Fh, 120, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh, 120, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h

        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  CO1, 0Fh, 160, 38h

        AYPlayChanA  FO1, 0Fh,  80, 38h
        AYPlayChanA  FO1, 0Fh, 120, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh, 120, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h

        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh, 120, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh, 120, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh, 120, 38h
        AYPlayChanA  CO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh, 120, 38h
        AYPlayChanA  CO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  CO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  CO2, 0Fh, 160, 38h

        AYPlayChanA  CO2, 0Fh, 160, 38h
        AYPlayChanA  DO2, 0Fh, 160, 38h

        AYPlayChanA  CO2, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  80, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  80, 38h

        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  80, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h
        AYPlayChanA  DO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh,  80, 38h
        AYPlayChanA  GO1, 0Fh,  80, 38h
        AYPlayChanA  AO1, 0Fh, 160, 38h

        AYPlayChanA  CO2, 0Fh, 160, 38h
        AYPlayChanA  DO2, 0Fh, 160, 38h

        AYPlayChanA  CO2, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h

        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h
        AYPlayChanA  DO1, 0Fh,  40, 38h
        AYPlayChanA  EO1, 0Fh,  40, 38h

        AYPlayChanA  FO1, 0Fh,  80, 38h
        AYPlayChanA  FO1, 0Fh,  80, 38h
        AYPlayChanA  FO1, 0Fh, 160, 38h

        AYNoPlay     200
;
; A bit of EastEnders...
;
        AYPlayChanA  FO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  CO2, 0Fh,  80, 38h
        AYPlayChanA  DO2, 0Fh,  80, 38h

        AYPlayChanA ASO1, 0Fh, 240, 38h
        AYNoPlay      80

        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh, 160, 38h
        AYPlayChanA  CO1, 0FH,  40, 38h

        AYPlayChanA  CO1, 0FH,  40, 38h
        AYPlayChanA  FO1, 0FH,  80, 38h
        AYPlayChanA  CO2, 0FH,  40, 38h
        AYPlayChanA  FO1, 0FH,  80, 38h
        AYPlayChanA  GO1, 0FH,  80, 38h

        AYPlayChanA  FO1, 0FH,  40, 38h
        AYPlayChanA  GO1, 0FH,  40, 38h
        AYPlayChanA  AO1, 0FH,  40, 38h
        AYPlayChanA ASO1, 0FH,  40, 38h
        AYPlayChanA  CO2, 0FH,  80, 38h
        AYPlayChanA  DO2, 0FH,  80, 38h

        AYPlayChanA ASO1, 0Fh, 240, 38h
        AYNoPlay      80

        AYPlayChanA ASO1, 0Fh,  40, 38h
        AYPlayChanA  AO1, 0Fh,  40, 38h
        AYPlayChanA  GO1, 0Fh,  40, 38h
        AYPlayChanA  FO1, 0Fh, 160, 38h
        AYPlayChanA  CO1, 0FH,  40, 38h

        AYPlayChanA  AO1, 0FH,  53, 38h
        AYPlayChanA ASO1, 0FH,  53, 38h
        AYPlayChanA  CO2, 0FH,  54, 38h
        AYPlayChanA  AO1, 0FH,  80, 38h
        AYPlayChanA  GO1, 0FH,  80, 38h

        AYPlayChanA  FO1, 0FH, 160, 38h

        Loop

        AYStop


.Channel1DMAData
;        AYNoPlay     100                        ;a
;        AYPlayChanB  AO1, 0Fh, 100              ;B
;        AYNoPlay     100                        ;c
;        AYPlayChanB  CO1, 0Fh, 100              ;a + B
;        AYNoPlay     100                        ;a + c
;        AYPlayChanB  CO1, 0Fh, 100              ;B + c
;        AYPlayChanB  EO0, 0Fh, 100              ;a, B + c
;        AYPlayChanB  FO0, 0Fh, 100              ;a, B + c
;        AYPlayChanB  GO0, 0Fh, 100              ;a, B + c
;        AYPlayChanB  EO0, 0Fh, 100              ;a, B + c
;
;        AYNoPlay     200
;
        Repeat        10

        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  CO0, 0Ch, 320
        AYPlayChanB  CO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  CO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  CO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 160
        AYPlayChanB  CO0, 0Ch, 160
        AYPlayChanB  DO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 160
        AYPlayChanB  CO0, 0Ch, 160
        AYPlayChanB  FO0, 0Ch, 320
        AYPlayChanB  FO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 160
        AYPlayChanB  CO0, 0Ch, 160
        AYPlayChanB  DO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 160
        AYPlayChanB  CO0, 0Ch, 160
        AYPlayChanB  FO0, 0Ch, 320

        AYNoPlay     200

        AYPlayChanB  FO0, 0Ch, 160
        AYPlayChanB  AO0, 0Ch, 160
        AYPlayChanB  DO0, 0Ch, 320
        AYPlayChanB  GO0, 0Ch, 160
        AYPlayChanB  FO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 160
        AYPlayChanB  CO0, 0Ch, 160
        AYPlayChanB  FO0, 0Ch, 160
        AYPlayChanB  AO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 320
        AYPlayChanB  GO0, 0Ch, 160
        AYPlayChanB  FO0, 0Ch, 160
        AYPlayChanB ASO0, 0Ch, 160
        AYPlayChanB  CO0, 0Ch, 160
        AYPlayChanB  AO0, 0Ch, 160

        Loop

        AYStop


.Channel2DMAData
;        AYNoPlay     100                        ;a
;        AYNoPlay     100                        ;b
;        AYPlayChanC  FO1, 0Fh, 100              ;C
;        AYNoPlay     100                        ;a + b
;        AYPlayChanC  FO1, 0Fh, 100              ;a + C
;        AYPlayChanC  FO1, 0Fh, 100              ;b + C
;        AYPlayChanC  GO0, 0Fh, 100              ;a, b + C
;        AYPlayChanC  AO0, 0Fh, 100              ;a, b + C
;        AYPlayChanC  BO0, 0Fh, 100              ;a, b + C
;        AYPlayChanC  CO1, 0Fh, 100              ;a, b + C
;
;        AYNoPlay     200
;
        Repeat        10

        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC ASO0, 0Ah, 320
        AYPlayChanC ASO0, 0Ah, 320
        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC ASO0, 0Ah, 320
        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC ASO0, 0Ah, 320

        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC  AO0, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 160
        AYPlayChanC ASO0, 0Ah, 160
        AYPlayChanC  FO0, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 160
        AYPlayChanC ASO0, 0Ah, 160
        AYPlayChanC  AO0, 0Ah, 320
        AYPlayChanC  AO0, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 160
        AYPlayChanC ASO0, 0Ah, 160
        AYPlayChanC  FO0, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 160
        AYPlayChanC ASO0, 0Ah, 160
        AYPlayChanC  AO0, 0Ah, 320

        AYNoPlay     200

        AYPlayChanC  AO0, 0Ah, 160
        AYPlayChanC  CO1, 0Ah, 160
        AYPlayChanC  FO0, 0Ah, 320
        AYPlayChanC ASO0, 0Ah, 160
        AYPlayChanC  AO0, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 160
        AYPlayChanC  EO0, 0Ah, 160
        AYPlayChanC  AO0, 0Ah, 160
        AYPlayChanC  CO1, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 320
        AYPlayChanC ASO0, 0Ah, 160
        AYPlayChanC  AO0, 0Ah, 160
        AYPlayChanC  DO0, 0Ah, 160
        AYPlayChanC  EO0, 0Ah, 160
        AYPlayChanC  CO1, 0Ah, 160

        Loop

        AYStop



