;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(All the static messages and fixed value DBs)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        DEFSEG  FixedData, CLASS=DATA
;
;        SEG     FixedData
;
;
;        PUBLIC  .MainMenuTable          ;accessed from TESTPACK
;;        PUBLIC  .StepOnMenuTable        ;acessed from ALLTESTS
;        PUBLIC  .CRTCInitialValues      ;accessed from SUPPORT
;        PUBLIC  .Initial16ColorPalette  ;accessed from SUPPORT
;        PUBLIC  .HexDigits              ;accessed from SUPPORT
;        PUBLIC  .MatrixDefinitions      ;accessed from SUPPORT
;        PUBLIC  .Arnold5Key             ;accessed from SUPPORT
;        PUBLIC  .RetestMess             ;accessed from SUPPORT
;        PUBLIC  .KeyTranslateTable      ;accessed from FLOPCMND
;        PUBLIC  .RecognizableString     ;accessed from RAMTEST
;        PUBLIC  .ModeMess               ;accessed from MODES
;        PUBLIC  .Mode0MaskTable         ;accessed from MODES
;        PUBLIC  .Mode1MaskTable         ;accessed from MODES
;        PUBLIC  .Mode2MaskTable         ;accessed from MODES
;        PUBLIC  .LenRecogString         ;accessed from RAMTEST
;        PUBLIC  .ErrorMessageTable      ;accessed from ERROR
;        PUBLIC  .LowMess                ;accessed from ERROR
;        PUBLIC  .HighMess               ;accessed from ERROR
;        PUBLIC  .RAMFillMess            ;accessed from ERROR
;        PUBLIC  .RAMWaveUpStoredMess    ;accessed from ERROR
;        PUBLIC  .RAMWaveUpInverseMess   ;accessed from ERROR
;        PUBLIC  .RAMWaveDnInverseMess   ;accessed from ERROR
;        PUBLIC  .RAMWaveDnStoredMess    ;accessed from ERROR
;        PUBLIC  .RAMBlockMess           ;accessed from ERROR
;        PUBLIC  .RAMOffsetMess          ;accessed from ERROR
;        PUBLIC  .RAMBitMess             ;accessed from ERROR
;        PUBLIC  .FlybackLowMess         ;accessed from ERROR
;        PUBLIC  .FlybackHighMess        ;accessed from ERROR
;        PUBLIC  .FlybackActiveMess      ;accessed from ERROR
;        PUBLIC  .FlybackInactiveMess    ;accessed from ERROR
;        PUBLIC  .IntPeriodMess          ;accessed from ERROR
;        PUBLIC  .IntNotThereMess        ;accessed from ERROR
;        PUBLIC  .InitProcessorMessPt1   ;accessed from TESTPACK
;        PUBLIC  .InitProcessorMessPt2   ;accessed from TESTPACK
;        PUBLIC  .CrLfMess               ;accessed from TESTPACK
;        PUBLIC  .Arnold5ErrorMess       ;accessed from TESTPACK
;        PUBLIC  .CheckSumMess           ;accessed from TESTPACK
;        PUBLIC  .TestingBlockMess       ;accessed from RAMTEST
;        PUBLIC  .LoopCountMess          ;accessed from COUNTER
;        PUBLIC  .LoopLimitMess          ;accessed from COUNTER
;        PUBLIC  .FrameFlybackMess       ;accessed from FLYBACK
;        PUBLIC  .InterruptMess          ;accessed from INTTEST
;        PUBLIC  .PlayChannelAMess       ;accessed from SOUND
;        PUBLIC  .PlayChannelBMess       ;accessed from SOUND
;        PUBLIC  .PlayChannelCMess       ;accessed from SOUND
;        PUBLIC  .TestStereoMess         ;accessed from SOUND
;        PUBLIC  .PlayAnBMess            ;accessed from SOUND
;        PUBLIC  .PlayAnCMess            ;accessed from SOUND
;        PUBLIC  .PlayBnCMess            ;accessed from SOUND
;        PUBLIC  .PlayAnBnCMess          ;accessed from SOUND
;        PUBLIC  .PlayEnvelopesMess      ;accessed from SOUND
;        PUBLIC  .EnvelopeEqualMess      ;accessed from SOUND
;        PUBLIC  .EnvelopeBackMess       ;accessed from SOUND
;        PUBLIC  .EnvelopeShapeTable     ;accessed from SOUND
;        PUBLIC  .Pal27TestMess          ;accessed from PALET27
;        PUBLIC  .PalWhiteoutMess        ;accessed from PALET27
;        PUBLIC  .Pal27Line1Mess         ;accessed from PALET27
;        PUBLIC  .Pal27Line9Mess         ;accessed from PALET27
;        PUBLIC  .Pal27Line17Mess        ;accessed from PALET27
;        PUBLIC  .PalVector0to8          ;accessed from PALET27
;        PUBLIC  .PalVector9to11         ;accessed from PALET27
;        PUBLIC  .PalVector12to1A        ;accessed from PALET27
;        PUBLIC  .KeyTestLegend1         ;accessed from KEYBOARD
;        PUBLIC  .KeyTestLegend2         ;accessed from KEYBOARD
;        PUBLIC  .KeyTestLegend3         ;accessed from KEYBOARD
;        PUBLIC  .KeyTestLegend4         ;accessed from KEYBOARD
;        PUBLIC  .KeyTestLegend5         ;accessed from KEYBOARD
;        PUBLIC  .KeyboardDiagTable      ;accessed from KEYBOARD
;        PUBLIC  .PrinterOFFMess         ;accessed from PRINTER
;        PUBLIC  .PrinterONMess          ;accessed from PRINTER
;        PUBLIC  .TapeTestMess           ;accessed from TAPE
;        PUBLIC  .TapeSampleMess         ;accessed from TAPE
;        PUBLIC  .AnalogTestMess         ;accessed from ANALOGUE
;        PUBLIC  .AnalogChannelMess      ;accessed from ANALOGUE
;        PUBLIC  .AnalogColonMess        ;accessed from ANALOGUE
;        PUBLIC  .Palette4096Mess        ;accessed from PALET496
;        PUBLIC  .SpriteTestMess         ;accessed from SPRITES
;        PUBLIC  .SpriteSunDefinition    ;accessed from SPRITES
;        PUBLIC  .SpriteMountainData     ;accessed from SPRITES
;        PUBLIC  .SpritePalette          ;accessed from SPRITES
;        PUBLIC  .SpriteDefinitions      ;accessed from SPRITES
;        PUBLIC  .SpritePalDefinitions   ;accessed from SPRITPAL
;        PUBLIC  .SpritePalMess          ;accessed from SPRITPAL
;        PUBLIC  .SpriteStartPositions   ;accessed from SPRITES
;        PUBLIC  .SpriteEndPositions     ;accessed from SPRITES
;        PUBLIC  .SpriteMoveVectors      ;accessed from SPRITES
;        PUBLIC  .SpriteMoveStarts       ;accessed from SPRITES
;        PUBLIC  .RasterRainbow          ;accessed from RASTER
;        PUBLIC  .SoundInstructions      ;accessed from SOUNDDMA
;        PUBLIC  .NoDiskControllerMess   ;accessed from FLOPPY
;
;        PUBLIC  .OrionKeyMess           ;accessed from ORION
;        PUBLIC  .OrnSoundPlayingLeft    ;accessed from ORNSOUND
;        PUBLIC  .OrnSoundPlayingRight   ;accessed from ORNSOUND
;        PUBLIC  .OrnSoundPlayingBoth    ;accessed from ORNSOUND
;        PUBLIC  .OrionKeyDiag           ;accessed from ORNCNTRL
;        PUBLIC  .OrionKeyTable          ;accessed from ORNCNTRL
;        PUBLIC  .AnalogOkMess           ;accessed from ORNCNTRL
;        PUBLIC  .AnalogNGMess           ;accessed from ORNCNTRL
;        PUBLIC  .NotOKorNGMess          ;accessed from ORNCNTRL
;
;
;;        EXTERN  AllTests                ;in ALLTESTS
;        EXTERN  OrionTests              ;in ORION
;        EXTERN  FrameFlybackTest        ;in FLYBACK
;        EXTERN  InterruptTest           ;in INTTEST
;        EXTERN  RAMTest                 ;in RAMTEST
;        EXTERN  SimpleSoundTest         ;in SOUND
;        EXTERN  ScreenModesTest         ;in MODES
;        EXTERN  Palette27Test           ;in PALET27
;        EXTERN  KeyboardTest            ;in KEYBOARD
;        EXTERN  PrinterTest             ;in PRINTER
;        EXTERN  DatacorderTest          ;in TAPE
;        EXTERN  FloppyTest              ;in FLOPPY
;        EXTERN  AnalogueJoystickTest    ;in ANALOGUE
;        EXTERN  Palette4096Test         ;in PALET496
;        EXTERN  SpritesTest             ;in SPRITES
;        EXTERN  SpritePaletteTest       ;in SPRITPAL
;        EXTERN  SplitScreenTest         ;in SPLIT
;        EXTERN  SoftScrollTest          ;in SSCROLL
;        EXTERN  RasterInterruptTest     ;in RASTER
;        EXTERN  DMASoundTest            ;in SOUNDDMA
;        EXTERN  IncrementLoopLimit      ;in COUNTER
;        EXTERN  DecrementLoopLimit      ;in COUNTER
;
;        INCLUDE "Equates.inc"
;

.MainMenuTable
                .DB    2               ;row 2
                .DB    4               ;column 6
;                .TEXT    "All the following in sequence:$"
                .TEXT    "Orion Factory Tests$"
                .TEXT    "Frame Flyback Test$"
                .TEXT    "Interrupt Test$"
                .TEXT    "RAM Test$"
                .TEXT    "Simple Sound Test$"
                .TEXT    "Screen Modes Test$"
                .TEXT    "27 Color Palette Test$"
                .TEXT    "Keyboard Test$"
                .TEXT    "Printer Test$"
                .TEXT    "DataCorder Test$"
                .TEXT    "Floppy disk test (DTEST)$"
                .TEXT    "Analogue Joystick Test$"
                .TEXT    "4096 Color Palette Test$"
                .TEXT    "Sprites Movement Test$"
                .TEXT    "Sprite Palette Test$"
                .TEXT    "Split Screen Test$"
                .TEXT    "Soft Scroll Test$"
                .TEXT    "Raster Interrupt Test$"
                .TEXT    "DMA driven Sound Test$"
                .TEXT    "Increment loop limit$"
                .TEXT    "Decrement loop limit$"
                .DB    0                               ;end of text marker

;                .DW    AllTests
                .DW    OrionTests
                .DW    FrameFlybackTest
                .DW    InterruptTest
                .DW    RAMTest
                .DW    UpperSoundTest
;;;                .DW    SimpleSoundTest
                .DW    ScreenModesTest + 4000h
                .DW    UpperPalette27Test + 4000h   ;bit 6 in H set means don't
;;;                .DW    Palette27Test + 4000h   ;bit 6 in H set means don't
                .DW    0 ; UpperKeyboardTest + 4000h    ;CLS but do loop process
;;;                .DW    KeyboardTest + 4000h    ;CLS but do loop process
                .DW    PrinterTest
                .DW    DatacorderTest + 4000h
;;;                .DW    FloppyTest
                .DW    0; UpperFloppyTest
                .DW    AnalogueJoystickTest
                .DW    Palette4096Test + 4000h
                .DW    SpritesTest + 4000h
                .DW    SpritePaletteTest
                .DW    SplitScreenTest
                .DW    SoftScrollTest
                .DW    RasterInterruptTest
                .DW    DMASoundTest
                .DW    IncrementLoopLimit + 8000h ;top bit set means don't
                .DW    DecrementLoopLimit + 8000h ;clear the screen

;.StepOnMenuTable
;                .DB    8                       ;row 8
;                .DB    2                       ;column 2
;                .DB    "Pass Test and step on to next$"
;                .DB    "Fail Test and step on to next$"
;                .DB    "Ignore result, repeat test$"
;                .DB    "Ignore result, perform previous test$"
;                .DB    "End test loop, return to main menu$"
;                .DB    0

;                .DW    1111h           ;these are fixed flag values instead
;                .DW    2222h           ;of being routine addresses to be
;                .DW    3333h           ;run.
;                .DW    4444h
;                .DW    5555h

.HexDigits
        .TEXT    "0123456789ABCDEF"



.Arnold5Key
                .DB    0AAh,0          ;synchronise
                .DB    0FFh,077h,0B3h,051h,0A8h,0D4h,062h,039h,09Ch,046h
                .DB    02Bh,015h,08Ah,0CDh,0EEh,0FFh

.RetestMess
        .TEXT    "    Press "
        .DB	132
        .TEXT	" to re-run that test\r\n"
        .TEXT    "    Any other key to continue$"

.KeyTranslateTable:
                .DB      0,  0,  0,'9','6','3',0Dh,'.',  0,  0,'7','8','5','1','2','0',  7,'[',0Dh,']','4' ;0..20
                .DB      0,5ch,  0,'^','-','@','P',';',':','?','.','0','9','O','I','L','K','M',',','8','7','U','Y','H','J','N',' '      ;21..47
                .TEXT    "65RTGFBV43EWSDCX12"
                .DB	 0,'Q',9,'A',0,'Z',0,0,0,0,0,0,0,8

.RecognizableString:
                .TEXT    "This is a fairly recognizable string"
.LenRecogString =     $ - .RecognizableString

.TestingBlockMess
                .TEXT    "Currently testing RAM block xx of $"

.ModeMess
        .TEXT    "This is MODE $"

.Mode0MaskTable
        .DB    000h,0C0h,00Ch,0CCh
        .DB    030h,0F0h,03Ch,0FCh
        .DB    003h,0C3h,00Fh,0CFh
        .DB    033h,0F3h,03Fh,0FFh

.Mode1MaskTable
        .DB    000h,0F0h,00Fh,0FFh

.Mode2MaskTable
        .DB    000h,0FFh

.ErrorMessageTable:	.TEXT	"Processor ERROR - Test Failed$"        ; ERROR 1
					.TEXT	"RAM ERROR on $"                        ; ERROR 2
																	;  followed by "fill" / "wave up" / "wave down"
																	;  followed by " - block="
																	;  followed by var (block number)
																	;  followed by "  offset="
																	;  followed by var (offset)
																	;  followed by "  bit="
																	;  followed by var (fail bit)

        .TEXT    "RAM Bank Switching ERROR$"			;ERROR 3
        .TEXT    "Frame Flyback ERROR\r\n$"				;ERROR 4
        												;followed by "Signal permanently " / "Period incorrect"
        												;followed by "low" / "high"
        .TEXT    "Interrupt ERROR\r\n$"					;ERROR 5
														;followed by "No timer interrupt" /
														;            "Period is too low" /
														;            "Period is too high (INT may be stuck high)"

        .TEXT    "Printer ERROR\r\n\n"
        .TEXT    "  BUSY signal permanently $"             ;ERROR 6
                ;followed by "high"/"low"

.LowMess:				.TEXT	"low$"
.HighMess:				.TEXT	"high$"
.RAMFillMess:			.TEXT	"initial fill$"
.RAMWaveUpStoredMess:	.TEXT	"wave up,\r\n"
						.TEXT	"  checking normal pattern$"
.RAMWaveUpInverseMess:	.TEXT	"wave up,\r\n"
						.TEXT	"  checking inverse pattern$"
.RAMWaveDnInverseMess:	.TEXT	"wave down,\r\n"
						.TEXT	"  checking inverse pattern$"
.RAMWaveDnStoredMess:	.TEXT	"wave down,\r\n"
						.TEXT	"  checking normal pattern$"
.RAMBlockMess:			.TEXT	"\r\n  Block = $"
.RAMOffsetMess:			.TEXT	"\r\n  Offset = $"
.RAMBitMess:			.TEXT	"\r\n  Failing Bit = $"
.FlybackLowMess			.TEXT	"Flyback Signal stuck low$"
.FlybackHighMess		.TEXT	"Flyback Signal stuck high$"
.FlybackActiveMess		.TEXT	"Active period is incorrect$"
.FlybackInactiveMess	.TEXT	"Inactive period is incorrect$"
.IntPeriodMess			.TEXT	"INT signal period is wrong$"
.IntNotThereMess		.TEXT	"No INT signal detected$"
.InitProcMessPt1:		.TEXT	"Arnold 5 Diagnostic ROM Version "
						.DB		Version,'.',Mark,'$'
.InitProcMessPt2:		.TEXT	"Processor test PASSED$"
.CrLfMess:				.TEXT	"\r\n$"
.Arn5ErrMess:			.TEXT	"\r\nUnable to disable new features !$"
.CheckSumMess:			.TEXT	"\r\n\nROM Checksum = $"
.LoopCountMess:			.TEXT	"Loop Count = $"
.LoopLimitMess:			.TEXT	"Loop Limit = $"
.FrameFlybackMess:		.TEXT	"Testing Frame Flyback signal$"
.InterruptMess:			.TEXT	"Testing Interrupt Signal$"
.PlayChannelAMess:		.TEXT	"Note now playing on Sound Channel A\r\n$"
.PlayChannelBMess:		.TEXT	"Note now playing on Sound Channel B\r\n$"
.PlayChannelCMess:		.TEXT	"Note now playing on Sound Channel C\r\n$"
.PlayAnBMess:			.TEXT	"Playing on channels A and B\r\n$"
.PlayAnCMess:			.TEXT	"Playing on channels A and C\r\n$"
.PlayBnCMess:			.TEXT	"Playing on channels B and C\r\n$"
.TestStereoMess:		.TEXT	"Testing stereo by sweeping from A to C\r\n$"
.PlayAnBnCMess:			.TEXT	"Playing on channels A B and C\r\n$"
.PlayEnvelopesMess:		.TEXT	"\r\nUsing Envelope 00 =       $"
.EnvelopeEqualMess:		.TEXT    " = $"
.EnvelopeBackMess:		.DB		bs,bs,bs,bs,bs,bs,bs,bs,bs,bs,bs,'$'
.EnvelopeShapeTable:	.DB		136,136,136,136,136,136,'$','$'    ;down/vert repeated
						.DB		137,'_','_','_','_','_','$','$'    ;down then quiet
						.DB		137,139,137,139,137,139,'$','$'    ;down up repeated
						.DB		136,140,140,140,140,140,'$','$'    ;down/vert then stay up
						.DB		138,138,138,138,138,138,'$','$'    ;up/vert repeated
						.DB		139,140,140,140,140,140,'$','$'    ;up then stay up
						.DB		139,137,139,137,139,137,'$','$'    ;up down repeated
						.DB		138,'_','_','_','_','_','$','$'    ;up/vert then stay down
.Pal27TestMess:			.TEXT	"Use "
						.DB		132
						.TEXT	" and "
						.DB		133
						.TEXT	" to vary the background colour$"
.PalWhiteoutMess:		.TEXT	"Use "
						.DB		134
						.TEXT	" or "
						.DB		135
						.TEXT	" to turn screen white$"
.Pal27Line1Mess:		.TEXT	"Bright                          Bright          Bright\r\n"
						.TEXT	"    Black   Blue    Blue    Red     Magenta Mauve   Red     Purple  Magenta$"
.Pal27Line9Mess:		.TEXT	"Sky                     Pastel                  Pastel\r\n"
						.TEXT	"    Green   Cyan    Blue    Yellow  White   Blue    Orange  Pink    Magenta$"
.Pal27Line17Mess:		.TEXT	"Bright  Sea     Bright          Pastel  Pastel  Bright  Pastel  Bright\r\n"
						.TEXT	"    Green   Green   Cyan    Lime    Green   Cyan    Yellow  Yellow  White$"
.PalVector0to8:			.DB		20,4,21,28,24,29,12,5,13
.PalVector9to11:		.DB		22,6,23,30,0,31,14,7,15
.PalVector12to1A:		.DB		18,2,19,26,25,27,10,3,11
.KeyTestLegend1:		.TEXT	"Paddle 0                                        Paddle 1$"
.KeyTestLegend2:		.TEXT	"CTRL + TAB$"
.KeyTestLegend3:		.TEXT	"CTRL + ESC$"
.KeyTestLegend4:		.TEXT	"or P + "
						.DB	132
						.TEXT	" to restart$"
.KeyTestLegend5:		.TEXT	"or P + "
						.DB	133
						.TEXT	" to end$"
.KeyboardDiagTable
;
; For each of the 80 keys this shows the (x,y) coordinate position of the
; upper left corner and the text to be put in the middle. All keys are drawn
; as follows:
;
;       ------   so e.g. if TEXT=" A" ----  if TEXT="CAPSLK" --------
;       | TEXT                         |  A                    | CAPSLK
;       |                              |                       |
;
; Such keys when drawn together might give:
;
;       ------------------
;       | TEXT |  A | CAPSLK
;       |      |    |
;       ------------------
;       |  A | CAPSLK | TEXT
;       |    |        |
;
        .DB      64,9            ;(0) key position
        .DB      2               ;length of text
        .DB      ' ',94          ;the text (space, up arrow)

        .DB      68,12,2,' ',135 ;(1) actually right cursor
        .DB      64,12,2,' ',133 ;(2) down cursor
        .DB      68,0,2,'F','9'     ;(3)
        .DB      68,3,2,'F','6'     ;(4)
        .DB      68,6,2,'F','3'     ;(5)
        .DB      46,12,12
        .TEXT	'    ENTER   '  ;(6)
        .DB      68,9,2,' ','.'     ;(7)
        .DB      60,12,2,' ',134 ;(8) left cursor
        .DB      7,12,4
        .TEXT	'COPY'   ;(9)
        .DB      60,0,2,'F','7'     ;(10)
        .DB      64,0,2,'F','8'     ;(11)
        .DB      64,3,2,'F','5'     ;(12)
        .DB      60,6,2,'F','1'     ;(13)
        .DB      64,6,2,'F','2'     ;(14)
        .DB      60,9,2,'F','0'     ;(15)
        .DB      52,0,2,'C','L'     ;(16)
        .DB      49,3,2,' ','['     ;(17)
        .DB      53,3,5
        .TEXT	' RETN'   ;(18)
        .DB      50,6,2,' ',']'     ;(19)
        .DB      60,3,2,'F','4'     ;(20)
        .DB      0,9,5
        .TEXT	'SHIFT'   ;(21)
        .DB      47,9,2,' ',92    ;(22)
        .DB      0,12,5
        .TEXT	'CTRL '  ;(23)
        .DB      48,0,2,' ',132  ;(24) up arrow
        .DB      44,0,2,' ','_'     ;(25)
        .DB      45,3,2,' ','@'     ;(26)
        .DB      41,3,2,' ','P'     ;(27)
        .DB      46,6,2,' ',';'     ;(28)
        .DB      42,6,2,' ',':'     ;(29)
        .DB      43,9,2,' ','/'     ;(30)
        .DB      39,9,2,' ','.'     ;(31)
        .DB      40,0,2,' ','0'     ;(32)
        .DB      36,0,2,' ','9'     ;(33)
        .DB      37,3,2,' ','O'     ;(34)
        .DB      33,3,2,' ','I'     ;(35)
        .DB      38,6,2,' ','L'     ;(36)
        .DB      34,6,2,' ','K'     ;(37)
        .DB      31,9,2,' ','M'     ;(38)
        .DB      35,9,2,' ',','     ;(39)
        .DB      32,0,2,' ','8'     ;(40)
        .DB      28,0,2,' ','7'     ;(41)
        .DB      29,3,2,' ','U'     ;(42)
        .DB      25,3,2,' ','Y'     ;(43)
        .DB      26,6,2,' ','H'     ;(44)
        .DB      30,6,2,' ','J'     ;(45)
        .DB      27,9,2,' ','N'     ;(46)
        .DB      13,12,31
        .TEXT	'             SPACE             ' ;(47)
        .DB      24,0,2,' ','6'     ;(48)
        .DB      20,0,2,' ','5'     ;(49)
        .DB      17,3,2,' ','R'     ;(50)
        .DB      21,3,2,' ','T'     ;(51)
        .DB      22,6,2,' ','G'     ;(52)
        .DB      18,6,2,' ','F'     ;(53)
        .DB      23,9,2,' ','B'     ;(54)
        .DB      19,9,2,' ','V'     ;(55)
        .DB      16,0,2,' ','4'     ;(56)
        .DB      12,0,2,' ','3'     ;(57)
        .DB      13,3,2,' ','E'     ;(58)
        .DB      9,3,2,' ','W'      ;(59)
        .DB      10,6,2,' ','S'     ;(60)
        .DB      14,6,2,' ','D'     ;(61)
        .DB      15,9,2,' ','C'     ;(62)
        .DB      11,9,2,' ','X'     ;(63)
        .DB      4,0,2,' ','1'      ;(64)
        .DB      8,0,2,' ','2'      ;(65)
        .DB      0,0,2,'E','S'      ;(66)
        .DB      5,3,2,' ','Q'      ;(67)
        .DB      0,3,3
        .TEXT	'TAB'     ;(68)
        .DB      6,6,2,' ','A'      ;(69)
        .DB      0,6,4
        .TEXT	'CAPS'    ;(70)
        .DB      7,9,2,' ','Z'      ;(71)

        .DB      4,16,2,' ',132 ;(72) joystick up arrow
        .DB      4,22,2,' ',133 ;(73) joystick down arrow
        .DB      0,19,2,' ',134  ;(74) joystick left arrow
        .DB      8,19,2,' ',135 ;(75) joystick right arrow
        .DB      14,19,2,'F','1'    ;(76) joystick F2 (never used)
        .DB      20,19,2,'F','2'    ;(77) joystick F1

        .DB      0,0,2,'E','C'      ;(78) key never used (redraws ESC)

        .DB      56,0,2,'D','L'     ;(79)

        .DB      51,9,7
        .TEXT	' SHIFT ' ;(80) (really 21 the second time)
        .DB      54,6,4
        .TEXT	'    '    ;(81) extra bit of RETN

        .DB      52,16,2,' ',132 ;(82) joystick 1 up arrow
        .DB      52,22,2,' ',133 ;(83) joystick 1 down arrow
        .DB      48,19,2,' ',134  ;(84) joystick 1 left arrow
        .DB      56,19,2,' ',135 ;(85) joystick 1 right arrow
        .DB      62,19,2,'F','1'    ;(86) joystick 1 F2 (never used)
        .DB      68,19,2,'F','2'    ;(87) joystick 1 F1

        .DB      4,19,2,' ',' '     ;(88) middle of paddle 0
        .DB      52,19,2,' ',' '    ;(89) middle of paddle 1


.OrionKeyDiag
        .TEXT      " CHANNEL 1"
        .DB	9,9
        .TEXT	"     CHANNEL 2"
        .DB	0dh,0ah
        .DB      0ah
        .DB      9
        .TEXT	"   Digital Joysticks",
        .DB	0dh,0ah
        .DB      9
        .TEXT	"   ================="
        .DB	0dh,0ah
        .DB      0ah
        .DB      0ah
        .DB      0ah
        .DB      9
        .TEXT	"   Analog Joysticks"
        .DB	0dh,0ah
        .DB      9
        .TEXT	"   ================"
        .DB	0dh,0ah
        .TEXT      " X1 =        "
        .DB	132,' ',134
        .TEXT	", Press F1   X2 = "
        .DB	0dh,0ah
        .TEXT      " Y1 =        "
        .DB	133,' ',135
        .TEXT	", Press F2   Y2 = "
        .DB	0dh,0ah
        .DB      0ah
        .DB      9
        .TEXT	"     Fire Buttons"
        .DB	0dh,0ah
        .DB      9
        .TEXT	"     ============"
        .DB	0dh,0ah
        .DB      0ah
        .DB      0ah
        .DB      0ah
        .DB      9
        .TEXT	"     Pause Key"
        .DB	0dh,0ah
        .DB      9
        .TEXT	"     ========="
        .DB	0dh,0ah
        .DB      0ah
        .DB      0ah
        .DB      0ah
        .TEXT      "Press  "
        .DB	133
        .TEXT	" and Pause (P)  or  ESC  to end."
        .DB      "$"

.OrionKeyTable
;
; Each entry is an XY co-ordinate followed by the address of a text message
;
        .DW      00503h
        .DW      .OUpMess

        .DW      00703h
        .DW      .ODnMess

        .DW      00602h
        .DW      .OLfMess

        .DW      00604h
        .DW      .ORtMess

        .DW      00522h
        .DW      .OupMess

        .DW      00722h
        .DW      .ODnMess

        .DW      00621h
        .DW      .OLfMess

        .DW      00623h
        .DW      .ORtMess

        .DW      01102h
        .DW      .OF1Mess

        .DW      01108h
        .DW      .OF2Mess

        .DW      0111Bh
        .DW      .OF1Mess

        .DW      01121h
        .DW      .OF2Mess

        .DW      0160Fh
        .DW      .OPsMess

.OUpMess:				.DB		132,'$'
.ODnMess:				.DB		133,'$'
.OLfMess:				.DB		134,'$'
.ORtMess:				.DB		135,'$'
.OF1Mess:				.TEXT	"Fire1$"
.OF2Mess:				.TEXT	"Fire2$"
.OPsMess:				.TEXT	"PAUSE$"
.AnalogOKMess:			.TEXT	"OK$"
.AnalogNGMess:			.TEXT	"NG$"
.NotOKorNGMess:			.TEXT	"  $"
.PrinterOFFMess:		.TEXT	"Switch Printer OFF-Line then press\r\n"
						.TEXT	"any key - press ESC/FIRE to abandon.\r\n\n$"
.PrinterONMess:			.TEXT	"Switch Printer ON-Line then press\r\n"
						.TEXT	"any key - press ESC/FIRE to abandon.\r\n\n$"
.TapeTestMess:			.TEXT	"Play the test tape and adjust the head azimuth screw to get the best possible\r\n"
						.TEXT	"reading on the following graph (ESC/FIRE abandons test):\r\n\n\n\n"
						.TEXT	"|       |       |       |       |       |       |       |       |       |$"
.TapeSampleMess:		.TEXT	"Sample rate =$"

.AnalogTestMess
        .TEXT    "      Analogue Joystick Test"
        .DB	0dh,0ah
        .DB    0dh,0ah
        .TEXT    "The following display shows the values"
        .DB	0dh,0ah
        .TEXT    "read from the analogue channels."
        .DB	0dh,0ah,0ah

        .TEXT    "Only Channels 0..3 are active (4..7 are"
        .DB	0dh,0ah
        .TEXT    "tied). The range of values on channels"
        .DB	0dh,0ah
        .TEXT    "0..3 should be 00 to 3F"
        .DB	0dh,0ah
        .DB    0ah,0ah,'$'
.AnalogChannelMess
        .TEXT    "Channel $"
.AnalogColonMess
        .TEXT    " = $"

.Palette4096Mess
        .TEXT    "Use "
        .DB	134
        .TEXT	" and "
        .DB	135
        .TEXT	" to vary the background"
        .DB	0dh,0ah
        .TEXT    "Use "
        .DB	132
        .TEXT	" and "
        .DB	133
        .TEXT	" to vary the Green level =$"

.NoDiskControllerMess
        .TEXT      "There is no 765 disk controller fitted."
        .DB	0dh,0ah,0ah
        .TEXT      "              Test Abandoned.$"

.SpriteTestMess
        .DB      9
        .TEXT	"      SPRITES TEST       "
        .DB	0dh,0ah
        .DB      9
        .TEXT	"                         "
        .DB	0dh,0ah
        .DB      9
        .TEXT	"Use "
        .DB	132
        .TEXT	" and "
        .DB	133
        .TEXT	" to vary speed"
        .DB	0dh,0ah
        .DB      9
        .TEXT	"                         "
        .DB	0dh,0ah
        .DB      9
        .TEXT	"Press ESC or FIRE to Exit$"

.SpriteSunDefinition
        .DB    000h,000h,0FFh,0FFh,0FFh,0FFh,000h,000h
        .DB    000h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,000h
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
        .DB    000h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,000h
        .DB    000h,000h,0FFh,0FFh,0FFh,0FFh,000h,000h

.SpriteMountainData
        .DB    1,1,1,0,0,0,0,1,1,1,-1,1,-1,1,-1,-1,-1,0,0,0,-1,-1,-1
        .DB    0,1,0,0,0,0,1,1,-1,-1,-1,0,1,1,-1,-1,1,-1

.SpritePalMess
        .DB    9
        .TEXT	"  SPRITE PALETTE TEST"
        .DB	0dh,0ah,0ah
        .TEXT    "Use "
        .DB	134
        .TEXT	" and "
        .DB	135
        .TEXT	" to vary blue component ="
        .DB	0dh,0ah
        .TEXT    "Use "
        .DB	132
        .TEXT	" and "
        .DB	133
        .TEXT	" to vary red component  ="
        .DB	0dh,0ah
        .TEXT    "        Press ESC or FIRE to exit         $"

.SPritePalette
        .DW    0004h,0040h,0400h,0444h,0007h,0070h,0700h,0777h
        .DW    000Bh,00B0h,0B00h,0BBBh,000Fh,00F0h,0F00h,0FFFh

.SpriteStartPositions
        .DW    32,0                   ;sprite 0
        .DW    160,0                  ;sprite 1
        .DW    288,0                  ;sprite 2
        .DW    416,0                  ;sprite 3
        .DW    544,0                  ;sprite 4
        .DW    544,36                  ;sprite 5
        .DW    544,72                  ;sprite 6
        .DW    544,108                 ;sprite 7
        .DW    544,144                 ;sprite 8
        .DW    416,144                 ;sprite 9
        .DW    288,144                 ;sprite A
        .DW    160,144                 ;sprite B
        .DW    32,144                  ;sprite C
        .DW    32,108                  ;sprite D
        .DW    32,72                   ;sprite E
        .DW    32,36                   ;sprite F

        .DW    32,16                   ;sprite 0
        .DW    160,16                  ;sprite 1
        .DW    288,16                  ;sprite 2
        .DW    416,16                  ;sprite 3
        .DW    544,16                  ;sprite 4
        .DW    544,48                  ;sprite 5
        .DW    544,80                  ;sprite 6
        .DW    544,112                 ;sprite 7
        .DW    544,144                 ;sprite 8
        .DW    416,144                 ;sprite 9
        .DW    288,144                 ;sprite A
        .DW    160,144                 ;sprite B
        .DW    32,144                  ;sprite C
        .DW    32,112                  ;sprite D
        .DW    32,80                   ;sprite E
        .DW    32,48                   ;sprite F

.SpriteEndPositions:
        .DW    0,0                     ;sprite 0
        .DW    128,0                    ;sprite 1
        .DW    256,0                   ;sprite 2
        .DW    384,0                   ;sprite 3
        .DW    0,48                    ;sprite 4
        .DW    128,48                   ;sprite 5
        .DW    256,48                  ;sprite 6
        .DW    384,48                  ;sprite 7
        .DW    0,96                    ;sprite 8
        .DW    128,96                   ;sprite 9
        .DW    256,96                  ;sprite A
        .DW    384,96                  ;sprite B
        .DW    0,144                   ;sprite C
        .DW    128,144                  ;sprite D
        .DW    256,144                 ;sprite E
        .DW    384,144                 ;sprite F


.SpriteMoveVectors
;
; These are the offsets to X and Y that are incrementally added to the sprite
; positions to make them move.
;
        .DB    4,0                     ; 1 sprite 0 start  off= 0
        .DB    4,0                     ; 2 sprite 1 start  off= 2
        .DB    4,0                     ; 3 sprite 2 start  off= 4
        .DB    4,0                     ; 4 sprite 3 start  off= 6
        .DB    4,0                     ; 5                 off= 8
        .DB    -4,0                    ; 6                 off= A
        .DB    0,1                     ; 7 sprite 4 start  off= C
        .DB    0,1                     ; 8 sprite 5 start  off= E
        .DB    0,1                     ; 9 sprite 6 start  off=10
        .DB    0,1                     ; A sprite 7 start  off=12
        .DB    0,1                     ; B                 off=14
        .DB    0,1                     ; C                 off=16
        .DB    0,-1                    ; D                 off=18
        .DB    0,-1                    ; E                 off=1A
        .DB    -4,0                    ; F sprite 8 start  off=1C
        .DB    -4,0                    ;10 sprite 9 start  off=1E
        .DB    -4,0                    ;11 sprite A start  off=20
        .DB    -4,0                    ;12 sprite B start  off=22
        .DB    -4,0                    ;13                 off=24
        .DB    4,0                     ;14                 off=26
        .DB    0,-1                    ;15 sprite C start  off=28
        .DB    0,-1                    ;16 sprite D start  off=2A
        .DB    0,-1                    ;17 sprite E start  off=2C
        .DB    0,-1                    ;18 sprite F start  off=2E
        .DB    0,-1                    ;19
        .DB    0,-1                    ;1A
        .DB    0,1                     ;1B
        .DB    0,1                     ;1C
        .DB    -1                      ;end of table mark to allow easy wraps

.SpriteMoveStarts
;
; These are offsets into the above table to determine where each sprite starts
;
        .DB    00h,02h,04h,06h, 0Ch,0Eh,10h,12h
        .DB    1Ch,1Eh,20h,22h, 28h,2Ah,2Ch,2Eh

.RasterRainbow
        .DB      12,14,10,18,21,24,13,20

.SoundInstructions:		.TEXT    "A tune will now begin to play in the\r\n"
						.TEXT    "background using the Sound DMA feature\r\n"
						.TEXT    "to program data into the sound chip. In\r\n"
						.TEXT    "the meantime the Keyboard test will be\r\n"
						.TEXT    "run to make sure that the two do not\r\n"
						.TEXT    "interact. When you end the keyboard\r\n"
						.TEXT    "test the sound will also be turned off\r\n"
						.TEXT    "Press any key to continue.$"
.OrionKeyMess:			.TEXT    "Press any key to continue$"
.OrnSoundPlayingLeft	.TEXT    "Note playing on Left Channel$"
.OrnSoundPlayingRight	.TEXT    "Note playing on Right Channel$"
.OrnSoundPlayingBoth	.TEXT    "Note playing on Middle Channel$"

