;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Test of screen modes)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  ScreenModesTest         ;called indirectly from TESTPACK
;                                        ; out of MainMenuTable
;
;        EXTERN  SetCursorPos            ;in SUPPORT
;        EXTERN  ScreenPrintChar         ;in SUPPORT
;        EXTERN  PrintStringHL           ;in SUPPORT
;        EXTERN  PrintAHex               ;in SUPPORT
;        EXTERN  KeyboardRead            ;in SUPPORT
;        EXTERN  .ModeMess               ;in MESSAGES
;        EXTERN  .Mode0MaskTable         ;in MESSAGES
;        EXTERN  .Mode1MaskTable         ;in MESSAGES
;        EXTERN  .Mode2MaskTable         ;in MESSAGES
;
;        EXTERN  ?ScreenMode             ;in TESTVARS
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;===============
ScreenModesTest:
;===============
;
; I cannot tell from within the software how good or bad the screen display
; looks so the best I can do here is switch the screen between each of the 3
; MODEs and print a character set and some pretty blobs that the user will
; have to identify any faults in.
;
; In a rash moment I thought I might also have a stab at the odd MODE 3 and
; perhaps have a quick go at the special 6845 programming to make MODE 1
; look like a Spectrum (i.e. 256 x 192 instead of the normal 320 x 200).
;
; For MODE 0 the screen should look summat like:
;
;  <--------20--------->
; ͻ
;  @ABCDEFGHIJKLMNOPQRS
;  ABCDEFGHIJKLMNOPQRST|
;  BCDEFGHIJKLMNOPQRSTU|
;  CDEFGHIJKLMNOPQRSTUV|
;  DEFGHIJKLMNOPQRSTUVW|
;  EFGHIJKLMNOPQRSTUVWX|
;  FGHIJKLMNOPQRSTUVWXY|
;  GHIJKLMNOPQRSTUVWXYZ|
;  HIJKLMNOPQRSTUVWXYZ[|
;  IJKLMNOPQRSTUVWXYZ[\|
;  JKLMNOPQRSTUVWXYZ[\]|
;  KLMNOPQRSTUVWXYZ[\]^25
;  LMNOPQRSTUVWXYZ[\]^_|
;  MNOPQRSTUVWXYZ[\]^_'|
;  NOPQRSTUVWXYZ[\]^_'a|
;  OPQRSTUVWXYZ[\]^_'ab|
;  PQRSTUVWXYZ[\]^_'abc|
;  QRSTUVWXYZ[\]^_'abcd|
;  RSTUVWXYZ[\]^_'abcde|
;  STUVWXYZ[\]^_'abcdef|
;                      |
;     ۰۰۰۰  |   line start = C690h, top left blobs = C698h
;    0123456789ABCDEF  |
;     ۰۰۰۰  |
;     ۰۰۰۰  
; ͼ
;
; For MODE 1 the screen should look summat like:
;
;  <-----------------40-------------------->
; ͻ
;  @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefg
;  ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefgh
;  BCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghi
;  CDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghij
;  DEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijk
;  EFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijkl
;  FGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklm
;  GHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmn
;  HIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmno
;  IJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnop
;  JKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopq
;  KLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqr
;  LMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrs
;  MNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrst
;  NOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstu
;  OPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuv
;  PQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvw
;  QRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwx
;  RSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxy
;  STUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz
;                                          
;            ۰
;    PEN  0  PEN  1۰PEN  2PEN  3
;            ۰
;            ۰
; ͼ
;
; For MODE 2 the screen should look summat like:
;
;  <-------------------------------------80---------------------------------------->
; ͻ
;   !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmno
;  !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnop
;  "#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopq
;  #$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqr
;  $%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrs
;  %&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrst
;  &'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstu
;  '()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuv
;  ()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvw
;  )*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwx
;  *+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxy
;  +,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz
;  ,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{
;  -./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|
;  ./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}
;  /0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~
;  0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~
;  123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~.
;  23456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~..
;  3456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~...
;                                                                                  
;                                          ۺ
;          PEN 0                           PEN 1ۺ
;                                          ۺ
;                                          ۺ
; ͼ
;
;
; Finally the screen is put into the infamous "MODE 3" and the MODE 0 test
; pattern is drawn on it.
;

;
; The following draws the MODE 0 test screen.
;
        ld      hl,0C000h
        ld      de,0C001h
        ld      bc,03FFFh
        ld      (hl),0
        ldir                            ;clear screen

        exx                             ;C' has ROM/MODE bits
        ld      b,07Fh
        ld      a,c
        and     11111100b               ;clear MC0 and MC1 bits
        ld      c,a
        out     (c),c                   ;set MODE 0
        exx

        call    _ModeDoMODE0Test

        ld      de,1403h
        call    SetCursorPos
        ld      hl,.ModeMess
        ld      b,1
        call    PrintStringHL
        ld      a,0                     ;Tell user which MODE this is
        call    PrintAHex

        call    _ModesWaitKey

;
; The following draws the MODE 1 test screen.
;
        ld      hl,0C000h
        ld      de,0C001h
        ld      bc,03FFFh
        ld      (hl),0
        ldir                            ;clear screen

        exx                             ;C' has ROM/MODE bits
        ld      b,07Fh
        ld      a,c
        and     11111100b               ;clear MC0 and MC1 bits
        or      1                       ;then set MODE 1 bit
        ld      c,a
        out     (c),c                   ;set MODE 1
        exx

        ld      a,1
        ld      (QUESTMARK_ScreenMode),a

        ld      a,64                    ;start at "@" character on 1st line
        ld      b,20                    ;number of lines to print
        ld      c,0                     ;will count up rows
_Mode1CharlineLoop:
        push    bc                      ;and line counter
        push    af                      ;save start char

        ld      d,c
        ld      e,0
        call    SetCursorPos

        pop     af
        push    af

        ld      b,40                    ;number of chars on a line
_Mode1DoALine:
        push    bc                      ;store character count
        push    af                      ;save current character
        call    ScreenPrintChar         ;(SUPPORT) print it
        pop     af                      ;retrieve current character
        inc     a                       ;step char up as we do a line
        pop     bc                      ;retrieve char count
        djnz    _Mode1DoALine

        pop     af                      ;get starting character
        pop     bc                      ;get line counter
        inc     a                       ;next line starts with next char
        inc     c
        djnz    _Mode1CharLineLoop

;
; The MODE 1 screen is 40 chars wide and we want to show 4 color bars so each
; is 10 characters wide. MODE 1 chars use 2 bytes so each "blob" is 20 bytes
; wide. The four bytes to produce PEN 0, 1 2 and 3 are 000h, 0F0h, 00Fh, 0FFh.
; These are held in .Mode1MaskTable.
;
; location=C690h                ;cos we use full line width (no indent)
; FOR line=0 TO 3
;  FOR scan=0 TO 7
;   table_pointer = addr(table)
;   FOR blob=0 to 3
;    FOR byte=0 TO 19
;     POKE location,(table_pointer)
;     INC location
;    NEXT byte
;    INC table_pointer
;   NEXT blob
;   location=location + 800h (down a scan) - 80 (cos we've gone across that many)
;  NEXT scan
;  location=location + 80 (down a char line) + &c000 (cos it wraps over FFFF..0)
; NEXT line
;

        ld      hl,0C690h               ;the magic location (start line 21)
        ld      b,4                     ;FOR lines: 4 of 'em
_Mode1BarsLineloop:
        ld      c,8                     ;FOR scans: 8 on current 8*8
_Mode1BarsScanLoop:
        push    bc
        ld      de,.Mode1MaskTable      ;table_pointer = ADDR (table)
        ld      b,4                     ;FOR blobs: 4 to make a line
_Mode1BarsBlobLoop:
        ld      c,20                     ;FOR byte: 20 for each color blob
_Mode1BarsByteLoop:
        ld      a,(de)
        ld      (hl),a                  ;POKE location, (table pointer)
        inc     hl                      ;INC Location
        dec     c
        jr      nz,_Mode1BarsByteLoop   ;NEXT byte

        inc     de                      ;INC table pointer
        djnz    _Mode1BarsBlobLoop      ;NEXT blob

        ld      de,800h - 80
        add     hl,de                   ;location=location + 800h - 80
        pop     bc                      ;get two outer counters back
        dec     c
        jr      nz,_Mode1BarsScanLoop   ;NEXT scan

        ld      de,0C000h + 80
        add     hl,de                   ;wraps back down to next char line

        djnz    _Mode1BarsLineLoop       ;NEXT line

        ld      de,140Ch
        call    SetCursorPos
        ld      hl,.ModeMess
        ld      b,1
        call    PrintStringHL
        ld      a,1                     ;Tell user which MODE this is
        call    PrintAHex

        call    _ModesWaitKey

;
; The following draws the MODE 2 test screen.
;
        ld      hl,0C000h
        ld      de,0C001h
        ld      bc,03FFFh
        ld      (hl),0
        ldir                            ;clear screen

        exx                             ;C' has ROM/MODE bits
        ld      b,07Fh
        ld      a,c
        and     11111100b               ;clear MC0 and MC1 bits
        or      2                       ;set MODE 2 bit
        ld      c,a
        out     (c),c                   ;set MODE 2
        exx

        ld      a,2
        ld      (QUESTMARK_screenmode),a

        ld      a,32                    ;start at "@" character on 1st line
        ld      b,20                    ;number of lines to print
        ld      c,0
_Mode2CharlineLoop:
        push    bc                      ;and line counter
        push    af                      ;save start char

        ld      d,c
        ld      e,0
        call    SetCursorPos

        pop     af
        push    af

        ld      b,80                    ;number of chars on a line
_Mode2DoALine:
        push    bc                      ;store character count
        push    af                      ;save current character
        call    ScreenPrintChar         ;(SUPPORT) print it
        pop     af                      ;retrieve current character
        inc     a                       ;step char up as we do a line
        pop     bc                      ;retrieve char count
        djnz    _Mode2DoALine

        pop     af                      ;and starting character
        pop     bc                      ;get line counter
        inc     a                       ;next line starts with next char
        inc     c                       ;step row counter on
        djnz    _Mode2CharLineLoop

; The MODE 2 screen is 80 chars wide and we want to show 2 color bars so each
; is 40 characters wide. MODE 2 chars use 1 byte so each "blob" is 40 bytes
; wide. The two bytes to produce PEN 0, 1 are 000h, 0FFh. These are held
; in .Mode2MaskTable.
;
; location=C690h
; FOR line=0 TO 3
;  FOR scan=0 TO 7
;   table_pointer = addr(table)
;   FOR blob=0 to 1
;    FOR byte=0 TO 39
;     POKE location,(table_pointer)
;     INC location
;    NEXT byte
;    INC table_pointer
;   NEXT blob
;   location=location + 800h (down a scan) - 80 (cos we've gone across that many)
;  NEXT scan
;  location=location + 80 (down a char line) + &c000 (cos it wraps over FFFF..0)
; NEXT line
;
        ld      hl,0C690h               ;the magic location
        ld      b,4                     ;FOR lines: 4 of 'em
_Mode2BarsLineloop:
        ld      c,8                     ;FOR scans: 8 on current 8*8
_Mode2BarsScanLoop:
        push    bc
        ld      de,.Mode2MaskTable      ;table_pointer = ADDR (table)
        ld      b,2                     ;FOR blobs: 2 to make a line
_Mode2BarsBlobLoop:
        ld      c,40                    ;FOR byte: 40 for each color blob
_Mode2BarsByteLoop:
        ld      a,(de)
        ld      (hl),a                  ;POKE location, (table pointer)
        inc     hl                      ;INC Location
        dec     c
        jr      nz,_Mode2BarsByteLoop   ;NEXT byte

        inc     de                      ;INC table pointer
        djnz    _Mode2BarsBlobLoop      ;NEXT blob

        ld      de,800h - 80
        add     hl,de                   ;location=location + 800h - 80
        pop     bc                      ;get two outer counters back
        dec     c
        jr      nz,_Mode2BarsScanLoop   ;NEXT scan

        ld      de,0C000h + 80
        add     hl,de                   ;wraps back down to next char line

        djnz    _Mode2BarsLineLoop       ;NEXT line

        ld      de,1420h
        call    SetCursorPos
        ld      hl,.ModeMess
        ld      b,1
        call    PrintStringHL
        ld      a,2                     ;Tell user which MODE this is
        call    PrintAHex

        call    _ModesWaitKey

;
; This final bit is a bit of an oddity. There is a fourth mode (MODE 3) which
; is the un documented combination of the bottom two bits (both=1). In this
; mode the color info is scanned like MODE 0 but only the right half of each
; nybble is used (making 8K for the whole screen). The other 4 bits in each
; byte is free for other things - such as a back screen. It may have been used
; in some games.
;
        ld      hl,0C000h
        ld      de,0C001h
        ld      bc,03FFFh
        ld      (hl),0
        ldir                            ;clear screen

        exx                             ;C' has ROM/MODE bits
        ld      b,07Fh
        ld      a,c
        and     11111100b               ;clear MC0 and MC1 bits
        or      3                       ;set MODE 3 bits
        ld      c,a
        out     (c),c                   ;set MODE 3
        exx

        call    _ModeDoMODE0Test        ;drawing like we are in MODE 0

        ld      de,1403h
        call    SetCursorPos
        ld      hl,.ModeMess
        ld      b,1
        call    PrintStringHL
        ld      a,3                     ;Tell user which MODE this is
        call    PrintAHex

        call    _ModesWaitKey

_ModesEndTest:

        xor     a                       ;clear carry cos there can never be
                                        ;an error !
        ret

_ModesWaitKey:
;
; Simple routine just waits for any key to be hit. If one isn't hit within
; a certain time limit then we return anyway.
;
        ld      b,40h                  ;a delay
_ModesKeyLoop:
        push    bc
        call    KeyboardRead
        pop     bc
        cp      0FFh
        jr      nz,_ModesWaitKeyHit
        djnz    _ModesKeyLoop          ;and may drop thru to RET anyway
        ld      a,0

_ModesWaitKeyHit:
        cp      66                      ;was ESC pressed
        jr      z,_ModesEarlyEnd
        cp      76                      ;was joy 0 fire
        jr      z,_ModesEarlyEnd
        ret


_ModesEarlyEnd:
        pop     hl                      ;waste return address from call to
                                        ;_ModesWaitKey
        jr      _ModesEndTest           ;then leave


_ModeDoMODE0Test:
;
; This same code is used for both MODE 0 and MODE 3 so is moved to the end here
; as a subroutine.
;
        xor     a
        ld      (QUESTMARK_ScreenMode),a

        ld      a,64                    ;start at "@" character on 1st line
        ld      b,20                    ;number of lines to print
        ld      c,0                     ;as B goes down C comes up
_Mode0CharlineLoop:
        push    bc                      ;save line counter
        push    af                      ;save start char

        ld      d,c
        ld      e,0
        call    SetCursorPos

        pop     af
        push    af

        ld      b,20                    ;number of chars on a line
_Mode0DoALine:
        push    bc                      ;store character count
        push    af                      ;save current character
        call    ScreenPrintChar         ;(SUPPORT) print it
        pop     af                      ;retrieve current character
        inc     a                       ;step char up as we do a line
        pop     bc                      ;retrieve char count
        djnz    _Mode0DoALine

        pop     af                      ;get starting character
        pop     bc                      ;get line counter
        inc     a                       ;next line starts with next char
        inc     c                       ;step row count on
        djnz    _Mode0CharLineLoop

;
; Now to print some color bars on lines 21, 22, 23 and 24 (the last 4 lines)
; As physical addresses for a line start are (0C000h + (row * 80)), I can tell
; you now that the address of the first char on line 21 is 0C690h.
;
; In MODE 0 the 16 color bars are just one character wide so, cos the screen is
; 20 chars wide we start the first at an indent of 2 characters. This means
; that the PEN 0 blob is written at 0C698h..0C69Bh. PEN 1 at 0C69Ch..0C69Fh,...
;                                   0CE98h..0CE9Bh           0CE9Ch..0CE9Fh
;                                   0D698h..0D69Bh           0D69Ch..0D69Fh
;                                     :       :                :       :
;                                   0FE98h..0FE9Bh           0FE9Ch..0FE9Fh
;then:
;                                   0C6E8h..0C6EBh....
;then:
;                                   0C738h..0C73Bh....
;and finally:
;                                   0C788h..0C78Bh....
;
; The byte for PEN 0 is 000h, PEN 1 is 0C0h, PEN 2 is 00Ch, PEN 3 is 0CCh
;              PEN 4 is 030h, PEN 5 is 0F0h, PEN 6 is 03Ch, PEN 7 is 0FCh
;              PEN 8 is 003h, PEN 9 is 0C3h, PEN A is 00Fh, PEN B is 0CFh
;              PEN C is 033h, PEN D is 0F3h, PEN E is 03Fh, PEN F is 0FFh
;
; These are the entries found in .Mode0MaskTable.
;
; The algorithm to POKE the correct values to show the color bars is:
;
; location=C698h
; FOR line=0 TO 3
;  FOR scan=0 TO 7
;   table_pointer = addr(table)
;   FOR blob=0 to 15
;    FOR byte=0 TO 3
;     POKE location,(table_pointer)
;     INC location
;    NEXT byte
;    INC table_pointer
;   NEXT blob
;   location=location + 800h (down a scan) - 64 (cos we've gone across that many)
;  NEXT scan
;  location=location + 80 (down a char line) + &c000 (cos it wraps over FFFF..0)
; NEXT line
;

        ld      hl,0C698h               ;the magic location
        ld      b,4                     ;FOR lines: 4 of 'em
_Mode0BarsLineloop:
        ld      c,8                     ;FOR scans: 8 on current 8*8
_Mode0BarsScanLoop:
        push    bc
        ld      de,.Mode0MaskTable      ;table_pointer = ADDR (table)
        ld      b,16                    ;FOR blobs: 16 to make a line
_Mode0BarsBlobLoop:
        ld      c,4                     ;FOR byte: 4 for each color blob
_Mode0BarsByteLoop:
        ld      a,(de)
        ld      (hl),a                  ;POKE location, (table pointer)
        inc     hl                      ;INC Location
        dec     c
        jr      nz,_Mode0BarsByteLoop   ;NEXT byte

        inc     de                      ;INC table pointer
        djnz    _Mode0BarsBlobLoop      ;NEXT blob

        ld      de,800h - 64
        add     hl,de                   ;location=location + 800h - 64
        pop     bc                      ;get two outer counters back
        dec     c
        jr      nz,_Mode0BarsScanLoop   ;NEXT scan

        ld      de,0C000h + 80
        add     hl,de                   ;wraps back down to next char line

        djnz    _Mode0BarsLineLoop      ;NEXT line

        ret

