;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Orions GX4000 control test)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  OrionControlsTest       ;called indirectly from TESTPACK
;                                        ; out of MainMenuTable
;
;
;        EXTERN  SetCursorPos
;        EXTERN  PrintStringHL
;        EXTERN  HighlightLine
;        EXTERN  KeyboardReadNoDelay
;        EXTERN  PrintAHex
;        EXTERN  UnlockArn5
;        EXTERN  RelockArn5
;
;        EXTERN  .OrionKeyDiag
;        EXTERN  .OrionKeyTable
;        EXTERN  .AnalogOKMess
;        EXTERN  .AnalogNGMess
;        EXTERN  .NotOKorNGMess
;
;
;        EXTERN  ?KeysHeldDownBuffer
;        EXTERN  ?PrintCharXORMask
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;=================
OrionControlsTest:
;=================
;
        ld      de,00200h
        call    SetCursorPos

        ld      hl,.OrionKeyDiag
        ld      b,1
        call    PrintStringHL

        ld      c,0Dh                   ;C=D means no key to highlight
        call    _OrionDrawKeys

        ld      d,2
        call    HighlightLine

        call    UnlockArn5

_OrionCntrlKeyRead:
        call    KeyboardReadNoDelay
        cp      66
        jp      z,_OCntrlEndTest
        ld      b,a                     ;save that key number
        ld      a,c                     ;get count of keys pressed
        cp      2
        ld      a,b                     ;get back the key number
        jr      nz,_ONoTwoKeys
;
; here with two keys pressed
;
        cp      73                      ;Joy 0 Down QUESTMARK_
        jr      nz,_OIsItJoy1Down
_ONowCheckP:
        ld      a,(QUESTMARK_KeysHeldDownBuffer+1)       ;get next key
        cp      27                      ;is it Pause QUESTMARK_
        jr      nz,_ONoTwoKeys
        jp      _OCntrlEndTest

_OIsItJoy1Down:
        cp      49
        jr      nz,_ONoTwoKeys
        jr      _ONowCheckP

_ONoTwoKeys:
        ld      c,0                     ;C holds number of item pressed
        cp      72
        jr      z,_OrionUpdateScreen    ;C=0 means Joy 0 Up
        inc     c
        cp      73
        jr      z,_OrionUpdateScreen    ;C=1 means Joy 0 Down
        inc     c
        cp      74
        jr      z,_OrionUpdateScreen    ;C=2 means Joy 0 Left
        inc     c
        cp      75
        jr      z,_OrionUpdateScreen    ;C=3 means Joy 0 Right
        inc     c
        cp      48
        jr      z,_OrionUpdateScreen    ;C=4 means Joy 1 Up
        inc     c
        cp      49
        jr      z,_OrionUpdateScreen    ;C=5 means Joy 1 Down
        inc     c
        cp      50
        jr      z,_OrionUpdateScreen    ;C=6 means Joy 1 Left
        inc     c
        cp      51
        jr      z,_OrionUpdateScreen    ;C=7 means Joy 1 Right
        inc     c
        cp      76
        jr      z,_OrionUpdateScreen    ;C=8 means Joy 0 Fire1
        inc     c
        cp      77
        jr      z,_OrionUpdateScreen    ;C=9 means Joy 0 Fire2
        inc     c
        cp      52
        jr      z,_OrionUpdateScreen    ;C=A means Joy 1 Fire1
        inc     c
        cp      53
        jr      z,_OrionUpdateScreen    ;C=B means Joy 1 Fire2
        inc     c
        cp      27
        jr      z,_OrionUpdateScreen    ;C=C means Pause
        inc     c                       ;C=D means no key recognised

_OrionUpdateScreen:
;
; get here with C identifying which key is pressed.
;
        push    bc
        call    _OrionDrawKeys          ;draw the keys and highlight C

        ld      de,00B06h               ;posn on screen of channel 0 value
        call    SetCursorPos
        ld      a,(6808h)               ;get analog channel 0
        call    PrintAHex

        ld      de,00C06h               ;posn on screen of channel 1 value
        call    SetCursorPos
        ld      a,(6809h)               ;get analog channel 1
        call    PrintAHex

        ld      de,00B22h               ;posn on screen of channel 2 value
        call    SetCursorPos
        ld      a,(680Ah)               ;get analog channel 2
        call    PrintAHex

        ld      de,00C22h               ;posn on screen of channel 3 value
        call    SetCursorPos
        ld      a,(680Bh)               ;get analog channel 3
        call    PrintAHex

        pop     bc
;
; At this point C=8,9,A,B means a fire button is being pressed. We will check
; the analog readings C=8 means 6808 <= 6 and 6809 <=6. If C=9 then we expect
; 6808 >= 36h and 6809 >=36h. C=A we expect 680A <=6 and 680B <=6. If C=B we
; expect 680A >=36h and 680B >= 36h.
;
        ld      a,c
        cp      8
        jr      nz,_OIsItJoy0Fire2
        ld      a,(6808h)
        ld      hl,.AnalogOKMess
        cp      7
        jr      c,_OJ0F1XIsOK
        ld      hl,.AnalogNGMess
_OJ0F1XIsOK:
        ld      a,(6809h)
        ld      bc,.AnalogOKMess
        cp      7
        jr      c,_OJ0F1YIsOk
        ld      bc,.AnalogNGMess
_OJ0F1YIsOK:
        push    bc
        ld      de,00B09h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        pop     hl
        ld      de,00C09h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        jp      _OrionCntrlKeyRead

_OIsItJoy0Fire2:
        cp      9
        jr      nz,_OIsItJoy1Fire1
        ld      a,(6808h)
        ld      hl,.AnalogOKMess
        cp      36h
        jr      nc,_OJ0F2XIsOK
        ld      hl,.AnalogNGMess
_OJ0F2XIsOK:
        ld      a,(6809h)
        ld      bc,.AnalogOKMess
        cp      36h
        jr      nc,_OJ0F2YIsOk
        ld      bc,.AnalogNGMess
_OJ0F2YIsOK:
        push    bc
        ld      de,00B09h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        pop     hl
        ld      de,00C09h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        jp      _OrionCntrlKeyRead

_OIsItJoy1Fire1:
        cp      0Ah
        jr      nz,_OIsItJoy1Fire2
        ld      a,(680Ah)
        ld      hl,.AnalogOKMess
        cp      7
        jr      c,_OJ1F1XIsOK
        ld      hl,.AnalogNGMess
_OJ1F1XIsOK:
        ld      a,(680Bh)
        ld      bc,.AnalogOKMess
        cp      7
        jr      c,_OJ1F1YIsOk
        ld      bc,.AnalogNGMess
_OJ1F1YIsOK:
        push    bc
        ld      de,00B25h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        pop     hl
        ld      de,00C25h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        jp      _OrionCntrlKeyRead

_OIsItJoy1Fire2:
        cp      0Bh
        jr      nz,_ONotAFireButton
        ld      a,(680Ah)
        ld      hl,.AnalogOKMess
        cp      36h
        jr      nc,_OJ1F2XIsOK
        ld      hl,.AnalogNGMess
_OJ1F2XIsOK:
        ld      a,(680Bh)
        ld      bc,.AnalogOKMess
        cp      36h
        jr      nc,_OJ1F2YIsOk
        ld      bc,.AnalogNGMess
_OJ1F2YIsOK:
        push    bc
        ld      de,00B25h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        pop     hl
        ld      de,00C25h
        call    SetCursorPos
        ld      b,1
        call    PrintStringHL
        jp      _OrionCntrlKeyRead

_ONotAFireButton:
        ld      de,00B09h               ;as no fire button is pressed we now
        call    SetCursorPos            ;blank the four positions that might
        ld      hl,.NotOKorNGMess       ;have OK or NG printed at them.
        ld      b,1
        call    PrintStringHL
        ld      de,00C09h
        call    SetCursorPos
        ld      hl,.NotOKorNGMess
        ld      b,1
        call    PrintStringHL
        ld      de,00B25h
        call    SetCursorPos
        ld      hl,.NotOKorNGMess
        ld      b,1
        call    PrintStringHL
        ld      de,00C25h
        call    SetCursorPos
        ld      hl,.NotOKorNGMess
        ld      b,1
        call    PrintStringHL
        jp      _OrionCntrlKeyRead



_OCntrlEndTest:
        call    RelockArn5

        xor     a                       ;clear carry cos no error
        ret


_OrionDrawKeys:
;
; Get here with C=key to highlight. But if C=D then no highlight
;
        ld      hl,.OrionKeyTable
        ld      b,13                    ;number of entries
_OrionDKLoop:
        push    bc
        ld      e,(hl)
        inc     hl
        ld      d,(hl)
        inc     hl
        push    hl
        call    SetCursorPos
        ld      a,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,a
        ld      a,13
        sub     b                       ;make 13..0 into 0..13
        cp      c                       ;is this the key to highlight QUESTMARK_
        ld      a,0
        jr      nz,_ODNoHighlight
        ld      a,0FFh
_ODNoHighlight:
        ld      (QUESTMARK_PrintCharXORMask),a
        ld      b,1
        call    PrintStringHL
        xor     a
        ld      (QUESTMARK_PrintCharXORMask),a
        pop     hl
        inc     hl
        inc     hl
        pop     bc
        djnz    _OrionDKLoop
        ret


