;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Orions Sound Test)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  OrionSoundTest          ;called indirectly from TESTPACK
;                                        ; out of MainMenuTable
;
;
;        EXTERN  PrintStringHL
;        EXTERN  SetCursorPos
;        EXTERN  ProgramNote
;        EXTERN  WriteAYChip
;        EXTERN  DelayASeconds
;        EXTERN  KeyboardReadNoDelay
;
;        EXTERN  .OrionKeyMess
;        EXTERN  .OrnSoundPlayingLeft
;        EXTERN  .OrnSoundPlayingRight
;        EXTERN  .OrnSoundPlayingBoth
;
;        include "equates.inc"
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;==============
OrionSoundTest:
;==============
;
        ld      de,00C00h
        call    SetCursorPos

        ld      hl,.OrionKeyMess
        ld      b,1
        call    PrintStringHL

        ld      de,00A00h
        call    SetCursorPos

        ld      hl,.OrnSoundPlayingLeft
        ld      b,1
        call    PrintStringHL

        ld      b,1
        ld      hl,CO1
        call    ProgramNote

        ld      e,3Eh                   ;channel A only
        ld      d,7                     ;the enables register
        call    WriteAYChip             ;start the left channel playing

        ld      a,1
        call    DelayASeconds

_OSKeyWaitLeft:
        call    KeyboardReadNoDelay
        cp      0FFh
        jr      z,_OSKeyWaitLeft

        ld      e,3Fh
        ld      d,7
        call    WriteAyChip             ;stop sound playing

        ld      de,00A00h
        call    SetCursorPos

        ld      hl,.OrnSoundPlayingRight
        ld      b,1
        call    PrintStringHL

        ld      b,4
        ld      hl,CO1
        call    ProgramNote

        ld      e,3Bh                   ;channel C only
        ld      d,7                     ;the enables register
        call    WriteAYChip             ;start the left channel playing

        ld      a,1
        call    DelayASeconds

_OSKeyWaitRight:
        call    KeyboardReadNoDelay
        cp      0FFh
        jr      z,_OSKeyWaitRight

        ld      e,3Fh
        ld      d,7
        call    WriteAyChip             ;stop sound playing

        ld      de,00A00h
        call    SetCursorPos

        ld      hl,.OrnSoundPlayingBoth
        ld      b,1
        call    PrintStringHL

        ld      b,2
        ld      hl,CO1
        call    ProgramNote

        ld      e,3Dh                   ;channel B only
        ld      d,7                     ;the enables register
        call    WriteAYChip             ;start the left channel playing

        ld      a,1
        call    DelayASeconds

_OSKeyWaitBoth:
        call    KeyboardReadNoDelay
        cp      0FFh
        jr      z,_OSKeyWaitBoth

        ld      e,3Fh
        ld      d,7
        call    WriteAyChip             ;stop sound playing

        xor     a                       ;clear carry cos no error
        ret

