;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Printer Test)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  PrinterTest             ;called indirectly from TESTPACK
;                                        ; out of MainMenuTable
;
;        EXTERN  SetCursorPos            ;SUPPORT
;        EXTERN  PrintStringHL           ;SUPPORT
;        EXTERN  KeyboardRead            ;SUPPORT
;        EXTERN  PrinterPrintChar        ;SUPPORT
;        EXTERN  .PrinterOFFMess         ;MESSAGES
;        EXTERN  .PrinterONMess          ;MESSAGES
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;===========
PrinterTest:
;===========
;
; This test (a la Spectrum) will just ask the user to switch the printer
; "OFF line" and press a key. A test is then made that the BUSY signal in
; 8255 port B bit 6 is high. The user will be asked to switch the printer
; is "ON line". A check is made to see that the busy bit has gone away.
;
; The test then goes on to print characters 32..127 and 160..255 on the
; printer 5 times.
;
        exx
        set     0,l                     ;assume a printer exists ! (see
                                        ;description of PrinterPrintChar)
        exx

        ld      de,00200h
        call    SetCursorPos

        ld      hl,.PrinterOFFMess
        ld      b,1                     ;screen only
        call    PrintStringHL           ;ask user to switch off and press key

_PrinterWaitOFF:
        call    KeyboardRead            ;wait for key
        cp      0FFh
        jr      z,_PrinterWaitOff

        cp      66
        jp      z,_PrinterEndTest
        cp      76
        jp      z,_PrinterEndTest
        cp      77
        jp      z,_PrinterEndTest
        cp      52
        jp      z,_PrinterEndTest
        cp      53
        jp      z,_PrinterEndTest

        ld      bc,4000h
_PrinterDebounce0:
        dec     bc
        ld      a,b
        or      c
        jr      nz,_PrinterDebounce0

        ld      bc,0F500h               ;8255 port B has BUSY it
        in      a,(c)
        bit     6,a                     ;test BUSY (expect high)
        jr      nz,_PrinterIsOFF
;
; Z is set means stuck low.
;
        ld      b,0
        ld      a,6                     ;ERROR 6 is Printer BUSY error
        scf
        ret

_PrinterIsOFF:
        ld      hl,.PrinterONMess
        ld      b,1                     ;screen only
        call    PrintStringHL           ;ask user to switch on and press key

_PrinterWaitON:
        call    KeyboardRead            ;wait for key
        cp      0FFh
        jr      z,_PrinterWaitON

        cp      66
        jp      z,_PrinterEndTest
        cp      76
        jr      z,_PrinterEndTest
        cp      77
        jp      z,_PrinterEndTest
        cp      52
        jp      z,_PrinterEndTest
        cp      53
        jp      z,_PrinterEndTest

        ld      bc,4000h
_PrinterDebounce1:
        dec     bc
        ld      a,b
        or      c
        jr      nz,_PrinterDebounce1

        ld      bc,0F500h               ;8255 port B has BUSY it
        in      a,(c)
        bit     6,a                     ;test BUSY (expect high)
        jr      z,_PrinterIsON
;
; NZ is set means stuck high.
;
        ld      a,6                     ;ERROR 6 is Printer BUSY error
        ld      b,1
        scf
        ret

_PrinterIsON:
;
; Now print chars 32..127 and 160..255 about 5 times:
;
        ld      b,5
_PrinterTextLoop:
        push    bc

        ld      a,32                    ;start at 32
        ld      b,95                    ;do 95 chars (up to 127)
_PrinterCharLoop1:
        push    af
        push    bc
        call    PrinterPrintChar
        pop     bc
        pop     af
        inc     a
        djnz    _PrinterCharLoop1

        ld      a,160                   ;start at 160
        ld      b,95                    ;do 95 chars (up to 255)
_PrinterCharLoop2:
        push    af
        push    bc
        call    PrinterPrintChar
        pop     bc
        pop     af
        inc     a
        djnz    _PrinterCharLoop2

        pop     bc
        djnz    _PrinterTextLoop

_PrinterEndTest:
        xor     a
        ret

