;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Simple test of the Z80 processor)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  ProcessorTest           ;called from TESTPACK
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;=============
ProcessorTest:
;=============
;
; This routine (lifted from the original test pack source) just performs
; a few well known Z80 ops and passes a known value around the registers
;
; The routine sets carry if a fault is found else it RETs NC
;
        xor     a                       ;this should give Z and NC Sign=0
        jp      nz,_ProcessFail         ;but we find NZ
        jp      c,_ProcessFail          ;but we find C
        jp      m,_ProcessFail          ;but we find M (i.e. Minus - Sign=1)

        daa                             ;Z should stay set
        jp      nz,_ProcessFail

        scf                             ;set carry = 1 (C)
        sbc     a,a                     ;take a from a with borrow should give
                                        ;a=FF, NZ, C, M (i.e. not Positive)

        jp      z,_ProcessFail          ;but we find Z
        jp      nc,_ProcessFail         ;but we find NC
        jp      p,_ProcessFail          ;but we find P (positive)

        daa                             ;makes A=99
        sub     099h                    ;gives A=0 and Z
        jp      nz,_ProcessFail         ;but we find NZ

        ld      a,05Ah                  ;an "interesting" test pattern
        ld      b,a                     ;pass it around the registers
        ld      c,b
        ld      d,c
        ld      e,d
        ld      h,e
        ld      l,h
        ex      af,af'                  ;so we now have access to A'
        ld      a,l                     ;put the 05Ah value into A'
        exx                             ;switch to alternates
                                        ;(but can't test/corrupt BC')
        ld      d,a                     ;D'=A'
        ld      e,d
        ld      h,e
        ld      l,h
        ex      af,af'                  ;access to A again
        ld      a,0A6h                  ;2's complement of pattern in A
        add     A,l                       ;add L' which should still be 05Ah
        exx                             ;back to normal reg. set
        jp      nz,_ProcessFail         ;the add should have been 05A+0A6=000

        ld      ix,05A5Ah               ;an "interesting" value
        ld      de,0A5A5h               ;and its complement
        add     ix,de                   ;gives 0FFFFh and NC
        jp      c,_ProcessFail
        ld      de,1                    ;gonna add 1 to wrap to 0
        add     ix,de                   ;do the sums to give 0 and C
        jp      nc,_ProcessFail         ;if carry wasn't set there's a problem

        ld      iy,05A5Ah               ;an "interesting" value
        ld      bc,0A5A5h               ;and its complement
        add     iy,bc                   ;gives 0FFFFh and NC
        jp      c,_ProcessFail
        ld      bc,1                    ;gonna add 1 to wrap to 0
        add     iy,bc                   ;do the sums to give 0 and C
        jp      nc,_ProcessFail         ;if carry wasn't set there's a problem

        xor     a                       ;clear carry (all is well)
        ret

_ProcessFail:
        ld      a,1                     ;Processor test error code
        scf                             ;Carry set means a fault was found
        ret
