;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Test of DMA elctronics that feed the sound chip)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  DMASoundTest    ;called indirectly from TESTPACK
;                                ; out of MainMenuTable
;
;        EXTERN  UnlockArn5              ;SUPPORT
;        EXTERN  RelockArn5              ;SUPPORT
;        EXTERN  SetCursorPos            ;SUPPORT
;        EXTERN  PrintStringHL           ;SUPPORT
;        EXTERN  KeyboardRead            ;SUPPORT
;        EXTERN  KeyboardTest            ;KEYBOARD
;        EXTERN  WriteAYChip             ;SUPPORT
;        EXTERN  DelayASeconds           ;SUPPORT
;
;
;        EXTERN  .SoundInstructions      ;MESSAGES
;        EXTERN  .Channel0DMAData        ;MESSAGES
;        EXTERN  .Channel1DMAData        ;MESSAGES
;        EXTERN  .Channel2DMAData        ;MESSAGES
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;============
DMASoundTest:
;============
;
; This will attempt to test the DMA sound feature by playing a multi-voice
; tune. I'm not going to ty and test every possibility of every feature cos
; it would take too long but if I can play a tune then I guess the best part
; of it must be working.
;
; The way the sound DMA works (simplest) is as follows:
;
; 1) program 6C00/1 with address of channel 0 "program"
; 2) program 6C04/5 with address of channel 1 "program"
; 3) program 6C08/9 with address of channel 2 "program"
; 4) set the enable bits in 6C0F to on - the data starts to pump !
;
; Once we have got a tune in motion we want to make sure that there is no
; interaction with the keyboard reading via the 8255/AY-3-8912 combination so
; we just call the normal keyboard test routine while the tune continues to
; play. When the user exits from the keyboard test control returns back to
; here where we finally stop the tune and end.
;
; So that there isn't a possibility of the tune running out while in the key
; test it will be made up of a reasonable lengthed sequence of notes within
; a repeat loop that is set to the maximum (4095) number of interations.
;
        ld      de,00200h
        call    SetCursorPos

        ld      bc,7f81h
        out     (c),c                           ;both ROMs on
        ld      bc,0df01h
        out     (C),c                           ;ROM 1 to C000h

;        ld      hl,ASICBLOCK_Channel0DMAData
        ld      hl,.Channel0DMAData
        ld      de,0A000h                       ;a free bit of RAM
        ld      bc,01FFFh                       ;make sure we get all to RAM
        ldir

        call    UnlockArn5

        ld      hl,.SoundInstructions
        ld      b,1
        call    PrintStringHL                   ;tell user wots appenin

        ld      b,100
_SoundDWaitKey:
        push    bc
        call    KeyboardRead
        pop     bc
        cp      0FFh
        jr      nz,_SoundDStartTest
        djnz    _SoundDWaitKey

_SoundDStartTest:
        ld      hl,0A000h                      ;we know this ones fixed
        ld      (6C00h),hl
        ld      hl,.Channel1DMAData - .Channel0DMAData + 0A000h
        ld      (6C04h),hl
        ld      hl,.Channel2DMAData - .Channel0DMAData + 0A000h
        ld      (6C08h),hl                      ;init the DMA pointers

        ld      a,060h                          ;256 scan lines
        ld      (6C02h),a                       ;channel 0 pause prescaler
        ld      (6C06h),a                       ;channel 0 pause prescaler
        ld      (6C0Ah),a                       ;channel 0 pause prescaler

        ld      a,7                             ;set all three channels playing
        ld      (6C0Fh),a                       ;kick the tune off.

        ld      a,37h                           ;magic flag value means we are
                                                ;passing a timeout value in HL

        ld      hl,8000h                        ;a humungous delay !
        call    KeyboardTest                    ;go do normal keyboard test

        ld      a,0
        ld      (6C0Fh),a                       ;stop the tune

        ld      d,7
        ld      e,03Fh
        call    WriteAyChip                     ;cancel any sound

        call    RelockArn5

        ret

;
; Is it really this easy I wonder !
;
