;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Casette Test that shows frequency analysis of data read)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  DatacorderTest          ;called indirectly from TESTPACK
;                                        ; out of MainMenuTable
;
;        EXTERN  ScreenSetMOde           ;in SUPPORT
;        EXTERN  PrintStringHL           ;in SUPPORT
;        EXTERN  KeyboardReadNoDelay     ;in SUPPORT
;        EXTERN  ScreenPrintChar         ;in SUPPORT
;        EXTERN  SetCursorPos            ;in SUPPORT
;        EXTERN  PrintAHex               ;in SUPPORT
;
;        EXTERN  .TapeSampleMess         ;in MESSAGES
;        EXTERN  .TapeTestMess           ;in MESSAGES
;
;        EXTERN  ?TapeSamples            ;in TESTVARS
;        EXTERN  ?TapeBlobPosition       ;in TESTVARS
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

;==============
DatacorderTest:
;==============
;
; This is a straight rob of the routine in the Spectrum +3 test code.
;
; The cassette read data bit is bit 7 in port 0F5xxh
;
; The way it works is as follows:
;
; 1) Draw the static legend for a horizontal bar graph
; loop
;  2) if key pressed then end
;  3) count = 0
;  4) for i=1 to 1000h
;      if tape bit flips then inc count
;     next i
; ;now count holds the number of times the bit flipped in the length of time
; it takes to count to 1000
;  5) clear the current horizontal bar
;  6) draw a bar whose length is proportional to count. (count / 32 say)
; end loop
;
; So the length of the bar shows the number of transisiotns in the sample
; period. The theory is the more the merrier !
;
        ld      hl,1600h                ;default sample count
        ld      (QUESTMARK_TapeSamples),hl

        ld      a,2
        call    ScreenSetMode

        ld      de,0200h
        call    SetCursorPos            ;row 2 column 0

        ld      hl,.TapeTestMess
        ld      b,1
        call    PrintStringHL           ;say wots appenin and draw static legend

        ld      de,00C00h
        call    SetCursorPos

        ld      hl,.TapeSampleMess
        ld      b,1
        call    PrintStringHL

        ld      de,00800h               ;starting position for blob
        ld      (QUESTMARK_TapeBlobPosition),de

        ld      bc,0F600h
        in      a,(c)                   ;get current Port C
        set     4,a                     ;switch motor bit on
        out     (c),a

_TapeTestLoop:
        ld      hl,0                    ;reset count of transitions
        ld      c,0

        ld      b,0F5h                  ;the tape port address
        ld      de,(QUESTMARK_TapeSamples)       ;counter for FOR NEXT
_TapeSampleLoop:
        dec     de
        ld      a,d
        or      e
        jr      z,_TapeGotSample

        in      a,(c)                   ;read tape bits and bobs
        and     080h                    ;check top bit
        cp      c
        jr      z,_TapeSampleLoop
        inc     hl                      ;count of transitions
        ld      c,a                     ;remember current state
        jr      _TapeSampleLoop

_TapeGotSample:
;
; now HL has count of number of transitions while we counted down from 1000h
; we want to scale this value that could be as much as 100h (say) into the
; width of the screen (80 bytes). Dividing by 4 should do the trick.
;
        srl     h                       ;one left and bit 0 to carry
        rr      l                       ;one left, carry to bit 7 (and bit 0 to carry)
;        srl     h
;        rr      l                       ;now have hl=hl/4
        ld      a,l
        sub     32
        jr      nc,_TapeLStillPositive
        ld      a,0
_TapeLStillPositive:
        ld      l,a

        ld      a,79
        cp      l                       ;check l is 0..79
        jr      nc,_TapeLInRange
        ld      l,79                    ;force it into range

_TapeLInRange:
;
; Now going to clear current blob
;
        push    hl
        ld      de,(QUESTMARK_TapeBlobPosition)
        call    SetCursorPos
        ld      a,' '
        call    ScreenPrintChar
        pop     hl
;
; Now want to display a blob whose horizontal pos is given by L
;
        ld      de,(QUESTMARK_TapeBlobPosition)
        ld      e,l                     ;set the new column posn.
        ld      (QUESTMARK_TapeBlobPosition),de  ;update variable
        call    SetCursorPos

        ld      a,127                   ;a checker board character
        call    ScreenPrintChar

        ld      de,00C0Eh
        call    SetCursorPos            ;gonna print current sample rate

        ld      hl,(QUESTMARK_TapeSamples)
        ld      a,h
        push    hl
        call    PrintAHex
        pop     hl
        ld      a,l
        call    PrintAHex

        call    KeyboardReadNoDelay
        cp      0FFh
        jr      z,_TapeNoKeyPressed
        cp      66                      ;ESC key
        jr      z,_TapeEndTest
        cp      76                      ;joystick fire
        jr      z,_TapeEndTest
        cp      0                       ;up key
        jr      z,_TapeIncreaseSample
        cp      72                      ;jopystick up
        jr      z,_TapeIncreaseSample
        cp      2                       ;down key
        jr      z,_TapeDecreaseSample
        cp      73                      ;joystick down
        jr      z,_TapeDecreaseSample


_TapeNoKeyPressed:
        ld      bc,0F600h
        in      a,(c)                   ;get current Port C
        set     4,a                     ;switch motor bit on
        out     (c),a
        jp      _TapeTestLoop           ;then do some more !

_TapeIncreaseSample:
        ld      hl,(QUESTMARK_TapeSamples)
        inc     h
        ld      (QUESTMARK_TapeSamples),hl
        jr      _TapeNoKeyPressed

_TapeDecreaseSample:
        ld      hl,(QUESTMARK_TapeSamples)
        dec     h
        ld      (QUESTMARK_TapeSamples),hl
        jr      _TapeNoKeyPressed


_TapeEndTest:
        ld      bc,0F600h
        in      a,(c)                   ;get current Port C
        res     4,a                     ;switch motor bit off
        out     (c),a

        xor     a                       ;clear carry
        ret

