	.LOCALLABELCHAR "."

	.ORG	0

;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Main file which sets segments and includes main test routine)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131


; This file should be the first one linked as it contains the RSTs that go
; at the start of the ROM.


#define	LoadAY(reg,data)	.DB (data),(reg)&0fh
#define Pause(delay)		.DW (delay)|01000h
#define	Repeat(count)		.DW (count)|02000h
#define	AYNop			.DW 4000h
#define	Loop			.DW 4001h
#define	AYInt			.DW 4010h
#define	AYStop			.DW 4020h


#define	AYPlayChanA(note,volume,delay,enables)	.DW	0000h|((note)&0ffh)
#defcont		\			.DW	0100h|((note)>>8)
#defcont		\			.DW	0800h|(volume)
#defcont		\			.DW	0700h|(enables)
#defcont		\			.DW	1000h|((delay*9)/10)
#defcont		\			.DW	073fh
#defcont		\			.DW	1000h|((delay)/10)

#define	AYPlayChanB(note,volume,delay)		.DW	0200h|((note)&0ffh)
#defcont		\	.DW	0300h|((note)>>8)
#defcont		\	.DW	0900h|(volume)
#defcont		\	.DW	4000h
#defcont		\	.DW	1000h|((delay*9)/10)
#defcont		\	.DW	4000h
#defcont		\	.DW	1000h|((delay)/10)

#define	AYPlayChanC(note,volume,delay)		.DB	0400h|((note)&0ffh)
#defcont		\	.DW	0500h|((note)>>8)
#defcont		\	.DW	0a00h|(volume)
#defcont		\	.DW	4000h
#defcont		\	.DW	1000h|((delay*9)/10)
#defcont		\	.DW	4000h
#defcont		\	.DW	1000h|((delay)/10)

#define	AYNoPlay(delay)				AYNop
#defcont		\	AYNop
#defcont		\	AYNop
#defcont		\	AYNop
#defcont		\	Pause((delay))
#defcont		\	AYNop



PowerUpEntry:
        jp      _TestStart

		.ORG	030H

		JP		utility_handler

		.ORG	038H

        jp      Im1Interrupt            ;when in IM1 interrupts come here and
                                        ;are then passed to the timer
                                        ;interrupt test code.

        .TEXT    "Arnold 5 Test ROM by C J Lawson, (C) Amstrad plc 1990"

.ROMDateAndTime
        .TEXT    "Date=00-00-1900 "      ;these entries will be filled in by my
        .TEXT    "Time=00:00:00$"        ;DATEROM utility that reads the system
                                        ;date/time and puts it into the .HEX
                                        ;file at this fixed point.



UTID_SCREENMODE		=	0
UTID_PRINTSTRING	=	1
UTID_SETCURSOR		=	2
#define	UTIL_ScreenSetMode(x)	.DB 0f7H,UTID_SCREENMODE,(x)
#define	UTIL_PrintString(x,y)	.DB 0f7H,UTID_PRINTSTRING,(x) \ .DW (y)
#define	UTIL_SetCursorPos(x)	.DB 0f7H,UTID_SETCURSOR \ .DW (x)

utility_handler:
		push	iy
		push	af
		ld		iy,0
		add		iy,sp
		push	de
		push	bc
		push	ix
		push	hl

		ld		e,(iy+4)
		ld		d,(iy+5)

		push	de
		pop		ix

		push	iy
		ld		a,(ix+0)
		inc		ix

		cp		UTID_SCREENMODE
		jp		nz,.notscmode

		ld		a,(ix+0)
		inc		ix
		push	ix		
		call	ScreenSetMode
		pop		ix
		jp		.util_done

.notscmode:
		cp		UTID_PRINTSTRING
		jp		nz,.notpstring

		ld		b,(ix+0)
		ld		l,(ix+1)
		ld		h,(ix+2)
		inc		ix
		inc		ix
		inc		ix
		push	ix		
		call	PrintStringHL
		pop		ix
		jp		.util_done

.notpstring:
		cp		UTID_SETCURSOR
		jp		nz,.notscurs

		ld		e,(ix+0)
		ld		d,(ix+1)
		inc		ix
		inc		ix
		push	ix		
		call	SetCursorPos
		pop		ix
		jp		.util_done

.notscurs:



		
.util_done:
		pop		iy
		push	ix
		pop		hl
		ld		(iy+4),l
		ld		(iy+5),h

		pop		hl
		pop		ix
		pop		bc
		pop		de
		pop		af
		pop		iy
		ret



keyboardtest:
	push	hl
	push	bc
.lp:	ld	b,0
.lp2:	djnz	.lp2
	dec	hl
	ld	a,h
	or	l
	jr	nz,.lp
	pop	bc
	pop	hl
	ret

        #include "equates.inc"
        #include "inttest.S"
	       #include "support.S"
        #include "PROCESSR.S"
        #include "MENU.S"
        #include "COUNTER.S"
        #include "DEFAULTS.S"
        #include "FLYBACK.S"
        #include "ERROR.S"
        #include "RAMTEST.S"
        #include "SOUND.S"
        #include "SOUNDDMA.S"
;        #include "FLOPCMND.S"
;        #include "FLOPMESS.S"
;        #include "FLOPPY.S"
        #include "RASTER.S"
        #include "ANALOGUE.S"
        #include "FSETBASE.S"
        #include "MODES.S"
        #include "ORION.S"
        #include "ORNCNTRL.S"
        #include "ORNSOUND.S"
        #include "PALET496.S"
        #include "PALET27.S"
        #include "PRINTER.S"
        #include "SPLIT.S"
        #include "SPRITES.S"
        #include "SPRITPAL.S"
        #include "SSCROLL.S"
        #include "TAPE.S"
;        #include "UPROMLNK.S"

        #include "MESSAGES.S"







;RAMLessCall     %MACRO  TargetRoutine
;                %GENSYM ReturnLabel
;                ld      sp,ReturnLabel
;                jp      TargetRoutine
;ReturnLabel     defw    ReturnLabel + 2
;                %ENDM


#define	RAMLessCall(xx)		ld sp,$+6
#defcont		\	jp	xx
#defcont		\	.DW	$+2

;RAMLessCall     %MACRO  TargetRoutine
;                %GENSYM ReturnLabel
;                ld      sp,ReturnLabel
;                jp      TargetRoutine
;~ReturnLabel    .dw     $ReturnLabel + 2
;                %ENDM




;        DEFSEG  TestCode, CLASS=CODE, START=0       ;ensure power up entry is positioned
;
;        SEG     TestCode

_TestStart:
;
; The idea here is to set the various I/O devices into "safe" conditions and get
; the machine to a point where, if during the following tests and error occurs,
; it is woken up enuff to at least have a stab at printing it to the Centronics
; port and perhaps even printing it on the screen.
;
        di                              ;interrupts will only ever be enabled
                                        ;during the INTTEST and also after the
                                        ;switch to IM2 when testing the various
                                        ;vectored interrupt mechanisms.

        im      1                       ;for the time being the machine is put
                                        ;into interrupt mode 1 so that when
                                        ;interrupts are first enabled they
                                        ;will vector via RST 038h

        exx                             ;switch to alternate register set cos
                                        ;B' will always hold 07Fh (the I/O
                                        ;addr of the ULA) and C' will hold the
                                        ;last value that set the mode and rom
                                        ;bits.

        ld      b,07Fh                  ;I/O addr of the ULA
        ld      c,0C0h
        out     (c),c                   ;make sure default RAM page selected

        ld      c,089h                  ;this magic value has the top 3 bits
                                        ;=100 (i.e. set ROM+MODE). The clear
                                        ;52 divider bit is 0, the
                                        ;lower ROM will be enabled and the
                                        ;screen mode is set to 1 (40x25).
        out     (c),c                   ;set that state into the hardware.

        exx                             ;back to the "normal" register set

        RAMLessCall(ProcessorTest)       ;(in PROCESSR)
        jp      c,_ProcessorFail        ;if processor failed then warn

        exx                             ;reset alternate registers
        ld      bc,07F89h               ;C' has mode bits etc.
        ld      l,1                     ;L':0 set means we can print
        exx

        ld      bc,0DF00h               ;DFxx=ROM switching port
        out     (c),c                   ;select ROM 0 as upper ROM

        ld      bc,0F782h               ;F7xx=8255 control register
        out     (c),c                   ;set port A=out, B=In and C=Out

        ld      bc,0F600h
        out     (c),c                   ;make sure BDIR/BC1=0 and cassette off

        ld      a,0
        ld      bc,0FA7Eh
        out     (c),a                   ;switch off disk motors

;
; it is not necessary to set the AY port A (keyboard columns) to input as
; this is the default state when the AY chip is reset.
;

        ld      bc,0EF7Fh               ;EFxx=Centronics latch
        out     (c),c                   ;set all bits high except not-STROBE

        ld      hl,8000h                ;RAM variable area
        ld      de,8001h
        ld      bc,1000h
        ld      (hl),0AAh
        ldir                            ;fill RAM variable area with AA test

        ld      hl,8000h
        ld      bc,1000h
_RAMVarTestLoop1:
        ld      a,0AAh
        cpi
        jp      nz,_RAMVarFail
        ld      a,b
        or      c
        jr      nz,_RAMVarTestLoop1

        ld      hl,8000h                ;RAM variable area
        ld      de,8001h
        ld      bc,1000h
        ld      (hl),055h
        ldir                            ;fill RAM variable area with 55 test

        ld      hl,8000h
        ld      bc,1000h
_RAMVarTestLoop2:
        ld      a,055h
        cpi
        jp      nz,_RAMVarFail
        ld      a,b
        or      c
        jr      nz,_RAMVarTestLoop2
        jr      _RAMVarPass

_RAMVarPass:
;        ld      hl,8000h
;        ld      de,8001h
;        ld      bc,0FFFh                ;that's all memory from 8000 to 9000
;        ld      (hl),0
;        ldir                            ;clear all vars to 0 (Floppy stuff
                                        ;needs this !)

        ld      bc,7f81h
        out     (c),c           ;switch on both ROMS
        ld      bc,0df82h
        out     (c),c           ;select ROM 1 as the upper ROM

        ld      hl,0C000h
        ld      de,08000h
        ld      bc,03fffh
        ldir                    ;copy code out of ROM into RAM

        ld      bc,0df00h
        out     (c),c           ;select ROM 1 as the upper ROM

		exx
        out     (c),c
		exx

        ld      sp,QUESTMARK_RAMstack            ;(in TESTVARS)

        call    ScreenResetPalette      ;set a known collection of colors

		UTIL_ScreenSetMode(1)

        exx
        ld      l,1                     ;assume printer is there
        exx

		UTIL_PrintString(2,.CrLfMess)	 		; get printer ready for message
		UTIL_PrintString(2,.InitProcMessPt1)	; "Arnold 5 diagnostics Version x.y" to printer

		UTIL_PrintString(3,.CrLfMess)			; both screen and printer
		UTIL_PrintString(3,.CrLfMess)
		UTIL_PrintString(3,.ROMDateAndTime)		; print Rom Date and time

        ld      bc,07F81h               ;mode 1 and both ROMs on
        out     (c),c

        ld      de,0                    ;the 16 bit sum
        ld      hl,0                    ;the pointer
        ld      bc,4000h                ;count of bytes in lower ROM
_TestCheckSum1:
        ld      a,(hl)                  ;get byte from ROM
        add     A,e                       ;add lower half of DE
        ld      e,a                     ;and save result
        ld      a,0
        adc     A,d                       ;add any carry into d
        ld      d,a                     ;and save that result
        inc     hl                      ;step on memory pointer
        dec     bc                      ;and reduce counter
        ld      a,b
        or      c
        jr      nz,_TestCheckSum1
;
; DE has result for lower ROM at this point
;
        ld      hl,0C000h               ;now point at upper ROM
        ld      bc,4000h                ;which is also 16K long
_TestCheckSum2:
        ld      a,(hl)                  ;get byte from ROM
        add     A,e                       ;add lower half of DE
        ld      e,a                     ;and save result
        ld      a,0
        adc     A,d                       ;add any carry into d
        ld      d,a                     ;and save that result
        inc     hl                      ;step on memory pointer
        dec     bc                      ;and reduce counter
        ld      a,b
        or      c
        jr      nz,_TestCheckSum2

        exx
        out     (c),c                   ;set mode bits back to normal
        exx

        push    de                      ;save checksum
		UTIL_PrintString(3,.CheckSumMess)
        pop     de
        push    de
        ld      a,d
        call    PrintAHex               ;print hi byte on screen
        pop     de
        push    de
        ld      a,d
        call    LprintAHex              ;and printer
        pop     de
        push    de
        ld      a,e
        call    PrintAHex               ;print low byte on screen
        pop     de
        ld      a,e
        call    LprintAHex              ;and printer

		UTIL_PrintString(2,.CrLfMess)	;move printer down a line

_TestWaitNoKey:
        call    KeyboardRead            ;if space held down then wait
        cp      47
        jr      z,_TestWaitNoKey

;
; Once the initialisation has been performed we arrive at this entry point.
; The main loop is entered to allow other tests to be chosen from a menu.
;
_TestMainCode:
		UTIL_SetCursorPos(00806h)		;(8,6)

        exx
        ld      l,1                     ;wind printer up after L' corrupted
        exx

		UTIL_PrintString(2,.CrLfMess)			; Printer only
		UTIL_PrintString(3,.InitProcMessPt2)	; "Processor test PASSED" to screen and printer
		UTIL_PrintString(2,.CrLfMess)			; Only CR LF on printer

        call    UnLockArn5              ;rets C if it couldn't - assume Arn 1-4
        jr      c,_TestGotArnold1234
        call    ReLockArn5              ;assume this will work (NC)
        jr      c,_TestArn5Error
        ld      a,5                     ;Arnold type
        jr      _TestSetArnoldType

_TestArn5Error:
		UTIL_PrintString(3,.Arn5ErrMess)	;warn user that we couldn' disable Arn5
        jp      _TheVeryEND             ;and die


_TestGotArnold1234:
        ld      a,4                     ;means 1..4

_TestSetArnoldType:
        ld      (QUESTMARK_ArnoldType),a

        ld      a,1
        call    DelayASeconds           ;long enough to read the messages


        ld      hl,QUESTMARK_TestLoopLimit       ;(in TESTVARS)
        ld      (hl),1                  ;set loop counter to 1

_TestMainLoop:
        ld      a,0                     ;do all menu including re-draw
_TestProcessMenu:
        ld      hl,.MainMenuTable       ;(in MESSAGES)
        call    ProcessAMenu            ;(in MENU)
        ld      (QUESTMARK_TestLastHighlight),a
        jr      nc,_TestMenuSelected    ;if carry set then menu timed out
        call    DefaultTests            ;so run default tests
        jr      _TestMainLoop           ;then start again

_TestMenuSelected:
;
; This returns with the address of the routine to call in HL. If the top bit
; of H is set then it is either increment or decrement loop counter so we
; definitely don't want to do it "TestLoopCounter" times or clear the screen.
;
; If the bit 6 in H is set then it is the address of a routine that sets its
; own screen mode so there is no point in clearing the screen here.
;
; This returns with A holding the currently highlighted line which can be stored
; and passed into ProcessAMenu next time in B with A=2 (which means reuse old
; highlight value).
;
        bit     7,h
        jr      z,_TestLoopy
        res     7,h                     ;make a sensible address
        call    _TestIndirectCallHL     ;run the inc/dec loop
        ld      a,1                     ;parm to ProcessAMenu means no re-draw
        jr      _TestProcessMenu

_TestLoopy:
        ld      a,(QUESTMARK_TestLoopLimit)      ;get current setting of limit
        ld      (QUESTMARK_TestLoopCounter),a    ;initialise counter before tests
_TestCounterLoop:
        bit     6,h                     ;if 6 set then no CLS
        jr      nz,_TestNoTouchScreen

        push    hl                      ;save routine addr in case we loop
        ld      a,(QUESTMARK_TestLoopCounter)
        ld      l,a
        ld      a,(QUESTMARK_TestLoopLimit)      ;only want CLS if 1st loop
        cp      l
        jr      nz,_TestNoClearScreen
        ld      a,1
        call    ScreenSetMode           ;all routines start on blank MODE 1
        call    PrintLoopLimit          ;with loop limit at bottom left
_TestNoClearScreen:
        call    PrintLoopCount          ;and loop count at bottom right
        ld      de,00200h               ;tests may start to print at (0,2)
        call    SetCursorPos
        pop     hl

_TestNoTouchScreen:
        res     6,h                     ;clear possible flag bit (no harm)
        push    hl
        call    _TestIndirectCallHL     ;go do the selected test routine
;
; routines return with C set if there was an error and A contains error code
;
        jp      c,ErrorHandler
        pop     hl                      ;retrieve that address
        ld      a,(QUESTMARK_TestLoopCounter)
        dec     a
        ld      (QUESTMARK_TestLoopCounter),a
        jr      nz,_TestCounterLoop
        ld      a,(QUESTMARK_TestLastHighlight)
        ld      b,a
        ld      a,2                     ;parm for ProcessAMenu to re-use old
                                        ;highlight

        jp      _TestProcessMenu        ;This is the top command loop !

_TestIndirectCallHL:
;
; The worlds fave routine...
;
        jp      (hl)


_ProcessorFail:
;
; Serious shit man ! We'll have a crack at printing an error message but what
; hope is there really QUESTMARK_
;
        exx
        ld      l,1                     ;enable printer
        exx

        ld      a,'C'
        RAMLessCall(PrinterPrintChar)

        ld      a,'P'
        RAMLessCall(PrinterPrintChar)

        ld      a,'U'
        RAMLessCall(PrinterPrintChar)

        jr      _SeriousFailure


_RAMVarFail:
;
; If the unthinkable should happen and the 8000h..9000h block of RAM can't
; even hold AA or 55 then we are in dead shtuck. The best I can hope to do
; without using any RAM is to print a fail message on the printer using
; RAMLessCALLs to PrinterPrintChar. I can't even use PrintStringHL so each
; character must be sent individually.
;
        exx
        ld      l,1                     ;enable printer
        exx

        ld      a,'R'
        RAMLessCall(PrinterPrintChar)

        ld      a,'A'
        RAMLessCall(PrinterPrintChar)

        ld      a,'M'
        RAMLessCall(PrinterPrintChar)


_SeriousFailure:
        ld      a,' '
        RAMLessCall(PrinterPrintChar)

        ld      a,'E'
        RAMLessCall(PrinterPrintChar)

        ld      a,'R'
        RAMLessCall(PrinterPrintChar)

        ld      a,'R'
        RAMLessCall(PrinterPrintChar)

        ld      a,'O'
        RAMLessCall(PrinterPrintChar)

        ld      a,'R'
        RAMLessCall(PrinterPrintChar)

        ld      a,'!'
        RAMLessCall(PrinterPrintChar)

        ld      a,0Dh
        RAMLessCall(PrinterPrintChar)

        ld      a,0Ah
        RAMLessCall(PrinterPrintChar)


_TheVeryEND:
        jr      _TheVeryEND             ;If things are that bad what else can
                                        ;we do QUESTMARK_
	
.MatrixDefinitions
;
; definitions of characters 32..127 stolen from Arnolds ROM
;
        .DB    000h,000h,000h,000h,000h,000h,000h,000h ;<space>
        .DB    018h,018h,018h,018h,018h,000h,018h,000h ;!
        .DB    06Ch,06Ch,06Ch,000h,000h,000h,000h,000h ;"
        .DB    06Ch,06Ch,0FEh,06Ch,0FEh,06Ch,06Ch,000h ;#
        .DB    018h,03Eh,058h,03Ch,01Ah,07Ch,018h,000h ;$
        .DB    000h,0C6h,0CCh,018h,030h,066h,0C6h,000h ;%
        .DB    038h,06Ch,038h,076h,0DCh,0CCh,076h,000h ;&
        .DB    018h,018h,030h,000h,000h,000h,000h,000h ;'
        .DB    00Ch,018h,030h,030h,030h,018h,00Ch,000h ;(
        .DB    030h,018h,00Ch,00Ch,00Ch,018h,030h,000h ;)
        .DB    000h,066h,03Ch,0FFh,03Ch,066h,000h,000h ;*
        .DB    000h,018h,018h,07Eh,018h,018h,000h,000h ;+
        .DB    000h,000h,000h,000h,000h,018h,018h,030h ;,
        .DB    000h,000h,000h,07Eh,000h,000h,000h,000h ;-
        .DB    000h,000h,000h,000h,000h,018h,018h,000h ;.
        .DB    006h,00Ch,018h,030h,060h,0C0h,080h,000h ;/
        .DB    07Ch,0C6h,0CEh,0D6h,0E6h,0C6h,07Ch,000h ;0
        .DB    018h,038h,018h,018h,018h,018h,07Eh,000h ;1
        .DB    03Ch,066h,006h,03Ch,060h,066h,07Eh,000h ;2
        .DB    03Ch,066h,006h,01Ch,006h,066h,03Ch,000h ;3
        .DB    01Ch,03Ch,06Ch,0CCh,0FEh,00Ch,01Eh,000h ;4
        .DB    07Eh,062h,060h,07Ch,006h,066h,03Ch,000h ;5
        .DB    03Ch,066h,060h,07Ch,066h,066h,03Ch,000h ;6
        .DB    07Eh,066h,006h,00Ch,018h,018h,018h,000h ;7
        .DB    03Ch,066h,066h,03Ch,066h,066h,03Ch,000h ;8
        .DB    03Ch,066h,066h,03Eh,006h,066h,03Ch,000h ;9
        .DB    000h,000h,018h,018h,000h,018h,018h,000h ;:
        .DB    000h,000h,018h,018h,000h,018h,018h,030h ;;
        .DB    00Ch,018h,030h,060h,030h,018h,00Ch,000h ;<
        .DB    000h,000h,07Eh,000h,000h,07Eh,000h,000h ;=
        .DB    060h,030h,018h,00Ch,018h,030h,060h,000h ;>
        .DB    03Ch,066h,066h,00Ch,018h,000h,018h,000h ;?
        .DB    07Ch,0C6h,0DEh,0DEh,0DEh,0C0h,07Ch,000h ;@
        .DB    018h,03Ch,066h,066h,07Eh,066h,066h,000h ;A
        .DB    0FCh,066h,066h,07Ch,066h,066h,0FCh,000h ;B
        .DB    03Ch,066h,0C0h,0C0h,0C0h,066h,03Ch,000h ;C
        .DB    0F8h,06Ch,066h,066h,066h,06Ch,0F8h,000h ;D
        .DB    0FEh,062h,068h,078h,068h,062h,0FEh,000h ;E
        .DB    0FEh,062h,068h,078h,068h,060h,0F0h,000h ;F
        .DB    03Ch,066h,0C0h,0C0h,0CEh,066h,03Eh,000h ;G
        .DB    066h,066h,066h,07Eh,066h,066h,066h,000h ;H
        .DB    07Eh,018h,018h,018h,018h,018h,07Eh,000h ;I
        .DB    01Eh,00Ch,00Ch,00Ch,0CCh,0CCh,078h,000h ;J
        .DB    0E6h,066h,06Ch,078h,06Ch,066h,0E6h,000h ;K
        .DB    0F0h,060h,060h,060h,062h,066h,0FEh,000h ;L
        .DB    0C6h,0EEh,0FEh,0FEh,0D6h,0C6h,0C6h,000h ;M
        .DB    0C6h,0E6h,0F6h,0DEh,0CEh,0C6h,0C6h,000h ;N
        .DB    038h,06Ch,0C6h,0C6h,0C6h,06Ch,038h,000h ;O
        .DB    0FCh,066h,066h,07Ch,060h,060h,0F0h,000h ;P
        .DB    038h,06Ch,0C6h,0C6h,0DAh,0CCh,076h,000h ;Q
        .DB    0FCh,066h,066h,07Ch,06Ch,066h,0E6h,000h ;R
        .DB    03Ch,066h,060h,03Ch,006h,066h,03Ch,000h ;S
        .DB    07Eh,05Ah,018h,018h,018h,018h,03Ch,000h ;T
        .DB    066h,066h,066h,066h,066h,066h,03Ch,000h ;U
        .DB    066h,066h,066h,066h,066h,03Ch,018h,000h ;V
        .DB    0C6h,0C6h,0C6h,0D6h,0FEh,0EEh,0C6h,000h ;W
        .DB    0C6h,06Ch,038h,038h,06Ch,0C6h,0C6h,000h ;X
        .DB    066h,066h,066h,03Ch,018h,018h,03Ch,000h ;Y
        .DB    0FEh,0C6h,08Ch,018h,032h,066h,0FEh,000h ;Z
        .DB    03Ch,030h,030h,030h,030h,030h,03Ch,000h ;[
        .DB    0C0h,060h,030h,018h,00Ch,006h,002h,000h ;
        .DB    03Ch,00Ch,00Ch,00Ch,00Ch,00Ch,03Ch,000h ;]
        .DB    018h,03Ch,07Eh,018h,018h,018h,018h,000h ;^
        .DB    000h,000h,000h,000h,000h,000h,000h,0FFh ;_
        .DB    030h,018h,00Ch,000h,000h,000h,000h,000h ;'
        .DB    000h,000h,078h,00Ch,07Ch,0CCh,076h,000h ;a
        .DB    0E0h,060h,07Ch,066h,066h,066h,0DCh,000h ;b
        .DB    000h,000h,03Ch,066h,060h,066h,03Ch,000h ;c
        .DB    01Ch,00Ch,07Ch,0CCh,0CCh,0CCh,076h,000h ;d
        .DB    000h,000h,03Ch,066h,07Eh,060h,03Ch,000h ;e
        .DB    01Ch,036h,030h,078h,030h,030h,078h,000h ;f
        .DB    000h,000h,03Eh,066h,066h,03Eh,006h,07Ch ;g
        .DB    0E0h,060h,06Ch,076h,066h,066h,0E6h,000h ;h
        .DB    018h,000h,038h,018h,018h,018h,03Ch,000h ;i
        .DB    006h,000h,00Eh,006h,006h,066h,066h,03Ch ;j
        .DB    0E0h,060h,066h,06Ch,078h,06Ch,0E6h,000h ;k
        .DB    038h,018h,018h,018h,018h,018h,03Ch,000h ;l
        .DB    000h,000h,06Ch,0FEh,0D6h,0D6h,0C6h,000h ;m
        .DB    000h,000h,0DCh,066h,066h,066h,066h,000h ;n
        .DB    000h,000h,03Ch,066h,066h,066h,03Ch,000h ;o
        .DB    000h,000h,0DCh,066h,066h,07Ch,060h,0F0h ;p
        .DB    000h,000h,076h,0CCh,0CCh,07Ch,00Ch,01Eh ;q
        .DB    000h,000h,0DCh,076h,060h,060h,0F0h,000h ;r
        .DB    000h,000h,03Ch,060h,03Ch,006h,07Ch,000h ;s
        .DB    030h,030h,07Ch,030h,030h,036h,01Ch,000h ;t
        .DB    000h,000h,066h,066h,066h,066h,03Eh,000h ;u
        .DB    000h,000h,066h,066h,066h,03Ch,018h,000h ;v
        .DB    000h,000h,0C6h,0D6h,0D6h,0FEh,06Ch,000h ;w
        .DB    000h,000h,0C6h,06Ch,038h,06Ch,0C6h,000h ;x
        .DB    000h,000h,066h,066h,066h,03Eh,006h,07Ch ;y
        .DB    000h,000h,07Eh,04Ch,018h,032h,07Eh,000h ;z
        .DB    00Eh,018h,018h,070h,018h,018h,00Eh,000h ;{
        .DB    018h,018h,018h,018h,018h,018h,018h,000h ;|
        .DB    070h,018h,018h,00Eh,018h,018h,070h,000h ;}
        .DB    076h,0DCh,000h,000h,000h,000h,000h,000h ;~
        .DB    0CCh,033h,0CCh,033h,0CCh,033h,0CCh,033h ;<checker>
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh ;solid blob        128
        .DB    0FFh,0FFh,0C0h,0C0h,0C0h,0C0h,0C0h,0C0h ;top left keyb box 129
        .DB    0FFh,0FFh,000h,000h,000h,000h,000h,000h ;top of keyb box   130
        .DB    0C0h,0C0h,0C0h,0C0h,0C0h,0C0h,0C0h,0C0h ;left keyb box     131
        .DB    018h,03Ch,07Eh,0FFh,018h,018h,018h,018h ;up arrow          132
        .DB    018h,018h,018h,018h,0FFh,07Eh,03Ch,018h ;down arrow        133
        .DB    010h,030h,070h,0FFh,0FFh,070h,030h,010h ;left arrow        134
        .DB    008h,00Ch,00Eh,0FFh,0FFh,00Eh,00Ch,008h ;right arrow       135
        .DB    083h,0C3h,063h,033h,01Bh,00Fh,007h,003h ;down/vert envelop 136
        .DB    080h,0C0h,060h,030h,018h,00Ch,006h,003h ;down envelop      137
        .DB    003h,007h,00Fh,01Bh,033h,063h,0C3h,083h ;up/vert envelop   138
        .DB    003h,006h,00Ch,018h,030h,060h,0C0h,080h ;up envelop        139
        .DB    0FFh,000h,000h,000h,000h,000h,000h,000h ;top envelop       140

	.org	08000h

        #include "testvars.S"


.SpriteDefinitions
;
; Sprite 0 consits of a background square of color 0 with a foreground digit
; defined in color F to look like a 0
;
        .DB    000h,000h,000h,000h,000h,000h,000h,000h
        .DB    000h,034h,056h,078h,09Ah,0BCh,000h,000h
        .DB    002h,034h,056h,078h,09Ah,0BCh,0D0h,000h
        .DB    012h,034h,000h,000h,000h,0BCh,0DEh,000h
        .DB    012h,034h,000h,000h,00Ah,0BCh,0DEh,000h
        .DB    012h,034h,000h,000h,09Ah,0BCh,0DEh,000h
        .DB    012h,034h,000h,008h,09Ah,0BCh,0DEh,000h
        .DB    012h,034h,000h,078h,090h,0BCh,0DEh,000h
        .DB    012h,034h,006h,078h,000h,0BCh,0DEh,000h
        .DB    012h,034h,056h,070h,000h,0BCh,0DEh,000h
        .DB    012h,034h,056h,000h,000h,0BCh,0DEh,000h
        .DB    012h,034h,040h,000h,000h,0BCh,0DEh,000h
        .DB    012h,034h,000h,000h,000h,0BCh,0DEh,000h
        .DB    002h,034h,056h,078h,09Ah,0BCh,0D0h,000h
        .DB    000h,034h,056h,078h,09Ah,0BCh,000h,000h
        .DB    000h,000h,000h,000h,000h,000h,000h,000h
;
; Sprite 1 consits of a background square of color 1 with a foreground digit
; defined in color E to look like a 1
;
        .DB    011h,011h,011h,011h,011h,011h,011h,011h
        .DB    011h,011h,011h,022h,022h,011h,011h,011h
        .DB    011h,011h,013h,033h,033h,011h,011h,011h
        .DB    011h,011h,044h,044h,044h,011h,011h,011h
        .DB    011h,011h,055h,055h,055h,011h,011h,011h
        .DB    011h,011h,011h,066h,066h,011h,011h,011h
        .DB    011h,011h,011h,077h,077h,011h,011h,011h
        .DB    011h,011h,011h,088h,088h,011h,011h,011h
        .DB    011h,011h,011h,099h,099h,011h,011h,011h
        .DB    011h,011h,011h,0AAh,0AAh,011h,011h,011h
        .DB    011h,011h,011h,0BBh,0BBh,011h,011h,011h
        .DB    011h,011h,011h,0CCh,0CCh,011h,011h,011h
        .DB    011h,011h,011h,0DDh,0DDh,011h,011h,011h
        .DB    011h,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,011h
        .DB    011h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,011h
        .DB    011h,011h,011h,011h,011h,011h,011h,011h
;
; Sprite 2 consits of a background square of color 2 with a foreground digit
; defined in color 0 to look like a 2
;
        .DB    022h,022h,022h,022h,022h,022h,022h,022h
        .DB    022h,022h,056h,078h,09Ah,0BCh,022h,022h
        .DB    022h,024h,056h,078h,09Ah,0BCh,0D2h,022h
        .DB    022h,034h,056h,078h,022h,0BCh,0DEh,022h
        .DB    022h,034h,056h,022h,022h,0BCh,0DEh,022h
        .DB    022h,022h,022h,022h,022h,0BCh,0DEh,022h
        .DB    022h,022h,022h,022h,02Ah,0BCh,0DEh,022h
        .DB    022h,022h,056h,078h,09Ah,0BCh,0D2h,022h
        .DB    022h,024h,056h,078h,09Ah,0BCh,022h,022h
        .DB    022h,034h,056h,072h,022h,022h,022h,022h
        .DB    022h,034h,056h,022h,022h,022h,022h,022h
        .DB    022h,034h,056h,022h,022h,0BCh,0DEh,022h
        .DB    022h,034h,056h,022h,022h,0BCh,0DEh,022h
        .DB    022h,034h,056h,078h,09Ah,0BCh,0DEh,022h
        .DB    022h,034h,056h,078h,09Ah,0BCh,0DEh,022h
        .DB    022h,022h,022h,022h,022h,022h,022h,022h
;
; Sprite 3 consits of a background square of color 3 with a foreground digit
; defined in color 0 to look like a 3
;
        .DB    033h,033h,033h,033h,033h,033h,033h,033h
        .DB    033h,033h,011h,011h,011h,011h,033h,033h
        .DB    033h,032h,022h,022h,022h,022h,023h,033h
        .DB    033h,044h,043h,033h,034h,044h,044h,033h
        .DB    033h,055h,033h,033h,033h,055h,055h,033h
        .DB    033h,033h,033h,033h,033h,066h,066h,033h
        .DB    033h,033h,033h,033h,037h,077h,077h,033h
        .DB    033h,033h,033h,088h,088h,088h,083h,033h
        .DB    033h,033h,033h,099h,099h,099h,093h,033h
        .DB    033h,033h,033h,033h,03Ah,0AAh,0AAh,033h
        .DB    033h,033h,033h,033h,033h,0BBh,0BBh,033h
        .DB    033h,0CCh,033h,033h,033h,0CCh,0CCh,033h
        .DB    033h,0DDh,003h,033h,03Dh,0DDh,0DDh,033h
        .DB    033h,03Eh,0EEh,0EEh,0EEh,0EEh,0E3h,033h
        .DB    033h,033h,0FFh,0FFh,0FFh,0FFh,033h,033h
        .DB    033h,033h,033h,033h,033h,033h,033h,033h
;
; Sprite 4 consits of a background square of color 4 with a foreground digit
; defined in color 0 to look like a 4
;
        .DB    044h,044h,044h,044h,044h,044h,044h,044h
        .DB    044h,044h,044h,098h,076h,044h,044h,044h
        .DB    044h,044h,04Ah,098h,076h,044h,044h,044h
        .DB    044h,044h,0BAh,098h,076h,044h,044h,044h
        .DB    044h,04Ch,0BAh,098h,076h,044h,044h,044h
        .DB    044h,0DCh,0B4h,098h,076h,044h,044h,044h
        .DB    04Eh,0DCh,044h,098h,076h,044h,044h,044h
        .DB    0FEh,0D4h,044h,098h,076h,044h,044h,044h
        .DB    0FEh,044h,044h,098h,076h,044h,044h,044h
        .DB    0FEh,0DCh,0BAh,098h,076h,053h,021h,044h
        .DB    0FEh,0DCh,0BAh,098h,076h,053h,021h,044h
        .DB    044h,044h,044h,098h,076h,044h,044h,044h
        .DB    044h,044h,044h,098h,076h,044h,044h,044h
        .DB    044h,044h,0BAh,098h,076h,053h,044h,044h
        .DB    044h,044h,0BAh,098h,076h,053h,044h,044h
        .DB    044h,044h,044h,044h,044h,044h,044h,044h
;
; Sprite 5 consits of a background square of color 5 with a foreground digit
; defined in color 0 to look like a 5
;
        .DB    055h,055h,055h,055h,055h,055h,055h,055h
        .DB    055h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,055h
        .DB    055h,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,055h
        .DB    055h,0DDh,0DDh,055h,055h,055h,0DDh,055h
        .DB    055h,0CCh,0CCh,055h,055h,055h,0CCh,055h
        .DB    055h,0BBh,0BBh,055h,055h,055h,055h,055h
        .DB    055h,0AAh,0AAh,0A5h,055h,055h,055h,055h
        .DB    055h,059h,099h,099h,099h,099h,055h,055h
        .DB    055h,055h,088h,088h,088h,088h,085h,055h
        .DB    055h,055h,055h,055h,057h,077h,077h,055h
        .DB    055h,055h,055h,055h,055h,066h,066h,055h
        .DB    055h,044h,044h,055h,055h,044h,044h,055h
        .DB    055h,033h,033h,055h,055h,033h,033h,055h
        .DB    055h,052h,022h,022h,022h,022h,025h,055h
        .DB    055h,055h,011h,011h,011h,011h,055h,055h
        .DB    055h,055h,055h,055h,055h,055h,055h,055h
;
; Sprite 6 consits of a background square of color 6 with a foreground digit
; defined in color 0 to look like a 6
;
       .DB     066h,066h,066h,066h,066h,066h,066h,066h
       .DB     066h,066h,0BAh,098h,075h,043h,066h,066h
       .DB     066h,06Ch,0BAh,098h,075h,043h,026h,066h
       .DB     066h,0DCh,0BAh,066h,066h,043h,021h,066h
       .DB     066h,0DCh,0BAh,066h,066h,043h,021h,066h
       .DB     066h,0DCh,0BAh,066h,066h,066h,066h,066h
       .DB     066h,0DCh,0BAh,066h,066h,066h,066h,066h
       .DB     066h,0DCh,0BAh,098h,075h,043h,066h,066h
       .DB     066h,0DCh,0BAh,098h,075h,043h,026h,066h
       .DB     066h,0DCh,0BAh,066h,066h,043h,021h,066h
       .DB     066h,0DCh,0BAh,066h,066h,043h,021h,066h
       .DB     066h,0DCh,0BAh,066h,066h,043h,021h,066h
       .DB     066h,0DCh,0BAh,066h,066h,043h,021h,066h
       .DB     066h,06Ch,0BAh,098h,075h,043h,026h,066h
       .DB     066h,066h,0BAh,098h,075h,043h,066h,066h
       .DB     066h,066h,066h,066h,066h,066h,066h,066h
;
; Sprite 7 consits of a background square of color 7 with a foreground digit
; defined in color 0 to look like a 7
;
        .DB    077h,077h,077h,077h,077h,077h,077h,077h
        .DB    077h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,077h
        .DB    077h,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,077h
        .DB    077h,0DDh,077h,077h,077h,0DDh,0DDh,077h
        .DB    077h,0CCh,077h,077h,077h,0CCh,0CCh,077h
        .DB    077h,077h,077h,077h,077h,0BBh,0BBh,077h
        .DB    077h,077h,077h,077h,070h,0AAh,0AAh,077h
        .DB    077h,077h,077h,077h,099h,099h,097h,077h
        .DB    077h,077h,077h,078h,088h,088h,077h,077h
        .DB    077h,077h,077h,066h,066h,007h,077h,077h
        .DB    077h,077h,077h,055h,055h,077h,077h,077h
        .DB    077h,077h,077h,044h,044h,077h,077h,077h
        .DB    077h,077h,077h,033h,033h,077h,077h,077h
        .DB    077h,077h,077h,022h,022h,077h,077h,077h
        .DB    077h,077h,077h,011h,011h,077h,077h,077h
        .DB    077h,077h,077h,077h,077h,077h,077h,077h
;
; Sprite 8 consits of a background square of color 8 with a foreground digit
; defined in color 3 to look like a 8
;
        .DB    088h,088h,088h,088h,088h,088h,088h,088h
        .DB    088h,088h,045h,067h,09Ah,0BCh,088h,088h
        .DB    088h,083h,045h,067h,09Ah,0BCh,0D8h,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,083h,045h,067h,09Ah,0BCh,0D8h,088h
        .DB    088h,083h,045h,067h,09Ah,0BCh,0D8h,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,023h,045h,088h,088h,0BCh,0DEh,088h
        .DB    088h,083h,045h,067h,09Ah,0BCh,0D8h,088h
        .DB    088h,088h,045h,067h,09Ah,0BCh,088h,088h
        .DB    088h,088h,088h,088h,088h,088h,088h,088h
;
; Sprite 9 consits of a background square of color 9 with a foreground digit
; defined in color 0 to look like a 9
;
        .DB    099h,099h,099h,099h,099h,099h,099h,099h
        .DB    099h,099h,011h,011h,011h,011h,099h,099h
        .DB    099h,092h,022h,022h,022h,022h,029h,099h
        .DB    099h,033h,033h,099h,099h,033h,033h,099h
        .DB    099h,044h,044h,099h,099h,044h,044h,099h
        .DB    099h,055h,055h,099h,099h,055h,055h,099h
        .DB    099h,066h,066h,099h,099h,066h,066h,099h
        .DB    099h,097h,077h,077h,077h,077h,077h,099h
        .DB    099h,099h,088h,088h,088h,088h,088h,099h
        .DB    099h,099h,099h,099h,099h,0AAh,0AAh,099h
        .DB    099h,099h,099h,099h,099h,0BBh,0BBh,099h
        .DB    099h,0CCh,0CCh,099h,099h,0CCh,0CCh,099h
        .DB    099h,0DDh,0DDh,099h,099h,0DDh,0DDh,099h
        .DB    099h,09Eh,0EEh,0EEh,0EEh,0EEh,0E9h,099h
        .DB    099h,099h,0FFh,0FFh,0FFh,0FFh,099h,099h
        .DB    099h,099h,099h,099h,099h,099h,099h,099h
;
; Sprite A consits of a background square of color A with a foreground digit
; defined in color 0 to look like a A
;
        .DB    0AAh,0AAh,0AAh,0AAh,0AAh,0AAh,0AAh,0AAh
        .DB    0AAh,0AAh,0AAh,067h,089h,0AAh,0AAh,0AAh
        .DB    0AAh,0AAh,0A5h,067h,089h,0BAh,0AAh,0AAh
        .DB    0AAh,0AAh,045h,067h,089h,0BCh,0AAh,0AAh
        .DB    0AAh,0A3h,045h,067h,089h,0BCh,0DAh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,067h,089h,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,067h,089h,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,023h,045h,0AAh,0AAh,0BCh,0DEh,0AAh
        .DB    0AAh,0AAh,0AAh,0AAh,0AAh,0AAh,0AAh,0AAh
;
; Sprite B consits of a background square of color B with a foreground digit
; defined in color 0 to look like a B
;
        .DB    0BBh,0BBh,0BBh,0BBh,0BBh,0BBh,0BBh,0BBh
        .DB    011h,011h,011h,011h,011h,011h,0BBh,0BBh
        .DB    022h,022h,022h,022h,022h,022h,02Bh,0BBh
        .DB    0BBh,033h,033h,0BBh,0BBh,033h,033h,0BBh
        .DB    0BBh,044h,044h,0BBh,0BBh,044h,044h,0BBh
        .DB    0BBh,055h,055h,0BBh,0BBh,055h,055h,0BBh
        .DB    0BBh,066h,066h,0BBh,0BBh,066h,066h,0BBh
        .DB    0BBh,077h,077h,077h,077h,077h,07Bh,0BBh
        .DB    0BBh,088h,088h,088h,088h,088h,08Bh,0BBh
        .DB    0BBh,099h,099h,0BBh,0BBh,099h,099h,0BBh
        .DB    0BBh,0AAh,0AAh,0BBh,0BBh,0AAh,0AAh,0BBh
        .DB    0BBh,0CCh,0CCh,0BBh,0BBh,0CCh,0CCh,0BBh
        .DB    0BBh,0DDh,0DDh,0BBh,0BBh,0DDh,0DDh,0BBh
        .DB    0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,0EBh,0BBh
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0BBh,0BBh
        .DB    0BBh,0BBh,0BBh,0BBh,0BBh,0BBh,0BBh,0BBh
;
; Sprite C consits of a background square of color C with a foreground digit
; defined in color 0 to look like a C
;
        .DB    0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0CCh,0CCh,0A9h,087h,065h,043h,0CCh,0CCh
        .DB    0CCh,0CBh,0A9h,087h,065h,043h,02Ch,0CCh
        .DB    0CCh,0DBh,0A9h,08Ch,0C5h,043h,021h,0CCh
        .DB    0CEh,0DBh,0A9h,0CCh,0CCh,043h,021h,0CCh
        .DB    0FEh,0DBh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0FEh,0DBh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0FEh,0DBh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0FEh,0DBh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0FEh,0DBh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0FEh,0DBh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
        .DB    0CEh,0DBh,0A9h,0CCh,0CCh,043h,021h,0CCh
        .DB    0CCh,0DBh,0A9h,08Ch,0C5h,043h,021h,0CCh
        .DB    0CCh,0CBh,0A9h,087h,065h,043h,02Ch,0CCh
        .DB    0CCh,0CCh,0A9h,087h,065h,043h,0CCh,0CCh
        .DB    0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh
;
; Sprite D consits of a background square of color D with a foreground digit
; defined in color 0 to look like a D
;
        .DB    0DDh,0DDh,0DDh,0DDh,0DDh,0DDh,0DDh,0DDh
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0DDh,0DDh,0DDh
        .DB    0EEh,0EEh,0EEh,0EEh,0EEh,0EDh,0DDh,0DDh
        .DB    0DDh,0CCh,0CCh,0DCh,0CCh,0CCh,0DDh,0DDh
        .DB    0DDh,0BBh,0BBh,0DDh,0BBh,0BBh,0BDh,0DDh
        .DB    0DDh,0AAh,0AAh,0DDh,0DDh,0AAh,0AAh,0DDh
        .DB    0DDh,099h,099h,0DDh,0DDh,099h,099h,0DDh
        .DB    0DDh,088h,088h,0DDh,0DDh,088h,088h,0DDh
        .DB    0DDh,077h,077h,0DDh,0DDh,077h,077h,0DDh
        .DB    0DDh,066h,066h,0DDh,0DDh,066h,066h,0DDh
        .DB    0DDh,055h,055h,0DDh,0DDh,055h,055h,0DDh
        .DB    0DDh,044h,044h,0DDh,044h,044h,04Dh,0DDh
        .DB    0DDh,033h,033h,0D3h,033h,033h,0DDh,0DDh
        .DB    022h,022h,022h,022h,022h,02Dh,0DDh,0DDh
        .DB    011h,011h,011h,011h,011h,0DDh,0DDh,0DDh
        .DB    0DDh,0DDh,0DDh,0DDh,0DDh,0DDh,0DDh,0DDh
;
; Sprite E consits of a background square of color 0 with a foreground digit
; defined in color 0 to look like a 0
;
        .DB    0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh
        .DB    0FDh,0CBh,0A9h,087h,065h,043h,021h,0EEh
        .DB    0FDh,0CBh,0A9h,087h,065h,043h,021h,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,0EEh,0EEh,021h,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,0EEh,0EEh,021h,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,065h,0EEh,0EEh,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,065h,0EEh,0EEh,0EEh
        .DB    0EEh,0CBh,0A9h,087h,065h,0EEh,0EEh,0EEh
        .DB    0EEh,0CBh,0A9h,087h,065h,0EEh,0EEh,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,065h,0EEh,0EEh,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,065h,0EEh,0EEh,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,0EEh,0EEh,021h,0EEh
        .DB    0EEh,0CBh,0A9h,0EEh,0EEh,0EEh,021h,0EEh
        .DB    0FDh,0CBh,0A9h,087h,065h,043h,021h,0EEh
        .DB    0FDh,0CBh,0A9h,087h,065h,043h,021h,0EEh
        .DB    0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh
;
; Sprite F consits of a background square of color F with a foreground digit
; defined in color 0 to look like a F
;
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
        .DB    000h,0EEh,0EEh,0EEh,0EEh,0EEh,0EEh,0FFh
        .DB    000h,0DDh,0DDh,0DDh,0DDh,0DDh,0DDh,0FFh
        .DB    0FFh,0CCh,0CCh,0FFh,0FFh,0FFh,0CCh,0FFh
        .DB    0FFh,0BBh,0BBh,0FFh,0FFh,0FFh,0BBh,0FFh
        .DB    0FFh,0AAh,0AAh,0FFh,0AAh,0FFh,0FFh,0FFh
        .DB    0FFh,099h,099h,0FFh,099h,0FFh,0FFh,0FFh
        .DB    0FFh,088h,088h,088h,088h,0FFh,0FFh,0FFh
        .DB    0FFh,077h,077h,077h,077h,0FFh,0FFh,0FFh
        .DB    0FFh,066h,066h,0FFh,066h,0FFh,0FFh,0FFh
        .DB    0FFh,055h,055h,0FFh,055h,0FFh,0FFh,0FFh
        .DB    0FFh,044h,044h,0FFh,0FFh,0FFh,0FFh,0FFh
        .DB    0FFh,033h,033h,0FFh,0FFh,0FFh,0FFh,0FFh
        .DB    022h,022h,022h,022h,0FFh,0FFh,0FFh,0FFh
        .DB    011h,011h,011h,011h,0FFh,0FFh,0FFh,0FFh
        .DB    0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh

.SpritePalDefinitions
;
; used in sprite palette test, only 0 and 1 are defined (see comments in
; SPRITPAL).
;
        .DB    000h,000h,000h,000h,011h,011h,011h,011h
        .DB    000h,000h,000h,000h,011h,011h,011h,011h
        .DB    000h,000h,000h,000h,011h,011h,011h,011h
        .DB    000h,000h,000h,000h,011h,011h,011h,011h
        .DB    044h,044h,044h,044h,055h,055h,055h,055h
        .DB    044h,044h,044h,044h,055h,055h,055h,055h
        .DB    044h,044h,044h,044h,055h,055h,055h,055h
        .DB    044h,044h,044h,044h,055h,055h,055h,055h
        .DB    088h,088h,088h,088h,099h,099h,099h,099h
        .DB    088h,088h,088h,088h,099h,099h,099h,099h
        .DB    088h,088h,088h,088h,099h,099h,099h,099h
        .DB    088h,088h,088h,088h,099h,099h,099h,099h
        .DB    0CCh,0CCh,0CCh,0CCh,0DDh,0DDh,0DDh,0DDh
        .DB    0CCh,0CCh,0CCh,0CCh,0DDh,0DDh,0DDh,0DDh
        .DB    0CCh,0CCh,0CCh,0CCh,0DDh,0DDh,0DDh,0DDh
        .DB    0CCh,0CCh,0CCh,0CCh,0DDh,0DDh,0DDh,0DDh

        .DB    022h,022h,022h,022h,033h,033h,033h,033h
        .DB    022h,022h,022h,022h,033h,033h,033h,033h    
        .DB    022h,022h,022h,022h,033h,033h,033h,033h    
        .DB    022h,022h,022h,022h,033h,033h,033h,033h
        .DB    066h,066h,066h,066h,077h,077h,077h,077h
        .DB    066h,066h,066h,066h,077h,077h,077h,077h    
        .DB    066h,066h,066h,066h,077h,077h,077h,077h    
        .DB    066h,066h,066h,066h,077h,077h,077h,077h
        .DB    0AAh,0AAh,0AAh,0AAh,0BBh,0BBh,0BBh,0BBh
        .DB    0AAh,0AAh,0AAh,0AAh,0BBh,0BBh,0BBh,0BBh    
        .DB    0AAh,0AAh,0AAh,0AAh,0BBh,0BBh,0BBh,0BBh    
        .DB    0AAh,0AAh,0AAh,0AAh,0BBh,0BBh,0BBh,0BBh
        .DB    0EEh,0EEh,0EEh,0EEh,0FFh,0FFh,0FFh,0FFh
        .DB    0EEh,0EEh,0EEh,0EEh,0FFh,0FFh,0FFh,0FFh    
        .DB    0EEh,0EEh,0EEh,0EEh,0FFh,0FFh,0FFh,0FFh    
        .DB    0EEh,0EEh,0EEh,0EEh,0FFh,0FFh,0FFh,0FFh    

;
; The following 3 blocks are the date for playing on each of the 3 DMA sound
; channels. A always "plays" because it is used to set the AY enables
; register (7) as the 4th parameter. However, when only B and/or C are to be
; heards its period and volume are programmed with 0.
;
.Channel0DMAData
;        AYPlayChanA  GO1, 0Fh, 100, 3Eh         ;Channel A only
;        AYPlayChanA    0,   0, 100, 3Dh         ;dummy to enable just B
;        AYPlayChanA    0,   0, 100, 3Bh         ;dummy to enable just C
;        AYPlayChanA  GO0, 0Fh, 100, 3Ch         ;Channels A and B
;        AYPlayChanA  CO1, 0Fh, 100, 3Ah         ;Channels A and C
;        AYPlayChanA    0,   0, 100, 39h         ;dummy to enable B and C
;        AYPlayChanA  CO0, 0Fh, 100, 38h         ;Channels A, B and C
;        AYPlayChanA  CO0, 0Fh, 100, 38h         ;Channels A, B and C
;        AYPlayChanA  DO0, 0Fh, 100, 38h         ;Channels A, B and C
;        AYPlayChanA  EO0, 0Fh, 100, 38h         ;Channels A, B and C
;
;        AYNoPlay     200
;
; The following is Eine Kleine Nacht Musik
;
        Repeat(10)

        AYPlayChanA(  FO1, 0Fh, 120, 38h )
        AYPlayChanA(  CO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh, 120, 38h )
        AYPlayChanA(  CO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  CO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  CO2, 0Fh, 160, 38h )

        AYPlayChanA( ASO1, 0Fh, 120, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh, 120, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
					 
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  CO1, 0Fh, 160, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  80, 38h )
        AYPlayChanA(  FO1, 0Fh, 120, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh, 120, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh, 120, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh, 120, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh, 120, 38h )
        AYPlayChanA(  CO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh, 120, 38h )
        AYPlayChanA(  CO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  CO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  CO2, 0Fh, 160, 38h )
					 
        AYPlayChanA(  CO2, 0Fh, 160, 38h )
        AYPlayChanA(  DO2, 0Fh, 160, 38h )
					 
        AYPlayChanA(  CO2, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  80, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  80, 38h )
					 
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  80, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
        AYPlayChanA(  DO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  80, 38h )
        AYPlayChanA(  GO1, 0Fh,  80, 38h )
        AYPlayChanA(  AO1, 0Fh, 160, 38h )
					 
        AYPlayChanA(  CO2, 0Fh, 160, 38h )
        AYPlayChanA(  DO2, 0Fh, 160, 38h )
					 
        AYPlayChanA(  CO2, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
        AYPlayChanA(  DO1, 0Fh,  40, 38h )
        AYPlayChanA(  EO1, 0Fh,  40, 38h )
					 
        AYPlayChanA(  FO1, 0Fh,  80, 38h )
        AYPlayChanA(  FO1, 0Fh,  80, 38h )
        AYPlayChanA(  FO1, 0Fh, 160, 38h )

        AYNoPlay(200)
;
; A bit of EastEnders...
;
        AYPlayChanA(  FO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  CO2, 0Fh,  80, 38h )
        AYPlayChanA(  DO2, 0Fh,  80, 38h )

        AYPlayChanA( ASO1, 0Fh, 240, 38h )
        AYNoPlay(80)

        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh, 160, 38h )
        AYPlayChanA(  CO1, 0FH,  40, 38h )
					 
        AYPlayChanA(  CO1, 0FH,  40, 38h )
        AYPlayChanA(  FO1, 0FH,  80, 38h )
        AYPlayChanA(  CO2, 0FH,  40, 38h )
        AYPlayChanA(  FO1, 0FH,  80, 38h )
        AYPlayChanA(  GO1, 0FH,  80, 38h )
					 
        AYPlayChanA(  FO1, 0FH,  40, 38h )
        AYPlayChanA(  GO1, 0FH,  40, 38h )
        AYPlayChanA(  AO1, 0FH,  40, 38h )
        AYPlayChanA( ASO1, 0FH,  40, 38h )
        AYPlayChanA(  CO2, 0FH,  80, 38h )
        AYPlayChanA(  DO2, 0FH,  80, 38h )
					 
        AYPlayChanA( ASO1, 0Fh, 240, 38h )
        AYNoPlay(      80		 )
					 
        AYPlayChanA( ASO1, 0Fh,  40, 38h )
        AYPlayChanA(  AO1, 0Fh,  40, 38h )
        AYPlayChanA(  GO1, 0Fh,  40, 38h )
        AYPlayChanA(  FO1, 0Fh, 160, 38h )
        AYPlayChanA(  CO1, 0FH,  40, 38h )
					 
        AYPlayChanA(  AO1, 0FH,  53, 38h )
        AYPlayChanA( ASO1, 0FH,  53, 38h )
        AYPlayChanA(  CO2, 0FH,  54, 38h )
        AYPlayChanA(  AO1, 0FH,  80, 38h )
        AYPlayChanA(  GO1, 0FH,  80, 38h )
					 
        AYPlayChanA(  FO1, 0FH, 160, 38h )

        Loop

        AYStop


.Channel1DMAData
;        AYNoPlay     100                        ;a
;        AYPlayChanB(  AO1, 0Fh, 100              ;B
;        AYNoPlay     100                        ;c
;        AYPlayChanB(  CO1, 0Fh, 100              ;a + B
;        AYNoPlay     100                        ;a + c
;        AYPlayChanB(  CO1, 0Fh, 100              ;B + c
;        AYPlayChanB(  EO0, 0Fh, 100              ;a, B + c
;        AYPlayChanB(  FO0, 0Fh, 100              ;a, B + c
;        AYPlayChanB(  GO0, 0Fh, 100              ;a, B + c
;        AYPlayChanB(  EO0, 0Fh, 100              ;a, B + c
;
;        AYNoPlay(     200)
;
        Repeat(10)

        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  CO0, 0Ch, 320 )
        AYPlayChanB(  CO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  CO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  CO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 160 )
        AYPlayChanB(  CO0, 0Ch, 160 )
        AYPlayChanB(  DO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 160 )
        AYPlayChanB(  CO0, 0Ch, 160 )
        AYPlayChanB(  FO0, 0Ch, 320 )
        AYPlayChanB(  FO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 160 )
        AYPlayChanB(  CO0, 0Ch, 160 )
        AYPlayChanB(  DO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 160 )
        AYPlayChanB(  CO0, 0Ch, 160 )
        AYPlayChanB(  FO0, 0Ch, 320 )

        AYNoPlay(200)

        AYPlayChanB(  FO0, 0Ch, 160 )
        AYPlayChanB(  AO0, 0Ch, 160 )
        AYPlayChanB(  DO0, 0Ch, 320 )
        AYPlayChanB(  GO0, 0Ch, 160 )
        AYPlayChanB(  FO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 160 )
        AYPlayChanB(  CO0, 0Ch, 160 )
        AYPlayChanB(  FO0, 0Ch, 160 )
        AYPlayChanB(  AO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 320 )
        AYPlayChanB(  GO0, 0Ch, 160 )
        AYPlayChanB(  FO0, 0Ch, 160 )
        AYPlayChanB( ASO0, 0Ch, 160 )
        AYPlayChanB(  CO0, 0Ch, 160 )
        AYPlayChanB(  AO0, 0Ch, 160 )

        Loop

        AYStop


.Channel2DMAData
;        AYNoPlay     100                        ;a
;        AYNoPlay     100                        ;b
;        AYPlayChanC(  FO1, 0Fh, 100              ;C
;        AYNoPlay     100                        ;a + b
;        AYPlayChanC(  FO1, 0Fh, 100              ;a + C
;        AYPlayChanC(  FO1, 0Fh, 100              ;b + C
;        AYPlayChanC(  GO0, 0Fh, 100              ;a, b + C
;        AYPlayChanC(  AO0, 0Fh, 100              ;a, b + C
;        AYPlayChanC(  BO0, 0Fh, 100              ;a, b + C
;        AYPlayChanC(  CO1, 0Fh, 100              ;a, b + C
;
;        AYNoPlay     200
;
        Repeat(10)

        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC( ASO0, 0Ah, 320 )
        AYPlayChanC( ASO0, 0Ah, 320 )
        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC( ASO0, 0Ah, 320 )
        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC( ASO0, 0Ah, 320 )
				    
        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC(  AO0, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 160 )
        AYPlayChanC( ASO0, 0Ah, 160 )
        AYPlayChanC(  FO0, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 160 )
        AYPlayChanC( ASO0, 0Ah, 160 )
        AYPlayChanC(  AO0, 0Ah, 320 )
        AYPlayChanC(  AO0, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 160 )
        AYPlayChanC( ASO0, 0Ah, 160 )
        AYPlayChanC(  FO0, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 160 )
        AYPlayChanC( ASO0, 0Ah, 160 )
        AYPlayChanC(  AO0, 0Ah, 320 )
				    
        AYNoPlay(     200	    )
				    
        AYPlayChanC(  AO0, 0Ah, 160 )
        AYPlayChanC(  CO1, 0Ah, 160 )
        AYPlayChanC(  FO0, 0Ah, 320 )
        AYPlayChanC( ASO0, 0Ah, 160 )
        AYPlayChanC(  AO0, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 160 )
        AYPlayChanC(  EO0, 0Ah, 160 )
        AYPlayChanC(  AO0, 0Ah, 160 )
        AYPlayChanC(  CO1, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 320 )
        AYPlayChanC( ASO0, 0Ah, 160 )
        AYPlayChanC(  AO0, 0Ah, 160 )
        AYPlayChanC(  DO0, 0Ah, 160 )
        AYPlayChanC(  EO0, 0Ah, 160 )
        AYPlayChanC(  CO1, 0Ah, 160 )
				    
        Loop			    
				    
        AYStop			    



 
        .END
