;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Variables destined to be placed in RAM at about 8000h)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;
;        DEFSEG  TestVariables, CLASS=DATA, START=8000h
;
;        SEG     TestVariables
;
;        PUBLIC  ?IntVectorTable         ;used in RASTER
;
;        PUBLIC  ?RAMstack               ;used to init SP in TESTPACK
;        PUBLIC  ?RAMTestStack
;
;        PUBLIC  ?TempSPStore            ;used to move SP to IX in RAMTEST
;                                        ;also used in SOUND for ESC exit
;
;        PUBLIC  ?ArnoldType             ;in TESTPACK holds 4 or 5
;
;        PUBLIC  ?NumberOfRAMBlocks      ;in RAMTEST
;
;        PUBLIC  ?ErrorRegisters         ;a mini "stack" used in ERROR
;
;        PUBLIC  ?PrintCharXORMask       ;in SUPPORT
;
;        PUBLIC  ?KeyboardBuffer         ;used by KeyboardRead in SUPPORT
;        PUBLIC  ?KeysHeldDownBuffer     ;used by KeyboardRead in SUPPORT
;
;        PUBLIC  ?ScreenMode
;
;        PUBLIC  ?MenuTopRow, ?MenuBottomRow, ?MenuHighlightedRow
;        PUBLIC  ?MenuCursorPos, ?MenuAddrTable  ;all used in MENU
;        PUBLIC  ?MenuTimeout
;        PUBLIC  ?MenuLastKeyPress
;        PUBLIC  ?MenuDebounceCount
;
;        PUBLIC  ?TestLoopLimit          ;accessed by COUNTER
;        PUBLIC  ?TestLoopCounter        ;accessed by COUNTER
;        PUBLIC  ?TestLastHighlight      ;accessed by TESTPACK
;
;        PUBLIC  ?IM1InterruptCounter    ;accessed by INTTEST
;
;        PUBLIC  ?KeyboardTimeout        ;accessed by KEYBOARD
;        PUBLIC  ?KeyLengthTimeout       ;accessed by KEYBOARD
;        PUBLIC  ?KeyCTRLPressed         ;accessed by KEYBOARD
;        PUBLIC  ?KeySHIFT1Printed       ;accessed by KEYBOARD
;
;        PUBLIC  ?Palette27Background    ;accessed by PALET27
;        PUBLIC  ?Pal27LastKeyPressed    ;accessed by PALET27
;        PUBLIC  ?Pal27TimesKeyPressed   ;accessed by PALET27
;        PUBLIC  ?Palette27Timeout       ;accessed by PALET27
;
;        PUBLIC  ?Pal496Background       ;accessed by PALET496
;        PUBLIC  ?PaletteLastKeyPressed  ;accessed by PALET496
;        PUBLIC  ?PaletteKeyCount        ;accessed by PALET496
;
;        PUBLIC  ?SpriteMag              ;accessed by SPRITES
;        PUBLIC  ?SpriteBeingMoved       ;accessed by SPRITES
;        PUBLIC  ?SpriteMoveControl      ;accessed by SPRITES
;        PUBLIC  ?SpriteDelay            ;accessed by SPRITES
;
;        PUBLIC  ?SplitScreenLine        ;accessed by SPLIT
;        PUBLIC  ?SplitSecondAddr        ;accessed by SPLIT
;        PUBLIC  ?SplitIncrement         ;accessed by SPLIT
;
;        PUBLIC  ?RasterIntLine          ;accessed by RASTER
;        PUBLIC  ?RasterIncrement        ;accessed by RASTER
;        PUBLIC  ?RasterIntHappened      ;accessed by RASTER
;        PUBLIC  ?RasterFaults0          ;accessed by RASTER
;        PUBLIC  ?RasterFaults1          ;accessed by RASTER
;        PUBLIC  ?RasterFaults2          ;accessed by RASTER
;
;        PUBLIC  ?TapeBlobPosition       ;accessed by TAPE
;        PUBLIC  ?TapeSamples            ;accessed by TAPE
;
;        PUBLIC  ?sectorbuffer           ;accessed by FLOPPY
;        PUBLIC  ?verifybuffer           ;accessed by FLOPPY
;
;        PUBLIC  ?formatbuffer           ;accessed by FLOPPY
;
;        PUBLIC  ?roflag                 ;accessed by FLOPPY
;        PUBLIC  ?verifyflag             ;accessed by FLOPPY
;        PUBLIC  ?driveflag              ;accessed by FLOPPY
;        PUBLIC  ?quicksector            ;accessed by FLOPPY
;        PUBLIC  ?paratable              ;accessed by FLOPPY
;        PUBLIC  ?monto                  ;accessed by FLOPPY
;        PUBLIC  ?moffto                 ;accessed by FLOPPY
;        PUBLIC  ?wrtoff                 ;accessed by FLOPPY
;        PUBLIC  ?hdsettle               ;accessed by FLOPPY
;        PUBLIC  ?steprate               ;accessed by FLOPPY
;        PUBLIC  ?headuld                ;accessed by FLOPPY
;        PUBLIC  ?headld                 ;accessed by FLOPPY
;        PUBLIC  .paralen                ;accessed by FLOPPY
;        PUBLIC  ?rcount                 ;accessed by FLOPPY
;        PUBLIC  ?motorrunning           ;accessed by FLOPPY
;        PUBLIC  ?messdisable            ;accessed by FLOPPY
;        PUBLIC  ?tickerrunning          ;accessed by FLOPPY
;        PUBLIC  ?xpb                    ;accessed by FLOPPY
;        PUBLIC  ?motortimeout           ;accessed by FLOPPY
;        PUBLIC  ?intflag                ;accessed by FLOPPY
;        PUBLIC  ?nmiflag                ;accessed by FLOPPY
;        PUBLIC  ?statusbuffer           ;accessed by FLOPPY
;        PUBLIC  ?bufferaddr             ;accessed by FLOPPY
;        PUBLIC  ?savehl                 ;accessed by FLOPPY
;        PUBLIC  ?savesp                 ;accessed by FLOPPY
;
;        PUBLIC  ?messtab                ;accessed by FLOPPY
;        PUBLIC  ?usertable              ;accessed by FLOPPY
;        PUBLIC  ?savedbc                ;accessed by FLOPPY
;        PUBLIC  ?savedde                ;accessed by FLOPPY
;
;        PUBLIC  ?CurCmndChar            ;accessed by FLOPPY and FLOPCMND
;        PUBLIC  ?LoopCount              ;accessed by FLOPPY and FLOPCMND
;        PUBLIC  ?MaxLoop                ;accessed by FLOPPY and FLOPCMND
;        PUBLIC  ?ErrorCount             ;accessed by FLOPPY and FLOPCMND
;        PUBLIC  ?MaxError               ;accessed by FLOPPY and FLOPCMND
;
;        PUBLIC  defbase                 ;accessed by FLOPCMND
;        PUBLIC  cpstack                 ;accessed by FLOPCMND
;        PUBLIC  ?cmndtable               ;accessed by FLOPCMND
;        PUBLIC  autodefenable           ;accessed by FLOPCMND
;        PUBLIC  cpbuffer                ;accessed by FLOPCMND
;        PUBLIC  lencpbuffer             ;accessed by FLOPCMND

;
; These variables are not initialised (hence the use of DEFS). It is up to the
; test routines to initialise variables before they are used.
;
; 8000h is chosen as as good a place as any to stick these variables. Unless
; there is a screw up on the RAM switching front this area should always be
; fixed as block 2 and the screen should never be positioned there.
;
QUESTMARK_IntVectorTable         .BLOCK    8
;
; The Interrup Vector Table has to be aligned on an 8 byte boundary so that
; the lower three bits of the value programmed into 6805 can be 0. The easy
; answer is to copy the table out of ROM to this area that I know is fixed
; at 8000h.
;

                        	.BLOCK    256    ;stack grows back into this area
QUESTMARK_RAMstack               .BLOCK    2

                        	.BLOCK    256
QUESTMARK_RAMTestStack           .BLOCK    2

QUESTMARK_TempSPStore            .BLOCK    2

QUESTMARK_NumberOfRAMBlocks      .BLOCK    1       ;either 3 or 7 (64K or 128K)

QUESTMARK_ArnoldType             .BLOCK    1

QUESTMARK_ErrorRegisters         .BLOCK    20       ;in ERROR all regs are PUSHed here

QUESTMARK_KeyboardBuffer         .BLOCK    10      ;10 keyboard row bytes
QUESTMARK_KeysHeldDownBuffer     .BLOCK    16      ;assume max of 16 held down

QUESTMARK_ScreenMode             .BLOCK    1

QUESTMARK_PrintCharXORMask       .BLOCK    1

QUESTMARK_MenuCursorPos          .BLOCK    2       ;in MENU (holds top left pos)
QUESTMARK_MenuTopRow             .BLOCK    1       ;in MENU top screen line of menu
QUESTMARK_MenuBottomRow          .BLOCK    1       ;in MENU bottom screen line of menu
QUESTMARK_MenuHighlightedRow     .BLOCK    1       ;in MENU Obvious (QUESTMARK_)
QUESTMARK_MenuAddrTable          .BLOCK    2       ;in MENU starting point of the routine addresses in table
QUESTMARK_MenuTimeout            .BLOCK    2       ;in MENU
QUESTMARK_MenuLastKeyPress       .BLOCK    1       ;in MENU
QUESTMARK_MenuDebounceCount      .BLOCK    1       ;in MENU

QUESTMARK_TestLoopLimit          .BLOCK    1       ;in COUNTER times to perform test
QUESTMARK_TestLoopCounter        .BLOCK    1       ;in COUNTER actual variable counter

QUESTMARK_TestLastHighlight      .BLOCK    1       ;in TESTPACK

QUESTMARK_IM1InterruptCounter    .BLOCK    1       ;in INTTEST (counts IM1 interrupts)

QUESTMARK_KeyboardTimeout        .BLOCK    2
QUESTMARK_KeyLengthTimeout       .BLOCK    2
QUESTMARK_KeyCTRLPressed         .BLOCK    1       ;in KEYBOARD flags possible end of test
QUESTMARK_KeySHIFT1Printed       .BLOCK    1       ;in KEYBOARD make sure 2 SHIFTs print

QUESTMARK_Palette27Background    .BLOCK    1       ;in PALET27 used to hold colour
QUESTMARK_Pal27LastKeyPressed    .BLOCK    1       ;in PALET27 used to debounce keys
QUESTMARK_Pal27TimesKeyPressed   .BLOCK    1       ;in PALET27 used to debounce keys
QUESTMARK_Palette27Timeout       .BLOCK    2       ;in PALET27 used to count down time

QUESTMARK_Pal496Background       .BLOCK    2       ;in PALET496
QUESTMARK_PaletteLastKeyPressed  .BLOCK    1       ;in PALET496 to help de-bounce
QUESTMARK_PaletteKeyCount        .BLOCK    1       ;in PALET496 to help de-bounce

QUESTMARK_SpriteMag              .BLOCK    1       ;in SPRITES magnification=1 2 or 3
QUESTMARK_SpriteBeingMoved       .BLOCK    1       ;in SPRITES identify one in motion 1..16
QUESTMARK_SpriteMoveControl      .BLOCK    2       ;in SPRITES addres of its control reg
QUESTMARK_SpriteDelay            .BLOCK    2

QUESTMARK_SplitScreenLine        .BLOCK    1       ;in SPLIT (line where split currently is)
QUESTMARK_SplitSecondAddr        .BLOCK    2       ;address of start of 2nd screen
QUESTMARK_SplitIncrement         .BLOCK    1       ;in SPLIT going up (1) or down (-1)


QUESTMARK_RasterIntLine          .BLOCK    1       ;in RASTER (where Int will happen)
QUESTMARK_RasterIncrement        .BLOCK    1       ;in RASTER (1=down, -1=up)
QUESTMARK_RasterIntHappened      .BLOCK    1       ;in RASTER flag says if its happened yet
QUESTMARK_RasterFaults0          .BLOCK    1       ;in RASTER counts wrong vectors
QUESTMARK_RasterFaults1          .BLOCK    1       ;in RASTER counts wrong vectors
QUESTMARK_RasterFaults2          .BLOCK    1       ;in RASTER counts wrong vectors

QUESTMARK_TapeBlobPosition       .BLOCK    2       ;in TAPE where cursor should posn. for blob
QUESTMARK_TapeSamples            .BLOCK    2       ;in TAPE

;QUESTMARK_dskwrtbuffer           .BLOCK    514     ;in FLOPPY
;QUESTMARK_sectorbuffer           .equ     QUESTMARK_dskwrtbuffer
;QUESTMARK_dskreadbuffer          .BLOCK    514     ;in FLOPPY
;QUESTMARK_verifybuffer           .equ     QUESTMARK_dskreadbuffer

;QUESTMARK_formatbuffer           .BLOCK    9 * 4

;QUESTMARK_roflag                 .BLOCK    1       ;in FLOPPY
;QUESTMARK_verifyflag             .BLOCK    1       ;in FLOPPY
;QUESTMARK_driveflag              .BLOCK    1       ;in FLOPPY

;QUESTMARK_quicksector            .BLOCK    2       ;in FLOPPY

;QUESTMARK_paratable              .equ     $
;QUESTMARK_monto                  .BLOCK    2       ;in FLOPPY motor on timeout (x 20mS)
;QUESTMARK_moffto                 .BLOCK    2       ;in FLOPPY motor on timeout (x 20mS)
;QUESTMARK_wrtoff                 .BLOCK    1       ;in FLOPPY write current off (x 10uS)
;QUESTMARK_hdsettle               .BLOCK    1       ;in FLOPPY head settle (mS)
;QUESTMARK_steprate               .BLOCK    1       ;in FLOPPY step rate (mS)
;QUESTMARK_headuld                .BLOCK    1       ;in FLOPPY head unload time
;QUESTMARK_headld                 .BLOCK    1       ;in FLOPPY head load time and non-DMA
;.paralen                .equ     $ - QUESTMARK_paratable
;QUESTMARK_rcount                 .BLOCK    1       ;in FLOPPY retry count
;QUESTMARK_motorrunning           .BLOCK    1       ;in FLOPPY obvious
;QUESTMARK_messdisable            .BLOCK    1       ;in FLOPPY messages disabled flag
;QUESTMARK_tickerrunning          .BLOCK    1       ;in FLOPPY obvious
;QUESTMARK_xpb                    .BLOCK    2 * 11  ;in FLOPPY 2 lots of XPB (A and B)
;QUESTMARK_motortimeout           .BLOCK    2       ;in FLOPPY (x 20mS)
;QUESTMARK_intflag                .BLOCK    1       ;in FLOPPY
;QUESTMARK_nmiflag                .BLOCK    1       ;in FLOPPY
;QUESTMARK_statusbuffer           .BLOCK    8       ;in FLOPPY
;QUESTMARK_bufferaddr             .BLOCK    2       ;in FLOPPY
;QUESTMARK_savehl                 .BLOCK    2       ;in FLOPPY
;QUESTMARK_savesp                 .BLOCK    2       ;in FLOPPY
;
;QUESTMARK_messtab                .BLOCK    2       ;in FLOPPY
;QUESTMARK_usertable              .BLOCK    2       ;in FLOPPY
;QUESTMARK_savedbc                .BLOCK    2       ;in FLOPPY
;QUESTMARK_savedde                .BLOCK    2       ;in FLOPPY

QUESTMARK_CurCmndChar            .BLOCK    2       ;in FLOPPY
QUESTMARK_LoopCount              .BLOCK    2       ;in FLOPPY
QUESTMARK_MaxLoop                .BLOCK    2       ;in FLOPPY
QUESTMARK_ErrorCount             .BLOCK    2       ;in FLOPPY
QUESTMARK_MaxError               .BLOCK    2       ;in FLOPPY

cpstack                 	.BLOCK    2       ;in FLOPCMND
defbase                 	.BLOCK    2       ;in FLOPCMND
QUESTMARK_cmndtable              .BLOCK    2       ;in FLOPCMND
autodefenable           	.BLOCK    2       ;in FLOPCMND
cpbuffer                	.BLOCK    255     ;in FLOPCMND
lencpbuffer             	.equ     255     ;in FLOPCMND

