;$PAGINATE
;$title(Arnold 5 test)
;$subtitle(Various disk tests based on the MEJ DTEST code)
;$copyright(Copyright (c) 1989, 1990, Amstrad plc.)
;$pagewidth=131
;
;        PUBLIC  FloppyTest      ;called indirectly from TESTPACK
;                                ; out of MainMenuTable
;        PUBLIC  KeyboardTest
;        PUBLIC  SimpleSoundTest
;        PUBLIC  Palette27Test
;
;        EXTERN  UpperFloppyTest
;        EXTERN  UpperKeyboardTest
;        EXTERN  UpperSoundTest
;        EXTERN  UpperPalette27Test
;
;
;        DEFSEG  TestCode, CLASS=CODE
;
;        SEG     TestCode

FloppyTest:
;
; The floppy test code actually resides in the top ROM so we enable that
; ROM and then copy the code out to RAM at 4000h (it is executed here rather
; than at 0C000h to make development easier)
;
        exx
        ld      bc,7f81h
        out     (c),c           ;switch on both ROMS
        exx
        ld      bc,0df01h
        out     (c),c           ;select ROM 1 as the upper ROM

;        ld      hl,0C000h
;        ld      de,04000h
;        ld      bc,03fffh
;        ldir                    ;copy code out of ROM into RAM

        call    UpperFloppyTest ;enter the floppy test routine

        exx
        ld      bc,7f89h        ;the "normal" state
        out     (c),c
        exx

        ret

KeyboardTest:
;
; The keyboard test code actually resides in the top ROM so we enable that
; ROM and then copy the code out to RAM at 4000h (it is executed here rather
; than at 0C000h to make development easier)
;
        exx
        ld      bc,7f81h
        out     (c),c           ;switch on both ROMS
        exx

        ld      bc,0df01h
        out     (c),c           ;select ROM 1 as the upper ROM

;        ld      hl,0C000h
;        ld      de,04000h
;        ld      bc,03fffh
;        ldir                    ;copy code out of ROM into RAM
;
        call    UpperKeyboardTest ;enter the keyboard test routine

        exx
        ld      bc,7f89h        ;the "normal" state
        out     (c),c
        exx

        ret

SimpleSoundTest:
;
; The floppy test code actually resides in the top ROM so we enable that
; ROM and then copy the code out to RAM at 4000h (it is executed here rather
; than at 0C000h to make development easier)
;
        exx
        ld      bc,7f81h
        out     (c),c           ;switch on both ROMS
        exx

        ld      bc,0df01h
        out     (c),c           ;select ROM 1 as the upper ROM

;        ld      hl,0C000h
;        ld      de,04000h
;        ld      bc,03fffh
;        ldir                    ;copy code out of ROM into RAM

        call    UpperSoundTest ;enter the sound test routine

        exx
        ld      bc,7f89h        ;the "normal" state
        out     (c),c
        exx

        ret

Palette27Test:
;
; The floppy test code actually resides in the top ROM so we enable that
; ROM and then copy the code out to RAM at 4000h (it is executed here rather
; than at 0C000h to make development easier)
;
        exx
        ld      bc,7f81h
        out     (c),c           ;switch on both ROMS
        exx

        ld      bc,0df01h
        out     (c),c           ;select ROM 1 as the upper ROM

;        ld      hl,0C000h
;        ld      de,04000h
;        ld      bc,03fffh
;        ldir                    ;copy code out of ROM into RAM

        call    UpperPalette27Test ;enter the dulux test routine

        exx
        ld      bc,7f89h        ;the "normal" state
        out     (c),c
        exx

        ret
