/*
 * A tool to generate a list of words to ignore in an Amstrad related document.
 *
 *  Usage:
 *
 * ignoreList
 *
 * The output file is a ASCII file.
 *
 *  (c) Copyright, Kevin Thacker 2002,2003
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv)
{
	if (argc==2)
	{
		FILE *fh;

		fh = fopen(argv[1],"w");

		if (fh)
		{
			int i;

			/* 8-bit hex values with '#' prefix */
			for (i=0; i<256; i++)
			{
				fprintf(fh,"#%02x\n",i);
			}

			/* 16-bit hex values with '#' prefix */
			for (i=0; i<65536; i++)
			{
				fprintf(fh,"#%04x\n",i);
			}

			fclose(fh);
		}
	}

	exit(0);
}

