#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * A tool to convert a word list into a StarOffice/OpenOffice compatible dictionary. 
 *
 *  Usage:
 *
 * <input file> <output file>
 *
 * The input file is assumed to be ASCII with one word per line.
 * The output file is a StarOffice/OpenOffice compatible dictionary.
 *
 *
 * Assumptions: 
 *	- No word is longer than 256 characters/bytes.
 *	- All words use 8-bit ASCII
 *	- standard end of line characters are used
 *
 *  (c) Copyright, Kevin Thacker 2002,2003
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

const char *sHeaderIdent = "WBSWG2";

/*---------------------------------------------------------------------------*/

void writeString(const char *sString, FILE *fhOut)
{
	int nStringLen = strlen(sString);

	/* length of string in characters */
	fputc((nStringLen&0x0ff),fhOut);
	fputc(((nStringLen>>8)&0x0ff),fhOut);

	/* write string */
	fwrite(sString, nStringLen, 1, fhOut);
}

/*---------------------------------------------------------------------------*/

int main(int argc, char **argv)
{
	if (argc==3)
	{
		FILE *fhIn;
		
		fhIn = fopen(argv[1],"r");

		if (fhIn)
		{
			FILE *fhOut;

			fhOut = fopen(argv[2],"wb");

			if (fhOut)
			{
				const char *sResult;

				/* write main header ident string */
				writeString(sHeaderIdent,fhOut);
				
				/* function of these bytes?? */
				fputc(0x0ff,fhOut);
				fputc(0x000,fhOut);
				fputc(0x000,fhOut);

				/* read all the words */
				do
				{
					char sBuffer[256];

					/* read a line */
					sResult = fgets(sBuffer, sizeof(sBuffer), fhIn);

					if (sResult)
					{
						int i;

						/* remove end of line; replace EOL characters with NUL character */
						for (i=strlen(sBuffer)-1; i>=0; i--)
						{
							char ch = sBuffer[i];

							if ((ch==13) || (ch==10))
								sBuffer[i] = '\0';
						}

						/* now write string */
						writeString(sBuffer,fhOut);
					}
				}
				while (sResult);

				fclose(fhOut);
			}
		
			fclose(fhIn);
		}
	}
}

