/**
 * \file
 * The Contiki web browser configuration file.
 * \author Adam Dunkels <adam@dunkels.com>
 *
 */

/*
 * Copyright (c) 2002-2003, Adam Dunkels.
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution. 
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.  
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  
 *
 * This file is part of the Contiki desktop environment
 *
 * $Id: www-conf.h.example,v 1.4 2004/07/04 11:37:34 adamdunkels Exp $
 *
 */
#ifndef __WWW_CONF_H__
#define __WWW_CONF_H__

/**
 * The width of the web page viewing area, measured in characters.
 */
#define WWW_CONF_WEBPAGE_WIDTH 36

/**
 * The height of the web page viewing area, measured in characters.
 */
#define WWW_CONF_WEBPAGE_HEIGHT 17

/**
 * The size of the "Back" history.
 */
#define WWW_CONF_HISTORY_SIZE 4

/**
 * The maximum length of the URLs the web browser will handle.
 */
#define WWW_CONF_MAX_URLLEN 100

/**
 * The maxiumum number of widgets (i.e., hyperlinks, form elements) on
 * a single web page view.
 *
 * \note This does not limit the total number of widgets in a web
 * page, only the number of widget that are visible simultaneously.
 */
#define WWW_CONF_MAX_NUMPAGEWIDGETS 20

/**
 * Turns support for the \<center\> tag on or off, and must be on for
 * HTML forms to work.
 */
#define WWW_CONF_RENDERSTATE 1

/**
 * Toggles support for HTML forms.
 */
#define WWW_CONF_FORMS       1

/**
 * Maximum length of HTML form action URLs.
 */
#define WWW_CONF_MAX_FORMACTIONLEN  40

/**
 * Maximum length of HTML form name.
 */
#define WWW_CONF_MAX_FORMNAMELEN    20

/**
 * Maximum length of HTML form input name.
 */
#define WWW_CONF_MAX_INPUTNAMELEN   20

/**
 * Maximum length of HTML form input value.
 */
#define WWW_CONF_MAX_INPUTVALUELEN  (WWW_CONF_WEBPAGE_WIDTH - 1)

/**
 * The defaule home page.
 */
#define WWW_CONF_HOMEPAGE "http://contiki.c64.org/"

#endif /* __WWW_CONF_H__ */
