;; This example shows how to perform a directory of a disc
;; and extract the filenames. 
;;
;; This code is public domain and can freely be used in your
;; own programs.
;;
;; Written by Kevin Thacker. 2002



;;------------------------------------------------------------------

;; firmware function to catalog a disc or cassette
cas_catalog == 0xbc9b
;; firmware function to disable text output
txt_vdu_enable == 0xbb54
;; firmware function to enable text output
txt_vdu_disable == 0xbb57
;; firmware function to find a RSX 
kl_find_command == 0xbcd4

		.globl __readdir
		.area _CODE

;;------------------------------------------------------------------
;; find BIOS SET MESSAGE command
;; this is used to disable disc messages.
;; this is compatible with other DOSs that also provide this command
__readdir::

ld hl,#cmd_bios_set_message
call kl_find_command
ret nc

;; command found

;; store address of command
ld (bios_set_message),hl
ld a,c
;; store "rom select" of command
ld (bios_set_message+2),a

;;------------------------------------------------------------------

;; do CAT
ld hl,#2
add hl,sp
ld e,(hl)
inc hl
ld d,(hl)
call fetch_directory
ret


;;------------------------------------------------------------------
;; display files from data generated by CAS CATALOG function

;; perform a CAT command

fetch_directory::
push de
;; disable disc messages. Error messages will not be displayed.
ld a,#0xff
rst 0x018						;; KL FAR CALL
.dw bios_set_message

;; disable text output
call txt_vdu_disable

pop de

;; initialise in case of an error
xor a
ld (de),a

;; do catalog
call cas_catalog

;; enable text output
call txt_vdu_enable

;; enable disc messages. Error messages will be displayed
ld a,#0x0
rst 0x018						;; KL FAR CALL
.dw bios_set_message
ret


;;------------------------------------------------------------------

;; this is initialised when the "BIOS SET MESSAGE" RSX has been found.
bios_set_message:
.dw 0                    ;; address of function
.db 0                    ;; "rom select" for function


cmd_bios_set_message:
.db #0x01+#0x80				;; this is the "BIOS SET MESSAGE" RSX

