;; PCW bootstrap program (c) Kevin Thacker 2002
;; Source code released under the GNU Public License v2.

org &0000
write"pcwboot.bin"

jp start	
defs &38-3
ei
reti
defs &66-&3b
jp nmi_handler
defs &100-&68-1
;;ret			;; nmi
;;defs &100-&66
.start
di			
ld sp,&f000
im 1

;; setup ram. Reading/writing
ld a,&83
out (&f3),a
ld a,&82
out (&f2),a
ld a,&81
out (&f1),a
ld a,&80
out (&f0),a

;; turn off display
ld a,&00
out (&f7),a

;; copy accross bootstrap code
ld hl,boot_strap_start
ld de,&4800
ld bc,end_boot_strap-boot_strap
ldir
;; execute boot strap code
jp &4800

.boot_strap_start

;; boot strap code
org &4800
.boot_strap
;;;; setup nmi handler
;;ld a,&c3
;;ld hl,nmi_handler
;;ld (&0066),a
;;ld (&0067),hl

;; writing puts data to block 0, reading comes from bank 1 (but with bootstrap active it reads the rom code??)
;;ld a,&10
;;out (&f0),a

;; connect disc to no interrupt 
ld a,4
out (&f8),a

.retry_load
call wait_space
call load_sector

;; error gets to here
ld b,8
ld a,&80
.flash_screen
;; set invert/no invert
out (&f7),a
call wait_a_second
;; change invert state
xor &80
djnz flash_screen

jp retry_load

.wait_a_second
push bc
ld b,6*50
.was1
call wait_int
djnz was1
pop bc
ret


.wait_int
push af
push de
;; read current counter value - and clear it
in a,(&f4)

;; read value but don't clear this time
in a,(&f8)
ld e,a

;; wait for change
.wi1 in a,(&f8)
xor e
and &f
jr z,wi1
pop de
pop af
ret


.load_sector
;; disc motor on
ld a,9
out (&f8),a

;; delay - wait for motor to spin up.
ld b,3
ld hl,0
.d1 dec hl
ld a,h
or l
jr nz,d1
djnz d1

;; check drive ready state
call sense_drive_status
ret z

;; if it gets to here, it was ready...
call specify

;; seek to track 0
call recalibrate


;; read data 
ld a,&46			;;%010000110
call fdc_write
;; drive a - side 0
xor a
call fdc_write
;; track 0 (C)
xor a
call fdc_write
;; head (H)
xor a
call fdc_write
;; sector ID (R)
ld a,1 
call fdc_write
;; sector size (N)
ld a,2 
call fdc_write
;; sector ID (EOT)
ld a,1
call fdc_write
;; gap length
ld a,&4a
call fdc_write
; data length

;; connect disc interrupt to nmi interrupts
ld a,2
out (&f8),a


;; initialise address to write sector data to
ld hl,&F000

ld a,&ff
call fdc_write



;; each nmi will read a byte of data!

;; wait for result phase..
.rd1
in a,(0)
bit 5,a
jr nz,rd1


call result_phase

ld a,4
out (&f8),a

;; end boot strap
ld a,0
out (&f8),a

;; execute code
jp &f010

;;------------------------------------------
;; read data in result phase
.result_phase
ld c,0
;; still in execution phase?
.r1
in a,(c)
bit 5,a
jr nz,r1
ld hl,fdc_result


.r2
;; check if data ready
in a,(c)
add a,a
jr nc,r2
add a,a
jr nc,r2

;; get byte
inc c
in a,(c)
ld (hl),a
inc hl
dec c

;; small delay
ld a,5
.r3 dec a
jr nz,r3

;; still busy... continue fetching bytes
in a,(c)
bit 4,a
jr nz,r2
ret

.fdc_result defs 7

.nmi_handler
push af
;; execution phase?
in a,(&0)
bit 5,a
jr z,not_fdc
in a,(&01)
ld (hl),a
inc hl
.not_fdc
pop af
retm


;; ---------------------
;; write command byte to fdc

.fdc_write
ld c,0
push af
in a,(c)
add a,a
jr nc,fdc_w4
add a,a
jr nc,fdc_w2
.fdc_w4
pop af
ret

.fdc_w2
pop af
;; write byte
inc c
out (c),a
dec c
;; delay
ld a,5
.fdc_w3
dec a
jr nz,fdc_w3
ret

;; -------------------------
;; move drive head to track 0

.recalibrate
;; seek to track 0
ld a,7
call fdc_write
;; drive 0
xor a
call fdc_write
ld c,&f8
.rc1
in a,(c)
bit 5,a
jr z,rc1
;; sense interrupt status
ld a,8
call fdc_write
call result_phase
ret

.sense_drive_status
ld a,4
call fdc_write
xor a
call fdc_write
call result_phase
;; isolate ready state
ld a,(fdc_result)
and &20
ret


.wait_space
push af
push de
push hl

;; page 3 mapped into &c000-&ffff
ld hl,&c000+&3ff5

;; get current key state
ld a,(hl)
ld e,a

.ws1 
ld a,(hl)
ld d,a
xor e
and &80
jr z,ws1
;; make sure key was pressed..
ld a,d
and &80
jr z,ws1
pop hl
pop de
pop af
ret

.specify
ld a,3
call fdc_write
ld a,&ef
call fdc_write
ld a,&3
call fdc_write
ret


.end_boot_strap
