	
;;------------------------------------
;; display a string on-screen
.print_string
	ld a,(hl)
	or a
	ret z
	call show_char
	jr print_string
 
;;-----------------------------------
;; set screen address to render chars at
.get_coord_addr
	push de
	push bc
	push hl

	push hl
	ld l,h
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl		; x8
	ld e,l
	ld d,h
	pop hl			; DE = byte offset for X

	ld h,0
	ld c,l
	ld b,h
	add hl,hl		; x2
	add hl,hl		; x4
	add hl,hl		; x8
	add hl,bc		; x9
	add hl,hl		; 
	add hl,hl		; 
	add hl,hl		;
	add hl,hl		; x&90
					; HL = byte offset for Y
	add hl,de		; final offset
	ld de,(scr_base)
	add hl,de
	ld (coord_addr),hl
	pop hl
	pop bc
	pop de
	ret

;;----------------------------------------
;; update position after drawing a char
.update_coords
	ld a,(x_coord)
	inc a
	ld (x_coord),a
	cp 90
	jr c,uc1
	xor a
	ld (x_coord),a

	ld a,(y_coord)
	inc a
	ld (y_coord),a
	cp 32
	jr c,uc1
	xor a
	ld (y_coord),a
.uc1
	ret

;;----------------------------------------
;; set coordinates - locks to valid range
.set_coords
	ld a,h
	cp 90
	jr c,sc1
	ld a,90-1
.sc1
	ld (x_coord),a
		
	ld a,l
	cp 32
	jr c,sc2

.sc2
	ld (y_coord),a
	
.show_char
	push hl
	push bc
	push de
	push af

	cp 20
	jr c,ctrl_char
	call plot_char

	call update_coords
	
	pop af
	pop de
	pop bc 
	pop hl

	ret

	

;;----------------------------------------------------------------
;; render a char at the current coordinates 
;; a = char to draw
.plot_char
	ld hl,(coords)
	call get_coord_addr

	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld de,font_gfx
	add hl,de
	ex de,hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	
	ld a,(de)
	ld (hl),a
	inc hl
	ret

;;---------------------------------------------------

.welcome
	defb "PCW Boot-Strap program by Kevin Thacker. 22-May-2000",13,10,13,10
	defb "Please insert disk and press SPACE.", 13,10,13,10,0

.font_gfx

.coords
.y_coord
	defb 0
.x_coord
	defb 0

.coord_addr
	defw 0
.scr_base
	defw 0
