#include <stdio.h>
#include <stdlib.h>

#define min(a,b) \
	(a<b) ? a : b


int main(int argc, char *argv[])
{
	FILE *fh;
	
	if (argc!=2)
	{
		fprintf(stdout,"Usage:\ndatamaker <filename>\n");
		return 1;
	}
	
	fh = fopen(argv[1],"rb");
	
	if (fh!=NULL)
	{
		unsigned long end;
		unsigned long start;
		unsigned long length;
		unsigned char *buffer;
		
		fseek(fh,0,SEEK_SET);
		start = ftell(fh);
		
		fseek(fh,0,SEEK_END);
		end = ftell(fh);	
	
		fseek(fh, 0,SEEK_SET);
		
		length = end - start;
	
		buffer = malloc(length);
		
		if (buffer!=NULL)
		{
			if (fread(buffer, 1, length, fh)==length)
			{
				unsigned char *pos = buffer;
		
				/* ok, read the file, now start outputting data to stdout */	
						
				while (length!=0)
				{
					int bytesThisRow = min(length, 16);
					int i;
					
					fprintf(stdout,"defb ");
					for (i = 0; i<bytesThisRow; i++)
					{
						if (i!=0)
						{
							fprintf(stdout,",");
						}
						fprintf(stdout,"&%02x",pos[0]);
						pos++;
						
					}
					fprintf(stdout,"\n");
				
					length = length - bytesThisRow;	
				}
				
				
			}
			free(buffer);
		}
	
		fclose(fh);
	}

  	return 0;
}
