
;; MYMPLAY - Player for MYM-tunes
;; CPC-specific code  by Morpheus 2.2.2000
;; Original MSX version by Marq/Lieves!Tuore & Fit 30.1.2000
;;
;; Source suitable for Maxam

.FRAG    equ    128     ;; Fragment size
.REGS    equ    14      ;; Number of PSG registers
.FBITS   equ    7       ;; Bits needed to store fragment offset

;; Amstrad CPC Firmware calls
.CAS_IN_OPEN     equ    &bc77  ;; Open file
.CAS_IN_DIRECT   equ    &bc83  ;; read all of input 
.CAS_IN_CLOSE    equ    &bc7a  ;; close input file
.TXT_OUTPUT      equ    &bb5a  ;; output char

 org    &1000  ;; don't put it too low, because basic will not be able to load it
 nolist
 write"mymplay.bin"

.main   call    readfile        ;; Read the file in
        jr      nc,loadok
        ret                     ;; Load error, exit

.loadok call    showinfo        ;; Print a message
  
;; CPC specific
;; requires DI here because firmware uses BC',AF',HL'
;; and changing these when interrupts are enabled
;; is bad.            
di
exx     ;; push alternative register set, so we can
push bc ;; return to BASIC properly
push de
push hl
exx
ex af,af'
push af
ex af,af'
        
        exx                     ;; Starting values for procedure readbits
        ld      e,1
        ld      d,0
        ld      hl,data
        exx

        ld      hl,uncomp       ;; Starting values for the playing variables
        ld      (dest1),hl
        ld      hl,2*FRAG+uncomp
        ld      (dest2),hl
        ld      (psource),hl
        ld      a,FRAG
        ld      (played),a
        ld      hl,0
        ld      (prows),hl

        call    extract         ;; Unpack the first fragment

        ld      hl,interrupt    ;; Set our new interrupt handler
        call    setint

.mainloop
        call    extract

.waitvb ld      a,(played)      ;; Wait until VBI has played a fragment
        or      a
        jr      nz,waitvb

        ld      (psource),iy
        ld      a,FRAG
        ld      (played),a

;;        jr mainloop
        call    keypress        ;; End if key pressed
      jr      nz,mainloop

;; CPC specific
;; restore alternative register set
;; so we can return to basic properly
ex af,af'
pop af
ex af,af'
exx
pop hl
pop de
pop bc
exx

        ld      hl,(oldint)     ;; Restore the old interrupt
        call    setint
        call    shutup



        ret                     ;; Goodbye!

;; *** Unpack a fragment. Returns IY=new playing position for VBI
.extract

        ld      a,0
.regloop
        push    af
        ld      c,a
        ld      b,0
        ld      hl,regbits      ;; D=Bits in this PSG register
        add     hl,bc
        ld      d,(hl)
        ld      hl,current      ;; E=Current value of a PSG register
        add     hl,bc
        ld      e,(hl)

        ld      bc,FRAG*4
        ld      hl,(dest1)      ;; IX=Destination 1
        ld      ix,(dest1)
        add     hl,bc
        ld      (dest1),hl
        ld      hl,(dest2)      ;; HL=Destination 2
        push    hl
        add     hl,bc
        ld      (dest2),hl
        pop     hl

        ex      af,af'
        ld      a,FRAG          ;; AF'=fragment end counter
        ex      af,af'
        ld      a,1             ;; Get fragment bit
        call    readbits
        or      a
        jr      nz,compfrag     ;; 1=Compressed fragment, 0=Unchanged

        ld      b,FRAG          ;; Unchanged fragment: just set all to E
.sweep  ld      (hl),e
        inc     hl
        ld      (ix),e
        inc     ix
        djnz    sweep
        jp      nextreg

.compfrag                       ;; Compressed fragment
        ld      a,1
        call    readbits
        or      a
        jr      nz,notprev      ;; 0=Previous register value, 1=raw/compressed

        ld      (hl),e          ;; Unchanged register
        inc     hl
        ld      (ix),e
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

.notprev
        ld      a,1
        call    readbits
        or      a
        jr      z,packed        ;; 0=compressed data, 1=raw data

        ld      a,d             ;; Raw data, read regbits[i] bits
        call    readbits
        ld      e,a
        ld      (hl),a
        inc     hl
        ld      (ix),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

.packed ld      a,FBITS         ;; Reference to previous data:
        call    readbits        ;; Read the offset
        ld      c,a
        ld      a,FBITS         ;; Read the number of bytes
        call    readbits
        ld      b,a

        push    hl
        push    bc
        ld      bc,-FRAG
        add     hl,bc
        pop     bc
        ld      a,b
        ld      b,0
        add     hl,bc
        ld      b,a
        push    hl
        pop     iy              ;; IY=source address
        pop     hl

        inc     b
.copy   ld      a,(iy)          ;; Copy from previous data
        inc     iy
        ld      e,a             ;; Set current value
        ld      (hl),a
        inc     hl
        ld      (ix),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        djnz    copy

.nextbit
        ex      af,af'          ;; If AF'=0 then fragment is done
        ld      c,a
        ex      af,af'
        ld      a,c
        or      a
        jp      nz,compfrag

.nextreg
        pop     af
        ld      b,0             ;; Save the current value of PSG reg
        ld      c,a
        push    hl
        ld      hl,current
        add     hl,bc
        ld      (hl),e
        pop     hl

        inc     a               ;; Check if all registers are done
        cp      REGS
        jp      nz,regloop

        or      a               ;; Check if dest2 must be wrapped
        ld      bc,rows
        sbc     hl,bc
        jr      nz,nowrap

        ld      ix,uncomp
        ld      hl,2*FRAG+uncomp
        ld      iy,3*FRAG+uncomp
        jr      endext

.nowrap ld      ix,FRAG+uncomp
        ld      hl,3*FRAG+uncomp
        ld      iy,2*FRAG+uncomp

.endext ld      (dest1),ix
        ld      (dest2),hl

        ld      bc,FRAG         ;; Check end-of-file. Clumsy :v/
        ld      hl,(prows)
        add     hl,bc
        ld      (prows),hl
        ld      bc,(rows)
        or      a
        sbc     hl,bc
        jr      c,noend         ;; If rows>played rows then exit
        exx                     ;; Otherwise restart
        ld      e,1
        ld      d,0
        ld      hl,data
        exx
        ld      hl,0
        ld      (prows),hl

.noend  
ret

;; *** Reads A bits from data, returns bits in A
.readbits
        exx
        ld      b,a
        ld      c,0

.onebit sla     c               ;; Get one bit at a time
        rrc     e
        jr      nc,nonew        ;; Wrap the AND value
        ld      d,(hl)
        inc     hl

.nonew  ld      a,e
        and     d
        jr      z,zero
        inc     c
.zero   djnz    onebit

        ld      a,c
        exx
        ret

;; *** The interrupt handler. Partially CPC specific
.interrupt
        di
        push    af
        push    bc
        push    de
        push    hl
 
   ;; Amstrad has interrupts every 52 scanlines
   ;; which works out at 6 interrupts per screen
        ;; If interrupts are not delayed, then there will
   ;; always be one interrupt that occurs 2 lines into the VBL

   ;; check for VBL
   ld b,&f5
   in a,(c)
   rra
   jr nc,endint


        ld      hl,(psource)
        ld      bc,4*FRAG-1   ;; Bytes to skip before next reg-1
        xor     a

.ploop  
        ld     e,(hl)
   call psg_write
        inc     a
        add     hl,bc
        cp      REGS-1
        jr      nz,ploop

        ld      a,(hl)
        cp      &ff           ;; If reg 13 is FF then don't output
        jr      z,notrig
        ld      e,a
        ld      a,13
        call    psg_write

.notrig ld      hl,(psource)
        inc     hl
        ld      (psource),hl

        ld      a,(played)
        or      a
        jr      z,endint
        dec     a
        ld      (played),a

.endint pop     hl
        pop     de
        pop     bc
        pop     af
        ei
        ret

;; *** Sets a new interrupt handler pointed by HL. CPC-specific
.setint
        di
        ld      bc,(&38+1)
        ld      (oldint),bc
        ld      (&38+1),hl
        ld      a,&c3
        ld      (&38),a
        ei
        ret

;; *** Reads a file specified when called e.g. CALL &100,"DEMO3.MYM"
;; BASIC will setup IX and A.
;; IX points to parameters. A = parameter count
;;
;; (IX+0, IX+1) is last parameter, (IX+2, IX+3) is second from last etc.

.readfile
          ;; check number of parameters is ok
          cp 1
          jr nz,loadfail

          ;; get address of parameter.
          ;; for a string, the parameter will point to string
          ;; descriptor block.
          ;;
          ;; string descriptor block format:
          ;; byte 0 = length of string in chars
          ;; byte 1,2 = address of string in memory

          ld l,(ix+0)
          ld h,(ix+1)

          ld b,(hl)     ;; get string length
          inc hl
          ld a,(hl)
          inc hl
          ld h,(hl)     ;; get string address
          ld l,a
          ld de,&c000  ;; address of 2k read buffer
          call CAS_IN_OPEN
          ;;jr c,loadfail

          ;; setup address to load file to
          ld hl,rows
          call CAS_IN_DIRECT
          ;;jr c,loadfail

          ;; close input file
          call CAS_IN_CLOSE

          or a
          ret
.loadfail
          scf
          ret

;; *** Writes data to AY-3-8912. CPC-specific
;; A = register index, E = data.
;; The AY-3-8910 is accessed through the 8255 PPI
;; at address f6xx, and f4xx.
.psg_write
        push bc
     ld b,&f4        ;; specify register
        out (c),a
      
       ld bc,&f6c0     ;; PSG write register
        out (c),c
        ld bc,&f600     ;; PSG inactive
        out (c),c
        ld b,&f4
        out (c),e
              
        ld bc,&f680     ;; PSG write data
        out (c),c
        ld bc,&f600     ;; PSG inactive
        out (c),c
        pop bc
        ret

;; *** Prints an info string. CPC-specific
showinfo:
        ld hl,info
si2:    ld a,(hl)
   or a
   ret z        
   inc hl
        call TXT_OUTPUT
        djnz si2
        ret

;; *** Returns Z=0 if key pressed. CPC-specific
;;
;; reading the keyboard on the CPC requires a lot of work.
;; The keyboard is connected to the PPI and PSG port A.
;; Specify the keyboard line with the PPI, and then read the data from the PSG.

keypress:
        di

   ;; tell PSG we are accessing register 14
   ld bc,&f40e ;; write PSG register 14
   out (c),c 
   ld bc,&f6c0 ;; PSG specify register operation
   out (c),c
   ld bc,&f600 ;; inactive
   out (c),c
  
   ld bc,&f792 ;; tell PPI to set port A to input (so data can be read from PSG)
   out (c),c   
 
   ;; tell PSG we are reading from register 14
   ld bc,&f648 ;; PSG read operation + specify keyboard line 8
   out (c),c
   ld b,&f4
   in a,(c)  ;; read the data for line 8

   ld bc,&f600 ;; inactive
   out (c),c
        
   ld bc,&f782 ;; tell PPI to set port A to output (so data can be written to PSG)
   out (c),c
   bit 2,a  ;; check escape key was pressed. nz=not pressed, z = pressed

   ei
   ret

;; *** Shuts down the audio. CPC-specific
shutup:
        ld      d,14    ;; count
        ld      a,0     ;; start reg index
        ld      e,0     ;; data

shloop:
        call psg_write  ;; write reg
        inc a
        dec d
        jr nz,shloop
        ret

;; *** Program data
oldint: defw     0       ;; Old int handler
played: defb     0       ;; VBI counter
dest1:  defw     0       ;; Uncompress destination 1
dest2:  defw     0       ;; - " -                  2
psource: defw    0       ;; Playing offset for the VB-player
prows:  defw     0       ;; Rows played so far

info    defb     "MYM player 0.3 "
        defb     "by Morpheus",13,10
        defb     "Press Esc to exit...",13,10,0

;; Bits per PSG register
.regbits defb    8,4,8,4,8,4,5,8,5,5,5,8,8,8
;; Current values of PSG registers
.current defb    0,0,0,0,0,0,0,0,0,0,0,0,0,0

;; Reserve room for uncompressed data
.uncomp
defs 4*FRAG*REGS

;; The tune is stored here
.rows   defw     0
.data

.end
