
; MYMPLAY - Player for MYM-tunes
; MSX-version by Marq/Lieves!Tuore & Fit 30.1.2000
:
; 1.2.2000  - Added the disk loader. Thanks to Yzi & Plaque for examples.
;
; Source suitable for Table-driven assembler (TASM), sorry all
; Devpac freaks :v/

FRAG    .equ    128     ; Fragment size
REGS    .equ    14      ; Number of PSG registers
FBITS   .equ    7       ; Bits needed to store fragment offset
FCB     .equ    05ch    ; FCB Address. MSX specific.

.org    100h

main:   call    readfile        ; Read the file in
        jr      nz,loadok
        ret                     ; Load error, exit

loadok: call    showinfo        ; Print a message

        exx                     ; Starting values for procedure readbits
        ld      e,1
        ld      d,0
        ld      hl,data
        exx

        ld      hl,uncomp       ; Starting values for the playing variables
        ld      (dest1),hl
        ld      hl,(2*FRAG)+uncomp
        ld      (dest2),hl
        ld      (psource),hl
        ld      a,FRAG
        ld      (played),a
        ld      hl,0
        ld      (prows),hl

        call    extract         ; Unpack the first fragment

        ld      hl,interrupt    ; Set our new interrupt handler
        call    setint

mainloop:
        call    extract

waitvb: ld      a,(played)      ; Wait until VBI has played a fragment
        or      a
        jr      nz,waitvb

        ld      (psource),iy
        ld      a,FRAG
        ld      (played),a

        call    keypress        ; End if key pressed
        jr      nz,mainloop

        ld      hl,(oldint)     ; Restore the old interrupt
        call    setint
        call    shutup

        ret                     ; Goodbye!

; *** Unpack a fragment. Returns IY=new playing position for VBI
extract:
        ld      a,0
regloop:
        push    af
        ld      c,a
        ld      b,0
        ld      hl,regbits      ; D=Bits in this PSG register
        add     hl,bc
        ld      d,(hl)
        ld      hl,current      ; E=Current value of a PSG register
        add     hl,bc
        ld      e,(hl)

        ld      bc,FRAG*4
        ld      hl,(dest1)      ; IX=Destination 1
        ld      ix,(dest1)
        add     hl,bc
        ld      (dest1),hl
        ld      hl,(dest2)      ; HL=Destination 2
        push    hl
        add     hl,bc
        ld      (dest2),hl
        pop     hl

        ex      af,af'
        ld      a,FRAG          ; AF'=fragment end counter
        ex      af,af'
        ld      a,1             ; Get fragment bit
        call    readbits
        or      a
        jr      nz,compfrag     ; 1=Compressed fragment, 0=Unchanged

        ld      b,FRAG          ; Unchanged fragment: just set all to E
sweep:  ld      (hl),e
        inc     hl
        ld      (ix),e
        inc     ix
        djnz    sweep
        jp      nextreg

compfrag:                       ; Compressed fragment
        ld      a,1
        call    readbits
        or      a
        jr      nz,notprev      ; 0=Previous register value, 1=raw/compressed

        ld      (hl),e          ; Unchanged register
        inc     hl
        ld      (ix),e
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

notprev:
        ld      a,1
        call    readbits
        or      a
        jr      z,packed        ; 0=compressed data, 1=raw data

        ld      a,d             ; Raw data, read regbits[i] bits
        call    readbits
        ld      e,a
        ld      (hl),a
        inc     hl
        ld      (ix),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

packed: ld      a,FBITS         ; Reference to previous data:
        call    readbits        ; Read the offset
        ld      c,a
        ld      a,FBITS         ; Read the number of bytes
        call    readbits
        ld      b,a

        push    hl
        push    bc
        ld      bc,-FRAG
        add     hl,bc
        pop     bc
        ld      a,b
        ld      b,0
        add     hl,bc
        ld      b,a
        push    hl
        pop     iy              ; IY=source address
        pop     hl

        inc     b
copy:   ld      a,(iy)          ; Copy from previous data
        inc     iy
        ld      e,a             ; Set current value
        ld      (hl),a
        inc     hl
        ld      (ix),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        djnz    copy

nextbit:
        ex      af,af'          ; If AF'=0 then fragment is done
        ld      c,a
        ex      af,af'
        ld      a,c
        or      a
        jp      nz,compfrag

nextreg:
        pop     af
        ld      b,0             ; Save the current value of PSG reg
        ld      c,a
        push    hl
        ld      hl,current
        add     hl,bc
        ld      (hl),e
        pop     hl

        inc     a               ; Check if all registers are done
        cp      REGS
        jp      nz,regloop

        or      a               ; Check if dest2 must be wrapped
        ld      bc,rows
        sbc     hl,bc
        jr      nz,nowrap

        ld      ix,uncomp
        ld      hl,(2*FRAG)+uncomp
        ld      iy,(3*FRAG)+uncomp
        jr      endext

nowrap: ld      ix,FRAG+uncomp
        ld      hl,(3*FRAG)+uncomp
        ld      iy,(2*FRAG)+uncomp

endext: ld      (dest1),ix
        ld      (dest2),hl

        ld      bc,FRAG         ; Check end-of-file. Clumsy :v/
        ld      hl,(prows)
        add     hl,bc
        ld      (prows),hl
        ld      bc,(rows)
        or      a
        sbc     hl,bc
        jr      c,noend         ; If rows>played rows then exit
        exx                     ; Otherwise restart
        ld      e,1
        ld      d,0
        ld      hl,data
        exx
        ld      hl,0
        ld      (prows),hl

noend:  ret

; *** Reads A bits from data, returns bits in A
readbits:
        exx
        ld      b,a
        ld      c,0

onebit: sla     c               ; Get one bit at a time
        rrc     e
        jr      nc,nonew        ; Wrap the AND value
        ld      d,(hl)
        inc     hl

nonew:  ld      a,e
        and     d
        jr      z,zero
        inc     c
zero:   djnz    onebit

        ld      a,c
        exx
        ret

; *** The interrupt handler. Partially MSX specific
interrupt:
        push    af
        push    bc
        push    de
        push    hl

        in      a,(99h)         ; Interrupt Acknowledge

        ld      c,0a1h
        ld      hl,(psource)
        ld      de,(4*FRAG)-1   ; Bytes to skip before next reg-1
        xor     a

ploop:  out     (0a0h),a        ; Output all registers
        outi
        inc     a
        add     hl,de
        cp      REGS-1
        jr      nz,ploop

        ld      a,0ffh
        cp      (hl)            ; If reg 13 is FF then don't output
        jr      z,notrig
        ld      a,13
        out     (0a0h),a
        outi

notrig: ld      hl,(psource)
        inc     hl
        ld      (psource),hl

        ld      a,(played)
        or      a
        jr      z,endint
        dec     a
        ld      (played),a

endint: pop     hl
        pop     de
        pop     bc
        pop     af
        ei
        reti

; *** Sets a new interrupt handler pointed by HL. MSX-specific
setint:
        di
        ld      bc,(38h+1)
        ld      (oldint),bc
        ld      (38h+1),hl
        ld      a,0c3h
        ld      (38h),a
        ei
        ret

; *** Reads a file given on the command line. MSX-specific.
;     Returns Z=0 if success. Trashes registers, but that's ok.
readfile:
        ld      de,FCB+12       ; Clear the end of FCB
        ld      b,24
        xor     a
clrend: ld      (de),a
        inc     de
        djnz    clrend

        ld      de,FCB
        ld      c,0fh           ; Open file
        call    5
        or      a
        jr      z,openok
        and     0               ; Return with error
        ret

openok: xor     a               ; Clear block/record fields
        ld      (FCB+12),a
        ld      (FCB+13),a
        ld      (FCB+32),a

        ld      de,rows         ; Read dest address
readloop:
        push    de
        ld      de,FCB
        ld      c,014h          ; Sequential read
        call    5
        pop     de
        or      a               ; If A<>0 then the file is over
        jr      nz,eof
        ld      hl,080h
        ld      bc,128          ; Record size (default)
        ldir
        jr      readloop

eof:    ld      de,FCB
        ld      c,010h          ; Close file
        call    5
        or      1               ; Return with ok
        ret

; *** Prints an info string. MSX-specific
showinfo:
        ld      de,info
        ld      c,9
        call    5
        ret

; *** Returns Z=0 if key pressed. MSX-specific
keypress:
        di
        in      a,(0aah)
        and     0f0h
        or      7
        out     (0aah),a
        in      a,(0a9h)
        bit     2,a
        ei
        ret

; *** Shuts down the audio. MSX-specific
shutup:
        ld      b,14
        ld      a,0
        ld      c,0a1h
        ld      d,0
shloop: out     (0a0h),a
        inc     a
        out     (c),d
        djnz    shloop
        ret

; *** Program data
oldint: .dw     0       ; Old int handler
played: .db     0       ; VBI counter
dest1:  .dw     0       ; Uncompress destination 1
dest2:  .dw     0       ; - " -                  2
psource: .dw    0       ; Playing offset for the VB-player
prows:  .dw     0       ; Rows played so far

info    .db     "MYM player 0.3 "
        .db     "by Marq/Lieves!Tuore",13,10
        .db     "Press Esc to exit...",13,10,"$"

; Bits per PSG register
regbits: .db    8,4,8,4,8,4,5,8,5,5,5,8,8,8
; Current values of PSG registers
current: .db    0,0,0,0,0,0,0,0,0,0,0,0,0,0

; Reserve room for uncompressed data
uncomp:
.org $+(4*FRAG*REGS)

; The tune is stored here
rows:   .dw     0
data:

.end
       bit     2,a
        ei
        ret

; *** Shuts down the audio. MSX-specific
shutup:
