;; File: crt0.s
;; Generic crt0.s for a Z80
;; From SDCC..
;; Modified to suit execution on the Amstrad CPC!
;; by H. Hansen 2003
;;
;; Furthur modified by Kevin Thacker to add BASIC stub
    .module crt0
	.globl	_main

	.area _HEADER (ABS)

	.org 	0x170	;; Load address for BASIC programs.
	
	;; Tokenized BASIC stub:
	;;
	;; 10 CALL &17C

	.dw 10		;; Line length in bytes
	.dw 10		;; Line number	
	.db 0x83	;; 'CALL' keyword
	.db 0x020	;; space character
	.db 0x01c	;; 16-bit hexidecimal integer number follows
	.dw 0x017c	;; memory address to execute 
	.db 0		;; end of line marker
	.dw 0		;; end of BASIC file

	;; Binary program continues from here (0x017c)
	
init:
	;; Initialise global variables
    	call    gsinit
	call	_main
	jp	_exit

	;; Ordering of segments for the linker.
	.area	_HOME
	.area	_CODE
    .area   _GSINIT
    .area   _GSFINAL
        
	.area	_DATA
    .area   _BSS
    .area   _HEAP

   .area   _CODE
__clock::
;;	ld		a,#2
;;  rst     0x08
	ret
	
_exit::
	ret
	
	.area   _GSINIT
gsinit::	

    .area   _GSFINAL
    ret
