/* 
* This program will generate a link-z80 compatible .lnk file.
*
* link-z80 is the linker program that comes with SDCC and targets 
* the Z80 CPU. 
*
* The Z80 CPU is used by the Amstrad CPC
*
* Released under GNU Public Licence v2.
* (c) Copyright Kevin Thacker, September 2004 
*/

#include <stdio.h>
#include <stdlib.h>

#include <getopt.h>

#ifndef NULL
#define NULL 0
#endif

int main(int argc, char **argv)
{
	int result = -1;
	int generateMap = 0;	/* generate map file */
	int updateListing = 0;	/* update listing files with link data */
	int nogmbSymbols = 0;	/* no$gmb symbols */
	int hexMap = 0;		/* hex map */
	int decimalMap = 0;	/* decimal map */
	int octalMap = 0;	/* octal map */

	int i;
	int c;


	char *outputFile = NULL;	/* name of output file */

	char **objectFiles = NULL;	/* list of object files */
	int objectFileCount = 0;	/* number of object files */

	char **libraryPaths = NULL;	/* list of library paths */
	int libraryPathCount = 0;	/* number of library paths */

	char **libraryFiles = NULL;	/* list of library files */
	int libraryFileCount = 0;	/* number of library files */

	char **definesList = NULL;	/* list of defines */
	int definesCount = 0;		/* number of defines */

	if (argc<=1)
	{
		result = -1;
		goto quit;
	}
	
	/* potentially all the parameters could be object files */	
	objectFiles = malloc(sizeof(char *)*argc);

	if (objectFiles==NULL)
	{
		result = -2;
		goto quit;
	}

	libraryFiles = malloc(sizeof(char *)*argc);

	if (libraryFiles==NULL)
	{
		result = -2;
		goto quit;
	}

	libraryPaths = malloc(sizeof(char *)*argc);	

	if (objectFiles==0)
	{
		result = -2;
		goto quit;
	}

	definesList = malloc(sizeof(char *)*argc);	

	if (definesList==0)
	{
		result = -2;
		goto quit;
	}

	optind = 1;
	
	/* look for output file, defined with -o option */
	do
	{
		c = getopt(argc, argv,"b:djk:l:mo:qux");
		switch (c)
		{
			case 'b':
			{
				definesList[definesCount] = optarg;
				definesCount++;
			}	
			break;

			case 'o':
			{
				outputFile = optarg;
			}
			break;

			case 'k':
			{
				libraryPaths[libraryPathCount] = optarg;
				libraryPathCount++;
			}
			break;

			case 'l':
			{
				libraryFiles[libraryFileCount] = optarg;
				libraryFileCount++;
			}
			break;

			case 'm':
			{
				generateMap = 1;
			}
			break;

			case 'u':
			{
				updateListing = 1;
			}
			break;
		
			case 'j':
			{
				nogmbSymbols = 1;
			}
			break;

			case 'x':
			{
				hexMap = 1;
			}
			break;

			case 'd':
			{
				decimalMap = 1;
			}
			break;

			case 'q':
			{
				octalMap = 1;
			}
			break;

			case ':':
			case '?':
			{
				result = -3;
				goto quit;
			}
			break;

			default:
				break;
		}
	}
	while (c!=-1);

	for (i=optind; i<argc; i++)
	{
		objectFiles[objectFileCount] = argv[i];
		objectFileCount++;
	}		

	/* look for library files, defined with -l option */
	fprintf(stdout,"-i");
	
	/* generate map? */
	if (generateMap)
		fputc('m',stdout);

	/* update listing? */
	if (updateListing)
		fputc('u',stdout);

	if (hexMap)
		fputc('x',stdout);
	
	if (decimalMap)
		fputc('d',stdout);

	if (octalMap)
		fputc('q',stdout);
		
	if (nogmbSymbols)
		fputc('j',stdout);

	/* seperate options from output file */
	fputc(' ',stdout);

	if (outputFile)
	{
		fprintf(stdout,outputFile);
	}
	else
	{
		fprintf(stdout,"a.out");
	}

	fprintf(stdout,"\n");

	/* library paths */
	for (i=0; i<libraryPathCount; i++)
	{
		fprintf(stdout,"-k %s\n",libraryPaths[i]);
	}

	/* library files */	
	for (i=0; i<libraryFileCount; i++)
	{
		fprintf(stdout,"-l %s\n",libraryFiles[i]);
	}

	/* defines */
	for (i=0; i<definesCount; i++)
	{	
		fprintf(stdout,"-b %s\n",definesList[i]);
	}


	/* output object files */
	for (i=0; i<objectFileCount; i++)
	{
		fprintf(stdout,"%s\n",objectFiles[i]);

	}

	fprintf(stdout,"\n");
	fprintf(stdout,"-e\n");	

	result = 0;

quit:
	if (objectFiles!=NULL)
		free(objectFiles);

	if (libraryFiles!=NULL)
		free(libraryFiles);

	if (libraryPaths!=NULL)
		free(libraryPaths);

	if (definesList!=NULL)
		free(definesList);

	exit(result);
	return result;

}

