/* 
 *  Art Studio Picture Viewer (c) Copyright, Kevin Thacker 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "amsdos.h"

/****************************************************************************/
/* AMSDOS helper functions */

/* calculate checksum as AMSDOS would for the first 66 bytes of a datablock */
/* this is used to determine if a file has a AMSDOS header */
unsigned int AMSDOS_CalculateChecksum(const unsigned char *pHeader)
{
        unsigned int Checksum;
        int i;

        Checksum = 0;

        for (i=0; i<67; i++)
        {
                unsigned int CheckSumByte;

                CheckSumByte = pHeader[i] & 0x0ff;

                Checksum+=CheckSumByte;
        }

        return Checksum;
}

BOOL     AMSDOS_HasAmsdosHeader(const unsigned char *pHeader)
{
        unsigned int CalculatedChecksum;
        unsigned int ChecksumFromHeader;

        CalculatedChecksum = AMSDOS_CalculateChecksum(pHeader);

        ChecksumFromHeader = (pHeader[67] & 0x0ff) |
                                                (pHeader[68] & 0x0ff)<<8;

        if (ChecksumFromHeader == CalculatedChecksum)
                return TRUE;

        return FALSE;
}
