/* 
 *  Art Studio Picture Viewer (c) Copyright, Kevin Thacker 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include "filehelp.h"
#include <string.h>

BOOL	LoadFile(const char *pFilename, unsigned char **ppAddr, unsigned long *pLength)
{
	FILE *fh;
	BOOL bSuccess = FALSE;

	*ppAddr = NULL;
	*pLength = 0;

	fh = fopen(pFilename,"rb");

	if (fh!=NULL)
	{
		char *pAddr;
		size_t Length;
		size_t Current;

		Current = ftell(fh);
		fseek(fh,0, SEEK_END);
		Length = ftell(fh);
		fseek(fh, Current,SEEK_SET);

		if (Length!=0)
		{
			pAddr = (char *)malloc(Length);	

			if (pAddr)
			{
				if (fread(pAddr, 1, Length, fh)==Length)
				{
					*ppAddr = pAddr;
					*pLength = Length;
					bSuccess = TRUE;
				}
			}
		}
		else
		{
			bSuccess = TRUE;
		}

		fclose(fh);
	}

	return bSuccess;
}

int GetExtensionLength(const char *pInputFilename)
{
	size_t StringLength = strlen(pInputFilename);
	size_t Position = StringLength-1;
	size_t ExtensionLength = 0;

	while (Position!=0)
	{
		char ch;

		ch = pInputFilename[Position];

		if (ch=='.')
			break;

		Position--;
	}

	if (Position==0)
		return 0;

	return StringLength-Position-1;
}

char *ChangeExtension(const char *pInputFilename, const char *pNewExtension)
{
	size_t ExtensionLength;
	size_t NewExtensionLength;
	size_t StringLength;
	char *pOutputString;

	/* length of entire filename */
	StringLength = strlen(pInputFilename);
	/* length of extension on input filename */
	ExtensionLength = GetExtensionLength(pInputFilename);
	/* length of new extension */
	NewExtensionLength = strlen(pNewExtension);

	if (ExtensionLength==0)
	{
		/* input filename doesn't have an extension */
		pOutputString = malloc(StringLength + 1 + NewExtensionLength + 1);

		if (pOutputString!=NULL)
		{
			memcpy(pOutputString, pInputFilename,StringLength+1);
			strcat(pOutputString, ".");
			strcat(pOutputString, pNewExtension);
		
			return pOutputString;
		}
	}
	else
	{
		size_t AllocLength;

		AllocLength = StringLength; 
		if (NewExtensionLength>ExtensionLength)
			AllocLength += NewExtensionLength - ExtensionLength;

		pOutputString = malloc(AllocLength+1);

		if (pOutputString!=NULL)
		{
			memcpy(pOutputString, pInputFilename, StringLength-ExtensionLength);
			pOutputString[StringLength-ExtensionLength] = '\0';
			strcat(pOutputString, pNewExtension);

			return pOutputString;
		}
	}

	return NULL;
}
