;MINI CASSETTE SAVE AND LOAD - AMSTRAD CPC
;COPYRIGHT 1989 SPEEDLOCK ASSOCIATES
;TEL: 0793 870525 OR 0734 470303

;**** MULTI-LOAD BLOCK LOADER ****

START:	   EQU #8000
LENGTH:	   EQU #2000

              ORG 4000H     ;CAN BE ANYWHERE

MAIN:         DI            ;INTERRUPTS MUST BE DISABLED
              LD HL,START   ;START ADDRESS OF CODE BLOCK
              LD DE,LENGTH  ;LENGTH OF CODE BLOCK
              CALL LOAD
              EI            ;IF REQUIRED

              RET C         ;RETURN IF NO ERRORS

ERROR:        RST 0         ;YOUR ERROR ROUTINE (IF ANY) GOES HERE


;Mini Cassette LOAD

LOAD:         PUSH HL
              PUSH DE
	   PUSH DE
              LD A,10H      ;START MOTOR
              CALL MOTOR
              EXX 
              POP DE
              INC DE        ;EXTRA BYTE FOR CHECKSUM
              EXX 
              LD B,0F5H
              IN A,(C)
              LD C,A
LSHT:         LD E,20H
LSTA:         EQU LSHT
LCNT:         LD D,91
              LD A,0CH-3
              CALL LEDG2
              JR NC,LSHT
              LD A,145
              CP D
              JR NC,LSHT
              DEC E
              JR NZ,LCNT
LSYNC:        LD D,91
              CALL LEDG1
              JR NC,LSTA
              LD A,91+21
              CP D
              JR C,LSYNC
              CALL LEDG1
              JR NC,LSTA
              LD DE,0B801H
L8BIT:        LD A,0CH-3
L8BENT:       CALL LEDG2
              JR NC,ERR
              LD A,0D4H
              CP D
              RL E
              LD D,0B8H
              JR NC,L8BIT
              LD (HL),E
              INC HL
              LD E,1
              EXX 
              DEC DE
              LD A,D
              OR E
              EXX 
              LD A,09H-3
              JR NZ,L8BENT

ERR:	   POP DE
	   POP HL

;Check no errors in data

              CALL CHKSM2

              CP 1          ;CARRY SET IF CHECKSUM=0

LDEND:        EX AF,AF'

              XOR A         ;STOP MOTOR
              CALL MOTOR

              EX AF,AF'
              RET

LEDG2:        CALL LEDGE
              RET NC

LEDG1:        LD A,0EH-3
LEDGE:        DEC A
              JR NZ,LEDGE
LSAMP:        INC D
              RET Z
              LD B,0F5H
              IN A,(C)
              XOR C
              JP P,LSAMP
              LD B,7FH
              LD A,10H
              OUT (C),A
              LD A,C
              CPL 
              LD C,A
              RRA 

;2AH=Br.Blue/Black
;26H=Br.Red/Br.Magenta

              LD A,2AH
              RLA 
              OUT (C),A
              SCF 
              RET 

;Do CHECKSUM on data

CHKSM2:       XOR A
CSL2:         ADD (HL)
              INC HL
              DEC DE
              LD C,A
              LD A,D
              OR E
              LD A,C
              JR NZ,CSL2
              SUB (HL)
              RET 

MOTOR:        LD B,0F6H
              OUT (C),A
              LD BC,0
DEL:          DEC BC
              LD A,B
              OR C
              JR NZ,DEL
              RET 

	   END
