;MINI CASSETTE SAVE AND LOAD - AMSTRAD CPC
;COPYRIGHT 1989 SPEEDLOCK ASSOCIATES
;TEL: 0793 870525 OR 0734 470303

;**** MULTI-LOAD BLOCK SAVER ****

              ORG 1000H         ;CAN BE ANYWHERE (0040H-AA00H)

CASIO:        EQU 0BC77H
CASID:        EQU 0BC83H
CASIC:        EQU 0BC7AH
KTK:          EQU 0BB1EH
KIB:          EQU 0BCCEH
KLFC:         EQU 0BCD4H
KLFPC:        EQU 001BH
MCSTPR:       EQU 0BD16H
TXTOUT:       EQU 0BB5AH
              
STADDR:       EQU 0200H         ;START ADDRESS OF CODE BLOCK
LENGTH:       EQU 4000H         ;LENGTH OF CODE BLOCK
			   ;ALSO SET FILENAME AT END OF THIS FILE
MSTART:       LD C,7
              LD DE,0040H
              LD HL,0B0FFH
              CALL KIB
              LD HL,DISCM
              CALL KLFC
              XOR A
              CALL KLFPC

              LD HL,FNAME
              LD B,12
              LD DE,0C000H
              CALL CASIO
              LD HL,STADDR
              CALL CASID
              CALL CASIC

              LD HL,SPRMES
              CALL PRINT

LSPRES:       LD A,47       ;WAIT FOR SPACE BAR
              CALL KTK
              JR Z,LSPRES

              LD HL,STADDR
              LD DE,LENGTH
              CALL SAVE

              LD HL,ENDMES
              CALL PRINT

ENDLP:        JR ENDLP
              

SAVE:         LD A,10H
              CALL MOTOR
              DI 

;Mini Cassette SAVE

              PUSH HL
              PUSH DE
              CALL CHKSM2
              POP DE
              INC DE
              LD HL,0C00H
              LD A,30H
              LD B,A
SLEAD:        DJNZ SLEAD
              LD B,0F6H
              OUT (C),A
              XOR 20H
              LD B,0A4H
              DEC L
              JR NZ,SLEAD
              DEC B
              DEC H
              JP P,SLEAD
              LD B,2FH+5
SYNC1:        DJNZ SYNC1
              LD B,0F6H
              OUT (C),A
              LD A,10H
              LD B,37H
SYNC2:        DJNZ SYNC2
              LD B,0F6H
              OUT (C),A
              POP HL
              LD C,(HL)
              NOP           ;NOPS ARE ESSENTIAL FOR TIMING!!
              NOP 
              LD B,23H
              SCF 
              NOP 
              JR BITS8
SBIT2:        LD A,10H
              BIT 7,A
SBIT1:        DJNZ SBIT1
              JR NC,SOUT
              LD B,2BH
SSET:         DJNZ SSET
SOUT:         LD B,0F6H
              OUT (C),A
              LD B,26H
              JR NZ,SBIT2
              DEC B
              AND A
BITS8:        RL C
              LD A,30H
              JR NZ,SBIT1
              DEC DE
              INC HL
              LD B,1FH+1
              LD C,(HL)
              LD A,E
              OR D
              SCF 
              JR NZ,BITS8

MOTOR:        LD B,0F6H
              OUT (C),A
              LD BC,0
DEL:          DEC BC
              LD A,B
              OR C
              JR NZ,DEL
              EI 
              RET 

;Do CHECKSUM on data

CHKSM2:       XOR A
CSL2:         ADD (HL)
              INC HL
              DEC DE
              LD C,A
              LD A,D
              OR E
              LD A,C
              JR NZ,CSL2
              LD (HL),A
              RET 

PRINT:        LD A,(HL)
              OR A
              RET Z
              CALL TXTOUT
              INC HL
              JR PRINT

SPRMES:       DEFM "PRESS SPACE TO SAVE"
              DEFB 10,13,0
ENDMES:       DEFM "SAVE COMPLETED"
              DEFB 10,13,0
DISCM:        DEFM "DIS"
              DEFB "C"+80H

FNAME:        DEFM "LOAD1   .BIN"

              END

