;DISC LOAD - SPECTRUM +3 COPYRIGHT 1990 SPEEDLOCK ASSOCIATES
;Must only be used with the express permission of the authors
;Tel. 0734 470303 or 0793 870525 for further details + info

              ORG #8000     ;MUST BE IN UNCONTENDED RAM

;DISC ACCESS ROUTINES - READ MULTIPLE SECTORS

;Format disc to 9 sectors of size 512 bytes each (Standard AMSDOS Format)
;N.B. Loader always loads whole sectors - make sure load area is multiple of
;512 bytes.
;Please use inner part of disc (e.g. tracks 20-39) for multi-load data, as
;our protection system requires track 0 plus a number of tracks for loading
;screen and main part of program.

SECTORMASK:   EQU 00H       ;SET FOR DISC FORMAT (0xH FOR +3DOS)

STADDR:	   EQU #8000
LENGTH:	   EQU #2000
TRACK:	   EQU 20
FSECT:	   EQU 1

READ:         DI 
              LD BC,1FFDH
              LD A,12       ;DISC MOTOR ON
              OUT (C),A

              LD B,4
WAIT1:        LD HL,0
WAIT2:        DEC HL
              LD A,H
              OR L
              JR NZ,WAIT2
              DJNZ WAIT1

              LD HL,STADDR                ;START ADDRESS OF FILE
              LD DE,LENGTH                ;FILE LENGTH (BYTES)
              LD A,TRACK                  ;DISC TRACK NUMBER (0 TO 39)
              LD C,FSECT                  ;FIRST SECTOR NUMBER (1 TO 9)

              CALL FLOAD                  ;LOAD FILE FROM DISC

              LD BC,1FFDH
              LD A,4
              OUT (C),A                   ;DISC MOTOR OFF

              EI 
              RET C                       ;RETURN HERE IF NO ERRORS

ERROR:                                    ;YOUR ERROR ROUTINE HERE (IF REQD)
              RET 

;File Load Routine
;Entry: A=Start Track, C=Start Sector, HL=Load Address, DE=Length
;Exits: Carry Set=OK, NC=Error

FLOAD:        LD      B,D             ;hi-byte of length in B
              LD      D,A             ;get start track in D

              SRL     B               ;200h bytes per sector
              JR      C,FLDJ0         ;add sector if D is odd
              LD      A,E             ;if D is even, check E
              OR      A
              JR      Z,FLDJ1         ;if E = 0, don't add sector
FLDJ0:        INC     B

FLDJ1:        LD      E,C             ;get start sector

FLDJ2:        LD      A,9+1           ;9 sectors per track
              SUB     E
              CP      B
              JR      C,FLDJ3         ;if more than one track

;Here if less than 1 track, or for last part of file

              LD      A,E             ;start sector
              ADD     B               ;+ length
              DEC     A               ;-1
              LD      C,A             ;set end sector
              JP      RDTRAK          ;and read 1 part of track

;Here if whole track, or more than one track

FLDJ3:        LD      C,A             ;sectors to load
              PUSH    BC
              PUSH    HL
              PUSH    DE
              LD      C,9             ;set end sector for full track
              CALL    RDTRAK          ;read from 1st sector to end
              POP     DE
              POP     HL
              POP     BC
              RET     NC              ;return if disc error
              LD      A,B             ;total sectors for file
              SUB     C
              LD      B,A             ;sectors remaining to load
              LD      A,H
              ADD     C
              ADD     C               ;set load address for next part
              LD      H,A
              LD      E,1             ;back to sector 1 for next track
              INC     D               ;next track
              JR      FLDJ2

RDTRAK:       LD A,D
              LD (SEEK+3),A
              LD (DSCDAT+3),A
              LD (LDADDR+1),HL
              LD A,E
              OR SECTORMASK
              LD (DSCDAT+5),A
              LD A,C
              OR SECTORMASK
              LD (DSCDAT+7),A

DISCJ1:       LD DE,READID
              CALL OUTSQ1
              LD A,(RESULT)
              OR A
              JR NZ,DISCJ1

              LD DE,SEEK
              CALL DIS1

              LD DE,DSCDAT
LDADDR:       LD HL,0
              JP OUTSQ2

DIS1:         CALL OUTSQ0
DS1L:         LD DE,SENSE
              CALL OUTSQ1
              LD HL,RESULT
              BIT 5,(HL)
              JR Z,DS1L
              RET 

OUTSQ0:       LD BC,RDATL5
              JR OUTSQ
OUTSQ1:       LD BC,RDATL3
              LD HL,RESULT
              JR OUTSQ

OUTSQ2:       LD BC,DATL2
OUTSQ:        LD (OSQJ+1),BC
              LD A,(DE)
              LD B,A
              INC DE
OSEQL2:       PUSH BC
              LD A,(DE)
              INC DE
              CALL OUTDAT
              POP BC
              DJNZ OSEQL2
              LD BC,2FFDH
              LD DE,2010H
OSQJ:         JP DATL2

DATL1:        LD B,3FH
DISCM:        INI 
              LD B,2FH
DATL2:        IN A,(C)
              JP P,DATL2
              AND D
              JR NZ,DATL1

              LD HL,RESULT
RDATL3:       IN A,(C)
              CP 0C0H
              JR C,RDATL3
              LD B,3FH
              INI 
              LD B,2FH
              LD A,5
RDATL4:       DEC A
              JR NZ,RDATL4
              IN A,(C)
              AND E
              JR NZ,RDATL3
              LD A,(RESULT+1)
              AND 24H
              RET NZ
              SCF 
              RET 

RDATL5:       IN A,(C)
              JP P,RDATL5
              RET 

;OUTPUT DATA

OUTDAT:       LD BC,2FFDH
              PUSH AF
OUTDJ1:       IN A,(C)
              ADD A
              JR NC,OUTDJ1
              ADD A
              JR NC,OUTDJ2
              POP AF
              RET 
OUTDJ2:       POP AF
              LD B,3FH
              OUT (C),A
              LD B,2FH
              LD A,5
OUTDJ3:       DEC A
              NOP 
              JR NZ,OUTDJ3
              RET 

;FDC COMMAND OPCODES AND DATA

SEEK:         DEFB 3,0FH,0,0
SENSE:        DEFB 1,8
READID:       DEFB 2,4AH,0
DSCDAT:       DEFB 9,46H,0,0,0,41H,2,49H,2AH,0FFH

RESULT:       DEFS 8        ;BUFFER FOR FDC RESULTS DATA

	   END

