;Spectrum Fast LOAD &  SAVE routines for use within games.
;Copyright 1989 Speedlock Associates
;Written by David Aubrey Jones
;Must not be used without permission from Speedlock Associates
;Tel.0734 470303 / 0793 870525

              ORG 8000H	;MUST BE IN UNCONTENDED RAM

;Example of use
;-saving and loading a screen

TSAVE:        LD IX,4000H
              LD DE,1B00H
	   LD A,0FFH
              CALL SAVE
              RET 

TLOAD:        LD IX,4000H
              LD DE,1B00H
	   LD A,0FFH
              CALL LOAD
	   RET C

;ERROR ROUTINE

              RET 

;SAVE ROUTINES

SAVE:         LD HL,BACK
              PUSH HL
              LD HL,0C98H
SFLAG:        EX AF,AF'
              INC DE
              DEC IX
              DI 
              LD A,2
              LD B,A
SLEAD:        DJNZ SLEAD
              OUT (0FEH),A
              XOR 0FH
              LD B,0A4H
              DEC L
              JR NZ,SLEAD
              DEC B
              DEC H
              JP P,SLEAD
              LD B,2FH
SYNC1:        DJNZ SYNC1
              OUT (0FEH),A
              LD A,0DH
              LD B,37H
SYNC2:        DJNZ SYNC2
              OUT (0FEH),A
              LD BC,3B0EH
              EX AF,AF'
              LD L,A
              JP SST
SLOOP:        LD A,D
              OR E
              JR Z,SPAR
              LD L,(IX+0)
SLPP:         LD A,H
              XOR L
SST:          LD H,A
              LD A,1
              SCF 
              JP S8BIT
SPAR:         LD L,H
              JR SLPP
SBIT2:        LD A,C
              BIT 7,B
SBIT1:        DJNZ SBIT1
              JR NC,SOUT
              LD B,2EH
SSET:         DJNZ SSET
SOUT:         OUT (0FEH),A
              LD B,2AH
              JR NZ,SBIT2
              DEC B
              XOR A
              INC A
S8BIT:        RL L
              JP NZ,SBIT1
              DEC DE
              INC IX
              LD B,1DH
              LD A,7FH
              IN A,(0FEH)
              RRA 
              RET NC
              LD A,D
              INC A
              JP NZ,SLOOP
              LD B,3BH
SDEL:         DJNZ SDEL
              RET 

BACK:         PUSH AF

;Black Border at END

              XOR A
              OUT (0FEH),A
              EI 
              POP AF
              RET C

ERR:          RST 8
              DEFB 1AH



;LOAD ROUTINES

LOAD:         DI 
              OR A
              SCF 
              EX AF,AF'
              LD A,2
              LD (BOR+1),A
              LD A,0FH
              OUT (0FEH),A
              LD HL,BACK
              PUSH HL
              IN A,(0FEH)
              RRA 
              AND 20H
              LD C,A
LSTART:       LD H,0
LLEAD:        LD B,90H
              CALL LEDG2
              JR NC,LSTART
              LD A,0BFH
              CP B
              JR NC,LSTART
              INC H
              JR NZ,LLEAD
LSYNC:        LD B,0C3H
              CALL LEDG1
              JR NC,LSTART
              LD A,B
              CP 0D4H
              JR NC,LSYNC
              CALL LEDG1
              RET NC
              LD A,1
              LD (BOR+1),A
              LD H,0
              LD B,0C0H
              JR LMARK
LLOOP:        EX AF,AF'
              JR NZ,LFLG
              JR NC,LVER
              LD (IX+0),L
              JR LNEXT
LFLG:         RL C
              XOR L
              RET NZ
              LD A,C
              RRA 
              LD C,A
              INC DE
              JR LDEC
LVER:         LD A,(IX+0)
              XOR L
              RET NZ
LNEXT:        INC IX
LDEC:         DEC DE
              EX AF,AF'
              LD B,0C2H
LMARK:        LD L,1
L8B:          CALL LEDG2
              RET NC
              LD A,0DBH
              CP B
              RL L
              LD B,0C0H
              JP NC,L8B
              LD A,H
              XOR L
              LD H,A
              LD A,D
              OR E
              JR NZ,LLOOP
              LD A,H
              CP 1
              RET 

LEDG2:        CALL LEDG1
              RET NC
LEDG1:        AND A
LSAMP:        INC B
              RET Z
              LD A,7FH
              IN A,(0FEH)
              RRA 
              RET NC
              XOR C
              AND 20H
              JR Z,LSAMP
              LD A,C
              CPL 
              LD C,A
BOR:          AND 2
              OR 8
              OUT (0FEH),A
              SCF 
              RET 

	   END

