/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __AIFF_HEADER_INCLUDED__
#define __AIFF_HEADER_INCLUDED__

#include "sample.h"
#include "chunk.h"

extern SampleHandler AIFF_SampleHandler;

#define CHUNK_ID_FORM CHUNK_ID('F','O','R','M')
#define CHUNK_ID_COMM CHUNK_ID('C','O','M','M')
#define CHUNK_ID_SSND CHUNK_ID('S','S','N','D')


int AIFF_Open(const char *pFilename, SampleDescription *desc);
void AIFF_Close(SampleDescription *);
unsigned char AIFF_ReadSample(SampleDescription *desc);
unsigned long AIFF_IsEOF(SampleDescription *desc);

#ifdef _WIN32
#pragma pack(1)
#endif

struct extended
{
	unsigned char encoded_floating_point_number[10];
};

typedef struct COMM_CHUNK
{
	unsigned short NumberOfChannels;
	unsigned long LengthInSamples;
	unsigned short BitsPerSample;
	struct extended SampleRate;
} COMM_CHUNK;

#ifdef _WIN32
#pragma pack()
#endif

#endif