/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BUFFERED_FILE_HEADER_INCLUDED__
#define __BUFFERED_FILE_HEADER_INCLUDED__

#include <stdio.h>
#include <stdlib.h>

typedef struct
{
	/* pointer to buffer */
	unsigned char *pBuffer;
	/* offset in bytes within buffer to read data out of */
	size_t ReadPosition;
	/* length of data used */
	size_t LengthUsed;
	/* length of buffer in bytes */
	size_t Capacity;
	/* file handle */
	FILE *fh;
} BufferedFile;

void	BufferedFile_Init(BufferedFile *, size_t BufferLength);
void	BufferedFile_Free(BufferedFile *);
size_t BufferedFile_ReadData(BufferedFile *, void *pBuffer, size_t Length);
void BufferedFile_Seek(BufferedFile *pBufferedFile, size_t Offset, size_t Relative);
size_t BufferedFile_GetPos(BufferedFile *);
int		BufferedFile_Open(BufferedFile *, const char *);
#endif