/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __CHUNK_HEADER_INCLUDED__
#define __CHUNK_HEADER_INCLUDED__


#include <stdio.h>
#include <stdlib.h>
#include "endian.h"
#include "bufffile.h"

#ifdef _WINDOWS
#pragma pack(1)
#endif

#define CHUNK_ID(a,b,c,d) \
	(((a&0x0ff)<<24)|((b&0x0ff)<<16)|((c&0x0ff)<<8)|(d&0x0ff))

typedef struct CHUNK_HEADER
{
	unsigned long ID;
	unsigned long Length;
} CHUNK_HEADER;

typedef struct CHUNK_READ_DATA
{
	CHUNK_HEADER Header;
	unsigned long ReadOffset;
} CHUNK_READ_DATA;


#define CHUNK_MAX_STACK_ITEMS 8

typedef struct CHUNK_FILE_READ
{
	/* chunk's pushed onto stack */
	CHUNK_READ_DATA Stack[CHUNK_MAX_STACK_ITEMS];
	unsigned long NumStackItems;

	/* current header that is active */
	CHUNK_READ_DATA Current;

//	FILE *fh;
	BufferedFile bufferedFile;

	int Endianness;
} CHUNK_FILE_READ;

/* close chunk file */
void ChunkFile_Close(CHUNK_FILE_READ *pChunkFileRead);
/* open chunk file */
int ChunkFile_Open(CHUNK_FILE_READ *pChunkFileRead, const char *pFilename);
/* set the endianness that the chunk file was created with; this determines the endianness of the chunk length
in the chunk header */
void ChunkFile_SetEndianness(CHUNK_FILE_READ *pChunkFileRead, const int Endianness);
/* get the id of the parent chunk */
const unsigned long ChunkFile_GetParentChunkID(CHUNK_FILE_READ *pChunkFileRead);
/* get the length of the parent chunk */
const unsigned long ChunkFile_GetParentChunkLength(CHUNK_FILE_READ *pChunkFileRead);
/* get pointer to parent chunk */
CHUNK_READ_DATA *ChunkFile_GetParentChunk(CHUNK_FILE_READ *pChunkFileRead);

/* get length from a chunk length that was written big endian style */
const unsigned long Chunk_GetLengthLittleEndian(CHUNK_HEADER *pHeader);
/* get length from a chunk length that was written little endian style */
const unsigned long Chunk_GetLengthBigEndian(CHUNK_HEADER *pHeader);
/* get ID of chunk */
const unsigned long Chunk_GetID(CHUNK_HEADER *pHeader);

/* open the current chunk to read the data from it */
void	ChunkFile_OpenChunk(CHUNK_FILE_READ *pChunkFileRead);
/* close the current chunk to read the data from it */
void	ChunkFile_CloseChunk(CHUNK_FILE_READ *pChunkFileRead);

/* read data from the current chunk */
const unsigned long ChunkFile_ReadData(CHUNK_FILE_READ *pChunkFileRead, unsigned char *pBuffer, const unsigned long Length);

void ChunkFileRead_Start(CHUNK_FILE_READ *pChunkFileRead, CHUNK_HEADER *pParent, FILE *fh);

int ChunkFile_FindChunk(CHUNK_FILE_READ *pChunkFileRead, unsigned long ChunkID);
/* skip the current chunk */
void ChunkFile_SkipChunk(CHUNK_FILE_READ *pChunkFileRead);


#ifdef _WINDOWS
#pragma pack()
#endif

#endif