/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __CSW_HEADER_INCLUDED__
#define __CSW_HEADER_INCLUDED__

#include "sample.h"

extern SampleHandler CSW_SampleHandler;


/* identification */
#define CSW_IDENT "Compressed Square Wave\x01a"

#define CSW_COMPRESSION_RLE 0x01

#define CSW_POLARITY_MASK (1<<0)


typedef struct CSW_FILE_HEADER
{
	/* identification string */
 	unsigned char Ident[0x017];
	/* version */
	unsigned char MajorFormatRevision;
	unsigned char MinorFormatRevision;
	/* sample rate */
	unsigned char SampleRateHzL;
	unsigned char SampleRateHzH;
	/* compression type */
	unsigned char CompressionType;
	/* flags */
	unsigned char Flags;
	/* reserved */
	unsigned char Reserved[3];
} CSW_FILE_HEADER;

/* compression information:

  byte-code

  if byte-code!=0, then byte-code defines number of samples that wave is at current level,
  if byte-code==0, then read 4-bytes (little endian format) which defines the number of samples that wave is at
  current level.

*/

int CSW_Open(const char *pFilename, SampleDescription *desc);
void CSW_Close(SampleDescription *);
unsigned char CSW_ReadSample(SampleDescription *);
unsigned long CSW_IsEOF(SampleDescription *desc);

#endif