/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __ENDIAN_HEADER_INCLUDED__
#define __ENDIAN_HEADER_INCLUDED__

enum
{
	ENDIANNESS_LITTLE_ENDIAN = 0,
	ENDIANNESS_BIG_ENDIAN
};

#define SwapEndianWord(a) \
	(((a&0x0ff)<<8)|((a>>8)&0x0ff))

#define SwapEndianLong(a) \
	(((a&0x0ff)<<24)|(((a>>8)&0x0ff)<<16)|(((a>>16)&0x0ff)<<8)|(((a>>24)&0x0ff)<<0))

#endif
