/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "iff.h"

SampleHandler IFF_SampleHandler=
{
	"IFF 8SVX Audio Sound File (IFF)",
	IFF_Open,
	IFF_Close,
	IFF_ReadSample,
	IFF_IsEOF,
};


static	CHUNK_FILE_READ ChunkFileRead;
static unsigned long EndOfFile;

int IFF_Open(const char *pFilename,SampleDescription *desc)
{
	int Status = SAMPLE_FILE_NOT_RECOGNISED;
	int bGotFormat = 0;
	unsigned long BitsPerSample;
	unsigned long NumChannels;

//	*ppBuffer = NULL;
//	*pLength = 0;

	if (ChunkFile_Open(&ChunkFileRead, pFilename))
	{
		/* FORM chunk? */
		if (ChunkFile_GetParentChunkID(&ChunkFileRead)== CHUNK_ID_FORM)
		{
			unsigned char Type[4];

			/* big endian */
			ChunkFile_SetEndianness(&ChunkFileRead, ENDIANNESS_BIG_ENDIAN);
		
			if (ChunkFile_ReadData(&ChunkFileRead, &Type[0], 4)==4)
			{
				if (
					(Type[0]=='8') ||
					(Type[1]=='S') ||
					(Type[2]=='V') ||
					(Type[3]=='X')
					)
				{
					if (ChunkFile_FindChunk(&ChunkFileRead, CHUNK_ID_VHDR))
					{
						unsigned long ChunkLength;

						ChunkFile_OpenChunk(&ChunkFileRead);

						ChunkLength = ChunkFile_GetParentChunkLength(&ChunkFileRead);

						{
							VHDR_CHUNK Vhdr;

							if (ChunkFile_ReadData(&ChunkFileRead, (unsigned char *)&Vhdr,sizeof(VHDR_CHUNK))==sizeof(VHDR_CHUNK))
							{
#ifdef LSB_FIRST
								desc->Rate = SwapEndianWord(Vhdr.Frequency);
#else
								desc->Rate = Vhdr.Frequency;
#endif
								BitsPerSample = 8;

#ifdef LSB_FIRST
								NumChannels = SwapEndianWord(Vhdr.NumChannels);
#else
								NumChannels = Vhdr.NumChannels;
#endif
								bGotFormat = 1;

								if (NumChannels==1)
								{
									desc->Format = SAMPLE_FORMAT_8MS;
								}
								else
								{
									desc->Format = SAMPLE_FORMAT_8SS;
								}
							}
						}

						ChunkFile_CloseChunk(&ChunkFileRead);
					}

					if (bGotFormat)
					{
						if (ChunkFile_FindChunk(&ChunkFileRead, CHUNK_ID_BODY))
						{
							//							unsigned char *pBuffer;
							unsigned long ChunkLength;
							
							ChunkFile_OpenChunk(&ChunkFileRead);
							
							ChunkLength = ChunkFile_GetParentChunkLength(&ChunkFileRead);

							desc->LengthInSamples = (ChunkLength<<3)/(BitsPerSample*NumChannels);

							SampleDescription_InitDuration(desc);

							EndOfFile = 0;

							if (desc->LengthInSamples==0)
							{
								Status = SAMPLE_FILE_NO_DATA;
							}
							else
							{
								Status = SAMPLE_FILE_OK;
							}
						}
					}
				}
			}
		}

		if (Status!=SAMPLE_FILE_OK)
		{
			ChunkFile_Close(&ChunkFileRead);
		}
	}

	return Status;
}

void IFF_Close(SampleDescription *desc)
{
	ChunkFile_Close(&ChunkFileRead);

}

unsigned long IFF_IsEOF(SampleDescription *desc)
{
	return EndOfFile;
}


unsigned char IFF_ReadSample(SampleDescription *desc)
{
	unsigned char Data[8];
	unsigned long BytesPerSample = GetBytesPerSample(desc);

	if (ChunkFile_ReadData(&ChunkFileRead, Data, GetBytesPerSample(desc))!=BytesPerSample)
	{
		EndOfFile = 1;
		return 0x080;
	}

	return ConvertData(Data, desc->Format);
}
