/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __AMIGA_IFF_HEADER_INCLUDED__
#define __AMIGA_IFF_HEADER_INCLUDED__

#include "sample.h"
#include "chunk.h"


extern SampleHandler IFF_SampleHandler;


#ifdef _WINDOWS
#pragma pack(1)
#endif

#define CHUNK_ID_FORM CHUNK_ID('F','O','R','M')
#define CHUNK_ID_VHDR CHUNK_ID('V','H','D','R')
#define CHUNK_ID_BODY CHUNK_ID('B','O','D','Y')

typedef struct VHDR_CHUNK
{
	unsigned long DataLength;	/* length of data in bytes */
	unsigned long pad[2];
	unsigned short Frequency;
	unsigned short pad1[1];		/* unknown; is 0x0100 in hex */
	unsigned short NumChannels;
	unsigned short pad2[1];
} VHDR_CHUNK;


int IFF_Open(const char *pFilename, SampleDescription *desc);
void IFF_Close(SampleDescription *);
unsigned char IFF_ReadSample(SampleDescription *);
unsigned long IFF_IsEOF(SampleDescription *desc);


#ifdef _WINDOWS
#pragma pack()
#endif

#endif